/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.control.eums.ControlTypeEnum;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.AbstractControlImpl;
import kd.epm.eb.control.impl.calc.CalcBalance;
import kd.epm.eb.control.impl.calc.ReopenCalc;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.utils.BgControlParamUtils;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgControlRuleUtils;
import kd.epm.eb.control.utils.BgControlUtils;

public class ReopenBudgetImpl
extends AbstractControlImpl {
    private static final Log log = LogFactory.getLog(ReopenBudgetImpl.class);
    private LogStats stats;

    public ReopenBudgetImpl(IControlParameter parameter) {
        super(parameter);
    }

    public void reopenBudget() {
        this.stats = new LogStats("budget-control-log : ");
        this.stats.addInfo("begin-reopenBudget.");
        this.stats.addInfo(this.getParameter().getEntityNumber());
        this.stats.addInfo(this.getParameter().getBizId());
        this.stats.addInfo(this.getParameter().getEntryId());
        if (this.getParameter() == null) {
            ControlException.errorControlParameter();
        }
        HashSet<String> bizIds = new HashSet<String>();
        bizIds.add(this.getParameter().getBizId());
        List<BgControlRecord> records = BgControlRecordUtils.query(bizIds);
        Set<BgControlRecord> closedRecords = records.stream().filter(k -> BgControlRecord.OccupationType.CLSOCC.getNumber().equals(k.getOccType())).collect(Collectors.toSet());
        if (closedRecords.isEmpty()) {
            return;
        }
        if (StringUtils.isNotEmpty((String)this.getParameter().getEntryId())) {
            closedRecords = closedRecords.stream().filter(k -> StringUtils.isNotEmpty((String)k.getRefEntryId()) && this.getParameter().getEntryIdArr().contains(k.getRefEntryId())).collect(Collectors.toSet());
        }
        Date createTime = new Date();
        Map<Object, Object> bizModelMap = Maps.newHashMapWithExpectedSize((int)closedRecords.size());
        ArrayList<BgControlRecord> reopenRecords = new ArrayList<BgControlRecord>(closedRecords.size());
        for (BgControlRecord record : closedRecords) {
            if (!bizModelMap.containsKey(record.getBizModel().getId())) {
                bizModelMap.put(record.getBizModel().getId(), record.getBizModel());
            }
            BgControlRecord newRecord = BgControlRecord.createFromControlParam(record, createTime, this.getParameter().getOperation());
            newRecord.setOccType(BgControlRecord.OccupationType.REPOCC.getNumber());
            newRecord.setAmount(record.getAmount().negate());
            reopenRecords.add(newRecord);
        }
        List<IControlParam> controlParams = BgControlRecord.createControlParam(this.getParameter(), reopenRecords);
        if (controlParams == null || controlParams.isEmpty()) {
            return;
        }
        controlParams.forEach(f -> f.setControlType(ControlTypeEnum.OCCUPATION));
        bizModelMap = BgControlUtils.buildBizModelMap(controlParams);
        BgControlData controlData = new BgControlData(true, null, null, this.stats);
        controlData.setBizModels((Map<Long, BizModel>)bizModelMap);
        Map<Long, List<IControlParam>> paramMap = BgControlUtils.buildParamMap(controlParams);
        for (List<IControlParam> _param : paramMap.values()) {
            BgControlParamUtils.get().setParameter(this.getParameter()).fillMembers(controlData, _param);
        }
        BgControlRuleUtils.getInterface().queryControlRule(controlData, controlParams);
        CalcBalance calcbalance = new CalcBalance(this.getParameter(), controlData, null);
        calcbalance.getControlParams().addAll(controlParams);
        calcbalance.builderMembersForReturn((Map<Long, BizModel>)bizModelMap, controlParams);
        ReopenCalc reopenCalc = new ReopenCalc(calcbalance, reopenRecords, closedRecords, (Map<Long, BizModel>)bizModelMap);
        reopenCalc.setParameter(this.getParameter());
        reopenCalc.setStats(this.stats);
        if (!bizModelMap.isEmpty() && !reopenRecords.isEmpty()) {
            this.lock(reopenCalc);
        } else {
            this.stats.addInfo("no-reopenBudget-reopenRecords.size=" + reopenRecords.size());
        }
        this.checkResult(this.getParameter());
        this.stats.addInfo("end-reopenBudget.");
        log.info(this.stats.toString());
    }
}

