/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.BizOrgUnit;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.eums.ControlLogTypeEnum;
import kd.epm.eb.control.eums.ControlResultEnum;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.face.IControlResult;
import kd.epm.eb.control.impl.AbstractControlImpl;
import kd.epm.eb.control.impl.calc.CalcControl;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlProcessUtils;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgRegisterUtils;

public class RequestBudgetImpl
extends AbstractControlImpl {
    private static final Log log = LogFactory.getLog(RequestBudgetImpl.class);

    public RequestBudgetImpl(IControlParameter parameter) {
        super(parameter);
    }

    public IControlResult requestBudget() {
        this.getStats().addInfo("begin requestBudget.");
        this.getStats().setLogs(null);
        this.getStats().setControllogs(null);
        boolean isBeforeException = true;
        try {
            String seqfilter;
            String operName;
            String oper;
            String controltype;
            IControlParameter parameter = this.getParameter();
            if (parameter == null) {
                ControlException.errorControlParameter();
                IControlResult iControlResult = null;
                return iControlResult;
            }
            if (parameter.getCalcParameter() == null || !parameter.getCalcParameter().check()) {
                ControlException.errorControlParameter();
                IControlResult iControlResult = null;
                return iControlResult;
            }
            if (!this.specialCheck(parameter.getEntityNumber(), parameter.getBizObj())) {
                parameter.getResult().setResult(ControlResultEnum.DONTCONTROL);
                this.getParameter().getResult().setCode("dont-control-fm");
                IControlResult iControlResult = this.getParameter().getResult();
                return iControlResult;
            }
            String[] props = BgRegisterUtils.queryRegisterBizUnit(this.getParameter().getEntityNumber());
            parameter.getControlManager().setOccAgain(BgRegisterUtils.isOccAgain(props));
            parameter.getControlManager().setDeductByEntry(BgRegisterUtils.isDeductByEntry(props));
            BgRegisterUtils.checkHasDefaultSet(parameter, props, this.getStats());
            Object[] objProps = BgRegisterUtils.getBizUnit(this.getStats(), this.getParameter(), props);
            BgRegisterUtils.checkDefaultProps(this.getStats(), objProps, props);
            BizOrgUnit bizOrgUnit = (BizOrgUnit)objProps[0];
            Date bizTime = (Date)objProps[1];
            BgControlData controlData = new BgControlData(BgRegisterUtils.isMultiControl(props), bizOrgUnit, bizTime, this.getStats());
            if (!this.isControl(this.getManagerParam(bizOrgUnit))) {
                BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLPROCESSADD, 0, null, ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u542f\u7528\u7684\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u3002", (String)"ControlLog_NoProcessScheme", (String)"epm-eb-business", (Object[])new Object[0]), null, false);
                BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLRESULT, 0, null, ResManager.loadKDString((String)"\u4e0d\u63a7\u5236", (String)"ControlLog_DontControl", (String)"epm-eb-business", (Object[])new Object[0]), null, false);
                this.getParameter().getResult().setResult(ControlResultEnum.DONTCONTROL);
                this.getParameter().getResult().setCode("dont-control-process-scheme");
                IControlResult iControlResult = this.getParameter().getResult();
                return iControlResult;
            }
            if (this.isShowBeyondMessage(this.getManagerParam(bizOrgUnit))) {
                this.getParameter().getResult().setShowBeyondMessage(true);
            }
            BgControlProcessUtils.queryProcessSet(this.getParameter(), controlData, this.getParentOrgIds(controlData), this.getStats());
            if (controlData.getProcess() == null || controlData.getProcess().isEmpty()) {
                this.getStats().addInfo("not suit control processes");
                BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLPROCESSADD, 0, null, ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u542f\u7528\u7684\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u3002", (String)"ControlLog_NoProcessScheme", (String)"epm-eb-business", (Object[])new Object[0]), null, false);
                BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLRESULT, 0, null, ResManager.loadKDString((String)"\u4e0d\u63a7\u5236", (String)"ControlLog_DontControl", (String)"epm-eb-business", (Object[])new Object[0]), null, false);
                this.getParameter().getResult().setResult(ControlResultEnum.DONTCONTROL);
                this.getParameter().getResult().setCode("dont-control-process-scheme");
                IControlResult iControlResult = this.getParameter().getResult();
                return iControlResult;
            }
            parameter.setCheckIdempotent(true);
            if (parameter.getControlManager().canOccAgain().booleanValue() && parameter.getControlManager().isExecute()) {
                parameter.setCheckIdempotent(false);
            }
            if (BgControlRecordUtils.checkIdempotent(this.getParameter(), this.getStats())) {
                BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLRESULT, 0, null, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u6709\u6267\u884c\u6216\u76f8\u540c\u64cd\u4f5c\u7684\u5360\u7528\u8bb0\u5f55\u3002", (String)"ControlLog_CheckIdempotent", (String)"epm-eb-business", (Object[])new Object[0]), null, false);
                this.getParameter().getResult().setCode("success-check-idempotent");
                IControlResult iControlResult = this.getParameter().getResult();
                return iControlResult;
            }
            if (!this.getParameter().getControlManager().isExecute() && !this.getParameter().getControlManager().isOccupation()) {
                this.getStats().addInfo("not control value prop!" + this.getParameter().getBizId());
                BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLPROCESSADD, 0, null, ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u542f\u7528\u7684\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u3002", (String)"ControlLog_NoProcessScheme", (String)"epm-eb-business", (Object[])new Object[0]), null, false);
                BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLRESULT, 0, null, ResManager.loadKDString((String)"\u4e0d\u63a7\u5236", (String)"ControlLog_DontControl", (String)"epm-eb-business", (Object[])new Object[0]), null, false);
                this.getParameter().getResult().setResult(ControlResultEnum.DONTCONTROL);
                this.getParameter().getResult().setCode("dont-control-process-scheme");
                IControlResult iControlResult = this.getParameter().getResult();
                return iControlResult;
            }
            if (this.getParameter().getControlManager().isExecute()) {
                if (this.getParameter().getControlManager().isNegativeOcc()) {
                    ControlException.errNegativeExecute();
                    IControlResult iControlResult = this.getParameter().getResult();
                    return iControlResult;
                }
                controltype = BillFieldTypeEmum.RUNOPERATION.getName();
                oper = (String)controlData.getProcess().get("controlprocess.entryentity.runoperation");
                operName = BgControlLogUtils.getBizRegName(this.getParameter().getEntityNumber(), oper, BillFieldTypeEmum.RUNOPERATION.getNumber());
                BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLPROCESSEXECUTE, 0, null, ResManager.loadResFormat((String)"%1\u65f6\u673a\uff1a%2", (String)"ControlLog_ProcessAdd1", (String)"epm-eb-business", (Object[])new Object[]{controltype, oper, operName}), null, false);
            } else {
                controltype = BillFieldTypeEmum.TAKEOPERATION.getName();
                oper = (String)controlData.getProcess().get("controlprocess.entryentity.takeoperation");
                operName = BgControlLogUtils.getBizRegName(this.getParameter().getEntityNumber(), oper, BillFieldTypeEmum.TAKEOPERATION.getNumber());
                BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLPROCESSOCC, 0, null, ResManager.loadResFormat((String)"%1\u65f6\u673a\uff1a%2 - %3", (String)"ControlLog_ProcessAdd", (String)"epm-eb-business", (Object[])new Object[]{controltype, oper, operName}), null, false);
            }
            String procCondition = ResManager.loadKDString((String)"\u7a7a", (String)"ControlLog_Null", (String)"epm-eb-business", (Object[])new Object[0]);
            if (StringUtils.isNotEmpty((String)((String)controlData.getProcess().get("controlprocess.entryentity.condition")))) {
                procCondition = (String)controlData.getProcess().get("controlprocess.entryentity.condition");
            }
            if (StringUtils.isNotEmpty((String)(seqfilter = (String)controlData.getProcess().get("controlprocess.entryentity.serqfilter"))) && seqfilter.startsWith("{")) {
                try {
                    FlexBDValueCondition fc = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)seqfilter, FlexBDValueCondition.class);
                    procCondition = fc.getDescription().getLocaleValue();
                }
                catch (Throwable fc) {
                    // empty catch block
                }
            }
            BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLPROCESSCONDITION, 0, null, procCondition, null, false);
            BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLPROCESSRANGE, 0, null, ResManager.loadResFormat((String)"\u4e1a\u52a1\u5355\u5143\uff1a%1 - %2", (String)"ControlLog_ProcessOrg", (String)"epm-eb-business", (Object[])new Object[]{controlData.getProcess().get("org.number"), controlData.getProcess().get("org.name")}), null, false);
            Collection<BizModel> models = this.getParameter().getBizUtils().queryModel(bizTime, true);
            models = this.getParameter().getBizUtils().filterModel(models, controlData);
            if (models != null && !models.isEmpty()) {
                controlData.setBizModels(models);
                if (StringUtils.isEmpty((String)this.getParameter().getDataManager().getUpstreamId())) {
                    if (this.getParameter().getDataManager().getSourceBizUnit() == null) {
                        Map<String, HashSet<Long>> sourceBills = this.getSourceBillsV2(models, this.getParameter(), controlData.getStats());
                        if (sourceBills != null && !sourceBills.isEmpty()) {
                            this.getParameter().getDataManager().setSourceBizUnit(sourceBills);
                        } else {
                            this.getStats().addInfo("not find source bizId.");
                        }
                    }
                    this.checkSource();
                } else {
                    this.getStats().addInfo("has upstreamId. upstreamId = " + this.getParameter().getDataManager().getUpstreamId());
                }
                this.getStats().add("begin-CalcControl");
                CalcControl calc = CalcControl.getInterface(controlData);
                calc.setParameter(this.getParameter());
                calc.setModels(models);
                this.lock(calc);
            } else {
                this.getStats().addInfo("not control model!" + this.getParameter().getBizId());
                this.getParameter().getResult().setCode("success-no-model");
                this.getParameter().getResult().setResult(ControlResultEnum.PASS);
            }
            isBeforeException = false;
            this.checkResult(this.getParameter());
        }
        catch (KDBizException e) {
            if (isBeforeException) {
                BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLRESULT, 2, null, e.getMessage(), null, false);
            }
            throw e;
        }
        finally {
            this.getStats().addInfo("end requestBudget.");
            log.info(this.getStats().toString());
            BgControlLogUtils.finishInfo(this.getStats(), log);
            BgControlLogUtils.saveDetailLog(this.getParameter().getGlobalId(), this.getStats(), log);
        }
        return this.getParameter().getResult();
    }

    protected boolean specialCheck(String entityNumber, DynamicObject bill) {
        DynamicObjectCollection entry;
        Object obj;
        if (StringUtils.isEmpty((String)entityNumber) || bill == null) {
            return true;
        }
        if ("pmas_pro_approval".equals(entityNumber)) {
            DynamicObjectCollection entry2;
            Object obj2 = bill.get("fundsourceentry");
            if (obj2 instanceof DynamicObjectCollection && (entry2 = (DynamicObjectCollection)obj2).isEmpty()) {
                this.getStats().addInfo(entityNumber + " fundsourceentry is null. is not control.");
                return false;
            }
        } else if ("pmas_projfundsource".equals(entityNumber) && (obj = bill.get("fundentry")) instanceof DynamicObjectCollection && (entry = (DynamicObjectCollection)obj).isEmpty()) {
            this.getStats().addInfo(entityNumber + " fundentry is null. is not control.");
            return false;
        }
        return true;
    }

    @Override
    protected void checkResult(IControlParameter parameter) {
        super.checkResult(parameter);
    }
}

