/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.ControlMessageTypeEnum;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.eums.ControlLogTypeEnum;
import kd.epm.eb.control.eums.ControlResultEnum;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.face.IResultCause;
import kd.epm.eb.control.impl.AbstractControlImpl;
import kd.epm.eb.control.impl.calc.ReturnCalc;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.BgRegisterUtils;

public class ReturnBudgetImpl
extends AbstractControlImpl {
    private static final Log log = LogFactory.getLog(ReturnBudgetImpl.class);

    public ReturnBudgetImpl(IControlParameter parameter) {
        super(parameter);
    }

    public void returnBudget() throws KDBizException {
        Set<String> tables;
        LogStats stats = new LogStats("budget-control-log : ");
        stats.addInfo("begin-returnBudget.");
        stats.addInfo(this.getParameter().getEntityNumber());
        stats.addInfo(this.getParameter().getBizId());
        stats.addInfo(this.getParameter().getEntryId());
        ReturnCalc returnCalc = ReturnCalc.getInterface();
        returnCalc.setParameter(this.getParameter());
        Long modelId = null;
        String[] props = BgRegisterUtils.queryRegisterBizUnit(this.getParameter().getEntityNumber());
        if (props != null && props.length > 6 && "false".equals(props[6])) {
            this.getParameter().getControlManager().setCalcBalance(false);
        }
        if ((tables = BgControlUtils.getCRTable(this.getParameter().getEntityNumber(), this.getParameter().getBizId())).isEmpty()) {
            tables.add("t_eb_bgcontrolrecord");
        }
        String sql = null;
        HashMap<Long, Set> bizTables = new HashMap<Long, Set>(10);
        for (String table : tables) {
            sql = "select distinct fmodelid from " + table + " where fbizid = ?";
            DataSet rst = DB.queryDataSet((String)"queryBgRecord", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{this.getParameter().getBizId()});
            Throwable throwable = null;
            try {
                if (rst == null) continue;
                Row row = null;
                while (rst.hasNext()) {
                    row = rst.next();
                    modelId = row.getLong("fmodelid");
                    if (modelId == null || modelId == 0L) continue;
                    bizTables.computeIfAbsent(modelId, f -> new HashSet(10)).add(table);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rst == null) continue;
                if (throwable != null) {
                    try {
                        rst.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rst.close();
            }
        }
        if (this.hasOffset(tables)) {
            if (StringUtils.isNotEmpty((String)this.getParameter().getEntryId())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u5df2\u7ecf\u6709\u5bf9\u5f53\u524d\u5355\u636e\u5177\u4f53\u5206\u5f55\u7684\u51b2\u51cf\u8bb0\u5f55\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u5220\u9664\u9884\u7b97\u7684\u64cd\u4f5c\u3002", (String)"ReturnBudgetImpl_1", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u5df2\u7ecf\u6709\u5bf9\u5f53\u524d\u5355\u636e\u7684\u51b2\u51cf\u8bb0\u5f55\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u5220\u9664\u9884\u7b97\u7684\u64cd\u4f5c\u3002", (String)"ReturnBudgetImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        HashMap<Long, Set> bizModelMap = new HashMap<Long, Set>(10);
        if (!bizTables.isEmpty()) {
            Long busModelId = 0L;
            for (Map.Entry entry : bizTables.entrySet()) {
                if (CommonUtils.hasBusinessModel((Long)((Long)entry.getKey())).booleanValue()) {
                    for (String crTable : (Set)entry.getValue()) {
                        if ("t_eb_bgcontrolrecord".equals(crTable)) {
                            stats.addInfo("end-returnBudget-crTable-error.");
                            log.info(stats.toString());
                            return;
                        }
                        busModelId = Long.valueOf(crTable.substring("t_eb_cr".length()));
                        bizModelMap.computeIfAbsent((Long)entry.getKey(), f -> new HashSet(10)).add(busModelId);
                    }
                    continue;
                }
                bizModelMap.put((Long)entry.getKey(), (Set)null);
            }
            stats.addInfo("modelIds size = " + bizModelMap.size());
            returnCalc.getBizModelMap().putAll(bizModelMap);
            returnCalc.setStats(stats);
            if (!bizModelMap.isEmpty()) {
                stats.add("begin-lock");
                this.lock(returnCalc);
            }
            try {
                this.checkResult(this.getParameter());
            }
            catch (Exception e) {
                stats.addInfo("end-returnBudget.");
                log.info(stats.toString());
                throw e;
            }
        }
        stats.addInfo("end-returnBudget.");
        log.info(stats.toString());
    }

    @Override
    protected void checkResult(IControlParameter parameter) {
        if (parameter == null || parameter.getResult() == null) {
            throw new NullPointerException("not control result.");
        }
        if (!parameter.getControlManager().isCalcBalance()) {
            return;
        }
        if (parameter.getResult().getResult().getNumber().equals(ControlResultEnum.BEYOND.getNumber())) {
            List<IResultCause> causeList = parameter.getResult().getCause();
            StringBuilder moreMsg = new StringBuilder();
            HashSet rpt = new HashSet(16);
            ArrayList<IResultCause> sourceReason = new ArrayList<IResultCause>(causeList.size());
            if (causeList.stream().anyMatch(k -> StringUtils.isNotEmpty((String)k.getControlParam().getRefBizId()) && k.getControlParam().isBeyondBudget())) {
                causeList.stream().filter(k -> StringUtils.isNotEmpty((String)k.getControlParam().getRefBizId()) && k.getControlParam().isBeyondBudget()).forEach(k -> {
                    IControlParam sourceParam;
                    Optional<IResultCause> any = causeList.stream().filter(m -> m.getControlParam().getBizId().equals(k.getControlParam().getRefBizId())).findAny();
                    if (any.isPresent() && !rpt.contains((sourceParam = any.get().getControlParam()).getBizNumber())) {
                        String entityNumber = sourceParam.getEntityNumber();
                        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                        moreMsg.append(String.format("%s:%s", billType.getDisplayName(), sourceParam.getBizNumber()));
                        rpt.add(sourceParam.getBizNumber());
                        sourceReason.add((IResultCause)k);
                    }
                });
            }
            String entityNumber = parameter.getEntityNumber();
            Boolean showBeyondMessage = parameter.getResult().getShowBeyondMessage();
            String controlMessage = null;
            if (moreMsg.length() > 0) {
                controlMessage = BgControlUtils.getControlMessage(sourceReason, entityNumber, showBeyondMessage, ControlMessageTypeEnum.BUDGET_NOT_ENOUGH.getNumber());
                controlMessage = ControlException.getReturnErrMsg((String)moreMsg.toString(), (String)controlMessage);
            } else {
                controlMessage = BgControlUtils.getControlMessage(causeList, entityNumber, showBeyondMessage, ControlMessageTypeEnum.BUDGET_NOT_ENOUGH.getNumber());
            }
            this.getStats().addInfo(controlMessage);
            BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLRESULT, 2, null, controlMessage, null, false);
            ControlException.errorOutOfBalance((String)controlMessage);
        } else {
            String bizno = this.getParameter().getBizNo();
            if (bizno == null) {
                try {
                    bizno = this.getParameter().getBizNumber();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (bizno == null) {
                bizno = "";
            }
            BgControlLogUtils.addDetail(this.getStats(), ControlLogTypeEnum.CONTROLRESULT, 0, parameter.getResult().getCode(), ControlException.returnBudget((String)bizno), null, false);
            this.getStats().addInfo(ControlException.requestBudget((String)this.getParameter().getBizNo()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasOffset(Set<String> tables) {
        if (tables == null) return false;
        if (tables.isEmpty()) {
            return false;
        }
        Iterator<String> iterator = tables.iterator();
        while (iterator.hasNext()) {
            String table = iterator.next();
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select 1 from " + table + " where ", new Object[0]);
            sqlBuilder.append(" fbizid <> '" + this.getParameter().getBizId() + "'", new Object[0]);
            sqlBuilder.append(" and frefbizid = '" + this.getParameter().getBizId() + "'", new Object[0]);
            if (StringUtils.isNotEmpty((String)this.getParameter().getEntryId())) {
                sqlBuilder.appendIn(" and frefentryid", (Object[])this.getParameter().getEntryId().split(","));
            }
            try {
                DataSet ds = this.queryDataSet("checkOffset", BgBaseConstant.epm, sqlBuilder);
                Throwable throwable = null;
                try {
                    if (ds == null || !ds.hasNext()) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (ds == null) continue;
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    ds.close();
                }
            }
            catch (Exception ex) {
                log.error("returnBudget-checkOffset error.", (Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
        return false;
    }

    private DataSet queryDataSet(String algoKey, DBRoute epm, SqlBuilder sqlBuilder) {
        return DB.queryDataSet((String)algoKey, (DBRoute)epm, (SqlBuilder)sqlBuilder);
    }
}

