/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.calc;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BooleanProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.ChangeTypeServiceHelper;
import kd.epm.eb.common.utils.EntityUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.eums.ControlResultEnum;
import kd.epm.eb.control.eums.ControlTypeEnum;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.model.AbstractBgControlRecord;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.impl.model.BgControlSetting;
import kd.epm.eb.control.impl.model.ControlOccRecord;
import kd.epm.eb.control.impl.model.ControlOccValue;
import kd.epm.eb.control.impl.model.ResultCause;
import kd.epm.eb.control.utils.BalanceCheckUtils;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.BgRegisterUtils;

public class BalanceCheck {
    private static Log log = LogFactory.getLog(BalanceCheck.class);
    private boolean isNeedOccupation = true;
    private LogStats stats = null;
    private IControlParameter parameter = null;
    private Collection<IControlParam> controlParams = null;
    private Collection<BgControlRecord> bgControlRecords = new ArrayList<BgControlRecord>();
    private Map<Long, Map<String, Map<String, Object>>> changeTypes = new HashMap<Long, Map<String, Map<String, Object>>>();
    private Date createTime = new Date();

    public void setNeedOccupation(boolean isNeedOccupation) {
        this.isNeedOccupation = isNeedOccupation;
    }

    protected LogStats getStats() {
        return this.stats;
    }

    public BalanceCheck setParameter(IControlParameter parameter) {
        this.parameter = parameter;
        return this;
    }

    public IControlParameter getParameter() {
        return this.parameter;
    }

    public BalanceCheck setControlParams(Collection<IControlParam> controlParams) {
        this.controlParams = controlParams;
        return this;
    }

    public Collection<IControlParam> getControlParams() {
        return this.controlParams;
    }

    public Collection<BgControlRecord> getBgControlRecords() {
        return this.bgControlRecords;
    }

    public BalanceCheck(LogStats stats) {
        this.stats = stats;
    }

    public static BalanceCheck getInterface(LogStats stats) {
        return new BalanceCheck(stats);
    }

    public boolean calc() {
        List collect;
        List<Long> oboDims;
        Map<Long, Set<String>> oboMemberNumberMap;
        BigDecimal amend;
        String dataKey;
        if (this.getParameter() == null || this.getControlParams() == null || this.getControlParams().isEmpty()) {
            return false;
        }
        HashMap<Long, Set<String>> unitWriteOffIds = new HashMap<Long, Set<String>>(10);
        HashMap<Long, Map<Long, Set<String>>> nounitWriteSchemIds = new HashMap<Long, Map<Long, Set<String>>>();
        for (IControlParam iControlParam : this.getControlParams()) {
            if (!iControlParam.isWriteOffs()) continue;
            if (IDUtils.isNotNull((Long)iControlParam.getTargetSchemeId())) {
                nounitWriteSchemIds.computeIfAbsent(iControlParam.getBizModel().getKey(), f -> new HashMap(10)).computeIfAbsent(iControlParam.getTargetSchemeId(), g -> new HashSet(10)).add(iControlParam.getRefBizId());
                continue;
            }
            unitWriteOffIds.computeIfAbsent(iControlParam.getBizModel().getKey(), f -> new HashSet(10)).add(iControlParam.getRefBizId());
        }
        LinkedHashSet bizIds = Sets.newLinkedHashSet();
        bizIds.add(this.getParameter().getBizId());
        if (this.getParameter().getDataManager().getSourceBizUnit() != null) {
            for (HashSet<Long> hashSet : this.getParameter().getDataManager().getSourceBizUnit().values()) {
                for (Object sId : hashSet) {
                    bizIds.add(String.valueOf(sId));
                }
            }
        }
        Map map = EntityUtils.getSourceIds((DynamicObject)this.getParameter().getBizObj());
        for (Set ids : map.values()) {
            for (Object id : ids) {
                if (!StringUtils.isNotEmpty((String)id)) continue;
                bizIds.add(id);
            }
        }
        List<Map<String, Object>> list = this.getParameter().getBizObjMaps();
        if (list != null) {
            List _sourceAmounts = null;
            for (Map map2 : list) {
                String _sourceId = (String)map2.get("sourceid");
                if (StringUtils.isNotEmpty((String)_sourceId)) {
                    bizIds.add(_sourceId);
                    continue;
                }
                _sourceAmounts = (List)map2.get("sourceamount");
                if (_sourceAmounts == null || _sourceAmounts.isEmpty()) continue;
                for (Object subMap : _sourceAmounts) {
                    if (subMap.get("id") == null) continue;
                    bizIds.add(String.valueOf(subMap.get("id")));
                }
            }
        }
        if (StringUtils.isNotEmpty((String)this.getParameter().getDataManager().getUpstreamId())) {
            bizIds.add(this.getParameter().getDataManager().getUpstreamId());
        }
        this.getStats().addInfo("bizIds = " + JSON.toJSONString((Object)bizIds));
        List<BgControlRecord> records = BgControlRecordUtils.query(bizIds, this.getParameter().getDataManager().getModel(), true);
        if (records != null && !records.isEmpty()) {
            this.getStats().addInfo("recordsSize = " + records.size());
        }
        ArrayList<BgControlRecord> writeOffRecords = records == null ? new ArrayList<BgControlRecord>(1) : records.stream().filter(k -> !this.getParameter().getControlManager().isReturnBudget() || !k.getBizId().equals(this.getParameter().getBizId())).collect(Collectors.toList());
        this.createTime = new Date();
        ArrayList<IControlParam> occupations = new ArrayList<IControlParam>();
        ArrayList<IControlParam> arrayList = new ArrayList<IControlParam>();
        ArrayList<IControlParam> writeOffs = new ArrayList<IControlParam>();
        for (IControlParam controlParam : this.getControlParams()) {
            if (!controlParam.isWriteOffs()) continue;
            writeOffs.add(controlParam);
        }
        for (IControlParam controlParam : this.getControlParams()) {
            if (controlParam.isWriteOffs()) continue;
            if (controlParam.getControlType() == ControlTypeEnum.OCCUPATION) {
                occupations.add(controlParam);
                continue;
            }
            if (controlParam.getControlType() == ControlTypeEnum.EXECUTE) {
                arrayList.add(controlParam);
                continue;
            }
            if (controlParam.getControlType() != ControlTypeEnum.NOTCONTROL) continue;
        }
        LinkedHashSet<String> controlBizIds = this.calcControlBizIds();
        controlBizIds.addAll(bizIds);
        this.getStats().addInfo("controlBizIds = " + JSONUtils.toString(controlBizIds));
        ArrayList<BgControlRecord> currRecords = new ArrayList<BgControlRecord>();
        if (this.isNeedOccupation) {
            if (!occupations.isEmpty()) {
                occupations.addAll(writeOffs);
                this.occupationRequest(occupations, controlBizIds, writeOffRecords, false, currRecords, unitWriteOffIds, nounitWriteSchemIds);
            }
            if (!arrayList.isEmpty()) {
                arrayList.addAll(writeOffs);
                this.occupationRequest(arrayList, controlBizIds, writeOffRecords, true, currRecords, unitWriteOffIds, nounitWriteSchemIds);
            }
        }
        TreeMap<String, BigDecimal> mergeAmends = new TreeMap<String, BigDecimal>(String::compareTo);
        TreeMap<String, BigDecimal> mergeAdjustCheckAmends = new TreeMap<String, BigDecimal>(String::compareTo);
        HashMap groupAmends = Maps.newHashMapWithExpectedSize((int)this.getControlParams().size());
        HashMap groupAdjustCheckAmends = Maps.newHashMapWithExpectedSize((int)this.getControlParams().size());
        HashMap controlParamMap = Maps.newHashMapWithExpectedSize((int)this.getControlParams().size());
        HashMap recordMap = Maps.newHashMapWithExpectedSize((int)this.getControlParams().size());
        HashMap groupParamMap = Maps.newHashMapWithExpectedSize((int)this.getControlParams().size());
        HashSet<String> hasOccMemberKeys = new HashSet<String>(16);
        String groupNoKey = null;
        HashMap<String, BigDecimal> totalAdjustAmendMap = new HashMap<String, BigDecimal>(16);
        Member vMember = null;
        Member cMember = null;
        Member dMember = null;
        if (!this.getControlParams().isEmpty()) {
            Iterator<Object> controlParam = this.getControlParams().iterator().next();
            cMember = controlParam.getChangeType(true);
            vMember = controlParam.getVersion(true);
            dMember = controlParam.getMember(true, SysDimensionEnum.DataType.getNumber());
        }
        if (vMember != null && cMember != null && dMember != null) {
            for (BgControlRecord record : currRecords) {
                record = record.getClone();
                record.setMember(vMember);
                record.setMember(cMember);
                record.setMember(dMember);
                dataKey = record.getMemberKey(false);
                amend = mergeAmends.computeIfAbsent(dataKey, f -> BigDecimal.ZERO);
                amend = amend.add(record.getAmount());
                mergeAmends.put(dataKey, amend);
                if (!recordMap.containsKey(dataKey)) {
                    recordMap.put(dataKey, new ArrayList(10));
                }
                ((List)recordMap.get(dataKey)).add(record);
            }
        }
        for (IControlParam controlParam : this.getControlParams()) {
            BigDecimal adjustCheckAmend;
            dataKey = controlParam.getMemberKeyByBudget();
            amend = mergeAmends.computeIfAbsent(dataKey, f -> BigDecimal.ZERO);
            amend = amend.add(controlParam.getAmend());
            mergeAmends.put(dataKey, amend);
            if (controlParam.isOccupation()) {
                hasOccMemberKeys.add(dataKey);
            }
            if (controlParam.getAdjustCheckFlag()) {
                adjustCheckAmend = mergeAdjustCheckAmends.computeIfAbsent(dataKey, f -> BigDecimal.ZERO);
                adjustCheckAmend = adjustCheckAmend.add(controlParam.getAdjustCheckAmend());
                mergeAdjustCheckAmends.put(dataKey, adjustCheckAmend);
                BigDecimal totalAdjustAmend = totalAdjustAmendMap.computeIfAbsent(dataKey, f -> BigDecimal.ZERO);
                totalAdjustAmend = totalAdjustAmend.add(adjustCheckAmend);
                totalAdjustAmendMap.put(dataKey, totalAdjustAmend);
            }
            List params = controlParamMap.computeIfAbsent(dataKey, f -> Lists.newArrayList());
            params.add(controlParam);
            int groupNo = controlParam.getSetting().getGroupNo();
            groupNoKey = null;
            if (groupNo > 0) {
                Iterator<BgControlSetting> oboMemberNumberMap2 = controlParam.getSetting().getOboMemberNumberMap();
                List<Long> oboDims2 = controlParam.getSetting().getOboDimIds();
                groupNoKey = controlParam.getGroupKey(controlParam, (Map<Long, Set<String>>)((Object)oboMemberNumberMap2), oboDims2, null);
                amend = groupAmends.computeIfAbsent(groupNoKey, f -> BigDecimal.ZERO);
                amend = amend.add(controlParam.getAmend());
                groupAmends.put(groupNoKey, amend);
                if (controlParam.getAdjustCheckFlag()) {
                    if (controlParam.getAdjustCheckTotalFlag() && !controlParam.getGroupKeyHasUserDimFlag()) continue;
                    adjustCheckAmend = groupAdjustCheckAmends.computeIfAbsent(groupNoKey, f -> BigDecimal.ZERO);
                    adjustCheckAmend = adjustCheckAmend.add(controlParam.getAdjustCheckAmend());
                    groupAdjustCheckAmends.put(groupNoKey, adjustCheckAmend);
                }
                params = groupParamMap.computeIfAbsent(groupNoKey, f -> Lists.newArrayList());
                if (controlParam.isOccupation()) {
                    hasOccMemberKeys.add(groupNoKey);
                }
                params.add(controlParam);
            }
            for (Object setting : controlParam.getActParentGroupSetting()) {
                String _groupNoKey = controlParam.getGroupKey((BgControlSetting)((Object)setting), controlParam, oboMemberNumberMap = setting.getOboMemberNumberMap(), oboDims = setting.getOboDimIds(), null);
                if (StringUtils.equals((String)groupNoKey, (String)_groupNoKey)) continue;
                amend = groupAmends.computeIfAbsent(_groupNoKey, f -> BigDecimal.ZERO);
                amend = amend.add(controlParam.getAmend());
                groupAmends.put(_groupNoKey, amend);
                if (controlParam.getAdjustCheckFlag()) {
                    if (controlParam.getAdjustCheckTotalFlag() && !controlParam.getGroupKeyHasUserDimFlag()) continue;
                    adjustCheckAmend = groupAdjustCheckAmends.computeIfAbsent(_groupNoKey, f -> BigDecimal.ZERO);
                    adjustCheckAmend = adjustCheckAmend.add(controlParam.getAdjustCheckAmend());
                    groupAdjustCheckAmends.put(_groupNoKey, adjustCheckAmend);
                }
                params = groupParamMap.computeIfAbsent(_groupNoKey, f -> Lists.newArrayList());
                if (controlParam.isOccupation()) {
                    hasOccMemberKeys.add(_groupNoKey);
                }
                params.add(controlParam);
            }
        }
        for (IControlParam controlParam : this.getControlParams()) {
            for (Object setting : controlParam.getActParentGroupSetting()) {
                oboMemberNumberMap = setting.getOboMemberNumberMap();
                oboDims = setting.getOboDimIds();
                if (!controlParam.isAddup()) continue;
                controlParam.calcHasPeriods();
                for (String actualPeriod : controlParam.getHasActualPeriods()) {
                    String groupKey = controlParam.getGroupKey(controlParam, oboMemberNumberMap, oboDims, actualPeriod);
                    if (groupAmends.containsKey(groupKey)) continue;
                    groupAmends.put(groupKey, BigDecimal.ZERO);
                }
            }
        }
        HashMap<String, Boolean> isEbModelMap = new HashMap<String, Boolean>();
        HashMap<Long, Set<String>> members = new HashMap<Long, Set<String>>();
        Map<String, BigDecimal> parentAmends = BalanceCheckUtils.calcParentAmount(this.getStats(), mergeAmends, controlParamMap, isEbModelMap, null, members, hasOccMemberKeys);
        parentAmends = BalanceCheckUtils.calcParentAmount(this.getStats(), mergeAmends, recordMap, isEbModelMap, parentAmends, members, hasOccMemberKeys);
        BalanceCheckUtils.calcSumPeriodAmount(this.getStats(), mergeAmends, parentAmends, controlParamMap, isEbModelMap, hasOccMemberKeys);
        BalanceCheckUtils.calcSumPeriodGroupAmount(this.getStats(), groupAmends, groupParamMap, hasOccMemberKeys);
        if (this.getParameter().isHasAdjustCheck()) {
            this.handleControlParamMapBySameBgDataKey(controlParamMap, totalAdjustAmendMap);
            BalanceCheckUtils.calcSumAdjustCheckPeriodAmount(this.getStats(), mergeAdjustCheckAmends, controlParamMap);
            BalanceCheckUtils.calcSumAdjustCheckPeriodPeriodGroupAmount(this.getStats(), groupAdjustCheckAmends, groupParamMap);
        }
        BalanceCheckUtils.handleBalanceCheckControlParam(this.getControlParams(), this.isNeedOccupation);
        for (IControlParam controlParam : this.getControlParams()) {
            Iterator ruleId = controlParam.getSetting().getId();
            if (controlParam.getAdjustCheckFlag()) {
                controlParam.calc(mergeAdjustCheckAmends, groupAdjustCheckAmends, controlParam.getSetting().getOboMemberNumberMap(), controlParam.getSetting().getOboDimIds(), hasOccMemberKeys);
            } else {
                controlParam.calc(mergeAmends, groupAmends, controlParam.getSetting().getOboMemberNumberMap(), controlParam.getSetting().getOboDimIds(), hasOccMemberKeys);
            }
            if (!controlParam.isBeyondBudget() || this.getParameter().getControlManager().isCalcBalance() && controlParam.getControlType().getIndex() != ControlTypeEnum.NOTCONTROL.getIndex() && !controlParam.isWriteOffs()) continue;
            controlParam.setBeyondBudget(false);
        }
        Boolean isPass = !this.getControlParams().stream().anyMatch(param -> param.isBeyondBudget() && (this.getParameter().getControlManager().isValidBalance() != false || param.getSetting() != null && !param.getSetting().isBeyond()));
        if (this.getControlParams().stream().anyMatch(param -> param.getSetting() != null && !param.getSetting().isBeyond() && param.isBeyondBudget())) {
            collect = this.getControlParams().stream().filter(param -> param.getSetting() != null && !param.getSetting().isBeyond() && param.isBeyondBudget()).collect(Collectors.toList());
            this.getParameter().getResult().setResult(ControlResultEnum.BEYOND);
            for (IControlParam iControlParam : collect) {
                this.getParameter().getResult().addCause(ResultCause.createFromControlParam(iControlParam, iControlParam.getSetting().isBeyond()));
            }
        } else if (this.getControlParams().stream().anyMatch(param -> this.getParameter().getControlManager().isValidBalance() != false && param.isBeyondBudget())) {
            this.getParameter().getResult().setResult(ControlResultEnum.BEYOND);
            collect = this.getControlParams().stream().filter(param -> this.getParameter().getControlManager().isValidBalance() != false && param.isBeyondBudget()).collect(Collectors.toList());
            for (IControlParam iControlParam : collect) {
                this.getParameter().getResult().addCause(ResultCause.createFromControlParam(iControlParam, iControlParam.getSetting().isBeyond()));
            }
        } else {
            this.getParameter().getResult().setCode("success");
            this.getParameter().getResult().setResult(ControlResultEnum.PASS);
        }
        if (this.getParameter().getControlManager().isStandard()) {
            IControlParam controlParam;
            if (this.getControlParams().stream().anyMatch(param -> param.isBeyondWarning())) {
                controlParam = this.getControlParams().stream().filter(param -> param.isBeyondWarning()).findFirst().get();
                String billId = controlParam.getBizId();
                String formId = this.getParameter().getEntityNumber();
                if (StringUtils.isNotEmpty((String)billId)) {
                    this.setBillWarningStatus(Long.parseLong(billId), formId, this.getParameter().getBizObj(), "1");
                }
            } else {
                controlParam = this.getControlParams().iterator().next();
                if (StringUtils.isNotEmpty((String)controlParam.getBizId())) {
                    this.setBillWarningStatus(IDUtils.toLong((Object)controlParam.getBizId()), this.getParameter().getEntityNumber(), this.getParameter().getBizObj(), "0");
                }
            }
        }
        return isPass;
    }

    private void handleControlParamMapBySameBgDataKey(Map<String, List<IControlParam>> controlParamMap, Map<String, BigDecimal> totalAdjustAmendMap) {
        for (Map.Entry<String, List<IControlParam>> entry : controlParamMap.entrySet()) {
            String key = entry.getKey();
            List<IControlParam> controlParams = entry.getValue();
            for (IControlParam controlParam : controlParams) {
                if (!totalAdjustAmendMap.containsKey(key)) continue;
                controlParam.setAdjustCheckAmend(totalAdjustAmendMap.get(key));
            }
        }
    }

    private LinkedHashSet<String> calcControlBizIds() {
        LinkedHashSet bizIds = Sets.newLinkedHashSet();
        bizIds.add(this.getParameter().getBizId());
        if (this.getParameter().getDataManager().getSourceBizUnit() != null) {
            for (HashSet<Long> hashSet : this.getParameter().getDataManager().getSourceBizUnit().values()) {
                for (Object sId : hashSet) {
                    bizIds.add(String.valueOf(sId));
                }
            }
        }
        Map sources = EntityUtils.getSourceIds((DynamicObject)this.getParameter().getBizObj());
        for (Set ids : sources.values()) {
            for (String id : ids) {
                if (!StringUtils.isNotEmpty((String)id)) continue;
                bizIds.add(id);
            }
        }
        List<Map<String, Object>> list = this.getParameter().getBizObjMaps();
        if (list != null) {
            List _sourceAmounts = null;
            for (Map<String, Object> entry : list) {
                String _sourceId = (String)entry.get("sourceid");
                if (StringUtils.isNotEmpty((String)_sourceId)) {
                    bizIds.add(_sourceId);
                    continue;
                }
                _sourceAmounts = (List)entry.get("sourceamount");
                if (_sourceAmounts == null || _sourceAmounts.isEmpty()) continue;
                for (Map subMap : _sourceAmounts) {
                    if (subMap.get("id") == null) continue;
                    bizIds.add(String.valueOf(subMap.get("id")));
                }
            }
        }
        if (StringUtils.isNotEmpty((String)this.getParameter().getDataManager().getUpstreamId())) {
            bizIds.add(this.getParameter().getDataManager().getUpstreamId());
        }
        return bizIds;
    }

    private void setBillWarningStatus(Long fid, String formId, DynamicObject bizBill, String value) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("type", "=", (Object)BillFieldTypeEmum.WARNING.getNumber()));
        filters.add(new QFilter("fieldtable", "=", (Object)formId));
        DynamicObject regDy = QueryServiceHelper.queryOne((String)"eb_bgcontrolbizreg", (String)"number", (QFilter[])filters.toArray(new QFilter[0]));
        if (regDy == null || bizBill == null) {
            return;
        }
        String fieldName = regDy.getString("number");
        this.getStats().addInfo("setBillWarningStatusFieldName : " + String.format("fieldName = %s,fid = %s,formid = %s", fieldName, fid, formId));
        Boolean isContainKey = bizBill.getDataEntityType().getProperties().containsKey((Object)fieldName);
        if (isContainKey.booleanValue()) {
            DynamicProperty fieldType = bizBill.getDynamicObjectType().getProperty(fieldName);
            if (fieldType instanceof BooleanProp) {
                this.getParameter().getResult().getWarningResult().put(fieldName, value);
            } else {
                this.getStats().addInfo(ResManager.loadResFormat((String)"setBillWarningStatusFieldValue : \u975e\u5e03\u5c14\u7c7b\u578b:%1", (String)"BalanceCheck_0", (String)"epm-eb-business", (Object[])new Object[]{fieldName}));
            }
        } else {
            this.getStats().addInfo(ResManager.loadResFormat((String)"setBillWarningStatusFieldValue : \u4e0d\u5b58\u5728\u5c5e\u6027:%1", (String)"BalanceCheck_1", (String)"epm-eb-business", (Object[])new Object[]{fieldName}));
        }
    }

    public void check() {
        for (IControlParam controlParam : this.getControlParams()) {
            if (!controlParam.isQueryBudget()) continue;
            controlParam.calc(null, null, new HashMap<Long, Set<String>>(16), new ArrayList<Long>(16), null);
            BgControlLogUtils.infoThread(this.getStats(), controlParam.isNeedLog(), () -> "queryBalance ControlParam.toMap:" + JSONUtils.toString(controlParam.toMap()));
        }
    }

    protected void occupation(Collection<IControlParam> occupations) {
        if (occupations == null || this.createTime == null) {
            return;
        }
        BgControlRecord record = null;
        Map<String, BigDecimal> sumApplyValues = this.getSumApplyValue(occupations);
        for (IControlParam occupation : occupations) {
            String ctrlKey = occupation.getMemberKey(false, occupation.getBizModel().getDimensions());
            BigDecimal applyValue = sumApplyValues.get(ctrlKey);
            if (occupation.isWriteOffs() && (occupation.getAmount() == null || occupation.getAmount().compareTo(BigDecimal.ZERO) == 0) || !occupation.isOnlyCheck() && !occupation.isWriteOffs() && !this.getParameter().getControlManager().isNegativeOcc() && applyValue.compareTo(BigDecimal.ZERO) < 0 || (record = this.createBgControlRecord(occupation)) == null) continue;
            if (occupation.isWriteOffs()) {
                this.setWriteoffInfo(record, occupation);
            } else {
                record.setMember(ChangeTypeServiceHelper.loadChangeType((Map)ChangeTypeServiceHelper.getOccupation((BizModel)record.getBizModel(), this.changeTypes)));
                record.setOccType(BgControlRecord.OccupationType.INITOCC.getNumber());
            }
            this.getBgControlRecords().add(record);
        }
    }

    protected void setWriteoffInfo(BgControlRecord record, IControlParam occupation) {
        record.setRefEntryId(occupation.getEntryId());
        record.setOccType(BgControlRecord.OccupationType.WOOCC.getNumber());
        if (occupation.getControlType() == ControlTypeEnum.OCCUPATION) {
            record.setMember(ChangeTypeServiceHelper.loadChangeType((Map)ChangeTypeServiceHelper.getOccupation((BizModel)occupation.getBizModel(), this.changeTypes)));
        } else {
            record.setMember(ChangeTypeServiceHelper.loadChangeType((Map)ChangeTypeServiceHelper.getExecuted((BizModel)occupation.getBizModel(), this.changeTypes)));
        }
    }

    protected Map<String, BigDecimal> getSumApplyValue(Collection<IControlParam> controlParams) {
        HashMap applyValues = Maps.newHashMapWithExpectedSize((int)controlParams.size());
        for (IControlParam controlParam : controlParams) {
            if (controlParam.isWriteOffs()) continue;
            String actualKey = controlParam.getMemberKey(false, controlParam.getBizModel().getDimensions());
            BigDecimal sumValue = applyValues.computeIfAbsent(actualKey, f -> BigDecimal.ZERO);
            sumValue = sumValue.add(controlParam.getAmount());
            applyValues.put(actualKey, sumValue);
        }
        return applyValues;
    }

    private Boolean isReviewOcc(String bizId, Collection<BgControlRecord> records) {
        return this.getParameter().getControlManager().isOccupation() && records.stream().anyMatch(k -> k.getBizId().equals(bizId) && k.getMember(SysDimensionEnum.ChangeType.getNumber()).getNumber().equals("Occupation"));
    }

    private Boolean isReviewExec(String bizId, Collection<BgControlRecord> records) {
        return this.getParameter().getControlManager().isExecute() && records.stream().anyMatch(k -> k.getBizId().equals(bizId) && k.getMember(SysDimensionEnum.ChangeType.getNumber()).getNumber().equals("Execute"));
    }

    protected BgControlRecord createBgControlRecord(IControlParam controlParam) {
        if (controlParam == null) {
            return null;
        }
        return BgControlRecord.createFromControlParam(controlParam, this.getParameter().getEntityNumber(), controlParam.getBizModel().getDimensions(), this.createTime, this.getParameter().getOperation());
    }

    protected void request(Collection<IControlParam> executes) {
        if (executes == null || this.createTime == null) {
            return;
        }
        for (IControlParam execute : executes) {
            BgControlRecord record = this.createBgControlRecord(execute);
            if (record == null) continue;
            Map changeType = ChangeTypeServiceHelper.getExecuted((BizModel)execute.getBizModel(), this.changeTypes);
            if (execute.isWriteOffs()) {
                if (execute.getAmount() == null || execute.getAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                this.setWriteoffInfo(record, execute);
            } else {
                record.setMember(ChangeTypeServiceHelper.loadChangeType((Map)changeType));
                record.setOccType(BgControlRecord.OccupationType.EXECUTE.getNumber());
            }
            this.getBgControlRecords().add(record);
        }
    }

    protected void occupationRequest(Collection<IControlParam> controlParams, Collection<String> bizIds, Collection<BgControlRecord> records, boolean isRequest, List<BgControlRecord> currRecords, Map<Long, Set<String>> unitWriteOffIds, Map<Long, Map<Long, Set<String>>> nounitWriteSchemIds) {
        if (controlParams == null || controlParams.isEmpty()) {
            return;
        }
        if (this.createTime == null) {
            this.createTime = new Date();
        }
        LogStats mystats = new LogStats("budget-control-log : ");
        Boolean isReviewOcc = this.isReviewOcc(this.parameter.getBizId(), records);
        Boolean isReviewExec = this.isReviewExec(this.parameter.getBizId(), records);
        if (records == null || records.isEmpty()) {
            if (isRequest) {
                this.request(controlParams);
            } else {
                this.occupation(controlParams);
            }
            return;
        }
        this.getStats().addInfo("start-occupationRequest-records-size = " + records.size());
        BgControlLogUtils.infoThread(this.getStats(), true, () -> "start-occupationRequest-records = " + JSON.toJSONString((Object)records));
        HashSet<String> hasNegativeOcc = new HashSet<String>(16);
        BgControlUtils.buildHasNegativeOcc(records, hasNegativeOcc);
        HashMap<String, String[]> defaultSetting = new HashMap<String, String[]>(16);
        boolean hasCurr = this.hasCurrOccupation(records);
        HashMap addNewOccupationRecordMap = Maps.newHashMapWithExpectedSize((int)controlParams.size());
        List sortParams = controlParams.stream().sorted(Comparator.comparing(x -> x.getMember(false, x.getBizModel().isEBByModel() ? SysDimensionEnum.Period.getNumber() : SysDimensionEnum.BudgetPeriod.getNumber()) != null ? x.getMember(false, x.getBizModel().isEBByModel() ? SysDimensionEnum.Period.getNumber() : SysDimensionEnum.BudgetPeriod.getNumber()).getNumber() : "")).collect(Collectors.toList());
        BigDecimal requestValue = null;
        BigDecimal thisRequestValue = null;
        ControlOccValue occValue = null;
        BigDecimal deductValue = null;
        BigDecimal value = null;
        String memberKey = null;
        ArrayList<ControlOccRecord> controlOccRecords = new ArrayList<ControlOccRecord>(controlParams.size());
        Map<String, Member> periodMemberMap = this.getPeriodMemberMap(records);
        Map<String, Map<String, Map<String, ControlOccValue>>> periodMap = null;
        HashMap sumApplyValues = Maps.newHashMapWithExpectedSize((int)controlParams.size());
        for (IControlParam controlParam : controlParams) {
            if (controlParam.isWriteOffs() || controlParam.getBizModel() == null) continue;
            controlParam.setBgMemberJson(BgControlRecord.getBudgetMemberJson(controlParam, controlParam.getBizModel().getDimensions()));
            if (controlParam.isOnlyCheck()) continue;
            memberKey = controlParam.getMemberKey(false, controlParam.getBizModel().getDimensions());
            value = sumApplyValues.computeIfAbsent(memberKey, f -> BigDecimal.ZERO);
            value = value.add(controlParam.getAmount());
            sumApplyValues.put(memberKey, value);
        }
        if ((isReviewOcc.booleanValue() || isReviewExec.booleanValue()) && records.stream().anyMatch(k -> this.parameter.getBizId().equals(k.getBizId()) && BgControlRecord.OccupationType.CLSOCC.getNumber().equals(k.getOccType()) && (this.parameter.getControlManager().getDeductByEntry() == false || controlParams.stream().anyMatch(l -> k.getRefEntryId().equals(l.getEntryId()))))) {
            ControlException.errorReviewOccClosed();
        }
        BgControlLogUtils.infoThread(this.getStats(), true, () -> "controlParams>>" + JSONUtils.toString((Object)sumApplyValues));
        HashMap<Object, Map> sourceamounts = new HashMap<Object, Map>(10);
        Boolean isWriteOffByEntry = Boolean.FALSE;
        ArrayList<BgControlRecord> addNewRecords = new ArrayList<BgControlRecord>(sortParams.size());
        for (int i = 0; i < sortParams.size(); ++i) {
            IControlParam controlParam = (IControlParam)sortParams.get(i);
            int paramIndex = i;
            if (controlParam.getBizModel() == null || !isRequest && controlParam.isWriteOffs()) continue;
            memberKey = controlParam.getMemberKey(false, false, controlParam.getBizModel().getDimensions());
            value = (BigDecimal)sumApplyValues.get(memberKey);
            BgControlLogUtils.info(this.getStats(), true, paramIndex + ".memberKey>>" + memberKey + ",membervalue=" + value);
            boolean isNocc = false;
            if (value != null && value.compareTo(BigDecimal.ZERO) < 0 && !isRequest && !controlParam.isOnlyCheck()) {
                if (!this.getParameter().getControlManager().isNegativeOcc()) continue;
                isNocc = true;
            }
            if (controlParam.isOnlyCheck() || isRequest || controlParam.getAmount().compareTo(BigDecimal.ZERO) != 0 || isReviewOcc.booleanValue() && controlParam.getAmount().compareTo(BigDecimal.ZERO) == 0) {
                BgControlRecord record = this.createBgControlRecord(controlParam);
                if (record == null) continue;
                if (!controlParam.isWriteOffs()) {
                    if (isRequest) {
                        record.setMember(ChangeTypeServiceHelper.loadChangeType((Map)ChangeTypeServiceHelper.getExecuted((BizModel)controlParam.getBizModel(), this.changeTypes)));
                        record.setOccType(isReviewExec != false ? BgControlRecord.OccupationType.REVEXEC.getNumber() : BgControlRecord.OccupationType.EXECUTE.getNumber());
                    } else {
                        record.setMember(ChangeTypeServiceHelper.loadChangeType((Map)ChangeTypeServiceHelper.getOccupation((BizModel)controlParam.getBizModel(), this.changeTypes)));
                        record.setOccType(isReviewOcc != false ? BgControlRecord.OccupationType.REVOCC.getNumber() : BgControlRecord.OccupationType.INITOCC.getNumber());
                    }
                } else {
                    if (controlParam.getControlType() == ControlTypeEnum.OCCUPATION) {
                        record.setMember(ChangeTypeServiceHelper.loadChangeType((Map)ChangeTypeServiceHelper.getOccupation((BizModel)controlParam.getBizModel(), this.changeTypes)));
                    } else {
                        record.setMember(ChangeTypeServiceHelper.loadChangeType((Map)ChangeTypeServiceHelper.getExecuted((BizModel)controlParam.getBizModel(), this.changeTypes)));
                    }
                    record.setOccType(BgControlRecord.OccupationType.WOOCC.getNumber());
                    record.setRefEntryId(controlParam.getEntryId());
                    String changeType = this.parameter.getControlManager().isOccupation() ? "Occupation" : "Execute";
                    record.setWriteOffType("writeoffscheme" + changeType);
                }
                addNewRecords.add(record);
            }
            if (isNocc || controlParam.isWriteOffs() || controlParam.isOnlyCheck()) continue;
            try {
                sourceamounts.clear();
                if (!this.getParameter().getControlManager().isStandard() && controlParam.getPropValueMap().get("sourceamount") instanceof List && StringUtils.isEmpty((String)((String)controlParam.getPropValueMap().get("sourceid")))) {
                    List _sourceAmounts = (List)controlParam.getPropValueMap().get("sourceamount");
                    Object bizId = null;
                    BigDecimal amount = null;
                    HashSet<Object> rBizIds = new HashSet<Object>(16);
                    HashSet<String> rentryBizIds = new HashSet<String>(16);
                    for (Map map : _sourceAmounts) {
                        amount = !map.containsKey("amount") ? null : new BigDecimal(String.valueOf(map.get("amount")));
                        bizId = String.valueOf(map.get("id"));
                        String entityNumber = !map.containsKey("bostype") ? null : map.get("bostype").toString();
                        BgRegisterUtils.loadDefaultSetting(defaultSetting, entityNumber);
                        Map amounts = sourceamounts.getOrDefault(bizId, new HashMap());
                        if (defaultSetting.containsKey(entityNumber)) {
                            String[] props = (String[])defaultSetting.get(entityNumber);
                            isWriteOffByEntry = BgRegisterUtils.isDeductByEntry(props);
                            if (isWriteOffByEntry.booleanValue()) {
                                Object sbizId = bizId;
                                isWriteOffByEntry = records.stream().filter(arg_0 -> BalanceCheck.lambda$occupationRequest$32((String)sbizId, arg_0)).allMatch(k -> StringUtils.isNotEmpty((String)k.getEntryId()));
                            }
                        } else {
                            isWriteOffByEntry = Boolean.FALSE;
                        }
                        if (map.get("entryId") != null && isWriteOffByEntry.booleanValue()) {
                            String entryId = map.get("entryId").toString();
                            if (StringUtils.isEmpty((String)entryId)) {
                                ControlException.entryIdMustInput();
                            }
                            if (rentryBizIds.contains((String)bizId + "#" + entryId)) {
                                ControlException.errorSourceAmountParam();
                            }
                            rentryBizIds.add((String)bizId + "#" + entryId);
                            amounts.put(entryId, amount);
                            sourceamounts.put(bizId, amounts);
                        } else {
                            if (rBizIds.contains(bizId)) {
                                ControlException.errorSourceAmountParam();
                            }
                            rBizIds.add(bizId);
                            amounts.put(bizId, amount);
                            sourceamounts.put(bizId, amounts);
                        }
                        if (!isWriteOffByEntry.booleanValue() || map.get("entryId") != null) continue;
                        ControlException.entryIdMustInput();
                    }
                }
            }
            catch (KDBizException ex) {
                throw ex;
            }
            catch (Throwable e) {
                sourceamounts.clear();
                log.info("FIELD_SOURCE_AMOUNTS_ERROR", (Object)e);
                ControlException.erorrOther((Throwable)e);
            }
            if (periodMap == null) {
                ArrayList<BgControlRecord> allrecords = new ArrayList<BgControlRecord>();
                if (records != null) {
                    allrecords.addAll(records);
                }
                for (IControlParam param : controlParams) {
                    BgControlRecord r;
                    if (!param.isWriteOffs() || (r = this.createBgControlRecord(param)) == null) continue;
                    this.setWriteoffInfo(r, param);
                    allrecords.add(r);
                }
                periodMap = BgControlUtils.getRecordPeriod(allrecords, addNewOccupationRecordMap, false, bizIds, this.getParameter().getBizId(), periodMap, isReviewOcc, isReviewExec, isWriteOffByEntry);
            } else {
                periodMap = BgControlUtils.getRecordPeriod(null, addNewOccupationRecordMap, false, bizIds, this.getParameter().getBizId(), periodMap, isReviewOcc, isReviewExec, isWriteOffByEntry);
            }
            addNewOccupationRecordMap.clear();
            List<String> ctrlPeriodRange = this.calcPeriodRange(controlParam);
            requestValue = controlParam.getAmount();
            try {
                Map<String, Map<String, Map<String, ControlOccValue>>> _periodMap = periodMap;
                BgControlLogUtils.infoThread(this.getStats(), controlParam.isNeedLog(), () -> paramIndex + ". ctrlPeriodRange=" + JSONUtils.toString((Object)ctrlPeriodRange) + " bizIds=" + JSONUtils.toString((Object)bizIds) + " occupationRequest=" + JSONUtils.toString((Object)_periodMap));
            }
            catch (Throwable _periodMap) {
                // empty catch block
            }
            for (String bizId : bizIds) {
                if (isReviewOcc.booleanValue() && this.parameter.getBizId().equals(bizId)) continue;
                if (requestValue != null && requestValue.compareTo(controlParam.getAmount()) != 0 && BigDecimal.ZERO.compareTo(requestValue) >= 0) break;
                if (!bizId.equals(this.parameter.getBizId()) && records.stream().anyMatch(k -> bizId.equals(k.getBizId()) && "Execute".equals(k.getMemberNumber(SysDimensionEnum.ChangeType.getNumber()))) || !bizId.equals(this.parameter.getBizId()) && this.parameter.getDataManager() != null && this.parameter.getDataManager().getNegativeOcc() != null && this.parameter.getDataManager().getNegativeOcc().contains(BgControlUtils.getNegativeOccKey(this.parameter.getBizId(), controlParam.getBizModel().getKey()))) continue;
                if (hasNegativeOcc.contains(BgControlUtils.getNegativeOccKey(bizId, controlParam.getBizModel().getKey()))) {
                    if (!controlParam.isNeedLog()) continue;
                    log.info("hasNegativeOcc:" + BgControlUtils.getNegativeOccKey(bizId, controlParam.getBizModel().getKey()));
                    continue;
                }
                Boolean hasSourceAmount = false;
                HashMap writeOffMap = new HashMap();
                if (!bizId.equals(this.getParameter().getBizId()) && !sourceamounts.isEmpty() && !sourceamounts.containsKey(bizId)) continue;
                if (!bizId.equals(this.getParameter().getBizId()) && sourceamounts.get(bizId) != null) {
                    if (isWriteOffByEntry.booleanValue()) {
                        Map decimalMap = (Map)sourceamounts.get(bizId);
                        for (Map.Entry ery : decimalMap.entrySet()) {
                            writeOffMap.put(bizId + "#" + (String)ery.getKey(), ery.getValue());
                        }
                    } else {
                        thisRequestValue = (BigDecimal)((Map)sourceamounts.get(bizId)).get(bizId);
                        writeOffMap.put(bizId, thisRequestValue);
                    }
                    hasSourceAmount = true;
                } else {
                    thisRequestValue = requestValue;
                    writeOffMap.put(bizId, thisRequestValue);
                }
                if (periodMap == null) continue;
                if (nounitWriteSchemIds != null && !nounitWriteSchemIds.isEmpty()) {
                    log.info(JSON.toJSONString(nounitWriteSchemIds));
                }
                if (unitWriteOffIds != null && !unitWriteOffIds.isEmpty()) {
                    log.info(JSON.toJSONString(unitWriteOffIds));
                }
                if (!controlParam.isWriteOffs() && controlParam.getControlScheme() != null && controlParam.getControlScheme().getWriteOff() != null && !controlParam.getControlScheme().getWriteOff().getBills().isEmpty() ? nounitWriteSchemIds != null && nounitWriteSchemIds.get(controlParam.getBizModel().getKey()) != null && nounitWriteSchemIds.get(controlParam.getBizModel().getKey()).get(controlParam.getControlScheme().getDetailId()) != null && nounitWriteSchemIds.get(controlParam.getBizModel().getKey()).get(controlParam.getControlScheme().getDetailId()).contains(bizId) : unitWriteOffIds != null && unitWriteOffIds.get(controlParam.getBizModel().getKey()) != null && unitWriteOffIds.get(controlParam.getBizModel().getKey()).contains(bizId)) continue;
                block11: for (Map.Entry entry : writeOffMap.entrySet()) {
                    String currBizId = (String)entry.getKey();
                    if (periodMap.get(currBizId) == null) continue;
                    if (hasSourceAmount.booleanValue()) {
                        thisRequestValue = (BigDecimal)entry.getValue();
                        if (thisRequestValue == null) {
                            thisRequestValue = requestValue;
                        }
                    } else {
                        thisRequestValue = requestValue;
                    }
                    Iterator iterator = ctrlPeriodRange.iterator();
                    while (iterator.hasNext()) {
                        String period = (String)iterator.next();
                        if (BigDecimal.ZERO.compareTo(thisRequestValue) >= 0) continue block11;
                        if (!hasSourceAmount.booleanValue() && value != null) {
                            if (thisRequestValue.compareTo(value) >= 0) {
                                thisRequestValue = value;
                                sumApplyValues.put(memberKey, BigDecimal.ZERO);
                            } else {
                                sumApplyValues.put(memberKey, value.subtract(thisRequestValue));
                            }
                        }
                        if ((occValue = this.calcOccValue(controlParam, currBizId, period, periodMap)) == null || BigDecimal.ZERO.compareTo(occValue.getOccValue()) >= 0) continue;
                        deductValue = occValue.getOccValue().min(thisRequestValue);
                        mystats.addInfo("has occupation period = " + period + " bizid = " + bizId + " value = " + deductValue);
                        controlOccRecords.clear();
                        occValue.occupation(controlOccRecords, deductValue, controlParam);
                        for (ControlOccRecord occRecord : controlOccRecords) {
                            String periodKey;
                            BgControlRecord record = this.createBgControlRecord(controlParam);
                            if (occRecord.getAmount() != null) {
                                record.setBgMemberJson(occRecord.getAmount().getBgMemberJson());
                            }
                            record.setAmount(occRecord.getOccValue().negate());
                            record.setMember(ChangeTypeServiceHelper.loadChangeType((Map)ChangeTypeServiceHelper.getOccupation((BizModel)controlParam.getBizModel(), this.changeTypes)));
                            if (isWriteOffByEntry.booleanValue() && currBizId.contains("#")) {
                                String[] ids = currBizId.split("#");
                                record.setRefBizId(ids[0]);
                                record.setRefEntryId(ids[1]);
                            } else if (bizId.equals(controlParam.getBizId())) {
                                if (StringUtils.isNotEmpty((String)record.getEntryId())) {
                                    record.setRefEntryId(record.getEntryId());
                                }
                                record.setRefBizId(bizId);
                            } else {
                                record.setRefBizId(bizId);
                            }
                            record.setOccType(BgControlRecord.OccupationType.WOOCC.getNumber());
                            record.setWriteOffType(this.parameter.getControlManager().isOccupation() ? "Occupation" : "Execute");
                            if (occRecord.getAmount() != null) {
                                if (occRecord.getAmount().getReqOrgUnitOcc() != null) {
                                    record.setReqOrgUnit(occRecord.getAmount().getReqOrgUnitOcc());
                                }
                                if (occRecord.getAmount().getReqAccountOcc() != null) {
                                    record.setReqAccount(occRecord.getAmount().getReqAccountOcc());
                                }
                            }
                            if (periodMemberMap.containsKey(periodKey = record.getBizModel().getId() + "!" + period)) {
                                record.setOccPeriod(periodMemberMap.get(periodKey));
                            } else {
                                mystats.addInfo("no found period = " + periodKey);
                            }
                            addNewRecords.add(record);
                            occValue.addRecord(occRecord, record);
                            controlParam.setOccupation(true);
                        }
                        requestValue = requestValue.subtract(deductValue);
                        thisRequestValue = thisRequestValue.subtract(deductValue);
                    }
                }
            }
            controlParam.setAmend(requestValue);
        }
        if (!isRequest) {
            for (IControlParam controlParam : controlParams) {
                BgControlRecord record;
                if (!controlParam.isWriteOffs() || controlParam.getAmount().compareTo(BigDecimal.ZERO) == 0 || (record = this.createBgControlRecord(controlParam)) == null) continue;
                record.setOccType(BgControlRecord.OccupationType.WOOCC.getNumber());
                record.setMember(ChangeTypeServiceHelper.loadChangeType((Map)ChangeTypeServiceHelper.getOccupation((BizModel)controlParam.getBizModel(), this.changeTypes)));
                record.setRefEntryId(controlParam.getEntryId());
                if (controlParam.getControlType() == ControlTypeEnum.OCCUPATION) {
                    record.setMember(ChangeTypeServiceHelper.loadChangeType((Map)ChangeTypeServiceHelper.getOccupation((BizModel)controlParam.getBizModel(), this.changeTypes)));
                } else {
                    record.setMember(ChangeTypeServiceHelper.loadChangeType((Map)ChangeTypeServiceHelper.getExecuted((BizModel)controlParam.getBizModel(), this.changeTypes)));
                }
                addNewRecords.add(record);
            }
        }
        if (controlParams != null && !controlParams.isEmpty()) {
            BgControlLogUtils.infoThread(this.getStats(), controlParams.iterator().next().isNeedLog(), () -> "new-records = " + JSON.toJSONString((Object)addNewRecords));
        }
        if (isReviewOcc.booleanValue() || isReviewExec.booleanValue()) {
            log.info("addnewRecords:" + JSONUtils.toString(addNewRecords));
            this.diffCalControlRecod(records, addNewRecords, this.parameter.getControlManager().getDeductByEntry(), !isRequest);
        } else {
            this.secondWriteOffs(controlParams, records, addNewRecords);
            this.getBgControlRecords().addAll(addNewRecords);
        }
        if (isRequest && hasCurr) {
            String key;
            List occRecords;
            HashMap<String, List> occRecordMap = new HashMap<String, List>(records.size());
            for (BgControlRecord _record : records) {
                String occMemberKey;
                String periodNumber;
                if (_record.isDel().booleanValue()) continue;
                if (this.getParameter().getBizId().equals(_record.getBizId()) && StringUtils.isEmpty((String)_record.getRefBizId()) && "Occupation".equals(_record.getMemberNumber(SysDimensionEnum.ChangeType.getNumber()))) {
                    periodNumber = this.getPeriodNumberByBgControlRecord(_record);
                    occMemberKey = _record.getMemberKey(true) + periodNumber;
                    occRecords = occRecordMap.computeIfAbsent(occMemberKey, f -> Lists.newArrayList());
                    occRecords.add(_record);
                }
                if (!isReviewExec.booleanValue() || !this.getParameter().getBizId().equals(_record.getBizId()) || !StringUtils.equals((String)_record.getBizId(), (String)_record.getRefBizId()) || !"Occupation".equals(_record.getMemberNumber(SysDimensionEnum.ChangeType.getNumber()))) continue;
                periodNumber = this.getPeriodNumberByBgControlRecord(_record);
                occMemberKey = _record.getMemberKey(true) + periodNumber;
                occRecords = occRecordMap.computeIfAbsent(occMemberKey, f -> Lists.newArrayList());
                occRecords.add(_record);
            }
            for (BgControlRecord record : this.getBgControlRecords()) {
                if (!this.getParameter().getBizId().equals(record.getBizId()) || !StringUtils.equals((String)record.getBizId(), (String)record.getRefBizId()) || !"Occupation".equals(record.getMemberNumber(SysDimensionEnum.ChangeType.getNumber())) || record.isDel().booleanValue()) continue;
                String periodNumber = this.getPeriodNumberByBgControlRecord(record);
                String occMemberKey = record.getMemberKey(true) + periodNumber;
                occRecords = occRecordMap.computeIfAbsent(occMemberKey, f -> Lists.newArrayList());
                occRecords.add(record);
            }
            HashMap<String, BigDecimal> occRecordValueMap = new HashMap<String, BigDecimal>(occRecordMap.size());
            for (Map.Entry entry : occRecordMap.entrySet()) {
                key = (String)entry.getKey();
                List recordValue = (List)entry.getValue();
                BigDecimal occSumValue = occRecordValueMap.computeIfAbsent(key, f -> BigDecimal.ZERO);
                for (BgControlRecord record : recordValue) {
                    occSumValue = occSumValue.add(record.getAmount());
                }
                occRecordValueMap.put(key, occSumValue);
            }
            for (Map.Entry entry : occRecordValueMap.entrySet()) {
                key = (String)entry.getKey();
                BigDecimal occSum = (BigDecimal)entry.getValue();
                if (occSum.compareTo(BigDecimal.ZERO) == 0 || occRecordMap.get(key) == null) continue;
                BgControlRecord bgControlRecord = (BgControlRecord)((List)occRecordMap.get(key)).get(0);
                BgControlRecord tmpRecord = BgControlRecord.createFromControlParam(bgControlRecord, this.createTime, this.getParameter().getOperation());
                tmpRecord.setId(DBServiceHelper.genGlobalLongId());
                tmpRecord.setRefBizId(this.getParameter().getBizId());
                if (StringUtils.isNotEmpty((String)tmpRecord.getEntryId())) {
                    tmpRecord.setRefEntryId(tmpRecord.getEntryId());
                }
                tmpRecord.setAmount(occSum.negate());
                tmpRecord.setRequestId(RequestContext.get().getTraceId());
                tmpRecord.setOccType(BgControlRecord.OccupationType.WOOCC.getNumber());
                tmpRecord.setWriteOffType("Execute");
                if (bgControlRecord.getBizModel().isEBByModel()) {
                    tmpRecord.setOccPeriod(bgControlRecord.getMember(SysDimensionEnum.Period.getNumber()));
                } else {
                    tmpRecord.setOccPeriod(bgControlRecord.getMember(SysDimensionEnum.BudgetPeriod.getNumber()));
                }
                if (currRecords != null) {
                    currRecords.add(tmpRecord);
                }
                this.getBgControlRecords().add(tmpRecord);
            }
        }
        BgControlLogUtils.info(this.getStats(), true, mystats.toString());
    }

    private String getPeriodNumberByBgControlRecord(BgControlRecord _record) {
        String periodNumber = _record.getBizModel().isEBByModel() ? _record.getMemberNumber(SysDimensionEnum.Period.getNumber()) : _record.getMemberNumber(SysDimensionEnum.BudgetPeriod.getNumber());
        if (_record.getOccPeriod() != null) {
            periodNumber = _record.getOccPeriodNumber();
        }
        return periodNumber;
    }

    private Map<String, Member> getPeriodMemberMap(Collection<BgControlRecord> records) {
        HashMap<String, Member> periodMemberMap = new HashMap<String, Member>(records.size());
        if (records != null) {
            Iterator<BgControlRecord> iterator = records.iterator();
            while (iterator.hasNext()) {
                BgControlRecord record;
                String periodNumberKey = (record = iterator.next()).getBizModel().isEBByModel() ? SysDimensionEnum.Period.getNumber() : SysDimensionEnum.BudgetPeriod.getNumber();
                Member member = record.getMember(periodNumberKey);
                if (member == null) continue;
                periodMemberMap.put(record.getBizModel().getId() + "!" + member.getNumber(), member);
            }
        }
        return periodMemberMap;
    }

    private ControlOccValue calcOccValue(IControlParam param, String bizId, String period, Map<String, Map<String, Map<String, ControlOccValue>>> periodMap) {
        if (param != null && periodMap != null && periodMap.get(bizId) != null && period != null) {
            Map<String, ControlOccValue> periodValues;
            String occKey;
            Map<String, Map<String, ControlOccValue>> memberValueMap = periodMap.get(bizId);
            String memberKey = param.getMemberKey(false, true, param.getBizModel().getDimensions());
            String exeKey = SysDimensionEnum.ChangeType.getNumber() + "_" + "Execute";
            if ((memberKey = memberKey.replaceAll(exeKey, occKey = SysDimensionEnum.ChangeType.getNumber() + "_" + "Occupation")) != null && memberValueMap.get(memberKey) != null && (periodValues = memberValueMap.get(memberKey)).get(period) != null) {
                return periodValues.get(period);
            }
        }
        return null;
    }

    private List<String> calcPeriodRange(IControlParam controlParam) {
        String currperiod;
        HashSet<String> periodRange = new HashSet<String>();
        if (controlParam == null) {
            return new ArrayList<String>();
        }
        if (controlParam.getBgPeriod() != null) {
            for (List<String> periods : controlParam.getBgPeriod()) {
                periodRange.add(periods.get(1));
            }
        }
        String string = currperiod = controlParam.getPeriod(false) != null ? controlParam.getPeriod(false).getNumber() : null;
        if (currperiod != null) {
            periodRange.remove(currperiod);
        }
        ArrayList<String> sortPeriodRange = new ArrayList<String>(periodRange);
        Collections.sort(sortPeriodRange);
        sortPeriodRange.add(0, currperiod);
        return sortPeriodRange;
    }

    protected boolean hasCurrOccupation(Collection<BgControlRecord> records) {
        if (records == null || records.isEmpty()) {
            return false;
        }
        for (BgControlRecord record : records) {
            if (!this.getParameter().getBizId().equals(record.getBizId()) || !"Occupation".equals(record.getMemberNumber(SysDimensionEnum.ChangeType.getNumber()))) continue;
            return true;
        }
        return false;
    }

    protected void occupationRequestByEntry(Collection<IControlParam> executes, Collection<String> bizIds, Collection<BgControlRecord> records) {
    }

    /*
     * WARNING - void declaration
     */
    protected void diffCalControlRecod(Collection<BgControlRecord> records, List<BgControlRecord> addNewRecords, Boolean deductByEntry, Boolean isOcc) {
        ArrayList<BgControlRecord> dValueRecords = new ArrayList<BgControlRecord>(16);
        if (records.stream().anyMatch(k -> this.parameter.getBizId().equals(k.getBizId()) && (StringUtils.isEmpty((String)k.getEntryId()) || "0".equals(k.getEntryId()))) || addNewRecords.stream().anyMatch(k -> StringUtils.isEmpty((String)k.getRefBizId()) && (StringUtils.isEmpty((String)k.getEntryId()) || "0".equals(k.getEntryId())) || StringUtils.isNotEmpty((String)k.getRefBizId()) && StringUtils.isEmpty((String)k.getRefEntryId()))) {
            deductByEntry = false;
        }
        if (deductByEntry.booleanValue()) {
            ArrayList<BgControlRecord> delEntrys;
            Map<String, List<BgControlRecord>> selfWriteOffs = records.stream().filter(k -> StringUtils.isNotEmpty((String)k.getRefBizId()) && this.parameter.getBizId().equals(k.getRefBizId()) && k.isOccExe(isOcc) != false).collect(Collectors.groupingBy(k -> k.getBizModel().getKey() + "#" + k.getRefBizId() + "#" + k.getRefEntryId()));
            Map<String, List<BgControlRecord>> occgroupingByEntryId = records.stream().filter(k -> this.parameter.getBizId().equals(k.getBizId()) && StringUtils.isEmpty((String)k.getRefBizId()) && k.isOccExe(isOcc) != false).collect(Collectors.groupingBy(k -> k.getBizModel().getKey() + "#" + k.getBizId() + "#" + k.getEntryId()));
            Set addOccRecords = addNewRecords.stream().filter(k -> this.parameter.getBizId().equals(k.getBizId()) && StringUtils.isEmpty((String)k.getRefBizId()) && k.isOccExe(isOcc) != false).collect(Collectors.toSet());
            for (BgControlRecord bgControlRecord : addOccRecords) {
                if (occgroupingByEntryId.containsKey(bgControlRecord.getBizModel().getKey() + "#" + bgControlRecord.getBizId() + "#" + bgControlRecord.getEntryId())) {
                    void var12_28;
                    List<BgControlRecord> addrecords = occgroupingByEntryId.get(bgControlRecord.getBizModel().getKey() + "#" + bgControlRecord.getBizId() + "#" + bgControlRecord.getEntryId());
                    BigDecimal bigDecimal = BigDecimal.ZERO;
                    delEntrys = new ArrayList<BgControlRecord>(16);
                    Iterator iterator = addrecords.iterator();
                    while (iterator.hasNext()) {
                        BgControlRecord oldrecord = (BgControlRecord)iterator.next();
                        if (oldrecord.getMemberKey().equals(bgControlRecord.getMemberKey())) {
                            BigDecimal bigDecimal2 = var12_28.add(oldrecord.getAmount());
                            continue;
                        }
                        oldrecord.setIsDel(true);
                        oldrecord.setAmount(oldrecord.getAmount().negate());
                        delEntrys.add(oldrecord);
                    }
                    if (selfWriteOffs.containsKey(bgControlRecord.getBizModel().getKey() + "#" + bgControlRecord.getBizId() + "#" + bgControlRecord.getEntryId())) {
                        BigDecimal writeOffAmounts;
                        if (!delEntrys.isEmpty()) {
                            ControlException.errorDelEntryCheck();
                        }
                        if ((writeOffAmounts = selfWriteOffs.get(bgControlRecord.getBizModel().getKey() + "#" + bgControlRecord.getBizId() + "#" + bgControlRecord.getEntryId()).stream().map(AbstractBgControlRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add)) != null && bgControlRecord.getAmount().add(writeOffAmounts).compareTo(BigDecimal.ZERO) < 0) {
                            ControlException.errorAmountCheck((boolean)isOcc);
                        }
                    }
                    if (bgControlRecord.getAmount().compareTo((BigDecimal)var12_28) != 0) {
                        bgControlRecord.setAmount(bgControlRecord.getAmount().subtract((BigDecimal)var12_28));
                        bgControlRecord.setOccType(isOcc != false ? BgControlRecord.OccupationType.REVOCC.getNumber() : BgControlRecord.OccupationType.REVEXEC.getNumber());
                        dValueRecords.add(bgControlRecord);
                    }
                    if (delEntrys.isEmpty()) continue;
                    dValueRecords.addAll(delEntrys);
                    continue;
                }
                dValueRecords.add(bgControlRecord);
            }
            Set set = addNewRecords.stream().filter(k -> this.parameter.getBizId().equals(k.getBizId()) && StringUtils.isNotEmpty((String)k.getRefBizId())).collect(Collectors.toSet());
            Map<String, List<BgControlRecord>> map = records.stream().filter(k -> this.parameter.getBizId().equals(k.getBizId()) && StringUtils.isNotEmpty((String)k.getRefBizId())).collect(Collectors.groupingBy(k -> k.getBizModel().getKey() + "#" + k.getRefBizId() + "#" + k.getRefEntryId() + "#" + k.getWriteOffTypeOrDefault()));
            for (BgControlRecord bgControlRecord : set) {
                if (map.containsKey(bgControlRecord.getBizModel().getKey() + "#" + bgControlRecord.getRefBizId() + "#" + bgControlRecord.getRefEntryId() + "#" + bgControlRecord.getWriteOffTypeOrDefault())) {
                    delEntrys = new ArrayList(16);
                    List hisWriteOffs = map.getOrDefault(bgControlRecord.getBizModel().getKey() + "#" + bgControlRecord.getRefBizId() + "#" + bgControlRecord.getRefEntryId() + "#" + bgControlRecord.getWriteOffTypeOrDefault(), new ArrayList());
                    BigDecimal hisWriteOffAmount = BigDecimal.ZERO;
                    for (BgControlRecord hisWriteOff : hisWriteOffs) {
                        if (hisWriteOff.getMemberKey().equals(bgControlRecord.getMemberKey())) {
                            hisWriteOffAmount = hisWriteOffAmount.add(hisWriteOff.getAmount());
                            continue;
                        }
                        hisWriteOff.setIsDel(true);
                        hisWriteOff.setAmount(hisWriteOff.getAmount().negate());
                        delEntrys.add(hisWriteOff);
                    }
                    if (bgControlRecord.getAmount().compareTo(hisWriteOffAmount) != 0) {
                        bgControlRecord.setAmount(bgControlRecord.getAmount().subtract(hisWriteOffAmount));
                        bgControlRecord.setOccType(isOcc != false ? BgControlRecord.OccupationType.REVOCC.getNumber() : BgControlRecord.OccupationType.REVEXEC.getNumber());
                        dValueRecords.add(bgControlRecord);
                    }
                    if (delEntrys.isEmpty()) continue;
                    dValueRecords.addAll(delEntrys);
                    continue;
                }
                dValueRecords.add(bgControlRecord);
            }
            if (this.parameter.getControlManager().isStandard() || this.getParameter().getControlManager().isDelentry().booleanValue()) {
                for (Map.Entry entry : occgroupingByEntryId.entrySet()) {
                    if (!addOccRecords.stream().noneMatch(k -> ((String)entry.getKey()).equals(k.getBizModel().getKey() + "#" + k.getBizId() + "#" + k.getEntryId()))) continue;
                    ((List)entry.getValue()).forEach(k -> {
                        if (records.stream().anyMatch(n -> StringUtils.isNotEmpty((String)n.getRefBizId()) && this.parameter.getBizId().equals(n.getRefBizId()) && n.getEntryId().equals(k.getEntryId()))) {
                            ControlException.errordeleteWriteoffs();
                        }
                        k.setIsDel(true);
                        k.setAmount(k.getAmount().negate());
                    });
                    dValueRecords.addAll((Collection)entry.getValue());
                }
                for (Map.Entry entry : map.entrySet()) {
                    if (!set.stream().noneMatch(k -> ((String)entry.getKey()).equals(k.getBizModel().getKey() + "#" + k.getRefBizId() + "#" + k.getRefEntryId() + "#" + k.getWriteOffTypeOrDefault()))) continue;
                    ((List)entry.getValue()).forEach(k -> {
                        k.setIsDel(true);
                        k.setAmount(k.getAmount().negate());
                    });
                    dValueRecords.addAll((Collection)entry.getValue());
                }
            }
            if (!dValueRecords.isEmpty()) {
                HashSet<String> hasMerged = new HashSet<String>(16);
                for (IControlParam controlParam : this.controlParams) {
                    BigDecimal mergeAmend;
                    Set amendRecords;
                    if (!controlParam.isWriteOffs()) {
                        amendRecords = dValueRecords.stream().filter(k -> k.getBizModel().getKey().equals(controlParam.getBizModel().getKey()) && k.getEntryId().equals(controlParam.getEntryId()) && (StringUtils.isEmpty((String)k.getRefBizId()) || StringUtils.isNotEmpty((String)k.getRefBizId()) && k.getOccPeriodId() != null && k.getOccPeriodId() != 0L)).collect(Collectors.toSet());
                        if (amendRecords == null || amendRecords.isEmpty()) continue;
                        mergeAmend = amendRecords.stream().map(AbstractBgControlRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        controlParam.setAmend(mergeAmend);
                        continue;
                    }
                    amendRecords = dValueRecords.stream().filter(k -> k.getBizModel().getKey().equals(controlParam.getBizModel().getKey()) && k.getEntryId().equals(controlParam.getEntryId()) && StringUtils.isNotEmpty((String)k.getRefBizId()) && k.getRefBizId().equals(controlParam.getRefBizId()) && (k.getOccPeriodId() == null || k.getOccPeriodId() == 0L)).collect(Collectors.toSet());
                    if (amendRecords == null || amendRecords.isEmpty()) continue;
                    mergeAmend = amendRecords.stream().map(AbstractBgControlRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    controlParam.setAmend(mergeAmend);
                    hasMerged.add(controlParam.getRefBizId() + "#" + controlParam.getAcMemberKey());
                }
                this.getBgControlRecords().addAll(dValueRecords);
            } else {
                this.controlParams.forEach(k -> k.setAmend(BigDecimal.ZERO));
            }
        } else {
            Map<String, List<BgControlRecord>> historyOccRecords = records.stream().filter(k -> this.parameter.getBizId().equals(k.getBizId()) && StringUtils.isEmpty((String)k.getRefBizId()) && k.isOccExe(isOcc) != false).collect(Collectors.groupingBy(k -> k.getMemberKey()));
            Map<String, List<BgControlRecord>> selfWriteOffs = records.stream().filter(k -> StringUtils.isNotEmpty((String)k.getRefBizId()) && this.parameter.getBizId().equals(k.getRefBizId())).collect(Collectors.groupingBy(k -> BgControlUtils.getWriteOffKey(k)));
            for (Map.Entry<String, List<BgControlRecord>> entry : historyOccRecords.entrySet()) {
                List list = addNewRecords.stream().filter(k -> k.getMemberKey().equals(currRecord.getKey()) && StringUtils.isEmpty((String)k.getRefBizId())).collect(Collectors.toList());
                if (!list.isEmpty()) {
                    BigDecimal writeOffAmounts;
                    BigDecimal historyAmount = entry.getValue().stream().map(AbstractBgControlRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal bigDecimal = list.stream().map(AbstractBgControlRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (selfWriteOffs.containsKey(entry.getKey()) && (writeOffAmounts = selfWriteOffs.get(entry.getKey()).stream().map(AbstractBgControlRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add)) != null && bigDecimal.add(writeOffAmounts).compareTo(BigDecimal.ZERO) < 0) {
                        ControlException.errorAmountCheck((boolean)isOcc);
                    }
                    if (bigDecimal.compareTo(historyAmount) == 0) continue;
                    BgControlRecord addNewRecord = ((BgControlRecord)list.get(0)).getClone();
                    addNewRecord.setOnlyCheck(false);
                    addNewRecord.setAmount(bigDecimal.subtract(historyAmount));
                    addNewRecord.setOccType(isOcc != false ? BgControlRecord.OccupationType.REVOCC.getNumber() : BgControlRecord.OccupationType.REVEXEC.getNumber());
                    dValueRecords.add(addNewRecord);
                    continue;
                }
                if (!this.parameter.getControlManager().isStandard() && !this.getParameter().getControlManager().isDelentry().booleanValue()) continue;
                entry.getValue().forEach(k -> {
                    if (records.stream().anyMatch(n -> StringUtils.isNotEmpty((String)n.getRefBizId()) && k.getBizId().equals(n.getRefBizId()) && BgControlUtils.getWriteOffKey(n).equals(k.getMemberKey()))) {
                        ControlException.errordeleteWriteoffs();
                    }
                    k.setIsDel(true);
                    k.setAmount(k.getAmount().negate());
                });
                dValueRecords.addAll((Collection)entry.getValue());
            }
            Map<String, List<BgControlRecord>> historyWriteOffRecords = records.stream().filter(k -> this.parameter.getBizId().equals(k.getBizId()) && StringUtils.isNotEmpty((String)k.getRefBizId())).collect(Collectors.groupingBy(k -> k.getRefBizId() + "#" + k.getWriteOffTypeOrDefault() + "#" + k.getMemberKey()));
            for (Map.Entry<String, List<BgControlRecord>> entry : historyWriteOffRecords.entrySet()) {
                List collect = addNewRecords.stream().filter(k -> StringUtils.isNotEmpty((String)k.getRefBizId()) && (k.getRefBizId() + "#" + k.getWriteOffTypeOrDefault() + "#" + k.getMemberKey()).equals(currRecord.getKey())).collect(Collectors.toList());
                if (!collect.isEmpty()) {
                    BigDecimal bigDecimal = entry.getValue().stream().map(AbstractBgControlRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal newAmount = collect.stream().map(AbstractBgControlRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (newAmount.compareTo(bigDecimal) == 0) continue;
                    BgControlRecord addNewRecord = ((BgControlRecord)collect.get(0)).getClone();
                    addNewRecord.setAmount(newAmount.subtract(bigDecimal));
                    addNewRecord.setOccType(BgControlRecord.OccupationType.WOOCC.getNumber());
                    dValueRecords.add(addNewRecord);
                    continue;
                }
                if (!this.parameter.getControlManager().isStandard() && !this.getParameter().getControlManager().isDelentry().booleanValue()) continue;
                entry.getValue().forEach(k -> {
                    boolean isDel = false;
                    if (this.parameter.getControlManager().isOccupation() ? k.getWriteOffTypeOrDefault().equals("Occupation") : k.getWriteOffTypeOrDefault().equals("Execute")) {
                        isDel = true;
                    }
                    if (k.getWriteOffType().startsWith("writeoffscheme") && addNewRecords.stream().anyMatch(j -> j.getBizModel().getKey().equals(k.getBizModel().getKey()) && j.getBizId().equals(k.getBizId()) && k.getRefBizId().equals(j.getRefBizId()) && !j.getWriteOffType().startsWith("writeoffscheme"))) {
                        isDel = true;
                    }
                    if (!k.getWriteOffType().startsWith("writeoffscheme") && addNewRecords.stream().anyMatch(j -> j.getBizModel().getKey().equals(k.getBizModel().getKey()) && j.getBizId().equals(k.getBizId()) && k.getRefBizId().equals(j.getRefBizId()) && j.getWriteOffType().startsWith("writeoffscheme"))) {
                        isDel = true;
                    }
                    if ("writeoffschemeExecute".equals(k.getWriteOffType()) && "Execute".equals(k.getMemberNumber(SysDimensionEnum.ChangeType.getNumber())) && this.parameter.getControlManager().isExecute() && this.controlParams.stream().noneMatch(l -> k.getBizModel().getKey().equals(l.getBizModel().getKey()) && l.isWriteOffs() && k.getRefBizId().equals(l.getRefBizId()))) {
                        isDel = true;
                    }
                    if (isDel) {
                        k.setIsDel(true);
                        k.setAmount(k.getAmount().negate());
                        this.getBgControlRecords().add((BgControlRecord)k);
                    }
                });
            }
            for (BgControlRecord bgControlRecord : addNewRecords) {
                if ((!StringUtils.isEmpty((String)bgControlRecord.getRefBizId()) || historyOccRecords.containsKey(bgControlRecord.getMemberKey())) && (!StringUtils.isNotEmpty((String)bgControlRecord.getRefBizId()) || historyWriteOffRecords.containsKey(bgControlRecord.getRefBizId() + "#" + bgControlRecord.getWriteOffTypeOrDefault() + "#" + bgControlRecord.getMemberKey())) || bgControlRecord.getAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                dValueRecords.add(bgControlRecord);
            }
            if (!dValueRecords.isEmpty()) {
                HashSet<String> hashSet = new HashSet<String>(16);
                for (IControlParam controlParam : this.controlParams) {
                    Set amendRecords;
                    String string = BgControlUtils.getMemberKey(controlParam, false, true, false, controlParam.getBizModel().getDimensions());
                    if (!controlParam.isWriteOffs()) {
                        amendRecords = dValueRecords.stream().filter(k -> ignChangeTypeKey != null && ignChangeTypeKey.equals(BgControlUtils.getMemberKey(k, true, false, k.getBizModel().getDimensions())) && (StringUtils.isEmpty((String)k.getRefBizId()) || StringUtils.isNotEmpty((String)k.getRefBizId()) && k.getOccPeriodId() != null && k.getOccPeriodId() != 0L)).collect(Collectors.toSet());
                        Set delRecords = this.getBgControlRecords().stream().filter(k -> k.isDel() != false && ignChangeTypeKey.equals(BgControlUtils.getMemberKey(k, true, false, k.getBizModel().getDimensions())) && StringUtils.isNotEmpty((String)k.getRefBizId()) && k.getOccPeriodId() != null && k.getOccPeriodId() != 0L).collect(Collectors.toSet());
                        if (delRecords != null && !delRecords.isEmpty()) {
                            amendRecords.addAll(delRecords);
                        }
                        if (amendRecords != null && !amendRecords.isEmpty()) {
                            if (!hashSet.contains(string)) {
                                BigDecimal mergeAmend = amendRecords.stream().map(AbstractBgControlRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                                controlParam.setAmend(mergeAmend);
                                hashSet.add(string);
                                continue;
                            }
                            controlParam.setAmend(BigDecimal.ZERO);
                            continue;
                        }
                        controlParam.setAmend(BigDecimal.ZERO);
                        continue;
                    }
                    amendRecords = dValueRecords.stream().filter(k -> StringUtils.isNotEmpty((String)k.getRefBizId()) && k.getRefBizId().equals(controlParam.getRefBizId()) && ignChangeTypeKey != null && ignChangeTypeKey.equals(BgControlUtils.getMemberKey(k, true, false, k.getBizModel().getDimensions())) && (k.getOccPeriodId() == null || k.getOccPeriodId() == 0L)).collect(Collectors.toSet());
                    if (amendRecords != null && !amendRecords.isEmpty()) {
                        if (!hashSet.contains(controlParam.getRefBizId() + "#" + controlParam.getAcMemberKey())) {
                            BigDecimal mergeAmend = amendRecords.stream().map(AbstractBgControlRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                            controlParam.setAmend(mergeAmend);
                            hashSet.add(controlParam.getRefBizId() + "#" + controlParam.getAcMemberKey());
                            continue;
                        }
                        controlParam.setAmend(BigDecimal.ZERO);
                        continue;
                    }
                    controlParam.setAmend(BigDecimal.ZERO);
                }
                this.getBgControlRecords().addAll(dValueRecords);
            } else {
                this.controlParams.forEach(k -> k.setAmend(BigDecimal.ZERO));
            }
        }
    }

    private void secondWriteOffs(Collection<IControlParam> cps, Collection<BgControlRecord> records, List<BgControlRecord> addNewRecords) {
        block0: for (IControlParam controlParam : cps) {
            if (!controlParam.isWriteOffs()) continue;
            String ignChangeTypeKey = BgControlUtils.getMemberKey(controlParam, false, true, false, controlParam.getBizModel().getDimensions());
            Set collect = records.stream().filter(k -> k.getBizId().equals(this.getParameter().getBizId()) && StringUtils.isNotEmpty((String)k.getRefBizId()) && k.getRefBizId().equals(controlParam.getRefBizId()) && ignChangeTypeKey.equals(BgControlUtils.getMemberKey(k, true, false, k.getBizModel().getDimensions())) && k.getEntryId() != null && k.getEntryId().equals(controlParam.getEntryId())).collect(Collectors.toSet());
            if (collect == null || collect.isEmpty()) continue;
            BigDecimal amount = collect.stream().map(AbstractBgControlRecord::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Iterator<BgControlRecord> iterator = addNewRecords.iterator();
            while (iterator.hasNext()) {
                BgControlRecord rd = iterator.next();
                if (!StringUtils.isNotEmpty((String)rd.getRefBizId()) || !rd.getRefBizId().equals(controlParam.getRefBizId()) || !ignChangeTypeKey.equals(BgControlUtils.getMemberKey(rd, true, false, rd.getBizModel().getDimensions())) || rd.getEntryId() == null || !rd.getEntryId().equals(controlParam.getEntryId())) continue;
                if (rd.getAmount().compareTo(amount) == 0) {
                    iterator.remove();
                } else {
                    rd.setAmount(rd.getAmount().subtract(amount));
                }
                controlParam.setAmend(rd.getAmount().subtract(amount));
                continue block0;
            }
        }
    }

    private static /* synthetic */ boolean lambda$occupationRequest$32(String sbizId, BgControlRecord k) {
        return k.getBizId().equals(sbizId) && StringUtils.isEmpty((String)k.getRefBizId());
    }
}

