/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.calc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.OlapServerRuntimeException;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.expr.business.AggregateExpr;
import kd.epm.eb.business.expr.command.ScriptCommand;
import kd.epm.eb.business.expr.face.IExpress;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.enums.BgControlPeriodTypeEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.BgDataUtils;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DimMembers;
import kd.epm.eb.common.utils.DynamicObjectUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.control.BgContParamUtils;
import kd.epm.eb.common.utils.control.ConditionUtils;
import kd.epm.eb.common.utils.lock.LockHandler;
import kd.epm.eb.common.utils.obj.ObjectUtils;
import kd.epm.eb.common.utils.obj.ObjectValueToMap;
import kd.epm.eb.control.eums.ControlTypeEnum;
import kd.epm.eb.control.face.IBatchControlParameter;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.CalcMemberParameter;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.impl.model.BgControlSetting;
import kd.epm.eb.control.impl.model.BudgetBalance;
import kd.epm.eb.control.impl.model.ControlParam;
import kd.epm.eb.control.utils.BgControlLogAddUtils;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlParamUtils;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgControlRuleUtils;
import kd.epm.eb.control.utils.BgControlSchemeUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.OQLBuilder;
import kd.epm.eb.control.utils.WriteOffsUtils;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.ebBusiness.sql.MDResultSet;
import kd.epm.eb.ebBusiness.sql.SQLBuilder;
import kd.epm.eb.olap.OlapServiceCaller;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.utils.KDOlapRequestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class CalcBalance
implements Runnable,
Callable<Collection<IControlParam>> {
    private static final Log log = LogFactory.getLog(CalcBalance.class);
    private Integer maxLength = null;
    private LockHandler handler = null;
    private IControlParameter parameter = null;
    private BgControlData controlData = null;
    private Collection<IControlParam> controlParams = new LinkedList<IControlParam>();
    private Map<Long, List<Map<String, Map<String, kd.epm.eb.common.model.Member>>>> members = null;

    public Integer getMaxLength() {
        if (this.maxLength == null) {
            this.maxLength = BgControlLogUtils.getLogMaxLength();
        }
        return this.maxLength;
    }

    public LockHandler getHandler() {
        return this.handler;
    }

    protected IControlParameter getParameter() {
        return this.parameter;
    }

    protected BgControlData getControlData() {
        return this.controlData;
    }

    public CalcBalance(IControlParameter parameter, BgControlData controlData, LockHandler handler) {
        this.parameter = parameter;
        this.controlData = controlData;
        this.handler = handler;
    }

    public Collection<IControlParam> getControlParams() {
        return this.controlParams;
    }

    @Override
    public Collection<IControlParam> call() {
        Collection<IControlParam> result = null;
        try {
            result = this.calc();
        }
        catch (Throwable ex) {
            log.error(ex);
            throw ex;
        }
        return result;
    }

    public Collection<IControlParam> queryBudget() {
        Collection<IControlParam> result = null;
        try {
            result = this.calc();
        }
        catch (Throwable ex) {
            log.error(ex);
            throw ex;
        }
        return result;
    }

    public Collection<IControlParam> queryMemberBudget() {
        return this.calcMember();
    }

    public Map<String, Map<String, Map<String, String>>> queryOrgMembers() {
        if (this.getParameter() == null || this.getControlData() == null) {
            return null;
        }
        this.filterControlDims();
        return this.builderOrgParams();
    }

    private void filterControlDims() {
        for (BizModel bizModel : this.getControlData().getBizModels().values()) {
            if (bizModel.getDimensions() == null || bizModel.getDimensions().isEmpty()) {
                List dimensions = BgDimensionServiceHelper.getDimensionByModel((BizModel)bizModel, (boolean)false);
                dimensions = bizModel.filterControlDims(dimensions);
                bizModel.setDimension(dimensions);
            }
            this.getParameter().getDataManager().getModel().put(bizModel.getKey(), bizModel);
        }
    }

    public Collection<IControlParam> queryDimensionMember() {
        if (this.getParameter() == null || this.getControlData() == null) {
            return null;
        }
        this.filterControlDims();
        this.checkControlManageId();
        this.getControlParams().addAll(this.builderParams());
        this.checkControlParams(this.getControlData().getBizModels(), this.getControlParams());
        return this.getControlParams();
    }

    private void checkControlManageId() {
        for (BizModel bizModel : this.getControlData().getBizModels().values()) {
            if (bizModel.isEBByModel() || bizModel.getControlManagerId() != null && bizModel.getControlManagerId() != 0L) continue;
            ControlException.errorNoControlDimension();
        }
    }

    @Override
    public void run() {
    }

    public void beforeCalc() {
        if (this.getParameter() == null || this.getControlData() == null) {
            return;
        }
        this.getControlData().getStats().add("begin calc Balance.");
        this.filterControlDims();
        this.checkControlManageId();
        this.getControlData().getStats().add("end filterControlDims&checkControlManageId.");
        this.getControlParams().addAll(this.builderParams());
        this.getControlData().getStats().add("end builder params.");
        this.buildNegativeOcc();
        if (WriteOffsUtils.verifyWriteOffs(this.getParameter())) {
            this.getControlParams().addAll(WriteOffsUtils.get().builderParams(this.getParameter(), this.getControlData(), this.getControlParams()));
            this.getControlData().getStats().add("end builder writeOffs params.");
        }
        this.checkControlParams(this.getControlData().getBizModels(), this.getControlParams());
        this.members = this.builderMembers(this.getControlData().getBizModels(), this.getControlParams());
        if (!this.getControlParams().isEmpty()) {
            BgControlLogUtils.info(log, this.getControlParams().iterator().next().isNeedLog(), JSONUtils.toString(this.members));
        }
        this.getControlData().getStats().add("end builderMembers.");
    }

    private void buildNegativeOcc() {
        HashSet<String> negativeOcc = new HashSet<String>(16);
        if (this.getParameter().getControlManager().isOccupation()) {
            if (this.getControlParams() != null && this.getParameter().getControlManager().isNegativeOcc()) {
                HashMap<Long, Map> occvalues = new HashMap<Long, Map>(10);
                for (IControlParam iControlParam : this.getControlParams()) {
                    String memberKey;
                    if (iControlParam.isOnlyCheck() || iControlParam.isWriteOffs() || iControlParam.getBizModel() == null || iControlParam.getAmount() == null) continue;
                    Map mvalue = occvalues.computeIfAbsent(iControlParam.getBizModel().getKey(), f -> new HashMap(16));
                    if (mvalue.get(memberKey = iControlParam.getMemberKey(false, false, iControlParam.getBizModel().getDimensions())) != null) {
                        mvalue.put(memberKey, ((BigDecimal)mvalue.get(memberKey)).add(iControlParam.getAmount()));
                        continue;
                    }
                    mvalue.put(memberKey, iControlParam.getAmount());
                }
                block1: for (Map.Entry entry : occvalues.entrySet()) {
                    for (BigDecimal e : ((Map)entry.getValue()).values()) {
                        if (e == null || e.compareTo(BigDecimal.ZERO) >= 0) continue;
                        negativeOcc.add(BgControlUtils.getNegativeOccKey(this.getParameter().getBizId(), (Long)entry.getKey()));
                        continue block1;
                    }
                }
            }
        } else if (this.getParameter().getControlManager().isExecute()) {
            List<BgControlRecord> records = BgControlRecordUtils.query(this.getParameter().getBizId(), this.getControlData().getBizModels());
            BgControlUtils.buildHasNegativeOcc(records, negativeOcc);
        }
        log.info("budget-control-log : NegativeOcc:" + JSONUtils.toString(negativeOcc));
        this.getParameter().getDataManager().setNegativeOcc(negativeOcc);
    }

    protected Collection<IControlParam> calc() {
        if (this.getParameter() == null || this.getControlData() == null) {
            return this.getControlParams();
        }
        this.beforeCalc();
        if (this.getHandler() != null) {
            this.getHandler().tryLock();
        }
        return this.lockDo();
    }

    public Collection<IControlParam> lockDo() {
        long st = System.currentTimeMillis();
        this.aggregate(this.getControlParams(), this.members);
        this.getControlData().getStats().add("end aggregate.");
        this.queryOlap(this.getControlData().getBizModels(), this.members);
        this.getControlData().getStats().add("end calc Balance.");
        Collection<IControlParam> params = this.getControlParams();
        if (params != null && !params.isEmpty() && this.getControlData().getBizOrgUnit() != null) {
            boolean[] _param = BgContParamUtils.getManagerParam((String)this.getParameter().getEntityNumber(), (Long)this.getControlData().getBizOrgUnit().getOrgId());
            boolean isCheckPermission = BgContParamUtils.isShowCheckMemPermission((boolean[])_param);
            for (IControlParam param : params) {
                param.setCheckPermission(isCheckPermission);
            }
            st = System.currentTimeMillis() - st;
            BgControlLogUtils.info(this.getControlData().getStats(), params.iterator().next().isNeedLog(), "budget-control-log : use_time_lockDo:" + st);
        }
        return params;
    }

    protected Map<String, Map<String, Map<String, String>>> builderOrgParams() {
        Map<String, Collection<BgControlScheme>> schemes = BgControlSchemeUtils.query(this.getControlData(), this.getParameter().getEntityNumber(), true);
        if (schemes == null || schemes.isEmpty()) {
            BgControlLogAddUtils.addDetailModel(this.getControlData().getStats(), this.getControlData().getBizModels().values());
            ControlException.notDimensionMappings((String)this.getParameter().getEntityNumber());
            return null;
        }
        DynamicObject model = null;
        HashMap<String, Map<String, Map<String, String>>> map = new HashMap<String, Map<String, Map<String, String>>>(2);
        OQLBuilder oqlBuilder = new OQLBuilder();
        HashSet hasBizModel = new HashSet(10);
        BizModel bizModel = null;
        for (Map.Entry<String, Collection<BgControlScheme>> entry : schemes.entrySet()) {
            hasBizModel.clear();
            for (BgControlScheme scheme : entry.getValue()) {
                if (hasBizModel.contains(scheme.getBizModelKey())) continue;
                bizModel = this.getControlData().getBizModels().get(scheme.getBizModelKey());
                if (bizModel == null) {
                    BgControlLogUtils.info(this.getControlData().getStats(), true, "nofound-bizmodel=" + scheme.getBizModelKey());
                    continue;
                }
                String orgUnitFields = scheme.getOrgUnitFields();
                String orgUnitExtFields = scheme.getOrgUnitExtFields();
                model = ObjectUtils.filterObject((DynamicObject)this.getParameter().getBizObj(), (QFilter[])oqlBuilder.getBuilder().toArrays(), (boolean)true);
                if (model == null) {
                    return map;
                }
                List propsMap = ObjectUtils.toMap((DynamicObject)model, (String[])new String[]{orgUnitFields, orgUnitExtFields});
                if (propsMap.isEmpty()) continue;
                Map propMap = (Map)propsMap.get(0);
                kd.epm.eb.common.model.Dimension dimension = (kd.epm.eb.common.model.Dimension)bizModel.getDimensionMap().get(SysDimensionEnum.Entity.getNumber());
                kd.epm.eb.common.model.Member member = new kd.epm.eb.common.model.Member(dimension);
                Object obj = propMap.get(orgUnitFields);
                if (obj instanceof DynamicObject) {
                    DynamicObject o = (DynamicObject)obj;
                    member.setNumber(o.getString("number"));
                } else {
                    ControlException.errorOrgNoDynamicObject();
                }
                kd.epm.eb.common.model.Member[] _member = scheme.mapping((boolean)true, (kd.epm.eb.common.model.Member)member, (Map<String, Object>)propMap).member;
                String number = _member[1].getNumber();
                Map _map = map.computeIfAbsent(entry.getKey(), f -> new HashMap(10)).computeIfAbsent(scheme.getBizModelKey().toString(), f -> new HashMap(2));
                _map.put("orgNumber", number);
                _map.put("modelId", bizModel.getId().toString());
            }
        }
        return map;
    }

    protected Collection<IControlParam> builderParams() {
        Map<String, Collection<BgControlScheme>> schemas = null;
        schemas = this.getParameter() instanceof IBatchControlParameter ? ((IBatchControlParameter)this.getParameter()).getSchemes() : BgControlSchemeUtils.query(this.getControlData(), this.getParameter().getEntityNumber(), true);
        if (schemas != null && this.getControlData().getProcess() != null) {
            Long processId = IDUtils.toLong((Object)this.getControlData().getProcess().get("controlprocess.id"));
            Iterator<Map.Entry<String, Collection<BgControlScheme>>> itG = schemas.entrySet().iterator();
            while (itG.hasNext()) {
                Map.Entry<String, Collection<BgControlScheme>> gEntry = itG.next();
                if (gEntry.getValue() != null) {
                    Iterator<BgControlScheme> itS = gEntry.getValue().iterator();
                    while (itS.hasNext()) {
                        if (itS.next().isInProcess(processId)) continue;
                        itS.remove();
                    }
                }
                if (gEntry.getValue() != null && !gEntry.getValue().isEmpty()) continue;
                itG.remove();
            }
        }
        if (schemas == null || schemas.isEmpty()) {
            BgControlLogAddUtils.addDetailModel(this.getControlData().getStats(), this.getControlData().getBizModels().values());
            ControlException.notDimensionMappings((String)this.getParameter().getEntityNumber());
            return new LinkedList<IControlParam>();
        }
        this.getControlData().getStats().add("end-query-scheme");
        DynamicObject model = null;
        boolean hasWriteSchema = false;
        LinkedList<Map<String, Object>> propsMap = new LinkedList();
        OQLBuilder oqlBuilder = new OQLBuilder();
        LinkedList<IControlParam> controlParams = new LinkedList<IControlParam>();
        if (schemas == null || schemas.isEmpty()) {
            return controlParams;
        }
        DynamicObject bizObjDyn = null;
        if (this.getParameter().getControlManager().isStandard()) {
            if (this.getParameter().getBizObj() == null) {
                HashSet<String> fields = new HashSet<String>(10);
                for (Map.Entry<String, Collection<BgControlScheme>> subSchemes : schemas.entrySet()) {
                    for (BgControlScheme schema : subSchemes.getValue()) {
                        oqlBuilder.builder(this.getParameter(), this.getParameter().getEntityNumber(), this.getControlData(), schema, true);
                        if (!StringUtils.isNotEmpty((String)oqlBuilder.getFields())) continue;
                        fields.addAll(Arrays.asList(oqlBuilder.getFields().split(",")));
                    }
                }
                OQLBuilder.addParentField(fields);
                bizObjDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(this.parameter.getBizId()), (String)this.getParameter().getEntityNumber(), (String)String.join((CharSequence)",", fields));
            } else {
                bizObjDyn = this.getParameter().getBizObj();
            }
        }
        HashSet<Long> hasSchemeKeys = new HashSet<Long>(10);
        HashSet<Long> hasCheckSchemeKeys = new HashSet<Long>(10);
        BizModel bizModel = null;
        HashMap<String, Collection> bizModelMap = new HashMap<String, Collection>(10);
        HashSet<String> hasOnlyCheck = new HashSet<String>(10);
        StringBuilder noMemberMsg = new StringBuilder();
        String parseErrMsg = null;
        String emptyEntryErr = null;
        for (Map.Entry<String, Collection<BgControlScheme>> subSchemes : schemas.entrySet()) {
            hasSchemeKeys.clear();
            for (BgControlScheme schema : subSchemes.getValue()) {
                block46: {
                    block45: {
                        parseErrMsg = null;
                        if (hasSchemeKeys.contains(schema.getBizModelKey())) continue;
                        bizModel = this.getControlData().getBizModels().get(schema.getBizModelKey());
                        if (bizModel == null) {
                            BgControlLogUtils.info(this.getControlData().getStats(), true, "nofound-scheme=" + schema.getBizModelKey());
                            continue;
                        }
                        propsMap.clear();
                        oqlBuilder.builder(this.getParameter(), this.getParameter().getEntityNumber(), this.getControlData(), schema, true);
                        this.getControlData().getStats().add("begin-filterObject");
                        if (!this.getParameter().getControlManager().isStandard()) break block45;
                        if (bizObjDyn == null || (model = ObjectUtils.filterObject((DynamicObject)bizObjDyn, (QFilter[])oqlBuilder.getBuilder().toArrays(), (boolean)true)) == null) break block46;
                        ObjectValueToMap obj2Map = new ObjectValueToMap();
                        propsMap = obj2Map.execute(model, oqlBuilder.getFields().split(","));
                        if (!obj2Map.getErrorMessage().isEmpty()) {
                            parseErrMsg = StringUtils.join((Collection)obj2Map.getErrorMessage(), (String)"\r\n");
                        }
                        if (obj2Map.emptyEntryErrMessage == null) break block46;
                        emptyEntryErr = obj2Map.emptyEntryErrMessage;
                        break block46;
                    }
                    Map.Entry<String, Object> entry22 = null;
                    LinkedHashMap propMap = null;
                    for (Map<String, Object> bizObj : this.getParameter().getBizObjMaps()) {
                        propMap = Maps.newLinkedHashMapWithExpectedSize((int)bizObj.size());
                        for (Map.Entry<String, Object> entry22 : bizObj.entrySet()) {
                            propMap.put(entry22.getKey().toLowerCase(), entry22.getValue());
                        }
                        propsMap.add(propMap);
                    }
                }
                this.getControlData().getStats().add("end-filterObject");
                try {
                    LinkedList _propsMap = propsMap;
                    BgControlLogUtils.infoThread(this.getControlData().getStats(), this.getMaxLength() > 0, () -> JSONUtils.toString((Object)_propsMap, (int)this.getMaxLength()));
                }
                catch (Throwable _propsMap) {
                    // empty catch block
                }
                this.getControlData().getStats().add("end-log-propsMap");
                if (StringUtils.isNotEmpty((String)schema.getCondition()) && schema.getFilter() != null) {
                    this.getControlData().getStats().addInfo("begin-run-condition.");
                    BgControlLogUtils.info(this.getControlData().getStats(), true, "condition" + schema.getCondition());
                    ArrayList _filterProps = Lists.newArrayListWithCapacity((int)propsMap.size());
                    ConditionUtils utils = ConditionUtils.get();
                    ConditionUtils.QFilterEvaluator evaluator = new ConditionUtils.QFilterEvaluator();
                    for (Map map : propsMap) {
                        evaluator.setValues(map);
                        QFilter filter = schema.getFilter();
                        if (!this.parameter.getControlManager().isStandard()) {
                            for (QFilter.QFilterNest next : filter.getNests(true)) {
                                QFilter nextFilter = next.getFilter();
                                if (nextFilter == null || nextFilter.getValue() == null || filter.getProperty().equals(nextFilter.getProperty()) || !"EMPTY".equals(nextFilter.getValue().toString())) continue;
                                next.remove();
                            }
                        }
                        if (!utils.run(filter, evaluator)) continue;
                        _filterProps.add(map);
                    }
                    if (schema.isOnlycontrolsuit()) {
                        propsMap.clear();
                        propsMap.addAll(_filterProps);
                    } else if (_filterProps.isEmpty()) {
                        propsMap.clear();
                    }
                    this.getControlData().getStats().add("end-run-condition.");
                }
                if (propsMap.isEmpty()) {
                    this.getControlData().getStats().add("propsMap-isEmpty.");
                    continue;
                }
                if (parseErrMsg != null) {
                    throw new KDBizException(parseErrMsg);
                }
                this.checkControlParam(this.getParameter(), oqlBuilder, propsMap);
                this.checkPropMap(this.getParameter(), oqlBuilder, schema, propsMap);
                hasSchemeKeys.add(schema.getBizModelKey());
                if (!schema.isOnlyCheck()) {
                    hasCheckSchemeKeys.add(schema.getBizModelKey());
                }
                if (schema.isOnlyCheck()) {
                    hasOnlyCheck.add(schema.getGroupId() + "!" + schema.getModelId());
                }
                if (!schema.isOnlyCheck()) {
                    hasWriteSchema = true;
                }
                if (schema.hasMapping(bizModel)) {
                    schema.loadMapping(bizModel);
                }
                Collection<IControlParam> _params = null;
                try {
                    _params = this.builderParams(this.getParameter(), schema, this.getControlData(), new HashMap<String, String>(oqlBuilder.getProps()), propsMap);
                }
                catch (KDBizException e) {
                    if (e.getErrorCode() != null && "error-not-exist-member".equals(e.getErrorCode().getCode())) {
                        if (noMemberMsg.length() > 0) {
                            noMemberMsg.append("\r\n");
                        }
                        noMemberMsg.append(e.getMessage());
                        if (!this.getControlData().isMultiControl()) {
                            break;
                        }
                    }
                    throw e;
                }
                if (_params == null) continue;
                controlParams.addAll(_params);
                if (this.getControlData().isMultiControl()) continue;
                break;
            }
            for (BizModel _bizModel : this.getControlData().getBizModels().values()) {
                if (hasCheckSchemeKeys.contains(_bizModel.getKey())) continue;
                bizModelMap.computeIfAbsent(subSchemes.getKey(), f -> new ArrayList(10)).add(_bizModel);
            }
        }
        if (noMemberMsg.length() > 0) {
            ControlException.notExistMember((String)noMemberMsg.toString());
        }
        if (!hasWriteSchema) {
            if (emptyEntryErr != null) {
                ControlException.nullEntityErr(emptyEntryErr);
            }
            if (this.getControlData().isMultiControl()) {
                if (!bizModelMap.isEmpty()) {
                    BgControlLogAddUtils.addDetailModel(this.getControlData().getStats(), this.getControlData().getBizModels().values());
                    ControlException.notDimensionMappings(bizModelMap, (String)this.getParameter().getEntityNumber(), hasOnlyCheck);
                }
            } else if (controlParams.isEmpty()) {
                BgControlLogAddUtils.addDetailModel(this.getControlData().getStats(), this.getControlData().getBizModels().values());
                ControlException.notDimensionMapping((BizModel)this.getControlData().getBizModels().values().iterator().next(), (String)this.getParameter().getEntityNumber());
            }
        }
        BgControlLogAddUtils.addDetailLogs(this.getControlData().getStats(), this.getControlData().isMultiControl(), controlParams, this.getParameter().getEntityNumber());
        return controlParams;
    }

    protected void checkControlParam(IControlParameter parameter, OQLBuilder oqlBuilder, List<Map<String, Object>> propsMap) {
        if (!parameter.getControlManager().isStandard() && parameter.getControlManager().getDeductByEntry().booleanValue()) {
            HashSet<String> repeatEntryIds = new HashSet<String>();
            for (Map<String, Object> prop : propsMap) {
                String entryProp = oqlBuilder.getEntryProp();
                if (StringUtils.isEmpty((String)entryProp)) {
                    ControlException.nullEntryId();
                    continue;
                }
                if (prop.get(oqlBuilder.getEntryProp()) == null || "".equals(prop.get(oqlBuilder.getEntryProp()))) {
                    ControlException.nullEntryId();
                    continue;
                }
                String entryId = (String)prop.get(oqlBuilder.getEntryProp());
                if (repeatEntryIds.contains(entryId)) {
                    ControlException.repeatEntryId();
                    continue;
                }
                repeatEntryIds.add(entryId);
            }
        }
    }

    protected void checkPropMap(IControlParameter parameter, OQLBuilder oqlBuilder, BgControlScheme schema, List<Map<String, Object>> propsMap) {
        if (parameter == null || propsMap == null || propsMap.isEmpty()) {
            ControlException.propValueIsNull();
            return;
        }
        LinkedHashSet checkFields = Sets.newLinkedHashSetWithExpectedSize((int)oqlBuilder.getProps().size());
        if (!parameter.getControlManager().isQueryBalance()) {
            checkFields.add("id");
            checkFields.add(parameter.getBizUtils().getBillNumberField(parameter.getEntityNumber()));
        }
        Map.Entry<String, String> entry2 = null;
        for (Map.Entry<String, String> entry2 : oqlBuilder.getProps().entrySet()) {
            if (Arrays.asList("entryProp", "entrySeqProp").contains(entry2.getKey()) || entry2.getKey().startsWith("userdefined") || entry2.getKey().endsWith("Ext")) continue;
            checkFields.add(entry2.getValue());
        }
        ArrayList<String> checkResult = new ArrayList<String>();
        for (Map<String, Object> props : propsMap) {
            HashSet<String> repeat = new HashSet<String>(16);
            for (Map.Entry<String, Object> prop : props.entrySet()) {
                if (!checkFields.contains(prop.getKey()) || prop.getValue() != null && !"".equals(prop.getValue())) continue;
                String propName = prop.getKey();
                String fieldNumber = "";
                if (parameter.getControlManager().isStandard()) {
                    propName = propName.replaceAll("\\.name|\\.number", "");
                    fieldNumber = propName.replaceAll("\\.name|\\.number", "");
                    Optional<IDataEntityProperty> optional = Optional.ofNullable(DynamicObjectUtils.getEntityProperty((DynamicObject)parameter.getBizObj(), (String)propName));
                    if (optional.isPresent()) {
                        propName = DynamicObjectUtils.getDisplayName((IDataEntityProperty)optional.get());
                    }
                    if (prop.getKey().endsWith(".name")) {
                        propName = propName + ResManager.loadKDString((String)".\u540d\u79f0", (String)"CalcBalance_3", (String)"epm-eb-business", (Object[])new Object[0]);
                    }
                    if (prop.getKey().endsWith(".number")) {
                        propName = propName + ResManager.loadKDString((String)".\u7f16\u7801", (String)"CalcBalance_4", (String)"epm-eb-business", (Object[])new Object[0]);
                    }
                }
                if (!repeat.add(fieldNumber)) continue;
                checkResult.add(propName);
            }
        }
        if (!checkResult.isEmpty()) {
            ControlException.propValueIsNull((String)StringUtils.join(checkResult, (String)","));
        }
    }

    protected Collection<IControlParam> calcMember() {
        if (this.getParameter() == null || this.getControlData() == null || this.getControlData().getBizModels() == null || this.getControlData().getBizModels().isEmpty()) {
            return this.getControlParams();
        }
        this.filterControlDims();
        CalcMemberParameter calcParam = (CalcMemberParameter)this.getParameter().getCalcParameter();
        Collection<String> types = calcParam.getTypes();
        if (types == null) {
            types = new ArrayList<String>();
            types.add(BgControlSettingTypeEnum.MONTH.getNumber());
        }
        ControlParam controlParam = null;
        BgControlSetting setting = null;
        kd.epm.eb.common.model.Member member = null;
        kd.epm.eb.common.model.Dimension dimen = null;
        GregorianCalendar calendar = new GregorianCalendar();
        BizModel bizModel = this.getControlData().getBizModels().values().iterator().next();
        Map dimensionMap = bizModel.getDimensionMap();
        BgControlLogUtils.info(this.controlData.getStats(), true, "controlDim" + SerializationUtils.toJsonString(dimensionMap.keySet()));
        for (Map<String, String> memberObj : calcParam.getMembers()) {
            for (String type : types) {
                controlParam = new ControlParam();
                controlParam.setDefaultZero(this.getParameter() == null ? true : this.getParameter().isDefaultZero());
                controlParam.setStats(this.getControlData().getStats());
                controlParam.setBizModel(bizModel);
                Long modelId = bizModel.getId();
                controlParam.setControlType(ControlTypeEnum.OCCUPATION);
                boolean ebByModel = controlParam.getBizModel().isEBByModel();
                member = new kd.epm.eb.common.model.Member(null, "NoScenario", "NoScenario");
                member.setDimension((kd.epm.eb.common.model.Dimension)dimensionMap.get(SysDimensionEnum.Scenario.getNumber()));
                controlParam.setMember(true, member);
                controlParam.setMember(false, member);
                member = new kd.epm.eb.common.model.Member(null, "CurrentPeriod", "CurrentPeriod");
                member.setDimension((kd.epm.eb.common.model.Dimension)dimensionMap.get(SysDimensionEnum.ChangeType.getNumber()));
                controlParam.setMember(true, member);
                member = new kd.epm.eb.common.model.Member(null, "EBChanges", "EBChanges");
                member.setDimension((kd.epm.eb.common.model.Dimension)dimensionMap.get(SysDimensionEnum.ChangeType.getNumber()));
                controlParam.setMember(false, member);
                member = new kd.epm.eb.common.model.Member(null, "Budget", "Budget");
                member.setDimension((kd.epm.eb.common.model.Dimension)dimensionMap.get(SysDimensionEnum.DataType.getNumber()));
                controlParam.setMember(true, member);
                member = new kd.epm.eb.common.model.Member(null, "Actual", "Actual");
                member.setDimension((kd.epm.eb.common.model.Dimension)dimensionMap.get(SysDimensionEnum.DataType.getNumber()));
                controlParam.setMember(false, member);
                member = new kd.epm.eb.common.model.Member(null, "IRpt", "IRpt");
                member.setDimension((kd.epm.eb.common.model.Dimension)dimensionMap.get(SysDimensionEnum.Process.getNumber()));
                controlParam.setMember(true, member);
                controlParam.setMember(false, member);
                member = new kd.epm.eb.common.model.Member(null, "ATTotal", "ATTotal");
                member.setDimension((kd.epm.eb.common.model.Dimension)dimensionMap.get(SysDimensionEnum.AuditTrail.getNumber()));
                controlParam.setMember(true, member);
                controlParam.setMember(false, member);
                if (dimensionMap.containsKey(SysDimensionEnum.InternalCompany.getNumber())) {
                    member = new kd.epm.eb.common.model.Member(null, "ICNone", "ICNone");
                    member.setDimension((kd.epm.eb.common.model.Dimension)dimensionMap.get(SysDimensionEnum.InternalCompany.getNumber()));
                    controlParam.setMember(true, member);
                    controlParam.setMember(false, member);
                }
                member = new kd.epm.eb.common.model.Member(null, "EBChanges", "EBChanges");
                member.setDimension((kd.epm.eb.common.model.Dimension)dimensionMap.get(SysDimensionEnum.ChangeType.getNumber()));
                controlParam.setMember(false, member);
                for (Map.Entry<String, String> memberData : memberObj.entrySet()) {
                    member = new kd.epm.eb.common.model.Member(null, memberData.getValue(), memberData.getValue());
                    dimen = (kd.epm.eb.common.model.Dimension)dimensionMap.get(memberData.getKey());
                    if (dimen == null) continue;
                    this.getMemberLongNumberByEntityOrAccount(member, controlParam, memberData.getKey());
                    member.setDimension(dimen);
                    if (BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimen)) {
                        controlParam.getQueryUserDefDims().add(dimen.getNumber());
                    }
                    if (!memberData.getKey().equals(SysDimensionEnum.DataType.getNumber())) {
                        controlParam.setMember(true, member);
                        controlParam.setMember(false, member);
                    } else if (!ebByModel) {
                        controlParam.setMember(true, member);
                    }
                    if (member.getDimension().getNumber().equals(SysDimensionEnum.Entity.getNumber())) {
                        controlParam.setReqMember(member);
                        continue;
                    }
                    if (!member.getDimension().getNumber().equals(SysDimensionEnum.Account.getNumber())) continue;
                    controlParam.setReqMember(member);
                }
                for (kd.epm.eb.common.model.Dimension dimension : bizModel.getDimensions()) {
                    member = controlParam.getMember(true, dimension.getNumber());
                    if (member != null) continue;
                    member = new kd.epm.eb.common.model.Member(null, dimension.getNumber(), dimension.getNumber());
                    this.getMemberLongNumberByEntityOrAccount(member, controlParam, dimension.getNumber());
                    member.setDimension(dimension);
                    controlParam.setMember(true, member);
                    controlParam.setMember(false, member);
                }
                member = new kd.epm.eb.common.model.Member(null, "ACTUAL", "ACTUAL");
                member.setDimension((kd.epm.eb.common.model.Dimension)bizModel.getDimensionMap().get(SysDimensionEnum.Version.getNumber()));
                controlParam.setMember(false, member);
                member = new kd.epm.eb.common.model.Member(null, "EntityInput", "EntityInput");
                member.setDimension((kd.epm.eb.common.model.Dimension)bizModel.getDimensionMap().get(SysDimensionEnum.AuditTrail.getNumber()));
                controlParam.setMember(false, member);
                if (ebByModel) {
                    String yearNum = controlParam.getMember(true, SysDimensionEnum.Year.getNumber()).getNumber();
                    String periodNum = controlParam.getMember(true, SysDimensionEnum.Period.getNumber()).getNumber();
                    controlParam.setBizTime(this.parseBizTime(calendar, yearNum, periodNum));
                    setting = BgControlSetting.createDefault();
                    setting.setSettingType(BgControlSettingTypeEnum.valueOf((String)type));
                    if (calcParam.isHasQuerySetRule()) {
                        if (periodNum.startsWith("M_")) {
                            setting.setPeriodType(BgControlPeriodTypeEnum.MONTH);
                        } else if (periodNum.startsWith("Q_")) {
                            setting.setPeriodType(BgControlPeriodTypeEnum.QUARTER);
                        } else if (periodNum.startsWith("HF_")) {
                            setting.setPeriodType(BgControlPeriodTypeEnum.HALFYEAR);
                        }
                    }
                } else {
                    String budgetPeriod = controlParam.getMember(true, SysDimensionEnum.BudgetPeriod.getNumber()).getNumber();
                    String[] arr = budgetPeriod.split("\\.");
                    String yearNum = arr[0];
                    String periodNum = "";
                    if (arr.length > 1) {
                        periodNum = arr[1];
                    }
                    controlParam.setBizTime(this.parseBizTime(calendar, yearNum, periodNum));
                    if (controlParam.getBizModel().getPeriodUtils().isPeriodUserDefine()) {
                        String pnumber = controlParam.getFullPeriodNumber(true);
                        if (pnumber == null) {
                            pnumber = controlParam.getFullPeriodNumber(false);
                        }
                        controlParam.setBizTime(controlParam.getBizModel().getPeriodUtils().parseBizTime(pnumber));
                    }
                    setting = BgControlSetting.createDefault();
                    setting.setSettingType(BgControlSettingTypeEnum.valueOf((String)type));
                    if (calcParam.isHasQuerySetRule()) {
                        if (periodNum.startsWith("M")) {
                            setting.setPeriodType(BgControlPeriodTypeEnum.MONTH);
                        } else if (periodNum.startsWith("Q")) {
                            setting.setPeriodType(BgControlPeriodTypeEnum.QUARTER);
                        } else if (periodNum.startsWith("HF")) {
                            setting.setPeriodType(BgControlPeriodTypeEnum.HALFYEAR);
                        }
                    }
                }
                controlParam.setSetting(setting);
                if (this.getParameter().isHasAdjustCheck()) {
                    controlParam.setBizNumber(memberObj.get("billNumber"));
                    controlParam.setAdjustCheckFlag(true);
                    IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                    Map budgetMemberMap = (Map)((BudgetBalance)controlParam).get("BUDGET_MEMBER");
                    HashSet datasetdimnumber = null;
                    kd.epm.eb.common.model.Member acc = (kd.epm.eb.common.model.Member)budgetMemberMap.get(SysDimensionEnum.Account.getNumber());
                    if (acc != null) {
                        datasetdimnumber = Sets.newHashSet((Object[])modelCacheHelper.getDimensionNums(modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, acc.getNumber()).getDatasetId()));
                    }
                    int userDefinedDimCount = 0;
                    int userDefinedDimTotalCount = 0;
                    for (Map.Entry entry : budgetMemberMap.entrySet()) {
                        String dimNumber = (String)entry.getKey();
                        kd.epm.eb.common.model.Member budgetMember = (kd.epm.eb.common.model.Member)entry.getValue();
                        Dimension dimension = modelCacheHelper.getDimension(dimNumber);
                        if (dimension.isPreset() || datasetdimnumber != null && !datasetdimnumber.contains(dimension.getNumber())) continue;
                        ++userDefinedDimCount;
                        if (!dimNumber.equals(budgetMember.getNumber())) continue;
                        ++userDefinedDimTotalCount;
                    }
                    if (userDefinedDimCount > 0 && userDefinedDimCount == userDefinedDimTotalCount) {
                        controlParam.setAdjustCheckTotalFlag(true);
                    }
                }
                if (this.getParameter().isHasQueryActControlRule() && this.getParameter().isHasQueryActControlRuleByBudOcc()) {
                    controlParam.setBizNumber("null");
                    controlParam.setQueryBalanceAndBudOccFlag(true);
                }
                controlParam.setNeedLog(BgControlLogUtils.isNeedLog());
                this.getControlParams().add(controlParam);
            }
        }
        if (calcParam.isHasQuerySetRule() && (this.getParameter().isHasAdjustCheck() || this.getParameter().isHasQueryActControlRule())) {
            try {
                BgControlRuleUtils.getInterface().queryControlRule(this.getControlData(), this.getControlParams());
            }
            catch (KDBizException e) {
                if ("EB090002".equals(e.getErrorCode().getCode())) {
                    throw e;
                }
                log.error("query control rule error", (Throwable)e);
            }
            catch (Exception e) {
                log.error("query control rule error", (Throwable)e);
            }
        }
        BgControlParamUtils utils = BgControlParamUtils.get();
        utils.setParameter(this.getParameter());
        utils.fillMembers(this.getControlData(), this.getControlParams());
        utils.fillPeriodMembers(bizModel, this.getControlData(), this.getControlParams());
        Map<Long, List<Map<String, Map<String, kd.epm.eb.common.model.Member>>>> dimMembers = this.builderMembers(this.getControlData().getBizModels(), this.getControlParams());
        this.aggregate(this.getControlParams(), dimMembers);
        BgControlLogUtils.infoThread(this.getControlData().getStats(), true, () -> "CalcBalance.queryOlap: " + dimMembers.toString());
        this.queryOlap(this.getControlData().getBizModels(), dimMembers);
        return this.getControlParams();
    }

    private void getMemberLongNumberByEntityOrAccount(kd.epm.eb.common.model.Member member, IControlParam controlParam, String dimNumber) {
        Long viewId;
        IModelCacheHelper cacheHelper;
        Member cacheHelperMember;
        if (member == null || controlParam == null || controlParam.getBizModel() == null) {
            return;
        }
        if ((SysDimensionEnum.Entity.getNumber().equals(dimNumber) || SysDimensionEnum.Account.getNumber().equals(dimNumber)) && (cacheHelperMember = (cacheHelper = ModelCacheContext.getOrCreate((Long)controlParam.getBizModel().getId())).getMember(dimNumber, viewId = cacheHelper.getViewByBusModelAndDimNumber(controlParam.getBizModel().getControlBusModelId(), dimNumber), member.getNumber())) != null) {
            member.setLongNumber(cacheHelperMember.getLongNumber());
        }
    }

    private Date parseBizTime(Calendar calendar, String yearNum, String periodNum) {
        char _char;
        int i;
        if (calendar == null || StringUtils.isEmpty((String)yearNum) || StringUtils.isEmpty((String)periodNum)) {
            return new Date();
        }
        String _year = "";
        String _month = "";
        StringBuilder str = new StringBuilder();
        int in = yearNum.length();
        for (i = 0; i < in; ++i) {
            _char = yearNum.charAt(i);
            if (!Character.isDigit(_char)) continue;
            str.append(_char);
        }
        _year = str.toString();
        str.setLength(0);
        in = periodNum.length();
        for (i = 0; i < in; ++i) {
            _char = periodNum.charAt(i);
            if (!Character.isDigit(_char)) continue;
            str.append(_char);
        }
        _month = str.toString();
        if (periodNum.startsWith("M_Q") || periodNum.startsWith("Q_Q")) {
            if ("1".equals(_month)) {
                _month = "3";
            } else if ("2".equals(_month)) {
                _month = "6";
            } else if ("3".equals(_month)) {
                _month = "9";
            } else if ("4".equals(_month)) {
                _month = "12";
            }
        } else if (periodNum.startsWith("M_HF") || periodNum.startsWith("Q_HF") || periodNum.startsWith("HF_")) {
            if ("1".equals(_month)) {
                _month = "6";
            } else if ("2".equals(_month)) {
                _month = "12";
            }
        } else if (periodNum.endsWith("_YearTotal")) {
            _month = "12";
        }
        calendar.set(1, Integer.parseInt(_year));
        calendar.set(2, Integer.parseInt(_month) - 1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public void aggregate(Collection<IControlParam> controlParams, Map<Long, List<Map<String, Map<String, kd.epm.eb.common.model.Member>>>> members) {
        if (controlParams == null || controlParams.isEmpty() || members == null || members.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, List<Map<String, Map<String, kd.epm.eb.common.model.Member>>>> entry : members.entrySet()) {
            if (this.getControlData().getBizModels() == null || this.getControlData().getBizModels().get(entry.getKey()) == null || !this.getControlData().getBizModels().get(entry.getKey()).isEBByModel()) continue;
            AggregateExpr expr = new AggregateExpr();
            for (Map<String, Map<String, kd.epm.eb.common.model.Member>> dimMember : entry.getValue()) {
                for (Map.Entry<String, Map<String, kd.epm.eb.common.model.Member>> dim : dimMember.entrySet()) {
                    expr.addMembers(dim.getKey(), dim.getValue().keySet());
                }
            }
            ArrayList<IExpress> expresses = new ArrayList<IExpress>();
            expresses.add(expr);
            try {
                ScriptCommand command = ScriptCommand.getIntance(OlapServiceHelper.getOlapConnection((String)this.getControlData().getBizModels().get(entry.getKey()).getCubeNumber()));
                command.execute(this.getControlData().getBizModels().get(entry.getKey()).getId(), expresses);
            }
            catch (Throwable ex) {
                log.error("command-execute-error:", ex);
                if (ex instanceof ConnectException || ex instanceof OlapServerRuntimeException) {
                    ControlException.connectOlapFail();
                    continue;
                }
                throw new KDBizException(new ErrorCode("EB040551", ex.getMessage()), new Object[0]);
            }
        }
    }

    public void queryOlap(Map<Long, BizModel> bizModelMap, Map<Long, List<Map<String, Map<String, kd.epm.eb.common.model.Member>>>> members) {
        if (bizModelMap == null || bizModelMap.isEmpty() || members == null || members.isEmpty()) {
            return;
        }
        String dataKey = null;
        HashMap<String, Collection<BgData>> bgDataMap = new HashMap<String, Collection<BgData>>();
        Collection<BgData> _bgDatas = null;
        for (Map.Entry<Long, List<Map<String, Map<String, kd.epm.eb.common.model.Member>>>> entry : members.entrySet()) {
            BizModel bizModel = bizModelMap.get(entry.getKey());
            if (bizModel == null) {
                BgControlLogUtils.info(this.getControlData().getStats(), true, "nofound-bizModel=" + entry.getKey());
                continue;
            }
            bgDataMap.clear();
            LinkedList<BgData> bgDatas = new LinkedList<BgData>();
            if (bizModel.isEBByModel()) {
                this.queryOlapByEb(bizModel, entry.getValue(), bgDatas);
            } else if (ShrekOlapServiceHelper.isStartShrek()) {
                this.queryOlapByShrek(bizModel, entry.getValue(), bgDatas);
            } else {
                this.queryOlapByDB(bizModel, entry.getValue(), bgDatas);
            }
            HashMap<String, Set<String>> hasDataNumbers = new HashMap<String, Set<String>>(10);
            for (BgData bgData : bgDatas) {
                dataKey = bgData.getDataKey((Collection)bizModel.getDimensions(), true);
                for (Map.Entry entry2 : bgData.getMemberMap().entrySet()) {
                    hasDataNumbers.computeIfAbsent((String)entry2.getKey(), (Function<String, Set<String>>)((Function<String, Set>)f -> new HashSet(10))).add(entry2.getValue());
                }
                if (bgDataMap.containsKey(dataKey)) {
                    _bgDatas = (Collection)bgDataMap.get(dataKey);
                } else {
                    _bgDatas = new LinkedList();
                    bgDataMap.put(dataKey, _bgDatas);
                }
                _bgDatas.add(bgData);
            }
            if (this.getParameter().isHasAdjustCheck() && bgDataMap.isEmpty()) {
                this.fillValueByBudgetZeroAdjustCheck(bizModel, this.getControlParams());
                return;
            }
            this.fillValue(bizModel, this.getControlParams(), bgDataMap, hasDataNumbers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryOlapByEb(BizModel bizModel, List<Map<String, Map<String, kd.epm.eb.common.model.Member>>> members, List<BgData> bgDatas) {
        if (bizModel == null || bizModel.getDimensions() == null || bizModel.getDimensions().isEmpty() || members == null || members.isEmpty() || bgDatas == null) {
            return;
        }
        List dimensions = bizModel.getDimensions();
        LinkedHashSet<String> memberSet = new LinkedHashSet<String>();
        SQLBuilder builder = new SQLBuilder(bizModel.getCubeNumber());
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            builder.addSelectField(new String[]{dimension.getNumber()});
            memberSet.clear();
            for (Map<String, Map<String, kd.epm.eb.common.model.Member>> dimMembers : members) {
                Map<String, kd.epm.eb.common.model.Member> memberMap = dimMembers.get(dimension.getNumber());
                memberSet.addAll(memberMap.keySet());
            }
            builder.addFilter(dimension.getNumber(), memberSet.toArray(new String[memberSet.size()]));
        }
        builder.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        Long modelId = bizModel.getId();
        try (MDResultSet rst = null;){
            rst = OlapServiceHelper.queryData((SQLBuilder)builder);
            while (rst.next()) {
                BgData bgData = new BgData(modelId);
                for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                    bgData.setMember(dimension.getNumber(), rst.getString(dimension.getNumber()));
                }
                bgData.setValue(rst.getBigDecimal(FacTabFieldDefEnum.FIELD_MONEY.getField()));
                bgDatas.add(bgData);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void queryOlapByShrek(BizModel bizModel, List<Map<String, Map<String, kd.epm.eb.common.model.Member>>> members, List<BgData> bgDatas) {
        block27: {
            if (bizModel == null || bizModel.getDimensions() == null || bizModel.getDimensions().isEmpty() || members == null || members.isEmpty() || bgDatas == null) {
                return;
            }
            dimensions = bizModel.getDimensions();
            modelId = bizModel.getId();
            accountDim = bizModel.getModelCache().getDimension(SysDimensionEnum.Account.getNumber());
            accountMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Map<String, Map<String, kd.epm.eb.common.model.Member>> dimMembers : members) {
                memberMap = dimMembers.get(SysDimensionEnum.Account.getNumber());
                for (String memberNumber : memberMap.keySet()) {
                    member = accountDim.getMember(null, memberNumber);
                    if (member == null) continue;
                    accounts = accountMap.computeIfAbsent(member.getDatasetId(), (Function<Long, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$queryOlapByShrek$7(java.lang.Long ), (Ljava/lang/Long;)Ljava/util/Set;)());
                    accounts.add(member.getNumber());
                }
            }
            if (accountMap.isEmpty()) break block27;
            value = null;
            dimensionMap = bizModel.getModelCache().getDimensionMap();
            dimMembers = new DimMembers();
            for (Map.Entry<K, V> entry : accountMap.entrySet()) {
                datasetId = (Long)entry.getKey();
                accounts = (Set)entry.getValue();
                dataset = Dataset.of((DynamicObject)DatasetServiceHelper.loadDatasets((Long)datasetId));
                ctrlDims = dimensions.stream().map((Function<kd.epm.eb.common.model.Dimension, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$queryOlapByShrek$8(kd.epm.eb.common.model.Dimension ), (Lkd/epm/eb/common/model/Dimension;)Ljava/lang/String;)()).collect(Collectors.toList());
                datasetDimMap = bizModel.getModelCache().getDimensionMap(datasetId);
                ctrlDims.removeAll(datasetDimMap.keySet());
                v0 = hasEqualsDims = ctrlDims.isEmpty() == false;
                if (hasEqualsDims) {
                    dimMembers.clear();
                    for (String addDim : ctrlDims) {
                        dimMembers.addMembers(Arrays.asList(new String[]{addDim, ((Dimension)dimensionMap.get(addDim)).getNoneNumber()}));
                    }
                }
                dimensionNums = Lists.newArrayListWithCapacity((int)dimensions.size());
                membersMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
                for (Object dimension : dimensions) {
                    if (!datasetDimMap.containsKey(dimension.getNumber())) continue;
                    dimensionNums.add(dimension.getNumber());
                    memberSet = membersMap.computeIfAbsent(dimension.getNumber(), (Function<String, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$queryOlapByShrek$9(java.lang.String ), (Ljava/lang/String;)Ljava/util/Set;)());
                    for (Map<String, Map<String, kd.epm.eb.common.model.Member>> _dimMembers : members) {
                        if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
                            memberSet.addAll(accounts);
                            continue;
                        }
                        memberMap = _dimMembers.get(dimension.getNumber());
                        memberSet.addAll(memberMap.keySet());
                    }
                }
                for (Object dimension : datasetDimMap.keySet()) {
                    membersMap.computeIfAbsent(dimension, (Function<String, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$queryOlapByShrek$10(java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/util/Set;)((String)dimension));
                }
                queryInfo = new SelectCommandInfo();
                queryInfo.addDims(dimensionNums.toArray(new String[0]));
                queryInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
                dimension = membersMap.entrySet().iterator();
                while (dimension.hasNext()) {
                    dim = (Map.Entry)dimension.next();
                    queryInfo.addFilter((String)dim.getKey(), ((Set)dim.getValue()).toArray(new String[0]));
                }
                reader = ShrekOlapServiceHelper.queryReader((Model)Model.of((BizModel)bizModel), (Dataset)dataset, (SelectCommandInfo)queryInfo, (LogStats)this.getControlData().getStats());
                var29_31 = null;
lbl70:
                // 2 sources

                try {
                    while (reader.hasNext()) {
                        block28: {
                            values = reader.next();
                            if (values == null || values[0] == null || (value = values[0] instanceof BigDecimal != false ? (BigDecimal)values[0] : (values[0] instanceof Number != false ? new BigDecimal(values[0].toString()) : null)) == null) continue;
                            bgData = new BgData(modelId);
                            bgData.setValue(value);
                            in = dimensionNums.size();
                            for (i = 0; i < in; ++i) {
                                bgData.setMember((String)dimensionNums.get(i), (String)values[i + 1]);
                            }
                            if (!hasEqualsDims) break block28;
                            dimMembers.reset();
                            while (dimMembers.hasNext()) {
                                tmpNumbers = dimMembers.next();
                                tmpData = bgData.clone();
                                in = ctrlDims.size();
                                for (i = 0; i < in; ++i) {
                                    tmpData.setMember((String)ctrlDims.get(i), tmpNumbers[i]);
                                }
                                bgDatas.add(tmpData);
                            }
                            ** GOTO lbl70
                        }
                        bgDatas.add(bgData);
                    }
                }
                catch (Throwable var30_35) {
                    var29_31 = var30_35;
                    throw var30_35;
                }
                finally {
                    if (reader == null) continue;
                    if (var29_31 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable var30_34) {
                            var29_31.addSuppressed(var30_34);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
    }

    private void queryOlapByDB(BizModel bizModel, List<Map<String, Map<String, kd.epm.eb.common.model.Member>>> members, List<BgData> bgDatas) {
        if (bizModel == null || bizModel.getDimensions() == null || bizModel.getDimensions().isEmpty() || members == null || members.isEmpty() || bgDatas == null) {
            return;
        }
        List dimensions = bizModel.getDimensions();
        BgData bgData = null;
        HashSet<String> memberSet = new HashSet<String>();
        SQLBuilder builder = new SQLBuilder(bizModel.getCubeNumber());
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            builder.addSelectField(new String[]{dimension.getNumber()});
            memberSet.clear();
            for (Map<String, Map<String, kd.epm.eb.common.model.Member>> dimMembers : members) {
                Map<String, kd.epm.eb.common.model.Member> memberMap = dimMembers.get(dimension.getNumber());
                memberSet.addAll(memberMap.keySet());
            }
            builder.addFilter(dimension.getNumber(), memberSet.toArray(new String[memberSet.size()]));
        }
        builder.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        Long modelId = bizModel.getId();
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(builder.getSelectField());
        queryInfo.addMeasures(builder.getMeasures());
        builder.getFilters().forEach(p -> queryInfo.addFilter((String)p.p1, (String[])p.p2));
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        IKDOlapRequest request = KDOlapRequestUtils.of((IModelCacheHelper)cacheHelper, (Long)modelId, (Long)bizModel.getControlBusModelId(), null, (SelectCommandInfo)queryInfo, null);
        request.getOlapQuery().setUseDimension(bizModel.getDimensionArrays());
        request.getOlapQuery().setDimensionMap(bizModel.getDimensionMap(cacheHelper));
        request.getProperties().setPropertyValue("IGNORE_DATASET", KDValue.valueOf((String)BgConstant.TRUE_STR));
        request.getProperties().setPropertyValue("IGNORE_CALC", KDValue.valueOf((String)BgConstant.TRUE_STR));
        request.getProperties().setPropertyValue("IGNORE_SAVE", KDValue.valueOf((String)BgConstant.TRUE_STR));
        request.getProperties().setPropertyValue("IGNORE_PERM_READ", KDValue.valueOf((String)BgConstant.TRUE_STR));
        OlapServiceCaller caller = new OlapServiceCaller();
        List cells = caller.query(request);
        if (cells != null && !cells.isEmpty()) {
            IKDCell cell2 = null;
            for (IKDCell cell2 : cells) {
                bgData = new BgData(modelId);
                int in = dimensions.size();
                for (int i = 0; i < in; ++i) {
                    bgData.setMember(((kd.epm.eb.common.model.Dimension)dimensions.get(i)).getNumber(), cell2.getMeta().getNumber()[i]);
                }
                bgData.setValue(cell2.getValue().getDecimal());
                bgDatas.add(bgData);
            }
        }
    }

    protected Set<String> getChildren(kd.epm.eb.common.model.Dimension dimension, Map<String, kd.epm.eb.common.model.Member> members) {
        HashSet<String> children = new HashSet<String>();
        if (dimension == null || members == null || members.isEmpty()) {
            return children;
        }
        children.addAll(members.keySet());
        return children;
    }

    /*
     * Could not resolve type clashes
     */
    protected void fillValue(BizModel bizModel, Collection<IControlParam> controlParams, Map<String, Collection<BgData>> bgDataMap, Map<String, Set<String>> hasNumbers) {
        if (bizModel == null || controlParams == null || controlParams.isEmpty() || bgDataMap == null || bgDataMap.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        String yearNum = null;
        Collection<BgData> bgDatas = null;
        Map valueMap = null;
        int groupNo = 0;
        boolean isEbByModel = bizModel.isEBByModel();
        String AT_ATTotal = "AuditTrail_ATTotal";
        String AT_BO = "AuditTrail_BudgetOccupation";
        boolean hasAdjustCheck = this.getParameter().isHasAdjustCheck();
        boolean hasQueryActControlRule = this.getParameter().isHasQueryActControlRule();
        boolean hasQueryActControlRuleByBudOcc = this.getParameter().isHasQueryActControlRuleByBudOcc();
        Map<String, BigDecimal> adjustValueMap = this.getParameter().getAdjustValueMap();
        Map<String, BigDecimal> submitValueMap = this.getParameter().getSubmitValueMap();
        List dimensions = bizModel.getDimensions();
        BgControlLogUtils.info(this.getControlData().getStats(), this.controlData.isNeedLog(), "bgDataKey-" + StringUtils.join(bgDataMap.keySet(), (String)","));
        HashSet existKeys = Sets.newHashSetWithExpectedSize((int)controlParams.size());
        HashMap dimNumbers = Maps.newHashMapWithExpectedSize((int)dimensions.size());
        for (kd.epm.eb.common.model.Dimension dim : dimensions) {
            dimNumbers.put(String.valueOf(dim.getId()), dim.getNumber());
        }
        for (IControlParam controlParam : controlParams) {
            List<String> period;
            BgData data;
            String auditTrail;
            Iterator<List<String>> period22;
            String periodNum;
            String version;
            String changeType;
            Object data22;
            if (!controlParam.checkBizModel(bizModel)) continue;
            controlParam.setEbByModel(isEbByModel);
            if (!controlParam.isQueryBudget()) continue;
            HashMap<Long, Boolean> hasUserDefinedDimensionMap = new HashMap<Long, Boolean>(dimensions.size());
            for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                hasUserDefinedDimensionMap.put(dimension.getId(), BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension));
            }
            List<List<String>> bgPeriods = controlParam.isAddup() ? controlParam.getAcPeriod() : controlParam.getBgPeriod();
            List<List<String>> acPeriods = controlParam.getAcPeriod();
            String ctBgMemberNum = controlParam.getMember(true, SysDimensionEnum.ChangeType.getNumber()).getNumber();
            String ctAcMemberNum = controlParam.getMember(false, SysDimensionEnum.ChangeType.getNumber()).getNumber();
            String verBgMemberNum = controlParam.getVersion(true).getNumber();
            String verAcMemberNum = controlParam.getVersion(false).getNumber();
            String bgDataKey = IDUtils.isNotEmptyLong((Long)controlParam.getSetting().getGroupId()) != false ? controlParam.getBgDataKey(bizModel.getDimensions(), controlParam.getSetting(), controlParam, controlParam.getSetting().getOboMemberNumberMap(), controlParam.getSetting().getOboDimIds(), hasUserDefinedDimensionMap) : controlParam.getBgDataKey(bizModel.getDimensions(), controlParam, hasUserDefinedDimensionMap);
            if (bgDataMap.containsKey(bgDataKey)) {
                bgDatas = bgDataMap.get(bgDataKey);
                for (Object data22 : bgDatas) {
                    changeType = data22.getMemberNumber(SysDimensionEnum.ChangeType.getNumber());
                    version = data22.getMemberNumber(SysDimensionEnum.Version.getNumber());
                    if (changeType == null || version == null) continue;
                    if (isEbByModel) {
                        yearNum = data22.getMemberNumber(SysDimensionEnum.Year.getNumber());
                        periodNum = data22.getMemberNumber(SysDimensionEnum.Period.getNumber());
                    } else {
                        periodNum = data22.getMemberNumber(SysDimensionEnum.BudgetPeriod.getNumber());
                    }
                    if (!changeType.equals(ctBgMemberNum) || !version.equals(verBgMemberNum)) continue;
                    for (Iterator<List<String>> period22 : bgPeriods) {
                        if (isEbByModel) {
                            if (!period22.get(0).equals(yearNum) || !period22.get(1).equals(periodNum)) continue;
                            controlParam.getBudgetValues().put(data22.getPeriodKey(true), data22.getValue());
                            continue;
                        }
                        if (!periodNum.equals(period22.get(1))) continue;
                        controlParam.getBudgetValues().put(data22.getPeriodKey(false), data22.getValue());
                    }
                }
            }
            if (hasAdjustCheck) {
                this.dealAdjustCheckBudgetAmount(bizModel.getDimensions(), isEbByModel, adjustValueMap, submitValueMap, existKeys, controlParam, hasUserDefinedDimensionMap);
            }
            String string = auditTrail = bgDataKey.contains("AuditTrail_") ? Arrays.stream(bgDataKey.split("!")).filter(k -> k.startsWith("AuditTrail_")).findFirst().get() : "AuditTrail_ATTotal";
            if (bgDataKey.indexOf(auditTrail) >= 0) {
                if (bgDataMap.containsKey(bgDataKey = bgDataKey.replace(auditTrail, "AuditTrail_BudgetOccupation"))) {
                    bgDatas = bgDataMap.get(bgDataKey);
                    data22 = bgDatas.iterator();
                    while (data22.hasNext()) {
                        data = (BgData)data22.next();
                        changeType = data.getMemberNumber(SysDimensionEnum.ChangeType.getNumber());
                        version = data.getMemberNumber(SysDimensionEnum.Version.getNumber());
                        if (changeType == null || version == null) continue;
                        if (isEbByModel) {
                            yearNum = data.getMemberNumber(SysDimensionEnum.Year.getNumber());
                            periodNum = data.getMemberNumber(SysDimensionEnum.Period.getNumber());
                        } else {
                            periodNum = data.getMemberNumber(SysDimensionEnum.BudgetPeriod.getNumber());
                        }
                        if (!this.verifyBudget(changeType, ctBgMemberNum, version, verBgMemberNum)) continue;
                        period22 = bgPeriods.iterator();
                        while (period22.hasNext()) {
                            period = (List<String>)period22.next();
                            if (isEbByModel) {
                                if (!((String)period.get(0)).equals(yearNum) || !((String)period.get(1)).equals(periodNum)) continue;
                                controlParam.getBudgetOccupationValues().put(data.getPeriodKey(true), data.getValue());
                                continue;
                            }
                            if (!periodNum.equals(period.get(1))) continue;
                            controlParam.getBudgetOccupationValues().put(data.getPeriodKey(false), data.getValue());
                        }
                    }
                }
                if (hasAdjustCheck || hasQueryActControlRule && hasQueryActControlRuleByBudOcc) {
                    this.dealAdjustCheckBudgetOccupation(bgPeriods, bgDataKey, isEbByModel, submitValueMap, controlParam, bizModel.getDimensions());
                }
            }
            String acDataKey = IDUtils.isNotEmptyLong((Long)controlParam.getSetting().getGroupId()) != false ? controlParam.getAcDataKey(bizModel.getDimensions(), controlParam.getSetting(), controlParam, controlParam.getSetting().getOboMemberNumberMap(), controlParam.getSetting().getOboDimIds(), hasUserDefinedDimensionMap) : controlParam.getAcDataKey(bizModel.getDimensions(), controlParam, hasUserDefinedDimensionMap);
            BgControlLogUtils.info(this.getControlData().getStats(), this.getControlData().isNeedLog(), "acDataKey-" + acDataKey);
            if (bgDataMap.containsKey(acDataKey)) {
                bgDatas = bgDataMap.get(acDataKey);
                data22 = bgDatas.iterator();
                while (data22.hasNext()) {
                    data = (BgData)data22.next();
                    changeType = data.getMemberNumber(SysDimensionEnum.ChangeType.getNumber());
                    version = data.getMemberNumber(SysDimensionEnum.Version.getNumber());
                    if (changeType == null || version == null) continue;
                    if (isEbByModel) {
                        yearNum = data.getMemberNumber(SysDimensionEnum.Year.getNumber());
                        periodNum = data.getMemberNumber(SysDimensionEnum.Period.getNumber());
                    } else {
                        periodNum = data.getMemberNumber(SysDimensionEnum.BudgetPeriod.getNumber());
                    }
                    if (!this.verifyActual(changeType, version, verAcMemberNum)) continue;
                    period22 = acPeriods.iterator();
                    while (period22.hasNext()) {
                        period = period22.next();
                        if (isEbByModel) {
                            if (!period.get(0).equals(yearNum) || !period.get(1).equals(periodNum)) continue;
                            valueMap = controlParam.getActualValues().computeIfAbsent(changeType, f -> new HashMap());
                            valueMap.put(data.getPeriodKey(true), data.getValue());
                            continue;
                        }
                        if (!period.get(1).equals(periodNum)) continue;
                        valueMap = controlParam.getActualValues().computeIfAbsent(changeType, f -> new HashMap());
                        valueMap.put(data.getPeriodKey(false), data.getValue());
                    }
                }
            }
            if ((groupNo = controlParam.getSetting().getGroupNo()) <= 0) continue;
            long l1 = System.currentTimeMillis();
            List<BgControlSetting> rules = controlParam.getGroupRuleMap().get(groupNo);
            if (rules != null) {
                String ruleKey = controlParam.getSetting().getKey(controlParam.getBizModel(), controlParam.getControlScheme(), bizModel.getDimensions(), controlParam, controlParam.getSetting().getOboMemberNumberMap(), controlParam.getSetting().getOboDimIds(), hasUserDefinedDimensionMap);
                for (BgControlSetting rule : rules) {
                    boolean isExist = true;
                    String dimNumber = null;
                    for (Map.Entry<String, String> entry : rule.getMemberMap().entrySet()) {
                        dimNumber = SysDimensionEnum.Account.getNumber().equals(entry.getKey()) ? entry.getKey() : (String)dimNumbers.get(entry.getKey());
                        if (!hasNumbers.containsKey(dimNumber) || hasNumbers.get(dimNumber).contains(entry.getValue())) continue;
                        isExist = false;
                        break;
                    }
                    if (!isExist) continue;
                    boolean ignore = ruleKey.equals(rule.getKey(controlParam.getBizModel(), controlParam.getControlScheme(), bizModel.getDimensions(), controlParam, rule.getOboMemberNumberMap(), rule.getOboDimIds(), hasUserDefinedDimensionMap));
                    bgDataKey = controlParam.getBgDataKey(bizModel.getDimensions(), rule, controlParam, rule.getOboMemberNumberMap(), rule.getOboDimIds(), hasUserDefinedDimensionMap);
                    if (bgDataMap.containsKey(bgDataKey)) {
                        bgDatas = bgDataMap.get(bgDataKey);
                        for (BgData data3 : bgDatas) {
                            changeType = data3.getMemberNumber(SysDimensionEnum.ChangeType.getNumber());
                            version = data3.getMemberNumber(SysDimensionEnum.Version.getNumber());
                            if (changeType == null || version == null) continue;
                            if (isEbByModel) {
                                yearNum = data3.getMemberNumber(SysDimensionEnum.Year.getNumber());
                                periodNum = data3.getMemberNumber(SysDimensionEnum.Period.getNumber());
                            } else {
                                periodNum = data3.getMemberNumber(SysDimensionEnum.BudgetPeriod.getNumber());
                            }
                            if (!this.verifyBudget(changeType, ctBgMemberNum, version, verBgMemberNum)) continue;
                            for (List<String> period3 : bgPeriods) {
                                if (isEbByModel) {
                                    if (!period3.get(0).equals(yearNum) || !period3.get(1).equals(periodNum)) continue;
                                    data3 = data3.clone();
                                    data3.setIgnore(ignore);
                                    controlParam.getExtBgData().put(data3.getDataKey((Collection)bizModel.getDimensions()), data3);
                                    continue;
                                }
                                if (!period3.get(1).equals(periodNum)) continue;
                                data3 = data3.clone();
                                data3.setIgnore(ignore);
                                controlParam.getExtBgData().put(data3.getDataKey((Collection)bizModel.getDimensions()), data3);
                            }
                        }
                    }
                    if (bgDataKey.indexOf(auditTrail) >= 0) {
                        if (bgDataMap.containsKey(bgDataKey = bgDataKey.replace(auditTrail, "AuditTrail_BudgetOccupation"))) {
                            bgDatas = bgDataMap.get(bgDataKey);
                            for (BgData data3 : bgDatas) {
                                changeType = data3.getMemberNumber(SysDimensionEnum.ChangeType.getNumber());
                                version = data3.getMemberNumber(SysDimensionEnum.Version.getNumber());
                                if (changeType == null || version == null) continue;
                                if (isEbByModel) {
                                    yearNum = data3.getMemberNumber(SysDimensionEnum.Year.getNumber());
                                    periodNum = data3.getMemberNumber(SysDimensionEnum.Period.getNumber());
                                } else {
                                    periodNum = data3.getMemberNumber(SysDimensionEnum.BudgetPeriod.getNumber());
                                }
                                if (!this.verifyBudget(changeType, ctBgMemberNum, version, verBgMemberNum)) continue;
                                for (List<String> period3 : bgPeriods) {
                                    if (isEbByModel) {
                                        if (!period3.get(0).equals(yearNum) || !period3.get(1).equals(periodNum)) continue;
                                        data3 = data3.clone();
                                        data3.setIgnore(ignore);
                                        controlParam.getExtBgOcData().put(data3.getDataKey((Collection)bizModel.getDimensions()), data3);
                                        continue;
                                    }
                                    if (!period3.get(1).equals(periodNum)) continue;
                                    data3 = data3.clone();
                                    data3.setIgnore(ignore);
                                    controlParam.getExtBgOcData().put(data3.getDataKey((Collection)bizModel.getDimensions()), data3);
                                }
                            }
                        }
                        if (hasAdjustCheck || hasQueryActControlRule && hasQueryActControlRuleByBudOcc) {
                            this.dealAdjustCheckGroupBudgetOccupation(bgPeriods, bgDataKey, isEbByModel, submitValueMap, controlParam, ignore, bizModel.getDimensions());
                        }
                    }
                    if (!bgDataMap.containsKey(acDataKey = controlParam.getAcDataKey(bizModel.getDimensions(), rule, controlParam, rule.getOboMemberNumberMap(), rule.getOboDimIds(), hasUserDefinedDimensionMap))) continue;
                    bgDatas = bgDataMap.get(acDataKey);
                    for (BgData data3 : bgDatas) {
                        changeType = data3.getMemberNumber(SysDimensionEnum.ChangeType.getNumber());
                        version = data3.getMemberNumber(SysDimensionEnum.Version.getNumber());
                        if (changeType == null || version == null) continue;
                        if (isEbByModel) {
                            yearNum = data3.getMemberNumber(SysDimensionEnum.Year.getNumber());
                            periodNum = data3.getMemberNumber(SysDimensionEnum.Period.getNumber());
                        } else {
                            periodNum = data3.getMemberNumber(SysDimensionEnum.BudgetPeriod.getNumber());
                        }
                        if (!this.verifyActual(changeType, version, verAcMemberNum)) continue;
                        for (List<String> period3 : acPeriods) {
                            if (isEbByModel) {
                                if (!period3.get(0).equals(yearNum) || !period3.get(1).equals(periodNum)) continue;
                                data3 = data3.clone();
                                data3.setIgnore(ignore);
                                controlParam.getExtAcData().put(data3.getDataKey((Collection)bizModel.getDimensions()), data3);
                                continue;
                            }
                            if (!period3.get(1).equals(periodNum)) continue;
                            data3 = data3.clone();
                            data3.setIgnore(ignore);
                            controlParam.getExtAcData().put(data3.getDataKey((Collection)bizModel.getDimensions()), data3);
                        }
                    }
                }
            }
            l1 = System.currentTimeMillis() - l1;
            BgControlLogUtils.info(this.getControlData().getStats(), controlParam.isNeedLog(), "budget-control-log : use_time_fillValue_group:" + l1);
        }
        l = System.currentTimeMillis() - l;
        if (controlParams != null && !controlParams.isEmpty()) {
            BgControlLogUtils.info(this.getControlData().getStats(), controlParams.iterator().next().isNeedLog(), "budget-control-log : use_time_fillValue:" + l);
        }
    }

    protected void fillValueByBudgetZeroAdjustCheck(BizModel bizModel, Collection<IControlParam> controlParams) {
        if (bizModel == null || controlParams == null || controlParams.isEmpty()) {
            return;
        }
        int groupNo = 0;
        boolean isEbByModel = bizModel.isEBByModel();
        String AT_ATTotal = "AuditTrail_ATTotal";
        String AT_BO = "AuditTrail_BudgetOccupation";
        boolean hasAdjustCheck = this.getParameter().isHasAdjustCheck();
        Map<String, BigDecimal> adjustValueMap = this.getParameter().getAdjustValueMap();
        Map<String, BigDecimal> submitValueMap = this.getParameter().getSubmitValueMap();
        HashSet existKeys = Sets.newHashSetWithExpectedSize((int)controlParams.size());
        for (IControlParam controlParam : controlParams) {
            List<BgControlSetting> rules;
            String auditTrail;
            if (!controlParam.checkBizModel(bizModel)) continue;
            controlParam.setEbByModel(isEbByModel);
            if (!controlParam.isQueryBudget()) continue;
            List dimensions = bizModel.getDimensions();
            HashMap<Long, Boolean> hasUserDefinedDimensionMap = new HashMap<Long, Boolean>(dimensions.size());
            for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                hasUserDefinedDimensionMap.put(dimension.getId(), BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension));
            }
            List<List<String>> bgPeriods = controlParam.isAddup() ? controlParam.getAcPeriod() : controlParam.getBgPeriod();
            String bgDataKey = controlParam.getBgDataKey(bizModel.getDimensions(), controlParam, hasUserDefinedDimensionMap);
            String string = auditTrail = bgDataKey.contains("AuditTrail_") ? Arrays.stream(bgDataKey.split("!")).filter(k -> k.startsWith("AuditTrail_")).findFirst().get() : "AuditTrail_ATTotal";
            if (bgDataKey.indexOf(auditTrail) >= 0) {
                bgDataKey = bgDataKey.replace(auditTrail, "AuditTrail_BudgetOccupation");
                if (hasAdjustCheck) {
                    this.dealAdjustCheckBudgetOccupation(bgPeriods, bgDataKey, isEbByModel, submitValueMap, controlParam, bizModel.getDimensions());
                }
            }
            if (hasAdjustCheck) {
                this.dealAdjustCheckBudgetAmount(bizModel.getDimensions(), isEbByModel, adjustValueMap, submitValueMap, existKeys, controlParam, hasUserDefinedDimensionMap);
            }
            if ((groupNo = controlParam.getSetting().getGroupNo()) <= 0 || (rules = controlParam.getGroupRuleMap().get(groupNo)) == null) continue;
            String ruleKey = controlParam.getSetting().getKey(controlParam.getBizModel(), controlParam.getControlScheme(), bizModel.getDimensions(), controlParam, controlParam.getSetting().getOboMemberNumberMap(), controlParam.getSetting().getOboDimIds(), hasUserDefinedDimensionMap);
            for (BgControlSetting rule : rules) {
                boolean ignore = ruleKey.equals(rule.getKey(controlParam.getBizModel(), controlParam.getControlScheme(), bizModel.getDimensions(), controlParam, rule.getOboMemberNumberMap(), rule.getOboDimIds(), hasUserDefinedDimensionMap));
                if (bgDataKey.indexOf("AuditTrail_ATTotal") < 0) continue;
                bgDataKey = bgDataKey.replace("AuditTrail_ATTotal", "AuditTrail_BudgetOccupation");
                if (!hasAdjustCheck) continue;
                this.dealAdjustCheckGroupBudgetOccupation(bgPeriods, bgDataKey, isEbByModel, submitValueMap, controlParam, ignore, bizModel.getDimensions());
            }
        }
    }

    private void dealAdjustCheckGroupBudgetOccupation(List<List<String>> bgPeriods, String bgDataKey, boolean isEbByModel, Map<String, BigDecimal> submitValueMap, IControlParam controlParam, boolean ignore, List<kd.epm.eb.common.model.Dimension> dimensions) {
        for (List<String> period : bgPeriods) {
            for (Map.Entry<String, BigDecimal> entry : submitValueMap.entrySet()) {
                boolean adjustCheckFlag;
                String periodKey;
                String key = entry.getKey();
                BigDecimal value = entry.getValue();
                String billNumberStr = this.getAdjustBillNumber(key);
                String billNumber = billNumberStr.replaceAll("billnumber_", "");
                String realKey = key.replaceAll(billNumberStr, "");
                String periodStr = this.getAdjustPeriodKey(key, isEbByModel);
                String[] split = periodStr.split("_");
                if (isEbByModel) {
                    boolean adjustCheckFlag2;
                    String adjustMapKey;
                    if (split.length < 4) continue;
                    periodKey = split[1] + "_" + split[2] + "_" + split[3];
                    String fyPeriod = period.get(0) + "_" + period.get(1);
                    if (!fyPeriod.equals(periodKey) || !realKey.equals(adjustMapKey = bgDataKey + periodStr + "!") || value == null) continue;
                    boolean bl = adjustCheckFlag2 = controlParam.getAdjustCheckFlag() && billNumber.equals(controlParam.getBizNumber());
                    if (!adjustCheckFlag2 && !controlParam.getQueryBalanceAndBudOccFlag()) continue;
                    BgData data = new BgData();
                    data.setIgnore(ignore);
                    data.setValue(value);
                    data.setMember(SysDimensionEnum.Year.getNumber(), period.get(0));
                    data.setMember(SysDimensionEnum.Period.getNumber(), period.get(1));
                    if (!isEbByModel) {
                        String ignoreICKey = key.replaceAll("!InternalCompany_InternalCompany", "").replaceAll("!InternalCompany_ICNone", "");
                        controlParam.getExtAdjustCheckBgOcData().put(ignoreICKey, data);
                        continue;
                    }
                    controlParam.getExtAdjustCheckBgOcData().put(key, data);
                    continue;
                }
                if (split.length < 2 || !(periodKey = split[1]).equals(period.get(1))) continue;
                realKey = realKey.replaceAll(periodStr + "!", "");
                String realKeyByControlDimension = this.getRealKeyByControlDimension(realKey, dimensions, controlParam);
                if (!(realKeyByControlDimension = realKeyByControlDimension.replaceAll("!InternalCompany_InternalCompany", "").replaceAll("!InternalCompany_ICNone", "")).equals(bgDataKey = bgDataKey.replaceAll("!InternalCompany_InternalCompany", "").replaceAll("!InternalCompany_ICNone", "")) || value == null) continue;
                boolean bl = adjustCheckFlag = controlParam.getAdjustCheckFlag() && billNumber.equals(controlParam.getBizNumber());
                if (!adjustCheckFlag && !controlParam.getQueryBalanceAndBudOccFlag()) continue;
                String extAdjustCheckBgOcDataKey = bgDataKey + periodKey;
                Map<String, BgData> extAdjustCheckBgOcData = controlParam.getExtAdjustCheckBgOcData();
                if (extAdjustCheckBgOcData.containsKey(extAdjustCheckBgOcDataKey)) {
                    BgData bgData = extAdjustCheckBgOcData.get(extAdjustCheckBgOcDataKey);
                    bgData.setValue(bgData.getValue().add(value));
                    continue;
                }
                BgData data = new BgData();
                data.setIgnore(ignore);
                data.setValue(value);
                data.setMember(SysDimensionEnum.BudgetPeriod.getNumber(), period.get(1));
                controlParam.getExtAdjustCheckBgOcData().put(extAdjustCheckBgOcDataKey, data);
            }
        }
    }

    private void dealAdjustCheckBudgetAmount(List<kd.epm.eb.common.model.Dimension> dimensions, boolean isEbByModel, Map<String, BigDecimal> adjustValueMap, Map<String, BigDecimal> submitValueMap, Set<String> existKeys, IControlParam controlParam, Map<Long, Boolean> hasUserDefinedDimensionMap) {
        controlParam.setAmend(BigDecimal.ZERO);
        controlParam.setAmount(BigDecimal.ZERO);
        controlParam.setAdjustCheckAmount(BigDecimal.ZERO);
        controlParam.setAdjustCheckAmend(BigDecimal.ZERO);
        controlParam.setAdjustCheckFlag(true);
        if (!isEbByModel && dimensions != null) {
            dimensions = new ArrayList<kd.epm.eb.common.model.Dimension>(dimensions);
            dimensions.removeIf(f -> SysDimensionEnum.InternalCompany.getNumber().equals(f.getNumber()));
        }
        if (adjustValueMap != null && adjustValueMap.size() > 0) {
            String bgDataKey = controlParam.getBgDataKey(dimensions, controlParam, hasUserDefinedDimensionMap);
            Iterator<Map.Entry<String, BigDecimal>> iterator = adjustValueMap.entrySet().iterator();
            while (iterator.hasNext()) {
                String realKey;
                String billNumberStr;
                BigDecimal value;
                String[] split;
                String periodNumber;
                Map.Entry<String, BigDecimal> entry = iterator.next();
                String key = entry.getKey();
                String periodStr = this.getAdjustPeriodKey(key, isEbByModel);
                if (isEbByModel) {
                    periodNumber = controlParam.getYear(true).getNumber() + "_" + controlParam.getPeriod(true).getNumber();
                    split = periodStr.split("_");
                    if (split.length < 4) continue;
                    value = entry.getValue();
                    billNumberStr = this.getAdjustBillNumber(key);
                    realKey = key.replaceAll(billNumberStr, "");
                    String billNumber = billNumberStr.replaceAll("billnumber_", "");
                    String bgDataKeyByPeriod = bgDataKey + SysDimensionEnum.Period.getNumber() + "_" + periodNumber + "!";
                    BgControlLogUtils.info(this.getControlData().getStats(), true, "adjustCheck adjustValueMapKey " + key + " bgDataKey " + bgDataKey + " realKey " + realKey + " bgDataKeyByPeriod " + bgDataKeyByPeriod);
                    if (!realKey.equals(bgDataKeyByPeriod) || value == null || !billNumber.equals(controlParam.getBizNumber()) || existKeys.contains(key)) continue;
                    controlParam.setAdjustCheckAmount(value);
                    controlParam.setAdjustCheckAmend(value);
                    existKeys.add(key);
                    continue;
                }
                periodNumber = controlParam.getPeriod(true).getNumber();
                split = periodStr.split("_");
                if (split.length < 2 || !periodNumber.equals(split[1])) continue;
                value = entry.getValue();
                billNumberStr = this.getAdjustBillNumber(key);
                realKey = key.replaceAll(billNumberStr, "").replaceAll(periodStr + "!", "");
                String realKeyByControlDimension = this.getRealKeyByControlDimension(realKey, dimensions, controlParam);
                String billNumber = billNumberStr.replaceAll("billnumber_", "");
                BgControlLogUtils.info(this.getControlData().getStats(), true, "adjustCheck adjustValueMapKey " + key + " bgDataKey " + bgDataKey + " realKey " + realKey + " realKeyByControlDimension " + realKeyByControlDimension);
                if (!(realKeyByControlDimension = realKeyByControlDimension.replaceAll("!InternalCompany_InternalCompany", "").replaceAll("!InternalCompany_ICNone", "")).equals(bgDataKey = bgDataKey.replaceAll("!InternalCompany_InternalCompany", "").replaceAll("!InternalCompany_ICNone", "")) || value == null || !billNumber.equals(controlParam.getBizNumber())) continue;
                controlParam.setAdjustCheckAmount(value);
                controlParam.setAdjustCheckAmend(value);
                iterator.remove();
                break;
            }
        }
    }

    private String getRealKeyByControlDimension(String realKey, List<kd.epm.eb.common.model.Dimension> controlDimensions, IControlParam controlParam) {
        List controlDimNumbers = controlDimensions.stream().map(kd.epm.eb.common.model.Dimension::getNumber).collect(Collectors.toList());
        Long modelId = controlParam.getBizModel().getId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        kd.epm.eb.common.model.Member account = controlParam.getAccount(true);
        Member cacheAccount = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, account.getNumber());
        List dimensionList = modelCacheHelper.getDimensionList(cacheAccount.getDatasetId());
        List dimNumbers = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        String[] split = realKey.split("!");
        StringBuilder realKeySb = new StringBuilder();
        HashMap<String, String> existDimAndMemberMap = new HashMap<String, String>(split.length);
        for (String dimAndMember : split) {
            String[] split1 = dimAndMember.split("_");
            if (split1.length == 1) {
                realKeySb.append(split1[0]).append("!");
            }
            existDimAndMemberMap.put(split1[0], dimAndMember);
        }
        controlDimNumbers.removeAll(dimNumbers);
        for (kd.epm.eb.common.model.Dimension controlDimension : controlDimensions) {
            Set ignDimNumbers = BgDataUtils.getIgnDimNumbers();
            if (ignDimNumbers != null && ignDimNumbers.contains(controlDimension.getNumber())) continue;
            String controlDimensionNumber = controlDimension.getNumber();
            if (SysDimensionEnum.InternalCompany.getNumber().equals(controlDimensionNumber)) {
                realKeySb.append(SysDimensionEnum.InternalCompany.getNumber()).append("_").append(SysDimensionEnum.InternalCompany.getNumber()).append("!");
                continue;
            }
            if (existDimAndMemberMap.containsKey(controlDimensionNumber)) {
                realKeySb.append((String)existDimAndMemberMap.get(controlDimensionNumber)).append("!");
                continue;
            }
            if (!controlDimNumbers.contains(controlDimensionNumber)) continue;
            realKeySb.append(controlDimensionNumber).append("_").append(controlDimensionNumber).append("!");
        }
        return realKeySb.toString();
    }

    private void dealAdjustCheckBudgetOccupation(List<List<String>> bgPeriods, String bgDataKey, boolean isEbByModel, Map<String, BigDecimal> submitValueMap, IControlParam controlParam, List<kd.epm.eb.common.model.Dimension> dimensions) {
        for (List<String> period : bgPeriods) {
            for (Map.Entry<String, BigDecimal> entry : submitValueMap.entrySet()) {
                boolean adjustCheckFlag;
                String periodKey;
                String key = entry.getKey();
                BigDecimal value = entry.getValue();
                String billNumberStr = this.getAdjustBillNumber(key);
                String billNumber = billNumberStr.replaceAll("billnumber_", "");
                String realKey = key.replaceAll(billNumberStr, "");
                String periodStr = this.getAdjustPeriodKey(key, isEbByModel);
                String[] split = periodStr.split("_");
                if (isEbByModel) {
                    boolean adjustCheckFlag2;
                    String adjustMapKey;
                    if (split.length < 4) continue;
                    periodKey = split[1] + "_" + split[2] + "_" + split[3];
                    String fyPeriod = period.get(0) + "_" + period.get(1);
                    if (!fyPeriod.equals(periodKey) || !realKey.equals(adjustMapKey = bgDataKey + periodStr + "!") || value == null) continue;
                    boolean bl = adjustCheckFlag2 = controlParam.getAdjustCheckFlag() && billNumber.equals(controlParam.getBizNumber());
                    if (!adjustCheckFlag2 && !controlParam.getQueryBalanceAndBudOccFlag()) continue;
                    controlParam.getAdjustCheckBudgetOccupationValues().put(fyPeriod, value);
                    continue;
                }
                if (split.length < 2 || !(periodKey = split[1]).equals(period.get(1))) continue;
                realKey = realKey.replaceAll(periodStr + "!", "");
                String realKeyByControlDimension = this.getRealKeyByControlDimension(realKey, dimensions, controlParam);
                if (!(realKeyByControlDimension = realKeyByControlDimension.replaceAll("!InternalCompany_InternalCompany", "").replaceAll("!InternalCompany_ICNone", "")).equals(bgDataKey = bgDataKey.replaceAll("!InternalCompany_InternalCompany", "").replaceAll("!InternalCompany_ICNone", "")) || value == null) continue;
                boolean bl = adjustCheckFlag = controlParam.getAdjustCheckFlag() && billNumber.equals(controlParam.getBizNumber());
                if (!adjustCheckFlag && !controlParam.getQueryBalanceAndBudOccFlag()) continue;
                Map<String, BigDecimal> adjustCheckBudgetOccupationValues = controlParam.getAdjustCheckBudgetOccupationValues();
                if (adjustCheckBudgetOccupationValues.containsKey(periodKey)) {
                    BigDecimal bigDecimal = adjustCheckBudgetOccupationValues.get(periodKey);
                    adjustCheckBudgetOccupationValues.put(periodKey, bigDecimal.add(value));
                    continue;
                }
                adjustCheckBudgetOccupationValues.put(periodKey, value);
            }
        }
    }

    private String getAdjustPeriodKey(String key, boolean isEbByModel) {
        String[] split;
        String periodStr = "";
        for (String s : split = key.split("!")) {
            if (isEbByModel) {
                if (!s.startsWith(SysDimensionEnum.Period.getNumber())) continue;
                periodStr = s;
                continue;
            }
            if (!s.startsWith(SysDimensionEnum.BudgetPeriod.getNumber())) continue;
            periodStr = s;
        }
        return periodStr;
    }

    private String getAdjustBillNumber(String key) {
        String[] split;
        String billNumberStr = "";
        for (String s : split = key.split("!")) {
            if (!s.startsWith("billnumber")) continue;
            billNumberStr = s;
        }
        return billNumberStr;
    }

    protected boolean verifyBudget(@NotNull String changeType, @NotNull String ctrlParamChangeType, @NotNull String version, @NotNull String ctrlParamVersion) {
        return changeType.equals(ctrlParamChangeType) && version.equals(ctrlParamVersion);
    }

    protected boolean verifyActual(@NotNull String changeType, @NotNull String version, @NotNull String ctrlParamVersion) {
        return (changeType.equals("Execute") || changeType.equals("Occupation") || changeType.equals("ActualChanges")) && version.equals(ctrlParamVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<IControlParam> builderParams(IControlParameter parameter, BgControlScheme scheme, BgControlData controlData, Map<String, String> props, List<Map<String, Object>> propsMap) {
        LogStats schemeStats = new LogStats("budget-control-log : ");
        schemeStats.addInfo("begin-builderParams");
        if (controlData.getStats().getLogs() != null) {
            schemeStats.setLogs(controlData.getStats().getLogs());
        }
        if (scheme != null) {
            scheme.setStats(schemeStats);
        }
        try {
            Collection<IControlParam> params = BgControlParamUtils.get().setParameter(parameter).setScheme(scheme).builderParams(controlData, props, propsMap);
            if (params != null) {
                DataSet ds;
                HashMap<Long, String> bussModelNames = new HashMap<Long, String>(10);
                HashMap<Long, String> modelNames = new HashMap<Long, String>(10);
                HashMap<Long, IModelCacheHelper> cacheHelpers = new HashMap<Long, IModelCacheHelper>(10);
                for (IControlParam iControlParam : params) {
                    Long busId;
                    if (iControlParam.getBizModel() == null) continue;
                    IModelCacheHelper cacheHelper = (IModelCacheHelper)cacheHelpers.get(iControlParam.getBizModel().getId());
                    if (cacheHelper == null) {
                        cacheHelper = ModelCacheContext.getOrCreate((Long)iControlParam.getBizModel().getId());
                        cacheHelpers.put(iControlParam.getBizModel().getId(), cacheHelper);
                    }
                    modelNames.put(iControlParam.getBizModel().getId(), null);
                    if (iControlParam.getBizModel().getStartVersion() != null && IDUtils.isNotNull((Long)(busId = IDUtils.toLong((Object)iControlParam.getBizModel().getStartVersion().get("bussmodel.id"))))) {
                        bussModelNames.put(busId, null);
                    }
                    this.setName(iControlParam, true, SysDimensionEnum.Version.getNumber(), cacheHelper);
                    this.setName(iControlParam, true, SysDimensionEnum.DataType.getNumber(), cacheHelper);
                    this.setName(iControlParam, true, SysDimensionEnum.Currency.getNumber(), cacheHelper);
                    this.setName(iControlParam, true, SysDimensionEnum.ChangeType.getNumber(), cacheHelper);
                    this.setName(iControlParam, true, SysDimensionEnum.AuditTrail.getNumber(), cacheHelper);
                    this.setName(iControlParam, false, SysDimensionEnum.AuditTrail.getNumber(), cacheHelper);
                    this.setName(iControlParam, true, SysDimensionEnum.BudgetPeriod.getNumber(), cacheHelper);
                    this.setName(iControlParam, true, SysDimensionEnum.Year.getNumber(), cacheHelper);
                    this.setName(iControlParam, true, SysDimensionEnum.Period.getNumber(), cacheHelper);
                }
                if (!bussModelNames.isEmpty()) {
                    ds = QueryServiceHelper.queryDataSet((String)"queryBusModel", (String)"eb_businessmodel", (String)"id,name", (QFilter[])new QFilter("id", "in", new HashSet(bussModelNames.keySet())).toArray(), null);
                    Throwable throwable = null;
                    try {
                        while (ds != null && ds.hasNext()) {
                            Row r2 = ds.next();
                            bussModelNames.put(r2.getLong("id"), r2.getString("name"));
                        }
                    }
                    catch (Throwable r2) {
                        Throwable throwable2 = r2;
                        throw r2;
                    }
                    finally {
                        if (ds != null) {
                            if (throwable != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable r2) {
                                    throwable.addSuppressed(r2);
                                }
                            } else {
                                ds.close();
                            }
                        }
                    }
                }
                if (!modelNames.isEmpty()) {
                    ds = QueryServiceHelper.queryDataSet((String)"queryModel", (String)"epm_model", (String)"id,name", (QFilter[])new QFilter("id", "in", new HashSet(modelNames.keySet())).toArray(), null);
                    Throwable throwable = null;
                    try {
                        while (ds != null && ds.hasNext()) {
                            Row r3 = ds.next();
                            modelNames.put(r3.getLong("id"), r3.getString("name"));
                        }
                    }
                    catch (Throwable r3) {
                        Throwable throwable3 = r3;
                        throw r3;
                    }
                    finally {
                        if (ds != null) {
                            if (throwable != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable r3) {
                                    throwable.addSuppressed(r3);
                                }
                            } else {
                                ds.close();
                            }
                        }
                    }
                }
                for (IControlParam iControlParam : params) {
                    if (iControlParam.getBizModel() == null || iControlParam.getBizModel().getStartVersion() == null) continue;
                    Long busId = IDUtils.toLong((Object)iControlParam.getBizModel().getStartVersion().get("bussmodel.id"));
                    if (IDUtils.isNotNull((Long)busId)) {
                        iControlParam.getBizModel().getStartVersion().set("bussmodel.name", bussModelNames.get(busId));
                    }
                    if (iControlParam.getBizModel().getObject() == null) continue;
                    iControlParam.getBizModel().getObject().set("name", modelNames.get(iControlParam.getBizModel().getId()));
                }
            }
            Collection<IControlParam> collection = params;
            return collection;
        }
        finally {
            if (scheme != null) {
                scheme.setStats(controlData.getStats());
                BgControlLogUtils.info(this.getControlData().getStats(), true, schemeStats.toString());
            }
        }
    }

    private void setName(IControlParam param, boolean isBudget, String dimNumber, IModelCacheHelper cacheHelper) {
        Member _m;
        if (param == null || StringUtils.isEmpty((String)dimNumber) || cacheHelper == null) {
            return;
        }
        kd.epm.eb.common.model.Member m = param.getMember(isBudget, dimNumber);
        if (m != null && (_m = cacheHelper.getMemberByAnyView(param.getBizModel().getControlBusModelId(), dimNumber, m.getNumber())) != null) {
            m.setName(_m.getName());
        }
    }

    protected void checkControlParams(Map<Long, BizModel> bizModels, Collection<IControlParam> controlParams) {
        if (bizModels == null || bizModels.isEmpty() || controlParams == null || controlParams.isEmpty()) {
            return;
        }
        kd.epm.eb.common.model.Member member = null;
        LinkedHashMap notLeafMemberMap = Maps.newLinkedHashMap();
        for (IControlParam iControlParam : controlParams) {
            if (iControlParam.getBizModel() == null) continue;
            BizModel bizModel = bizModels.get(iControlParam.getBizModel().getKey());
            if (bizModel == null) {
                BgControlLogUtils.info(this.getControlData().getStats(), true, "nofound-bizModel=" + iControlParam.getBizModel().getKey());
                continue;
            }
            Map subMap = notLeafMemberMap.computeIfAbsent(bizModel.getKey(), f -> new HashMap(10));
            for (kd.epm.eb.common.model.Dimension dimension : bizModel.getDimensions()) {
                List notLeafMemberList = null;
                if (SysDimensionEnum.Version.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.Year.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber()) || (member = iControlParam.getMember(false, dimension.getNumber())) == null || member.isLeaf()) continue;
                notLeafMemberList = subMap.computeIfAbsent(dimension.getName(), f -> Lists.newLinkedList());
                notLeafMemberList.add(ControlException.memberNameAndNumberFormat((kd.epm.eb.common.model.Member)member));
            }
        }
        if (!this.getParameter().isHasShareQuery()) {
            for (Map.Entry entry : notLeafMemberMap.entrySet()) {
                if (entry.getValue() == null || ((Map)entry.getValue()).isEmpty()) continue;
                int i = 1;
                StringBuilder str = new StringBuilder();
                ArrayList notLeafMemberDimNames = new ArrayList(((Map)entry.getValue()).keySet());
                str.append(ControlException.notLeafByMemberFirst(notLeafMemberDimNames, (BizModel)bizModels.get(entry.getKey()))).append("\r\n");
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    String dimName = (String)entry2.getKey();
                    List notLeafMembers = (List)entry2.getValue();
                    str.append(ControlException.notLeafMemberByDim((int)i++, (String)dimName, (List)notLeafMembers)).append("\r\n");
                }
                str.setLength(str.length() - 1);
                ControlException.notExistMember((String)str.toString());
            }
        }
    }

    public void builderMembersForReturn(Map<Long, BizModel> bizModelMap, Collection<IControlParam> controlParams) {
        this.members = this.builderMembers(bizModelMap, controlParams);
    }

    /*
     * WARNING - void declaration
     */
    public Map<Long, List<Map<String, Map<String, kd.epm.eb.common.model.Member>>>> builderMembers(Map<Long, BizModel> bizModelMap, Collection<IControlParam> controlParams) {
        HashMap<Long, List<Map<String, Map<String, kd.epm.eb.common.model.Member>>>> members = new HashMap<Long, List<Map<String, Map<String, kd.epm.eb.common.model.Member>>>>(10);
        if (bizModelMap == null || bizModelMap.isEmpty() || controlParams == null || controlParams.isEmpty()) {
            return members;
        }
        HashMap<String, Map<String, kd.epm.eb.common.model.Member>> bgMemberMap = new HashMap(16);
        HashMap<String, Map<String, kd.epm.eb.common.model.Member>> acMemberMap = new HashMap(16);
        Map<String, kd.epm.eb.common.model.Member> memberMap = null;
        kd.epm.eb.common.model.Member member = null;
        Member cacheMember = null;
        kd.epm.eb.common.model.Member budgetOccupation = new kd.epm.eb.common.model.Member(Long.valueOf(0L), ResManager.loadKDString((String)"\u5728\u9014\u5360\u7528\u9884\u7b97", (String)"CalcBalance_1", (String)"epm-eb-business", (Object[])new Object[0]), "BudgetOccupation");
        for (IControlParam controlParam : controlParams) {
            if (!controlParam.isQueryBudget()) {
                BgControlLogUtils.infoThread(this.getControlData().getStats(), true, () -> SerializationUtils.toJsonString(controlParam.toMap()));
                continue;
            }
            BizModel bizModel = bizModelMap.get(controlParam.getBizModel().getKey());
            if (bizModel == null) {
                BgControlLogUtils.info(this.getControlData().getStats(), true, "nofound-bizmodel=" + controlParam.getBizModel().getKey());
                continue;
            }
            ArrayList<HashMap<String, Map<String, kd.epm.eb.common.model.Member>>> subMembers = (ArrayList<HashMap<String, Map<String, kd.epm.eb.common.model.Member>>>)members.get(bizModel.getKey());
            if (subMembers == null) {
                subMembers = new ArrayList<HashMap<String, Map<String, kd.epm.eb.common.model.Member>>>(20);
                members.put(bizModel.getKey(), subMembers);
                bgMemberMap = new HashMap();
                subMembers.add(bgMemberMap);
                acMemberMap = new HashMap();
                subMembers.add(acMemberMap);
            } else {
                bgMemberMap = (Map)subMembers.get(0);
                acMemberMap = (Map)subMembers.get(1);
            }
            List dimensions = bizModel.getDimensions();
            for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                if (SysDimensionEnum.Year.getNumber().equals(dimension.getNumber())) continue;
                if (SysDimensionEnum.Period.getNumber().equals(dimension.getNumber())) {
                    List period;
                    Map<String, kd.epm.eb.common.model.Member> yearMap = this.getMembers(SysDimensionEnum.Year.getNumber(), bgMemberMap);
                    Map<String, kd.epm.eb.common.model.Member> periodMap = this.getMembers(SysDimensionEnum.Period.getNumber(), bgMemberMap);
                    Object periods = controlParam.getBgPeriod();
                    Iterator<List<String>> iterator = periods.iterator();
                    while (iterator.hasNext()) {
                        period = iterator.next();
                        member = new kd.epm.eb.common.model.Member(dimension);
                        member.setNumber(period.get(0));
                        member.setLeaf(true);
                        yearMap.put(member.getNumber(), member);
                        member = new kd.epm.eb.common.model.Member(dimension);
                        member.setNumber((String)period.get(1));
                        member.setLeaf(Boolean.parseBoolean((String)period.get(2)));
                        periodMap.put(member.getNumber(), member);
                    }
                    yearMap = this.getMembers(SysDimensionEnum.Year.getNumber(), acMemberMap);
                    periodMap = this.getMembers(SysDimensionEnum.Period.getNumber(), acMemberMap);
                    periods = controlParam.getAcPeriod();
                    Iterator iterator2 = periods.iterator();
                    while (iterator2.hasNext()) {
                        period = (List)iterator2.next();
                        member = new kd.epm.eb.common.model.Member(dimension);
                        member.setNumber((String)period.get(0));
                        member.setLeaf(true);
                        yearMap.put(member.getNumber(), member);
                        member = new kd.epm.eb.common.model.Member(dimension);
                        member.setNumber((String)period.get(1));
                        member.setLeaf(Boolean.parseBoolean((String)period.get(2)));
                        periodMap.put(member.getNumber(), member);
                    }
                    continue;
                }
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) {
                    Map<String, kd.epm.eb.common.model.Member> periodMap = this.getMembers(SysDimensionEnum.BudgetPeriod.getNumber(), bgMemberMap);
                    List<List<String>> periods = controlParam.getBgPeriod();
                    for (List list : periods) {
                        member = new kd.epm.eb.common.model.Member(dimension);
                        member.setNumber((String)list.get(1));
                        member.setLeaf(Boolean.parseBoolean((String)list.get(2)));
                        periodMap.put(member.getNumber(), member);
                    }
                    periodMap = this.getMembers(SysDimensionEnum.BudgetPeriod.getNumber(), acMemberMap);
                    periods = controlParam.getAcPeriod();
                    for (List list : periods) {
                        member = new kd.epm.eb.common.model.Member(dimension);
                        member.setNumber((String)list.get(1));
                        member.setLeaf(Boolean.parseBoolean((String)list.get(2)));
                        periodMap.put(member.getNumber(), member);
                    }
                    continue;
                }
                if (SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber())) {
                    memberMap = this.getMembers(dimension.getNumber(), bgMemberMap);
                    member = controlParam.getMember(true, SysDimensionEnum.ChangeType.getNumber());
                    memberMap.put(member.getNumber(), member);
                    memberMap = this.getMembers(dimension.getNumber(), acMemberMap);
                    member = controlParam.getMember(false, SysDimensionEnum.ChangeType.getNumber());
                    memberMap.put(member.getNumber(), member);
                    if (!memberMap.containsKey("Execute")) {
                        member = new kd.epm.eb.common.model.Member(null, "Execute", "Execute");
                        member.setDimension(dimension);
                        member.setLeaf(true);
                        memberMap.put("Execute", member);
                    }
                    if (!memberMap.containsKey("Occupation")) {
                        member = new kd.epm.eb.common.model.Member(null, "Occupation", "Occupation");
                        member.setDimension(dimension);
                        member.setLeaf(true);
                        memberMap.put("Occupation", member);
                    }
                    if (memberMap.containsKey("ActualChanges")) continue;
                    member = new kd.epm.eb.common.model.Member(null, "ActualChanges", "ActualChanges");
                    member.setDimension(dimension);
                    member.setLeaf(true);
                    memberMap.put("ActualChanges", member);
                    continue;
                }
                if (SysDimensionEnum.Version.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.DataType.getNumber().equals(dimension.getNumber())) {
                    memberMap = this.getMembers(dimension.getNumber(), bgMemberMap);
                    member = controlParam.getMember(true, dimension.getNumber());
                    memberMap.put(member.getNumber(), member);
                    memberMap = this.getMembers(dimension.getNumber(), acMemberMap);
                    member = controlParam.getMember(false, dimension.getNumber());
                    memberMap.put(member.getNumber(), member);
                    continue;
                }
                if (SysDimensionEnum.AuditTrail.getNumber().equals(dimension.getNumber())) {
                    memberMap = this.getMembers(dimension.getNumber(), bgMemberMap);
                    member = controlParam.getMember(true, SysDimensionEnum.AuditTrail.getNumber());
                    memberMap.put(member.getNumber(), member);
                    memberMap = this.getMembers(dimension.getNumber(), acMemberMap);
                    member = controlParam.getMember(false, SysDimensionEnum.AuditTrail.getNumber());
                    memberMap.put(member.getNumber(), member);
                    memberMap = this.getMembers(dimension.getNumber(), bgMemberMap);
                    memberMap.put(budgetOccupation.getNumber(), budgetOccupation);
                    continue;
                }
                memberMap = this.getMembers(dimension.getNumber(), bgMemberMap);
                member = controlParam.getMember(true, dimension.getNumber());
                memberMap.put(member.getNumber(), member);
                memberMap = this.getMembers(dimension.getNumber(), acMemberMap);
                member = controlParam.getMember(false, dimension.getNumber());
                memberMap.put(member.getNumber(), member);
            }
            if (controlParam != null && controlParam.isNeedLog()) {
                log.info("groupRuleMap," + JSONUtils.toString(controlParam.getGroupRuleMap(), (int)this.getMaxLength()));
            }
            if (controlParam.getGroupRuleMap().isEmpty()) continue;
            int groupNo = controlParam.getSetting().getGroupNo();
            List<BgControlSetting> rules = controlParam.getGroupRuleMap().get(groupNo);
            if (rules == null) continue;
            Long modelId = controlParam.getBizModel().getId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Object userDefined = null;
            Object var20_26 = null;
            String userDefNumber = null;
            String groupAccountNumber = null;
            String groupAccountName = null;
            Long userDefinedId = null;
            Map<Long, Set<String>> oboMemberNumberMap = rules.get(0).getOboMemberNumberMap();
            HashMap<Long, Boolean> hasUserDefinedDimensionMap = new HashMap<Long, Boolean>(dimensions.size());
            for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                member = controlParam.getMember(true, dimension.getNumber());
                if (CollectionUtils.isNotEmpty((Collection)oboMemberNumberMap.get(dimension.getId()))) {
                    for (String oboMemberNumber : oboMemberNumberMap.get(dimension.getId())) {
                        memberMap = this.getMembers(dimension.getNumber(), bgMemberMap);
                        Member oboMember = modelCacheHelper.getMemberByAnyView(bizModel.getControlBusModelId(), dimension.getNumber(), oboMemberNumber);
                        if (oboMember == null || !oboMember.getNumber().equals(member.getNumber())) continue;
                        member = new kd.epm.eb.common.model.Member(null, oboMember.getName(), oboMember.getNumber());
                        memberMap.put(member.getNumber(), member);
                    }
                }
                hasUserDefinedDimensionMap.put(dimension.getId(), BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension));
            }
            for (BgControlSetting setting : rules) {
                memberMap = this.getMembers(SysDimensionEnum.Account.getNumber(), bgMemberMap);
                groupAccountNumber = setting.getGroupAccountNumber();
                if (StringUtils.isNotEmpty((String)groupAccountNumber)) {
                    groupAccountName = setting.getGroupAccountName();
                    member = new kd.epm.eb.common.model.Member(null, groupAccountName, groupAccountNumber);
                } else {
                    member = new kd.epm.eb.common.model.Member(null, setting.getAccountName(), setting.getAccountNumber());
                }
                memberMap.put(member.getNumber(), member);
                if (this.getParameter().isHasAdjustCheck() || this.getParameter().isHasQueryActControlRule()) {
                    for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                        if (!((Boolean)hasUserDefinedDimensionMap.get(dimension.getId())).booleanValue()) continue;
                        for (int i = 1; i <= 7; ++i) {
                            member = null;
                            userDefinedId = setting.getObject().getDynamicObject("userDefinedRuleField").getLong("dimentions.userdefineddimid" + i);
                            memberMap = this.getMembers(dimension.getNumber(), bgMemberMap);
                            if (userDefinedId != null && userDefinedId.equals(dimension.getId())) {
                                userDefNumber = setting.getObject().getDynamicObject("userDefinedRuleField").getString("dimentions.userdefined" + i + ".number");
                                String string = setting.getObject().getDynamicObject("userDefinedRuleField").getString("dimentions.userdefined" + i + ".name");
                                if (StringUtils.isNotEmpty((String)userDefNumber) && StringUtils.isNotEmpty((String)string)) {
                                    member = new kd.epm.eb.common.model.Member(null, string, userDefNumber);
                                }
                            } else {
                                List<Long> groupRuleOboDimIdList = setting.getOboDimIds();
                                if (CollectionUtils.isNotEmpty(groupRuleOboDimIdList) && groupRuleOboDimIdList.contains(dimension.getId())) continue;
                                Long viewId = modelCacheHelper.getViewByBusModelAndDimNumber(bizModel.getControlBusModelId(), dimension.getNumber());
                                cacheMember = modelCacheHelper.getRootMember(dimension.getNumber(), viewId);
                                member = new kd.epm.eb.common.model.Member(null, cacheMember.getName(), cacheMember.getNumber());
                            }
                            if (member == null) continue;
                            memberMap.put(member.getNumber(), member);
                        }
                    }
                    continue;
                }
                HashMap<Long, String[]> userDefinedMapNew = new HashMap<Long, String[]>(7);
                for (int i = 1; i <= 7; ++i) {
                    DynamicObject dynamicObject;
                    if (setting.getObject() == null || setting.getObject().getDynamicObject("userDefinedRuleField") == null || (dynamicObject = setting.getObject().getDynamicObject("userDefinedRuleField")).get("dimentions.userdefineddimid" + i) == null || dynamicObject.get("dimentions.userdefined" + i + ".number") == null) continue;
                    userDefinedMapNew.put(dynamicObject.getLong("dimentions.userdefineddimid" + i), new String[]{dynamicObject.getString("dimentions.userdefined" + i + ".number"), dynamicObject.getString("dimentions.userdefined" + i + ".name")});
                }
                for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                    if (!BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension)) continue;
                    member = null;
                    String[] userdefs = (String[])userDefinedMapNew.get(dimension.getId());
                    if (userdefs != null && userdefs.length >= 2) {
                        userDefNumber = ((String[])userDefinedMapNew.get(dimension.getId()))[0];
                        String string = ((String[])userDefinedMapNew.get(dimension.getId()))[1];
                    } else {
                        userDefNumber = null;
                        Object var20_30 = null;
                    }
                    memberMap = this.getMembers(dimension.getNumber(), bgMemberMap);
                    if (StringUtils.isNotEmpty((String)userDefNumber)) {
                        void var20_33;
                        void var20_31;
                        if (StringUtils.isEmpty((String)var20_31)) {
                            String string = userDefNumber;
                        }
                        member = new kd.epm.eb.common.model.Member(null, (String)var20_33, userDefNumber);
                    } else {
                        List<Long> oboDimIdList = setting.getOboDimIds();
                        if (CollectionUtils.isNotEmpty(oboDimIdList) && oboDimIdList.contains(dimension.getId())) continue;
                        List pairs = ModelCacheServiceHelper.getMemberByAnyViewPair((Model)modelCacheHelper.getModelobj(), (Long)bizModel.getControlBusModelId(), (String)dimension.getNumber(), (String)dimension.getNumber(), (boolean)false);
                        if (pairs != null) {
                            for (Pair p : pairs) {
                                member = new kd.epm.eb.common.model.Member(null, ((Member)p.p1).getName(), ((Member)p.p1).getNumber());
                                memberMap.put(member.getNumber(), member);
                            }
                        }
                    }
                    if (member == null) continue;
                    memberMap.put(member.getNumber(), member);
                }
            }
        }
        if (bgMemberMap.isEmpty() && acMemberMap.isEmpty()) {
            members.clear();
        }
        return members;
    }

    private Map<String, kd.epm.eb.common.model.Member> getMembers1(kd.epm.eb.common.model.Dimension dimenion, Map<String, Map<String, kd.epm.eb.common.model.Member>> dimMembers) {
        return this.getMembers(dimenion.getNumber(), dimMembers);
    }

    private Map<String, kd.epm.eb.common.model.Member> getMembers(String dimNumber, Map<String, Map<String, kd.epm.eb.common.model.Member>> dimMembers) {
        if (StringUtils.isEmpty((String)dimNumber) || dimMembers == null) {
            throw new KDBizException("error members parameter.");
        }
        return dimMembers.computeIfAbsent(dimNumber, f -> new HashMap());
    }

    private static /* synthetic */ Set lambda$queryOlapByShrek$10(String dimension, String f) {
        HashSet<String> _members = new HashSet<String>();
        if (SysDimensionEnum.InternalCompany.getNumber().equals(dimension)) {
            _members.add("ICNone");
        } else {
            _members.add(dimension);
        }
        return _members;
    }

    private static /* synthetic */ Set lambda$queryOlapByShrek$9(String f) {
        return Sets.newLinkedHashSet();
    }

    private static /* synthetic */ String lambda$queryOlapByShrek$8(kd.epm.eb.common.model.Dimension d) {
        return d.getNumber();
    }

    private static /* synthetic */ Set lambda$queryOlapByShrek$7(Long f) {
        return Sets.newLinkedHashSet();
    }
}

