/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.calc;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.property.BooleanProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.impl.ThreadPoolImpl;
import kd.epm.eb.common.cache.control.BgLockCacheServiceHelper;
import kd.epm.eb.common.cache.control.BgLockMapping;
import kd.epm.eb.common.constant.BgControlConstant;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.control.eums.ControlResultEnum;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.calc.BalanceCheck;
import kd.epm.eb.control.impl.calc.CalcBalance;
import kd.epm.eb.control.impl.calc.ControlLock;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgReturnBudgetUtils;

public class CalcControl
extends ControlLock {
    private static final Log log = LogFactory.getLog(CalcControl.class);
    private Collection<BizModel> models = null;
    private BgControlData controlData;
    private List<IControlParam> controlParams = Collections.synchronizedList(new LinkedList());
    public List<BgControlRecord> returnRecords = new ArrayList<BgControlRecord>();
    private static volatile ThreadPool threadPool = null;
    private Map<Long, Long> lockTimestamps = new HashMap<Long, Long>(10);

    public void setModels(Collection<BizModel> models) {
        this.models = models;
    }

    protected Collection<BizModel> getModels() {
        return Collections.unmodifiableCollection(this.models);
    }

    protected BgControlData getControlData() {
        return this.controlData;
    }

    public List<IControlParam> getControlParams() {
        return this.controlParams;
    }

    public static CalcControl getInterface(BgControlData controlData) {
        return new CalcControl(controlData);
    }

    public CalcControl(BgControlData controlData) {
        this.controlData = controlData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPool getThreadPool() {
        if (threadPool != null) return threadPool;
        Class<CalcControl> clazz = CalcControl.class;
        synchronized (CalcControl.class) {
            if (threadPool != null) return threadPool;
            threadPool = CalcThreadPool.createExecutorService("controlCalcPools", 2, 10);
            // ** MonitorExit[var0] (shouldn't be in output)
            return threadPool;
        }
    }

    public Long getLockMainKey() {
        if (this.getModels().size() >= 1) {
            BizModel model = this.getModels().iterator().next();
            if (model.isEBByModel()) {
                return model.getId();
            }
            return model.getControlBusModelId();
        }
        return 0L;
    }

    public Map<Long, Long> getLockTimestamps() {
        return this.lockTimestamps;
    }

    public Map<Long, Set<Long>> getLockKeys() {
        HashMap<Long, Set<Long>> lockKeys = new HashMap<Long, Set<Long>>(10);
        if (this.getModels() == null || this.getModels().isEmpty()) {
            return lockKeys;
        }
        for (BizModel bizModel : this.getModels()) {
            Long bizModelId = bizModel.getId();
            Long lockMainKey = bizModel.getKey();
            Long bussModelId = 0L;
            if (!bizModel.isEBByModel()) {
                bussModelId = bizModel.getControlBusModelId();
            }
            if (!ControlParamsSettingUtil.isLockOrgUnit((Long)bizModel.getId())) {
                lockKeys.put(lockMainKey, null);
                continue;
            }
            HashSet orgIds = new HashSet();
            this.getControlParams().forEach(f -> {
                if (f.getBizModel() != null && f.getBizModel().getKey().equals(bizModel.getKey())) {
                    orgIds.add(f.getOrgUnit(true).getId());
                    orgIds.add(f.getOrgUnit(false).getId());
                }
            });
            BizModel model = this.getModels().iterator().next();
            BgLockMapping mapping = BgLockCacheServiceHelper.getNoLeafLockMember((Long)bizModelId, (Long)bussModelId, (LogStats)this.getStats());
            this.lockTimestamps.put(lockMainKey, mapping.getTime().getTime());
            lockKeys.put(lockMainKey, mapping.getLockOrgIds(orgIds));
        }
        return lockKeys;
    }

    public LogStats getStats() {
        if (this.getControlData() != null) {
            return this.getControlData().getStats();
        }
        return super.getStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object beforeLock() {
        if (this.getModels() == null) return null;
        if (this.getModels().isEmpty()) return null;
        if (this.getControlData() == null) return null;
        if (this.getControlData().getBizOrgUnit() == null) return null;
        if (this.getControlData().getBizTime() == null) {
            return null;
        }
        StringBuilder error = new StringBuilder();
        try {
            CalcBalance calc = new CalcBalance(this.getParameter(), this.getControlData().copy(this.getModels()), this);
            calc.beforeCalc();
            this.merge(calc.getControlParams());
            return calc;
        }
        catch (KDBizException ex) {
            log.error("budget-control-log : calc-balance-error:", (Throwable)ex);
            throw ex;
        }
        catch (Throwable ex) {
            log.error("budget-control-log : calc-balance-error:", ex);
            error.append(ex.getMessage()).append("\r\n");
        }
        if (error.length() <= 0) return null;
        ControlException.erorrOther((String)error.toString());
        return null;
    }

    public void lockDo(Object calc) {
        this.returnBudget();
        if (calc != null) {
            Collection<IControlParam> result = ((CalcBalance)calc).lockDo();
            this.getControlParams().clear();
            this.merge(result);
            this.afterLock();
        }
    }

    public void handler() {
        if (this.getModels() == null || this.getModels().isEmpty() || this.getControlData() == null || this.getControlData().getBizOrgUnit() == null || this.getControlData().getBizTime() == null) {
            return;
        }
        CalcBalance calc = (CalcBalance)this.beforeLock();
        this.lockDo(calc);
    }

    protected void afterLock() {
        this.writeControlLong(this.getParameter(), this.getControlParams(), this.getStats());
        if (this.getControlParams().isEmpty()) {
            this.getStats().addInfo("requestBudget: not controlparam!" + this.getParameter().getBizId());
            this.initWarnBeyond();
            this.getParameter().getResult().setCode("success-empty-params");
            this.getParameter().getResult().setResult(ControlResultEnum.PASS);
        } else {
            BalanceCheck balanceCheck = BalanceCheck.getInterface(this.getStats()).setParameter(this.getParameter()).setControlParams(this.getControlParams());
            if (this.getParameter().getControlManager().isQueryBalance()) {
                balanceCheck.check();
            } else {
                this.getStats().add("begin-balanceCheck-calc");
                boolean check = balanceCheck.calc();
                this.getStats().add("end-balanceCheck-calc");
                if (!this.getParameter().getControlManager().isValidBalance().booleanValue()) {
                    if (check) {
                        Collection bgControlRecords = balanceCheck.getBgControlRecords();
                        if (BgControlConstant.isCheckRecord && bgControlRecords.isEmpty()) {
                            ControlException.erorrOther((String)ResManager.loadResFormat((String)"\u63a7\u5236\u8bb0\u5f55\u68c0\u67e5\u5931\u8d25\uff0c\u9884\u7b97\u5360\u7528\u6216\u8005\u6267\u884c\u7684\u63a7\u5236\u8bb0\u5f55\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u6570\u636e", (String)"BgControlRecordUtils_2", (String)"epm-eb-business", (Object[])new Object[0]));
                        }
                        try {
                            if (bgControlRecords.stream().anyMatch(k -> k.isDel())) {
                                Set<BgControlRecord> deleteRecords = bgControlRecords.stream().filter(k -> k.isDel()).collect(Collectors.toSet());
                                BgControlRecordUtils.batchSaveOlap(this.getModels(), deleteRecords, this.getParameter().getBizNumber());
                                BgControlRecordUtils.delete(deleteRecords);
                                bgControlRecords = bgControlRecords.stream().filter(k -> k.isDel() == false).collect(Collectors.toList());
                            }
                            this.getStats().add("begin-save-record");
                            BgControlRecordUtils.save(bgControlRecords, this.getParameter().getApplier());
                            BgControlRecordUtils.batchSaveOlap(this.getModels(), bgControlRecords, this.getParameter().getBizNumber());
                            this.getStats().add("end-save-record");
                            this.getParameter().getResult().setCode("success");
                            this.getParameter().getResult().setResult(ControlResultEnum.PASS);
                        }
                        catch (Throwable ex) {
                            log.error("budget-control-log : ", ex);
                            BgControlLogUtils.info(this.getStats(), true, ex.getMessage());
                            throw ex;
                        }
                    } else {
                        if (!this.returnRecords.isEmpty()) {
                            BgControlRecordUtils.save(this.returnRecords, this.getParameter().getApplier());
                            BgControlRecordUtils.batchSaveOlap(this.getModels(), this.returnRecords, this.getParameter().getBizNumber());
                        }
                        this.getStats().addInfo("requestBudget: not budget!" + this.getParameter().getBizId());
                    }
                }
            }
        }
    }

    public void returnBudget() {
        if (this.getParameter().getControlManager().isReturnBudget()) {
            this.getControlData().getStats().addInfo("begin-return-records.");
            List<BgControlRecord> records = BgControlRecordUtils.query(Sets.newHashSet((Object[])new String[]{this.getParameter().getBizId()}));
            records.forEach(k -> this.returnRecords.add(k.getClone()));
            BgReturnBudgetUtils.returnBudget(this.getParameter().getEntityNumber(), this.getParameter().getBizId(), records);
            this.getControlData().getStats().addInfo("end-return-records.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeControlLong(IControlParameter parameter, Collection<IControlParam> controlParams, LogStats stats) {
        if (parameter == null || controlParams == null || stats == null) {
            return;
        }
        stats.add("begin-write-log");
        ArrayList<Map<String, Object>> _controlParams = new ArrayList<Map<String, Object>>(controlParams.size());
        int count = 0;
        for (IControlParam param : controlParams) {
            _controlParams.add(param.toMap());
            if (++count <= 20) continue;
            break;
        }
        Long globalId = null;
        if (parameter.getControlManager().isStandard() && parameter.getGlobalId() == 0L) {
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("entitynumber", "=", (Object)parameter.getEntityNumber()));
            builder.add(new QFilter("billid", "=", (Object)parameter.getBizId()));
            builder.add(new QFilter("operation", "=", (Object)(parameter.getControlManager() != null && parameter.getControlManager().isUserRequest() ? "userRequest" : parameter.getOperation())));
            DynamicObjectCollection logs = QueryServiceHelper.query((String)"eb_bgcontroloperlog", (String)"id", (QFilter[])builder.toArrays(), (String)"createdate desc", (int)1);
            globalId = logs != null && !logs.isEmpty() ? Long.valueOf(((DynamicObject)logs.get(0)).getLong("id")) : Long.valueOf(DBServiceHelper.genGlobalLongId());
            parameter.setGlobalId(globalId);
        } else {
            globalId = parameter.getGlobalId();
        }
        try (TXHandle tx = TX.requiresNew((String)"write-operation-log");){
            try {
                if (globalId != null) {
                    DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)globalId, (String)"eb_bgcontroloperlog", (String)"id, controlparams, hasparams");
                    if (log == null) {
                        stats.add("log-no-found");
                        return;
                    }
                    log.set("controlparams", (Object)JSONUtils.toString(_controlParams));
                    log.set("hasparams", (Object)Character.valueOf('1'));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
                } else {
                    stats.addInfo("no-operation-log.");
                }
            }
            catch (Exception e) {
                log.info(e.getMessage());
                tx.markRollback();
            }
            finally {
                stats.add("end-write-log");
            }
        }
    }

    protected void merge(Collection<IControlParam> controlParams) {
        if (controlParams == null || controlParams.isEmpty()) {
            return;
        }
        this.getControlParams().addAll(controlParams);
    }

    protected Callable<Collection<IControlParam>> getModelQuery(IControlParameter controlParameter, BgControlData controlData) {
        return new CalcBalance(controlParameter, controlData, this);
    }

    private void initWarnBeyond() {
        try {
            DynamicProperty fieldType;
            String entityNumber = this.getParameter().getEntityNumber();
            DynamicObject bizBill = this.getParameter().getBizObj();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("type", "=", (Object)BillFieldTypeEmum.WARNING.getNumber()));
            filters.add(new QFilter("fieldtable", "=", (Object)entityNumber));
            DynamicObject regDy = QueryServiceHelper.queryOne((String)"eb_bgcontrolbizreg", (String)"number", (QFilter[])filters.toArray(new QFilter[0]));
            if (regDy == null || bizBill == null) {
                return;
            }
            String fieldName = regDy.getString("number");
            Boolean isContainKey = bizBill.getDataEntityType().getProperties().containsKey((Object)fieldName);
            if (isContainKey.booleanValue() && (fieldType = bizBill.getDynamicObjectType().getProperty(fieldName)) instanceof BooleanProp) {
                this.getParameter().getResult().getWarningResult().put(fieldName, "0");
            }
        }
        catch (Exception e) {
            this.getControlData().getStats().addInfo("white-initwarn-error" + e.getMessage());
        }
    }

    static class CalcThreadPool {
        CalcThreadPool() {
        }

        private static ThreadPool createExecutorService(String poolName, int coreThread, int maxThread) {
            return new ThreadPoolImpl(ThreadLifeCycleManager.wrapExecutorService((ExecutorService)CalcThreadPool.genThreadPoolExecutor(poolName, coreThread, maxThread)));
        }

        private static ThreadPoolExecutor genThreadPoolExecutor(final String poolName, int coreThread, int maxThread) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(coreThread, maxThread, 30L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                private AtomicInteger atomicInteger = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, poolName + "-" + this.atomicInteger.incrementAndGet());
                }
            });
            executor.allowCoreThreadTimeOut(true);
            return executor;
        }
    }
}

