/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.calc;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.control.impl.calc.BalanceCheck;
import kd.epm.eb.control.impl.calc.CalcBalance;
import kd.epm.eb.control.impl.calc.ReopenCalc;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.utils.BalanceCheckUtils;
import kd.epm.eb.control.utils.BgControlRecordUtils;

public class CloseBudgetCalc
extends ReopenCalc {
    private static final Log log = LogFactory.getLog(CloseBudgetCalc.class);

    public CloseBudgetCalc(CalcBalance calcBalance, List<BgControlRecord> reopenRecords, Set<BgControlRecord> closedRecords, Map<Long, BizModel> bizModelMap) {
        super(calcBalance, reopenRecords, closedRecords, bizModelMap);
    }

    @Override
    public void lockDo(Object lockObject) {
        block15: {
            this.calcBalance.lockDo();
            BalanceCheckUtils.handleBalanceCheckControlParam(this.calcBalance.getControlParams(), false);
            BalanceCheck balanceCheck = BalanceCheck.getInterface(this.getStats()).setParameter(this.getParameter()).setControlParams(this.calcBalance.getControlParams());
            balanceCheck.setNeedOccupation(false);
            boolean check = balanceCheck.calc();
            if (check) {
                try (TXHandle tx = TX.requiresNew((String)"eb/CloseBudgetImpl/reopeeeenBudget");){
                    try {
                        BgControlRecordUtils.batchSaveOlap(this.bizModelMap.values(), this.reopenRecords, this.getParameter().getBizNumber());
                        BgControlRecordUtils.save(this.reopenRecords, this.getParameter().getApplier());
                        break block15;
                    }
                    catch (Exception ex) {
                        log.error("budget-control-log : closeBudget-save bgRecord error :", (Throwable)ex);
                        tx.markRollback();
                        BgControlRecordUtils.backOlap(this.bizModelMap.values(), this.reopenRecords);
                        throw ex;
                    }
                }
            }
            this.stats.addInfo("check false.");
        }
    }
}

