/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.calc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.control.BgLockCacheServiceHelper;
import kd.epm.eb.common.cache.control.BgLockMapping;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.impl.calc.BalanceCheck;
import kd.epm.eb.control.impl.calc.CalcBalance;
import kd.epm.eb.control.impl.calc.ControlLock;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.utils.BalanceCheckUtils;
import kd.epm.eb.control.utils.BgControlRecordUtils;

public class ReopenCalc
extends ControlLock {
    private static final Log log = LogFactory.getLog(ReopenCalc.class);
    protected CalcBalance calcBalance = null;
    protected List<BgControlRecord> reopenRecords = null;
    protected Set<BgControlRecord> closedRecords = null;
    protected Map<Long, BizModel> bizModelMap = null;
    protected LogStats stats = null;
    private Map<Long, Long> lockTimestamps = new HashMap<Long, Long>(10);

    public ReopenCalc(CalcBalance calcBalance, List<BgControlRecord> reopenRecords, Set<BgControlRecord> closedRecords, Map<Long, BizModel> bizModelMap) {
        this.calcBalance = calcBalance;
        this.reopenRecords = reopenRecords;
        this.closedRecords = closedRecords;
        this.bizModelMap = bizModelMap;
    }

    public void setStats(LogStats stats) {
        this.stats = stats;
    }

    public LogStats getStats() {
        return this.stats;
    }

    public Map<Long, Set<Long>> getLockKeys() {
        HashMap<Long, Set<Long>> lockKeys = new HashMap<Long, Set<Long>>(10);
        boolean isLockOrgUnit = false;
        HashSet<Long> bussModelIds = new HashSet<Long>(10);
        boolean isEb = false;
        Long lockMainKey = null;
        HashMap<Long, Set> orgIdMap = new HashMap<Long, Set>(10);
        for (IControlParam iControlParam : this.calcBalance.getControlParams()) {
            if (iControlParam.getBizModel() == null) continue;
            Long bizModelKey = iControlParam.getBizModel().getKey();
            orgIdMap.computeIfAbsent(bizModelKey, f -> new HashSet(10)).add(iControlParam.getOrgUnit(false).getId());
            if (iControlParam.getOrgUnit(true) == null) continue;
            orgIdMap.computeIfAbsent(bizModelKey, f -> new HashSet(10)).add(iControlParam.getOrgUnit(true).getId());
        }
        for (Map.Entry entry : orgIdMap.entrySet()) {
            if (this.bizModelMap == null || this.bizModelMap.get(entry.getKey()) == null) {
                log.info("budget-control-log : nofound-bizmodel=" + entry.getKey());
                continue;
            }
            BizModel bizModel = this.bizModelMap.get(entry.getKey());
            Long bizModelId = bizModel.getId();
            isLockOrgUnit = ControlParamsSettingUtil.isLockOrgUnit((Long)bizModelId);
            bussModelIds.clear();
            isEb = bizModel.isEBByModel();
            if (isEb) {
                bussModelIds.add(0L);
            } else {
                bussModelIds.add(bizModel.getControlBusModelId());
            }
            for (Long bussModelId : bussModelIds) {
                lockMainKey = isEb ? bizModelId : bussModelId;
                if (isLockOrgUnit) {
                    BgLockMapping mapping = BgLockCacheServiceHelper.getNoLeafLockMember((Long)bizModelId, (Long)bussModelId, (LogStats)this.getStats());
                    this.lockTimestamps.put(lockMainKey, mapping.getTime().getTime());
                    lockKeys.put(lockMainKey, mapping.getLockOrgIds((Set)entry.getValue()));
                    continue;
                }
                lockKeys.put(lockMainKey, null);
            }
        }
        return lockKeys;
    }

    public Map<Long, Long> getLockTimestamps() {
        return this.lockTimestamps;
    }

    public void handler() {
        Object obj = this.beforeLock();
        this.lockDo(obj);
    }

    public Object beforeLock() {
        return null;
    }

    public void lockDo(Object lockObject) {
        block15: {
            this.calcBalance.lockDo();
            BalanceCheckUtils.handleBalanceCheckControlParam(this.calcBalance.getControlParams(), false);
            BalanceCheck balanceCheck = BalanceCheck.getInterface(this.getStats()).setParameter(this.getParameter()).setControlParams(this.calcBalance.getControlParams());
            balanceCheck.setNeedOccupation(false);
            boolean check = balanceCheck.calc();
            if (check) {
                try (TXHandle tx = TX.requiresNew((String)"eb/CloseBudgetImpl/reopeeeenBudget");){
                    try {
                        BgControlRecordUtils.batchSaveOlap(this.bizModelMap.values(), this.reopenRecords, this.getParameter().getBizNumber());
                        BgControlRecordUtils.delete(this.closedRecords);
                        break block15;
                    }
                    catch (Exception ex) {
                        log.error("budget-control-log : closeBudget-save bgRecord error :", (Throwable)ex);
                        tx.markRollback();
                        BgControlRecordUtils.backOlap(this.bizModelMap.values(), this.reopenRecords);
                        throw ex;
                    }
                }
            }
            this.stats.addInfo("check false.");
        }
    }
}

