/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.calc;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.control.BgLockCacheServiceHelper;
import kd.epm.eb.common.cache.control.BgLockMapping;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.control.eums.ControlResultEnum;
import kd.epm.eb.control.eums.ControlTypeEnum;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.impl.calc.BalanceCheck;
import kd.epm.eb.control.impl.calc.CalcBalance;
import kd.epm.eb.control.impl.calc.ControlLock;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.impl.model.BudgetBalance;
import kd.epm.eb.control.utils.BgControlParamUtils;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgControlRuleUtils;
import kd.epm.eb.control.utils.BgControlUtils;

public class ReturnCalc
extends ControlLock {
    private static final Log log = LogFactory.getLog(ReturnCalc.class);
    private Map<Long, Set<Long>> bizModelMap = new HashMap<Long, Set<Long>>(10);
    private LogStats stats = null;
    private Map<Long, Long> lockTimestamps = new HashMap<Long, Long>(10);

    public static ReturnCalc getInterface() {
        return new ReturnCalc();
    }

    public Map<Long, Set<Long>> getBizModelMap() {
        return this.bizModelMap;
    }

    public void setStats(LogStats stats) {
        this.stats = stats;
    }

    public LogStats getStats() {
        return this.stats;
    }

    public Map<Long, Long> getLockTimestamps() {
        return this.lockTimestamps;
    }

    public Map<Long, Set<Long>> getLockKeys() {
        HashMap<Long, Set<Long>> lockKeys = new HashMap<Long, Set<Long>>(10);
        HashSet<Long> orgIds = new HashSet<Long>(10);
        boolean isLockOrgUnit = false;
        HashSet<Long> bussModelIds = new HashSet<Long>(10);
        boolean isEb = false;
        String crTable = null;
        Long lockMainKey = null;
        for (Map.Entry<Long, Set<Long>> entry : this.getBizModelMap().entrySet()) {
            Long bizModelId = entry.getKey();
            isLockOrgUnit = ControlParamsSettingUtil.isLockOrgUnit((Long)bizModelId);
            bussModelIds.clear();
            boolean bl = isEb = entry.getValue() == null || entry.getValue().isEmpty();
            if (isEb) {
                bussModelIds.add(0L);
            } else {
                bussModelIds.addAll((Collection)entry.getValue());
            }
            for (Long bussModelId : bussModelIds) {
                orgIds.clear();
                if (isEb) {
                    crTable = "t_eb_bgcontrolrecord";
                    lockMainKey = bizModelId;
                } else {
                    crTable = BizModel.getBgControlRecordTable((Long)bussModelId);
                    lockMainKey = bussModelId;
                }
                if (isLockOrgUnit) {
                    this.queryOrgIds(crTable, orgIds);
                    BgLockMapping mapping = BgLockCacheServiceHelper.getNoLeafLockMember((Long)bizModelId, (Long)bussModelId, (LogStats)this.getStats());
                    this.lockTimestamps.put(lockMainKey, mapping.getTime().getTime());
                    lockKeys.put(lockMainKey, mapping.getLockOrgIds(orgIds));
                    continue;
                }
                lockKeys.put(lockMainKey, null);
            }
        }
        return lockKeys;
    }

    private void queryOrgIds(String crTable, Set<Long> orgIds) {
        block16: {
            SqlBuilder sql = new SqlBuilder();
            BgControlRecordUtils.checkExistOccTypeByRecord(crTable);
            sql.append("select forgunitid,fbgmemberjson from " + crTable + " where (fentitynumber = ? and fbizid = ?) or frefbizid = ?", new Object[]{this.getParameter().getEntityNumber(), this.getParameter().getBizId(), this.getParameter().getBizId()});
            DataSet ds = DB.queryDataSet((String)"querycrtableorgid", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            Throwable throwable = null;
            block11: while (true) {
                try {
                    while (ds.hasNext()) {
                        Row row = ds.next();
                        orgIds.add(row.getLong("forgunitid"));
                        String bgmemberjson = row.getString("fbgmemberjson");
                        if (!StringUtils.isNotEmpty((String)bgmemberjson)) continue;
                        JSONObject bgMemberJson = JSONObject.parseObject((String)bgmemberjson);
                        if (bgmemberjson == null || !bgmemberjson.contains(String.valueOf(row.getLong("forgunitid")))) continue;
                        try {
                            orgIds.add(IDUtils.toLong((Object)bgMemberJson.get((Object)String.valueOf(row.getLong("forgunitid")))));
                            continue block11;
                        }
                        catch (Throwable throwable2) {
                        }
                    }
                    break block16;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            finally {
                if (ds != null) {
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
    }

    public Object beforeLock() {
        List<BgControlRecord> _records;
        HashMap<Long, BizModel> models = new HashMap<Long, BizModel>();
        String bizId = this.getParameter().getBizId();
        this.stats.add("begin-query-record");
        Boolean queryRef = StringUtils.isNotEmpty((String)this.getParameter().getEntryId());
        List<BgControlRecord> records = BgControlRecordUtils.query(this.getParameter().getBizId(), this.getBizModelMap(), models, queryRef);
        if (records == null || records.isEmpty()) {
            this.stats.addInfo("records size = 0");
            return null;
        }
        if (StringUtils.isNotEmpty((String)this.getParameter().getEntryId())) {
            if (records.stream().anyMatch(k -> StringUtils.isEmpty((String)k.getRefBizId()) && (StringUtils.isEmpty((String)k.getEntryId()) || "0".equals(k.getEntryId())) || StringUtils.isNotEmpty((String)k.getRefBizId()) && k.getRefBizId().equals(this.getParameter().getBizId()) && StringUtils.isEmpty((String)k.getRefEntryId()))) {
                ControlException.errorDelEntryCheck1();
            }
            records = records.stream().filter(k -> this.getParameter().getEntryIdArr().contains(k.getEntryId())).collect(Collectors.toList());
        }
        this.stats.add("end records size =" + records.size());
        ArrayList<BgControlRecord> allRecords = new ArrayList<BgControlRecord>(records);
        HashSet<String> upstreamIds = new HashSet<String>(10);
        for (BgControlRecord bgControlRecord : records) {
            bgControlRecord.setAmount(bgControlRecord.getAmount().negate());
            if (!StringUtils.isNotEmpty((String)bgControlRecord.getRefBizId()) || bizId.equals(bgControlRecord.getRefBizId())) continue;
            upstreamIds.add(bgControlRecord.getRefBizId());
        }
        if (!upstreamIds.isEmpty() && (_records = BgControlRecordUtils.query(upstreamIds, models, false)) != null && !_records.isEmpty()) {
            for (BgControlRecord record : _records) {
                record.setAmount(BigDecimal.ZERO);
                allRecords.add(record);
            }
        }
        Iterator it = allRecords.iterator();
        while (it.hasNext()) {
            if (!StringUtils.isEmpty((String)((BgControlRecord)it.next()).getBgMemberJson())) continue;
            it.remove();
        }
        List<IControlParam> controlParams = BgControlRecord.createControlParam(this.getParameter(), allRecords);
        this.stats.add("end-createControlParam");
        BgControlData bgControlData = new BgControlData(true, null, null, this.stats);
        bgControlData.setBizModels(models);
        try {
            Map<Long, List<IControlParam>> paramMap = BgControlUtils.buildParamMap(controlParams);
            for (List<IControlParam> _param : paramMap.values()) {
                BgControlParamUtils.get().setParameter(this.getParameter()).fillMembers(bgControlData, _param);
            }
        }
        catch (Throwable ex) {
            log.info("fillMembers-error:", (Object)ex);
            this.stats.addInfo("records size =" + records.size());
        }
        this.stats.add("end-fillMembers");
        BgControlRuleUtils.getInterface().queryControlRule(bgControlData, controlParams);
        this.stats.add("end-queryControlRule");
        Iterator<IControlParam> it2 = controlParams.iterator();
        while (it2.hasNext()) {
            IControlParam controlParam = it2.next();
            ((BudgetBalance)((Object)controlParam)).setStats(this.getStats());
            controlParam.setControlType(ControlTypeEnum.OCCUPATION);
            if (controlParam.getAmount() != null && BigDecimal.ZERO.compareTo(controlParam.getAmend()) != 0 || controlParam.getSetting() != null || !controlParam.getSetting().isBeyond()) continue;
            it2.remove();
        }
        CalcBalance calcbalance = new CalcBalance(this.getParameter(), bgControlData, null);
        calcbalance.getControlParams().addAll(controlParams);
        calcbalance.builderMembersForReturn(models, controlParams);
        return new Object[]{calcbalance, records, models};
    }

    public void handler() {
        Object obj = this.beforeLock();
        this.lockDo(obj);
    }

    public void lockDo(Object lockObject) {
        if (this.getBizModelMap() == null || this.getBizModelMap().isEmpty() || !(lockObject instanceof Object[])) {
            return;
        }
        Object[] result = (Object[])lockObject;
        if (result.length != 3) {
            this.stats.addInfo("lockObject error");
            return;
        }
        CalcBalance calcBalance = (CalcBalance)result[0];
        boolean check = true;
        Map models = (Map)result[2];
        List records = (List)result[1];
        if (calcBalance.getControlParams() != null && !calcBalance.getControlParams().isEmpty()) {
            boolean hasRecord = false;
            SqlBuilder sql = new SqlBuilder();
            sql.append("select ftable from ", new Object[0]).append("t_eb_bgcontrolindex", new Object[0]).append(" where ", new Object[0]);
            sql.append("fbizid = ?", new Object[]{this.getParameter().getBizId()});
            DataSet ds = DB.queryDataSet((String)"queryControlRecord", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            Object object = null;
            try {
                hasRecord = ds != null && ds.hasNext();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            if (!hasRecord) {
                sql = new SqlBuilder();
                sql.append("select fbizid from ", new Object[0]).append("t_eb_bgcontrolrecord", new Object[0]).append(" where ", new Object[0]);
                sql.append("fbizid = ?", new Object[]{this.getParameter().getBizId()});
                ds = DB.queryDataSet((String)"queryControlIndex", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
                object = null;
                try {
                    hasRecord = ds != null && ds.hasNext();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (object != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
            if (!hasRecord) {
                calcBalance.getControlParams().clear();
                records.clear();
            }
        }
        if (calcBalance.getControlParams() == null || calcBalance.getControlParams().isEmpty() || !this.getParameter().getControlManager().isCalcBalance()) {
            this.getParameter().getResult().setResult(ControlResultEnum.PASS);
        } else {
            calcBalance.lockDo();
            BalanceCheck balanceCheck = BalanceCheck.getInterface(this.getStats()).setParameter(this.getParameter()).setControlParams(calcBalance.getControlParams());
            balanceCheck.setNeedOccupation(false);
            check = balanceCheck.calc();
        }
        if (check) {
            try (TXHandle tx = TX.required();){
                try {
                    HashSet<String> crTables = new HashSet<String>(10);
                    for (Map.Entry<Long, Set<Long>> entry : this.bizModelMap.entrySet()) {
                        if (entry.getValue() == null || entry.getValue().isEmpty()) {
                            crTables.add("t_eb_bgcontrolrecord");
                            continue;
                        }
                        for (Long bussModelId : entry.getValue()) {
                            crTables.add(BizModel.getBgControlRecordTable((Long)bussModelId));
                        }
                    }
                    BgControlRecordUtils.batchSaveOlap(models.values(), records, this.getParameter().getBizNumber());
                    if (StringUtils.isNotEmpty((String)this.getParameter().getEntryId())) {
                        BgControlRecordUtils.delete(new HashSet<BgControlRecord>(records));
                    }
                    BgControlRecordUtils.delete(this.getParameter().getEntityNumber(), this.getParameter().getBizId(), crTables);
                }
                catch (Throwable ex) {
                    tx.markRollback();
                    throw ex;
                }
            }
        } else {
            this.stats.addInfo("check false.");
        }
    }
}

