/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.model;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.epm.eb.common.model.BgControlRecordExt;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;

public class AbstractBgControlRecord
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 6009665773823475181L;
    public static final String FIELD_ID = "id";
    public static final String FIELD_MODELID = "modelid";
    public static final String FIELD_CREATOR = "creator";
    public static final String FIELD_CREATETIME = "createtime";
    public static final String FIELD_ENTITYNUMBER = "entitynumber";
    public static final String FIELD_BIZID = "bizid";
    public static final String FIELD_BIZNUMBER = "biznumber";
    public static final String FIELD_OPERATION = "operation";
    public static final String FIELD_AMOUNT = "amount";
    public static final String FIELD_SETRULE = "settingid";
    public static final String FIELD_REF_BIZID = "frefbizid";
    public static final String FIELD_REQORGUNIT = "reqorgunit";
    public static final String FIELD_REQACCOUNT = "reqaccount";
    public static final String FIELD_ENTRY = "entryid";
    public static final String FIELD_OCCPERIOD = "occperiod";
    public static final String FIELD_OCCTYPE = "occtype";
    public static final String FIELD_BGMEMBERJSON = "fbgmemberjson";
    public static final String FIELD_ISDEL = "isdel";
    public static final String FIELD_REQUESTID = "requestId";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_WRITEOFFTYPE = "writeofftype";
    public static final String FIELD_REFENTRYID = "refentryid";
    public static final String FIELD_SERIALJSON = "serialtextjson";
    private BizModel bizModel = null;

    public void setBizModel(BizModel bizModel) {
        this.bizModel = bizModel;
    }

    public BizModel getBizModel() {
        return this.bizModel;
    }

    public void setId(Long id) {
        this.put(FIELD_ID, id);
    }

    public Long getId() {
        return (Long)this.get(FIELD_ID);
    }

    public void setModelId(Long id) {
        this.put(FIELD_MODELID, id);
    }

    public Long getModelId() {
        if (this.getBizModel() != null) {
            return this.getBizModel().getId();
        }
        return (Long)this.get(FIELD_MODELID);
    }

    public void setCreator(Long creator) {
        this.put(FIELD_CREATOR, creator);
    }

    public Long getCreator() {
        return (Long)this.get(FIELD_CREATOR);
    }

    public void setCreateTime(Date date) {
        this.put(FIELD_CREATETIME, date);
    }

    public Date getCreateTime() {
        return (Date)this.get(FIELD_CREATETIME);
    }

    public void setEntityNumber(String entityNumber) {
        this.put(FIELD_ENTITYNUMBER, entityNumber);
    }

    public String getEntityNumber() {
        return (String)this.get(FIELD_ENTITYNUMBER);
    }

    public void setBizId(String bizId) {
        this.put(FIELD_BIZID, bizId);
    }

    public String getBizId() {
        return (String)this.get(FIELD_BIZID);
    }

    public void setRefBizId(String refBizId) {
        this.put(FIELD_REF_BIZID, refBizId);
    }

    public String getRefBizId() {
        return (String)this.get(FIELD_REF_BIZID);
    }

    public void setBizNumber(String bizNumber) {
        this.put(FIELD_BIZNUMBER, bizNumber);
    }

    public String getBizNumber() {
        return (String)this.get(FIELD_BIZNUMBER);
    }

    public void setOperation(String operation) {
        this.put(FIELD_OPERATION, operation);
    }

    public String getOperation() {
        return (String)this.get(FIELD_OPERATION);
    }

    public void setEntryId(String entryId) {
        if (StringUtils.isEmpty((String)entryId)) {
            return;
        }
        this.put(FIELD_ENTRY, entryId);
    }

    public String getEntryId() {
        Object entryId = this.get(FIELD_ENTRY);
        return entryId != null ? String.valueOf(entryId) : "";
    }

    public Long getOccPeriodId() {
        return (Long)this.get("occperiod.id");
    }

    public String getOccPeriodNumber() {
        return (String)this.get("occperiod.number");
    }

    public String getOccPeriodName() {
        return (String)this.get("occperiod.name");
    }

    public void setOccPeriod(Member occPeriod) {
        if (occPeriod == null) {
            return;
        }
        this.put("occperiod.id", occPeriod.getId());
        this.put("occperiod.number", occPeriod.getNumber());
        this.put("occperiod.name", occPeriod.getName());
    }

    public Member getOccPeriod() {
        Long occPeriodId = this.getOccPeriodId();
        if (occPeriodId != null && occPeriodId > 0L) {
            Member occPeriod = new Member(occPeriodId);
            occPeriod.setNumber(this.getOccPeriodNumber());
            occPeriod.setName(this.getOccPeriodName());
            return occPeriod;
        }
        return null;
    }

    public void setReqOrgUnit(Member reqOrgUnit) {
        if (reqOrgUnit == null) {
            return;
        }
        this.put("reqorgunit.id", reqOrgUnit.getId());
        this.put("reqorgunit.number", reqOrgUnit.getNumber());
        this.put("reqorgunit.name", reqOrgUnit.getName());
    }

    public void setReqOrgUnit(Map<String, Object> reqOrgUnit) {
        if (reqOrgUnit == null) {
            return;
        }
        this.put("reqorgunit.id", reqOrgUnit.get(FIELD_ID));
        this.put("reqorgunit.number", reqOrgUnit.get("number"));
        this.put("reqorgunit.name", reqOrgUnit.get("name"));
    }

    public Member getReqOrgUnit() {
        Long reqOrgUnitId = this.getReqOrgUnitId();
        if (reqOrgUnitId != null) {
            Member reqOrgUnit = new Member(reqOrgUnitId);
            reqOrgUnit.setNumber(this.getReqOrgUnitNumber());
            reqOrgUnit.setName(this.getReqOrgUnitName());
            return reqOrgUnit;
        }
        return null;
    }

    public Long getReqOrgUnitId() {
        return (Long)this.get("reqorgunit.id");
    }

    public String getReqOrgUnitNumber() {
        return (String)this.get("reqorgunit.number");
    }

    public String getReqOrgUnitName() {
        return (String)this.get("reqorgunit.name");
    }

    public void setReqAccount(Member reqAccount) {
        if (reqAccount == null) {
            return;
        }
        this.put("reqaccount.id", reqAccount.getId());
        this.put("reqaccount.number", reqAccount.getNumber());
        this.put("reqaccount.name", reqAccount.getName());
    }

    public void setReqAccount(Map<String, Object> reqAccount) {
        if (reqAccount == null) {
            return;
        }
        this.put("reqaccount.id", reqAccount.get(FIELD_ID));
        this.put("reqaccount.number", reqAccount.get("number"));
        this.put("reqaccount.name", reqAccount.get("name"));
    }

    public Member getReqAccount() {
        Long reqAccountId = this.getReqAccountId();
        if (reqAccountId != null) {
            Member reqAccount = new Member(reqAccountId);
            reqAccount.setNumber(this.getReqAccountNumber());
            reqAccount.setName(this.getReqAccountName());
            return reqAccount;
        }
        return null;
    }

    public Long getReqAccountId() {
        return (Long)this.get("reqaccount.id");
    }

    public String getReqAccountNumber() {
        return (String)this.get("reqaccount.number");
    }

    public String getReqAccountName() {
        return (String)this.get("reqaccount.name");
    }

    public void setMember(Member member) {
        if (member == null || member.getDimension() == null || StringUtils.isEmpty((String)member.getDimension().getNumber())) {
            ControlException.errorNoExistRecordMember();
            return;
        }
        this.put(member.getDimension().getNumber() + ".id", member.getId());
        this.put(member.getDimension().getNumber() + ".number", member.getNumber());
        this.put(member.getDimension().getNumber() + ".name", member.getName());
    }

    public void setMemberId(String dimNumber, Long memberId) {
        this.put(dimNumber + ".id", memberId);
    }

    public void setMember(Dimension dimension, Map<String, Object> member) {
        if (dimension == null || member == null) {
            ControlException.errorNoExistRecordMember();
            return;
        }
        Map.Entry<String, Object> entry2 = null;
        for (Map.Entry<String, Object> entry2 : member.entrySet()) {
            this.put(dimension.getNumber() + "." + entry2.getKey(), entry2.getValue());
        }
    }

    public void setAmount(BigDecimal amount) {
        this.put(FIELD_AMOUNT, amount);
    }

    public BigDecimal getAmount() {
        return (BigDecimal)this.get(FIELD_AMOUNT);
    }

    public void setSetting(Long ruleId) {
        this.put(FIELD_SETRULE, ruleId);
    }

    public Long getSetting() {
        return (Long)this.get(FIELD_SETRULE);
    }

    public void setIsDel(Boolean del) {
        this.put(FIELD_ISDEL, del);
    }

    public Boolean isDel() {
        if (this.get(FIELD_ISDEL) == null) {
            return Boolean.FALSE;
        }
        return (Boolean)this.get(FIELD_ISDEL);
    }

    public void setRequestId(String requestId) {
        if (requestId == null) {
            this.put(FIELD_REQUESTID, "");
        }
        this.put(FIELD_REQUESTID, requestId);
    }

    public String getRequestId() {
        return (String)this.get(FIELD_REQUESTID);
    }

    public void setStatus(String statusValue) {
        this.put(FIELD_STATUS, statusValue);
    }

    public String getStatus() {
        return (String)this.get(FIELD_STATUS);
    }

    public void setWriteOffType(String writeofftype) {
        if (writeofftype == null) {
            this.put(FIELD_WRITEOFFTYPE, "");
        }
        this.put(FIELD_WRITEOFFTYPE, writeofftype);
    }

    public String getWriteOffType() {
        if (this.get(FIELD_WRITEOFFTYPE) == null) {
            return "";
        }
        return (String)this.get(FIELD_WRITEOFFTYPE);
    }

    public void setRefEntryId(String refEntryId) {
        if (refEntryId == null) {
            this.put(FIELD_REFENTRYID, "");
        }
        this.put(FIELD_REFENTRYID, refEntryId);
    }

    public String getRefEntryId() {
        if (this.get(FIELD_REFENTRYID) == null) {
            return "";
        }
        return (String)this.get(FIELD_REFENTRYID);
    }

    public void setSerialJson(String serialJson) {
        if (StringUtils.isNotEmpty((String)serialJson)) {
            this.put(FIELD_SERIALJSON, JSONUtils.parse((String)serialJson, BgControlRecordExt.class));
        }
    }

    protected BgControlRecordExt getExt(boolean create) {
        Object obj = this.get(FIELD_SERIALJSON);
        if (obj instanceof BgControlRecordExt) {
            return (BgControlRecordExt)obj;
        }
        if (create) {
            BgControlRecordExt ext = new BgControlRecordExt();
            this.put(FIELD_SERIALJSON, ext);
            return ext;
        }
        return null;
    }

    public Long getApplierId() {
        BgControlRecordExt ext = this.getExt(false);
        return ext == null ? null : ext.getApplierId();
    }

    public void setApplierId(Long applierId) {
        if (IDUtils.isNotNull((Long)applierId)) {
            this.getExt(true).setApplierId(applierId);
        } else {
            BgControlRecordExt ext = this.getExt(false);
            if (ext != null) {
                ext.setApplierId(applierId);
            }
        }
    }

    public String getReqEntBaseData() {
        BgControlRecordExt ext = this.getExt(false);
        return ext == null ? null : ext.getOrgBaseData();
    }

    public void setReqEntBaseData(String baseData) {
        if (StringUtils.isNotEmpty((String)baseData)) {
            this.getExt(true).setOrgBaseData(baseData);
        } else {
            BgControlRecordExt ext = this.getExt(false);
            if (ext != null) {
                ext.setOrgBaseData(baseData);
            }
        }
    }

    public String getReqAccBaseData() {
        BgControlRecordExt ext = this.getExt(false);
        return ext == null ? null : ext.getAccountBaseData();
    }

    public void setReqAccBasedata(String baseData) {
        if (StringUtils.isNotEmpty((String)baseData)) {
            this.getExt(true).setAccountBaseData(baseData);
        } else {
            BgControlRecordExt ext = this.getExt(false);
            if (ext != null) {
                ext.setAccountBaseData(baseData);
            }
        }
    }

    public Long getReqEntId() {
        BgControlRecordExt ext = this.getExt(false);
        return ext == null ? null : ext.getReqOrgId();
    }

    public void setReqEntId(Long reqOrgId) {
        if (IDUtils.isNotNull((Long)reqOrgId)) {
            this.getExt(true).setReqOrgId(reqOrgId);
        } else {
            BgControlRecordExt ext = this.getExt(false);
            if (ext != null) {
                ext.setReqOrgId(reqOrgId);
            }
        }
    }

    public Long getReqAccId() {
        BgControlRecordExt ext = this.getExt(false);
        return ext == null ? null : ext.getReqaccountId();
    }

    public void setReqAccId(Long reqaccountId) {
        if (IDUtils.isNotNull((Long)reqaccountId)) {
            this.getExt(true).setReqaccountId(reqaccountId);
        } else {
            BgControlRecordExt ext = this.getExt(false);
            if (ext != null) {
                ext.setReqaccountId(reqaccountId);
            }
        }
    }

    public String getSerialJson() {
        Object obj = this.get(FIELD_SERIALJSON);
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return JSONUtils.toString(obj);
    }

    public String getWriteOffTypeOrDefault() {
        String getWriteOffType = this.getWriteOffType();
        if (getWriteOffType.startsWith("writeoffscheme")) {
            return "writeoffscheme";
        }
        if (StringUtils.isEmpty((String)getWriteOffType)) {
            return "Occupation";
        }
        return getWriteOffType;
    }

    public Member getMember(Dimension dimension) {
        if (dimension == null || StringUtils.isEmpty((String)dimension.getNumber())) {
            ControlException.errorGetRecordMemberDimensionNull();
            return null;
        }
        Member member = this.getMember(dimension.getNumber());
        if (member == null && BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
            member = BgDimensionServiceHelper.getNoneMember((Dimension)dimension);
        }
        if (member == null) {
            ControlException.errorGetRecordMemberNull((String)dimension.getNumber());
            return null;
        }
        member.setDimension(dimension);
        return member;
    }

    public Member getMember(String dimensionNumber) {
        Long memberId;
        if (StringUtils.isEmpty((String)dimensionNumber)) {
            ControlException.errorGetRecordMemberDimensionNull();
        }
        if ((memberId = (Long)this.get(dimensionNumber + ".id")) != null) {
            Member member = new Member(memberId);
            member.setNumber((String)this.get(dimensionNumber + ".number"));
            member.setName((String)this.get(dimensionNumber + ".name"));
            return member;
        }
        return null;
    }

    public String getMemberNumber(String dimensionNumber) {
        if (StringUtils.isEmpty((String)dimensionNumber)) {
            ControlException.errorGetRecordMemberDimensionNull();
        }
        return (String)this.get(dimensionNumber + ".number");
    }

    public Long getMemberId(String dimensionNumber) {
        if (StringUtils.isEmpty((String)dimensionNumber)) {
            ControlException.errorGetRecordMemberDimensionNull();
        }
        return (Long)this.get(dimensionNumber + ".id");
    }

    public Map<String, String> getMembers(Collection<Dimension> dimensions) {
        if (dimensions == null || dimensions.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap members = Maps.newHashMapWithExpectedSize((int)dimensions.size());
        for (Dimension dimension : dimensions) {
            members.put(dimension.getNumber(), this.getMember(dimension).getNumber());
        }
        return members;
    }

    public void removeMember(String dimensionNumber) {
        if (StringUtils.isEmpty((String)dimensionNumber)) {
            ControlException.errorRemoveRecordMember();
        }
        this.remove(dimensionNumber + ".id");
        this.remove(dimensionNumber + ".name");
        this.remove(dimensionNumber + ".number");
    }

    public void setOccType(String occType) {
        this.put(FIELD_OCCTYPE, occType);
    }

    public String getOccType() {
        if (this.get(FIELD_OCCTYPE) != null) {
            return (String)this.get(FIELD_OCCTYPE);
        }
        return "";
    }

    public void setBgMemberJson(String bgMemberJson) {
        this.put(FIELD_BGMEMBERJSON, bgMemberJson);
    }

    public String getBgMemberJson() {
        if (this.get(FIELD_BGMEMBERJSON) != null) {
            return (String)this.get(FIELD_BGMEMBERJSON);
        }
        return "";
    }
}

