/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.model;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.BizOrgUnit;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.OrgUtils;
import kd.epm.eb.control.utils.BgControlLogUtils;

public class BgControlData {
    private boolean isMultiControl = false;
    private Map<Long, BizModel> bizModels = new HashMap<Long, BizModel>(10);
    private BizOrgUnit bizOrgUnit;
    private Boolean isReviewOcc = false;
    private Date bizTime;
    private Map<String, Object> process = null;
    private LogStats stats;
    private boolean isNeedLog = false;
    private Set<Long> parentIds;

    public void setMultiControl(boolean isMultiControl) {
        this.isMultiControl = isMultiControl;
    }

    public boolean isMultiControl() {
        return this.isMultiControl;
    }

    public Map<Long, BizModel> getBizModels() {
        return this.bizModels;
    }

    public void setBizModels(Map<Long, BizModel> bizModels) {
        this.bizModels = bizModels;
    }

    public void setBizModels(Collection<BizModel> bizModels) {
        this.bizModels = new HashMap<Long, BizModel>(10);
        if (bizModels != null) {
            for (BizModel bizModel : bizModels) {
                this.bizModels.put(bizModel.getKey(), bizModel);
            }
        }
    }

    public BizOrgUnit getBizOrgUnit() {
        return this.bizOrgUnit;
    }

    public void setIsReviewOcc(Boolean isReviewOcc) {
        this.isReviewOcc = isReviewOcc;
    }

    public Boolean getIsReviewOcc() {
        return this.isReviewOcc;
    }

    public Date getBizTime() {
        return this.bizTime;
    }

    public void setProcess(Map<String, Object> process) {
        this.process = process;
    }

    public Map<String, Object> getProcess() {
        return this.process;
    }

    public LogStats getStats() {
        return this.stats;
    }

    public boolean isNeedLog() {
        return this.isNeedLog;
    }

    public BgControlData(BizModel bizModel, BizOrgUnit bizOrgUnit, Date bizTime, LogStats stats) {
        HashMap<Long, BizModel> bizModels = new HashMap<Long, BizModel>(1);
        if (bizModel != null) {
            bizModels.put(bizModel.getKey(), bizModel);
        }
        this.bizModels = bizModels;
        this.bizOrgUnit = bizOrgUnit;
        this.bizTime = bizTime;
        this.stats = stats;
    }

    public BgControlData(boolean isMultiControl, BizOrgUnit bizOrgUnit, Date bizTime, LogStats stats) {
        this.isMultiControl = isMultiControl;
        this.bizOrgUnit = bizOrgUnit;
        this.bizTime = bizTime;
        this.stats = stats;
        this.isNeedLog = BgControlLogUtils.isNeedLog();
    }

    public Set<Long> getParentIds() {
        if (this.getBizOrgUnit() == null || this.getBizOrgUnit().getId() == null || this.getBizOrgUnit().getId() == 0L) {
            return null;
        }
        if (this.parentIds == null) {
            this.parentIds = OrgUtils.getParentIds((String)"bos_org_structure", (Long)this.getBizOrgUnit().getOrgId(), (boolean)true, (OrgViewTypeEnum)OrgViewTypeEnum.IS_ORGUNIT);
        }
        return this.parentIds;
    }

    public BgControlData copy(Collection<BizModel> bizModels) {
        if (bizModels == null) {
            return this.copy((Map<Long, BizModel>)null);
        }
        HashMap<Long, BizModel> bizModelMap = new HashMap<Long, BizModel>(10);
        for (BizModel bizModel : bizModels) {
            if (bizModel == null) continue;
            bizModelMap.put(bizModel.getKey(), bizModel);
        }
        return this.copy(bizModelMap);
    }

    public BgControlData copy(Map<Long, BizModel> bizModels) {
        BgControlData clone = new BgControlData(this.isMultiControl(), this.getBizOrgUnit(), this.getBizTime(), this.getStats());
        if (bizModels != null) {
            clone.setBizModels(bizModels);
        }
        clone.setProcess(this.getProcess());
        return clone;
    }
}

