/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.LogUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.control.ConditionUtils;
import kd.epm.eb.control.face.IWriteOff;
import kd.epm.eb.control.impl.model.BgItemMapping;
import kd.epm.eb.control.impl.model.BgItemMappingMember;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgMemMappingServiceHelper;
import org.jetbrains.annotations.NotNull;

public class BgControlScheme
implements Serializable {
    private static final long serialVersionUID = 451875361685820681L;
    private static final Log log = LogFactory.getLog(BgControlScheme.class);
    private Map<String, Object> schema;
    private Map<Long, String> propValues = Maps.newHashMapWithExpectedSize((int)32);
    private Member metric = null;
    private LogStats stats;
    private static final int MAX_USER_DEFINED_SIZE = 6;
    private Map<String, Long> userDefendDimIdMap = new HashMap<String, Long>();
    private Map<String, String> userDefendDimNumMap = new HashMap<String, String>();
    private Map<String, String> userDefendPropMap = new HashMap<String, String>();
    private Map<String, Long> hasMappings = new HashMap<String, Long>();
    private Map<Long, BgItemMapping> mappings = new HashMap<Long, BgItemMapping>();
    private String condition = null;
    private Map<String, String> propertyMap = new HashMap<String, String>();
    private QFilter filter = null;
    private int priority = 0;

    public void setStats(LogStats stats) {
        this.stats = stats;
    }

    public BgControlScheme(String entityNumber, BizModel model, Map<String, Object> schema, LogStats stats) {
        this.schema = schema;
        this.stats = stats;
        if (this.schema == null) {
            ControlException.errorNullControlScheme();
            return;
        }
        List dimensions = model.getDimensions();
        String propKey = null;
        String dimIdKey = null;
        Long dimId = 0L;
        Long field = null;
        Dimension dimension = null;
        HashMap dimensionMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
        for (Object _dimension : dimensions) {
            if (!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)_dimension)) continue;
            propKey = _dimension.getFieldMapped().replaceFirst("dim", "userdefined");
            dimensionMap.put(propKey, _dimension);
        }
        HashSet propIds = Sets.newHashSetWithExpectedSize((int)schema.size());
        for (Object e : schema.values()) {
            if (!(e instanceof Long)) continue;
            propIds.add((Long)e);
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fnumber from t_eb_bgcontrolbizreg where ", new Object[0]);
        sql.appendIn("fid", propIds.toArray(new Object[propIds.size()]));
        try (DataSet dataSet = DB.queryDataSet((String)"querytstructofbill", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            for (Row row : dataSet) {
                this.propValues.put(row.getLong("fid"), row.getString("fnumber"));
            }
        }
        Long l = (Long)schema.get("fmetricfield");
        if (l != null && l != 0L) {
            String _sql = "select fid, fnumber from " + SysDimensionEnum.Metric.getMemberTreetable() + " where fid = ?";
            try (DataSet ds = DB.queryDataSet((String)"queryMetric", (DBRoute)BgBaseConstant.epm, (String)_sql, (Object[])new Object[]{l});){
                if (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    this.metric = new Member(l);
                    this.metric.setNumber(row.getString("fnumber"));
                }
            }
        }
        for (int i = 1; i <= 6; ++i) {
            propKey = "userdefined" + i;
            dimIdKey = "fuserdefineddimid" + i;
            field = (Long)schema.get("fuserdefined" + i + "fieldid");
            if (field == null || field == 0L || (dimension = (dimId = (Long)schema.get(dimIdKey)) != null && dimId != 0L ? model.getDimension(dimId) : (Dimension)dimensionMap.get(propKey)) == null) continue;
            this.userDefendDimIdMap.put(propKey, dimension.getId());
            this.userDefendDimNumMap.put(dimension.getNumber(), propKey);
            this.userDefendPropMap.put("userdefined" + dimension.getNumber(), this.propValues.get(field));
            field = (Long)schema.get("fuserdefined" + i + "fieldextid");
            if (field == null || field == 0L) continue;
            this.userDefendPropMap.put("userdefined" + dimension.getNumber() + "ext", this.propValues.get(field));
        }
        this.setCondition(entityNumber, schema);
        String _priority = (String)schema.get("fpriority");
        if (StringUtils.isNotEmpty((String)_priority)) {
            if (_priority.contains("tabpage")) {
                if (_priority != null) {
                    if (_priority.startsWith("0")) {
                        this.setPriority(1);
                    } else if (_priority.startsWith("1")) {
                        this.setPriority(2);
                    } else if (_priority.startsWith("2")) {
                        this.setPriority(3);
                    } else {
                        this.setPriority(4);
                    }
                } else {
                    this.setPriority(4);
                }
            } else {
                this.setPriority(Integer.parseInt(_priority));
            }
        }
    }

    public boolean isOnlyCheck() {
        Object obj = this.schema.get("fisonlycheck");
        return BgControlScheme.getBoolean(obj);
    }

    public static boolean getBoolean(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if ("0".equals(obj)) {
            return false;
        }
        if ("1".equals(obj)) {
            return true;
        }
        return Boolean.parseBoolean(String.valueOf(obj));
    }

    public boolean isOnlycontrolsuit() {
        Object obj = this.schema.get("fisonlycontrolsuit");
        return BgControlScheme.getBoolean(obj);
    }

    public Long getBillId() {
        return IDUtils.toLong((Object)this.schema.get("fbill"));
    }

    public Long getGroupId() {
        return IDUtils.toLong((Object)this.schema.get("fid"));
    }

    public Long getDetailId() {
        return IDUtils.toLong((Object)this.schema.get("fdetailid"));
    }

    public String getGroupNumber() {
        return (String)this.schema.get("groupnumber");
    }

    public String getNumber() {
        return (String)this.schema.get("fnumber");
    }

    public String getSchemeKey() {
        return String.valueOf(this.getGroupId());
    }

    public String getOrgUnitFields() {
        Long value = (Long)this.schema.get("fentryfieldid");
        if (value == null || value == 0L) {
            ControlException.notDimensionMapping();
        }
        return this.propValues.get(value);
    }

    public String getOrgUnitExtFields() {
        Long value = (Long)this.schema.get("fentryfieldextid");
        return value != null && value != 0L ? this.propValues.get(value) : null;
    }

    public String getAccountFields() {
        Long value = (Long)this.schema.get("faccountfieldid");
        if (value == null || value == 0L) {
            ControlException.notDimensionMapping();
        }
        return this.propValues.get(value);
    }

    public String getAccountExtFields() {
        Long value = (Long)this.schema.get("faccountfieldextid");
        return value != null && value != 0L ? this.propValues.get(value) : null;
    }

    public String getCurrencyFields() {
        Long value = (Long)this.schema.get("fcurrencyfieldid");
        if (value == null || value == 0L) {
            ControlException.notDimensionMapping();
        }
        return this.propValues.get(value);
    }

    public String getCurrencyExtFields() {
        Long value = (Long)this.schema.get("fcurrencyfieldextid");
        return value != null && value != 0L ? this.propValues.get(value) : null;
    }

    public String getPeriodFields() {
        Long value = (Long)this.schema.get("fyearfieldid");
        if (value == null || value == 0L) {
            ControlException.notDimensionMapping();
        }
        return this.propValues.get(value);
    }

    public String getChangeTypeField() {
        Long value = (Long)this.schema.get("fchangetypefield");
        if (value != null && value != 0L) {
            return this.propValues.get(value);
        }
        return null;
    }

    public String getChangeTypeExtField() {
        Long value = (Long)this.schema.get("changetypefieldext");
        return value != null && value != 0L ? this.propValues.get(value) : null;
    }

    public Member getMetricField() {
        return this.metric;
    }

    public Map<String, Long> getUserDefendDimIdMap() {
        return this.userDefendDimIdMap;
    }

    public Map<String, String> getUserDefendDimNumMap() {
        return this.userDefendDimNumMap;
    }

    public Map<String, String> getUserDefendPropMap() {
        return this.userDefendPropMap;
    }

    public String getUserDefendExt(Dimension dimension) {
        if (dimension != null) {
            return this.userDefendPropMap.get(BgControlScheme.getUserDefendExtKey(dimension));
        }
        return null;
    }

    public static String getUserDefendKey(Dimension dimension) {
        if (dimension != null) {
            return "userdefined" + dimension.getNumber();
        }
        return null;
    }

    public static String getUserDefendExtKey(Dimension dimension) {
        if (dimension != null) {
            return "userdefined" + dimension.getNumber() + "ext";
        }
        return null;
    }

    public Map<String, Long> getHasMappings() {
        return this.hasMappings;
    }

    public Map<Long, BgItemMapping> getMappings() {
        return this.mappings;
    }

    public boolean hasMapping(BizModel model) {
        if (model == null || model.getDimensions() == null) {
            return false;
        }
        Long mapId = (Long)this.schema.get("fentrydimsionmapid");
        if (mapId != null && mapId != 0L) {
            this.getHasMappings().put(SysDimensionEnum.Entity.getNumber(), mapId);
        }
        if ((mapId = (Long)this.schema.get("faccountdimsionmapid")) != null && mapId != 0L) {
            this.getHasMappings().put(SysDimensionEnum.Account.getNumber(), mapId);
        }
        if ((mapId = (Long)this.schema.get("fcurrencydimsionmapid")) != null && mapId != 0L) {
            this.getHasMappings().put(SysDimensionEnum.Currency.getNumber(), mapId);
        }
        if ((mapId = (Long)this.schema.get("fchangetypedimsionmapid")) != null && mapId != 0L) {
            this.getHasMappings().put(SysDimensionEnum.ChangeType.getNumber(), mapId);
        }
        if (model.isEBByModel()) {
            for (Dimension dimension : model.getDimensions()) {
                if (!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) continue;
                String index = dimension.getFieldMapped().replaceFirst("dim", "");
                String userDefinedMap = "fuserdefined" + index + "dimsionmapid";
                mapId = (Long)this.schema.get(userDefinedMap);
                if (mapId == null || mapId == 0L) continue;
                this.getHasMappings().put(dimension.getNumber(), mapId);
            }
        } else {
            for (int i = 1; i <= 6; ++i) {
                Dimension dimension;
                String userDefinedMap = "fuserdefined" + i + "dimsionmapid";
                String dimensionId = "fuserdefineddimid" + i;
                Long dimId = (Long)this.schema.get(dimensionId);
                mapId = (Long)this.schema.get(userDefinedMap);
                if (mapId == null || mapId == 0L || (dimension = model.getDimension(dimId)) == null) continue;
                this.getHasMappings().put(dimension.getNumber(), mapId);
            }
        }
        BgControlLogUtils.info((LogStats)null, true, "getHasMappings=" + JSONUtils.toString(this.getHasMappings()));
        return !this.getHasMappings().isEmpty();
    }

    public void loadMapping(BizModel model) {
        this.stats.add("begin-load-mapping.");
        HashSet<Long> mappingIds = new HashSet<Long>();
        mappingIds.addAll(this.getHasMappings().values());
        Map<Long, BgItemMapping> mappings = BgMemMappingServiceHelper.queryCacheByMapping(model, mappingIds);
        if (mappings != null) {
            this.getMappings().putAll(mappings);
        }
        this.stats.add("end-load-mapping.");
    }

    public BgItemMappingMember mapping(boolean equalsNumber, Member member, Map<String, Object> propValueMap) {
        BgItemMapping mapping;
        BgItemMappingMember result = new BgItemMappingMember();
        Member[] _member = new Member[2];
        result.member = _member;
        _member[0] = member;
        _member[1] = member;
        if (member == null || member.getDimension() == null || member.isMapping()) {
            if (member != null) {
                this.stats.add("member isMapping.(id=" + member.getId() + ", number=" + member.getNumber() + ")");
            }
            return result;
        }
        if (this.getHasMappings().isEmpty()) {
            return result;
        }
        Long mappingId = this.getHasMappings().get(member.getDimension().getNumber());
        if (mappingId == null || mappingId == 0L) {
            return result;
        }
        if (equalsNumber) {
            if (StringUtils.isEmpty((String)member.getNumber())) {
                ControlException.errorMappingMemberNull((String)member.getDimension().getNumber());
            }
        } else if (member.getId() == null || member.getId() == 0L) {
            return result;
        }
        if ((mapping = this.getMappings().get(mappingId)) != null) {
            mapping.setStats(this.stats);
            long begin = System.nanoTime();
            BgItemMappingMember _result = mapping.mapping(equalsNumber, this, member, propValueMap);
            if (_result == null || _result.member == null) {
                return result;
            }
            result = _result;
            _member = result.member;
            try {
                this.stats.addInfo(member.getDimension().getNumber() + " is mapping, use=" + LogUtils.use((long)begin) + " _member = " + JSONUtils.toString((Object)member));
            }
            catch (Throwable e) {
                BgControlLogUtils.info(this.stats, true, e.getMessage());
            }
            if (_member[0] != null) {
                _member[0].setDimension(member.getDimension());
            } else {
                this.stats.addInfo("no member budget mapping. memberNumber = " + member.getNumber());
            }
            if (_member[1] != null) {
                _member[1].setDimension(member.getDimension());
            } else {
                this.stats.addInfo("no member actual mapping. memberNumber = " + member.getNumber());
            }
        } else {
            this.stats.addInfo("no mapping. dimensionNumber = " + member.getDimension().getNumber());
        }
        return result;
    }

    private void setCondition(String entityNumber, Map<String, Object> schema) {
        BgControlScheme.setCondition(this, entityNumber, schema);
    }

    private BgControlScheme() {
    }

    public static Set<String> getConditionFields(String entityNumber, Map<String, Object> schema) {
        if (StringUtils.isEmpty((String)entityNumber) || schema == null || schema.isEmpty()) {
            return new HashSet<String>(1);
        }
        BgControlScheme controlScheme = new BgControlScheme();
        BgControlScheme.setCondition(controlScheme, entityNumber, schema);
        return controlScheme.getCondProperty();
    }

    private static void setCondition(@NotNull BgControlScheme controlScheme, String entityNumber, Map<String, Object> schema) {
        controlScheme.setFilter(null);
        QFilter qFilter = null;
        try {
            if (schema.get("fserqfilter") != null && !"".equals(schema.get("fserqfilter")) && ((String)schema.get("fserqfilter")).startsWith("{")) {
                controlScheme.condition = (String)schema.get("fserqfilter");
                FlexBDValueCondition flexBDValueCondition = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)controlScheme.condition, FlexBDValueCondition.class);
                FilterBuilder filterBuilder = ConditionUtils.get().getFilterBuilder(entityNumber, flexBDValueCondition.getFilterCondition());
                qFilter = filterBuilder.getFilterObject().getFilterResult().getQFilter();
            } else if (schema.get("fqfilter") != null && !"".equals(schema.get("fqfilter"))) {
                controlScheme.condition = (String)schema.get("fqfilter");
                qFilter = QFilter.of((String)controlScheme.parseCondition(controlScheme.condition), (Object[])new Object[0]);
            }
        }
        catch (Throwable ex) {
            log.warn("condition parse error:" + controlScheme.condition);
            log.warn("condition parse error:", ex);
            ControlException.errorControlSchemeCondition((String)controlScheme.condition);
        }
        if (qFilter != null) {
            controlScheme.setFilter(qFilter);
            if (controlScheme.getFilter() != null && "gl_voucher".equals(entityNumber)) {
                if (controlScheme.getPropertyMap().containsKey(controlScheme.getFilter().getProperty())) {
                    controlScheme.getFilter().__setProperty(controlScheme.getPropertyMap().get(controlScheme.getFilter().getProperty()));
                }
                List filters = controlScheme.getFilter().getNests(true);
                for (QFilter.QFilterNest next : filters) {
                    if (!controlScheme.getPropertyMap().containsKey(next.getFilter().getProperty())) continue;
                    next.getFilter().__setProperty(controlScheme.getPropertyMap().get(next.getFilter().getProperty()));
                }
            }
        }
    }

    public String getCondition() {
        return this.condition;
    }

    private String parseCondition(String condition) {
        if (condition == null) {
            return null;
        }
        this.propertyMap.clear();
        Pattern p = Pattern.compile("[A-Za-z0-9]+[.A-Za-z0-9]+");
        Matcher m = p.matcher(condition);
        while (m.find()) {
            Object[] tmpStr;
            String property = m.group();
            if (property == null || !property.startsWith("entries.assgrp") || (tmpStr = org.apache.commons.lang3.StringUtils.split((String)property, (char)'.')) == null) continue;
            boolean replace = false;
            int in = tmpStr.length;
            for (int i = 0; i < in; ++i) {
                if (tmpStr[i] == null || tmpStr[i].length() <= 0 || !Character.isDigit(((String)tmpStr[i]).charAt(0))) continue;
                tmpStr[i] = "tag" + (String)tmpStr[i];
                replace = true;
            }
            if (!replace) continue;
            this.getPropertyMap().put(StringUtils.join((Object[])tmpStr, (char)'.'), property);
        }
        if (!this.getPropertyMap().isEmpty()) {
            for (Map.Entry<String, String> entry : this.getPropertyMap().entrySet()) {
                condition = org.apache.commons.lang3.StringUtils.replace((String)condition, (String)entry.getValue(), (String)entry.getKey());
            }
        }
        return condition;
    }

    public Map<String, String> getPropertyMap() {
        return this.propertyMap;
    }

    public Set<String> getCondProperty() {
        if (this.getFilter() == null) {
            return Collections.emptySet();
        }
        LinkedHashSet properties = Sets.newLinkedHashSet();
        properties.add(this.getFilter().getProperty());
        Iterator iterator = this.getFilter().getNests(true).iterator();
        while (iterator.hasNext()) {
            properties.add(((QFilter.QFilterNest)iterator.next()).getFilter().getProperty());
        }
        return properties;
    }

    private void setFilter(QFilter filter) {
        this.filter = filter;
    }

    public QFilter getFilter() {
        return this.filter;
    }

    private void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public Long getModelId() {
        Long value = (Long)this.schema.get("fmodelid");
        if (value == null || value == 0L) {
            ControlException.errorBizModel();
        }
        return value;
    }

    public Long getBussModelId() {
        Long value = (Long)this.schema.get("fbussmodelid");
        if (value == null) {
            ControlException.errorBizModel();
        }
        return value;
    }

    public Long getBizModelKey() {
        Long bussId = this.getBussModelId();
        if (bussId != 0L) {
            return bussId;
        }
        return this.getModelId();
    }

    public Date getEffectivetime() {
        return (Date)this.schema.get("feffectivetime");
    }

    public Date getInvalidtime() {
        return (Date)this.schema.get("finvalidtime");
    }

    public Map<String, Object> getCloneScheme() {
        if (this.schema != null) {
            return new HashMap<String, Object>(this.schema);
        }
        return new HashMap<String, Object>(10);
    }

    public boolean isDynamicvalue() {
        return BgControlScheme.isDynamicvalue(this.schema);
    }

    public static boolean isDynamicvalue(Map<String, Object> scheme) {
        if (scheme == null) {
            return false;
        }
        return BgControlScheme.getBoolean(scheme.get("fisdynamicvalue"));
    }

    public String getControlValue(String occType, String operation) {
        if (this.schema.get("controlSchemeValueField") == null) {
            return null;
        }
        Map values = (Map)this.schema.get("controlSchemeValueField");
        return (String)values.get(Pair.onePair((Object)occType, (Object)operation));
    }

    public void setControlSchemeValueField(Map<Pair<String, String>, String> valueFields) {
        this.schema.put("controlSchemeValueField", valueFields);
    }

    public Long getWriteoffSchemeId() {
        return IDUtils.toLong((Object)this.schema.get("fwriteoffschemeid"));
    }

    public void setWriteOff(IWriteOff of) {
        this.schema.put("writeoffobj", of);
    }

    public IWriteOff getWriteOff() {
        return (IWriteOff)this.schema.get("writeoffobj");
    }

    public void setProcessIds(Set<Long> set) {
        this.schema.put("processIdSet", set);
    }

    public Set<Long> getProcessIds() {
        return (Set)this.schema.get("processIdSet");
    }

    public boolean isInProcess(Long processId) {
        return !this.isDynamicvalue() || this.getProcessIds() == null || this.getProcessIds().isEmpty() || this.getProcessIds().contains(processId);
    }

    public void setSourceGroups(Set<Long> sourceGroups) {
        this.schema.put("sourceGroups", sourceGroups);
    }

    public Set<Long> getSourceGroups() {
        return (Set)this.schema.get("sourceGroups");
    }
}

