/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.model;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.utils.BgControlProcessUtils;

public class BgControlSchemeValueField {
    private Map<Pair<String, String>, String> valueFields = new LinkedHashMap<Pair<String, String>, String>(10);

    public Map<Pair<String, String>, String> getValueFields() {
        return this.valueFields;
    }

    private Map<String, String> getValueFieldsCache() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        for (Map.Entry<Pair<String, String>, String> entry : this.valueFields.entrySet()) {
            result.put((String)entry.getKey().p1 + "_" + (String)entry.getKey().p2, entry.getValue());
        }
        return result;
    }

    public String toJsonString() {
        String json = "";
        Map<String, String> result = this.getValueFieldsCache();
        if (result != null && !result.isEmpty()) {
            json = JSONUtils.toString(result);
        }
        return json;
    }

    public void addFromControlProcess(BillFieldTypeEmum fieldType, String operations, String valuefield) {
        if (fieldType == null || StringUtils.isEmpty((String)operations)) {
            return;
        }
        Set<String> operationSet = BgControlProcessUtils.getOperations(operations);
        if (operationSet != null) {
            for (String operaion : operationSet) {
                Pair key = Pair.onePair((Object)String.valueOf(fieldType.getIndex()), (Object)operaion);
                if (this.valueFields.containsKey(key)) {
                    if (StringUtils.equals((String)this.valueFields.get(key), (String)valuefield)) continue;
                    this.valueFields.put((Pair<String, String>)key, "");
                    continue;
                }
                this.valueFields.put((Pair<String, String>)Pair.onePair((Object)String.valueOf(fieldType.getIndex()), (Object)operaion), valuefield);
            }
        }
    }

    public void loadFromJson(String json) {
        MapType javaType;
        Map map;
        if (StringUtils.isNotEmpty((String)json) && (map = (Map)JSONUtils.parse((String)json, (JavaType)(javaType = JSONUtils.getMapper().getTypeFactory().constructMapType(LinkedHashMap.class, String.class, String.class)))) != null) {
            for (Map.Entry entry : map.entrySet()) {
                int index = ((String)entry.getKey()).indexOf(95);
                if (index <= 0) continue;
                this.valueFields.put((Pair<String, String>)Pair.onePair((Object)((String)entry.getKey()).substring(0, index), (Object)((String)entry.getKey()).substring(index + 1)), (String)entry.getValue());
            }
        }
    }
}

