/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.common.enums.BgControlPeriodTypeEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BaseObject;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.utils.BgControlRuleUtils;
import org.apache.commons.collections4.CollectionUtils;

public class BgControlSetting
extends BaseObject {
    private static final long serialVersionUID = 470935644891938503L;
    private Map<Long, Set<String>> oboMemberNumberMap = new HashMap<Long, Set<String>>(16);
    private List<Long> oboDimIds = new ArrayList<Long>(16);
    private Map<String, String> memberMap = new HashMap<String, String>(10);
    private String accountNumber = null;
    BigDecimal coefficient = null;
    private boolean isDefault = false;

    public static BgControlSetting loadFromDynamicobject(DynamicObject object) {
        return new BgControlSetting(object);
    }

    public static BgControlSetting createDefault() {
        DynamicObject object = BgControlRuleUtils.getInterface().createDefaultRuleObj();
        BgControlSetting setting = BgControlSetting.loadFromDynamicobject(object);
        setting.setPeriodType(BgControlPeriodTypeEnum.MONTH);
        setting.setSettingType(BgControlSettingTypeEnum.MONTH);
        setting.setCoefficient(BigDecimal.ONE);
        setting.setBeyond(false);
        return setting;
    }

    protected BgControlSetting(DynamicObject object) {
        super(object);
    }

    public void setObject(DynamicObject object) {
        super.setObject(object);
    }

    public Map<Long, Set<String>> getOboMemberNumberMap() {
        return this.oboMemberNumberMap;
    }

    public void setOboMemberNumberMap(Map<Long, Set<String>> oboMemberNumberMap) {
        this.oboMemberNumberMap = oboMemberNumberMap;
    }

    public List<Long> getOboDimIds() {
        return this.oboDimIds;
    }

    public void setOboDimIds(List<Long> oboDimIds) {
        this.oboDimIds = oboDimIds;
    }

    public Long getId() {
        return this.getObject().getDynamicObject("mainRuleField").getLong("id");
    }

    public String getAccountName() {
        if (IDUtils.isEmptyLong((Long)this.getGroupId()).booleanValue()) {
            return this.getObject().getDynamicObject("mainRuleField").getString("accounts.account.name");
        }
        return this.getObject().getDynamicObject("userDefinedRuleField").getString("dimentions.groupaccount.name");
    }

    public Map<String, String> getMemberMap() {
        return this.memberMap;
    }

    public void initMemberMap() {
        if (IDUtils.isEmptyLong((Long)this.getGroupId()).booleanValue()) {
            return;
        }
        this.memberMap.put(SysDimensionEnum.Account.getNumber(), this.getAccountNumber());
        for (int i = 1; i <= 7; ++i) {
            Long dimId = this.getObject().getDynamicObject("userDefinedRuleField").getLong("dimentions.userdefineddimid" + i);
            if (dimId == null || dimId == 0L) continue;
            this.memberMap.put(String.valueOf(dimId), this.getObject().getDynamicObject("userDefinedRuleField").getString("dimentions.userdefined" + i + ".number"));
        }
    }

    public String getAccountNumber() {
        if (this.accountNumber == null) {
            this.accountNumber = IDUtils.isEmptyLong((Long)this.getGroupId()) != false ? this.getObject().getDynamicObject("mainRuleField").getString("accounts.account.number") : this.getObject().getDynamicObject("userDefinedRuleField").getString("dimentions.groupaccount.number");
        }
        return this.accountNumber;
    }

    public String getGroupAccountName() {
        return this.getObject().getDynamicObject("userDefinedRuleField").getString("dimentions.groupaccount.name");
    }

    public String getGroupAccountNumber() {
        return this.getObject().getDynamicObject("userDefinedRuleField").getString("dimentions.groupaccount.number");
    }

    public BgControlPeriodTypeEnum getPeriodType() {
        BgControlPeriodTypeEnum _enum = BgControlPeriodTypeEnum.valueOf((int)this.getObject().getDynamicObject("mainRuleField").getInt("periodclassify"));
        return _enum;
    }

    public void setPeriodType(BgControlPeriodTypeEnum periodType) {
        if (this.getObject() != null && periodType != null) {
            this.getObject().getDynamicObject("mainRuleField").set("periodclassify", (Object)periodType.getIndex());
        }
    }

    public BgControlSettingTypeEnum getSettingType() {
        BgControlSettingTypeEnum _enum = BgControlSettingTypeEnum.valueOf((int)this.getObject().getDynamicObject("mainRuleField").getInt("controltype"));
        return _enum;
    }

    public void setSettingType(BgControlSettingTypeEnum controlType) {
        if (this.getObject() != null && controlType != null) {
            this.getObject().getDynamicObject("mainRuleField").set("controltype", (Object)controlType.getIndex());
        }
    }

    public boolean isCurrPeriod() {
        BgControlSettingTypeEnum controlType = this.getSettingType();
        return controlType == null || BgControlSettingTypeEnum.MONTH == controlType;
    }

    public BigDecimal getCoefficient() {
        if (this.coefficient != null) {
            return this.coefficient;
        }
        this.coefficient = this.getObject().getDynamicObject("mainRuleField").getBigDecimal("coefficient");
        if (this.coefficient == null) {
            this.coefficient = BigDecimal.ONE;
        }
        return this.coefficient;
    }

    public void setCoefficient(BigDecimal coefficient) {
        if (this.getObject() != null && coefficient != null) {
            this.getObject().getDynamicObject("mainRuleField").set("coefficient", (Object)coefficient);
            this.coefficient = coefficient;
        }
    }

    public boolean isBeyond() {
        return this.getObject().getDynamicObject("mainRuleField").getBoolean("isbeyond");
    }

    public void setBeyond(boolean isBeyond) {
        if (this.getObject() != null) {
            this.getObject().getDynamicObject("mainRuleField").set("isbeyond", (Object)isBeyond);
        }
    }

    public Long getGroupId() {
        return this.getObject().getDynamicObject("mainRuleField").getLong("group.id");
    }

    public int getGroupNo() {
        int groupNo = this.getObject().getDynamicObject("mainRuleField").getInt("group.groupseq");
        return groupNo;
    }

    public String getGroupName() {
        return this.getObject().getDynamicObject("mainRuleField").getString("group.groupname");
    }

    public String getMemberNumber(BizModel model, BgControlScheme controlScheme, Dimension dimension, IControlParam controlParam, Map<Long, Set<String>> oboMemberNumberMap) {
        if (dimension == null) {
            return null;
        }
        String memberNumber = BgControlRuleUtils.getRuleMember(this.getObject(), dimension, controlParam, oboMemberNumberMap);
        if (StringUtils.isEmpty((String)memberNumber)) {
            memberNumber = BgControlRuleUtils.getRuleMember(model, controlScheme, this.getObject(), dimension);
        }
        return memberNumber;
    }

    public String getKey(BizModel model, BgControlScheme controlScheme, Collection<Dimension> dimensions, IControlParam controlParam, Map<Long, Set<String>> oboMemberNumberMap, List<Long> oboDimIds, Map<Long, Boolean> hasUserDefinedDimensionMap) {
        String userDefNumber = null;
        String accountNumber = this.getAccountNumber();
        if (StringUtils.isNotEmpty((String)this.getGroupAccountNumber())) {
            accountNumber = this.getGroupAccountNumber();
        }
        StringBuilder ruleKey = new StringBuilder(accountNumber);
        for (Dimension dimension : dimensions) {
            if (!hasUserDefinedDimensionMap.get(dimension.getId()).booleanValue()) continue;
            userDefNumber = this.getMemberNumber(model, controlScheme, dimension, controlParam, oboMemberNumberMap);
            if (StringUtils.isNotEmpty((String)userDefNumber)) {
                ruleKey.append("_").append(userDefNumber);
                continue;
            }
            if (!IDUtils.isNotEmptyLong((Long)this.getGroupId()).booleanValue() || CollectionUtils.isNotEmpty(oboDimIds) && oboDimIds.contains(dimension.getId())) continue;
            ruleKey.append("_").append(dimension.getNumber());
        }
        return ruleKey.toString();
    }

    public void setId(Long id) {
        this.getObject().getDynamicObject("mainRuleField").set("id", (Object)id);
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean isDefault() {
        return this.isDefault;
    }
}

