/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.model;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.RangeMappingEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.impl.model.BgItemMappingMember;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.OQLBuilder;
import org.apache.commons.collections4.CollectionUtils;

public class BgItemMapping
implements Serializable {
    private static final Log log = LogFactory.getLog(BgItemMapping.class);
    private static final long serialVersionUID = 50386562573985333L;
    private static final String ENTRYID = "entryId";
    public static final String MAPPINGID = "mpId";
    public static final String BIZID = "biid";
    public static final String BIZNUMBER = "binu";
    public static final String BIZNAME = "bina";
    public static final String BIZRANGE = "bir";
    public static final String BIZENTITYNUMBER = "bien";
    public static final String BIZEXTID = "beid";
    public static final String BIZEXTNUMBER = "benu";
    public static final String BIZEXTNAME = "bena";
    public static final String BGITEMID = "bgiid";
    public static final String BGITEMNUMBER = "bginu";
    public static final String BGITEMNAME = "bgina";
    public static final String BGBUITEMID = "bgbuid";
    public static final String BGBUITEMNUMBER = "bgbunu";
    public static final String BGBUITEMNAME = "bgbuna";
    public static final String WILDCARDSTATUS = "wcs";
    public static final String WILDCARDSTATUS_YES = "1";
    public static final String WILDCARDSTATUS_NO = "0";
    public static final String DIMNUMBER = "dim";
    private Long id = null;
    private String number = null;
    private String dim = null;
    private boolean useAssistData = false;
    private boolean exitNoLeaf = false;
    private String bizData = null;
    private String bizDataExt = null;
    private LogStats stats = null;
    private Map<String, Map<String, String>> entry_only = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> entry_onlyId = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> wildcards = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> entryOnlyDimMemberEmp = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> child = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> extWildCardsChild = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> mappingDataCache = new HashMap<String, Map<String, String>>(100);
    private SimpleDateFormat format = new SimpleDateFormat("HH-mm-ss.SSS");
    private Map<String, DynamicObject> parentMap = new HashMap<String, DynamicObject>(100);

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getNumber() {
        return this.number;
    }

    public void setDim(String dim) {
        this.dim = dim;
    }

    public String getDim() {
        return this.dim;
    }

    public void setUseAssistData(boolean useAssistData) {
        this.useAssistData = useAssistData;
    }

    public boolean isUseAssistData() {
        return this.useAssistData;
    }

    public void setExitNoLeaf(boolean exitNoLeaf) {
        this.exitNoLeaf = exitNoLeaf;
    }

    public boolean isExitNoLeaf() {
        return this.exitNoLeaf;
    }

    public void setBizData(String bizData) {
        this.bizData = bizData;
    }

    public String getBizData() {
        return this.bizData;
    }

    public void setBizDataExt(String bizDataExt) {
        this.bizDataExt = bizDataExt;
    }

    public String getBizDataExt() {
        return this.bizDataExt;
    }

    public void setStats(LogStats stats) {
        this.stats = stats;
    }

    public LogStats getStats() {
        return this.stats;
    }

    public Map<String, Map<String, String>> getOnlyEntry() {
        return this.entry_only;
    }

    public Map<String, Map<String, String>> getOnlyEntryId() {
        return this.entry_onlyId;
    }

    public Map<String, Map<String, String>> getWildcards() {
        return this.wildcards;
    }

    public Map<String, Map<String, String>> getEntryOnlyDimMemberEmp() {
        return this.entryOnlyDimMemberEmp;
    }

    public Map<String, Map<String, String>> getChild() {
        return this.child;
    }

    public Map<String, Map<String, String>> getExtWildCardsChild() {
        return this.extWildCardsChild;
    }

    public void addEntry(Long mappingid, Long entryId, String bizEntityNumber, String bizId, String bizNumber, String bizName, String range, String bizExtId, String bizExtNumber, String bizExtName, String itemId, String itemNumber, String itemName, String itemBuId, String itemBuNumber, String itemBuName, String wildcardStatus) {
        if (entryId == null || entryId == 0L || StringUtils.isEmpty((String)bizNumber) || StringUtils.isEmpty((String)bizName)) {
            return;
        }
        LinkedHashMap<String, String> entry = new LinkedHashMap<String, String>(16);
        entry.put(MAPPINGID, mappingid.toString());
        entry.put(ENTRYID, entryId.toString());
        entry.put(BIZENTITYNUMBER, bizEntityNumber);
        entry.put(BIZID, bizId);
        entry.put(BIZNUMBER, bizNumber);
        entry.put(BIZNAME, bizName);
        entry.put(BIZRANGE, String.valueOf(range));
        entry.put(BIZEXTID, bizExtId);
        entry.put(BIZEXTNUMBER, bizExtNumber);
        entry.put(BIZEXTNAME, bizExtName);
        entry.put(BGITEMID, itemId);
        entry.put(BGITEMNUMBER, itemNumber);
        entry.put(BGITEMNAME, itemName);
        entry.put(BGBUITEMID, itemBuId);
        entry.put(BGBUITEMNUMBER, itemBuNumber);
        entry.put(BGBUITEMNAME, itemBuName);
        entry.put(WILDCARDSTATUS, wildcardStatus != null ? wildcardStatus : WILDCARDSTATUS_NO);
        int _range = RangeEnum.ONLY.getIndex();
        if (StringUtils.isNotEmpty((String)range)) {
            try {
                _range = Integer.parseInt(range);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.addEntry(entry, _range, wildcardStatus, itemNumber, itemBuNumber);
    }

    private void addEntry(Map<String, String> mapping, int range, String wildcardStatus, String itemNumber, String itemBuNumber) {
        if (mapping == null) {
            return;
        }
        String idKey = mapping.get(BIZID);
        String key = mapping.get(BIZNUMBER);
        String extKey = mapping.get(BIZEXTNUMBER);
        key = StringUtils.isEmpty((String)extKey) ? key : key + '@' + extKey;
        String string = idKey = StringUtils.isEmpty((String)extKey) ? idKey : idKey + '@' + extKey;
        if (WILDCARDSTATUS_YES.equals(wildcardStatus)) {
            if (StringUtils.isNotEmpty((String)itemNumber) || StringUtils.isNotEmpty((String)itemBuNumber)) {
                if (RangeMappingEnum.ALL_EXCLUDE.getIndex() == range) {
                    this.getExtWildCardsChild().put(key, mapping);
                } else {
                    this.getWildcards().put(key, mapping);
                }
            }
        } else if (RangeEnum.ONLY.getIndex() == range) {
            if (StringUtils.isNotEmpty((String)itemNumber) || StringUtils.isNotEmpty((String)itemBuNumber)) {
                this.getOnlyEntry().put(key, mapping);
                this.getOnlyEntryId().put(idKey, mapping);
            } else {
                this.getEntryOnlyDimMemberEmp().put(key, mapping);
            }
        } else if (StringUtils.isNotEmpty((String)itemNumber) || StringUtils.isNotEmpty((String)itemBuNumber)) {
            this.getChild().put(key, mapping);
        }
    }

    public void sortWildcards() {
        if (this.getWildcards() == null || this.getWildcards().isEmpty()) {
            return;
        }
        LinkedHashMap<String, Map<String, String>> clone = new LinkedHashMap<String, Map<String, String>>(this.getWildcards());
        ArrayList entryList = new ArrayList(clone.entrySet());
        entryList.sort((e1, e2) -> {
            boolean bizWild2;
            boolean bizWild1 = this.hasWildcards((String)((Map)e1.getValue()).get(BIZNUMBER));
            if (bizWild1 != (bizWild2 = this.hasWildcards((String)((Map)e2.getValue()).get(BIZNUMBER)))) {
                return Boolean.compare(bizWild1, bizWild2);
            }
            boolean extWild1 = this.hasWildcards((String)((Map)e1.getValue()).get(BIZEXTNUMBER));
            boolean extWild2 = this.hasWildcards((String)((Map)e2.getValue()).get(BIZEXTNUMBER));
            return Boolean.compare(extWild1, extWild2);
        });
        this.getWildcards().clear();
        for (Map.Entry entry : entryList) {
            this.getWildcards().put((String)entry.getKey(), (Map<String, String>)entry.getValue());
        }
    }

    private boolean hasWildcards(String number) {
        return StringUtils.isNotEmpty((String)number) && '%' == number.charAt(number.length() - 1);
    }

    public BgItemMappingMember mapping(boolean equalsNumber, BgControlScheme schema, Member member, Map<String, Object> propValueMap) {
        if (schema == null || member == null || propValueMap == null) {
            this.getStats().addInfo("memberNumber or propValue is null.");
            return null;
        }
        Map<String, String> data = null;
        Member[] _member = new Member[]{member, member};
        String propNumValue = null;
        String mapKey = equalsNumber ? member.getNumber() : member.getId().toString();
        String extName = null;
        if (this.isUseAssistData()) {
            this.getStats().addInfo("use AssistData.");
            String extField = this.getExtField(member.getDimension(), schema);
            String extNumField = OQLBuilder.getNumberProp(extField);
            String extNameField = OQLBuilder.getAliasProp(extField);
            propNumValue = Convert.toStr((Object)propValueMap.get(extNumField));
            extName = Convert.toStr((Object)propValueMap.get(extNameField));
            if (propNumValue != null) {
                this.getStats().addInfo("find extPropValue. propKey = " + extField + "; propNumField = " + extNumField + "; propNumValue = " + propNumValue);
                mapKey = mapKey + '@' + propNumValue;
            } else {
                this.getStats().addInfo("not find extPropValue. propKey = " + extNumField);
                propNumValue = "";
            }
        } else {
            this.getStats().addInfo("cant use AssistData.");
        }
        BgControlLogUtils.info(this.getStats(), true, "find-mapping=" + equalsNumber + mapKey);
        if (this.mappingDataCache.containsKey(equalsNumber + mapKey)) {
            data = this.mappingDataCache.get(equalsNumber + mapKey);
        } else {
            BgControlLogUtils.info(this.getStats(), true, "find-mapping=" + equalsNumber + mapKey + " " + this.format.format(new Date()));
            Map<String, String> map = data = equalsNumber ? this.getOnlyEntry().get(mapKey) : this.getOnlyEntryId().get(mapKey);
            if (data == null && equalsNumber) {
                if (this.getEntryOnlyDimMemberEmp().containsKey(mapKey)) {
                    data = this.getSameNumberDimMemberData(member, schema, this.getEntryOnlyDimMemberEmp().get(mapKey));
                }
                if (data == null) {
                    data = this.fuzzyMatching(member.getNumber(), propNumValue);
                    if (data == null) {
                        data = this.parentMatching(member, member.getNumber(), propNumValue);
                    } else {
                        data = new HashMap<String, String>(data);
                        if (StringUtils.isNotEmpty((String)member.getName())) {
                            data.put(BIZNAME, member.getName());
                        }
                        if (StringUtils.isNotEmpty((String)extName)) {
                            data.put(BIZEXTNAME, extName);
                        }
                    }
                }
            }
        }
        this.mappingDataCache.put(equalsNumber + mapKey, data);
        if (data != null) {
            String number = data.get(BGITEMNUMBER);
            String name = data.get(BGITEMNAME);
            String bu_number = data.get(BGBUITEMNUMBER);
            String bu_name = data.get(BGBUITEMNAME);
            if (StringUtils.isNotEmpty((String)number) && StringUtils.isNotEmpty((String)name)) {
                _member[1] = new Member(null, name, number);
                _member[1].setMapping(true);
            }
            _member[0] = StringUtils.isNotEmpty((String)bu_number) && StringUtils.isNotEmpty((String)bu_name) ? new Member(null, bu_name, bu_number) : new Member(null, name, number);
            _member[0].setMapping(true);
        } else if (equalsNumber) {
            this.getStats().addInfo("not find mapping. memberNumber = " + member.getNumber());
        } else {
            this.getStats().addInfo("not find mapping. memberId = " + (member.getId() != null ? member.getId() : ""));
        }
        BgItemMappingMember result = new BgItemMappingMember();
        result.member = _member;
        result.mapping = data;
        return result;
    }

    private Map<String, String> getSameNumberDimMemberData(Member member, BgControlScheme schema, Map<String, String> sourceData) {
        HashMap<String, String> data = new HashMap<String, String>(16);
        Long modelId = schema.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        kd.epm.eb.common.cache.impl.Member dimMember = modelCacheHelper.getMemberByAnyView(member.getDimension().getNumber(), member.getNumber());
        if (dimMember == null) {
            return null;
        }
        data.put(BGITEMNUMBER, dimMember.getNumber());
        data.put(BGITEMNAME, dimMember.getName());
        if (sourceData != null && !sourceData.isEmpty() && StringUtils.isNotEmpty((String)sourceData.get(BGBUITEMNUMBER))) {
            data.put(BGBUITEMNUMBER, sourceData.get(BGBUITEMNUMBER));
            data.put(BGBUITEMNAME, sourceData.get(BGBUITEMNAME));
        }
        return data;
    }

    private Map<String, String> fuzzyMatching(String number, String extNumber) {
        if (this.getWildcards().isEmpty() || number == null) {
            return null;
        }
        boolean check = false;
        for (Map<String, String> entry : this.getWildcards().values()) {
            String bizNumber = entry.get(BIZNUMBER);
            if ('%' == bizNumber.charAt(bizNumber.length() - 1)) {
                if (number.startsWith(bizNumber = bizNumber.substring(0, bizNumber.length() - 1))) {
                    check = true;
                }
            } else {
                check = number.equals(bizNumber);
            }
            if (check && this.isUseAssistData()) {
                String bizExtNumber = entry.get(BIZEXTNUMBER);
                if (StringUtils.isNotEmpty((String)bizExtNumber) && StringUtils.isNotEmpty((String)extNumber)) {
                    if ('%' == bizExtNumber.charAt(bizExtNumber.length() - 1)) {
                        if (!extNumber.startsWith(bizExtNumber = bizExtNumber.substring(0, bizExtNumber.length() - 1))) {
                            check = false;
                        }
                    } else {
                        check = extNumber.equals(bizExtNumber);
                    }
                } else if (!StringUtils.isEmpty((String)bizExtNumber) || !StringUtils.isEmpty((String)extNumber)) {
                    check = false;
                }
            }
            if (!check) continue;
            return entry;
        }
        return null;
    }

    private Map<String, String> parentMatching(Member member, String number, String extNumber) {
        if (this.getChild().isEmpty() && this.getExtWildCardsChild().isEmpty() || member == null) {
            return null;
        }
        Map<String, String> data = null;
        String currNumber = number;
        DynamicObject obj = null;
        StringBuilder _log = new StringBuilder();
        _log.append("begin-parentMatching").append("\r\n");
        _log.append("allNumber-").append(number).append("\r\n");
        Long currId = member.getId();
        String mapKey = this.getMappingKey(number, extNumber);
        do {
            _log.append("find-key=").append(mapKey).append("\r\n");
            data = this.getChild().get(mapKey);
            if (data == null) {
                for (Map<String, String> entry : this.getExtWildCardsChild().values()) {
                    String bizExtNumber = entry.get(BIZEXTNUMBER);
                    if (!entry.get(BIZNUMBER).equals(currNumber) || !StringUtils.isNotEmpty((String)bizExtNumber) || '%' != bizExtNumber.charAt(bizExtNumber.length() - 1) || !extNumber.startsWith(bizExtNumber = bizExtNumber.substring(0, bizExtNumber.length() - 1))) continue;
                    data = entry;
                }
            }
            if (data == null) {
                _log.append("find-parent-id=").append(currId).append("\r\n");
                obj = this.getParentObj(this.getBizData(), currId);
                if (obj != null) {
                    currId = obj.getLong("id");
                    currNumber = obj.getString("number");
                    mapKey = this.getMappingKey(currNumber, extNumber);
                    continue;
                }
                _log.append("find-parent-null.").append("\r\n");
                continue;
            }
            _log.append("find.");
        } while (data == null && obj != null);
        BgControlLogUtils.info(this.getStats(), true, _log.toString());
        return data;
    }

    private String getMappingKey(String number, String extNumber) {
        String mapKey = this.isUseAssistData() && StringUtils.isNotEmpty((String)extNumber) ? number + '@' + extNumber : number;
        return mapKey;
    }

    private String getExtField(Dimension dimension, BgControlScheme schema) {
        if (dimension == null || schema == null) {
            return null;
        }
        if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
            return schema.getOrgUnitExtFields();
        }
        if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
            return schema.getAccountExtFields();
        }
        if (SysDimensionEnum.Currency.getNumber().equals(dimension.getNumber())) {
            return schema.getCurrencyExtFields();
        }
        if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
            return schema.getUserDefendExt(dimension);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Long> getMemberIdsByNumberSet(Set<String> memNumSet) {
        if (StringUtils.isEmpty((String)this.getBizData())) return null;
        if (CollectionUtils.isEmpty(memNumSet)) {
            return null;
        }
        HashMap<String, Long> memIdMap = new HashMap<String, Long>(memNumSet.size());
        QFBuilder builder = new QFBuilder();
        String entityNumber = this.getBizData();
        String selectFiles = "org.id as id,org.number as number";
        try {
            if ("bos_org".equals(entityNumber)) {
                entityNumber = "bos_org_structure";
                builder.add(new QFilter("org.number", "in", memNumSet));
            } else if ("bos_adminorg".equals(entityNumber)) {
                entityNumber = "bos_adminorg_structure";
                builder.add(new QFilter("org.number", "in", memNumSet));
                builder.add(new QFilter("view.treetype", "=", (Object)"01"));
            } else {
                builder.add(new QFilter("number", "in", memNumSet));
                selectFiles = "id,number";
            }
            HashMap<String, Set> memIdSetMap = new HashMap<String, Set>(memNumSet.size());
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getMemberIdsByNumberSet", (String)entityNumber, (String)selectFiles, (QFilter[])builder.toArrays(), null);){
                if (ds == null || ds.isEmpty()) {
                    HashMap<String, Long> hashMap = memIdMap;
                    return hashMap;
                }
                for (Row row : ds) {
                    Set memIdSet = memIdSetMap.computeIfAbsent(row.getString("number"), k -> new HashSet(16));
                    memIdSet.add(row.getLong("id"));
                }
            }
            Iterator iterator = memIdSetMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = (String)entry.getKey();
                Set value = (Set)entry.getValue();
                if (value.size() > 1) {
                    BgControlLogUtils.info(this.getStats(), true, "find-multiple-memberId-entityNumber:" + entityNumber + ";number:" + key + ";ids:" + StringUtils.join((Collection)value, (String)","));
                    continue;
                }
                memIdMap.put(key, (Long)value.iterator().next());
            }
            return memIdMap;
        }
        catch (Throwable ex) {
            log.error("getMemberIdsByNumberSet-error:", ex);
        }
        return memIdMap;
    }

    private DynamicObject getParentObj(String entityNumber, Long objId) {
        if (StringUtils.isEmpty((String)entityNumber) || objId == null || objId == 0L) {
            return null;
        }
        String pKey = entityNumber + "!" + objId;
        if (this.parentMap.containsKey(pKey)) {
            return this.parentMap.get(pKey);
        }
        QFBuilder builder = new QFBuilder();
        DynamicObject parent = null;
        try {
            if ("bos_org".equals(entityNumber)) {
                entityNumber = "bos_org_structure";
                builder.add(new QFilter("org.id", "=", (Object)objId));
                builder.add(new QFilter("view.treetype", "=", (Object)"15"));
            } else if ("bos_adminorg".equals(entityNumber)) {
                entityNumber = "bos_adminorg_structure";
                builder.add(new QFilter("org.id", "=", (Object)objId));
                builder.add(new QFilter("view.treetype", "=", (Object)"01"));
            } else {
                builder.add(new QFilter("id", "=", (Object)objId));
            }
            DynamicObject currObj = QueryServiceHelper.queryOne((String)entityNumber, (String)"id, parent.id, parent.number", (QFilter[])builder.toArrays());
            if (currObj != null) {
                parent = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
                parent.set("id", currObj.get("parent.id"));
                parent.set("number", currObj.get("parent.number"));
            }
        }
        catch (Throwable ex) {
            this.getStats().addInfo(ex.getMessage());
        }
        this.parentMap.put(pKey, parent);
        return parent;
    }
}

