/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.model;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.enums.BgControlPeriodTypeEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.model.BgDynamicObject;
import kd.epm.eb.common.model.BgPeriodUserDefinedUtils;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.BizOrgUnit;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.BgDataUtils;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.impl.model.BgControlSetting;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.BgPeriodUtils;

public class BudgetBalance
extends BgDynamicObject
implements IBudgetBalance {
    private static final long serialVersionUID = -7900705239583308059L;
    private static final Log log = LogFactory.getLog(BudgetBalance.class);
    private boolean isQueryBudget = true;
    protected transient LogStats stats = null;
    private static final String MAPPING_DATA = "MappingData";
    private static final String PROP_KEY = "propSource";
    private static final String NONE_KEY = "NONE_MEMBER_KEY";
    private static final String BUDGET_REQMEMBER = "BUDGET_REQMEMBER";
    private static final String BUDGET_MEMBER = "BUDGET_MEMBER";
    private static final String BUDGET_OBJECT = "BUDGET_OBJECT";
    private static final String ACTUAL_MEMBER = "ACTUAL_MEMBER";
    private static final String ACTUAL_OBJECT = "ACTUAL_OBJECT";
    private Map<String, Set<String>> addupPeriods = new HashMap<String, Set<String>>();
    private transient String budgetKey = null;
    private transient String actualKey = null;
    private String ctrlKey = null;
    private String ctrlKeyByOcc = null;
    private Map<Integer, List<BgControlSetting>> groupRuleMap = new HashMap<Integer, List<BgControlSetting>>();
    private Map<String, BgData> extBgData = new HashMap<String, BgData>();
    private Map<String, BgData> extBgOcData = new HashMap<String, BgData>();
    private Map<String, BgData> extAcData = new HashMap<String, BgData>();
    private BgControlScheme controlScheme = null;
    private String entryId;
    private Integer entrySeq;
    private JSONObject reqObj;
    private Map<String, BgData> extAdjustCheckBgOcData = new HashMap<String, BgData>();
    private boolean isCheckPermission = false;
    private boolean isExeMatch = false;
    private boolean isOccMatch = false;
    private boolean isNeedLog = false;
    private Set<String> queryUserDefDims = Sets.newHashSet();
    private boolean isDefaultZero = true;

    @Override
    public boolean isQueryBudget() {
        return this.isQueryBudget;
    }

    @Override
    public void setQueryBudget(boolean isQueryBudget) {
        this.isQueryBudget = isQueryBudget;
    }

    @Override
    public void setBizId(String bizId) {
        this.set("id", bizId);
    }

    @Override
    public String getBizId() {
        return this.getString("id");
    }

    public void setStats(LogStats stats) {
        this.stats = stats;
    }

    @Override
    public LogStats getStats() {
        return this.stats;
    }

    @Override
    public void setRefBizId(String refBizId) {
        this.set("refid", refBizId);
    }

    @Override
    public String getRefBizId() {
        return this.getString("refid");
    }

    @Override
    public void setBizNumber(String bizNumber) {
        this.set("number", bizNumber);
    }

    @Override
    public String getBizNumber() {
        return this.getString("number");
    }

    @Override
    public void setBizModel(BizModel bizModel) {
        this.set("bizmodel", bizModel);
    }

    @Override
    public BizModel getBizModel() {
        return (BizModel)this.get("bizmodel");
    }

    @Override
    public boolean checkBizModel(BizModel bizModel) {
        BizModel thisBizModel = this.getBizModel();
        if (bizModel == null) {
            return false;
        }
        if (thisBizModel == null) {
            return false;
        }
        return thisBizModel.getKey().equals(bizModel.getKey());
    }

    @Override
    public void setBizTime(Date bizTime) {
        this.set("bizTime", bizTime);
    }

    @Override
    public Date getBizTime() {
        return (Date)this.get("bizTime");
    }

    protected void setMember(String propertyName, Member member) {
        if (StringUtils.isEmpty((String)propertyName) || member == null || member.getDimension() == null || StringUtils.isEmpty((String)member.getDimension().getNumber())) {
            return;
        }
        HashMap<String, Member> members = (HashMap<String, Member>)this.get(propertyName);
        if (members == null) {
            members = new HashMap<String, Member>();
            this.set(propertyName, members);
        }
        members.put(member.getDimension().getNumber(), member);
    }

    protected Member getMember(String propertyName, String dimensionNumber) {
        if (StringUtils.isEmpty((String)propertyName) || StringUtils.isEmpty((String)dimensionNumber)) {
            return null;
        }
        Map members = (Map)this.get(propertyName);
        if (members != null) {
            return (Member)members.get(dimensionNumber);
        }
        return null;
    }

    protected void setObject(String propertyName, String dimensionNumber, DynamicObject object) {
        if (StringUtils.isEmpty((String)propertyName) || StringUtils.isEmpty((String)dimensionNumber) || object == null) {
            return;
        }
        HashMap<String, DynamicObject> objects = (HashMap<String, DynamicObject>)this.get(propertyName);
        if (objects == null) {
            objects = new HashMap<String, DynamicObject>();
            this.set(propertyName, objects);
        }
        objects.put(dimensionNumber, object);
    }

    protected DynamicObject getObject(String propertyName, String dimensionNumber) {
        if (StringUtils.isEmpty((String)propertyName) || StringUtils.isEmpty((String)dimensionNumber)) {
            return null;
        }
        Map members = (Map)this.get(propertyName);
        if (members != null) {
            return (DynamicObject)members.get(dimensionNumber);
        }
        return null;
    }

    @Override
    public void setMember(boolean isBudget, Member member) {
        this.setMember(this.getMemberType(isBudget), member);
    }

    @Override
    public Member getMember(boolean isBudget, String dimensionNumber) {
        return this.getMember(this.getMemberType(isBudget), dimensionNumber);
    }

    @Override
    public final void setReqMember(Member reqMember) {
        this.setMember(BUDGET_REQMEMBER, reqMember);
    }

    @Override
    public final Member getReqMember(String dimensionNumber) {
        return this.getMember(BUDGET_REQMEMBER, dimensionNumber);
    }

    @Override
    public void setMappingData(String dimensionNumber, Map<String, String> mappingData) {
        if (StringUtils.isEmpty((String)dimensionNumber)) {
            return;
        }
        this.getMappingDatas().put(dimensionNumber, mappingData);
    }

    @Override
    public Map<String, String> getMappingData(String dimensionNumber) {
        return this.getMappingDatas().get(dimensionNumber);
    }

    @Override
    public boolean hasMappingData() {
        return !this.getMappingDatas().isEmpty();
    }

    private Map<String, Map<String, String>> getMappingDatas() {
        HashMap mappingDatas = (HashMap)this.get(MAPPING_DATA);
        if (mappingDatas == null) {
            mappingDatas = new HashMap(10);
            this.set(MAPPING_DATA, mappingDatas);
        }
        return mappingDatas;
    }

    @Override
    public void setProp(String dimensionNumber, String propValue) {
        if (StringUtils.isEmpty((String)dimensionNumber) || StringUtils.isEmpty((String)propValue)) {
            return;
        }
        HashMap<String, String> props = (HashMap<String, String>)this.get(PROP_KEY);
        if (props == null) {
            props = new HashMap<String, String>();
            this.set(PROP_KEY, props);
        }
        props.put(dimensionNumber, propValue);
    }

    @Override
    public String getProp(String dimensionNumber) {
        if (StringUtils.isEmpty((String)dimensionNumber)) {
            return null;
        }
        Map props = (Map)this.get(PROP_KEY);
        if (props != null) {
            return (String)props.get(dimensionNumber);
        }
        return null;
    }

    @Override
    public void setHasNoneMember(String dimensionNumber) {
        if (StringUtils.isEmpty((String)dimensionNumber)) {
            return;
        }
        HashSet<String> nones = (HashSet<String>)this.get(NONE_KEY);
        if (nones == null) {
            nones = new HashSet<String>();
            this.set(NONE_KEY, nones);
        }
        nones.add(dimensionNumber);
    }

    @Override
    public boolean hasNoneMember(String dimensionNumber) {
        if (StringUtils.isEmpty((String)dimensionNumber)) {
            return false;
        }
        Set nones = (Set)this.get(NONE_KEY);
        if (nones != null) {
            return nones.contains(dimensionNumber);
        }
        return false;
    }

    private String getMemberType(boolean isBudget) {
        return isBudget ? BUDGET_MEMBER : ACTUAL_MEMBER;
    }

    private String getObjectType(boolean isBudget) {
        return isBudget ? BUDGET_OBJECT : ACTUAL_OBJECT;
    }

    @Override
    public void setOrgUnitObj(boolean isBudget, BizOrgUnit orgUnit) {
        this.setObject(this.getObjectType(isBudget), SysDimensionEnum.Entity.getNumber(), orgUnit.getObject());
    }

    @Override
    public BizOrgUnit getOrgUnitObj(boolean isBudget) {
        return new BizOrgUnit(SysDimensionEnum.Entity.getNumber(), this.getObject(this.getObjectType(isBudget), SysDimensionEnum.Entity.getNumber()));
    }

    @Override
    public void setReqOrgUnitObj(BizOrgUnit reqOrgUnit) {
        this.set("reqOrgUnitObj", reqOrgUnit.getObject());
    }

    @Override
    public BizOrgUnit getReqOrgUnitObj() {
        return new BizOrgUnit(SysDimensionEnum.Entity.getNumber(), this.getDynamicObject("reqOrgUnitObj"));
    }

    @Override
    public void setOrgUnit(boolean isBudget, Member orgUnit) {
        this.setMember(this.getMemberType(isBudget), orgUnit);
    }

    @Override
    public Member getOrgUnit(boolean isBudget) {
        return this.getMember(this.getMemberType(isBudget), SysDimensionEnum.Entity.getNumber());
    }

    public void setReqOrgUnit(Member reqOrgUnit) {
        this.set("reqOrgUnit", reqOrgUnit);
    }

    public Member getReqOrgUnit() {
        return (Member)this.get("reqOrgUnit");
    }

    @Override
    public void setAccountObj(boolean isBudget, DynamicObject account) {
        this.setObject(this.getObjectType(isBudget), SysDimensionEnum.Account.getNumber(), account);
    }

    @Override
    public DynamicObject getAccountObj(boolean isBudget) {
        return this.getObject(this.getObjectType(isBudget), SysDimensionEnum.Account.getNumber());
    }

    @Override
    public void setReqAccountObj(DynamicObject reqAccount) {
        this.set("reqAccountObj", reqAccount);
    }

    @Override
    public DynamicObject getReqAccountObj() {
        return this.getDynamicObject("reqAccountObj");
    }

    @Override
    public void setAccount(boolean isBudget, Member account) {
        this.setMember(this.getMemberType(isBudget), account);
    }

    @Override
    public Member getAccount(boolean isBudget) {
        return this.getMember(this.getMemberType(isBudget), SysDimensionEnum.Account.getNumber());
    }

    @Override
    public List<List<String>> getBgPeriod() {
        List<List<String>> bgPeriod = (List<List<String>>)this.get("bgPeriod");
        if (bgPeriod == null) {
            bgPeriod = BgPeriodUtils.getBgPeriod(this.getBizModel().isEBByModel(), this);
            this.set("bgPeriod", bgPeriod);
        }
        return bgPeriod;
    }

    @Override
    public List<List<String>> getAcPeriod() {
        List<List<String>> acPeriod = (List<List<String>>)this.get("acPeriod");
        if (acPeriod == null) {
            acPeriod = BgPeriodUtils.getAcPeriod(this.getBizModel().isEBByModel(), this);
            this.set("acPeriod", acPeriod);
        }
        return acPeriod;
    }

    @Override
    public Member getYear(boolean isBudget) {
        return this.getMember(this.getMemberType(isBudget), SysDimensionEnum.Year.getNumber());
    }

    @Override
    public String getFullPeriodNumber(boolean isBudget) {
        Member period = this.getPeriod(isBudget);
        if (period == null) {
            return null;
        }
        if (this.getBizModel().isEBByModel()) {
            Member year = this.getMember(isBudget, SysDimensionEnum.Year.getNumber());
            if (year != null) {
                return year.getNumber() + "_" + period.getNumber();
            }
            return null;
        }
        return period.getNumber();
    }

    @Override
    public String getFullPeriodNumberByCalc() {
        return this.isAddup() ? this.getFullPeriodNumber(true) : null;
    }

    @Override
    public String getFullPeriodNumberByAdd(boolean isBudget) {
        String key = "fullPeriodNumberByAdd" + isBudget;
        String fullPeriodNumberByAdd = this.getString(key);
        if (StringUtils.isEmpty((String)fullPeriodNumberByAdd)) {
            fullPeriodNumberByAdd = this.getFullPeriodNumber(isBudget);
            if (this.getBizModel() == null) {
                return this.getFullPeriodNumber(true);
            }
            BgPeriodUserDefinedUtils utils = this.getBizModel().getPeriodUtils();
            BgPeriodHelper.PeriodType periodType = null;
            Member period = this.getPeriod(isBudget);
            if (period != null && (periodType = this.getBizModel().isEBByModel() ? BgPeriodHelper.parseEb((String)period.getNumber()) : BgPeriodHelper.parse((String)period.getNumber())) != null && periodType.getType() != 4) {
                Date bizDate = BgPeriodHelper.periodNumberToDate((String)period.getNumber(), (boolean)this.getBizModel().isEBByModel());
                CalendarHelper calendar = new CalendarHelper(bizDate);
                if (this.getBizModel().isEBByModel()) {
                    Member year = this.getMember(isBudget, SysDimensionEnum.Year.getNumber());
                    if (year != null) {
                        fullPeriodNumberByAdd = year.getNumber() + "_" + BgPeriodUtils.getPeriodMonth((int)calendar.getCurrentlyMonth());
                    }
                } else {
                    fullPeriodNumberByAdd = utils.isPeriodUserDefine() ? utils.getPeriodNumber(BgControlPeriodTypeEnum.MONTH.getIndex(), utils.parseEndBizTime(period.getNumber())) : BgPeriodUtils.getBgPeriodMonth((int)calendar.getCurrentlyYear(), (int)calendar.getCurrentlyMonth());
                }
            }
            this.set(key, fullPeriodNumberByAdd);
        }
        return fullPeriodNumberByAdd;
    }

    @Override
    public void setFullPeriodNumberByAdd(String fullPeriodNumberByAdd) {
        this.set("fullPeriodNumberByAdd", fullPeriodNumberByAdd);
    }

    @Override
    public Member getPeriod(boolean isBudget) {
        Member period = null;
        String type = this.getMemberType(isBudget);
        period = this.getBizModel().isEBByModel() ? this.getMember(type, SysDimensionEnum.Period.getNumber()) : this.getMember(type, SysDimensionEnum.BudgetPeriod.getNumber());
        return period;
    }

    @Override
    public Member getCurrency(boolean isBudget) {
        return this.getMember(this.getMemberType(isBudget), SysDimensionEnum.Currency.getNumber());
    }

    @Override
    public Member getChangeType(boolean isBudget) {
        return this.getMember(this.getMemberType(isBudget), SysDimensionEnum.ChangeType.getNumber());
    }

    @Override
    public Member getScenario(boolean isBudget) {
        return this.getMember(this.getMemberType(isBudget), SysDimensionEnum.Scenario.getNumber());
    }

    @Override
    public Member getVersion(boolean isBudget) {
        return this.getMember(this.getMemberType(isBudget), SysDimensionEnum.Version.getNumber());
    }

    @Override
    public Member getAuditTrail(boolean isBudget) {
        return this.getMember(this.getMemberType(isBudget), SysDimensionEnum.AuditTrail.getNumber());
    }

    @Override
    public Member getMetric(boolean isBudget) {
        return this.getMember(this.getMemberType(isBudget), SysDimensionEnum.Metric.getNumber());
    }

    @Override
    public BigDecimal getRealBudget() {
        if (this.isAddup()) {
            String period = this.getFullPeriodNumberByAdd(true);
            if (period != null) {
                return this.getRealBudget(period);
            }
            return this.getRealBudget(null);
        }
        return this.getRealBudget(null);
    }

    public BigDecimal getRealBudget(String period) {
        BigDecimal budget = null;
        Map<String, BigDecimal> budgets = this.getBudgetValues();
        if (!budgets.isEmpty()) {
            if (this.isDefaultZero()) {
                budget = BigDecimal.ZERO;
            }
            for (Map.Entry<String, BigDecimal> entry : budgets.entrySet()) {
                if (!this.isInAddupPeriod(entry.getKey(), period)) continue;
                if (budget == null) {
                    budget = entry.getValue();
                    continue;
                }
                budget = budget.add(entry.getValue());
            }
        }
        return budget;
    }

    public boolean isInAddupPeriod(BgData bgData, String period) {
        if (bgData == null) {
            return false;
        }
        return this.isInAddupPeriod(bgData.getPeriodKey(this.isEbByModel()), period);
    }

    public boolean isInAddupPeriod(String bgDataPeriod, String period) {
        if (StringUtils.isEmpty((String)period) || !this.isAddup()) {
            return true;
        }
        Set<String> _addUpPeriods = this.getAddUpPeriod(period);
        BgControlLogUtils.info(this.stats, this.isNeedLog(), "budget-control-log :  period = " + period + " bgDataPeriod = " + bgDataPeriod + " _addUpPeriods = " + JSONUtils.toString(_addUpPeriods));
        return _addUpPeriods != null && _addUpPeriods.contains(bgDataPeriod);
    }

    public Set<String> getAddUpPeriod(String period) {
        if (this.addupPeriods.containsKey(period)) {
            return this.addupPeriods.get(period);
        }
        Date date = BgPeriodHelper.periodNumberToDate((String)period, (boolean)this.isEbByModel());
        List<List<String>> bgPeriods = BgPeriodUtils.getPeriod(this.isEbByModel(), this.getSetting(), date, false);
        if (bgPeriods != null) {
            HashSet<String> p = new HashSet<String>();
            for (List<String> periods : bgPeriods) {
                if (this.isEbByModel()) {
                    p.add(periods.get(0) + "_" + periods.get(1));
                    continue;
                }
                p.add(periods.get(1));
            }
            this.addupPeriods.put(period, p);
            return p;
        }
        this.addupPeriods.put(period, null);
        return null;
    }

    @Override
    public BigDecimal getBudget() {
        if (this.isAddup()) {
            String period = this.getFullPeriodNumberByAdd(true);
            if (period != null) {
                return this.getBudget(period);
            }
            return this.getBudget(null);
        }
        return this.getBudget(null);
    }

    @Override
    public BigDecimal getBudget(String period) {
        BigDecimal budget = this.getRealBudget(period);
        if (!this.getExtBgData().isEmpty()) {
            BigDecimal extBudget = this.isDefaultZero() ? BigDecimal.ZERO : null;
            for (BgData data : this.getExtBgData().values()) {
                if (data.isIgnore() || !this.isInAddupPeriod(data, period)) continue;
                if (extBudget == null) {
                    extBudget = data.getValue();
                    continue;
                }
                extBudget = extBudget.add(data.getValue());
            }
            if (extBudget != null) {
                BigDecimal bigDecimal = budget = budget != null ? budget.add(extBudget) : extBudget;
            }
        }
        if (budget != null) {
            budget = budget.multiply(this.getSetting().getCoefficient());
        }
        return budget;
    }

    @Override
    public BigDecimal getBudgetOccupation() {
        return this.getBudgetOccupation(null);
    }

    @Override
    public BigDecimal getBudgetOccupation(String period) {
        BigDecimal budget = null;
        Map<String, BigDecimal> occupationValues = this.getBudgetOccupationValues();
        if (!occupationValues.isEmpty()) {
            budget = BigDecimal.ZERO;
            for (Map.Entry<String, BigDecimal> entry : occupationValues.entrySet()) {
                if (!this.isInAddupPeriod(entry.getKey(), period)) continue;
                budget = budget.add(entry.getValue());
            }
        }
        if (!this.getExtBgOcData().isEmpty()) {
            BigDecimal extBudget = BigDecimal.ZERO;
            for (BgData data : this.getExtBgOcData().values()) {
                if (data.isIgnore() || !this.isInAddupPeriod(data, period)) continue;
                extBudget = extBudget.add(data.getValue());
            }
            budget = budget != null ? budget.add(extBudget) : extBudget;
        }
        return budget;
    }

    @Override
    public BigDecimal getActual() {
        return this.getActual(null);
    }

    public BigDecimal getActual(String period) {
        BigDecimal actual = null;
        BigDecimal occupation = this.getOccupation(period);
        BigDecimal execute = this.getExecute(period);
        BigDecimal actualChanges = this.getActualChanges(period);
        if (occupation != null) {
            actual = BigDecimal.ZERO;
            actual = actual.add(occupation);
        }
        if (execute != null) {
            if (actual == null) {
                actual = BigDecimal.ZERO;
            }
            actual = actual.add(execute);
        }
        if (actualChanges != null) {
            if (actual == null) {
                actual = BigDecimal.ZERO;
            }
            actual = actual.add(actualChanges);
        }
        return actual;
    }

    @Override
    public BigDecimal getOccupation() {
        return this.getOccupation(null);
    }

    @Override
    public BigDecimal getOccupation(String period) {
        BigDecimal occupation = null;
        Map<String, BigDecimal> occupations = this.getActualValues().get("Occupation");
        if (occupations != null && !occupations.isEmpty()) {
            if (this.isDefaultZero()) {
                occupation = BigDecimal.ZERO;
            }
            for (Map.Entry<String, BigDecimal> entry : occupations.entrySet()) {
                if (!this.isInAddupPeriod(entry.getKey(), period)) continue;
                if (occupation == null) {
                    occupation = entry.getValue();
                    continue;
                }
                occupation = occupation.add(entry.getValue());
            }
        }
        if (!this.getExtAcData().isEmpty()) {
            BigDecimal extOccupation = this.isDefaultZero() ? BigDecimal.ZERO : null;
            for (BgData data : this.getExtAcData().values()) {
                String memberNum;
                if (data.isIgnore() || !this.isInAddupPeriod(data, period) || !"Occupation".equals(memberNum = data.getMemberNumber(SysDimensionEnum.ChangeType.getNumber()))) continue;
                if (extOccupation == null) {
                    extOccupation = data.getValue();
                    continue;
                }
                extOccupation = extOccupation.add(data.getValue());
            }
            if (extOccupation != null) {
                occupation = occupation != null ? occupation.add(extOccupation) : extOccupation;
            }
        }
        return occupation;
    }

    @Override
    public BigDecimal getActualChanges() {
        return this.getActualChanges(null);
    }

    @Override
    public BigDecimal getActualChanges(String period) {
        BigDecimal actualChanges = null;
        Map<String, BigDecimal> executes = this.getActualValues().get("ActualChanges");
        if (executes != null && !executes.isEmpty()) {
            if (this.isDefaultZero()) {
                actualChanges = BigDecimal.ZERO;
            }
            for (Map.Entry<String, BigDecimal> entry : executes.entrySet()) {
                if (!this.isInAddupPeriod(entry.getKey(), period)) continue;
                if (actualChanges == null) {
                    actualChanges = entry.getValue();
                    continue;
                }
                actualChanges = actualChanges.add(entry.getValue());
            }
        }
        if (!this.getExtAcData().isEmpty()) {
            BigDecimal extActualChanges = this.isDefaultZero() ? BigDecimal.ZERO : null;
            for (BgData data : this.getExtAcData().values()) {
                String memberNum;
                if (data.isIgnore() || !this.isInAddupPeriod(data, period) || !"ActualChanges".equals(memberNum = data.getMemberNumber(SysDimensionEnum.ChangeType.getNumber()))) continue;
                if (extActualChanges == null) {
                    extActualChanges = data.getValue();
                    continue;
                }
                extActualChanges = extActualChanges.add(data.getValue());
            }
            if (extActualChanges != null) {
                actualChanges = actualChanges != null ? actualChanges.add(extActualChanges) : extActualChanges;
            }
        }
        return actualChanges;
    }

    @Override
    public BigDecimal getExecute() {
        return this.getExecute(null);
    }

    @Override
    public BigDecimal getExecute(String period) {
        BigDecimal execute = null;
        Map<String, BigDecimal> executes = this.getActualValues().get("Execute");
        if (executes != null && !executes.isEmpty()) {
            if (this.isDefaultZero()) {
                execute = BigDecimal.ZERO;
            }
            for (Map.Entry<String, BigDecimal> entry : executes.entrySet()) {
                if (!this.isInAddupPeriod(entry.getKey(), period)) continue;
                if (execute == null) {
                    execute = entry.getValue();
                    continue;
                }
                execute = execute.add(entry.getValue());
            }
        }
        if (!this.getExtAcData().isEmpty()) {
            String memberNum = null;
            BigDecimal extExecute = this.isDefaultZero() ? BigDecimal.ZERO : null;
            for (BgData data : this.getExtAcData().values()) {
                if (data.isIgnore() || !this.isInAddupPeriod(data, period) || !"Execute".equals(memberNum = data.getMemberNumber(SysDimensionEnum.ChangeType.getNumber()))) continue;
                if (extExecute == null) {
                    extExecute = data.getValue();
                    continue;
                }
                extExecute = extExecute.add(data.getValue());
            }
            if (extExecute != null) {
                execute = execute != null ? execute.add(extExecute) : extExecute;
            }
        }
        return execute;
    }

    @Override
    public void setAmount(BigDecimal amount) {
        this.set("amount", amount);
    }

    @Override
    public BigDecimal getAmount() {
        return this.getBigDecimal("amount");
    }

    @Override
    public BigDecimal getExeAmount() {
        return this.getBigDecimal("exeamount");
    }

    @Override
    public void setExeAmount(BigDecimal amount) {
        this.set("exeamount", amount);
    }

    @Override
    public BigDecimal getOccAmount() {
        return this.getBigDecimal("occamount");
    }

    @Override
    public void setOccAmount(BigDecimal amount) {
        this.set("occamount", amount);
    }

    @Override
    public void setBalance(BigDecimal balance) {
        this.set("balance", balance);
    }

    @Override
    public BigDecimal getBalance() {
        return this.getBigDecimal("balance");
    }

    @Override
    public void setLimitBalance(BigDecimal balance) {
        this.set("limitbalance", balance);
    }

    @Override
    public BigDecimal getLimitBalance() {
        return this.getBigDecimal("limitbalance");
    }

    @Override
    public void setAdjustCheckBeyond(boolean flag) {
        this.set("adjustCheckBeyond", flag);
    }

    @Override
    public boolean getAdjustCheckBeyond() {
        return this.getBoolean("adjustCheckBeyond") == null ? false : this.getBoolean("adjustCheckBeyond");
    }

    @Override
    public Map<String, BigDecimal> getBudgetValues() {
        HashMap budgets = (HashMap)this.get("budgets");
        if (budgets == null) {
            budgets = new HashMap();
            this.set("budgets", budgets);
        }
        return budgets;
    }

    @Override
    public Map<String, BigDecimal> getBudgetOccupationValues() {
        HashMap occupation = (HashMap)this.get("budgetOccupation");
        if (occupation == null) {
            occupation = new HashMap();
            this.set("budgetOccupation", occupation);
        }
        return occupation;
    }

    @Override
    public Map<String, Map<String, BigDecimal>> getActualValues() {
        HashMap actuals = (HashMap)this.get("actuals");
        if (actuals == null) {
            actuals = new HashMap();
            this.set("actuals", actuals);
        }
        return actuals;
    }

    @Override
    public void setSetting(BgControlSetting setting) {
        this.set("setting", (Object)setting);
    }

    @Override
    public BgControlSetting getSetting() {
        return (BgControlSetting)((Object)this.get("setting"));
    }

    @Override
    public List<BgControlSetting> getActParentGroupSetting() {
        ArrayList actParentSettings = (ArrayList)this.get("actParentSettings");
        if (actParentSettings == null) {
            actParentSettings = new ArrayList();
            this.set("actParentSettings", actParentSettings);
        }
        return actParentSettings;
    }

    @Override
    public String getMemberKey(boolean hasBudget, Collection<Dimension> dimensions) {
        if (hasBudget) {
            if (this.budgetKey == null) {
                this.budgetKey = BgControlUtils.getMemberKey(this, true, false, false, dimensions);
            }
            return this.budgetKey;
        }
        if (this.actualKey == null) {
            this.actualKey = BgControlUtils.getMemberKey(this, false, false, false, dimensions);
        }
        return this.actualKey;
    }

    @Override
    public String getMemberKey(boolean hasBudget, boolean ignPeriod, Collection<Dimension> dimensions) {
        return BgControlUtils.getMemberKey(this, hasBudget, false, ignPeriod, dimensions);
    }

    @Override
    public String getBgDataKey(Collection<Dimension> dimensions, IControlParam controlParam, Map<Long, Boolean> hasUserDefinedDimensionMap) {
        return BgControlUtils.getMemberKey(this, true, dimensions, BgDataUtils.getIgnDimNumbers(), null, controlParam, new HashMap<Long, Set<String>>(16), new ArrayList<Long>(16), hasUserDefinedDimensionMap);
    }

    @Override
    public String getBgDataKey(Collection<Dimension> dimensions, BgControlSetting setting, IControlParam controlParam, Map<Long, Set<String>> oboMemberMap, List<Long> oboDims, Map<Long, Boolean> hasUserDefinedDimensionMap) {
        return BgControlUtils.getMemberKey(this, true, dimensions, BgDataUtils.getIgnDimNumbers(), setting, controlParam, oboMemberMap, oboDims, hasUserDefinedDimensionMap);
    }

    @Override
    public String getAcDataKey(Collection<Dimension> dimensions, IControlParam controlParam, Map<Long, Boolean> hasUserDefinedDimensionMap) {
        return BgControlUtils.getMemberKey(this, false, dimensions, BgDataUtils.getIgnDimNumbers(), null, controlParam, new HashMap<Long, Set<String>>(16), new ArrayList<Long>(16), hasUserDefinedDimensionMap);
    }

    @Override
    public String getAcDataKey(Collection<Dimension> dimensions, BgControlSetting setting, IControlParam controlParam, Map<Long, Set<String>> oboMemberMap, List<Long> oboDims, Map<Long, Boolean> hasUserDefinedDimensionMap) {
        return BgControlUtils.getMemberKey(this, false, dimensions, BgDataUtils.getIgnDimNumbers(), setting, controlParam, oboMemberMap, oboDims, hasUserDefinedDimensionMap);
    }

    @Override
    public String getCtrlKey() {
        if (this.ctrlKey == null) {
            if (this.getBizModel() == null || this.getBizModel().getDimensions() == null) {
                ControlException.erorrOther((String)"budgetBalance getCtrlKey error. model or dimension is null.");
            }
            this.ctrlKey = BgControlUtils.getCtrlKey(this, false, this.getBizModel().getDimensions(), false);
        }
        return this.ctrlKey;
    }

    @Override
    public String getCtrlKeyByOcc() {
        if (this.ctrlKeyByOcc == null) {
            if (this.getBizModel() == null || this.getBizModel().getDimensions() == null) {
                ControlException.erorrOther((String)"budgetBalance getCtrlKey error. model or dimension is null.");
            }
            this.ctrlKeyByOcc = BgControlUtils.getCtrlKey(this, false, this.getBizModel().getDimensions(), true);
        }
        return this.ctrlKeyByOcc;
    }

    @Override
    public String getAcMemberKey() {
        return this.getMemberKey(false, this.getBizModel().getDimensions());
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap jsonMap = Maps.newLinkedHashMapWithExpectedSize((int)128);
        jsonMap.put("id", this.getBizId());
        jsonMap.put("number", this.getBizNumber());
        jsonMap.put("bizTime", this.getBizTime());
        HashMap<String, Object> modelMap = new HashMap<String, Object>();
        modelMap.put("id", this.getBizModel().getId());
        modelMap.put("number", this.getBizModel().getNumber());
        modelMap.put("name", this.getBizModel().getName());
        if (this.getBizModel() != null) {
            modelMap.put("busmodelid", this.getBizModel().getControlBusModelId());
        }
        jsonMap.put("model", modelMap);
        HashMap<String, Object> memberMap = null;
        Map members = (Map)this.get(this.getMemberType(true));
        for (Member member : members.values()) {
            if (member == null || member.getDimension() == null) continue;
            memberMap = new HashMap<String, Object>();
            memberMap.put("dimension.number", member.getDimension().getNumber());
            memberMap.put("dimension.name", member.getDimension().getName());
            memberMap.put("dimension.prop", this.getProp(member.getDimension().getNumber()));
            boolean bl = this.hasNoneMember(member.getDimension().getNumber());
            memberMap.put("dimension.none", bl);
            memberMap.put("number", member.getNumber());
            memberMap.put("name", member.getName());
            Member member2 = this.getReqMember(member.getDimension().getNumber());
            if (member2 != null) {
                if (bl) {
                    memberMap.put("number", "");
                    memberMap.put("name", "");
                } else {
                    memberMap.put("number", member2.getNumber());
                    memberMap.put("name", member2.getName());
                }
                memberMap.put("bgnumber", member.getNumber());
                memberMap.put("bgname", member.getName());
            }
            jsonMap.put(member.getDimension().getNumber(), memberMap);
        }
        jsonMap.put("budget", this.getBudget());
        for (Map.Entry entry : this.getBudgetValues().entrySet()) {
            jsonMap.put("budget : " + (String)entry.getKey(), entry.getValue());
        }
        jsonMap.put("actual", this.getActual());
        jsonMap.put("occupation", this.getOccupation());
        Map<String, BigDecimal> occupationDetail = this.getOccupationDetail();
        for (Map.Entry<String, BigDecimal> entry : occupationDetail.entrySet()) {
            jsonMap.put("occupation : " + entry.getKey(), entry.getValue());
        }
        jsonMap.put("execute", this.getExecute());
        Map<String, BigDecimal> map = this.getExecuteDetail();
        for (Map.Entry<String, BigDecimal> entry : map.entrySet()) {
            jsonMap.put("execute : " + entry.getKey(), entry.getValue());
        }
        Map<String, BgData> map2 = this.getExtBgData();
        for (Map.Entry<String, BgData> entry : map2.entrySet()) {
            jsonMap.put("extBg : " + entry.getKey(), entry.getValue().getValue());
        }
        for (Map.Entry<String, BgData> entry : this.getExtBgOcData().entrySet()) {
            jsonMap.put("extBg : " + entry.getKey(), entry.getValue().getValue());
        }
        Map<String, BgData> map3 = this.getExtAcData();
        for (Map.Entry<String, BgData> entry : map3.entrySet()) {
            jsonMap.put("extAc : " + entry.getKey(), entry.getValue().getValue());
        }
        Map<String, BigDecimal> map4 = this.getActualValues().get("ActualChanges");
        if (map4 != null && !map4.isEmpty()) {
            for (Map.Entry<String, BigDecimal> entry : map4.entrySet()) {
                jsonMap.put("actualChanges : " + entry.getKey(), entry.getValue());
            }
        }
        Map<String, BigDecimal> map5 = this.getBudgetOccupationValues();
        for (Map.Entry<String, BigDecimal> mapEntry : map5.entrySet()) {
            jsonMap.put("budgetOccupation : " + mapEntry.getKey(), mapEntry.getValue());
        }
        if (this.isAddup()) {
            jsonMap.put("isAddupversion", "1.02");
            jsonMap.put("isAddup", true);
            jsonMap.put("hasActualPeriods", this.getHasActualPeriods());
        }
        jsonMap.put("amount", this.getAmount());
        jsonMap.put("balance", this.getBalance());
        if (this.getSetting() != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("periodclassify", this.getSetting().getPeriodType().getNumber());
            hashMap.put("controltype", this.getSetting().getSettingType().getNumber());
            hashMap.put("coefficient", this.getSetting().getCoefficient());
            hashMap.put("isbeyond", this.getSetting().isBeyond());
            hashMap.put("groupNo", this.getSetting().getGroupNo());
            jsonMap.put("setting", hashMap);
        }
        if (this.getEntrySeq() != null && this.getEntrySeq() != 0) {
            jsonMap.put("entrySeq", this.getEntrySeq());
        }
        return jsonMap;
    }

    private Map<String, BigDecimal> getExecuteDetail() {
        Map<String, BigDecimal> executes = this.getActualValues().get("Execute");
        if (executes != null && !executes.isEmpty()) {
            return executes;
        }
        return new HashMap<String, BigDecimal>();
    }

    private Map<String, BigDecimal> getOccupationDetail() {
        Map<String, BigDecimal> occupations = this.getActualValues().get("Occupation");
        if (occupations != null && !occupations.isEmpty()) {
            return occupations;
        }
        return new HashMap<String, BigDecimal>();
    }

    @Override
    public void setGroupRuleMap(Map<Integer, List<BgControlSetting>> groupRuleMap) {
        this.groupRuleMap = groupRuleMap;
    }

    @Override
    public Map<Integer, List<BgControlSetting>> getGroupRuleMap() {
        return this.groupRuleMap;
    }

    @Override
    public Map<String, BgData> getExtBgData() {
        return this.extBgData;
    }

    @Override
    public Map<String, BgData> getExtBgOcData() {
        return this.extBgOcData;
    }

    @Override
    public Map<String, BgData> getExtAcData() {
        return this.extAcData;
    }

    @Override
    public void setControlScheme(BgControlScheme controlScheme) {
        this.controlScheme = controlScheme;
    }

    @Override
    public BgControlScheme getControlScheme() {
        return this.controlScheme;
    }

    @Override
    public boolean isOnlyCheck() {
        return this.getControlScheme() != null && this.getControlScheme().isOnlyCheck();
    }

    @Override
    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }

    @Override
    public String getEntryId() {
        if (this.entryId == null) {
            return "";
        }
        return this.entryId;
    }

    @Override
    public void setEntrySeq(Integer entrySeq) {
        this.entrySeq = entrySeq;
    }

    @Override
    public Integer getEntrySeq() {
        return this.entrySeq;
    }

    @Override
    public void setReqObj(String dimNumber, String entityNumber, Long id) {
        if (this.reqObj == null) {
            this.reqObj = new JSONObject();
        }
        JSONObject object = new JSONObject();
        object.put("metaType", (Object)entityNumber);
        object.put("id", (Object)id);
        this.reqObj.put(dimNumber, (Object)object);
    }

    @Override
    public JSONObject getReqObj() {
        return this.reqObj;
    }

    @Override
    public void setAdjustCheckFlag(boolean flag) {
        this.set("adjustCheckFlag", flag);
    }

    @Override
    public boolean getAdjustCheckFlag() {
        if (this.getBoolean("adjustCheckFlag") == null) {
            return false;
        }
        return this.getBoolean("adjustCheckFlag");
    }

    @Override
    public void setAdjustCheckBalance(BigDecimal adjustCheckBalance) {
        this.set("adjustCheckBalance", adjustCheckBalance);
    }

    @Override
    public BigDecimal getAdjustCheckBalance() {
        return this.getBigDecimal("adjustCheckBalance") == null ? BigDecimal.ZERO : this.getBigDecimal("adjustCheckBalance");
    }

    @Override
    public void setAdjustCheckBudget(BigDecimal adjustCheckBudget) {
        this.set("adjustCheckBudget", adjustCheckBudget);
    }

    @Override
    public BigDecimal getAdjustCheckBudget() {
        return this.getBigDecimal("adjustCheckBudget") == null ? BigDecimal.ZERO : this.getBigDecimal("adjustCheckBudget");
    }

    @Override
    public BigDecimal getAdjustCheckOccupation() {
        BigDecimal adjustCheckOccupation = null;
        BigDecimal occupation = this.getOccupation();
        BigDecimal budgetOccupation = this.getBudgetOccupation();
        BigDecimal actualChanges = this.getActualChanges();
        if (occupation != null) {
            adjustCheckOccupation = BigDecimal.ZERO;
            adjustCheckOccupation = adjustCheckOccupation.add(occupation);
        }
        if (budgetOccupation != null) {
            if (adjustCheckOccupation == null) {
                adjustCheckOccupation = BigDecimal.ZERO;
            }
            adjustCheckOccupation = adjustCheckOccupation.add(budgetOccupation.negate());
        }
        if (actualChanges != null) {
            if (adjustCheckOccupation == null) {
                adjustCheckOccupation = BigDecimal.ZERO;
            }
            adjustCheckOccupation = adjustCheckOccupation.add(actualChanges);
        }
        return adjustCheckOccupation;
    }

    @Override
    public BigDecimal getAdjustCheckBudgetOccupation() {
        return this.getAdjustCheckBudgetOccupation(null);
    }

    public BigDecimal getAdjustCheckBudgetOccupation(String period) {
        BigDecimal budget = null;
        Map<String, BigDecimal> adjustCheckBudgetOccupationValues = this.getAdjustCheckBudgetOccupationValues();
        if (!adjustCheckBudgetOccupationValues.isEmpty()) {
            budget = BigDecimal.ZERO;
            for (Map.Entry<String, BigDecimal> entry : adjustCheckBudgetOccupationValues.entrySet()) {
                if (!this.isInAddupPeriod(entry.getKey(), period)) continue;
                budget = budget.add(entry.getValue());
            }
        }
        if (!this.getExtAdjustCheckBgOcData().isEmpty()) {
            BigDecimal extAdjustCheckBudget = BigDecimal.ZERO;
            for (BgData data : this.getExtAdjustCheckBgOcData().values()) {
                if (data.isIgnore() || !this.isInAddupPeriod(data, period)) continue;
                extAdjustCheckBudget = extAdjustCheckBudget.add(data.getValue());
            }
            budget = budget != null ? budget.add(extAdjustCheckBudget) : extAdjustCheckBudget;
        }
        return budget;
    }

    @Override
    public Map<String, BigDecimal> getAdjustCheckBudgetOccupationValues() {
        HashMap adjustCheckBudgetOccupation = (HashMap)this.get("adjustcheckbudgetOccupation");
        if (adjustCheckBudgetOccupation == null) {
            adjustCheckBudgetOccupation = new HashMap(16);
            this.set("adjustcheckbudgetOccupation", adjustCheckBudgetOccupation);
        }
        return adjustCheckBudgetOccupation;
    }

    @Override
    public Map<String, BgData> getExtAdjustCheckBgOcData() {
        return this.extAdjustCheckBgOcData;
    }

    @Override
    public void setAddBalance(BigDecimal addBalance) {
        this.set("addBalance", addBalance);
    }

    @Override
    public BigDecimal getAddBalance() {
        return this.getBigDecimal("addBalance");
    }

    @Override
    public boolean isAddup() {
        if (this.getSetting() == null) {
            return false;
        }
        return BgControlSettingTypeEnum.HALFYEAR_ADDUP == this.getSetting().getSettingType() || BgControlSettingTypeEnum.MONTH_ADDUP == this.getSetting().getSettingType() || BgControlSettingTypeEnum.MONTH_HALFYEAR_ADDUP == this.getSetting().getSettingType() || BgControlSettingTypeEnum.MONTH_MODEL_ADDUP == this.getSetting().getSettingType() || BgControlSettingTypeEnum.MONTH_QUARTER_ADDUP == this.getSetting().getSettingType() || BgControlSettingTypeEnum.QUARTER_ADDUP == this.getSetting().getSettingType() || BgControlSettingTypeEnum.QUARTER_HALFYEAR_ADDUP == this.getSetting().getSettingType() || BgControlSettingTypeEnum.QUARTER_MODEL_ADDUP == this.getSetting().getSettingType() || BgControlSettingTypeEnum.YEAR_MODEL_ADDIP == this.getSetting().getSettingType();
    }

    @Override
    public Set<String> getHasActualPeriods() {
        HashSet<String> hasActualPeriods = (HashSet<String>)this.get("hasActualPeriods");
        if (hasActualPeriods == null) {
            hasActualPeriods = new HashSet<String>();
            String period = this.getFullPeriodNumberByAdd(false);
            if (period != null) {
                hasActualPeriods.add(period);
            }
            this.set("hasActualPeriods", hasActualPeriods);
        }
        return hasActualPeriods;
    }

    @Override
    public boolean isEbByModel() {
        return this.getBoolean("isEbByModel") == null ? false : this.getBoolean("isEbByModel");
    }

    @Override
    public void setEbByModel(boolean isEbByModel) {
        this.set("isEbByModel", isEbByModel);
    }

    @Override
    public void setAdjustCheckAmount(BigDecimal adjustCheckAmount) {
        this.set("adjustCheckAmount", adjustCheckAmount);
    }

    @Override
    public BigDecimal getAdjustCheckAmount() {
        return this.getBigDecimal("adjustCheckAmount") == null ? BigDecimal.ZERO : this.getBigDecimal("adjustCheckAmount");
    }

    @Override
    public void setAdjustCheckNoDefaultSetting(boolean adjustCheckNoDefaultSetting) {
        this.set("adjustCheckNoDefaultSetting", adjustCheckNoDefaultSetting);
    }

    @Override
    public boolean getAdjustCheckNoDefaultSetting() {
        if (this.getBoolean("adjustCheckNoDefaultSetting") == null) {
            return false;
        }
        return this.getBoolean("adjustCheckNoDefaultSetting");
    }

    @Override
    public boolean isMonthAddUp() {
        if (this.getSetting() == null) {
            return false;
        }
        BgControlSettingTypeEnum settingType = this.getSetting().getSettingType();
        return BgControlSettingTypeEnum.MONTH_ADDUP == settingType || BgControlSettingTypeEnum.MONTH_HALFYEAR_ADDUP == settingType || BgControlSettingTypeEnum.MONTH_MODEL_ADDUP == settingType || BgControlSettingTypeEnum.MONTH_QUARTER_ADDUP == settingType;
    }

    @Override
    public boolean isCheckPermission() {
        return this.isCheckPermission;
    }

    @Override
    public void setCheckPermission(boolean isCheckPermission) {
        this.isCheckPermission = isCheckPermission;
    }

    @Override
    public boolean isExeMatch() {
        return this.isExeMatch;
    }

    @Override
    public void setExeMatch(boolean isExeMatch) {
        this.isExeMatch = isExeMatch;
    }

    @Override
    public boolean isOccMatch() {
        return this.isOccMatch;
    }

    @Override
    public void setOccMatch(boolean isOccMatch) {
        this.isOccMatch = isOccMatch;
    }

    @Override
    public void setQueryBalanceAndBudOccFlag(boolean queryBalanceAndBudOccFlag) {
        this.set("queryBalanceAndBudOccFlag", queryBalanceAndBudOccFlag);
    }

    @Override
    public boolean getQueryBalanceAndBudOccFlag() {
        if (this.getBoolean("queryBalanceAndBudOccFlag") == null) {
            return false;
        }
        return this.getBoolean("queryBalanceAndBudOccFlag");
    }

    @Override
    public void setAdjustCheckTotalFlag(boolean adjustCheckTotalFlag) {
        this.set("adjustCheckTotalFlag", adjustCheckTotalFlag);
    }

    @Override
    public boolean getAdjustCheckTotalFlag() {
        if (this.getBoolean("adjustCheckTotalFlag") == null) {
            return false;
        }
        return this.getBoolean("adjustCheckTotalFlag");
    }

    @Override
    public void setNeedLog(boolean isNeedLog) {
        this.isNeedLog = isNeedLog;
    }

    @Override
    public boolean isNeedLog() {
        return this.isNeedLog;
    }

    @Override
    public Set<String> getQueryUserDefDims() {
        return this.queryUserDefDims;
    }

    @Override
    public boolean isDefaultZero() {
        return this.isDefaultZero;
    }

    @Override
    public void setDefaultZero(boolean isDefaultZero) {
        this.isDefaultZero = isDefaultZero;
    }
}

