/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.epm.eb.control.face.IControlAmount;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.impl.model.ControlOccRecord;

public class ControlOccValue {
    private BigDecimal occValue = BigDecimal.ZERO;
    private HashMap<String, Map<String, ControlOccRecord>> occRecordMap = new HashMap(10);

    public BigDecimal getOccValue() {
        return this.occValue;
    }

    public void addRecord(IControlAmount amount) {
        this.addRecord(null, amount);
    }

    public void addRecord(ControlOccRecord record, IControlAmount amount) {
        if (amount == null) {
            return;
        }
        this.occValue = this.occValue.add(amount.getOccValue());
        if (record == null) {
            record = (ControlOccRecord)this.occRecordMap.computeIfAbsent(amount.getBgMemberJson(), f -> Maps.newHashMap()).get(amount.getReqKey());
        }
        if (record == null) {
            record = new ControlOccRecord(amount);
            this.occRecordMap.computeIfAbsent(amount.getBgMemberJson(), f -> Maps.newHashMap()).put(amount.getReqKey(), record);
        } else {
            record.addRecord(amount);
        }
    }

    public void occupation(List<ControlOccRecord> occRecords, BigDecimal deductValue, IControlParam param) {
        if (occRecords == null || deductValue == null || BigDecimal.ZERO.compareTo(deductValue) >= 0) {
            return;
        }
        String bgMemberJson = param == null ? "" : param.getBgMemberJson();
        ArrayList firstRecords = Lists.newArrayList();
        for (Map.Entry<String, Map<String, ControlOccRecord>> entry : this.occRecordMap.entrySet()) {
            for (Map.Entry<String, ControlOccRecord> subEntry : entry.getValue().entrySet()) {
                if (entry.getKey().equals(bgMemberJson)) {
                    if (subEntry.getKey().equals(param == null ? "" : param.getReqKey())) {
                        firstRecords.add(subEntry.getValue());
                        continue;
                    }
                    occRecords.add(0, subEntry.getValue());
                    continue;
                }
                occRecords.add(subEntry.getValue());
            }
        }
        for (ControlOccRecord record : firstRecords) {
            occRecords.add(0, record);
        }
        ControlOccRecord record = null;
        Iterator<ControlOccRecord> it = occRecords.iterator();
        while (it.hasNext()) {
            record = it.next();
            if (BigDecimal.ZERO.compareTo(record.getCanOccValue()) >= 0 || BigDecimal.ZERO.compareTo(deductValue) >= 0) {
                it.remove();
                continue;
            }
            if (deductValue.compareTo(record.getCanOccValue()) < 0) {
                record.setOccValue(deductValue);
                deductValue = BigDecimal.ZERO;
                continue;
            }
            deductValue = deductValue.subtract(record.getCanOccValue());
            record.setOccValue(record.getCanOccValue());
        }
    }

    public void negativeOcc(List<ControlOccRecord> occRecords, BigDecimal deductValue) {
        if (occRecords == null || deductValue == null || deductValue.compareTo(BigDecimal.ZERO) >= 0) {
            return;
        }
        for (Map.Entry<String, Map<String, ControlOccRecord>> entry : this.occRecordMap.entrySet()) {
            for (Map.Entry<String, ControlOccRecord> subEntry : entry.getValue().entrySet()) {
                ControlOccRecord r = subEntry.getValue();
                occRecords.add(r);
                r.setOccValue(r.getCanOccValue());
            }
        }
    }
}

