/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.eums.ControlTypeEnum;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.impl.model.BgControlSetting;
import kd.epm.eb.control.impl.model.BudgetBalance;
import kd.epm.eb.control.utils.BalanceCheckUtils;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ControlParam
extends BudgetBalance
implements IControlParam {
    private static final Log log = LogFactory.getLog(ControlParam.class);
    private static final long serialVersionUID = 6188191896411022470L;
    private Long targetSchemeId = null;
    private boolean isFirstPeriod = false;
    private boolean isWriteOffs = false;
    private String budgetKeyTrue = null;
    private String budgetKeyFalse = null;
    private Set<String> parentMemberkeyByBudget = null;
    private String actualKey = null;
    private boolean groupKeyHasUserDimFlag = false;
    private transient String settingOrg = null;
    private String entityNumbr;

    @Override
    protected void setMember(String propertyName, Member member) {
        super.setMember(propertyName, member);
        this.budgetKeyTrue = null;
        this.budgetKeyFalse = null;
        this.actualKey = null;
    }

    @Override
    public void setProps(Map<String, String> props) {
        this.set("props", props);
    }

    @Override
    public Map<String, String> getProps() {
        return (Map)this.get("props");
    }

    @Override
    public void setPropValueMap(Map<String, Object> propValueMap) {
        this.set("propValueMap", propValueMap);
    }

    @Override
    public Map<String, Object> getPropValueMap() {
        return (Map)this.get("propValueMap");
    }

    @Override
    public void setApplyField(String applyField) {
        this.set("applyField", applyField);
    }

    @Override
    public String getApplyField() {
        return this.getString("applyField");
    }

    @Override
    public void setControlType(ControlTypeEnum controlType) {
        this.set("controlType", controlType.getNumber());
    }

    @Override
    public ControlTypeEnum getControlType() {
        return ControlTypeEnum.valueOfNumber(this.getString("controlType"));
    }

    @Override
    public void setAmend(BigDecimal amend) {
        this.set("amend", amend);
    }

    @Override
    public BigDecimal getAmend() {
        return this.getBigDecimal("amend");
    }

    @Override
    public BigDecimal getOccValue() {
        return this.getAmount();
    }

    @Override
    public void setBgMemberJson(String bgMemberJson) {
        this.set("bgMemberJson", bgMemberJson);
    }

    @Override
    public String getBgMemberJson() {
        String json = this.getString("bgMemberJson");
        return json == null ? "" : json;
    }

    @Override
    public void setTargetSchemeId(Long targetSchemeId) {
        this.targetSchemeId = targetSchemeId;
    }

    @Override
    public Long getTargetSchemeId() {
        return this.targetSchemeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calc(Map<String, BigDecimal> mergeAmends, Map<String, BigDecimal> groupAmends, Map<Long, Set<String>> oboMemberStringMap, List<Long> oboDimIds, Set<String> hasOccMemberKeys) {
        this.isFirstPeriod = true;
        String budOccPeriod = null;
        try {
            if (!this.isAddup()) {
                this.calc(mergeAmends, groupAmends, null, oboMemberStringMap, oboDimIds, hasOccMemberKeys);
            } else {
                this.calcHasPeriods(BalanceCheckUtils.calcHasPeriodAmends(this, mergeAmends));
                this.calcHasPeriods(BalanceCheckUtils.calcHasPeriodAmendsGroup(this, groupAmends));
                this.calcHasPeriods();
                for (String period : this.getHasActualPeriods()) {
                    this.calc(mergeAmends, groupAmends, period, oboMemberStringMap, oboDimIds, hasOccMemberKeys);
                    this.isFirstPeriod = false;
                }
            }
        }
        finally {
            this.isFirstPeriod = false;
        }
        budOccPeriod = this.getBizModel().isEBByModel() ? this.getYear(true).getNumber() + "_" + this.getPeriod(true).getNumber() : this.getPeriod(true).getNumber();
        BgControlLogUtils.info(this.stats, true, " calc end getBalance() = " + this.getBalance() + " getMemberKeyByBudget() = " + this.getMemberKeyByBudget() + " budOccPeriod = " + budOccPeriod);
        if (this.getQueryBalanceAndBudOccFlag() && !this.isAddup()) {
            BigDecimal adjustCheckBudgetOccupation = this.getAdjustCheckBudgetOccupation(budOccPeriod);
            if (adjustCheckBudgetOccupation == null) {
                adjustCheckBudgetOccupation = BigDecimal.ZERO;
            }
            this.setBalance(this.getBalance() != null ? this.getBalance().add(adjustCheckBudgetOccupation.negate()) : adjustCheckBudgetOccupation.negate());
            BgControlLogUtils.info(this.stats, true, " QueryBalanceAndBudOcc end getBalance() = " + this.getBalance() + " adjustCheckBudgetOccupation = " + adjustCheckBudgetOccupation + this.getMemberKeyByBudget() + " budOccPeriod = " + budOccPeriod);
        }
    }

    @Override
    public void calcHasPeriods() {
        this.calcHasPeriods(this.getBudgetOccupationValues());
        Map<String, Map<String, BigDecimal>> actualValues = this.getActualValues();
        for (Map<String, BigDecimal> subActualValue : actualValues.values()) {
            this.calcHasPeriods(subActualValue);
        }
        this.calcHasPeriodsExt(this.getExtBgOcData());
        this.calcHasPeriodsExt(this.getExtAcData());
        this.calcHasPeriodsBgData(this.getExtBgData());
        this.calcHasPeriodsBg(this.getBudgetValues());
    }

    private void calcHasPeriodsBg(Map<String, BigDecimal> budgetValues) {
        if (budgetValues == null || budgetValues.isEmpty()) {
            return;
        }
        String periodmember = this.getFullPeriodNumberByAdd(true);
        String period = null;
        for (Map.Entry<String, BigDecimal> entry : budgetValues.entrySet()) {
            period = entry.getKey();
            BigDecimal value = entry.getValue();
            if (value.compareTo(BigDecimal.ZERO) >= 0 || periodmember.compareTo(period) >= 0) continue;
            this.getHasActualPeriods().add(period);
        }
    }

    private void calcHasPeriodsBgData(Map<String, BgData> extBgData) {
        if (extBgData == null || extBgData.isEmpty()) {
            return;
        }
        String periodmember = this.getFullPeriodNumberByAdd(true);
        String period = null;
        BigDecimal value = null;
        for (BgData data : extBgData.values()) {
            if (data.isIgnore()) continue;
            period = data.getPeriodKey(this.getBizModel().isEBByModel());
            value = data.getValue();
            if (value.compareTo(BigDecimal.ZERO) >= 0 || periodmember.compareTo(period) >= 0) continue;
            this.getHasActualPeriods().add(period);
        }
    }

    private void calcHasPeriodsExt(Map<String, BgData> extData) {
        if (extData == null || extData.isEmpty()) {
            return;
        }
        String periodmember = this.getFullPeriodNumberByAdd(false);
        for (BgData data : extData.values()) {
            String period;
            if (data.isIgnore() || periodmember.compareTo(period = data.getPeriodKey(this.getBizModel().isEBByModel())) >= 0 || !this.isContainPeriod(this.getBizModel().isEBByModel(), period).booleanValue()) continue;
            this.getHasActualPeriods().add(period);
        }
    }

    private void calcHasPeriods(Map<String, BigDecimal> periodValues) {
        String periodmember = this.getFullPeriodNumberByAdd(false);
        if (periodValues != null && periodmember != null) {
            for (String period : periodValues.keySet()) {
                if (periodmember.compareTo(period) >= 0 || !this.isContainPeriod(this.getBizModel().isEBByModel(), period).booleanValue()) continue;
                this.getHasActualPeriods().add(period);
            }
        }
    }

    private Boolean isContainPeriod(Boolean isEb, String period) {
        if (isEb.booleanValue()) {
            return this.getAcPeriod().stream().anyMatch(k -> period.equals(String.join((CharSequence)"_", (String)k.get(0), (String)k.get(1))));
        }
        return this.getAcPeriod().stream().anyMatch(k -> period.equals(k.get(1)));
    }

    public boolean isFirstPeriod() {
        return this.isFirstPeriod;
    }

    public void calc(Map<String, BigDecimal> mergeAmends, Map<String, BigDecimal> groupAmends, String period, Map<Long, Set<String>> oboMemberNumberMap, List<Long> oboDimIds, Set<String> hasOccMemberKeys) {
        BigDecimal oldbalance;
        boolean hasOcc;
        BigDecimal budget = this.getBudget(period);
        BigDecimal budgetOccupation = this.getBudgetOccupation(period);
        BigDecimal actual = this.getActual(period);
        if (budget == null && this.isDefaultZero()) {
            budget = BigDecimal.ZERO;
        }
        if (budgetOccupation == null && this.isDefaultZero()) {
            budgetOccupation = BigDecimal.ZERO;
        }
        if (actual == null && this.isDefaultZero()) {
            actual = BigDecimal.ZERO;
        }
        if (this.getAmend() == null) {
            this.setAmend(BigDecimal.ZERO);
        }
        if (this.getAdjustCheckAmend() == null) {
            this.setAdjustCheckAmend(BigDecimal.ZERO);
        }
        if (this.getQueryBalanceAndBudOccFlag() && period != null) {
            BigDecimal adjustCheckBudgetOccupation = this.getAdjustCheckBudgetOccupation(period);
            if (adjustCheckBudgetOccupation == null) {
                adjustCheckBudgetOccupation = BigDecimal.ZERO;
            }
            budgetOccupation = budgetOccupation.subtract(adjustCheckBudgetOccupation);
        }
        BigDecimal _amend = this.getAdjustCheckFlag() ? this.getAdjustCheckAmend() : this.getAmend();
        String dataKey = this.getMemberKeyByBudget();
        boolean bl = hasOcc = hasOccMemberKeys != null && hasOccMemberKeys.contains(dataKey);
        if (mergeAmends != null && mergeAmends.containsKey(dataKey)) {
            _amend = mergeAmends.get(dataKey);
        }
        String periodDimNumber = null;
        periodDimNumber = this.getBizModel().isEBByModel() ? SysDimensionEnum.Period.getNumber() + "_" : SysDimensionEnum.BudgetPeriod.getNumber() + "_";
        if (!this.getAdjustCheckFlag() && this.getPeriod(true) != null) {
            String _dataKey = dataKey.replaceFirst(periodDimNumber + this.getPeriod(true).getNumber(), periodDimNumber + period);
            if (mergeAmends != null && mergeAmends.containsKey(_dataKey)) {
                _amend = mergeAmends.get(_dataKey);
                boolean bl2 = hasOcc = hasOcc || hasOccMemberKeys != null && hasOccMemberKeys.contains(_dataKey);
            }
        }
        if (groupAmends != null && this.getSetting() != null && IDUtils.isNotNull((Long)this.getSetting().getGroupId())) {
            String groupNoKey = this.getGroupKey(this, oboMemberNumberMap, oboDimIds, period);
            if (!groupAmends.containsKey(groupNoKey) && StringUtils.isNotEmpty((String)period)) {
                groupNoKey = this.getGroupKey(this, oboMemberNumberMap, oboDimIds, null);
            }
            if (groupAmends.containsKey(groupNoKey)) {
                _amend = groupAmends.get(groupNoKey);
                boolean bl3 = hasOcc = hasOcc || hasOccMemberKeys != null && hasOccMemberKeys.contains(groupNoKey);
            }
        }
        if (this.getAdjustCheckFlag()) {
            _amend = _amend.negate();
        }
        BigDecimal balance = null;
        BigDecimal limitBalance = null;
        if (budget != null || actual != null || budgetOccupation != null) {
            if (budget == null) {
                budget = BigDecimal.ZERO;
            }
            if (actual == null) {
                actual = BigDecimal.ZERO;
            }
            if (budgetOccupation == null) {
                budgetOccupation = BigDecimal.ZERO;
            }
            balance = budget.subtract(actual).subtract(budgetOccupation.negate());
            limitBalance = budget.subtract(actual).subtract(budgetOccupation.multiply(this.getSetting().getCoefficient()).negate());
        }
        if (this.isDefaultZero() && balance == null) {
            balance = BigDecimal.ZERO;
        }
        if (this.getBalanceCheckPrecision() != null && balance != null) {
            BgControlLogUtils.info(this.stats, true, " before balanceCheckPrecision balance = " + balance);
            balance = balance.setScale((int)this.getBalanceCheckPrecision(), RoundingMode.HALF_UP);
            limitBalance = limitBalance.setScale((int)this.getBalanceCheckPrecision(), RoundingMode.HALF_UP);
            BgControlLogUtils.info(this.stats, true, " after balanceCheckPrecision balance = " + balance);
        }
        if ((oldbalance = this.getBalance()) == null) {
            oldbalance = BigDecimal.ZERO;
        }
        if (this.isFirstPeriod || oldbalance.compareTo(balance == null ? BigDecimal.ZERO : balance) > 0) {
            BigDecimal curBeyondBalance;
            this.setBalance(balance);
            this.setLimitBalance(limitBalance);
            if (balance == null) {
                balance = BigDecimal.ZERO;
            }
            if ((curBeyondBalance = _amend.subtract(balance)).compareTo(this.getBeyondBalanceValue()) > 0) {
                this.setBeyondBalanceValue(curBeyondBalance);
            }
        }
        if (balance == null) {
            balance = BigDecimal.ZERO;
        }
        if (this.isFirstPeriod) {
            this.setBeyondBudget(true);
        }
        if (!this.isCheckNegative(hasOcc) && _amend.compareTo(BigDecimal.ZERO) <= 0 || _amend.compareTo(balance) <= 0) {
            if (this.isFirstPeriod) {
                this.setBeyondBudget(false);
            }
        } else {
            String periodNumber = this.getPeriod(true).getNumber();
            BgControlLogUtils.info(this.stats, true, " setBeyondBudget _amend = " + _amend + " getBalance() = " + this.getBalance() + " balance = " + balance + " period = " + period + " periodNumber = " + periodNumber);
            this.setBeyondBudget(true);
            BigDecimal curBeyondBalance = _amend.subtract(balance);
            if (curBeyondBalance.compareTo(this.getBeyondBalanceValue()) > 0) {
                this.setBeyondBalanceValue(curBeyondBalance);
            }
        }
        if (this.isFirstPeriod) {
            this.setBeyondWarning(false);
        }
        if (this.getSetting() != null && this.getSetting().isBeyond() && _amend.compareTo(this.getBalance() == null ? BigDecimal.ZERO : this.getBalance()) > 0) {
            this.setBeyondWarning(true);
        }
        if (this.getAdjustCheckFlag()) {
            if (this.getAdjustCheckNoDefaultSetting()) {
                this.setAdjustCheckBeyond(false);
            } else {
                BigDecimal allBudget;
                if (this.getAdjustCheckAmount().compareTo(BigDecimal.ZERO) >= 0) {
                    this.setAdjustCheckBeyond(false);
                    return;
                }
                BigDecimal bigDecimal = allBudget = this.getBudget() == null ? BigDecimal.ZERO : this.getBudget();
                if (period != null) {
                    String controlParPeriodNumber = this.getBizModel().isEBByModel() ? this.getYear(true).getNumber() + "_" + this.getPeriod(true).getNumber() : this.getPeriod(true).getNumber();
                    if (period.equals(controlParPeriodNumber)) {
                        this.setAdjustCheckBudget(allBudget.subtract(_amend));
                    }
                } else {
                    this.setAdjustCheckBudget(allBudget.subtract(_amend));
                }
                BgControlLogUtils.info(this.stats, true, " setAdjustCheckBudget _amend = " + _amend + " getBudget() = " + allBudget + " getBudget(period) = " + this.getBudget(period) + " getAdjustCheckBudget() = " + this.getAdjustCheckBudget() + " period = " + period);
                BigDecimal adjustCheckBudgetOccupation = this.getAdjustCheckBudgetOccupation(period);
                if (adjustCheckBudgetOccupation == null) {
                    adjustCheckBudgetOccupation = BigDecimal.ZERO;
                }
                BigDecimal adjustCheckBudget = budget.subtract(_amend);
                BigDecimal adjustCheckBalance = adjustCheckBudget.subtract(actual).subtract(budgetOccupation.negate()).add(adjustCheckBudgetOccupation.negate());
                BgControlLogUtils.info(this.stats, true, " adjustCheckBalanceCalc _amend = " + _amend + " budget = " + budget + " adjustCheckBudget = " + adjustCheckBudget + " actual = " + actual + " budgetOccupation = " + budgetOccupation.negate() + " adjustCheckBudgetOccupation = " + adjustCheckBudgetOccupation.negate() + " adjustCheckBalance = " + adjustCheckBalance + " period = " + period + " dataKey " + dataKey);
                if (this.getBalanceCheckPrecision() != null) {
                    BgControlLogUtils.info(this.stats, true, " before balanceCheckPrecision adjustCheckBalance = " + adjustCheckBalance);
                    adjustCheckBalance = adjustCheckBalance.setScale((int)this.getBalanceCheckPrecision(), RoundingMode.HALF_UP);
                    BgControlLogUtils.info(this.stats, true, " after balanceCheckPrecision adjustCheckBalance = " + adjustCheckBalance);
                }
                if (this.isFirstPeriod || this.getAdjustCheckBalance().compareTo(adjustCheckBalance) > 0) {
                    this.setAdjustCheckBalance(adjustCheckBalance);
                }
                if (this.isFirstPeriod) {
                    this.setAdjustCheckBeyond(true);
                }
                if (adjustCheckBalance.compareTo(BigDecimal.ZERO) >= 0) {
                    if (this.isFirstPeriod) {
                        this.setAdjustCheckBeyond(false);
                    }
                } else {
                    BgControlLogUtils.info(this.stats, true, " setAdjustCheckBeyond _amend = " + _amend + " getAdjustCheckBalance() = " + this.getAdjustCheckBalance() + " adjustCheckBalance = " + adjustCheckBalance + " period = " + period);
                    this.setAdjustCheckBeyond(true);
                }
            }
        }
    }

    @Override
    public void setBeyondBudget(boolean isBeyondBudget) {
        this.set("isBeyondBudget", isBeyondBudget);
    }

    @Override
    public boolean isBeyondBudget() {
        return this.getBoolean("isBeyondBudget");
    }

    @Override
    public void setFreeType(boolean isFreeType) {
        this.set("isFreeType", isFreeType);
    }

    @Override
    public boolean isFreeType() {
        Boolean isFreeType = this.getBoolean("isFreeType");
        return isFreeType != null && isFreeType != false;
    }

    @Override
    public void setBeyondWarning(boolean isBeyondWarning) {
        this.set("isBeyondWarning", isBeyondWarning);
    }

    @Override
    public boolean isBeyondWarning() {
        return this.getBoolean("isBeyondWarning");
    }

    @Override
    public void setWriteOffs(boolean isWriteOffs) {
        this.isWriteOffs = isWriteOffs;
    }

    @Override
    public boolean isWriteOffs() {
        return this.isWriteOffs;
    }

    @Override
    public String getMemberKeyByBudget(boolean ignChangeType) {
        if (ignChangeType) {
            if (this.budgetKeyTrue == null) {
                this.budgetKeyTrue = BgControlUtils.getMemberKey(this, true, ignChangeType, false, this.getBizModel().getDimensions());
            }
            return this.budgetKeyTrue;
        }
        if (this.budgetKeyFalse == null) {
            this.budgetKeyFalse = BgControlUtils.getMemberKey(this, true, ignChangeType, false, this.getBizModel().getDimensions());
        }
        return this.budgetKeyFalse;
    }

    @Override
    public String getMemberKeyByBudget() {
        if (this.budgetKeyFalse == null) {
            this.budgetKeyFalse = BgControlUtils.getMemberKey(this, true, false, false, this.getBizModel().getDimensions());
        }
        return this.budgetKeyFalse;
    }

    @Override
    public Set<String> getParentMemberkeyByBudget(Map<Long, Set<String>> members) {
        if (this.parentMemberkeyByBudget == null) {
            this.parentMemberkeyByBudget = BgControlUtils.getParentMemberKey(this, true, false, false, this.getBizModel().getDimensions(), members);
            this.parentMemberkeyByBudget.remove(this.getMemberKeyByBudget());
        }
        return this.parentMemberkeyByBudget;
    }

    @Override
    public String getMemberKeyByActual() {
        if (this.actualKey == null) {
            String exeKey = SysDimensionEnum.ChangeType.getNumber() + "_" + "Execute";
            String occKey = SysDimensionEnum.ChangeType.getNumber() + "_" + "Occupation";
            this.actualKey = BgControlUtils.getMemberKey(this, false, false, true, this.getBizModel().getDimensions());
            this.actualKey = this.actualKey.replaceAll(exeKey, occKey);
        }
        return this.actualKey;
    }

    @Override
    public String getGroupKey(IControlParam controlParam, Map<Long, Set<String>> oboMemberNumberMap, List<Long> oboDims, String period) {
        return this.getGroupKey(this.getSetting(), controlParam, oboMemberNumberMap, oboDims, period);
    }

    @Override
    public void setGroupKeyHasUserDimFlag(boolean groupKeyHasUserDimFlag) {
        this.groupKeyHasUserDimFlag = groupKeyHasUserDimFlag;
    }

    @Override
    public boolean getGroupKeyHasUserDimFlag() {
        return this.groupKeyHasUserDimFlag;
    }

    @Override
    public String getGroupKey(BgControlSetting setting, IControlParam controlParam, Map<Long, Set<String>> oboMemberNumberMap, List<Long> oboDims, String period) {
        BizModel model = this.getBizModel();
        StringBuilder ctrlGroupKey = new StringBuilder();
        ctrlGroupKey.append(SysDimensionEnum.Entity.getShortNumber()).append('_');
        ctrlGroupKey.append(this.getMember(true, SysDimensionEnum.Entity.getNumber()).getNumber()).append('@');
        if (model.isEBByModel()) {
            ctrlGroupKey.append(SysDimensionEnum.Year.getShortNumber()).append('_');
            ctrlGroupKey.append(StringUtils.isNotEmpty((String)period) ? period.substring(0, 6) : this.getMember(true, SysDimensionEnum.Year.getNumber()).getNumber()).append('@');
            ctrlGroupKey.append(SysDimensionEnum.Period.getShortNumber()).append('_');
            ctrlGroupKey.append(StringUtils.isNotEmpty((String)period) ? period.substring(7) : this.getMember(true, SysDimensionEnum.Period.getNumber()).getNumber());
        } else {
            ctrlGroupKey.append(SysDimensionEnum.BudgetPeriod.getShortNumber()).append('_');
            ctrlGroupKey.append(StringUtils.isNotEmpty((String)period) ? period : this.getMember(true, SysDimensionEnum.BudgetPeriod.getNumber()).getNumber());
        }
        for (Dimension dimension : model.getDimensions()) {
            if (SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())) {
                ctrlGroupKey.append('@').append(SysDimensionEnum.Metric.getShortNumber()).append('_');
                ctrlGroupKey.append(this.getMember(true, SysDimensionEnum.Metric.getNumber()).getNumber());
            }
            if (!SysDimensionEnum.Currency.getNumber().equals(dimension.getNumber())) continue;
            ctrlGroupKey.append('@').append(SysDimensionEnum.Currency.getShortNumber()).append('_');
            ctrlGroupKey.append(this.getMember(true, SysDimensionEnum.Currency.getNumber()).getNumber());
        }
        for (Dimension dimension : model.getDimensions()) {
            String memberNum;
            if (!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) || !StringUtils.isNotEmpty((String)(memberNum = setting.getMemberNumber(model, this.getControlScheme(), dimension, controlParam, oboMemberNumberMap))) || !CollectionUtils.isNotEmpty(oboDims) || !oboDims.contains(dimension.getId())) continue;
            this.groupKeyHasUserDimFlag = true;
            ctrlGroupKey.append('@').append(dimension.getShortNumber()).append('_').append(memberNum);
        }
        ctrlGroupKey.append('@').append(setting.getGroupNo());
        return ctrlGroupKey.toString();
    }

    @Override
    public void setAdjustCheckAmend(BigDecimal adjustCheckAmend) {
        this.set("adjustCheckAmend", adjustCheckAmend);
    }

    @Override
    public BigDecimal getAdjustCheckAmend() {
        return this.getBigDecimal("adjustCheckAmend") == null ? BigDecimal.ZERO : this.getBigDecimal("adjustCheckAmend");
    }

    @Override
    public void setBeyondBalanceValue(BigDecimal beyondBalanceValue) {
        this.set("beyondBalanceValue", beyondBalanceValue);
    }

    @Override
    public BigDecimal getBeyondBalanceValue() {
        return this.getBigDecimal("beyondBalanceValue") == null ? BigDecimal.ZERO : this.getBigDecimal("beyondBalanceValue");
    }

    @Override
    public void setBalanceCheckPrecision(Integer balanceCheckPrecision) {
        this.set("balanceCheckPrecision", balanceCheckPrecision);
    }

    @Override
    public Integer getBalanceCheckPrecision() {
        return (Integer)this.get("balanceCheckPrecision");
    }

    @Override
    public void setBalanceCheckOccupation(boolean isBalanceCheckOccupation) {
        this.set("isBalanceCheckOccupation", isBalanceCheckOccupation);
    }

    @Override
    public boolean isBalanceCheckOccupation() {
        return Boolean.TRUE.equals(this.get("isBalanceCheckOccupation"));
    }

    @Override
    public void setOccupation(boolean isOccupation) {
        this.set("isOccupation", isOccupation);
    }

    @Override
    public boolean isOccupation() {
        return this.isWriteOffs() || Boolean.TRUE.equals(this.getBoolean("isOccupation"));
    }

    @Override
    public boolean isCheckNegative(boolean hasOcc) {
        return this.isBalanceCheckOccupation() && hasOcc;
    }

    @Override
    public String getReqKey() {
        Long reqOrgId = 0L;
        Long reqAccId = 0L;
        Member member = this.getReqMember(SysDimensionEnum.Entity.getNumber());
        if (member != null) {
            reqOrgId = member.getId();
        }
        if ((member = this.getReqMember(SysDimensionEnum.Account.getNumber())) != null) {
            reqAccId = member.getId();
        }
        return reqOrgId + "!" + reqAccId;
    }

    @Override
    public Member getReqAccountOcc() {
        return this.getReqMember(SysDimensionEnum.Account.getNumber());
    }

    @Override
    public Member getReqOrgUnitOcc() {
        return this.getReqMember(SysDimensionEnum.Entity.getNumber());
    }

    @Override
    public void setSettingOrg(String orgNumber) {
        this.settingOrg = orgNumber;
    }

    @Override
    public String getSettingOrg() {
        return this.settingOrg;
    }

    @Override
    public void setEntityNumber(String entityNumber) {
        this.set("entityNumber", entityNumber);
    }

    @Override
    public String getEntityNumber() {
        return (String)this.get("entityNumber");
    }
}

