/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.impl.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.face.IWriteOff;

public class WriteOff
implements IWriteOff {
    private Long id = null;
    private String number = null;
    private Map<String, String[]> billsMap = new HashMap<String, String[]>();
    public static final int WRITE_OFF_BILL = 0;
    public static final int WRITE_OFF_SOURCE_BILL = 1;
    public static final int WRITE_OFF_SOURCE_ENTRY = 2;
    public static final int WRITE_OFF_TYPE = 3;
    public static final String WRITE_OFF_TYPE_OCCUPATION = "occupationwriteoff";
    public static final String WRITE_OFF_TYPE_EXECUTE = "excutewriteoff";
    public static final int WRITE_OFF_SOURCE_VALUE = 4;
    public static final int WRITE_OFF_TARGET_BILL = 5;
    public static final String WRITE_OFF_AMOUNT = "writeoffentry.amount";
    public static final String WRITE_OFF_ENTRYID = "writeoffentry.id";

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setNumber(String number) {
        this.number = number;
    }

    @Override
    public String getNumber() {
        return this.number;
    }

    @Override
    public Map<String, String[]> getBills() {
        return this.billsMap;
    }

    @Override
    public void addWriteOffByBill(DynamicObject entry) {
        if (entry == null) {
            return;
        }
        String[] writeInfo = new String[6];
        writeInfo[0] = entry.getDynamicObject("writeoffbill").getString("number");
        writeInfo[1] = entry.getDynamicObject("writeoffsourcebill").getString("number");
        if (entry.getDynamicObject("writeoffentry") != null) {
            writeInfo[2] = entry.getDynamicObject("writeoffentry").getString("number");
        }
        writeInfo[3] = entry.getString("writeofftype");
        writeInfo[4] = entry.getDynamicObject("writeoffvalue").getString("number");
        writeInfo[5] = entry.getDynamicObject("writeoffsourcebillentry").getString("number");
        this.billsMap.put(writeInfo[0], writeInfo);
    }

    @Override
    public void addWriteOffByBill(String entitynumber) {
        if (StringUtils.isEmpty((String)entitynumber)) {
            return;
        }
        String[] writeInfo = new String[6];
        writeInfo[0] = entitynumber;
        writeInfo[1] = "id";
        writeInfo[3] = WRITE_OFF_TYPE_EXECUTE;
        writeInfo[4] = WRITE_OFF_AMOUNT;
        writeInfo[5] = "";
        this.billsMap.put(writeInfo[0], writeInfo);
    }

    @Override
    public String[] getWriteOffByBill(String entityNumber) {
        return this.billsMap.get(entityNumber);
    }

    public static IWriteOff of(LinkedHashMap<String, List<Map<String, Object>>> writeoffMaps) {
        if (writeoffMaps == null || writeoffMaps.isEmpty()) {
            return null;
        }
        WriteOff _writeOff = new WriteOff();
        _writeOff.setId(0L);
        _writeOff.setNumber("NoStandardWriteOff");
        for (String entityNumber : writeoffMaps.keySet()) {
            _writeOff.addWriteOffByBill(entityNumber);
        }
        return _writeOff;
    }

    public static IWriteOff of(DynamicObject object) {
        if (object == null) {
            return null;
        }
        WriteOff _writeOff = new WriteOff();
        _writeOff.setId(object.getLong("id"));
        _writeOff.setNumber(object.getString("number"));
        for (DynamicObject entry : object.getDynamicObjectCollection("writeoffinfo")) {
            if (!WriteOff.validate(_writeOff, entry)) continue;
            _writeOff.addWriteOffByBill(entry);
        }
        return _writeOff;
    }

    private static boolean validate(IWriteOff writeOff, DynamicObject entry) {
        if (writeOff == null || entry == null) {
            return false;
        }
        DynamicObject entityNumber = entry.getDynamicObject("writeoffbill");
        if (entityNumber == null) {
            ControlException.errorWriteOffEntity((String)writeOff.getNumber());
        }
        if (StringUtils.isEmpty((String)entry.getString("writeofftype"))) {
            ControlException.errorWriteOffType((String)writeOff.getNumber(), (DynamicObject)entityNumber);
        }
        if (entry.getDynamicObject("writeoffvalue") == null) {
            ControlException.errorWriteOffValue((String)writeOff.getNumber(), (DynamicObject)entityNumber);
        }
        return true;
    }
}

