/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.PeriodUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.control.face.IControlAmount;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.utils.BgControlLogUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class BalanceCheckUtils {
    private static final Log log = LogFactory.getLog(BalanceCheckUtils.class);

    public static void calcSumPeriodAmount(LogStats stats, @NotNull Map<String, BigDecimal> mergeAmends, @NotNull Map<String, BigDecimal> parentAmends, @NotNull Map<String, List<IControlParam>> controlParamMap, Map<String, Boolean> isEBByModelMap, @NotNull Set<String> hasOccMemberKeys) {
        String _dataKey;
        String periodNumber;
        List<List<String>> bgPeriods;
        String currPeriodNumber;
        String[] periodKeys;
        IControlParam controlParam;
        List controlParams;
        String dataKey;
        Map periodMap;
        if (mergeAmends.isEmpty() || controlParamMap.isEmpty()) {
            return;
        }
        HashMap memberKeyMap = Maps.newHashMapWithExpectedSize((int)controlParamMap.size());
        HashMap itemPeriodMap = Maps.newHashMapWithExpectedSize((int)controlParamMap.size());
        for (Map.Entry<String, BigDecimal> entry : parentAmends.entrySet()) {
            String dataKey2 = entry.getKey();
            String[] periodKeys2 = memberKeyMap.computeIfAbsent(dataKey2, f -> BalanceCheckUtils.getPeriodKey(dataKey2, Boolean.TRUE.equals(isEBByModelMap.get(dataKey2))));
            periodMap = itemPeriodMap.computeIfAbsent(periodKeys2[0], f -> new TreeMap(String::compareTo));
            periodMap.put(periodKeys2[1], entry.getValue());
        }
        BgControlLogUtils.infoThread(stats, true, () -> "memberKeyMap:" + JSON.toJSONString((Object)memberKeyMap));
        BgControlLogUtils.infoThread(stats, true, () -> "itemPeriodMap:" + JSON.toJSONString((Object)itemPeriodMap));
        HashMap<String, BigDecimal> addMap = new HashMap<String, BigDecimal>(parentAmends.size());
        HashMap<String, List<IControlParam>> _controlParamMap = new HashMap<String, List<IControlParam>>(controlParamMap);
        String periodDimNumber = null;
        for (Map.Entry<String, BigDecimal> entry : mergeAmends.entrySet()) {
            dataKey = entry.getKey();
            controlParams = controlParamMap.get(dataKey);
            if (controlParams == null || controlParams.isEmpty() || (controlParam = controlParams.get(0)).getSetting() == null || controlParam.getSetting().isCurrPeriod() || (periodKeys = (String[])memberKeyMap.get(dataKey)) == null || (periodMap = (Map)itemPeriodMap.get(periodKeys[0])) == null) continue;
            currPeriodNumber = periodKeys[1];
            periodDimNumber = controlParam.getBizModel().isEBByModel() ? SysDimensionEnum.Period.getNumber() + "_" : SysDimensionEnum.BudgetPeriod.getNumber() + "_";
            if (controlParam.isAddup()) {
                controlParam.calcHasPeriods();
            }
            bgPeriods = controlParam.getAcPeriod();
            for (List<String> period : bgPeriods) {
                periodNumber = period.get(1);
                if (!periodMap.containsKey(periodNumber) && (!controlParam.isAddup() || !controlParam.getHasActualPeriods().contains(periodNumber)) || mergeAmends.containsKey(_dataKey = dataKey.replaceFirst(periodDimNumber + currPeriodNumber, periodDimNumber + periodNumber))) continue;
                addMap.put(_dataKey, periodMap.get(periodNumber) == null ? BigDecimal.ZERO : (BigDecimal)periodMap.get(periodNumber));
                _controlParamMap.put(_dataKey, controlParams);
                String[] _periodKeys = memberKeyMap.computeIfAbsent(_dataKey, f -> BalanceCheckUtils.getPeriodKey(_dataKey, Boolean.TRUE.equals(isEBByModelMap.get(_dataKey))));
                periodMap = itemPeriodMap.computeIfAbsent(_periodKeys[0], f -> new TreeMap(String::compareTo));
                periodMap.put(_periodKeys[1], periodMap.get(periodNumber) == null ? BigDecimal.ZERO : (BigDecimal)periodMap.get(periodNumber));
            }
        }
        mergeAmends.putAll(addMap);
        for (Map.Entry<String, BigDecimal> entry : mergeAmends.entrySet()) {
            dataKey = entry.getKey();
            BigDecimal value = entry.getValue();
            controlParams = (List)_controlParamMap.get(dataKey);
            if (controlParams == null || controlParams.isEmpty()) continue;
            controlParam = (IControlParam)controlParams.get(0);
            periodKeys = (String[])memberKeyMap.get(dataKey);
            if (periodKeys == null) {
                periodKeys = BalanceCheckUtils.getPeriodKey(dataKey, Boolean.TRUE.equals(isEBByModelMap.get(dataKey)));
            }
            if (periodKeys == null || (periodMap = (Map)itemPeriodMap.get(periodKeys[0])) == null) continue;
            currPeriodNumber = periodKeys[1];
            if (periodMap.get(currPeriodNumber) != null) {
                value = (BigDecimal)periodMap.get(currPeriodNumber);
            }
            periodDimNumber = controlParam.getBizModel().isEBByModel() ? SysDimensionEnum.Period.getNumber() + "_" : SysDimensionEnum.BudgetPeriod.getNumber() + "_";
            bgPeriods = controlParam.getBgPeriod();
            for (List<String> period : bgPeriods) {
                periodNumber = period.get(1);
                if (!periodMap.containsKey(periodNumber) || periodNumber.equals(currPeriodNumber)) continue;
                _dataKey = dataKey.replaceFirst(periodDimNumber + currPeriodNumber, periodDimNumber + periodNumber);
                if (hasOccMemberKeys != null && hasOccMemberKeys.contains(_dataKey)) {
                    hasOccMemberKeys.add(dataKey);
                }
                if (!controlParam.isAddup()) {
                    value = value.add((BigDecimal)periodMap.get(periodNumber));
                    continue;
                }
                if ((!controlParam.isMonthAddUp() || periodNumber.compareTo(currPeriodNumber) >= 0) && (controlParam.getSetting() == null || controlParam.getSetting().getSettingType() != BgControlSettingTypeEnum.QUARTER_ADDUP || periodNumber.compareTo((String)PeriodUtils.getPeriodListByCurPeriod((String)currPeriodNumber, (String)"quarter", (Boolean)controlParam.getBizModel().isEBByModel()).get(2)) > 0)) continue;
                value = value.add((BigDecimal)periodMap.get(periodNumber));
            }
            entry.setValue(value);
        }
        BgControlLogUtils.infoThread(stats, true, () -> "mergeAmends:" + JSON.toJSONString((Object)mergeAmends));
    }

    private static String[] getPeriodKey(@NotNull String dataKey, boolean isEb) {
        String[] memberKeys = new String[2];
        StringBuilder tmpKeys = new StringBuilder();
        String[] dimKeys = dataKey.split("!");
        String periodStart = isEb ? SysDimensionEnum.Period.getNumber() + "_" : SysDimensionEnum.BudgetPeriod.getNumber() + "_";
        for (String dimKey : dimKeys) {
            if (dimKey.startsWith(periodStart)) {
                memberKeys[1] = dimKey.substring(periodStart.length());
                continue;
            }
            tmpKeys.append(dimKey).append("!");
        }
        memberKeys[0] = tmpKeys.toString();
        return memberKeys;
    }

    public static void calcSumPeriodGroupAmount(LogStats stats, @NotNull Map<String, BigDecimal> groupAmends, @NotNull Map<String, List<IControlParam>> groupParamMap, @NotNull Set<String> hasOccMemberKeys) {
        Map periodMap;
        String groupKey;
        if (groupAmends.isEmpty() || groupParamMap.isEmpty()) {
            return;
        }
        String periodKey = null;
        StringBuilder strKey = new StringBuilder();
        HashMap sunGroupAmends = Maps.newHashMapWithExpectedSize((int)groupAmends.size());
        HashMap sunGroupKeyMap = Maps.newHashMapWithExpectedSize((int)groupAmends.size());
        HashMap<String, Set> subGroupHasOccs = new HashMap<String, Set>(groupAmends.size());
        for (Map.Entry<String, BigDecimal> entry : groupAmends.entrySet()) {
            String[] splitKeys = entry.getKey().split("@");
            strKey.setLength(0);
            for (String _splitKey : splitKeys) {
                String string = SysDimensionEnum.BudgetPeriod.getShortNumber() + "_";
                String ebPeriodPrex = SysDimensionEnum.Period.getShortNumber() + "_";
                if (_splitKey.startsWith(string)) {
                    periodKey = _splitKey.replaceFirst(string, "");
                    continue;
                }
                if (_splitKey.startsWith(ebPeriodPrex)) {
                    periodKey = _splitKey.replaceFirst(ebPeriodPrex, "");
                    continue;
                }
                strKey.append(_splitKey).append("@");
            }
            groupKey = strKey.toString();
            periodMap = sunGroupAmends.computeIfAbsent(groupKey, f -> new TreeMap(String::compareTo));
            periodMap.put(periodKey, entry.getValue());
            sunGroupKeyMap.put(entry.getKey(), groupKey);
            if (!hasOccMemberKeys.contains(entry.getKey())) continue;
            subGroupHasOccs.computeIfAbsent(groupKey, f -> new HashSet(2)).add(periodKey);
        }
        for (Map.Entry<String, BigDecimal> entry : groupAmends.entrySet()) {
            String key = entry.getKey();
            BigDecimal value = entry.getValue();
            groupKey = (String)sunGroupKeyMap.get(key);
            periodMap = (Map)sunGroupAmends.get(groupKey);
            if (periodMap == null) continue;
            List<IControlParam> controlParams = groupParamMap.get(key);
            if (controlParams == null || controlParams.isEmpty()) {
                Optional<String> optional = Arrays.stream(key.split("@")).filter(k -> k.startsWith("BP_") || k.startsWith("P_")).findFirst();
                if (periodMap.isEmpty() || !optional.isPresent()) continue;
                String period = optional.get().replaceFirst("BP_", "").replaceFirst("P_", "");
                for (Map.Entry entry2 : periodMap.entrySet()) {
                    List<IControlParam> ps;
                    if (((String)entry2.getKey()).compareTo(period) >= 0 || (ps = groupParamMap.get(key.replace(period, (CharSequence)entry2.getKey()))) == null || ps.isEmpty() || ps.get(0).getHasActualPeriods() == null || !ps.get(0).getHasActualPeriods().contains(period)) continue;
                    entry.setValue(entry.getValue().add((BigDecimal)entry2.getValue()));
                }
                continue;
            }
            IControlParam controlParam = controlParams.get(0);
            if (controlParam.getSetting() == null || controlParam.getSetting().isCurrPeriod()) continue;
            String currPeriodNumber = controlParam.getBizModel().isEBByModel() ? controlParam.getMember(true, SysDimensionEnum.Period.getNumber()).getNumber() : controlParam.getMember(true, SysDimensionEnum.BudgetPeriod.getNumber()).getNumber();
            if (periodMap.get(currPeriodNumber) != null) {
                value = (BigDecimal)periodMap.get(currPeriodNumber);
            }
            List<List<String>> bgPeriods = controlParam.getBgPeriod();
            for (List list : bgPeriods) {
                String periodNumber = (String)list.get(1);
                if (!periodMap.containsKey(periodNumber) || periodNumber.equals(currPeriodNumber)) continue;
                if (!controlParam.isAddup()) {
                    value = value.add((BigDecimal)periodMap.get(periodNumber));
                    if (subGroupHasOccs.get(groupKey) == null || !((Set)subGroupHasOccs.get(groupKey)).contains(periodNumber)) continue;
                    hasOccMemberKeys.add(entry.getKey());
                    continue;
                }
                if ((!controlParam.isMonthAddUp() || periodNumber.compareTo(currPeriodNumber) >= 0) && (controlParam.getSetting() == null || controlParam.getSetting().getSettingType() != BgControlSettingTypeEnum.QUARTER_ADDUP || periodNumber.compareTo((String)PeriodUtils.getPeriodListByCurPeriod((String)currPeriodNumber, (String)"quarter", (Boolean)controlParam.getBizModel().isEBByModel()).get(2)) > 0)) continue;
                value = value.add((BigDecimal)periodMap.get(periodNumber));
                if (subGroupHasOccs.get(groupKey) == null || !((Set)subGroupHasOccs.get(groupKey)).contains(periodNumber)) continue;
                hasOccMemberKeys.add(entry.getKey());
            }
            entry.setValue(value);
        }
        BgControlLogUtils.infoThread(stats, true, () -> "groupAmends:" + JSON.toJSONString((Object)groupAmends));
    }

    public static Map<String, BigDecimal> calcParentAmount(LogStats stats, @NotNull Map<String, BigDecimal> mergeAmends, @NotNull Map<String, List<IControlAmount>> controlParamMap, @NotNull Map<String, Boolean> isEbModelMap, Map<String, BigDecimal> parentAmends, Map<Long, Set<String>> members, Set<String> hasOccMemberKeys) {
        if (mergeAmends.isEmpty()) {
            return mergeAmends;
        }
        if (parentAmends == null) {
            parentAmends = new HashMap<String, BigDecimal>(mergeAmends);
        }
        if (controlParamMap.isEmpty()) {
            return parentAmends;
        }
        Set subSet = null;
        Member member = null;
        for (List<IControlAmount> params : controlParamMap.values()) {
            if (params == null || params.isEmpty()) continue;
            for (IControlAmount param : params) {
                if (param.getBizModel() == null) continue;
                subSet = members.computeIfAbsent(param.getBizModel().getId(), f -> new HashSet());
                for (Dimension dim : param.getBizModel().getDimensions()) {
                    if (dim == null || (member = param.getMember(true, dim.getNumber())) == null) continue;
                    subSet.add(dim.getNumber() + "_" + member.getNumber());
                }
            }
        }
        String dataKey = null;
        IControlAmount param = null;
        Member accountMember = null;
        Set<String> parentKeys = null;
        boolean isAdd = true;
        boolean isIgn = false;
        for (Map.Entry<String, List<IControlAmount>> entry : controlParamMap.entrySet()) {
            dataKey = entry.getKey();
            if (mergeAmends.get(dataKey) == null || entry.getValue() == null || entry.getValue().isEmpty() || (param = entry.getValue().get(0)).getBizModel() == null) continue;
            isEbModelMap.put(dataKey, param.getBizModel().isEBByModel());
            accountMember = param.getMember(true, SysDimensionEnum.Account.getNumber());
            if (accountMember == null || accountMember.getDimension() == null) continue;
            Long modelId = param.getBizModel().getId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            kd.epm.eb.common.cache.impl.Member dimMember = modelCacheHelper.getMember(accountMember.getDimension().getNumber(), null, accountMember.getNumber());
            kd.epm.eb.common.cache.impl.Member parentMember = null;
            if (dimMember == null || AggOprtEnum.SKIP.getSign().equals(dimMember.getAggType()) || AggOprtEnum.MULTI.getSign().equals(dimMember.getAggType()) || (parentKeys = param.getParentMemberkeyByBudget(members)) == null || parentKeys.isEmpty()) continue;
            for (String parentKey : parentKeys) {
                String[] parentmembers;
                String pAccNumber = null;
                for (String p : parentmembers = parentKey.split("!")) {
                    if (StringUtils.isEmpty((String)p) || !p.startsWith(SysDimensionEnum.Account.getNumber() + "_")) continue;
                    pAccNumber = p.substring(SysDimensionEnum.Account.getNumber().length() + 1);
                }
                if (pAccNumber == null) continue;
                dimMember = modelCacheHelper.getMember(accountMember.getDimension().getNumber(), null, accountMember.getNumber());
                isAdd = true;
                if (dimMember == null) continue;
                while (!(StringUtils.isEmpty((String)dimMember.getParentNumber()) || dimMember.getNumber().equals(dimMember.getParentNumber()) || pAccNumber.equals(dimMember.getNumber()))) {
                    parentMember = modelCacheHelper.getMember(accountMember.getDimension().getNumber(), null, dimMember.getParentNumber());
                    if (dimMember == null || AggOprtEnum.SKIP.getSign().equals(dimMember.getAggType()) || AggOprtEnum.MULTI.getSign().equals(dimMember.getAggType())) {
                        isIgn = true;
                        break;
                    }
                    boolean bl = isAdd = isAdd == AggOprtEnum.ADD.getSign().equals(dimMember.getAggType());
                    if (pAccNumber.equals(dimMember.getNumber())) break;
                    dimMember = parentMember;
                }
                if (isIgn) continue;
                BigDecimal value = parentAmends.get(parentKey);
                if (value == null) {
                    value = BigDecimal.ZERO;
                }
                value = isAdd ? value.add(mergeAmends.get(dataKey)) : value.subtract(mergeAmends.get(dataKey));
                parentAmends.put(parentKey, value);
                if (hasOccMemberKeys != null && hasOccMemberKeys.contains(dataKey)) {
                    hasOccMemberKeys.add(parentKey);
                }
                isEbModelMap.put(parentKey, param.getBizModel().isEBByModel());
            }
        }
        Map<String, BigDecimal> _parentAmends = parentAmends;
        BgControlLogUtils.infoThread(stats, true, () -> "parentAmends:" + JSON.toJSONString((Object)_parentAmends));
        return parentAmends;
    }

    public static Map<String, BigDecimal> calcHasPeriodAmends(IControlParam param, Map<String, BigDecimal> mergeAmends) {
        HashMap<String, BigDecimal> periodValues = new HashMap<String, BigDecimal>();
        if (param == null || param.getBizModel() == null || mergeAmends == null || mergeAmends.isEmpty()) {
            return periodValues;
        }
        String dataKey = param.getMemberKeyByBudget();
        String bizModelId = dataKey.substring(0, dataKey.indexOf("!") + 1);
        String[] periodKeys = BalanceCheckUtils.getPeriodKey(dataKey, param.getBizModel().isEBByModel());
        if (periodKeys == null) {
            return periodValues;
        }
        for (Map.Entry<String, BigDecimal> entry : mergeAmends.entrySet()) {
            String[] _periodKeys;
            if (!entry.getKey().startsWith(bizModelId) || (_periodKeys = BalanceCheckUtils.getPeriodKey(entry.getKey(), param.getBizModel().isEBByModel())) == null || !periodKeys[0].equals(_periodKeys[0])) continue;
            if (param.isEbByModel()) {
                Member year = param.getMember(false, SysDimensionEnum.Year.getNumber());
                if (year == null) continue;
                periodValues.put(year.getNumber() + "_" + _periodKeys[1], entry.getValue());
                continue;
            }
            periodValues.put(_periodKeys[1], entry.getValue());
        }
        return periodValues;
    }

    public static Map<String, BigDecimal> calcHasPeriodAmendsGroup(IControlParam param, Map<String, BigDecimal> groupAmends) {
        HashMap<String, BigDecimal> periodValues = new HashMap<String, BigDecimal>();
        if (param == null || param.getBizModel() == null || groupAmends == null || groupAmends.isEmpty()) {
            return periodValues;
        }
        return periodValues;
    }

    public static void calcSumAdjustCheckPeriodAmount(LogStats stats, @NotNull Map<String, BigDecimal> mergeAdjustCheckAmends, @NotNull Map<String, List<IControlParam>> controlParamMap) {
        Map periodMap;
        if (mergeAdjustCheckAmends.isEmpty() || controlParamMap.isEmpty()) {
            return;
        }
        HashMap memberKeyMap = Maps.newHashMapWithExpectedSize((int)controlParamMap.size());
        HashMap itemPeriodMap = Maps.newHashMapWithExpectedSize((int)controlParamMap.size());
        for (Map.Entry<String, BigDecimal> entry : mergeAdjustCheckAmends.entrySet()) {
            String dataKey = entry.getKey();
            List<IControlParam> controlParams = controlParamMap.get(dataKey);
            if (controlParams.isEmpty()) continue;
            String[] periodKeys = memberKeyMap.computeIfAbsent(dataKey, f -> BalanceCheckUtils.getPeriodKey(dataKey, ((IControlParam)controlParams.get(0)).getBizModel().isEBByModel()));
            periodMap = itemPeriodMap.computeIfAbsent(periodKeys[0], f -> new TreeMap(String::compareTo));
            periodMap.put(periodKeys[1], entry.getValue());
        }
        BgControlLogUtils.infoThread(stats, true, () -> "memberKeyMap:" + JSON.toJSONString((Object)memberKeyMap));
        BgControlLogUtils.infoThread(stats, true, () -> "itemPeriodMap:" + JSON.toJSONString((Object)itemPeriodMap));
        for (Map.Entry<String, BigDecimal> entry : mergeAdjustCheckAmends.entrySet()) {
            String[] periodKeys;
            IControlParam controlParam;
            String dataKey = entry.getKey();
            BigDecimal value = entry.getValue();
            List<IControlParam> controlParams = controlParamMap.get(dataKey);
            if (controlParams.isEmpty() || (controlParam = controlParams.get(0)).getSetting() == null || controlParam.getSetting().isCurrPeriod() || (periodKeys = (String[])memberKeyMap.get(dataKey)) == null || (periodMap = (Map)itemPeriodMap.get(periodKeys[0])) == null) continue;
            String currPeriodNumber = periodKeys[1];
            List<List<String>> bgPeriods = controlParam.getBgPeriod();
            for (List<String> period : bgPeriods) {
                String periodNumber = period.get(1);
                if (!periodMap.containsKey(periodNumber) || periodNumber.equals(currPeriodNumber)) continue;
                if (!controlParam.isAddup()) {
                    value = value.add((BigDecimal)periodMap.get(periodNumber));
                    continue;
                }
                if ((!controlParam.isMonthAddUp() || periodNumber.compareTo(currPeriodNumber) >= 0) && (controlParam.getSetting() == null || controlParam.getSetting().getSettingType() != BgControlSettingTypeEnum.QUARTER_ADDUP || periodNumber.compareTo((String)PeriodUtils.getPeriodListByCurPeriod((String)currPeriodNumber, (String)"quarter", (Boolean)controlParam.getBizModel().isEBByModel()).get(2)) > 0)) continue;
                value = value.add((BigDecimal)periodMap.get(periodNumber));
            }
            entry.setValue(value);
        }
        BgControlLogUtils.infoThread(stats, true, () -> "mergeAdjustCheckAmends:" + JSON.toJSONString((Object)mergeAdjustCheckAmends));
    }

    public static void calcSumAdjustCheckPeriodPeriodGroupAmount(LogStats stats, @NotNull Map<String, BigDecimal> groupAdjustCheckAmends, @NotNull Map<String, List<IControlParam>> groupParamMap) {
        Map periodMap;
        String groupKey;
        if (groupAdjustCheckAmends.isEmpty() || groupParamMap.isEmpty()) {
            return;
        }
        String periodKey = null;
        StringBuilder strKey = new StringBuilder();
        HashMap sunGroupAmends = Maps.newHashMapWithExpectedSize((int)groupAdjustCheckAmends.size());
        HashMap sunGroupKeyMap = Maps.newHashMapWithExpectedSize((int)groupAdjustCheckAmends.size());
        for (Map.Entry<String, BigDecimal> entry : groupAdjustCheckAmends.entrySet()) {
            String[] splitKeys = entry.getKey().split("@");
            strKey.setLength(0);
            for (String _splitKey : splitKeys) {
                String bgmPeriodPrex = SysDimensionEnum.BudgetPeriod.getShortNumber() + "_";
                String ebPeriodPrex = SysDimensionEnum.Period.getShortNumber() + "_";
                if (_splitKey.startsWith(bgmPeriodPrex)) {
                    periodKey = _splitKey.replaceFirst(bgmPeriodPrex, "");
                    continue;
                }
                if (_splitKey.startsWith(ebPeriodPrex)) {
                    periodKey = _splitKey.replaceFirst(ebPeriodPrex, "");
                    continue;
                }
                strKey.append(_splitKey).append("@");
            }
            groupKey = strKey.toString();
            periodMap = sunGroupAmends.computeIfAbsent(groupKey, f -> new TreeMap(String::compareTo));
            periodMap.put(periodKey, entry.getValue());
            sunGroupKeyMap.put(entry.getKey(), groupKey);
        }
        for (Map.Entry<String, BigDecimal> entry : groupAdjustCheckAmends.entrySet()) {
            IControlParam controlParam;
            List<IControlParam> controlParams;
            BigDecimal value = entry.getValue();
            groupKey = (String)sunGroupKeyMap.get(entry.getKey());
            periodMap = (Map)sunGroupAmends.get(groupKey);
            if (periodMap == null || (controlParams = groupParamMap.get(entry.getKey())) == null || controlParams.isEmpty() || (controlParam = controlParams.get(0)).getSetting() == null || controlParam.getSetting().isCurrPeriod()) continue;
            String currPeriodNumber = controlParam.getBizModel().isEBByModel() ? controlParam.getMember(true, SysDimensionEnum.Period.getNumber()).getNumber() : controlParam.getMember(true, SysDimensionEnum.BudgetPeriod.getNumber()).getNumber();
            List<List<String>> bgPeriods = controlParam.getBgPeriod();
            for (List<String> period : bgPeriods) {
                String periodNumber = period.get(1);
                if (!periodMap.containsKey(periodNumber) || periodNumber.equals(currPeriodNumber)) continue;
                if (!controlParam.isAddup()) {
                    value = value.add((BigDecimal)periodMap.get(periodNumber));
                    continue;
                }
                if ((!controlParam.isMonthAddUp() || periodNumber.compareTo(currPeriodNumber) >= 0) && (controlParam.getSetting() == null || controlParam.getSetting().getSettingType() != BgControlSettingTypeEnum.QUARTER_ADDUP || periodNumber.compareTo((String)PeriodUtils.getPeriodListByCurPeriod((String)currPeriodNumber, (String)"quarter", (Boolean)controlParam.getBizModel().isEBByModel()).get(2)) > 0)) continue;
                value = value.add((BigDecimal)periodMap.get(periodNumber));
            }
            entry.setValue(value);
        }
        BgControlLogUtils.infoThread(stats, true, () -> "groupAdjustCheckAmends:" + JSON.toJSONString((Object)groupAdjustCheckAmends));
    }

    public static void handleBalanceCheckControlParam(Collection<IControlParam> controlParams, boolean isRequest) {
        if (CollectionUtils.isEmpty(controlParams)) {
            return;
        }
        Set bizModelIdSet = controlParams.stream().filter(e -> e.getBizModel() != null).map(e -> e.getBizModel().getId()).collect(Collectors.toSet());
        Map checkPrecisionMap = ControlParamsSettingUtil.getBalanceCheckPrecisionByModelSet(bizModelIdSet);
        HashMap<Long, Boolean> checkOccMap = new HashMap<Long, Boolean>(2);
        for (IControlParam controlParam : controlParams) {
            if (controlParam.getBizModel() == null) continue;
            controlParam.setBalanceCheckPrecision((Integer)checkPrecisionMap.get(controlParam.getBizModel().getId()));
            if (!isRequest) continue;
            if (!checkOccMap.containsKey(controlParam.getBizModel().getId())) {
                checkOccMap.put(controlParam.getBizModel().getId(), ControlParamsSettingUtil.isBalanceCheckOccupation((Long)controlParam.getBizModel().getId()));
            }
            controlParam.setBalanceCheckOccupation((Boolean)checkOccMap.get(controlParam.getBizModel().getId()));
        }
    }
}

