/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import java.io.Serializable;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.control.BgControlCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.BgControlPeriodTypeEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CommonShowDetail;
import kd.epm.eb.common.utils.CommonShowDetailEntry;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.control.Centralized;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import kd.epm.eb.control.eums.ControlLogTypeEnum;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.impl.model.BgWhiteList;
import kd.epm.eb.control.impl.model.WriteOffLog;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlParamUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.BgControlWhiteUtils;
import kd.epm.eb.control.utils.BgRegisterUtils;
import kd.epm.eb.control.utils.OQLBuilder;
import org.jetbrains.annotations.NotNull;

public class BgControlLogAddUtils {
    private static final Log log = LogFactory.getLog(BgControlLogAddUtils.class);
    public static final String COL_PROPERTY = "1";
    public static final String COL_PROPERTY_EXT = "2";
    public static final String COL_MEMBER_BUDGET = "3";
    public static final String COL_MEMBER_ACTUAL = "4";
    public static final String COL_MEMBER_MAPPINGNAME = "5";

    public static void addDetailModel(LogStats stats, Collection<BizModel> models) {
        if (!LogStats.isNeedDetailLog((LogStats)stats)) {
            return;
        }
        try {
            EBThreadPoolExecutor.executeOnce(() -> {
                List list = stats.getControllogs();
                synchronized (list) {
                    BgControlLogAddUtils.innerAddDetailModel(stats, models);
                }
            }, (String)"control-addDetailModel");
        }
        catch (Throwable e) {
            log.info("addDetailModel-error{}", (Object)e);
        }
    }

    public static void innerAddDetailModel(LogStats stats, Collection<BizModel> models) {
        if (!LogStats.isNeedDetailLog((LogStats)stats) || models == null || models.isEmpty()) {
            return;
        }
        try {
            String split = ",";
            StringBuilder modelNames = new StringBuilder();
            StringBuilder oneCtrlDims = new StringBuilder();
            StringBuilder controlDimNames = new StringBuilder();
            StringBuilder orgNames = new StringBuilder();
            StringBuilder versionNames = new StringBuilder();
            StringBuilder dataTypeNames = new StringBuilder();
            StringBuilder auditTrailNames = new StringBuilder();
            StringBuilder times = new StringBuilder();
            SimpleDateFormat format = BgControlLogAddUtils.getDateFormatByInternetSet();
            for (BizModel model : models) {
                if (modelNames.length() > 0) {
                    modelNames.append("\r\n");
                    controlDimNames.append("\r\n");
                    orgNames.append("\r\n");
                    versionNames.append("\r\n");
                    dataTypeNames.append("\r\n");
                    auditTrailNames.append("\r\n");
                    times.append("\r\n");
                }
                modelNames.append(BgControlLogAddUtils.getModelName(model));
                oneCtrlDims.setLength(0);
                if (model.getDimensions() == null || model.getDimensions().isEmpty()) {
                    Object dimensions = BgDimensionServiceHelper.getDimensionByModel((BizModel)model, (boolean)false);
                    dimensions = model.filterControlDims((List)dimensions);
                    model.setDimension((List)dimensions);
                }
                for (kd.epm.eb.common.model.Dimension dim : model.getDimensions()) {
                    if (model.getControlDims() != null && !model.getControlDims().contains(dim.getId())) continue;
                    if (oneCtrlDims.length() > 0) {
                        oneCtrlDims.append(split);
                    }
                    oneCtrlDims.append(dim.getName());
                }
                controlDimNames.append(ResManager.loadResFormat((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[]{ResManager.loadKDString((String)"\u63a7\u5236\u7ef4\u5ea6", (String)"ControlLog_ControlDimension", (String)"epm-eb-business", (Object[])new Object[0]), oneCtrlDims.toString()}));
                if (model.getStartVersion() == null) {
                    orgNames.append(ResManager.loadResFormat((String)"\u53d7\u63a7\u5236\u7ec4\u7ec7\uff08\u4e1a\u52a1\u5355\u5143\uff09\uff1a%1\u3002", (String)"ControlLog_VersionOrg", (String)"epm-eb-business", (Object[])new Object[]{BgControlLogAddUtils.getEmptyString()}));
                    versionNames.append(ResManager.loadResFormat((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[]{SysDimensionEnum.Version.getChineseName(), BgControlLogAddUtils.getEmptyString()}));
                } else {
                    QFilter filter = new QFilter("controlversionid", "=", (Object)model.getControlManagerId());
                    ArrayList<String> names = new ArrayList<String>(16);
                    try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryVersionOrg", (String)"eb_controlversionorg", (String)"orgrange.name", (QFilter[])filter.toArray(), null);){
                        while (ds != null && ds.hasNext()) {
                            names.add(ds.next().getString("orgrange.name"));
                        }
                    }
                    orgNames.append(ResManager.loadResFormat((String)"\u53d7\u63a7\u5236\u7ec4\u7ec7\uff08\u4e1a\u52a1\u5355\u5143\uff09\uff1a%1\u3002", (String)"ControlLog_VersionOrg", (String)"epm-eb-business", (Object[])new Object[]{StringUtils.join(names, (String)",")}));
                    versionNames.append(ResManager.loadResFormat((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[]{SysDimensionEnum.Version.getChineseName(), model.getStartVersion().getString("version.name")}));
                }
                String name = BgControlLogAddUtils.getProperty(model, "datatype.name");
                if (StringUtils.isEmpty((String)name)) {
                    dataTypeNames.append(ResManager.loadResFormat((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[]{SysDimensionEnum.DataType.getChineseName(), BgControlLogAddUtils.getEmptyString()}));
                } else {
                    dataTypeNames.append(ResManager.loadResFormat((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[]{SysDimensionEnum.DataType.getChineseName(), name}));
                }
                name = BgControlLogAddUtils.getProperty(model, "audittrail.name");
                if (StringUtils.isEmpty((String)name)) {
                    auditTrailNames.append(ResManager.loadResFormat((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[]{SysDimensionEnum.AuditTrail.getChineseName(), BgControlLogAddUtils.getEmptyString()}));
                } else {
                    auditTrailNames.append(ResManager.loadResFormat((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[]{SysDimensionEnum.AuditTrail.getChineseName(), name}));
                }
                String effectivetime = BgControlLogAddUtils.getTime(model, "effectivetime", format);
                String invalidtime = BgControlLogAddUtils.getTime(model, "invalidtime", format);
                times.append(ResManager.loadResFormat((String)"\u751f\u6548\u65e5\u671f\uff1a%1\uff0c\u5931\u6548\u65e5\u671f\uff1a%2", (String)"ControlLog_VersionTime", (String)"epm-eb-business", (Object[])new Object[]{effectivetime, invalidtime}));
            }
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLDIMSETMODEL, 0, "", modelNames.toString(), null, false, models.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLDIMSETDIM, 0, "", controlDimNames.toString(), null, false, models.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLDIMSETORG, 0, "", orgNames.toString(), null, false, models.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLVERSIONSETMODEL, 0, "", modelNames.toString(), null, false, models.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLVERSIONSETVER, 0, "", versionNames.toString(), null, false, models.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLVERSIONSETTIME, 0, "", times.toString(), null, false, models.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLVERSIONSETDATATYPE, 0, "", dataTypeNames.toString(), null, false, models.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLVERSIONSETAUDITTRAIL, 0, "", auditTrailNames.toString(), null, false, models.size());
        }
        catch (Throwable e) {
            log.info("addDetailMaterule-error:{}", (Object)e);
        }
    }

    private static String getModelName(BizModel model) {
        if (model.isEBByModel() || model.isNewEBByModel() || model.getStartVersion() == null) {
            return ResManager.loadResFormat((String)"\u9884\u7b97\u4f53\u7cfb\uff1a%1\u3002", (String)"ControlLog_NoBusModel", (String)"epm-eb-business", (Object[])new Object[]{model.getName()});
        }
        return ResManager.loadResFormat((String)"\u9884\u7b97\u4f53\u7cfb\uff1a%1\uff1b\u4e1a\u52a1\u6a21\u578b\uff1a%2\u3002", (String)"ControlLog_HasBusModel", (String)"epm-eb-business", (Object[])new Object[]{model.getName(), model.getStartVersion().getString("bussmodel.name")});
    }

    public static String getProperty(BizModel model, String prop) {
        if (model == null || model.getStartVersion() == null) {
            return null;
        }
        return BgControlLogAddUtils.getProperty(model.getStartVersion(), prop);
    }

    public static String getProperty(DynamicObject doj, String prop) {
        if (doj == null || StringUtils.isEmpty((String)prop)) {
            return null;
        }
        try {
            return doj.getString(prop);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Date getTime(DynamicObject doj, String prop) {
        if (doj == null || StringUtils.isEmpty((String)prop)) {
            return null;
        }
        try {
            return doj.getDate(prop);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static String getTime(BizModel model, String field, @NotNull SimpleDateFormat format) {
        Date date = null;
        try {
            if (model != null && model.getStartVersion() != null) {
                date = model.getStartVersion().getDate(field);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return BgControlLogAddUtils.getTimeShow(format, date);
    }

    private static String getTimeShow(@NotNull SimpleDateFormat format, Date date) {
        if (date == null) {
            return BgControlLogAddUtils.getEmptyString();
        }
        return format.format(date);
    }

    public static SimpleDateFormat getDateFormatByInternetSet() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String userFormat = InteServiceHelper.getDateFormat((Long)UserUtils.getUserId());
        if (StringUtils.isEmpty((String)userFormat)) {
            try {
                format.applyPattern(userFormat);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return format;
    }

    public static void addDetailLogs(LogStats stats, boolean isMultiControl, Collection<IControlParam> controlParams, String entityNumber) {
        if (!LogStats.isNeedDetailLog((LogStats)stats)) {
            return;
        }
        try {
            EBThreadPoolExecutor.executeOnce(() -> {
                List list = stats.getControllogs();
                synchronized (list) {
                    BgControlLogAddUtils.innerAddDetailModel(stats, BgControlLogAddUtils.getBizModels(controlParams));
                    BgControlLogAddUtils.innerAddWhiteList(stats, entityNumber);
                    BgControlLogAddUtils.innerAddCentralized(stats, controlParams);
                    Map<Long, DynamicObject> dimmaterMap = BgControlLogAddUtils.innerQueryDimmaterMap(controlParams);
                    BgControlLogAddUtils.innerAddDetailMaterule(stats, isMultiControl, controlParams, dimmaterMap);
                    BgControlLogAddUtils.innerAddControlParams(stats, isMultiControl, controlParams, dimmaterMap);
                }
            }, (String)"control-addDetailMaterule");
        }
        catch (Throwable e) {
            log.info("addDetailMaterule-error{}", (Object)e);
        }
    }

    private static Collection<BizModel> getBizModels(Collection<IControlParam> controlParams) {
        ArrayList<BizModel> bizModels = new ArrayList<BizModel>(2);
        if (controlParams == null || controlParams.isEmpty()) {
            return bizModels;
        }
        bizModels.addAll(BgControlUtils.buildBizModelMap(controlParams).values());
        return bizModels;
    }

    private static void innerAddCentralized(LogStats stats, Collection<IControlParam> controlParams) {
        if (!LogStats.isNeedDetailLog((LogStats)stats) || controlParams == null || controlParams.isEmpty()) {
            return;
        }
        Map<Long, BizModel> bizModelMap = BgControlUtils.buildBizModelMap(controlParams);
        if (bizModelMap == null || bizModelMap.isEmpty()) {
            return;
        }
        CommonShowDetail detail = new CommonShowDetail("");
        CommonShowDetailEntry entry = detail.getEntry("", "");
        entry.addColumn(ControlLogTypeEnum.CENTRALIZEDACCOUNT.getNumber(), ControlLogTypeEnum.CENTRALIZEDACCOUNT.getAlias(), COL_PROPERTY);
        entry.addColumn(ControlLogTypeEnum.CENTRALIZEDMODEL.getNumber(), ControlLogTypeEnum.CENTRALIZEDMODEL.getAlias(), COL_PROPERTY);
        entry.addColumn(ControlLogTypeEnum.CENTRALIZEDRANGE.getNumber(), ControlLogTypeEnum.CENTRALIZEDRANGE.getAlias(), COL_PROPERTY);
        entry.addColumn(ControlLogTypeEnum.CENTRALIZEDORG.getNumber(), ControlLogTypeEnum.CENTRALIZEDORG.getAlias(), COL_PROPERTY);
        Object[] rowDatas = null;
        String empty = BgControlLogAddUtils.getEmptyString();
        ArrayList<String> names = new ArrayList<String>(16);
        Dimension dim = null;
        Object m = null;
        String modelFormat = ResManager.loadKDString((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[0]);
        for (BizModel bizModel : bizModelMap.values()) {
            IModelCacheHelper cache = ModelCacheContext.getOrCreate((Long)bizModel.getId());
            String centKey = BgControlParamUtils.getCentralizedKey(bizModel);
            List centralizeds = BgControlCache.getCentralized((String)centKey);
            if (centralizeds == null || centralizeds.isEmpty()) continue;
            for (Centralized centralized : centralizeds) {
                boolean isFirst = true;
                for (Centralized.CentEntry _entry : centralized.getEntries().values()) {
                    rowDatas = new Object[4];
                    entry.getDatas().add(rowDatas);
                    if (isFirst) {
                        dim = cache.getDimension(SysDimensionEnum.Account.getNumber());
                        rowDatas[0] = BgControlLogAddUtils.buildNames(names, dim, centralized.getAccounts(), cache, bizModel.getControlBusModelId());
                    } else {
                        isFirst = false;
                    }
                    rowDatas[1] = BgControlLogAddUtils.getModelName(bizModel);
                    names.clear();
                    dim = cache.getDimension(SysDimensionEnum.Entity.getNumber());
                    String org = BgControlLogAddUtils.replaceArgs(modelFormat, dim.getName(), BgControlLogAddUtils.buildNames(names, dim, _entry.getOrgRange(), cache, bizModel.getControlBusModelId()));
                    String biz = null;
                    if (!_entry.getBizRange().isEmpty() && StringUtils.isNotEmpty((String)centralized.getDimNumber()) && (dim = cache.getDimension(centralized.getDimNumber())) != null) {
                        biz = BgControlLogAddUtils.replaceArgs(modelFormat, dim.getName(), BgControlLogAddUtils.buildNames(names, dim, _entry.getBizRange(), cache, bizModel.getControlBusModelId()));
                        org = StringUtils.join((Object[])new Object[]{org, biz}, (String)",");
                    }
                    rowDatas[2] = org;
                    rowDatas[3] = _entry.toCentOrgMember().getName();
                }
            }
        }
        if (rowDatas == null) {
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CENTRALIZEDACCOUNT, 0, "", empty, null, false);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CENTRALIZEDMODEL, 0, "", empty, null, false);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CENTRALIZEDRANGE, 0, "", empty, null, false);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CENTRALIZEDORG, 0, "", empty, null, false);
        } else {
            rowDatas = (Object[])entry.getDatas().get(0);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CENTRALIZEDACCOUNT, 0, "", (String)rowDatas[0], detail, true);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CENTRALIZEDMODEL, 0, "", (String)rowDatas[1], null, true);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CENTRALIZEDRANGE, 0, "", (String)rowDatas[2], null, true);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CENTRALIZEDORG, 0, "", (String)rowDatas[3], null, true);
        }
    }

    private static String getEmptyString() {
        return ResManager.loadKDString((String)"\u7a7a", (String)"ControlLog_Null", (String)"epm-eb-business", (Object[])new Object[0]);
    }

    private static String buildNames(List<String> names, Dimension dim, Set<String> numbers, IModelCacheHelper modelCache, Long bussModelId) {
        if (names == null || dim == null || numbers == null || numbers.isEmpty()) {
            return "";
        }
        names.clear();
        for (String number : numbers) {
            kd.epm.eb.common.cache.impl.Member m = modelCache.getMemberByAnyView(bussModelId, dim.getNumber(), number);
            if (m != null) {
                names.add(m.getName());
                continue;
            }
            names.add(number);
        }
        return StringUtils.join(names, (String)",");
    }

    private static void innerAddWhiteList(LogStats stats, String entityNumber) {
        if (!LogStats.isNeedDetailLog((LogStats)stats) || StringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        List<BgWhiteList> whiteLists = BgControlWhiteUtils.queryCacheByWhiteList(entityNumber);
        QFilter filter = new QFilter("number", "=", (Object)entityNumber);
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_structofbill", (String)"name, number", (QFilter[])filter.toArray());
        if (obj == null) {
            log.info("innerAddWhiteList-entity-null:" + entityNumber);
            return;
        }
        String empty = BgControlLogAddUtils.getEmptyString();
        String type = null;
        String extBizType = null;
        String bizNumber = null;
        String orgNumber = null;
        CommonShowDetail detail = null;
        if (whiteLists != null && !whiteLists.isEmpty()) {
            detail = new CommonShowDetail("");
            CommonShowDetailEntry entry = detail.getEntry("", "");
            entry.addColumn(ControlLogTypeEnum.CONTROLWHITELISTTYPE.getNumber(), ControlLogTypeEnum.CONTROLWHITELISTTYPE.getAlias(), COL_PROPERTY);
            entry.addColumn(ControlLogTypeEnum.CONTROLWHITELISTEXT.getNumber(), ControlLogTypeEnum.CONTROLWHITELISTEXT.getAlias(), COL_PROPERTY);
            entry.addColumn(ControlLogTypeEnum.CONTROLWHITELISTBASEDATA.getNumber(), ControlLogTypeEnum.CONTROLWHITELISTBASEDATA.getAlias(), COL_PROPERTY);
            entry.addColumn(ControlLogTypeEnum.CONTROLWHITELISTORG.getNumber(), ControlLogTypeEnum.CONTROLWHITELISTORG.getAlias(), COL_PROPERTY);
            Object[] rowDatas = null;
            HashMap<String, String> bizType = new HashMap<String, String>(10);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBizType", (String)"eb_registmappingbill", (String)"basedatafield,basename", null, null);
            Iterator<BgWhiteList> iterator = null;
            try {
                if (ds != null) {
                    Row row = null;
                    while (ds.hasNext()) {
                        row = ds.next();
                        bizType.put(row.getString("basedatafield"), row.getString("basename"));
                    }
                }
            }
            catch (Throwable row) {
                iterator = row;
                throw row;
            }
            finally {
                if (ds != null) {
                    if (iterator != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)((Object)iterator)).addSuppressed(row);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            boolean isNeedReload = false;
            for (BgWhiteList w : whiteLists) {
                if (w.getCacheVer() >= 1) continue;
                isNeedReload = true;
                break;
            }
            if (isNeedReload) {
                BgControlWhiteUtils.clearCacheByWhiteList(entityNumber);
                whiteLists = BgControlWhiteUtils.queryCacheByWhiteList(entityNumber);
            }
            for (BgWhiteList w : whiteLists) {
                rowDatas = new Object[4];
                rowDatas[0] = w.isBlack() ? ResManager.loadKDString((String)"\u9ed1\u540d\u5355", (String)"WhiteListPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u767d\u540d\u5355", (String)"WhiteListPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                rowDatas[1] = bizType.get(w.getExtBizType());
                if (rowDatas[1] == null) {
                    rowDatas[1] = w.getExtBizType();
                }
                if (rowDatas[1] == null) {
                    rowDatas[1] = empty;
                }
                rowDatas[2] = StringUtils.join(w.getWhitelist(), (String)",");
                Object object = rowDatas[3] = w.getBizOrgIds() == null || w.getBizOrgIds().isEmpty() ? empty : StringUtils.join(w.getBizOrgIds(), (String)",");
                if (type == null) {
                    type = (String)rowDatas[0];
                    extBizType = (String)rowDatas[1];
                    bizNumber = (String)rowDatas[2];
                    orgNumber = (String)rowDatas[3];
                }
                entry.getDatas().add(rowDatas);
            }
        }
        if (type == null) {
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLWHITELISTBILL, 0, "", obj.getString("name"), null, false);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLWHITELISTTYPE, 0, "", empty, null, false);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLWHITELISTEXT, 0, "", empty, null, false);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLWHITELISTBASEDATA, 0, "", empty, null, false);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLWHITELISTORG, 0, "", empty, null, false);
        } else {
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLWHITELISTBILL, 0, "", obj.getString("name"), detail, false);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLWHITELISTTYPE, 0, "", type, null, true);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLWHITELISTEXT, 0, "", extBizType, null, true);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLWHITELISTBASEDATA, 0, "", bizNumber, null, true);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLWHITELISTORG, 0, "", orgNumber, null, true);
        }
    }

    private static Map<Long, DynamicObject> innerQueryDimmaterMap(Collection<IControlParam> controlParams) {
        QFilter filter;
        DynamicObjectCollection materules;
        LinkedHashMap<Long, DynamicObject> dimmaterMap = new LinkedHashMap<Long, DynamicObject>(10);
        LinkedHashMap<Long, DynamicObject> noSortMap = new LinkedHashMap<Long, DynamicObject>(10);
        if (controlParams == null || controlParams.isEmpty()) {
            return dimmaterMap;
        }
        LinkedHashSet<Long> detailIds = new LinkedHashSet<Long>(10);
        for (IControlParam param : controlParams) {
            if (param.getControlScheme() == null) continue;
            detailIds.add(param.getControlScheme().getDetailId());
        }
        if (!detailIds.isEmpty() && (materules = QueryServiceHelper.query((String)"eb_adddimmaterule", (String)"id,number,name,bill.number,cardentity,cardentity.title,cardentity.effectivetime,cardentity.invalidtime,cardentity.serqfilter,cardentity.metricfield.name", (QFilter[])(filter = new QFilter("cardentity", "in", detailIds)).toArray())) != null) {
            for (DynamicObject obj : materules) {
                noSortMap.put(obj.getLong("cardentity"), obj);
            }
            for (Long id : detailIds) {
                if (!noSortMap.containsKey(id)) continue;
                dimmaterMap.put(id, (DynamicObject)noSortMap.get(id));
            }
        }
        return dimmaterMap;
    }

    private static void innerAddControlParams(LogStats stats, boolean isMultiControl, Collection<IControlParam> controlParams, Map<Long, DynamicObject> dimmaterMap) {
        if (!LogStats.isNeedDetailLog((LogStats)stats) || controlParams == null || controlParams.isEmpty() || dimmaterMap == null || dimmaterMap.isEmpty()) {
            return;
        }
        try {
            Serializable dateeffectivetime;
            String dimmatershow = ResManager.loadKDString((String)"\u7ef4\u5ea6\u5339\u914d\u89c4\u5219", (String)"ControlLog_DimMater", (String)"epm-eb-business", (Object[])new Object[0]);
            log.info("begin-innerAddControlParams");
            LinkedHashMap<String, CommonShowDetail> logMap = new LinkedHashMap<String, CommonShowDetail>(10);
            CommonShowDetail controlrulelog = new CommonShowDetail(dimmatershow);
            HashMap<Long, Dimension> entityDimCache = new HashMap<Long, Dimension>(2);
            String entityName = null;
            String accountName = null;
            StringBuilder userDefine = new StringBuilder();
            Object[] noGroupData = null;
            Object[] groupData = null;
            Object[] defaultData = null;
            Format nformat = BgControlUtils.getDecimalFormatByInternetSet();
            String yes = ResManager.loadKDString((String)"\u662f", (String)"ControlLog_Yes", (String)"epm-eb-business", (Object[])new Object[0]);
            String no = ResManager.loadKDString((String)"\u5426", (String)"ControlLog_No", (String)"epm-eb-business", (Object[])new Object[0]);
            String split = ",";
            String modelFormat = ResManager.loadKDString((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[0]);
            CommonShowDetail logDetail = null;
            DynamicObject dimmater = null;
            String entitynumber = null;
            String key = null;
            String alias = null;
            String field = null;
            String extfield = null;
            String extAlias = null;
            String budgetNumber = null;
            String actualNumber = null;
            CommonShowDetailEntry entry = null;
            HashSet<String> hasNoEquals = new HashSet<String>(10);
            Object[] rowDatas = null;
            CommonShowDetailEntry.Column column = null;
            Member member = null;
            HashSet<Long> mappingIds = new HashSet<Long>(10);
            SimpleDateFormat format = BgControlLogAddUtils.getDateFormatByInternetSet();
            String empty = BgControlLogAddUtils.getEmptyString();
            for (IControlParam param : controlParams) {
                if (param.getControlScheme() == null) {
                    log.info("innerAddControlParams-controlscheme-null");
                    continue;
                }
                if (param.getBizModel() == null) {
                    log.info("innerAddControlParams-getBizModel-null");
                    continue;
                }
                dimmater = dimmaterMap.get(param.getControlScheme().getDetailId());
                if (dimmater == null) {
                    log.info("innerAddControlParams-dimmater-null " + param.getControlScheme().getDetailId());
                    continue;
                }
                entitynumber = dimmater.getString("bill.number");
                key = String.valueOf(dimmater.getLong("cardentity"));
                alias = dimmater.getString("name") + "-" + dimmater.getString("cardentity.title");
                for (kd.epm.eb.common.model.Dimension dimension : param.getBizModel().getDimensions()) {
                    if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.Currency.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber()) || BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension)) {
                        String dimkey = BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension) ? dimension.getName() : dimension.getNumber();
                        logDetail = logMap.computeIfAbsent(dimkey, f -> new CommonShowDetail(dimmatershow));
                        entry = logDetail.getEntry(key, alias);
                        if (entry.getColumns().isEmpty()) {
                            field = null;
                            extfield = null;
                            if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                                field = param.getControlScheme().getOrgUnitFields();
                                extfield = param.getControlScheme().getOrgUnitExtFields();
                            } else if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
                                field = param.getControlScheme().getAccountFields();
                                extfield = param.getControlScheme().getAccountExtFields();
                            } else if (SysDimensionEnum.Currency.getNumber().equals(dimension.getNumber())) {
                                field = param.getControlScheme().getCurrencyFields();
                                extfield = param.getControlScheme().getCurrencyExtFields();
                            } else if (SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber())) {
                                field = param.getControlScheme().getChangeTypeField();
                                extfield = param.getControlScheme().getChangeTypeExtField();
                            } else if (BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension)) {
                                field = param.getControlScheme().getUserDefendPropMap().get(BgControlScheme.getUserDefendKey(dimension));
                                extfield = param.getControlScheme().getUserDefendExt(dimension);
                            }
                            if (StringUtils.isNotEmpty((String)field)) {
                                entry.addColumn(field, BgControlLogUtils.getBizRegName(entitynumber, field, null), COL_PROPERTY);
                                if (StringUtils.isNotEmpty((String)extfield)) {
                                    entry.addColumn(field, BgControlLogUtils.getBizRegName(entitynumber, extfield, null), COL_PROPERTY);
                                }
                                entry.addColumn(dimension.getNumber() + "." + COL_MEMBER_BUDGET, dimension.getName(), COL_MEMBER_BUDGET);
                                entry.addColumn(dimension.getNumber() + "." + COL_MEMBER_ACTUAL, dimension.getName(), COL_MEMBER_ACTUAL);
                                entry.addColumn("eb_dimmembermapping", ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u6620\u5c04", (String)"ControlLog_Mapping", (String)"epm-eb-business", (Object[])new Object[0]), COL_MEMBER_MAPPINGNAME);
                                entry.getNullNoShowMsgColumnKey().add("eb_dimmembermapping");
                                entry.getHideColumnKey().add(dimension.getNumber() + "." + COL_MEMBER_ACTUAL);
                                if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                                    column = entry.addColumn("ControlLog_ControlParam", ResManager.loadKDString((String)"\u63a7\u5236\u53c2\u6570", (String)"ControlLog_ControlParam", (String)"epm-eb-business", (Object[])new Object[0]), COL_PROPERTY);
                                    entry.getNoShowMsgColumnKey().add("ControlLog_ControlParam");
                                    column.setMaxShowLength(300);
                                }
                            } else {
                                log.info("innerAddControlParams-field-null:" + dimension.getNumber());
                                continue;
                            }
                        }
                        rowDatas = new Object[entry.getColumns().size()];
                        entry.getDatas().add(rowDatas);
                        budgetNumber = null;
                        actualNumber = null;
                        for (int i = 0; i < entry.getColumns().size(); ++i) {
                            String mappingId;
                            column = (CommonShowDetailEntry.Column)entry.getColumns().get(i);
                            if ("ControlLog_ControlParam".equals(column.getColumnKey())) {
                                rowDatas[i] = JSONUtils.toString(param.toMap());
                                continue;
                            }
                            if (COL_PROPERTY.equals(column.getColumnType())) {
                                rowDatas[i] = BgControlParamUtils.getReqAlias(param, dimension);
                                if (!BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension) || rowDatas[i] != null) continue;
                                rowDatas[i] = empty;
                                continue;
                            }
                            if (COL_PROPERTY_EXT.equals(column.getColumnType())) {
                                extAlias = OQLBuilder.getAliasProp(extfield);
                                rowDatas[i] = Convert.toStr((Object)param.getPropValueMap().get(extAlias));
                                continue;
                            }
                            if (COL_MEMBER_BUDGET.equals(column.getColumnType())) {
                                member = param.getMember(true, dimension.getNumber());
                                if (member == null) continue;
                                rowDatas[i] = member.getName();
                                budgetNumber = member.getNumber();
                                continue;
                            }
                            if (COL_MEMBER_ACTUAL.equals(column.getColumnType())) {
                                member = param.getMember(false, dimension.getNumber());
                                if (member == null) continue;
                                rowDatas[i] = member.getName();
                                actualNumber = member.getNumber();
                                continue;
                            }
                            if (!COL_MEMBER_MAPPINGNAME.equals(column.getColumnType()) || param.getMappingData(dimension.getNumber()) == null || StringUtils.isEmpty((String)(mappingId = param.getMappingData(dimension.getNumber()).get("mpId")))) continue;
                            rowDatas[i] = mappingId;
                            mappingIds.add(IDUtils.toLong((Object)mappingId));
                        }
                        if (budgetNumber != null && !StringUtils.equals(budgetNumber, actualNumber)) {
                            hasNoEquals.add(dimension.getNumber() + "_" + key);
                            entry.getHideColumnKey().remove(dimension.getNumber() + "." + COL_MEMBER_ACTUAL);
                        }
                    } else if (SysDimensionEnum.Period.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) {
                        logDetail = logMap.computeIfAbsent(SysDimensionEnum.BudgetPeriod.getNumber(), f -> new CommonShowDetail(dimmatershow));
                        entry = logDetail.getEntry(key, alias);
                        if (entry.getColumns().isEmpty()) {
                            entry.addColumn(SysDimensionEnum.BudgetPeriod.getNumber(), BgControlLogUtils.getBizRegName(entitynumber, param.getControlScheme().getPeriodFields(), null), COL_PROPERTY);
                            entry.addColumn(SysDimensionEnum.BudgetPeriod.getNumber() + COL_PROPERTY, dimension.getName(), COL_MEMBER_BUDGET);
                        }
                        entry.getDatas().add(new Object[]{format.format(param.getBizTime()), param.getPeriod(true) == null ? empty : param.getPeriod(true).getName()});
                    } else if (SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())) {
                        // empty if block
                    }
                    userDefine.setLength(0);
                    if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                        entityName = param.getMember(true, SysDimensionEnum.Entity.getNumber()).getName();
                        continue;
                    }
                    if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
                        accountName = param.getMember(true, SysDimensionEnum.Account.getNumber()).getName();
                        continue;
                    }
                    if (!BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension) || param.getMember(true, dimension.getNumber()) == null) continue;
                    if (userDefine.length() > 0) {
                        userDefine.append(split);
                    }
                    userDefine.append(dimension.getName()).append("_").append(param.getMember(true, dimension.getNumber()).getName());
                }
                if (param.getSetting() != null) {
                    Long dimid;
                    entry = controlrulelog.getEntry(key, alias);
                    if (entry.getColumns().isEmpty()) {
                        entry.addColumn(SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Entity.getChineseName(), COL_PROPERTY);
                        entry.addColumn(SysDimensionEnum.Account.getNumber(), SysDimensionEnum.Account.getChineseName(), COL_PROPERTY);
                        entry.addColumn("userdefined", ResManager.loadKDString((String)"\u8f85\u52a9\u7ef4\u5ea6", (String)"ControlLog_UserDefined", (String)"epm-eb-business", (Object[])new Object[0]), COL_PROPERTY);
                        entry.getHideColumnKey().add("userdefined");
                        entry.addColumn(ControlLogTypeEnum.CONTROLRULEGROUPTYPE.getNumber(), ControlLogTypeEnum.CONTROLRULEGROUPTYPE.getAlias(), COL_PROPERTY);
                        entry.addColumn(ControlLogTypeEnum.CONTROLRULEGROUPCOEFFICIENT.getNumber(), ControlLogTypeEnum.CONTROLRULEGROUPCOEFFICIENT.getAlias(), COL_PROPERTY);
                        entry.addColumn(ControlLogTypeEnum.CONTROLRULEGROUPBEYOND.getNumber(), ControlLogTypeEnum.CONTROLRULEGROUPBEYOND.getAlias(), COL_PROPERTY);
                        entry.addColumn(ControlLogTypeEnum.CONTROLRULEGROUPORG.getNumber(), ControlLogTypeEnum.CONTROLRULEGROUPORG.getAlias(), COL_PROPERTY);
                        entry.addColumn(ControlLogTypeEnum.CONTROLRULEGROUPTIME.getNumber(), ControlLogTypeEnum.CONTROLRULEGROUPTIME.getAlias(), COL_PROPERTY);
                        entry.addColumn(ControlLogTypeEnum.P_CONTROLRELEDEFAULT.getNumber(), ResManager.loadKDString((String)"\u9ed8\u8ba4\u63a7\u5236\u65b9\u5f0f", (String)"ControlLog_DefaultRule", (String)"epm-eb-business", (Object[])new Object[0]), COL_PROPERTY);
                        entry.addColumn(ControlLogTypeEnum.CONTROLRULESETACCOUNT.getNumber(), ControlLogTypeEnum.CONTROLRULESETACCOUNT.getAlias(), COL_PROPERTY);
                        entry.addColumn(ControlLogTypeEnum.CONTROLRULESETUSERDEFINE.getNumber(), ControlLogTypeEnum.CONTROLRULESETUSERDEFINE.getAlias(), COL_PROPERTY);
                        entry.getHideColumnKey().add(ControlLogTypeEnum.CONTROLRULESETACCOUNT.getNumber());
                        entry.getHideColumnKey().add(ControlLogTypeEnum.CONTROLRULESETUSERDEFINE.getNumber());
                        entry.addColumn(ControlLogTypeEnum.CONTROLRULEGROUPADD.getNumber(), ControlLogTypeEnum.CONTROLRULEGROUPADD.getAlias(), COL_PROPERTY);
                        entry.addColumn(ControlLogTypeEnum.CONTROLRULEGROUPOBO.getNumber(), ControlLogTypeEnum.CONTROLRULEGROUPOBO.getAlias(), COL_PROPERTY);
                        entry.addColumn(ControlLogTypeEnum.CONTROLRULEGROUPMEMBER.getNumber(), ControlLogTypeEnum.CONTROLRULEGROUPMEMBER.getAlias(), COL_PROPERTY);
                        entry.getHideColumnKey().add(ControlLogTypeEnum.CONTROLRULEGROUPADD.getNumber());
                        entry.getHideColumnKey().add(ControlLogTypeEnum.CONTROLRULEGROUPOBO.getNumber());
                        entry.getHideColumnKey().add(ControlLogTypeEnum.CONTROLRULEGROUPMEMBER.getNumber());
                    }
                    rowDatas = new Object[14];
                    entry.getDatas().add(rowDatas);
                    rowDatas[0] = entityName;
                    rowDatas[1] = accountName;
                    rowDatas[2] = userDefine.toString();
                    if (userDefine.length() > 0) {
                        entry.getHideColumnKey().remove("userdefined");
                    }
                    rowDatas[3] = ResManager.loadResFormat((String)"\u660e\u7ec6\u671f\u95f4\u5206\u7c7b\uff1a%1\uff1b\u63a7\u5236\u65b9\u5f0f\uff1a%2\u3002", (String)"ControlLog_ControlType", (String)"epm-eb-business", (Object[])new Object[]{param.getSetting().getPeriodType().getName(), param.getSetting().getSettingType().getName()});
                    rowDatas[4] = nformat.format(param.getSetting().getCoefficient());
                    rowDatas[5] = param.getSetting().isBeyond() ? yes : no;
                    Dimension dimensionCache = entityDimCache.computeIfAbsent(param.getBizModel().getId(), f -> ModelCacheContext.getOrCreate((Long)param.getBizModel().getId()).getDimension(SysDimensionEnum.Entity.getNumber()));
                    Object object = rowDatas[6] = StringUtils.isEmpty((String)param.getSettingOrg()) ? "" : ModelCacheContext.getOrCreate((Long)param.getBizModel().getId()).getMemberByAnyView(param.getBizModel().getControlBusModelId(), dimensionCache.getNumber(), param.getSettingOrg()).getName();
                    if (param.getSetting().isDefault()) {
                        rowDatas[7] = empty;
                        rowDatas[8] = yes;
                        if (defaultData != null) continue;
                        defaultData = rowDatas;
                        continue;
                    }
                    rowDatas[8] = no;
                    dateeffectivetime = BgControlLogAddUtils.getTime(param.getSetting().getObject().getDynamicObject("mainRuleField"), "effectivedate");
                    Date dateinvalidtime = BgControlLogAddUtils.getTime(param.getSetting().getObject(), "invaliddate");
                    if (dateeffectivetime == null && dateinvalidtime == null) {
                        rowDatas[7] = empty;
                    } else {
                        String effectivetime = BgControlLogAddUtils.getTimeShow(format, (Date)dateeffectivetime);
                        String invalidtime = BgControlLogAddUtils.getTimeShow(format, dateinvalidtime);
                        rowDatas[7] = ResManager.loadResFormat((String)"\u751f\u6548\u65e5\u671f\uff1a%1\uff0c\u5931\u6548\u65e5\u671f\uff1a%2", (String)"ControlLog_VersionTime", (String)"epm-eb-business", (Object[])new Object[]{effectivetime, invalidtime});
                    }
                    if (IDUtils.isNotNull((Long)param.getSetting().getGroupId())) {
                        if (groupData == null) {
                            groupData = rowDatas;
                        }
                        rowDatas[11] = param.getSetting().getGroupName();
                        userDefine.setLength(0);
                        if (!param.getSetting().getOboDimIds().isEmpty()) {
                            for (Long dimid2 : param.getSetting().getOboDimIds()) {
                                if (IDUtils.isNull((Long)dimid2)) continue;
                                dimensionCache = ModelCacheContext.getOrCreate((Long)param.getBizModel().getId()).getDimension(dimid2);
                                Set<String> oboNumbers = param.getSetting().getOboMemberNumberMap().get(dimid2);
                                if (dimensionCache == null) continue;
                                if (userDefine.length() > 0) {
                                    userDefine.append(";");
                                }
                                userDefine.append(BgControlLogAddUtils.replaceArgs(modelFormat, dimensionCache.getName(), ""));
                                if (oboNumbers == null || oboNumbers.isEmpty()) continue;
                                boolean isfirst = true;
                                for (String number : oboNumbers) {
                                    if (!isfirst) {
                                        userDefine.append(split);
                                    } else {
                                        isfirst = false;
                                    }
                                    userDefine.append(ModelCacheContext.getOrCreate((Long)param.getBizModel().getId()).getMemberByAnyView(param.getBizModel().getControlBusModelId(), dimensionCache.getNumber(), number).getName());
                                }
                            }
                        }
                        rowDatas[12] = userDefine.toString();
                        userDefine.setLength(0);
                        DynamicObject userObj = param.getSetting().getObject().getDynamicObject("userDefinedRuleField");
                        userDefine.append(BgControlLogAddUtils.replaceArgs(modelFormat, SysDimensionEnum.Account.getChineseName(), userObj.getString("dimentions.groupaccount.name")));
                        for (int i = 1; i <= 7; ++i) {
                            String name;
                            dimid = userObj.getLong("dimentions.userdefineddimid" + i);
                            if (IDUtils.isNull((Long)dimid) || (dimensionCache = ModelCacheContext.getOrCreate((Long)param.getBizModel().getId()).getDimension(dimid)) == null || !StringUtils.isNotEmpty((String)(name = userObj.getString("dimentions.userdefined" + i + ".name")))) continue;
                            if (userDefine.length() > 0) {
                                userDefine.append(split);
                            }
                            userDefine.append(BgControlLogAddUtils.replaceArgs(modelFormat, dimensionCache.getName(), name));
                        }
                        rowDatas[13] = userDefine.toString();
                        entry.getHideColumnKey().remove(ControlLogTypeEnum.CONTROLRULEGROUPADD.getNumber());
                        entry.getHideColumnKey().remove(ControlLogTypeEnum.CONTROLRULEGROUPOBO.getNumber());
                        entry.getHideColumnKey().remove(ControlLogTypeEnum.CONTROLRULEGROUPMEMBER.getNumber());
                        continue;
                    }
                    if (param.getSetting().getObject() == null) continue;
                    if (noGroupData == null) {
                        noGroupData = rowDatas;
                    }
                    rowDatas[9] = param.getSetting().getAccountName();
                    DynamicObject userObj = param.getSetting().getObject().getDynamicObject("userDefinedRuleField");
                    userDefine.setLength(0);
                    if (userObj != null) {
                        for (int i = 1; i <= 7; ++i) {
                            String name;
                            dimid = userObj.getLong("dimentions.userdefineddimid" + i);
                            if (IDUtils.isNull((Long)dimid) || (dimensionCache = ModelCacheContext.getOrCreate((Long)param.getBizModel().getId()).getDimension(dimid)) == null || !StringUtils.isNotEmpty((String)(name = userObj.getString("dimentions.userdefined" + i + ".name")))) continue;
                            if (userDefine.length() > 0) {
                                userDefine.append(",");
                            }
                            userDefine.append(dimensionCache.getName()).append("_").append(name);
                        }
                    }
                    rowDatas[10] = userDefine.length() > 0 ? userDefine.toString() : empty;
                    entry.getHideColumnKey().remove(ControlLogTypeEnum.CONTROLRULESETACCOUNT.getNumber());
                    entry.getHideColumnKey().remove(ControlLogTypeEnum.CONTROLRULESETUSERDEFINE.getNumber());
                    continue;
                }
                log.info("innerAddControlParams-controlsetting-null");
            }
            if (groupData == null && noGroupData == null) {
                noGroupData = defaultData;
            }
            if (groupData != null) {
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULEGROUPADD, 0, "", (String)groupData[11], controlrulelog, false);
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULEGROUPOBO, 0, "", (String)groupData[12], null, true);
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULEGROUPMEMBER, 0, "", (String)groupData[13], null, true);
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULEGROUPTYPE, 0, "", (String)groupData[3], null, true);
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULEGROUPCOEFFICIENT, 0, "", (String)groupData[4], null, true);
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULEGROUPBEYOND, 0, "", (String)groupData[5], null, true);
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULEGROUPORG, 0, "", (String)groupData[6], null, true);
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULEGROUPTIME, 0, "", (String)groupData[7], null, true);
            }
            if (noGroupData != null) {
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULESETACCOUNT, 0, "", noGroupData[9] == null ? empty : (String)noGroupData[9], controlrulelog, false);
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULESETUSERDEFINE, 0, "", noGroupData[10] == null ? empty : (String)noGroupData[10], null, true);
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULESETTYPE, 0, "", (String)noGroupData[3], null, true);
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULESETCOEFFICIENT, 0, "", (String)noGroupData[4], null, true);
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULESETBEYOND, 0, "", (String)noGroupData[5], null, true);
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULESETORG, 0, "", (String)noGroupData[6], null, true);
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULESETTIME, 0, "", (String)noGroupData[7], null, true);
            }
            HashMap<String, String> mappingNames = new HashMap<String, String>(10);
            if (!mappingIds.isEmpty()) {
                QFilter filter = new QFilter("id", "in", mappingIds);
                dateeffectivetime = null;
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMappingName", (String)"eb_dimmembermapping", (String)"id,name", (QFilter[])filter.toArray(), null);){
                    if (ds != null) {
                        while (ds.hasNext()) {
                            Row row = ds.next();
                            mappingNames.put(row.getString("id"), row.getString("name"));
                        }
                    }
                }
                catch (Throwable row) {
                    dateeffectivetime = row;
                    throw row;
                }
            }
            for (Map.Entry detailE : logMap.entrySet()) {
                logDetail = (CommonShowDetail)detailE.getValue();
                for (Map.Entry entryE : logDetail.getEntryMap().entrySet()) {
                    entry = (CommonShowDetailEntry)entryE.getValue();
                    int mappingIndex = -1;
                    for (int c = 0; c < entry.getColumns().size(); ++c) {
                        column = (CommonShowDetailEntry.Column)entry.getColumns().get(c);
                        if (hasNoEquals.contains((String)detailE.getKey() + "_" + (String)entryE.getKey())) {
                            if (COL_MEMBER_BUDGET.equals(column.getColumnType())) {
                                column.setColumnAlias(ResManager.loadResFormat((String)"%1.\u9884\u7b97\u6570\u6210\u5458", (String)"ControlLog_Budget", (String)"epm-eb-business", (Object[])new Object[]{column.getColumnAlias()}));
                            } else if (COL_MEMBER_ACTUAL.equals(column.getColumnType())) {
                                column.setColumnAlias(ResManager.loadResFormat((String)"%1.\u5b9e\u9645\u6570\u6210\u5458", (String)"ControlLog_Actual", (String)"epm-eb-business", (Object[])new Object[]{column.getColumnAlias()}));
                            }
                        }
                        if (!COL_MEMBER_MAPPINGNAME.equals(column.getColumnType())) continue;
                        mappingIndex = c;
                    }
                    if (mappingIndex < 0) continue;
                    for (Object[] rowData : entry.getDatas()) {
                        if (rowData == null || mappingIndex >= rowData.length || rowData[mappingIndex] == null || !mappingNames.containsKey(rowData[mappingIndex])) continue;
                        rowData[mappingIndex] = mappingNames.get(rowData[mappingIndex]);
                    }
                }
            }
            logDetail = (CommonShowDetail)logMap.remove(SysDimensionEnum.Entity.getNumber());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.DIMMATERULEMAPPINGORG, 0, "", logDetail == null || logDetail.getEntryMap().isEmpty() ? empty : logDetail.getShowMessage(), logDetail, false);
            logDetail = (CommonShowDetail)logMap.remove(SysDimensionEnum.Account.getNumber());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.DIMMATERULEMAPPINGACCOUNT, 0, "", logDetail == null || logDetail.getEntryMap().isEmpty() ? empty : logDetail.getShowMessage(), logDetail, false);
            logDetail = (CommonShowDetail)logMap.remove(SysDimensionEnum.Currency.getNumber());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.DIMMATERULEMAPPINGCURRENCY, 0, "", logDetail == null || logDetail.getEntryMap().isEmpty() ? empty : logDetail.getShowMessage(), logDetail, false);
            logDetail = (CommonShowDetail)logMap.remove(SysDimensionEnum.ChangeType.getNumber());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.DIMMATERULEMAPPINGCHANGETYPE, 0, "", logDetail == null || logDetail.getEntryMap().isEmpty() || StringUtils.isEmpty((String)logDetail.getShowMessage()) ? empty : logDetail.getShowMessage(), logDetail, false);
            logDetail = (CommonShowDetail)logMap.remove(SysDimensionEnum.Period.getNumber());
            if (logDetail != null) {
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.DIMMATERULEMAPPINGPERIOD, 0, "", logDetail == null || logDetail.getEntryMap().isEmpty() ? empty : logDetail.getShowMessage(), logDetail, false);
            }
            if ((logDetail = (CommonShowDetail)logMap.remove(SysDimensionEnum.BudgetPeriod.getNumber())) != null) {
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.DIMMATERULEMAPPINGPERIOD, 0, "", logDetail == null || logDetail.getEntryMap().isEmpty() ? empty : logDetail.getShowMessage(), logDetail, false);
            }
            if (!logMap.isEmpty()) {
                StringBuilder msg = new StringBuilder();
                int size = 0;
                Iterator it = logMap.entrySet().iterator();
                while (it.hasNext()) {
                    logDetail = (CommonShowDetail)it.next().getValue();
                    String showMsg = logDetail.getShowMessage();
                    if (StringUtils.isEmpty((String)showMsg)) continue;
                    if (msg.length() > 0) {
                        msg.append("\r\n");
                    }
                    msg.append(logDetail.getShowMessage());
                    Iterator itEntry = logDetail.getEntryMap().entrySet().iterator();
                    while (itEntry.hasNext()) {
                        if (!((CommonShowDetailEntry)itEntry.next().getValue()).getDatas().isEmpty()) continue;
                        itEntry.remove();
                    }
                    if (logDetail.isEmpty()) {
                        it.remove();
                    }
                    ++size;
                }
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.DIMMATERULEMAPPINGUSERDEF, 0, "", msg.toString(), ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6", (String)"ControlLog_UserDefined1", (String)"epm-eb-business", (Object[])new Object[0]), logMap.isEmpty() ? null : logMap, size);
            }
            log.info("end-innerAddControlParams");
        }
        catch (Throwable e) {
            log.info("innerAddControlParams-error:{}", (Object)e);
        }
    }

    private static void innerAddDetailMaterule(LogStats stats, boolean isMultiControl, Collection<IControlParam> controlParams, Map<Long, DynamicObject> dimmaterMap) {
        if (!LogStats.isNeedDetailLog((LogStats)stats)) {
            return;
        }
        try {
            LinkedHashSet<String> names = new LinkedHashSet<String>(10);
            LinkedHashSet<String> groupnumbers = new LinkedHashSet<String>(10);
            ArrayList<String> modelnames = new ArrayList<String>(10);
            ArrayList<String> maternams = new ArrayList<String>(10);
            ArrayList<String> times = new ArrayList<String>(10);
            ArrayList<String> conditions = new ArrayList<String>(10);
            ArrayList<String> metris = new ArrayList<String>(10);
            ArrayList<String> ctrltypes = new ArrayList<String>(10);
            ArrayList<String> coffs = new ArrayList<String>(10);
            ArrayList<String> beyonds = new ArrayList<String>(10);
            ArrayList<String> freetypes = new ArrayList<String>(10);
            boolean hasNoDef = false;
            if (controlParams != null) {
                String empty = BgControlLogAddUtils.getEmptyString();
                SimpleDateFormat format = BgControlLogAddUtils.getDateFormatByInternetSet();
                LinkedHashMap<Long, BizModel> bizModelMap = new LinkedHashMap<Long, BizModel>(10);
                LinkedHashMap<Long, BizModel> bizModelIdMap = new LinkedHashMap<Long, BizModel>(10);
                for (IControlParam param : controlParams) {
                    if (param.getControlScheme() == null || param.getBizModel() == null) continue;
                    bizModelMap.put(param.getBizModel().getKey(), param.getBizModel());
                    bizModelIdMap.put(param.getBizModel().getId(), param.getBizModel());
                }
                for (BizModel bizModel : bizModelMap.values()) {
                    modelnames.add(BgControlLogAddUtils.getModelName(bizModel));
                }
                HashMap<Long, DynamicObject> defaultRuleMap = new HashMap<Long, DynamicObject>(bizModelIdMap.size());
                if (!bizModelMap.isEmpty()) {
                    QFBuilder builder = new QFBuilder();
                    builder.add(new QFilter("model.id", "in", new HashSet(bizModelIdMap.keySet())));
                    builder.add(new QFilter("isdefault", "=", (Object)Character.valueOf('1')));
                    DynamicObjectCollection col = QueryServiceHelper.query((String)"eb_bgcontrolrulemain", (String)"id,model,periodclassify,controltype,coefficient,isbeyond,isfreetype,effectivedate,invaliddate,createdate,illustrate,group.id,group.groupname,group.groupseq,accounts.account.id,accounts.account.name,accounts.account.number", (QFilter[])builder.toArrays());
                    if (col != null) {
                        for (DynamicObject rule : col) {
                            defaultRuleMap.put(rule.getLong("model"), rule);
                        }
                    }
                }
                boolean isMult = bizModelIdMap.size() > 1;
                String modelFormat = ResManager.loadResFormat((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[0]);
                String yes = ResManager.loadKDString((String)"\u662f", (String)"ControlLog_Yes", (String)"epm-eb-business", (Object[])new Object[0]);
                String no = ResManager.loadKDString((String)"\u5426", (String)"ControlLog_No", (String)"epm-eb-business", (Object[])new Object[0]);
                for (BizModel bizModel : bizModelIdMap.values()) {
                    DynamicObject rule = (DynamicObject)defaultRuleMap.get(bizModel.getId());
                    String modelname = bizModel.getName();
                    Format nformat = BgControlUtils.getDecimalFormatByInternetSet();
                    if (rule == null) {
                        hasNoDef = true;
                        BgControlLogAddUtils.addMsg(ctrltypes, empty, modelname, modelFormat, isMult);
                        BgControlLogAddUtils.addMsg(coffs, empty, modelname, modelFormat, isMult);
                        BgControlLogAddUtils.addMsg(beyonds, empty, modelname, modelFormat, isMult);
                        BgControlLogAddUtils.addMsg(freetypes, empty, modelname, modelFormat, isMult);
                        continue;
                    }
                    BgControlLogAddUtils.addMsg(ctrltypes, ResManager.loadResFormat((String)"\u660e\u7ec6\u671f\u95f4\u5206\u7c7b\uff1a%1\uff1b\u63a7\u5236\u65b9\u5f0f\uff1a%2\u3002", (String)"ControlLog_ControlType", (String)"epm-eb-business", (Object[])new Object[]{BgControlPeriodTypeEnum.getNameByValue((int)rule.getInt("periodclassify")), BgControlSettingTypeEnum.getNameByValue((int)rule.getInt("controltype"))}), modelname, modelFormat, isMult);
                    BgControlLogAddUtils.addMsg(coffs, nformat.format(rule.getBigDecimal("coefficient")), modelname, modelFormat, isMult);
                    BgControlLogAddUtils.addMsg(beyonds, rule.getBoolean("isbeyond") ? yes : no, modelname, modelFormat, isMult);
                    BgControlLogAddUtils.addMsg(freetypes, rule.getBoolean("isfreetype") ? yes : no, modelname, modelFormat, isMult);
                }
                if (dimmaterMap != null && !dimmaterMap.isEmpty()) {
                    for (DynamicObject obj : dimmaterMap.values()) {
                        names.add(obj.getString("name"));
                        groupnumbers.add(ResManager.loadResFormat((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[]{ResManager.loadKDString((String)"\u89c4\u5219\u7ec4", (String)"ControlLog_GroupNumber", (String)"epm-eb-business", (Object[])new Object[0]), obj.getString("number")}));
                        maternams.add(ResManager.loadResFormat((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[]{ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0", (String)"ControlLog_MaterName", (String)"epm-eb-business", (Object[])new Object[0]), obj.getString("cardentity.title")}));
                        String effectivetime = BgControlLogAddUtils.getTimeShow(format, obj.getDate("cardentity.effectivetime"));
                        String invalidtime = BgControlLogAddUtils.getTimeShow(format, obj.getDate("cardentity.invalidtime"));
                        times.add(ResManager.loadResFormat((String)"\u751f\u6548\u65e5\u671f\uff1a%1\uff0c\u5931\u6548\u65e5\u671f\uff1a%2", (String)"ControlLog_VersionTime", (String)"epm-eb-business", (Object[])new Object[]{effectivetime, invalidtime}));
                        metris.add(obj.getString("cardentity.metricfield.name"));
                        String serqfilter = obj.getString("cardentity.serqfilter");
                        String condition = empty;
                        try {
                            if (!StringUtils.isEmpty((String)serqfilter)) {
                                FlexBDValueCondition fc = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)serqfilter, FlexBDValueCondition.class);
                                condition = fc.getDescription().getLocaleValue();
                            }
                        }
                        catch (Throwable e) {
                            log.info("parse-conditiion:{}", (Object)e);
                        }
                        conditions.add(condition);
                    }
                }
            }
            String statsStr = isMultiControl ? ResManager.loadKDString((String)"\u751f\u6548", (String)"ControlLog_Multi_true", (String)"epm-eb-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u751f\u6548", (String)"ControlLog_Multi_false", (String)"epm-eb-business", (Object[])new Object[0]);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.REGISTBILLDEFAULTMULTI, 0, "", ResManager.loadResFormat((String)"\u53cc\u91cd\u63a7\u5236\uff1a%1\uff1b%2", (String)"ControlLog_Materule", (String)"epm-eb-business", (Object[])new Object[]{statsStr, StringUtils.join(names, (String)", ")}), null, false, names.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.DIMMATERULEGROUP, 0, "", StringUtils.join(groupnumbers, (String)"\r\n"), null, false, groupnumbers.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.DIMMATERULEBILL, 0, "", StringUtils.join(maternams, (String)"\r\n"), null, false, maternams.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.DIMMATERULEMODEL, 0, "", StringUtils.join(modelnames, (String)"\r\n"), null, false, modelnames.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.DIMMATERULETIME, 0, "", StringUtils.join(times, (String)"\r\n"), null, false, times.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.DIMMATERULECONDITION, 0, "", StringUtils.join(conditions, (String)"\r\n"), null, false, conditions.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.DIMMATERULEMAPPINGMETRIC, 0, "", StringUtils.join(metris, (String)"\r\n"), null, false, metris.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULEDEFAULTTYPE, hasNoDef ? 1 : 0, "", StringUtils.join(ctrltypes, (String)"\r\n"), null, false, ctrltypes.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULEDEFAULTCOEFFICIENT, hasNoDef ? 1 : 0, "", StringUtils.join(coffs, (String)"\r\n"), null, false, ctrltypes.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULEDEFAULTBEYOND, hasNoDef ? 1 : 0, "", StringUtils.join(beyonds, (String)"\r\n"), null, false, ctrltypes.size());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRULEDEFAULTFREE, hasNoDef ? 1 : 0, "", StringUtils.join(freetypes, (String)"\r\n"), null, false, ctrltypes.size());
        }
        catch (Throwable e) {
            log.info("addDetailMaterule-error:{}", (Object)e);
        }
    }

    public static void addWriteOffLogs(LogStats stats, Long writeOffId, List<WriteOffLog> logs) {
        if (!LogStats.isNeedDetailLog((LogStats)stats)) {
            return;
        }
        try {
            EBThreadPoolExecutor.executeOnce(() -> {
                List list = stats.getControllogs();
                synchronized (list) {
                    BgControlLogAddUtils.innerAddWriteOffLogs(stats, writeOffId, logs);
                }
            }, (String)"control-addDetailModel");
        }
        catch (Throwable e) {
            log.info("addDetailModel-error{}", (Object)e);
        }
    }

    public static void innerAddWriteOffLogs(LogStats stats, Long writeOffId, @NotNull List<WriteOffLog> logs) {
        if (!LogStats.isNeedDetailLog((LogStats)stats)) {
            return;
        }
        String empty = BgControlLogAddUtils.getEmptyString();
        DynamicObjectCollection writeoffschemes = null;
        if (IDUtils.isNotNull((Long)writeOffId)) {
            QFilter filter = new QFilter("id", "=", (Object)writeOffId);
            writeoffschemes = QueryServiceHelper.query((String)"eb_writeoffscheme_pro", (String)"name,writeoffinfo.writeoffbill.fieldtable,writeoffinfo.writeoffbill.name,writeoffinfo.writeoffsourcebill.number,writeoffinfo.writeoffsourcebill.name,writeoffinfo.writeoffentry.number,writeoffinfo.writeoffentry.name,writeoffinfo.writeoffvalue.number,writeoffinfo.writeoffvalue.name,writeoffinfo.writeoffsourcebillentry.number,writeoffinfo.writeoffsourcebillentry.name", (QFilter[])filter.toArray());
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLPROCESSWRITEOFFNAME, 0, "", ((DynamicObject)writeoffschemes.get(0)).getString("name"), null, false);
        } else {
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLPROCESSWRITEOFFNAME, 0, "", empty, null, false);
        }
        Format nFormat = BgControlUtils.getDecimalFormatByInternetSet();
        if (logs.isEmpty()) {
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLPROCESSWRITEOFFENTRYID, 0, "", empty, null, false);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLPROCESSWRITEOFFBILL, 0, "", empty, null, false);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLPROCESSWRITEOFFDETAILID, 0, "", empty, null, false);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLPROCESSWRITEOFFTYPE, 0, "", empty, null, false);
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLPROCESSWRITEOFFVALUE, 0, "", empty, null, false);
            return;
        }
        HashMap<String, Map> propNames = new HashMap<String, Map>(10);
        Map subNames = null;
        HashMap<String, String> billNames = new HashMap<String, String>(10);
        if (writeoffschemes != null) {
            for (DynamicObject writeoffinfo : writeoffschemes) {
                subNames = propNames.computeIfAbsent(writeoffinfo.getString("writeoffinfo.writeoffbill.fieldtable"), f -> new HashMap(4));
                billNames.put(writeoffinfo.getString("writeoffinfo.writeoffbill.fieldtable"), writeoffinfo.getString("writeoffinfo.writeoffbill.name"));
                subNames.put(writeoffinfo.getString("writeoffinfo.writeoffsourcebill.number"), writeoffinfo.getString("writeoffinfo.writeoffsourcebill.name"));
                subNames.put(writeoffinfo.getString("writeoffinfo.writeoffentry.number"), writeoffinfo.getString("writeoffinfo.writeoffentry.name"));
                subNames.put(writeoffinfo.getString("writeoffinfo.writeoffvalue.number"), writeoffinfo.getString("writeoffinfo.writeoffvalue.name"));
                subNames.put(writeoffinfo.getString("writeoffinfo.writeoffsourcebillentry.number"), writeoffinfo.getString("writeoffinfo.writeoffsourcebillentry.name"));
            }
        }
        CommonShowDetail detail = new CommonShowDetail(ControlLogTypeEnum.CONTROLPROCESSWRITEOFFBILL.getAlias());
        CommonShowDetailEntry entry = null;
        String writeoffocc = ResManager.loadKDString((String)"\u5360\u7528\u51b2\u9500", (String)"ControlLog_WriteOffOcc", (String)"epm-eb-business", (Object[])new Object[0]);
        String writeoffexe = ResManager.loadKDString((String)"\u6267\u884c\u51b2\u9500", (String)"ControlLog_WriteOffExe", (String)"epm-eb-business", (Object[])new Object[0]);
        boolean hasUserDef = false;
        Object[] rowDatas = null;
        StringBuilder tmpString = new StringBuilder();
        String log_entryid = null;
        String log_bill = null;
        String log_detialid = null;
        String log_type = null;
        String log_value = null;
        String modelFormat = ResManager.loadKDString((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[0]);
        String billField = null;
        for (WriteOffLog _log : logs) {
            billField = _log.getTargetApplyProp();
            try {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)_log.getSourceEntityNumber());
                billField = BgRegisterUtils.getFieldName(entityType, billField);
            }
            catch (Throwable e) {
                log.info("queryFieldName-error {}", (Object)e);
            }
            entry = detail.getEntry(_log.getSourceEntityNumber(), billNames.getOrDefault(_log.getSourceEntityNumber(), _log.getSourceEntityNumber()));
            subNames = propNames.getOrDefault(_log.getSourceEntityNumber(), new HashMap(1));
            entry.addColumn(SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Entity.getChineseName(), COL_MEMBER_BUDGET);
            entry.addColumn(SysDimensionEnum.Account.getNumber(), SysDimensionEnum.Account.getChineseName(), COL_MEMBER_BUDGET);
            entry.addColumn("userdefined", ResManager.loadKDString((String)"\u8f85\u52a9\u7ef4\u5ea6", (String)"ControlLog_UserDefined", (String)"epm-eb-business", (Object[])new Object[0]), COL_PROPERTY);
            entry.getHideColumnKey().add("userdefined");
            entry.addColumn(ControlLogTypeEnum.CONTROLPROCESSWRITEOFFVALUE.getNumber(), ControlLogTypeEnum.CONTROLPROCESSWRITEOFFVALUE.getAlias() + "(" + subNames.getOrDefault(_log.getValueProp(), _log.getValueProp()) + ")", COL_PROPERTY);
            entry.addColumn(ControlLogTypeEnum.CONTROLPROCESSWRITEOFFTYPE.getNumber(), ControlLogTypeEnum.CONTROLPROCESSWRITEOFFTYPE.getAlias(), COL_PROPERTY);
            entry.addColumn(ControlLogTypeEnum.CONTROLPROCESSWRITEOFFBILL.getNumber(), ControlLogTypeEnum.CONTROLPROCESSWRITEOFFBILL.getAlias() + "(" + subNames.getOrDefault(_log.getSourceIdProp(), _log.getSourceIdProp()) + ")", COL_PROPERTY);
            entry.addColumn(ControlLogTypeEnum.CONTROLPROCESSWRITEOFFENTRYID.getNumber(), ControlLogTypeEnum.CONTROLPROCESSWRITEOFFENTRYID.getAlias() + "(" + billField, COL_PROPERTY);
            entry.addColumn(ControlLogTypeEnum.CONTROLPROCESSWRITEOFFDETAILID.getNumber(), ControlLogTypeEnum.CONTROLPROCESSWRITEOFFDETAILID.getAlias() + "(" + subNames.getOrDefault(_log.getValueProp(), _log.getValueProp()) + ")", COL_PROPERTY);
            hasUserDef = false;
            for (IControlParam param : _log.getControlParams()) {
                if (!param.isWriteOffs()) continue;
                rowDatas = new Object[8];
                entry.getDatas().add(rowDatas);
                rowDatas[0] = param.getMember(false, SysDimensionEnum.Entity.getNumber()).getName();
                rowDatas[1] = param.getMember(false, SysDimensionEnum.Account.getNumber()).getName();
                tmpString.setLength(0);
                for (kd.epm.eb.common.model.Dimension dim : param.getBizModel().getDimensions()) {
                    if (!param.getBizModel().getControlDims().contains(dim.getId()) || !BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dim)) continue;
                    if (tmpString.length() > 0) {
                        tmpString.append(",");
                    }
                    tmpString.append(dim.getName()).append("_").append(param.getMember(false, dim.getNumber()).getName());
                }
                rowDatas[2] = tmpString.toString();
                if (tmpString.length() > 0) {
                    hasUserDef = true;
                }
                rowDatas[3] = nFormat.format(param.getAmount());
                rowDatas[4] = _log.isOccupation() ? writeoffocc : writeoffexe;
                rowDatas[5] = param.getRefBizId();
                rowDatas[6] = String.valueOf(param.getPropValueMap().get(_log.getTargetApplyProp()));
                rowDatas[7] = String.valueOf(param.getPropValueMap().get(_log.getTargetApplyProp()));
                if (log_entryid != null) continue;
                log_entryid = BgControlLogAddUtils.replaceArgs(modelFormat, billField, rowDatas[6]);
                log_bill = BgControlLogAddUtils.replaceArgs(modelFormat, subNames.getOrDefault(_log.getSourceIdProp(), _log.getSourceIdProp()), rowDatas[5]);
                log_detialid = BgControlLogAddUtils.replaceArgs(modelFormat, subNames.getOrDefault(_log.getEntryIdProp(), _log.getEntryIdProp()), rowDatas[7]);
                log_type = (String)rowDatas[4];
                log_value = BgControlLogAddUtils.replaceArgs(modelFormat, subNames.getOrDefault(_log.getValueProp(), _log.getValueProp()), rowDatas[3]);
            }
            if (!hasUserDef) continue;
            entry.getHideColumnKey().remove("userdefined");
        }
        if (log_entryid == null) {
            log_entryid = empty;
            log_bill = empty;
            log_detialid = empty;
            log_type = empty;
            log_value = empty;
        }
        BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLPROCESSWRITEOFFENTRYID, 0, "", log_entryid, log_entryid == null ? null : detail, false);
        BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLPROCESSWRITEOFFBILL, 0, "", log_bill, null, true);
        BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLPROCESSWRITEOFFDETAILID, 0, "", log_detialid, null, true);
        BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLPROCESSWRITEOFFTYPE, 0, "", log_type, null, true);
        BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLPROCESSWRITEOFFVALUE, 0, "", log_value, null, true);
    }

    private static void addMsg(@NotNull Collection<String> msgs, @NotNull String msg, String modelname, String msgFormat, boolean isMult) {
        if (isMult) {
            msgs.add(BgControlLogAddUtils.replaceArgs(msgFormat, modelname, msg));
        } else {
            msgs.add(msg);
        }
    }

    private static String replaceArgs(@NotNull String sResult, Object ... args) {
        if (args != null) {
            int iCount = args.length;
            for (int i = 1; i <= iCount; ++i) {
                sResult = sResult.replace("%" + i, String.valueOf(args[i - 1]));
            }
        }
        return sResult;
    }
}

