/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CommonShowDetail;
import kd.epm.eb.common.utils.CommonShowDetailEntry;
import kd.epm.eb.common.utils.ControlLog;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import kd.epm.eb.control.eums.ControlLogTypeEnum;
import org.jetbrains.annotations.NotNull;

public class BgControlLogUtils {
    private static final Log log = LogFactory.getLog(BgControlLogUtils.class);
    public static final String DELETE_HISTORY_LOG = "DELETE_HISTORY_LOG";

    public static void info(Log log, boolean isLog, String logInfo) {
        if (isLog) {
            StringBuilder stack = new StringBuilder();
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            if (stackTrace != null && stackTrace.length > 2) {
                for (int i = 0; i < stackTrace.length; ++i) {
                    if (stackTrace[i].getClassName().indexOf("epm.eb") == -1 || stackTrace[i].getClassName().indexOf("BgControlLogUtils") != -1) continue;
                    stack.append(String.format("%s.%s(%s:%s)%s", stackTrace[i].getClassName(), stackTrace[i].getMethodName(), stackTrace[i].getClassName(), stackTrace[i].getLineNumber(), "\r\n"));
                    break;
                }
            }
            log.info(stack + logInfo);
        }
    }

    public static void info(LogStats stats, boolean isLog, String logInfo) {
        if (isLog) {
            if (stats != null && stats.getLogs() != null) {
                stats.getLogs().add(BgControlLogUtils.getCurrTime() + " " + logInfo);
            } else {
                BgControlLogUtils.info(log, isLog, logInfo);
            }
        }
    }

    public static void infoThread(final LogStats stats, boolean isLog, final Supplier<String> supplier) {
        if (isLog) {
            if (stats != null && stats.getLogs() != null) {
                new Thread(){

                    @Override
                    public void run() {
                        stats.getLogs().add(BgControlLogUtils.getCurrTime() + " " + (String)supplier.get());
                    }
                }.start();
            } else {
                BgControlLogUtils.info(log, isLog, supplier.get());
            }
        }
    }

    public static void addDetail(@NotNull LogStats stats, @NotNull ControlLogTypeEnum logType, int result, String tips, String showMessage, CommonShowDetail detail, boolean isFindParent) {
        BgControlLogUtils.addDetail(stats, logType, result, tips, showMessage, detail, isFindParent, 1);
    }

    public static void addDetail(@NotNull LogStats stats, @NotNull ControlLogTypeEnum logType, int result, String tips, String showMessage, CommonShowDetail detail, boolean isFindParent, int lineCount) {
        if (!LogStats.isNeedDetailLog((LogStats)stats) || logType == null) {
            return;
        }
        if (lineCount == 0) {
            lineCount = 1;
        }
        ControlLog log = new ControlLog();
        log.setType(logType.getNumber());
        log.setResult(result);
        log.setTips(tips);
        log.setShowMessage(showMessage);
        log.setDetail(detail);
        log.setFindParent(isFindParent);
        log.setLineCount(lineCount);
        stats.getControllogs().add(log);
    }

    public static void addDetail(@NotNull LogStats stats, @NotNull ControlLogTypeEnum logType, int result, String tips, String showMessage, String detailMapTitle, LinkedHashMap<String, CommonShowDetail> detailMap, int lineCount) {
        if (!LogStats.isNeedDetailLog((LogStats)stats) || logType == null) {
            return;
        }
        ControlLog log = new ControlLog();
        log.setType(logType.getNumber());
        log.setResult(result);
        log.setTips(tips);
        log.setShowMessage(showMessage);
        log.setDetailMapTitle(detailMapTitle);
        log.setDetailMap(detailMap);
        log.setLineCount(lineCount);
        stats.getControllogs().add(log);
    }

    public static String getBizRegName(String entityNumber, String number, String type) {
        DynamicObject obj;
        if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)number)) {
            return "";
        }
        QFilter qf = new QFilter("fieldtable", "=", (Object)entityNumber);
        qf.and("number", "=", (Object)number);
        if (type != null) {
            qf.and("type", "=", (Object)type);
        }
        return (obj = QueryServiceHelper.queryOne((String)"eb_bgcontrolbizreg", (String)"name", (QFilter[])qf.toArray())) == null ? number : obj.getString("name");
    }

    public static void finishInfo(final LogStats stats, final Log log) {
        if (stats == null || stats.getLogs() == null || stats.getLogs().isEmpty() || log == null) {
            return;
        }
        EBThreadPoolExecutor.executeOnce((Runnable)new Runnable(){

            @Override
            public void run() {
                StringBuilder string = new StringBuilder();
                for (String _log : stats.getLogs()) {
                    if (string.length() == 0) {
                        string.append("budget-control-log : finishInfo ");
                    }
                    string.append("\r\n");
                    string.append(_log);
                    if (string.length() <= 10000) continue;
                    log.info(string.toString());
                    string.setLength(0);
                }
                if (string.length() > 0) {
                    log.info(string.toString());
                }
            }
        }, (String)"finishInfo");
    }

    public static void saveDetailLog(Long globalId, LogStats stats, Log log) {
        if (stats == null || stats.getControllogs() == null || stats.getControllogs().isEmpty() || log == null) {
            return;
        }
        try {
            EBThreadPoolExecutor.executeOnce(() -> {
                List list = stats.getControllogs();
                synchronized (list) {
                    BgControlLogUtils.innerSaveDetailLog(globalId, stats, log);
                }
            }, (String)"control-saveDetailLog");
        }
        catch (Throwable e) {
            BgControlLogUtils.log.info("saveDetailLog-error{}", (Object)e);
        }
    }

    private static void innerSaveDetailLog(Long globalId, LogStats stats, Log log) {
        try (TXHandle tx = TX.requiresNew((String)"eb/control/savedetaillog");){
            log.info("begin-innerSaveDetailLog");
            BgControlLogUtils.deleteHistoryLog();
            log.info("end-deleteHistoryLog");
            if (stats.getControllogs() != null && !stats.getControllogs().isEmpty()) {
                ControlLog resultLog = null;
                for (int i = stats.getControllogs().size() - 1; i >= 0; --i) {
                    if (!((ControlLog)stats.getControllogs().get(i)).getType().equals(ControlLogTypeEnum.CONTROLRESULT.getNumber())) continue;
                    resultLog = (ControlLog)stats.getControllogs().get(i);
                    break;
                }
                if (resultLog != null) {
                    stats.getControllogs().remove(resultLog);
                    stats.getControllogs().add(resultLog);
                }
                CommonShowDetail detail = new CommonShowDetail("");
                CommonShowDetailEntry entry = detail.getEntry("", "");
                entry.addColumn("log", ResManager.loadKDString((String)"\u63a7\u5236\u8fc7\u7a0b\u65e5\u5fd7", (String)"ControlLog_Log", (String)"epm-eb-business", (Object[])new Object[0]));
                entry.getDatas().add(new Object[]{stats.toString()});
                if (stats.getLogs() != null) {
                    stats.getLogs().forEach(f -> entry.getDatas().add(new Object[]{f}));
                }
                if (resultLog == null) {
                    BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.CONTROLRESULT, 0, "", ControlException.requestBudget((String)""), detail, false);
                } else {
                    resultLog.setDetail(detail);
                }
                SqlBuilder sql = new SqlBuilder();
                sql.append("UPDATE t_eb_bgcontroloperlog Set fhaslogs = '1' WHERE fid = ?", new Object[]{globalId});
                DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
                sql = new SqlBuilder();
                sql.append("DELETE FROM t_eb_bgcontrollogdetail WHERE FID = ?", new Object[]{globalId});
                DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
                sql = new SqlBuilder();
                String json = JSONUtils.toString((Object)stats.getControllogs());
                sql.append("INSERT INTO t_eb_bgcontrollogdetail(fid, fcreatedate, flogs) values(?,?,?)", new Object[]{globalId, new Date(), ObjectSerialUtil.compress4GZipByte((String)json)});
                DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            }
            log.info("end-innerSaveDetailLog");
        }
    }

    private static void deleteHistoryLog() {
        Date lastData = (Date)CacheServiceHelper.get((String)DELETE_HISTORY_LOG, Date.class);
        Calendar calendar = Calendar.getInstance();
        int thisYear = calendar.get(1);
        int thisDay = calendar.get(6);
        boolean needDelete = true;
        if (lastData != null) {
            calendar.setTime(lastData);
            int lastYear = calendar.get(1);
            int lastDay = calendar.get(6);
            if (lastYear == thisYear && thisDay - lastDay < 3) {
                needDelete = false;
            }
        }
        if (needDelete) {
            int day = BgControlLogUtils.getDeleteDay();
            calendar = Calendar.getInstance();
            calendar.add(6, 0 - day);
            SqlBuilder sql = new SqlBuilder();
            sql.append("Delete FROM t_eb_bgcontrollogdetail Where FCreateDate < ?", new Object[]{calendar.getTime()});
            DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            CacheServiceHelper.put((String)DELETE_HISTORY_LOG, (Object)new Date());
        }
    }

    private static String getCurrTime() {
        StringBuilder time = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        time.append(calendar.get(1)).append("-").append(BgControlLogUtils.getTime(2, calendar.get(2) + 1)).append("-").append(BgControlLogUtils.getTime(2, calendar.get(5))).append(" ").append(BgControlLogUtils.getTime(2, calendar.get(11))).append(":").append(BgControlLogUtils.getTime(2, calendar.get(12))).append(":").append(BgControlLogUtils.getTime(2, calendar.get(13))).append(".").append(BgControlLogUtils.getTime(3, calendar.get(14)));
        return time.toString();
    }

    private static String getTime(int sign, int value) {
        switch (sign) {
            case 2: {
                if (value < 10) {
                    return "0" + value;
                }
                return String.valueOf(value);
            }
            case 3: {
                if (value < 10) {
                    return "00" + value;
                }
                if (value < 100) {
                    return "0" + value;
                }
                return String.valueOf(value);
            }
        }
        return null;
    }

    public static int getDeleteDay() {
        try {
            Set logs = LogSignHelper.getLogSignByGropNum((String)"BudgetControlDeleteLog");
            if (logs != null && !logs.isEmpty()) {
                return Integer.parseInt((String)logs.iterator().next());
            }
        }
        catch (Throwable ex) {
            log.info("BgControlLogUtils-getDeleteDay", (Object)ex);
        }
        return 30;
    }

    public static boolean isNeedLog() {
        try {
            return LogSignHelper.needLog((String)"BudgetControlLog", (String)"NeedLog");
        }
        catch (Throwable ex) {
            log.info("BgControlLogUtils-isNeedLog", (Object)ex);
            return false;
        }
    }

    public static int getLogMaxLength() {
        try {
            Set logs = LogSignHelper.getLogSignByGropNum((String)"BudgetControlLogMaxLength");
            if (logs != null && !logs.isEmpty()) {
                return Integer.parseInt((String)logs.iterator().next());
            }
        }
        catch (Throwable ex) {
            log.info("BgControlLogUtils-BudgetControlLogMaxLength", (Object)ex);
        }
        return 20000;
    }

    public static boolean isMergeEntry() {
        try {
            return LogSignHelper.needLog((String)"BudgetControlMergeEntry", (String)"NeedMerge");
        }
        catch (Throwable ex) {
            log.info("BgControlLogUtils-isNeedLog", (Object)ex);
            return false;
        }
    }

    public static boolean isQueryAllOrg() {
        try {
            return LogSignHelper.needLog((String)"BudgetControlDimensionOrg", (String)"NeedQueryAllOrg");
        }
        catch (Throwable ex) {
            log.info("BgControlLogUtils-isQueryAllOrg", (Object)ex);
            return false;
        }
    }

    public static Integer getWarningDataSize() {
        try {
            Set logs = LogSignHelper.getLogSignByGropNum((String)"BudgetControlWarningDataSize");
            if (logs != null && !logs.isEmpty()) {
                return Integer.parseInt((String)logs.iterator().next());
            }
        }
        catch (Throwable ex) {
            log.info("BgControlLogUtils-getWarningDataSize", (Object)ex);
        }
        return 100;
    }

    public static Integer getVersionConstrastGptSize() {
        try {
            Set logs = LogSignHelper.getLogSignByGropNum((String)"VersionConstrastGptSize");
            if (logs != null && !logs.isEmpty()) {
                return Integer.parseInt((String)logs.iterator().next());
            }
        }
        catch (Throwable ex) {
            log.info("BgControlLogUtils-getVersionConstrastGptSize", (Object)ex);
        }
        return 50000;
    }
}

