/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.control.BgControlCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.enums.BgControlPeriodTypeEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.BizOrgUnit;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.resource.ResourceUtils;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DynamicObjectUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.common.utils.OrgUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.control.Centralized;
import kd.epm.eb.control.eums.ControlTypeEnum;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.CalcMemberParameter;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.impl.model.BgItemMapping;
import kd.epm.eb.control.impl.model.BgItemMappingMember;
import kd.epm.eb.control.impl.model.ControlParam;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlOrgUtils;
import kd.epm.eb.control.utils.BgControlProcessUtils;
import kd.epm.eb.control.utils.BgControlRuleUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.BgControlWhiteUtils;
import kd.epm.eb.control.utils.BgMemberMapHisUtils;
import kd.epm.eb.control.utils.BgPeriodUtils;

public class BgControlParamUtils {
    private static final Log log = LogFactory.getLog(BgControlParamUtils.class);
    private IControlParameter parameter = null;
    private BgControlScheme scheme = null;

    public BgControlParamUtils setParameter(IControlParameter parameter) {
        this.parameter = parameter;
        return this;
    }

    public IControlParameter getParameter() {
        return this.parameter;
    }

    public BgControlParamUtils setScheme(BgControlScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    public BgControlScheme getScheme() {
        return this.scheme;
    }

    public static BgControlParamUtils get() {
        return new BgControlParamUtils();
    }

    private BizModel getBizModel(BgControlData controlData) {
        if (controlData == null || controlData.getBizModels() == null || this.getScheme() == null || this.getScheme().getBizModelKey() == null) {
            return null;
        }
        return controlData.getBizModels().get(this.getScheme().getBizModelKey());
    }

    public Collection<IControlParam> builderParams(BgControlData controlData, Map<String, String> props, List<Map<String, Object>> propsMap) {
        if (this.getParameter() == null || controlData == null || propsMap == null || propsMap.isEmpty()) {
            return new ArrayList<IControlParam>();
        }
        controlData.getStats().add("begin-builderParams");
        boolean isNeedLog = BgControlLogUtils.isNeedLog();
        ArrayList<IControlParam> controlParams = new ArrayList<IControlParam>(propsMap.size());
        for (Map<String, Object> values : propsMap) {
            IControlParam param = this.createControlParam(controlData, props, values);
            if (param == null) continue;
            param.setNeedLog(isNeedLog);
            controlParams.add(param);
        }
        controlData.getStats().add("begin-buildObject");
        this.buildObject(controlParams);
        controlData.getStats().add("end-buildObject");
        controlData.getStats().add("begin-whiteBillControl");
        this.whiteBillControl(controlData.getStats(), this.getScheme(), controlParams);
        controlData.getStats().add("end-whiteBillControl");
        controlData.getStats().add("begin-isFreeType");
        this.isFreeType(controlParams, controlData);
        controlData.getStats().add("end-isFreeType");
        controlData.getStats().add("begin-fillMembers");
        this.fillMembers(controlData, controlParams);
        controlData.getStats().add("end-fillMembers");
        controlData.getStats().add("begin-buildControlRule");
        this.buildControlRule(controlData, controlParams);
        controlData.getStats().add("end-buildControlRule");
        controlData.getStats().add("begin-fillPeriodMembers");
        this.fillPeriodMembers(this.getBizModel(controlData), controlData, controlParams);
        controlData.getStats().add("end-fillPeriodMembers");
        controlData.getStats().add("begin-buildProcess");
        this.buildProcess(controlData, controlParams);
        controlData.getStats().add("end-buildProcess");
        return this.mergeControlParams(controlData, controlParams);
    }

    public Collection<IControlParam> mergeControlParams(BgControlData controlData, List<IControlParam> controlParams) {
        if (controlParams == null || controlParams.isEmpty() || !BgControlLogUtils.isMergeEntry()) {
            return controlParams;
        }
        LinkedHashMap<String, IControlParam> paramMap = new LinkedHashMap<String, IControlParam>(controlParams.size());
        String key = null;
        IControlParam merge = null;
        for (IControlParam param : controlParams) {
            key = param.getMemberKeyByBudget() + "!" + param.getMemberKeyByActual() + "!" + param.getReqKey();
            merge = (IControlParam)paramMap.get(key);
            if (merge != null) {
                merge.setAmend(BgControlParamUtils.add(merge.getAmend(), param.getAmend()));
                merge.setAmount(BgControlParamUtils.add(merge.getAmount(), param.getAmount()));
                continue;
            }
            paramMap.put(key, param);
        }
        return new ArrayList<IControlParam>(paramMap.values());
    }

    public static BigDecimal add(BigDecimal value1, BigDecimal value2) {
        if (value2 != null) {
            if (value1 == null) {
                return value2;
            }
            return value1.add(value2);
        }
        return value1;
    }

    private void isFreeType(List<IControlParam> controlParams, BgControlData controlData) {
        boolean freeType = BgControlWhiteUtils.isFreeType(this.getBizModel(controlData), controlData);
        for (IControlParam controlParam : controlParams) {
            controlParam.setFreeType(freeType);
        }
    }

    private void whiteBillControl(LogStats stats, BgControlScheme scheme, List<IControlParam> controlParams) {
        BgControlWhiteUtils.isExitAccount(stats, this.getParameter().getEntityNumber(), controlParams, scheme);
    }

    protected IControlParam createControlParam(BgControlData controlData, Map<String, String> props, Map<String, Object> values) {
        IControlParam controlParam = this.createBaseControlParam(controlData, props, values);
        this.buildBase(controlParam, values);
        this.buildOrg(controlParam, props);
        this.buildAccount(controlParam, props);
        this.buildPeriod(controlParam, props);
        this.buildCurrency(controlParam, props);
        this.buildVersion(controlParam);
        this.buildChangeType(controlParam, props);
        this.buildExtMember(controlParam, props);
        return controlParam;
    }

    public static String getReqAlias(IControlParam param, kd.epm.eb.common.model.Dimension dimension) {
        if (param == null || dimension == null) {
            return null;
        }
        if (param.getPropValueMap() == null) {
            log.info("getReqAlias-propValueMap-null");
            return null;
        }
        if (param.getProps() == null) {
            log.info("getReqAlias-props-null");
            return null;
        }
        String aliasField = null;
        if (kd.epm.eb.common.enums.SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
            aliasField = param.getProps().get("orgUnitAlias");
        } else if (kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
            aliasField = param.getProps().get("bizItemAlias");
        } else if (kd.epm.eb.common.enums.SysDimensionEnum.Currency.getNumber().equals(dimension.getNumber())) {
            aliasField = param.getProps().get("currencyAlias");
        } else if (kd.epm.eb.common.enums.SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber())) {
            aliasField = param.getProps().get("changeTypeAlias");
        } else if (BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension)) {
            String userDefinedId = BgControlScheme.getUserDefendKey(dimension);
            if (param.getProps().containsKey(userDefinedId)) {
                aliasField = param.getProps().get(userDefinedId + "Alias");
            }
        }
        if (aliasField == null || param.getPropValueMap().get(aliasField) == null) {
            return null;
        }
        String value = String.valueOf(param.getPropValueMap().get(aliasField));
        if (StringUtils.isEmpty((String)value)) {
            // empty if block
        }
        return value;
    }

    protected IControlParam createBaseControlParam(BgControlData controlData, Map<String, String> props, Map<String, Object> values) {
        Object entrySeq;
        ControlParam controlParam = new ControlParam();
        controlParam.setStats(controlData.getStats());
        controlParam.setControlScheme(this.getScheme());
        controlParam.setControlType(ControlTypeEnum.OCCUPATION);
        controlParam.setDefaultZero(this.getParameter() == null ? true : this.getParameter().isDefaultZero());
        if (!this.getParameter().getControlManager().isStandard() && this.getParameter().getControlManager().isExecute()) {
            controlParam.setControlType(ControlTypeEnum.EXECUTE);
        }
        controlParam.setBizModel(this.getBizModel(controlData));
        if (controlParam.getBizModel() == null) {
            ControlException.errorBizModel();
            return controlParam;
        }
        controlParam.setProps(props);
        controlParam.setPropValueMap(values);
        Object entryId = values.get(props.get("entryProp"));
        if (entryId != null) {
            controlParam.setEntryId(String.valueOf(entryId));
        }
        if ((entrySeq = values.get(props.get("entrySeqProp"))) instanceof Integer) {
            controlParam.setEntrySeq((Integer)entrySeq);
        }
        Member member = null;
        DynamicObject controlVersion = this.getParameter().getDataManager().getScenVersion().get(BgControlUtils.getSVKey(controlParam.getBizModel()));
        Map viewMap = controlParam.getBizModel().getView();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)controlParam.getBizModel().getId());
        for (kd.epm.eb.common.model.Dimension dimension : controlParam.getBizModel().getDimensions()) {
            Member metric;
            if (kd.epm.eb.common.enums.SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber()) && (metric = this.getScheme().getMetricField()) != null) {
                metric.setDimension(dimension);
                metric.setLeaf(true);
                controlParam.setMember(true, metric);
                controlParam.setMember(false, metric);
                continue;
            }
            if (kd.epm.eb.common.enums.SysDimensionEnum.Year.getNumber().equals(dimension.getNumber()) || kd.epm.eb.common.enums.SysDimensionEnum.Period.getNumber().equals(dimension.getNumber()) || kd.epm.eb.common.enums.SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())) continue;
            if (kd.epm.eb.common.enums.SysDimensionEnum.AuditTrail.getNumber().equals(dimension.getNumber())) {
                Long atId;
                member = null;
                if (controlVersion != null && controlVersion.getDataEntityType().getProperties().containsKey((Object)"audittrail.id") && (atId = (Long)controlVersion.get("audittrail.id")) != null && atId != 0L) {
                    member = new Member(atId, (String)controlVersion.get("audittrail.name"), (String)controlVersion.get("audittrail.number"));
                    member.setDimension(dimension);
                    controlParam.setMember(true, member);
                }
                if (member == null) {
                    member = new Member(null, "ATTotal", "ATTotal");
                    member.setDimension(dimension);
                    controlParam.setMember(true, member);
                }
                member = new Member(null, "EntityInput", "EntityInput");
                member.setDimension(dimension);
                controlParam.setMember(false, member);
                continue;
            }
            if (kd.epm.eb.common.enums.SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber())) {
                member = new Member(null, "CurrentPeriod", "CurrentPeriod");
                member.setDimension(dimension);
                controlParam.setMember(true, member);
                member = new Member(null, "Occupation", "Occupation");
                member.setDimension(dimension);
                controlParam.setMember(false, member);
                continue;
            }
            if (kd.epm.eb.common.enums.SysDimensionEnum.DataType.getNumber().equals(dimension.getNumber())) {
                Long dtId;
                member = null;
                if (controlVersion != null && controlVersion.getDataEntityType().getProperties().containsKey((Object)"datatype.id") && (dtId = (Long)controlVersion.get("datatype.id")) != null && dtId != 0L) {
                    member = new Member(dtId, (String)controlVersion.get("datatype.name"), (String)controlVersion.get("datatype.number"));
                }
                if (member == null) {
                    member = new Member(null, "Budget", "Budget");
                }
                member.setDimension(dimension);
                controlParam.setMember(true, member);
                member = new Member(null, "Actual", "Actual");
                member.setDimension(dimension);
                controlParam.setMember(false, member);
                continue;
            }
            if (kd.epm.eb.common.enums.SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) {
                member = new Member(null, "ICNone", "ICNone");
                member.setDimension(dimension);
                controlParam.setMember(true, member);
                controlParam.setMember(false, member);
                continue;
            }
            if (SysDimensionEnum.Process.getNumber().equals(dimension.getNumber())) {
                member = new Member(null, "IRpt", "IRpt");
                member.setDimension(dimension);
                controlParam.setMember(true, member);
                controlParam.setMember(false, member);
                continue;
            }
            if (SysDimensionEnum.Scenario.getNumber().equals(dimension.getNumber())) {
                member = new Member(null, "NoScenario", "NoScenario");
                member.setDimension(dimension);
                controlParam.setMember(true, member);
                controlParam.setMember(false, member);
                continue;
            }
            if (BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension)) {
                if (!controlParam.getBizModel().isEBByModel() && viewMap.get(dimension.getNumber()) != null && (Long)viewMap.get(dimension.getNumber()) != 0L) {
                    Long viewId = (Long)viewMap.get(dimension.getNumber());
                    kd.epm.eb.common.cache.impl.Member rootMember = modelCacheHelper.getRootMember(dimension.getNumber(), viewId);
                    member = new Member(null, rootMember.getName(), rootMember.getNumber());
                    member.setDimension(dimension);
                } else {
                    member = BgDimensionServiceHelper.getRootMember((kd.epm.eb.common.model.Dimension)dimension);
                }
            } else {
                member = BgDimensionServiceHelper.getNoneMember((kd.epm.eb.common.model.Dimension)dimension);
            }
            controlParam.setMember(true, member);
            member = BgDimensionServiceHelper.getNoneMember((kd.epm.eb.common.model.Dimension)dimension);
            controlParam.setMember(false, member);
        }
        return controlParam;
    }

    protected void buildBase(IControlParam controlParam, Map<String, Object> values) {
        if (controlParam == null || values == null) {
            return;
        }
        Object id = values.get("id");
        if (id != null) {
            controlParam.setBizId(id.toString());
        }
        controlParam.setBizNumber((String)values.get(this.getParameter().getBizUtils().getBillNumberField(this.getParameter().getEntityNumber())));
        if (StringUtils.isEmpty((String)controlParam.getBizNumber())) {
            controlParam.setBizNumber((String)values.get("number"));
        }
        if (StringUtils.isEmpty((String)controlParam.getBizId())) {
            controlParam.setBizId(this.getParameter().getBizId());
        }
        if (StringUtils.isEmpty((String)this.getParameter().getBizNo())) {
            this.getParameter().setBizNo(controlParam.getBizNumber());
        }
    }

    protected void buildOrg(IControlParam controlParam, Map<String, String> props) {
        if (controlParam == null || controlParam.getBizModel() == null || props == null) {
            return;
        }
        String orgField = props.get("orgUnit");
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)kd.epm.eb.common.enums.SysDimensionEnum.Entity.getMemberTreemodel());
        this.buildModel(object, orgField, props.get("orgUnitNum"), props.get("orgUnitAlias"), controlParam.getPropValueMap());
        controlParam.setOrgUnitObj(true, new BizOrgUnit(kd.epm.eb.common.enums.SysDimensionEnum.Entity.getNumber(), object));
        controlParam.setOrgUnitObj(false, new BizOrgUnit(kd.epm.eb.common.enums.SysDimensionEnum.Entity.getNumber(), object));
        controlParam.setReqOrgUnitObj(new BizOrgUnit(kd.epm.eb.common.enums.SysDimensionEnum.Entity.getNumber(), object));
        Member orgUnit = Member.loadFromDynamicObject((DynamicObject)object);
        orgUnit.setDimension((kd.epm.eb.common.model.Dimension)controlParam.getBizModel().getDimensionMap().get(kd.epm.eb.common.enums.SysDimensionEnum.Entity.getNumber()));
        controlParam.setOrgUnit(true, orgUnit);
        controlParam.setOrgUnit(false, orgUnit);
        controlParam.setReqMember(orgUnit);
        controlParam.setProp(kd.epm.eb.common.enums.SysDimensionEnum.Entity.getNumber(), orgField);
        Object orgObj = controlParam.getPropValueMap().get(orgField);
        if (orgObj instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)orgObj;
            controlParam.setReqObj(kd.epm.eb.common.enums.SysDimensionEnum.Entity.getNumber(), dy.getDataEntityType().getName(), dy.getLong("id"));
        }
    }

    protected void buildAccount(IControlParam controlParam, Map<String, String> props) {
        if (controlParam == null || controlParam.getBizModel() == null || props == null) {
            return;
        }
        String orgField = props.get("bizItem");
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)kd.epm.eb.common.enums.SysDimensionEnum.Account.getMemberTreemodel());
        this.buildModel(object, orgField, props.get("bizItemNum"), props.get("bizItemAlias"), controlParam.getPropValueMap());
        controlParam.setAccountObj(true, object);
        controlParam.setAccountObj(false, object);
        controlParam.setReqAccountObj(object);
        Member account = Member.loadFromDynamicObject((DynamicObject)object);
        account.setDimension((kd.epm.eb.common.model.Dimension)controlParam.getBizModel().getDimensionMap().get(kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber()));
        controlParam.setAccount(true, account);
        controlParam.setAccount(false, account);
        controlParam.setReqMember(account);
        controlParam.setProp(kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber(), orgField);
        Object orgObj = controlParam.getPropValueMap().get(orgField);
        if (orgObj instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)orgObj;
            controlParam.setReqObj(kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber(), dy.getDataEntityType().getName(), dy.getLong("id"));
        }
    }

    protected void buildPeriod(IControlParam controlParam, Map<String, String> props) {
        if (controlParam == null || props == null) {
            return;
        }
        String prop = props.get("bizTime");
        Object propValue = controlParam.getPropValueMap().get(prop);
        Date bizTime = ConvertUtils.toDate((Object)propValue);
        if (bizTime == null) {
            ControlException.errorBizTime((String)prop, (Object)propValue);
        }
        controlParam.setBizTime(bizTime);
        Map dimensionMap = controlParam.getBizModel().getDimensionMap();
        if (dimensionMap.containsKey(kd.epm.eb.common.enums.SysDimensionEnum.Year.getNumber())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(bizTime);
            Member year = new Member((kd.epm.eb.common.model.Dimension)controlParam.getBizModel().getDimensionMap().get(kd.epm.eb.common.enums.SysDimensionEnum.Year.getNumber()));
            year.setNumber("FY" + calendar.get(1));
            controlParam.setMember(true, year);
            controlParam.setMember(false, year);
        } else if (dimensionMap.containsKey(kd.epm.eb.common.enums.SysDimensionEnum.BudgetPeriod.getNumber())) {
            // empty if block
        }
        controlParam.setProp(kd.epm.eb.common.enums.SysDimensionEnum.Year.getNumber(), prop);
    }

    protected void buildCurrency(IControlParam controlParam, Map<String, String> props) {
        if (controlParam == null || controlParam.getBizModel() == null || props == null) {
            return;
        }
        Member currency = new Member((kd.epm.eb.common.model.Dimension)controlParam.getBizModel().getDimensionMap().get(kd.epm.eb.common.enums.SysDimensionEnum.Currency.getNumber()));
        this.buildMember(currency, props.get("currency"), props.get("currencyNum"), props.get("currencyAlias"), controlParam.getPropValueMap());
        controlParam.setMember(true, currency);
        controlParam.setMember(false, currency);
        controlParam.setProp(kd.epm.eb.common.enums.SysDimensionEnum.Currency.getNumber(), props.get("currency"));
    }

    protected void buildChangeType(IControlParam controlParam, Map<String, String> props) {
        if (controlParam == null || controlParam.getBizModel() == null || props == null) {
            return;
        }
        String changeTypeId = props.get("changeType");
        if (StringUtils.isNotEmpty((String)changeTypeId)) {
            Member changeType = new Member((kd.epm.eb.common.model.Dimension)controlParam.getBizModel().getDimensionMap().get(kd.epm.eb.common.enums.SysDimensionEnum.ChangeType.getNumber()));
            this.buildMember(changeType, changeTypeId, props.get("changeTypeNum"), props.get("changeTypeAlias"), controlParam.getPropValueMap());
            controlParam.setMember(true, changeType);
            controlParam.setProp(kd.epm.eb.common.enums.SysDimensionEnum.ChangeType.getNumber(), changeTypeId);
        }
    }

    protected void buildVersion(IControlParam controlParam) {
        if (controlParam == null || controlParam.getBizModel() == null) {
            return;
        }
        Map dimensionMap = controlParam.getBizModel().getDimensionMap();
        DynamicObject controlVersion = this.getParameter().getDataManager().getScenVersion().get(BgControlUtils.getSVKey(controlParam.getBizModel()));
        if (controlVersion != null) {
            kd.epm.eb.common.model.Dimension versionDim = (kd.epm.eb.common.model.Dimension)dimensionMap.get(kd.epm.eb.common.enums.SysDimensionEnum.Version.getNumber());
            Member version = new Member((Long)controlVersion.get("version.id"), (String)controlVersion.get("version.name"), (String)controlVersion.get("version.number"));
            version.setDimension(versionDim);
            controlParam.setMember(true, version);
            version = new Member((Long)controlVersion.get("acversion.id"), (String)controlVersion.get("acversion.name"), (String)controlVersion.get("acversion.number"));
            version.setDimension(versionDim);
            controlParam.setMember(false, version);
        }
    }

    protected void buildExtMember(IControlParam controlParam, Map<String, String> props) {
        if (controlParam == null || controlParam.getBizModel() == null || props == null) {
            return;
        }
        Member member = null;
        Member noneMember = null;
        List dimensions = controlParam.getBizModel().getDimensions();
        if (dimensions != null) {
            String userDefinedId = null;
            String userDefinedNum = null;
            String userDefinedAlias = null;
            for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                if (!BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension) || !props.containsKey(userDefinedId = BgControlScheme.getUserDefendKey(dimension))) continue;
                userDefinedNum = userDefinedId + "Num";
                userDefinedAlias = userDefinedId + "Alias";
                member = new Member(dimension);
                member.setDimension(dimension);
                this.buildMember(member, props.get(userDefinedId), props.get(userDefinedNum), props.get(userDefinedAlias), controlParam.getPropValueMap());
                if (member.getId() == null && StringUtils.isEmpty((String)member.getNumber())) {
                    noneMember = BgDimensionServiceHelper.getNoneMember((kd.epm.eb.common.model.Dimension)dimension);
                    member.setNumber(noneMember.getNumber());
                    member.setName(noneMember.getName());
                    member.setDimension(dimension);
                    controlParam.setHasNoneMember(dimension.getNumber());
                }
                controlParam.setMember(true, member);
                controlParam.setMember(false, member);
                controlParam.setProp(dimension.getNumber(), props.get(userDefinedId));
            }
        }
    }

    private void buildMember(Member member, String propId, String propNumber, String propAlias, Map<String, Object> values) {
        if (member == null || values == null || values.isEmpty()) {
            return;
        }
        Object obj = null;
        String tmpStr = null;
        if (StringUtils.isNotEmpty((String)propId)) {
            obj = values.get(propId);
            if (obj instanceof Long) {
                Long value = (Long)obj;
                if (value != 0L) {
                    member.setId((Long)obj);
                }
            } else if (obj instanceof String) {
                try {
                    member.setId(Long.valueOf(Long.parseLong((String)obj)));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (obj instanceof DynamicObject) {
                try {
                    member.setId(Long.valueOf(((DynamicObject)obj).getLong("id")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (StringUtils.isNotEmpty((String)propNumber)) {
            obj = values.get(propNumber);
            if (obj instanceof String) {
                tmpStr = (String)obj;
                if (tmpStr != null) {
                    member.setNumber(tmpStr.trim());
                }
            } else if (obj != null) {
                member.setNumber(obj.toString());
            }
        }
        if (StringUtils.isNotEmpty((String)propAlias)) {
            obj = values.get(propAlias);
            if (obj instanceof String) {
                tmpStr = (String)obj;
                if (tmpStr != null) {
                    member.setName(tmpStr.trim());
                }
            } else if (obj != null) {
                member.setName(obj.toString());
            }
        }
    }

    private void buildModel(DynamicObject object, String propId, String propNumber, String propAlias, Map<String, Object> values) {
        if (object == null || values == null) {
            return;
        }
        if (StringUtils.isNotEmpty((String)propId)) {
            Object obj = values.get(propId);
            if (obj instanceof DynamicObject) {
                object.set("id", (Object)((DynamicObject)obj).getLong("id"));
            } else {
                object.set("id", values.get(propId));
            }
        }
        if (StringUtils.isNotEmpty((String)propNumber)) {
            object.set("number", values.get(propNumber));
        }
        if (StringUtils.isNotEmpty((String)propAlias)) {
            object.set("name", values.get(propAlias));
        }
    }

    protected void buildObject(Collection<IControlParam> controlParams) {
        if (controlParams == null || controlParams.isEmpty()) {
            return;
        }
        String number = null;
        Long id = null;
        HashSet<String> orgUnitNums = new HashSet<String>(controlParams.size() * 3);
        HashSet<Long> itemIds = new HashSet<Long>(controlParams.size() * 3);
        for (IControlParam controlParam : controlParams) {
            orgUnitNums.add(controlParam.getOrgUnitObj(true).getNumber());
            orgUnitNums.add(controlParam.getOrgUnitObj(false).getNumber());
            orgUnitNums.add(controlParam.getReqOrgUnitObj().getNumber());
            itemIds.add(controlParam.getAccountObj(true).getLong("id"));
            itemIds.add(controlParam.getAccountObj(false).getLong("id"));
            itemIds.add(controlParam.getReqAccountObj().getLong("id"));
        }
        Map bizOrgUnitMap = OrgUtils.getOrgUnitMapByNums((String)"bos_org_structure", (Integer)BgControlOrgUtils.getOrgUnitType(), orgUnitNums);
        Map<Object, DynamicObject> bizItemMap = this.getParameter().getBizUtils().queryBizItem(this.getParameter().getBizUtils().getBizItemType(this.getParameter().getEntityNumber()), itemIds);
        for (IControlParam controlParam : controlParams) {
            number = controlParam.getOrgUnitObj(true).getNumber();
            if (bizOrgUnitMap.containsKey(number)) {
                controlParam.setOrgUnitObj(true, new BizOrgUnit("bos_org_structure", (DynamicObject)bizOrgUnitMap.get(number)));
            }
            if (bizOrgUnitMap.containsKey(number = controlParam.getOrgUnitObj(false).getNumber())) {
                controlParam.setOrgUnitObj(false, new BizOrgUnit("bos_org_structure", (DynamicObject)bizOrgUnitMap.get(number)));
            }
            if (bizOrgUnitMap.containsKey(number = controlParam.getReqOrgUnitObj().getNumber())) {
                controlParam.setReqOrgUnitObj(new BizOrgUnit("bos_org_structure", (DynamicObject)bizOrgUnitMap.get(number)));
            }
            if (bizItemMap.containsKey(id = Long.valueOf(controlParam.getAccountObj(true).getLong("id")))) {
                controlParam.setAccountObj(true, bizItemMap.get(id));
            }
            if (bizItemMap.containsKey(id = Long.valueOf(controlParam.getAccountObj(false).getLong("id")))) {
                controlParam.setAccountObj(false, bizItemMap.get(id));
            }
            if (!bizItemMap.containsKey(id = Long.valueOf(controlParam.getReqAccountObj().getLong("id")))) continue;
            controlParam.setReqAccountObj(bizItemMap.get(id));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void fillMembers(BgControlData controlData, Collection<IControlParam> controlParams) {
        Object calcParam;
        if (controlData == null || controlParams == null || controlParams.isEmpty()) {
            return;
        }
        BizModel bizModel = this.getBizModel(controlData);
        if (bizModel == null) {
            for (IControlParam controlParam : controlParams) {
                if (controlParam.getBizModel() == null) continue;
                bizModel = controlData.getBizModels().get(controlParam.getBizModel().getKey());
                break;
            }
        }
        if (bizModel == null) {
            ControlException.errorBizModel();
            return;
        }
        HashMap<String, Set<Long>> memberIdMap = new HashMap<String, Set<Long>>();
        List dimensions = bizModel.getDimensions();
        Member member = null;
        controlData.getStats().add("begin-mappingMember-false");
        this.mappingMember(controlData.getStats(), bizModel, controlParams, false);
        controlData.getStats().add("end-mappingMember-false");
        controlData.getStats().add("begin-getMemberIds");
        LinkedHashMap notExistMemberMap = Maps.newLinkedHashMap();
        for (IControlParam controlParam : controlParams) {
            for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                member = controlParam.getMember(true, dimension.getNumber());
                if (member != null && StringUtils.isEmpty((String)member.getNumber()) && member.getId() != null && member.getId() != 0L) {
                    this.getMemberIds(memberIdMap, dimension.getNumber()).add(member.getId());
                }
                if ((member = controlParam.getMember(false, dimension.getNumber())) == null || !StringUtils.isEmpty((String)member.getNumber()) || member.getId() == null || member.getId() == 0L) continue;
                this.getMemberIds(memberIdMap, dimension.getNumber()).add(member.getId());
            }
        }
        kd.epm.eb.common.cache.impl.Member object = null;
        HashMap<String, Set<String>> checkMemberMap = new HashMap<String, Set<String>>();
        Map dimensionMap = bizModel.getDimensionMap();
        ArrayList<IControlParam> removeControlParam = new ArrayList<IControlParam>(16);
        Map userMembers = MemberServiceHelper.queryUserDefinedSysMember((BizModel)bizModel);
        Map memberIds = MemberServiceHelper.queryByIds((Map)bizModel.getDimensionMap(), memberIdMap);
        if (!memberIds.isEmpty()) {
            for (IControlParam controlParam : controlParams) {
                for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                    if (!memberIds.containsKey(dimension.getNumber())) continue;
                    this.checkMemberById(memberIds, userMembers, checkMemberMap, bizModel, controlParam, dimension, notExistMemberMap);
                }
            }
        }
        controlData.getStats().add("begin-mappingMember-true");
        this.mappingMember(controlData.getStats(), bizModel, controlParams, true);
        controlData.getStats().add("end-mappingMember-true");
        HashMap<String, Set<String>> memberNumMap = new HashMap<String, Set<String>>();
        boolean hasCentralized = true;
        if (this.getParameter().getCalcParameter() instanceof CalcMemberParameter && ((CalcMemberParameter)(calcParam = (CalcMemberParameter)this.getParameter().getCalcParameter())).isHasQuerySetRule()) {
            hasCentralized = false;
        }
        if (hasCentralized && this.getParameter().isQueryCentralized()) {
            controlData.getStats().add("begin-centralizedMember");
            this.centralizedMember(bizModel, controlData, controlParams);
            controlData.getStats().add("end-centralizedMember");
        }
        controlData.getStats().add("begin-replaceNoDimMember");
        this.replaceNoDimMember(bizModel, false, controlData, controlParams);
        this.replaceNoDimMember(bizModel, true, controlData, controlParams);
        controlData.getStats().add("end-centralizedMember");
        for (IControlParam iControlParam : controlParams) {
            for (Object dimension : dimensions) {
                if (kd.epm.eb.common.enums.SysDimensionEnum.Period.getNumber().equals(dimension.getNumber()) || kd.epm.eb.common.enums.SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber()) || kd.epm.eb.common.enums.SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())) continue;
                member = iControlParam.getMember(true, dimension.getNumber());
                if (member == null) {
                    BgControlLogUtils.info(controlData.getStats(), true, "budget member is null, dimension number = " + dimension.getNumber());
                    continue;
                }
                if (member != null && StringUtils.isNotEmpty((String)member.getNumber())) {
                    this.getMembers(memberNumMap, dimension.getNumber()).add(member.getNumber());
                }
                if ((member = iControlParam.getMember(false, dimension.getNumber())) == null) {
                    BgControlLogUtils.info(controlData.getStats(), true, "actual member is null, dimension number = " + dimension.getNumber());
                }
                if (member != null && StringUtils.isNotEmpty((String)member.getNumber())) {
                    this.getMembers(memberNumMap, dimension.getNumber()).add(member.getNumber());
                }
                if (kd.epm.eb.common.enums.SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                    member = iControlParam.getReqMember(dimension.getNumber());
                    if (member != null && StringUtils.isNotEmpty((String)member.getNumber())) {
                        this.getMembers(memberNumMap, dimension.getNumber()).add(member.getNumber());
                        continue;
                    }
                    this.getMembers(memberNumMap, dimension.getNumber());
                    continue;
                }
                if (kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
                    member = iControlParam.getReqMember(dimension.getNumber());
                    if (member != null && StringUtils.isNotEmpty((String)member.getNumber())) {
                        this.getMembers(memberNumMap, dimension.getNumber()).add(member.getNumber());
                        continue;
                    }
                    this.getMembers(memberNumMap, dimension.getNumber());
                    continue;
                }
                if (!kd.epm.eb.common.enums.SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber())) continue;
                this.getMembers(memberNumMap, dimension.getNumber()).add("Occupation");
                this.getMembers(memberNumMap, dimension.getNumber()).add("Execute");
            }
        }
        controlData.getStats().add("begin-queryByNumber");
        Map members = MemberServiceHelper.queryByNumber((BizModel)bizModel, (Map)dimensionMap, memberNumMap);
        this.getParameter().getDataManager().addModelMembers(bizModel.getId(), members);
        controlData.getStats().add("end-queryByNumber");
        for (IControlParam controlParam : controlParams) {
            for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                if (kd.epm.eb.common.enums.SysDimensionEnum.Period.getNumber().equals(dimension.getNumber()) || kd.epm.eb.common.enums.SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber()) || kd.epm.eb.common.enums.SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())) continue;
                this.checkMember(members, userMembers, checkMemberMap, bizModel, controlParam, dimension, removeControlParam, notExistMemberMap);
                if (kd.epm.eb.common.enums.SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                    member = controlParam.getReqMember(dimension.getNumber());
                    if (member == null) continue;
                    kd.epm.eb.common.cache.impl.Member member2 = object = members.containsKey(dimension.getNumber()) ? (kd.epm.eb.common.cache.impl.Member)((Map)members.get(dimension.getNumber())).get(member.getNumber()) : null;
                    if (object != null) {
                        member = Member.loadFromCacheMember(object);
                        member.setDimension(dimension);
                        controlParam.setReqMember(member);
                        continue;
                    }
                    member = controlParam.getReqMember(dimension.getNumber());
                    continue;
                }
                if (!kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) || (member = controlParam.getReqMember(dimension.getNumber())) == null) continue;
                object = (kd.epm.eb.common.cache.impl.Member)((Map)members.get(dimension.getNumber())).get(member.getNumber());
                if (object != null) {
                    member = Member.loadFromCacheMember((kd.epm.eb.common.cache.impl.Member)object);
                    member.setDimension(dimension);
                    controlParam.setReqMember(member);
                    continue;
                }
                member = controlParam.getReqMember(dimension.getNumber());
            }
        }
        if (!this.getParameter().isHasShareQuery() && this.getScheme() != null && notExistMemberMap != null && !notExistMemberMap.isEmpty()) {
            boolean bl = true;
            StringBuilder str = new StringBuilder();
            QFilter filter = new QFilter("cardentity", "=", (Object)this.getScheme().getDetailId());
            DynamicObject mateGroup = QueryServiceHelper.queryOne((String)"eb_adddimmaterule", (String)"id,name,cardentity.title", (QFilter[])filter.toArray());
            String prop = notExistMemberMap.keySet().stream().map(k -> {
                if (this.parameter.getControlManager().isStandard()) {
                    if (k.p1 == null) {
                        return (String)k.p2;
                    }
                    IDataEntityProperty property = DynamicObjectUtils.getEntityProperty((DynamicObject)this.parameter.getBizObj(), (String)((String)k.p1));
                    if (property == null) {
                        return (String)k.p1;
                    }
                    return DynamicObjectUtils.getDisplayName((IDataEntityProperty)property);
                }
                return (String)k.p1;
            }).collect(Collectors.joining("\u3001"));
            str.append(ControlException.notExistByMemberFirst((String)prop, (BizModel)bizModel, (String)(mateGroup == null ? "" : mateGroup.getString("name")), (String)(mateGroup == null ? "" : mateGroup.getString("cardentity.title")))).append("\r\n");
            for (Map.Entry entry : notExistMemberMap.entrySet()) {
                void var17_23;
                String dimName = (String)((Pair)entry.getKey()).p2;
                List notExistMembers = (List)entry.getValue();
                str.append(ControlException.notExistMemberByDim((int)(++var17_23), (String)dimName, (List)notExistMembers)).append("\r\n");
            }
            str.setLength(str.length() - 1);
            ControlException.notExistMember((String)str.toString());
        }
        if (removeControlParam.size() > 0) {
            for (IControlParam mapEnty : removeControlParam) {
                controlParams.remove(mapEnty);
            }
        }
    }

    private void replaceNoDimMember(BizModel bizModel, boolean isBudget, BgControlData controlData, Collection<IControlParam> controlParams) {
        if (controlData == null || bizModel == null || controlParams == null || controlParams.isEmpty() || bizModel.isEBByModel()) {
            return;
        }
        Map dimensionMap = bizModel.getModelCache().getDimensionMap();
        Dimension accountDim = bizModel.getModelCache().getDimension(kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber());
        Map datasetDimMap = null;
        ArrayList calcDims = new ArrayList();
        List ctrlDims = bizModel.getDimensions().stream().map(d -> d.getNumber()).collect(Collectors.toList());
        for (IControlParam param : controlParams) {
            kd.epm.eb.common.cache.impl.Member accMember;
            Member _member = param.getMember(isBudget, kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber());
            if (_member == null || (accMember = accountDim.getMember(Long.valueOf(0L), _member.getNumber())) == null) continue;
            calcDims.clear();
            calcDims.addAll(ctrlDims);
            datasetDimMap = bizModel.getModelCache().getDimensionMap(accMember.getDatasetId());
            calcDims.removeAll(datasetDimMap.keySet());
            for (String dimNumber : calcDims) {
                _member = param.getMember(isBudget, dimNumber);
                if (_member == null || _member.getNumber() == null || dimensionMap.get(dimNumber) == null) continue;
                Dimension dimension = (Dimension)dimensionMap.get(dimNumber);
                kd.epm.eb.common.cache.impl.Member ctrlMember = isBudget ? bizModel.getModelCache().getMemberByAnyView(bizModel.getControlBusModelId(), dimension.getNumber(), dimension.getNumber()) : bizModel.getModelCache().getMemberByAnyView(bizModel.getControlBusModelId(), dimension.getNumber(), dimension.getNoneNumber());
                if (ctrlMember == null) continue;
                Member _m = Member.loadFormCache((kd.epm.eb.common.cache.impl.Member)ctrlMember);
                _m.setDimension(_member.getDimension());
                param.setMember(isBudget, _m);
            }
        }
    }

    protected void checkMember(Map<String, Map<String, kd.epm.eb.common.cache.impl.Member>> members, Map<String, Map<String, Member>> userMembers, Map<String, Set<String>> checkMemberMap, BizModel bizModel, IControlParam controlParam, kd.epm.eb.common.model.Dimension dimension, List<IControlParam> removeControlParam, Map<Pair<String, String>, List<String>> notExistMemberMap) {
        if (members == null || userMembers == null || checkMemberMap == null || bizModel == null || controlParam == null || dimension == null) {
            return;
        }
        kd.epm.eb.common.cache.impl.Member object = null;
        List notExistMemberList = null;
        Member member = controlParam.getMember(true, dimension.getNumber());
        if (member != null) {
            if (StringUtils.isNotEmpty((String)member.getNumber())) {
                Long busModelId;
                kd.epm.eb.common.cache.impl.Member accMember;
                kd.epm.eb.common.cache.impl.Member member2 = object = members.containsKey(dimension.getNumber()) ? members.get(dimension.getNumber()).get(member.getNumber()) : null;
                if (object != null && dimension.getNumber().equals(kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber()) && !bizModel.isEBByModel() && (accMember = bizModel.getModelCache().getMember(kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber(), null, String.valueOf(object.getNumber()))) != null && accMember.getDatasetId() != null && accMember.getDatasetId() != 0L && IDUtils.isNotNull((Long)(busModelId = bizModel.getModelCache().getBusModelByDataSet(accMember.getDatasetId()))) && IDUtils.isNotNull((Long)bizModel.getControlBusModelId()) && !busModelId.equals(bizModel.getControlBusModelId())) {
                    object = null;
                }
                if (object != null) {
                    member = Member.loadFromCacheMember(object);
                    member.setDimension(dimension);
                    controlParam.setMember(true, member);
                } else {
                    member = controlParam.getMember(true, dimension.getNumber());
                    this.isSameAccount(controlParam, checkMemberMap, member, removeControlParam);
                    if (this.checkMember(checkMemberMap, member, dimension)) {
                        controlParam.setQueryBudget(false);
                        if (this.getParameter().getControlManager().isStandard()) {
                            BgMemberMapHisUtils.write(controlParam.getBizModel().getId(), this.getParameter().getEntityNumber(), controlParam.getProp(member.getDimension().getNumber()), member);
                        }
                        if (dimension.getNumber().equals(kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber()) && controlParam.isFreeType()) {
                            removeControlParam.add(controlParam);
                        } else {
                            notExistMemberList = notExistMemberMap.computeIfAbsent((Pair<String, String>)Pair.onePair((Object)controlParam.getProp(dimension.getNumber()), (Object)dimension.getName()), f -> Lists.newLinkedList());
                            notExistMemberList.add(ControlException.memberNameAndNumberFormat((Member)member));
                        }
                    }
                }
            }
        } else if (BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension)) {
            member = userMembers.get(dimension.getNumber()).get(dimension.getNumber());
            member.setDimension(dimension);
            controlParam.setMember(true, member);
        }
        if ((member = controlParam.getMember(false, dimension.getNumber())) != null && StringUtils.isNotEmpty((String)member.getNumber())) {
            kd.epm.eb.common.cache.impl.Member member3 = object = members.containsKey(dimension.getNumber()) ? members.get(dimension.getNumber()).get(member.getNumber()) : null;
            if (object != null) {
                member = Member.loadFromCacheMember((kd.epm.eb.common.cache.impl.Member)object);
                member.setDimension(dimension);
                controlParam.setMember(false, member);
            } else {
                member = controlParam.getMember(false, dimension.getNumber());
                this.isSameAccount(controlParam, checkMemberMap, member, removeControlParam);
                if (this.checkMember(checkMemberMap, member, dimension)) {
                    controlParam.setQueryBudget(false);
                    if (this.getParameter().getControlManager().isStandard()) {
                        BgMemberMapHisUtils.write(controlParam.getBizModel().getId(), this.getParameter().getEntityNumber(), controlParam.getProp(member.getDimension().getNumber()), member);
                    }
                    if (dimension.getNumber().equals(kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber()) && controlParam.isFreeType()) {
                        removeControlParam.add(controlParam);
                    } else {
                        notExistMemberList = notExistMemberMap.computeIfAbsent((Pair<String, String>)Pair.onePair((Object)controlParam.getProp(dimension.getNumber()), (Object)dimension.getName()), f -> Lists.newLinkedList());
                        notExistMemberList.add(ControlException.memberNameAndNumberFormat((Member)member));
                    }
                }
            }
        }
    }

    private void isSameAccount(IControlParam controlParam, Map<String, Set<String>> memberMap, Member member, List<IControlParam> removeControlParam) {
        if (!member.getDimension().getNumber().equals(kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber())) {
            return;
        }
        if (memberMap == null || member == null) {
            return;
        }
        Set<String> members = memberMap.get(member.getDimension().getNumber());
        if (members == null) {
            return;
        }
        if (!members.contains(member.getNumber()) || !controlParam.isFreeType()) {
            return;
        }
        removeControlParam.add(controlParam);
    }

    protected void checkMemberById(Map<String, Map<Object, DynamicObject>> members, Map<String, Map<String, Member>> userMembers, Map<String, Set<String>> checkMemberMap, BizModel bizModel, IControlParam controlParam, kd.epm.eb.common.model.Dimension dimension, Map<Pair<String, String>, List<String>> notExistMemberMap) {
        DynamicObject object;
        if (members == null || userMembers == null || checkMemberMap == null || bizModel == null || controlParam == null || dimension == null) {
            return;
        }
        Member member = controlParam.getMember(true, dimension.getNumber());
        List notExistMemberList = null;
        if (member != null) {
            if (member.getId() != null && member.getId() != 0L && StringUtils.isEmpty((String)member.getNumber())) {
                object = members.get(dimension.getNumber()).get(member.getId());
                if (object != null) {
                    member = Member.loadFromDynamicObject((DynamicObject)object);
                    member.setDimension(dimension);
                    controlParam.setMember(true, member);
                    controlParam.setReqMember(member);
                } else if (this.checkMember(checkMemberMap, member, dimension)) {
                    controlParam.setQueryBudget(false);
                    if (this.getParameter().getControlManager().isStandard()) {
                        BgMemberMapHisUtils.write(controlParam.getBizModel().getId(), this.getParameter().getEntityNumber(), controlParam.getProp(member.getDimension().getNumber()), member);
                    }
                    notExistMemberList = notExistMemberMap.computeIfAbsent((Pair<String, String>)Pair.onePair((Object)controlParam.getProp(dimension.getNumber()), (Object)dimension.getName()), f -> Lists.newLinkedList());
                    notExistMemberList.add(ControlException.memberNameAndNumberFormat((Member)member));
                }
            }
        } else if (BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension)) {
            member = userMembers.get(dimension.getNumber()).get(dimension.getNumber());
            member.setDimension(dimension);
            controlParam.setMember(true, member);
        }
        if ((member = controlParam.getMember(false, dimension.getNumber())).getId() != null && member.getId() != 0L && StringUtils.isEmpty((String)member.getNumber())) {
            object = members.get(dimension.getNumber()).get(member.getId());
            if (object != null) {
                member = Member.loadFromDynamicObject((DynamicObject)object);
                member.setDimension(dimension);
                controlParam.setMember(false, member);
            } else if (this.checkMember(checkMemberMap, member, dimension)) {
                controlParam.setQueryBudget(false);
                if (this.getParameter().getControlManager().isStandard()) {
                    BgMemberMapHisUtils.write(controlParam.getBizModel().getId(), this.getParameter().getEntityNumber(), controlParam.getProp(member.getDimension().getNumber()), member);
                }
                notExistMemberList = notExistMemberMap.computeIfAbsent((Pair<String, String>)Pair.onePair((Object)controlParam.getProp(dimension.getNumber()), (Object)dimension.getName()), f -> Lists.newLinkedList());
                notExistMemberList.add(ControlException.memberNameAndNumberFormat((Member)member));
            }
        }
    }

    private boolean checkMember(Map<String, Set<String>> memberMap, Member member, kd.epm.eb.common.model.Dimension dimension) {
        boolean check = true;
        if (memberMap != null && member != null) {
            Set<String> members = memberMap.get(member.getDimension().getNumber());
            if (members == null) {
                members = new HashSet<String>();
                memberMap.put(member.getDimension().getNumber(), members);
            }
            if (members.contains(member.getNumber())) {
                check = false;
            } else {
                members.add(member.getNumber());
            }
        }
        if (check) {
            log.info(String.format("checkMember,memberMap:%s,member:%s,dimension:%s.", memberMap == null ? null : SerializationUtils.toJsonString(memberMap), member == null ? null : member.getNumber(), dimension == null ? null : dimension.getNumber()));
        }
        return check;
    }

    private Set<String> getMembers(Map<String, Set<String>> memberMap, String dimensionNumber) {
        Set<String> memberSet = memberMap.get(dimensionNumber);
        if (memberSet == null) {
            memberSet = new HashSet<String>();
            memberMap.put(dimensionNumber, memberSet);
        }
        return memberSet;
    }

    private Set<Long> getMemberIds(Map<String, Set<Long>> memberIdMap, String dimensionNumber) {
        Set<Long> memberSet = memberIdMap.get(dimensionNumber);
        if (memberSet == null) {
            memberSet = new HashSet<Long>();
            memberIdMap.put(dimensionNumber, memberSet);
        }
        return memberSet;
    }

    protected void mappingMember(LogStats stats, BizModel bizModel, Collection<IControlParam> controlParams, boolean hasNumber) {
        if (this.getScheme() == null || bizModel == null || controlParams == null || controlParams.isEmpty()) {
            return;
        }
        if (!this.getParameter().getControlManager().isStandard() && hasNumber && this.getScheme() != null) {
            this.handleMemberIdEmpty(bizModel, controlParams);
        }
        for (IControlParam controlParam : controlParams) {
            for (kd.epm.eb.common.model.Dimension dimension : bizModel.getDimensions()) {
                if (!this.isNeedMappingDim(dimension)) continue;
                Member member = controlParam.getMember(true, dimension.getNumber());
                if (this.getScheme() == null) continue;
                BgItemMappingMember _member = this.getScheme().mapping(hasNumber, member, controlParam.getPropValueMap());
                if (_member.mapping != null && (this.getParameter().isNeedMappingData() || LogStats.isNeedDetailLog((LogStats)stats))) {
                    controlParam.setMappingData(dimension.getNumber(), _member.mapping);
                }
                if (member != _member.member[0] || member.getNumber() != null && !member.getNumber().equals(_member.member[0].getNumber())) {
                    controlParam.setMember(true, _member.member[0]);
                    controlParam.setReqMember(member);
                }
                if (kd.epm.eb.common.enums.SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber()) || member == _member.member[1] && (member.getNumber() == null || member.getNumber().equals(_member.member[1].getNumber()))) continue;
                controlParam.setMember(false, _member.member[1]);
            }
        }
    }

    private void handleMemberIdEmpty(BizModel bizModel, Collection<IControlParam> controlParams) {
        Set memNumSet;
        Member member;
        HashMap<String, Set> memNumMapByDimNum = new HashMap<String, Set>(16);
        for (IControlParam controlParam : controlParams) {
            for (kd.epm.eb.common.model.Dimension dimension : bizModel.getDimensions()) {
                if (!this.isNeedMappingDim(dimension) || !IDUtils.isEmptyLong((Long)(member = controlParam.getMember(true, dimension.getNumber())).getId()).booleanValue()) continue;
                memNumSet = memNumMapByDimNum.computeIfAbsent(dimension.getNumber(), k -> new HashSet(16));
                memNumSet.add(member.getNumber());
            }
        }
        Map<Long, BgItemMapping> mappings = this.getScheme().getMappings();
        HashMap<String, Map<String, Long>> memIdMapByDimNum = new HashMap<String, Map<String, Long>>(16);
        for (Map.Entry entry : memNumMapByDimNum.entrySet()) {
            Map<String, Long> memIdMap;
            Long mappingId;
            String dimNumber = (String)entry.getKey();
            if (this.getScheme().getHasMappings() == null || IDUtils.isEmptyLong((Long)(mappingId = this.getScheme().getHasMappings().get(dimNumber))).booleanValue()) continue;
            memNumSet = (Set)entry.getValue();
            BgItemMapping bgItemMapping = mappings.get(mappingId);
            if (bgItemMapping == null || bgItemMapping.getChild() == null || bgItemMapping.getChild().isEmpty() || (memIdMap = bgItemMapping.getMemberIdsByNumberSet(memNumSet)) == null || memIdMap.size() <= 0) continue;
            memIdMapByDimNum.put(dimNumber, memIdMap);
        }
        for (IControlParam controlParam : controlParams) {
            for (kd.epm.eb.common.model.Dimension dimension : bizModel.getDimensions()) {
                if (!this.isNeedMappingDim(dimension) || !IDUtils.isEmptyLong((Long)(member = controlParam.getMember(true, dimension.getNumber())).getId()).booleanValue() || memIdMapByDimNum.get(dimension.getNumber()) == null) continue;
                member.setId((Long)((Map)memIdMapByDimNum.get(dimension.getNumber())).get(member.getNumber()));
            }
        }
    }

    private boolean isNeedMappingDim(kd.epm.eb.common.model.Dimension dimension) {
        if (dimension == null) {
            return false;
        }
        return BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension) || kd.epm.eb.common.enums.SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) || kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) || kd.epm.eb.common.enums.SysDimensionEnum.Currency.getNumber().equals(dimension.getNumber()) || kd.epm.eb.common.enums.SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber());
    }

    protected void centralizedMember(BizModel bizModel, BgControlData controlData, Collection<IControlParam> controlParams) {
        if (controlData == null || controlParams == null || controlParams.isEmpty() || bizModel == null) {
            return;
        }
        controlData.getStats().addInfo("begin-centralizedMember.");
        String _centralizedKey = BgControlParamUtils.getCentralizedKey(bizModel);
        List centralizeds = BgControlCache.getCentralized((String)_centralizedKey);
        if (centralizeds != null && !centralizeds.isEmpty()) {
            for (IControlParam controlParam : controlParams) {
                Member member = this.getCentData(controlParam, centralizeds);
                if (member == null) continue;
                Member oldMember = controlParam.getMember(true, kd.epm.eb.common.enums.SysDimensionEnum.Entity.getNumber());
                member.setDimension(oldMember.getDimension());
                controlParam.setMember(true, member);
                controlParam.setMember(false, member);
            }
        }
        controlData.getStats().add("end-centralizedMember.");
    }

    public static String getCentralizedKey(BizModel bizModel) {
        String _modelId = String.valueOf(bizModel.getId());
        String _busModelId = bizModel.isEBByModel() || IDUtils.isNull((Long)bizModel.getControlBusModelId()) ? "0" : String.valueOf(bizModel.getControlBusModelId());
        String _centralizedKey = _modelId + "@" + _busModelId;
        return _centralizedKey;
    }

    private Member getCentData(IControlParam controlParam, List<Centralized> centralizedList) {
        if (controlParam == null || centralizedList == null || centralizedList.isEmpty()) {
            return null;
        }
        Member _account = controlParam.getMember(true, kd.epm.eb.common.enums.SysDimensionEnum.Account.getNumber());
        Member _orgUnit = controlParam.getMember(true, kd.epm.eb.common.enums.SysDimensionEnum.Entity.getNumber());
        Member centraMember = null;
        Set lastCentraMember = new HashSet(16);
        for (Centralized centralized : centralizedList) {
            if (IDUtils.isNotNull((Long)centralized.getBusModelId()) && centralized.getBusModelId().compareTo(controlParam.getBizModel().getControlBusModelId()) != 0 || _account == null || !centralized.getAccounts().contains(_account.getNumber()) || _orgUnit == null) continue;
            Member _bizMember = !kd.epm.eb.common.enums.SysDimensionEnum.Entity.getNumber().equals(centralized.getDimNumber()) ? controlParam.getMember(true, centralized.getDimNumber()) : null;
            for (Centralized.CentEntry _centEntry : centralized.getEntries().values()) {
                Member n = _orgUnit;
                if (!_centEntry.getOrgRange().contains(n.getNumber()) && !_centEntry.getOrgRange().stream().anyMatch(k -> k.startsWith(n.getNumber() + "#"))) continue;
                if (_bizMember != null) {
                    if (!_centEntry.getBizRange().contains(_bizMember.getNumber())) continue;
                    if (centraMember != null && !centraMember.getNumber().equals(_centEntry.toCentOrgMember().getNumber())) {
                        String mem = _centEntry.getOrgRange().stream().filter(k -> k.equals(n.getNumber()) || k.startsWith(n.getNumber() + "#")).findFirst().get();
                        if (mem.contains("#")) {
                            String s2 = lastCentraMember.stream().filter(k -> k.equals(n.getNumber()) || k.startsWith(n.getNumber() + "#")).findFirst().get();
                            String tip = s2.contains("#") ? s2.split("#")[1] + "\u3001" + mem.split("#")[1] : mem.split("#")[1];
                            throw new KDBizException(ResourceUtils.moreCentral((String)controlParam.getBizModel().getName(), (String)this.getBusinessModelName(controlParam.getBizModel()), (String)mem.split("#")[0], (String)tip, (String)centraMember.getNumber(), (String)_centEntry.toCentOrgMember().getNumber()));
                        }
                        String s2 = lastCentraMember.stream().filter(k -> k.equals(n.getNumber()) || k.startsWith(n.getNumber() + "#")).findFirst().get();
                        String tip = s2.contains("#") ? s2.split("#")[1] : "";
                        throw new KDBizException(ResourceUtils.moreCentral((String)controlParam.getBizModel().getName(), (String)this.getBusinessModelName(controlParam.getBizModel()), (String)mem, (String)tip, (String)centraMember.getNumber(), (String)_centEntry.toCentOrgMember().getNumber()));
                    }
                    centraMember = _centEntry.toCentOrgMember();
                    lastCentraMember = _centEntry.getOrgRange();
                    continue;
                }
                if (centraMember != null && !centraMember.getNumber().equals(_centEntry.toCentOrgMember().getNumber())) {
                    String mem = _centEntry.getOrgRange().stream().filter(k -> k.equals(n.getNumber()) || k.startsWith(n.getNumber() + "#")).findFirst().get();
                    if (mem.contains("#")) {
                        String s2 = lastCentraMember.stream().filter(k -> k.equals(n.getNumber()) || k.startsWith(n.getNumber() + "#")).findFirst().get();
                        String tip = s2.contains("#") ? s2.split("#")[1] + "\u3001" + mem.split("#")[1] : mem.split("#")[1];
                        throw new KDBizException(ResourceUtils.moreCentral((String)controlParam.getBizModel().getName(), (String)this.getBusinessModelName(controlParam.getBizModel()), (String)mem.split("#")[0], (String)tip, (String)centraMember.getNumber(), (String)_centEntry.toCentOrgMember().getNumber()));
                    }
                    String s2 = lastCentraMember.stream().filter(k -> k.equals(n.getNumber()) || k.startsWith(n.getNumber() + "#")).findFirst().get();
                    String tip = s2.contains("#") ? s2.split("#")[1] : "";
                    throw new KDBizException(ResourceUtils.moreCentral((String)controlParam.getBizModel().getName(), (String)this.getBusinessModelName(controlParam.getBizModel()), (String)mem, (String)tip, (String)centraMember.getNumber(), (String)_centEntry.toCentOrgMember().getNumber()));
                }
                centraMember = _centEntry.toCentOrgMember();
                lastCentraMember = _centEntry.getOrgRange();
            }
        }
        return centraMember;
    }

    protected void buildControlRule(BgControlData controlData, Collection<IControlParam> controlParams) {
        BgControlRuleUtils.getInterface().queryControlRule(controlData, controlParams);
    }

    public void fillPeriodMembers(BizModel bizModel, BgControlData controlData, Collection<IControlParam> controlParams) {
        if (controlData == null || controlParams == null || controlParams.isEmpty() || bizModel == null) {
            return;
        }
        if (this.getParameter().isNotFillPeriod()) {
            return;
        }
        Map dimensionMap = bizModel.getDimensionMap();
        HashMap<String, Set<String>> memberNumMap = new HashMap<String, Set<String>>();
        String periodNum = null;
        kd.epm.eb.common.model.Dimension dimension = null;
        Member member = null;
        boolean isEbModel = bizModel.isEBByModel();
        dimension = isEbModel ? (kd.epm.eb.common.model.Dimension)dimensionMap.get(kd.epm.eb.common.enums.SysDimensionEnum.Period.getNumber()) : (kd.epm.eb.common.model.Dimension)dimensionMap.get(kd.epm.eb.common.enums.SysDimensionEnum.BudgetPeriod.getNumber());
        CalendarHelper helper = new CalendarHelper();
        for (IControlParam controlParam : controlParams) {
            helper.setTime(controlParam.getBizTime());
            int periodType = controlParam.getSetting().getPeriodType().getIndex();
            if (controlParam.getBizModel().getPeriodUtils().isPeriodUserDefine()) {
                periodNum = controlParam.getBizModel().getPeriodUtils().getPeriodNumber(periodType, controlParam.getBizTime());
            } else if (BgControlPeriodTypeEnum.MONTH.getIndex() == periodType) {
                periodNum = isEbModel ? BgPeriodUtils.getPeriodMonth((int)helper.getCurrentlyMonth()) : BgPeriodUtils.getBgPeriodMonth((int)helper.getCurrentlyYear(), (int)helper.getCurrentlyMonth());
            } else if (BgControlPeriodTypeEnum.QUARTER.getIndex() == periodType) {
                periodNum = isEbModel ? BgPeriodUtils.getPeriodQuarter((int)helper.getCurrentlyQuarter()) : BgPeriodUtils.getBgPeriodQuarter((int)helper.getCurrentlyYear(), (int)helper.getCurrentlyQuarter());
            } else if (BgControlPeriodTypeEnum.HALFYEAR.getIndex() == periodType) {
                periodNum = isEbModel ? BgPeriodUtils.getPeriodHalfYear((int)helper.getCurrentlyHalfYear()) : BgPeriodUtils.getBgPeriodHalfYear((int)helper.getCurrentlyYear(), (int)helper.getCurrentlyQuarter());
            } else if (BgControlPeriodTypeEnum.YEAR.getIndex() == periodType) {
                periodNum = BgPeriodUtils.getPeriodYear((int)helper.getCurrentlyYear());
            }
            Member period = new Member(dimension);
            period.setNumber(periodNum);
            period.setLeaf(false);
            controlParam.setMember(true, period);
            controlParam.setMember(false, period);
            this.getMembers(memberNumMap, dimension.getNumber()).add(controlParam.getMember(true, dimension.getNumber()).getNumber());
        }
        Map members = MemberServiceHelper.queryByNumber((BizModel)bizModel, (Map)dimensionMap, memberNumMap);
        kd.epm.eb.common.cache.impl.Member object = null;
        for (IControlParam controlParam : controlParams) {
            object = (kd.epm.eb.common.cache.impl.Member)((Map)members.get(dimension.getNumber())).get(controlParam.getMember(true, dimension.getNumber()).getNumber());
            if (object != null) {
                member = Member.loadFromCacheMember((kd.epm.eb.common.cache.impl.Member)object);
                member.setDimension(dimension);
                controlParam.setMember(true, member);
            } else {
                member = controlParam.getMember(true, dimension.getNumber());
                ControlException.notExistMember((String)ControlException.notExistByMember((kd.epm.eb.common.model.Dimension)dimension, (BizModel)bizModel, (Member)member));
            }
            object = (kd.epm.eb.common.cache.impl.Member)((Map)members.get(dimension.getNumber())).get(controlParam.getMember(false, dimension.getNumber()).getNumber());
            if (object != null) {
                member = Member.loadFromCacheMember((kd.epm.eb.common.cache.impl.Member)object);
                member.setDimension(dimension);
                controlParam.setMember(false, member);
                continue;
            }
            member = controlParam.getMember(false, dimension.getNumber());
            ControlException.notExistMember((String)ControlException.notExistByMember((kd.epm.eb.common.model.Dimension)dimension, (BizModel)bizModel, (Member)member));
        }
    }

    protected void buildProcess(BgControlData controlData, Collection<IControlParam> controlParams) {
        if (controlParams == null || controlParams.isEmpty()) {
            return;
        }
        if (this.getParameter().isNeedMappingData()) {
            if (!this.getParameter().getDataManager().getExeApplyFields().isEmpty()) {
                BgControlLogUtils.info(controlData.getStats(), true, "queryMappings-getExeApplyFields=" + JSONUtils.toString(this.getParameter().getDataManager().getExeApplyFields()));
                this.getParameter().getControlManager().setExecute(true);
                this.getParameter().getControlManager().setOccupation(true);
                this.getParameter().getDataManager().getApplyFields().clear();
                this.getParameter().getDataManager().getApplyFields().addAll(this.getParameter().getDataManager().getExeApplyFields());
                BgControlProcessUtils.buildProcess(this.getParameter(), controlData, controlParams);
                for (IControlParam param : controlParams) {
                    param.setExeAmount(param.getAmount());
                }
            }
            if (!this.getParameter().getDataManager().getOccApplyFields().isEmpty()) {
                BgControlLogUtils.info(controlData.getStats(), true, "queryMappings-getOccApplyFields=" + JSONUtils.toString(this.getParameter().getDataManager().getOccApplyFields()));
                this.getParameter().getControlManager().setExecute(false);
                this.getParameter().getControlManager().setOccupation(true);
                this.getParameter().getDataManager().getApplyFields().clear();
                this.getParameter().getDataManager().getApplyFields().addAll(this.getParameter().getDataManager().getOccApplyFields());
                BgControlProcessUtils.buildProcess(this.getParameter(), controlData, controlParams);
                for (IControlParam param : controlParams) {
                    param.setOccAmount(param.getAmount());
                }
            }
        } else {
            BgControlProcessUtils.buildProcess(this.getParameter(), controlData, controlParams);
        }
    }

    private String getBusinessModelName(BizModel bizModel) {
        DynamicObject bussObj;
        if (CommonUtils.isBgmdModel((Long)bizModel.getId()) && (bussObj = BusinessDataServiceHelper.loadSingle((Object)bizModel.getControlBusModelId(), (String)"eb_businessmodel", (String)"id,name")) != null) {
            return bussObj.getString("name");
        }
        return null;
    }
}

