/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.Format;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.ChangeTypeServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.LogUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.control.ConditionUtils;
import kd.epm.eb.common.utils.obj.ObjectUtils;
import kd.epm.eb.control.eums.ControlLogTypeEnum;
import kd.epm.eb.control.eums.ControlTypeEnum;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.WriteOff;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlUtils;

public class BgControlProcessUtils {
    private static final LogUtils log = LogUtils.getInstance(BgControlProcessUtils.class);
    private static final String FIELD = "id, org.id, org.number, org.name, controlprocess.id,controlprocess.number,controlprocess.entryentity.runoperation, controlprocess.entryentity.runvalue, controlprocess.entryentity.takeoperation, controlprocess.entryentity.takevalue, controlprocess.entryentity.writeoffscheme,controlprocess.entryentity.serqfilter,controlprocess.entryentity.condition,controlprocess.entryentity.priority";

    public static void queryProcessSet(IControlParameter parameter, BgControlData controlData, Set<Long> orgIds, LogStats logStats) {
        if (parameter == null || StringUtils.isEmpty((String)parameter.getEntityNumber()) || controlData == null || orgIds == null) {
            return;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("org", "in", orgIds));
        builder.add(new QFilter("controlprocess.entryentity.bill.fieldtable", "=", (Object)parameter.getEntityNumber()));
        builder.add(new QFilter("controlprocess.enable", "=", (Object)Character.valueOf('1')));
        List processes = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryProcessFields", (String)"eb_bgcontrolprocessorg", (String)FIELD, (QFilter[])builder.toArrays(), null);){
            processes = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        if (processes == null || processes.isEmpty()) {
            return;
        }
        Set<String> applyFields = parameter.getDataManager().getApplyFields();
        String operation = parameter.getOperation() != null ? parameter.getOperation().trim() : "";
        String[] orgNumbers = controlData.getBizOrgUnit().getLongNumber().split("!");
        if (orgNumbers == null || orgNumbers.length == 0) {
            return;
        }
        Map<Object, List<Map>> orgProcessMap = processes.stream().collect(Collectors.groupingBy(k -> k.getOrDefault("org.number", "default")));
        List<Object> currentProcessList = Lists.newArrayList();
        block9: for (int i = orgNumbers.length - 1; i >= 0 && (currentProcessList == null || currentProcessList.isEmpty()); --i) {
            String orgNumber = orgNumbers[i];
            currentProcessList = orgProcessMap.get(orgNumber);
            if (currentProcessList == null || currentProcessList.isEmpty()) continue;
            logStats.addInfo("processschema.number" + ((Map)currentProcessList.get(0)).get("controlprocess.number"));
            currentProcessList.sort((o1, o2) -> {
                String priority2;
                String priority1 = o1.getOrDefault("controlprocess.entryentity.priority", "0");
                if (priority1.equals(priority2 = o2.getOrDefault("controlprocess.entryentity.priority", "0"))) {
                    return 0;
                }
                if ("0".equals(priority1) || "".equals(priority1)) {
                    return 1;
                }
                if ("0".equals(priority2) || "".equals(priority2)) {
                    return -1;
                }
                return Integer.parseInt(priority2.toString()) - Integer.parseInt(priority1.toString());
            });
            for (Map map : currentProcessList) {
                String occOperation = (String)map.get("controlprocess.entryentity.takeoperation");
                String occValueField = (String)map.get("controlprocess.entryentity.takevalue");
                String exeOperation = (String)map.get("controlprocess.entryentity.runoperation");
                String exeValueField = (String)map.get("controlprocess.entryentity.runvalue");
                String serqfilter = (String)map.get("controlprocess.entryentity.serqfilter");
                String condition = (String)map.get("controlprocess.entryentity.condition");
                if (controlData.getProcess() != null && !controlData.getProcess().isEmpty()) continue block9;
                if (!StringUtils.isEmpty((String)serqfilter) && !BgControlProcessUtils.ispattern(serqfilter, parameter).booleanValue()) continue;
                logStats.addInfo("get control  process " + condition);
                controlData.setProcess(map);
                if (parameter.isNeedMappingData()) {
                    if (StringUtils.isNotEmpty((String)occOperation) && StringUtils.isNotEmpty((String)occValueField)) {
                        parameter.getDataManager().getOccApplyFields().add(occValueField);
                        parameter.setOperation(occOperation);
                        applyFields.add(occValueField);
                    }
                    if (!StringUtils.isNotEmpty((String)exeOperation) || !StringUtils.isNotEmpty((String)exeValueField)) continue;
                    parameter.getDataManager().getExeApplyFields().add(exeValueField);
                    if (!applyFields.isEmpty()) continue;
                    parameter.setOperation(exeOperation);
                    applyFields.add(exeValueField);
                    continue;
                }
                if (parameter.getControlManager().isStandard()) {
                    Set<String> operations;
                    if (applyFields.isEmpty() && StringUtils.isNotEmpty((String)exeOperation) && StringUtils.isNotEmpty((String)exeValueField) && (operations = BgControlProcessUtils.getOperations(exeOperation)).contains(operation)) {
                        parameter.getControlManager().setExecute(true);
                        applyFields.add(exeValueField);
                        BgControlProcessUtils.setWriteOffInfo(parameter, map);
                    }
                    if (applyFields.isEmpty() && StringUtils.isNotEmpty((String)occOperation) && StringUtils.isNotEmpty((String)occValueField) && (operations = BgControlProcessUtils.getOperations(occOperation)).contains(operation)) {
                        parameter.getControlManager().setOccupation(true);
                        applyFields.add(occValueField);
                        BgControlProcessUtils.setWriteOffInfo(parameter, map);
                    }
                    if (!applyFields.isEmpty()) continue;
                    if (StringUtils.isNotEmpty((String)exeValueField) && exeValueField.contains(".")) {
                        applyFields.add(exeValueField);
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((String)occValueField) || !occValueField.contains(".")) continue;
                    applyFields.add(occValueField);
                    continue;
                }
                String valueProp = null;
                String operationProp = null;
                if (parameter.getControlManager().isOccupation()) {
                    operationProp = StringUtils.isEmpty((String)parameter.getOperation()) ? occOperation : parameter.getOperation();
                    valueProp = occValueField;
                } else if (parameter.getControlManager().isExecute()) {
                    operationProp = StringUtils.isEmpty((String)parameter.getOperation()) ? exeOperation : parameter.getOperation();
                    valueProp = exeValueField;
                }
                if (!StringUtils.isNotEmpty(operationProp) || !StringUtils.isNotEmpty((String)valueProp)) continue;
                parameter.setOperation(operationProp);
                applyFields.add(valueProp);
                BgControlProcessUtils.setWriteOffInfo(parameter, map);
            }
        }
        if ("gl_voucher".equals(parameter.getEntityNumber())) {
            if (applyFields.contains("entries.debitlocal")) {
                applyFields.add("entries.creditlocal");
            } else if (applyFields.contains("entries.creditlocal")) {
                applyFields.add("entries.debitlocal");
            } else if (applyFields.contains("entries.debitori")) {
                applyFields.add("entries.creditori");
            } else if (applyFields.contains("entries.creditori")) {
                applyFields.add("entries.debitori");
            }
        }
    }

    private static void setWriteOffInfo(IControlParameter parameter, Map<String, Object> process) {
        Long _writeOffId;
        if (parameter == null || process == null) {
            return;
        }
        Object writeOffId = process.get("controlprocess.entryentity.writeoffscheme");
        if (writeOffId instanceof Long && (_writeOffId = (Long)writeOffId) != 0L) {
            DynamicObject writeOff = BusinessDataServiceHelper.loadSingleFromCache((Object)_writeOffId, (String)"eb_writeoffscheme_pro", (String)"id, number, name, writeoffinfo.id, writeoffinfo.writeoffbill, writeoffinfo.writeoffbill.number, writeoffinfo.writeofftype, writeoffinfo.writeoffsourcebill, writeoffinfo.writeoffsourcebill.number, writeoffinfo.writeoffentry, writeoffinfo.writeoffentry.number, writeoffinfo.writeoffvalue, writeoffinfo.writeoffvalue.number, writeoffinfo.writeoffsourcebillentry, writeoffinfo.writeoffsourcebillentry.number");
            parameter.getDataManager().setWriteOff(WriteOff.of(writeOff));
        }
    }

    public static void buildProcess(IControlParameter parameter, BgControlData controlData, Collection<IControlParam> controlParams) {
        boolean hasVoucher;
        if (parameter == null || StringUtils.isEmpty((String)parameter.getEntityNumber()) || controlData == null || controlParams == null) {
            ControlException.errorControlParameter();
            return;
        }
        if (controlParams.isEmpty()) {
            return;
        }
        if (parameter.getControlManager().isQueryBalance() && !parameter.isNeedMappingData()) {
            return;
        }
        if (parameter.getControlManager().isStandard() && StringUtils.isEmpty((String)parameter.getOperation())) {
            return;
        }
        HashMap<Long, Map> changeTypeMap = new HashMap<Long, Map>();
        if (controlData.getProcess() == null) {
            ControlException.notProcessSet((String)controlData.getBizModels().values().iterator().next().getName(), (String)controlData.getBizOrgUnit().getNumber());
        }
        String defApplyField = null;
        String borrow = "";
        String lend = "";
        String accountDc = null;
        String entryDc = null;
        Set<String> applyFields = parameter.getDataManager().getApplyFields();
        if (applyFields.size() == 1) {
            defApplyField = parameter.getDataManager().getApplyFields().iterator().next();
        }
        if (hasVoucher = "gl_voucher".equals(parameter.getEntityNumber())) {
            if (applyFields.contains("entries.debitlocal") || applyFields.contains("entries.creditlocal")) {
                borrow = "entries.debitlocal";
                lend = "entries.creditlocal";
            } else if (applyFields.contains("entries.debitori") || applyFields.contains("entries.creditori")) {
                borrow = "entries.debitori";
                lend = "entries.creditori";
            }
        }
        ControlTypeEnum ctrlType = parameter.getControlManager().isOccupation() ? ControlTypeEnum.OCCUPATION : ControlTypeEnum.EXECUTE;
        String ctType = parameter.getControlManager().isOccupation() ? "Occupation" : "Execute";
        for (IControlParam controlParam : controlParams) {
            BillFieldTypeEmum operation;
            BizModel bizModel;
            if (controlParam == null || controlParam.getBizModel() == null || (bizModel = controlData.getBizModels().get(controlParam.getBizModel().getKey())) == null) continue;
            Dimension ctDimension = (Dimension)bizModel.getDimensionMap().get(SysDimensionEnum.ChangeType.getNumber());
            controlParam.setControlType(ctrlType);
            Object object = parameter.getControlManager().isOccupation() ? BillFieldTypeEmum.TAKEOPERATION : (operation = parameter.getControlManager().isExecute() ? BillFieldTypeEmum.RUNOPERATION : null);
            if (operation != null && controlParam.getControlScheme() != null) {
                String applyField = controlParam.getControlScheme().getControlValue(String.valueOf(operation.getIndex()), parameter.getOperation());
                if (applyField != null) {
                    controlParam.setApplyField(applyField);
                } else {
                    controlParam.setApplyField(defApplyField);
                }
            } else {
                controlParam.setApplyField(defApplyField);
            }
            Map changeTypes = changeTypeMap.computeIfAbsent(controlParam.getBizModel().getId(), f -> new HashMap());
            Member ctMember = (Member)changeTypes.get(ctType);
            if (ctMember == null) {
                kd.epm.eb.common.cache.impl.Member ct = parameter.getDataManager().getModelMembers().get(controlParam.getBizModel().getId()).get(SysDimensionEnum.ChangeType.getNumber()).get(ctType);
                if (ct == null) {
                    Map maps = ChangeTypeServiceHelper.getOccupy((BizModel)controlParam.getBizModel());
                    ctMember = Member.loadFromDynamicObject((Map)maps);
                } else {
                    ctMember = Member.loadFromCacheMember((kd.epm.eb.common.cache.impl.Member)ct);
                }
            }
            if (ctMember == null) continue;
            ctMember.setDimension(ctDimension);
            controlParam.setMember(false, ctMember);
        }
        StringBuilder values = new StringBuilder();
        Format formuat = BgControlUtils.getDecimalFormatByInternetSet();
        for (IControlParam controlParam : controlParams) {
            Object value;
            if (controlParam.isOnlyCheck()) {
                controlParam.setAmend(BigDecimal.ZERO);
                controlParam.setAmount(BigDecimal.ZERO);
                continue;
            }
            accountDc = (String)controlParam.getPropValueMap().get("entries.account.dc");
            entryDc = (String)controlParam.getPropValueMap().get("entries.entrydc");
            BigDecimal applyValue = null;
            if (hasVoucher) {
                if (StringUtils.isEmpty((String)defApplyField) && (StringUtils.isEmpty((String)borrow) || StringUtils.isEmpty((String)lend))) {
                    ControlException.errorProcessSet();
                } else if (StringUtils.isEmpty((String)entryDc)) {
                    ControlException.errorEntryDc();
                } else if (StringUtils.isNotEmpty((String)defApplyField)) {
                    value = controlParam.getPropValueMap().get(defApplyField);
                    if (value != null) {
                        applyValue = ConvertUtils.toDecimal((Object)value);
                    }
                } else {
                    Object _lValue;
                    Object _bValue = controlParam.getPropValueMap().get(borrow);
                    if (_bValue == null) {
                        _bValue = controlParam.getPropValueMap().get(borrow.toLowerCase());
                    }
                    if ((_lValue = controlParam.getPropValueMap().get(lend)) == null) {
                        _lValue = controlParam.getPropValueMap().get(lend.toLowerCase());
                    }
                    BigDecimal bValue = ConvertUtils.toDecimal((Object)_bValue);
                    BigDecimal lValue = ConvertUtils.toDecimal((Object)_lValue);
                    applyValue = BgControlProcessUtils.getVoucherValue(entryDc, accountDc, bValue, lValue);
                }
            } else if (StringUtils.isNotEmpty((String)controlParam.getApplyField())) {
                value = controlParam.getPropValueMap().get(controlParam.getApplyField());
                if (value == null) {
                    value = controlParam.getPropValueMap().get(controlParam.getApplyField().toLowerCase());
                }
                if (value == null && !parameter.getControlManager().isQueryBalance()) {
                    log.warn("budget-control-log : ", "appley value is null(" + controlParam.getApplyField() + ").");
                }
                applyValue = ConvertUtils.toDecimal((Object)value);
            } else {
                ControlException.errorProcessSet();
            }
            if (applyValue == null) {
                applyValue = BigDecimal.ZERO;
            }
            if (values.length() > 0) {
                values.append(", ");
            }
            values.append(formuat.format(applyValue));
            controlParam.setAmount(applyValue);
            controlParam.setAmend(applyValue);
        }
        if (controlData != null && LogStats.isNeedDetailLog((LogStats)controlData.getStats())) {
            String typeAlias;
            ControlLogTypeEnum logType = parameter.getControlManager().isOccupation() ? ControlLogTypeEnum.CONTROLPROCESSVALUEOCC : ControlLogTypeEnum.CONTROLPROCESSVALUEEXECUTE;
            String string = typeAlias = parameter.getControlManager().isOccupation() ? ControlTypeEnum.OCCUPATION.getAlias() : ControlTypeEnum.EXECUTE.getAlias();
            if (StringUtils.isEmpty((String)defApplyField)) {
                String empty = ResManager.loadKDString((String)"\u7a7a", (String)"ControlLog_Null", (String)"epm-eb-business", (Object[])new Object[0]);
                BgControlLogUtils.addDetail(controlData.getStats(), logType, 1, "", ResManager.loadResFormat((String)"%1\u53d6\u503c\uff1a%2 - %3", (String)"ControlLog_ProcessValue", (String)"epm-eb-business", (Object[])new Object[]{typeAlias, empty, values.toString()}), null, false);
            } else {
                BgControlLogUtils.addDetail(controlData.getStats(), logType, 0, "", ResManager.loadResFormat((String)"%1\u53d6\u503c\uff1a%2 - %3", (String)"ControlLog_ProcessValue", (String)"epm-eb-business", (Object[])new Object[]{typeAlias, BgControlLogUtils.getBizRegName(parameter.getEntityNumber(), defApplyField, BillFieldTypeEmum.CONTROLVALUE.getNumber()), values.toString()}), null, false);
            }
        }
    }

    private static BigDecimal getVoucherValue(String entryDc, String accountDc, BigDecimal bValue, BigDecimal lValue) {
        if (entryDc == null || accountDc == null || bValue == null || lValue == null) {
            return null;
        }
        BigDecimal applyValue = bValue.subtract(lValue);
        if ("-1".equals(accountDc)) {
            applyValue = applyValue.multiply(BgBaseConstant.NEG_ONE);
        }
        return applyValue;
    }

    public static Set<String> getOperations(String operation) {
        if (StringUtils.isEmpty((String)operation)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> operations = new LinkedHashSet<String>();
        String[] _operations = operation.replaceAll("\uff0c", ",").split(",");
        if (_operations != null) {
            for (String _operation : _operations) {
                operations.add(_operation.trim());
            }
        }
        return operations;
    }

    public static Set<String> getCondProperty(QFilter qFilter) {
        LinkedHashSet properties = Sets.newLinkedHashSet();
        properties.add(qFilter.getProperty());
        Iterator iterator = qFilter.getNests(true).iterator();
        while (iterator.hasNext()) {
            properties.add(((QFilter.QFilterNest)iterator.next()).getFilter().getProperty());
        }
        return properties;
    }

    private static List<Map<String, Object>> getPropsMap(IControlParameter parameter, Set<String> fields) {
        List<Map<String, Object>> propsMap = new LinkedList<Map<String, Object>>();
        DynamicObject model = null;
        QFilter[] qFilter = new QFilter[]{new QFilter("id", "=", (Object)parameter.getBizId())};
        if (parameter.getControlManager().isStandard()) {
            try {
                qFilter = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(parameter.getBizId()))};
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (parameter.getBizObj() == null) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBizBill", (String)parameter.getEntityNumber(), (String)StringUtils.join(fields, (String)","), (QFilter[])qFilter, null);){
                propsMap.addAll(CommonServiceHelper.transDataSet((DataSet)ds));
            }
        } else {
            model = ObjectUtils.filterObject((DynamicObject)parameter.getBizObj(), (QFilter[])qFilter, (boolean)true);
            if (model != null) {
                propsMap = ObjectUtils.toMap((DynamicObject)model, (String[])fields.toArray(new String[0]));
            }
        }
        return propsMap;
    }

    private static Boolean ispattern(String serqfilter, IControlParameter parameter) {
        FlexBDValueCondition flexBDValueCondition = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)serqfilter, FlexBDValueCondition.class);
        FilterBuilder filterBuilder = ConditionUtils.get().getFilterBuilder(parameter.getEntityNumber(), flexBDValueCondition.getFilterCondition());
        QFilter qFilter = filterBuilder.getFilterObject().getFilterResult().getQFilter();
        if (qFilter == null) {
            return Boolean.FALSE;
        }
        Set<String> fields = BgControlProcessUtils.getCondProperty(qFilter);
        if (!parameter.getControlManager().isStandard()) {
            return Boolean.TRUE;
        }
        List<Map<String, Object>> propsMap = BgControlProcessUtils.getPropsMap(parameter, fields);
        ConditionUtils utils = ConditionUtils.get();
        ConditionUtils.QFilterEvaluator evaluator = new ConditionUtils.QFilterEvaluator();
        for (Map<String, Object> variable : propsMap) {
            evaluator.setValues(variable);
            if (!utils.run(qFilter, evaluator)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

