/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.constant.BgControlConstant;
import kd.epm.eb.common.ebcommon.common.Tuple;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.model.OlapData;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.permission.pojo.UserInfo;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.control.eums.ControlResultEnum;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.olap.OlapServiceCaller;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.impl.utils.KDOlapRequestUtils;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;

public class BgControlRecordUtils {
    private static final Log log = LogFactory.getLog(BgControlRecordUtils.class);
    private static final Map<String, String> EB_RECORD_FIELDS = new HashMap<String, String>();
    private static final Map<String, String> BgMd_RECORD_FIELDS = new HashMap<String, String>();
    private static final Map<String, String> RECORD_PROPS = new HashMap<String, String>();

    public static Map<String, String> getRecordFields() {
        return EB_RECORD_FIELDS;
    }

    public static Map<String, String> getBgMdRecordFields() {
        return BgMd_RECORD_FIELDS;
    }

    public static Map<String, String> getCommFields(BizModel model) {
        if (model.isEBByModel()) {
            return BgControlRecordUtils.getRecordFields();
        }
        return BgControlRecordUtils.getBgMdRecordFields();
    }

    public static Map<String, String> getCommFields(Model model) {
        if (model.isModelByEB()) {
            return BgControlRecordUtils.getRecordFields();
        }
        return BgControlRecordUtils.getBgMdRecordFields();
    }

    public static Map<String, String> getRecordProps() {
        return RECORD_PROPS;
    }

    public static void delete(String entityNumber, String bizId, Set<String> crTables) {
        if (entityNumber == null || bizId == null) {
            return;
        }
        if (crTables == null || crTables.isEmpty()) {
            DB.execute((DBRoute)BgBaseConstant.epm, (String)"delete from t_eb_bgcontrolrecord where fbizid = ?", (Object[])new Object[]{bizId});
        } else {
            for (String crTable : crTables) {
                BgControlRecordUtils.execute(BgBaseConstant.epm, "delete from " + crTable + " where fbizid = ?", new Object[]{bizId});
            }
        }
        DB.execute((DBRoute)BgBaseConstant.epm, (String)"delete from t_eb_bgcontrolindex where fentityNumber = ? and fbizid = ?", (Object[])new Object[]{entityNumber, bizId});
    }

    public static void delete(Set<BgControlRecord> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        String crTable = null;
        HashMap<String, List> recordMap = new HashMap<String, List>(records.size());
        for (BgControlRecord bgControlRecord : records) {
            crTable = bgControlRecord.getBizModel().isEBByModel() ? "t_eb_bgcontrolrecord" : BgControlUtils.getBgControlRecordTable(bgControlRecord.getModelId(), bgControlRecord.getBizModel().getControlBusModelId());
            List rds = recordMap.getOrDefault(crTable, new ArrayList());
            rds.add(new Object[]{bgControlRecord.getBizId(), bgControlRecord.getId()});
            recordMap.put(crTable, rds);
        }
        for (Map.Entry entry : recordMap.entrySet()) {
            BgControlRecordUtils.batchExecute(DBRoute.of((String)"epm"), "delete from " + (String)entry.getKey() + " where fbizid = ? and fid =?;", (List)entry.getValue());
        }
    }

    private static boolean execute(DBRoute dbRoute, String sql, Object[] params) {
        return DB.execute((DBRoute)dbRoute, (String)sql, (Object[])params);
    }

    private static int[] batchExecute(DBRoute dbRoute, String sql, List<Object[]> params) {
        return DB.executeBatch((DBRoute)dbRoute, (String)sql, params);
    }

    public static StringBuilder getSql(BizModel model) {
        StringBuilder sql = new StringBuilder();
        if (model.isEBByModel()) {
            sql.append("select fid, fmodelid, fbizid, frefbizid, fentitynumber, fbiznumber, foperation, fserialtextjson, freqorgunitid, forgunitid, freqaccountid, faccountid, fbgperiodid, fyearid, fperiodid, foccperiodid,focctype,fbgmemberjson, fcurrencyid, fscenarioid, fversionid, faudittrailid, ficid, fctid, fdatatypeid, fprocessid, fmetricid, fuserdefinedid1, fuserdefinedid2, fuserdefinedid3, fuserdefinedid4, fuserdefinedid5, fuserdefinedid6, fuserdefinedid7, fuserdefinedid8, fuserdefinedid9, fuserdefinedid10, famount,fentryid,fruleid,fcreatetime,frequestId,fstatus,fwriteofftype,frefentryid");
        } else {
            sql.append("select fid, fmodelid, fbizid, frefbizid, fentitynumber, fbiznumber, foperation, fserialtextjson, freqorgunitid, forgunitid, freqaccountid, faccountid, fbgperiodid, foccperiodid,focctype,fbgmemberjson, fcurrencyid, fversionid, fatid, fctid, fdtid, fmetricid, fentryid,fruleid,fcreatorid,fcreatetime,frequestId,fstatus,fwriteofftype,frefentryid,");
            for (kd.epm.eb.common.model.Dimension dimension : model.getDimensions()) {
                if (BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension)) {
                    sql.append(BgControlUtils.getUserDefinedIdField(dimension)).append(',');
                    continue;
                }
                if (!SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) continue;
                sql.append(BgControlRecordUtils.getBgMdRecordFields().get(dimension.getNumber())).append(',');
            }
            sql.append("famount");
        }
        sql.append(" from ").append(model.getBgControlRecordTable());
        BgControlRecordUtils.checkExistOccTypeByRecord(model.getBgControlRecordTable());
        return sql;
    }

    public static List<BgControlRecord> query(Set<String> bizIds) {
        ArrayList<BgControlRecord> records = new ArrayList<BgControlRecord>();
        if (bizIds == null || bizIds.isEmpty()) {
            return records;
        }
        HashSet crTables = Sets.newHashSet();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select ftable from ", new Object[0]).append("t_eb_bgcontrolindex", new Object[0]).append(" where ", new Object[0]);
        sql.appendIn("fbizid", bizIds.toArray(new Object[bizIds.size()]));
        DataSet ds = DB.queryDataSet((String)"queryIndex", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        Object object = null;
        try {
            for (Row row : ds) {
                crTables.add(row.getString("ftable"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        crTables.add("t_eb_bgcontrolrecord");
        LinkedHashMap models = Maps.newLinkedHashMap();
        for (String crTable : crTables) {
            BgControlRecordUtils.queryModels(bizIds, crTable, models);
        }
        return BgControlRecordUtils.query(bizIds, (Map<Long, BizModel>)models);
    }

    private static void queryModels(Set<String> bizIds, String crTable, Map<Long, BizModel> models) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fmodelid from ", new Object[0]).append(crTable, new Object[0]).append(" where ", new Object[0]);
        sql.appendIn("fbizid", bizIds.toArray(new Object[bizIds.size()]));
        sql.append(" group by fmodelid", new Object[0]);
        HashMap<Long, DynamicObject> modelObjs = new HashMap<Long, DynamicObject>(10);
        DynamicObject bizObj = null;
        try (DataSet ds = DB.queryDataSet((String)"queryModelId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            for (Row row : ds) {
                bizObj = modelObjs.computeIfAbsent(row.getLong("fmodelid"), f -> ModelUtils.getModel((Long)row.getLong("fmodelid")));
                BizModel model = new BizModel(bizObj);
                if (!model.isEBByModel() && crTable != null && crTable.startsWith("t_eb_cr")) {
                    model.setControlBusModelId(Long.valueOf(crTable.replaceFirst("t_eb_cr", "")));
                }
                models.put(model.getKey(), model);
            }
        }
    }

    public static List<BgControlRecord> query(String bizId, Map<Long, BizModel> models) {
        LinkedList<BgControlRecord> records = new LinkedList<BgControlRecord>();
        if (bizId == null) {
            return records;
        }
        HashSet<String> bizIds = new HashSet<String>();
        bizIds.add(bizId);
        return BgControlRecordUtils.query(bizIds, models);
    }

    public static List<BgControlRecord> query(String bizId, Map<Long, Set<Long>> bizModelMap, Map<Long, BizModel> bizModels, boolean hasRefBill) {
        LinkedList<BgControlRecord> records = new LinkedList<BgControlRecord>();
        if (bizId == null || bizModelMap.isEmpty()) {
            return records;
        }
        HashSet<String> bizIds = new HashSet<String>();
        bizIds.add(bizId);
        for (Map.Entry<Long, Set<Long>> entry : bizModelMap.entrySet()) {
            DynamicObject bizModelObj = ModelUtils.getModel((Long)entry.getKey());
            BizModel bizModel = new BizModel(bizModelObj);
            if (bizModel.isEBByModel()) {
                bizModels.put(bizModel.getKey(), bizModel);
                continue;
            }
            for (Long busModelId : entry.getValue()) {
                bizModel = new BizModel(bizModelObj);
                bizModel.setControlBusModelId(busModelId);
                bizModels.put(bizModel.getKey(), bizModel);
            }
        }
        return BgControlRecordUtils.query(bizIds, bizModels, hasRefBill);
    }

    public static List<BgControlRecord> query(Set<String> bizIds, Map<Long, BizModel> models) {
        return BgControlRecordUtils.query(bizIds, models, false);
    }

    public static List<BgControlRecord> query(Set<String> bizIds, Map<Long, BizModel> models, boolean hasRefBill) {
        LinkedList<BgControlRecord> records = new LinkedList<BgControlRecord>();
        if (bizIds == null || bizIds.isEmpty()) {
            return records;
        }
        Long modelId = null;
        BizModel model = null;
        Map<String, String> fields = null;
        LinkedHashMap<Long, Map<String, Set<Long>>> bizModelIdsMap = new LinkedHashMap<Long, Map<String, Set<Long>>>();
        for (Map.Entry<Long, BizModel> entry : models.entrySet()) {
            modelId = entry.getKey();
            model = entry.getValue();
            if (model == null) {
                model = new BizModel(ModelUtils.getModel((Long)modelId));
                entry.setValue(model);
            }
            modelId = model.getId();
            if (model.getDimensions() == null || model.getDimensions().isEmpty()) {
                BgControlUtils.queryControlDimension(model);
                List dimensions = BgDimensionServiceHelper.getDimensionByModel((BizModel)model, (boolean)false);
                dimensions = model.filterControlDims(dimensions);
                model.setDimension(dimensions);
            }
            StringBuilder basesql = BgControlRecordUtils.getSql(model);
            ArrayList<String> sqlParams = new ArrayList<String>(bizIds);
            StringBuilder sql = new StringBuilder(basesql);
            sql.append(" where fbizid in (").append(SqlBatchUtils.getBatchParamsSql((int)bizIds.size())).append(")");
            if (hasRefBill) {
                sql.append(" union ").append((CharSequence)basesql).append(" where frefbizid in (").append(SqlBatchUtils.getBatchParamsSql((int)bizIds.size())).append(")");
                sqlParams.addAll(bizIds);
            }
            DataSet ds = BgControlRecordUtils.queryDataSet("queryControlRecord", BgBaseConstant.epm, sql.toString(), sqlParams.toArray());
            Throwable throwable = null;
            try {
                if (ds == null) continue;
                String field = null;
                Row row = null;
                BgControlRecord record = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    record = new BgControlRecord();
                    record.setId(row.getLong("fid"));
                    record.setModelId(row.getLong("fmodelid"));
                    if (!modelId.equals(record.getModelId())) continue;
                    record.setEntityNumber(row.getString("fentitynumber"));
                    record.setBizId(row.getString("fbizid"));
                    record.setBizNumber(row.getString("fbiznumber"));
                    record.setOperation(row.getString("foperation"));
                    record.setAmount(row.getBigDecimal("famount"));
                    record.setBizModel(model);
                    record.setRefBizId(row.getString("frefbizid"));
                    record.setOccPeriod(new Member(row.getLong("foccperiodid")));
                    record.setOccType(row.getString("focctype"));
                    record.setBgMemberJson(row.getString("fbgmemberjson"));
                    record.setRequestId(row.getString("frequestId"));
                    record.setStatus(row.getString("fstatus"));
                    record.setWriteOffType(row.getString("fwriteofftype"));
                    record.setRefEntryId(row.getString("frefentryid"));
                    record.setReqOrgUnit(new Member(row.getLong("freqorgunitid")));
                    record.setReqAccount(new Member(row.getLong("freqaccountid")));
                    fields = BgControlRecordUtils.getCommFields(model);
                    for (kd.epm.eb.common.model.Dimension dimension : model.getDimensions()) {
                        field = BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension) ? BgControlUtils.getUserDefinedIdField(dimension) : fields.get(dimension.getNumber());
                        record.setMemberId(dimension.getNumber(), row.getLong(field));
                    }
                    record.setEntryId(row.getString("fentryid"));
                    record.setCreateTime(row.getDate("fcreatetime"));
                    record.setSetting(row.getLong("fruleid"));
                    records.add(record);
                    BgControlRecordUtils.buildQueryMap(bizModelIdsMap, record);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        BgControlRecordUtils.queryMember(records, bizModelIdsMap);
        return records;
    }

    private static DataSet queryDataSet(String algoKey, DBRoute dbRoute, String sql, Object[] params) {
        return DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)sql, (Object[])params);
    }

    private static void queryMember(List<BgControlRecord> bgRecords, Map<Long, Map<String, Set<Long>>> bizModelIdsMap) {
        if (bgRecords == null || bgRecords.isEmpty()) {
            return;
        }
        Map<String, Set<Long>> memberIdsMap = null;
        BizModel bizModel = null;
        Long memberId = null;
        if (bizModelIdsMap == null) {
            bizModelIdsMap = new LinkedHashMap<Long, Map<String, Set<Long>>>(16);
            for (BgControlRecord record : bgRecords) {
                BgControlRecordUtils.buildQueryMap(bizModelIdsMap, record);
            }
        }
        LinkedHashMap bizModelMap = new LinkedHashMap();
        HashMap membersMap = null;
        HashMap members = null;
        Member member = null;
        for (BgControlRecord record : bgRecords) {
            bizModel = record.getBizModel();
            memberIdsMap = bizModelIdsMap.get(bizModel.getKey());
            membersMap = (HashMap)bizModelMap.get(bizModel.getKey());
            if (membersMap == null) {
                Map _membersMap = MemberServiceHelper.queryByIds((Map)bizModel.getDimensionMap(), memberIdsMap);
                membersMap = new HashMap(_membersMap == null ? 10 : _membersMap.size());
                if (_membersMap != null) {
                    for (Map.Entry entry : _membersMap.entrySet()) {
                        members = new HashMap(entry.getValue() == null ? 10 : ((Map)entry.getValue()).size());
                        membersMap.put(entry.getKey(), members);
                        for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                            members.put(entry1.getKey(), Member.loadFromDynamicObject((DynamicObject)((DynamicObject)entry1.getValue())));
                        }
                    }
                }
                bizModelMap.put(bizModel.getKey(), membersMap);
            }
            for (kd.epm.eb.common.model.Dimension dimension : bizModel.getDimensions()) {
                members = (HashMap)membersMap.get(dimension.getNumber());
                if (members == null) {
                    ControlException.errorQueryRecordMember((String)dimension.getNumber());
                    return;
                }
                member = (Member)members.get(record.getMemberId(dimension.getNumber()));
                if (member == null) {
                    ControlException.errorQueryRecordMember((String)dimension.getNumber());
                    return;
                }
                member.setDimension(dimension);
                record.setMember(member);
                if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                    memberId = record.getReqOrgUnitId();
                    if (memberId != null && memberId != 0L && (member = (Member)members.get(memberId)) != null) {
                        member.setDimension(dimension);
                        record.setReqOrgUnit(member);
                    }
                } else if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) && (memberId = record.getReqAccountId()) != null && memberId != 0L && (member = (Member)members.get(memberId)) != null) {
                    member.setDimension(dimension);
                    record.setReqAccount(member);
                }
                if ((record.getOccPeriodId() == null || record.getOccPeriodId() == 0L || !SysDimensionEnum.Period.getNumber().equals(dimension.getNumber())) && !SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber()) || (member = (Member)members.get(memberId = record.getOccPeriodId())) == null) continue;
                member.setDimension(dimension);
                record.setOccPeriod(member);
            }
        }
    }

    private static void buildQueryMap(Map<Long, Map<String, Set<Long>>> bizModelIdsMap, BgControlRecord record) {
        BizModel bizModel = record.getBizModel();
        Map memberIdsMap = bizModelIdsMap.computeIfAbsent(bizModel.getKey(), k -> Maps.newLinkedHashMap());
        for (kd.epm.eb.common.model.Dimension dimension : bizModel.getDimensions()) {
            Long memberId;
            HashSet<Long> memberIds = (HashSet<Long>)memberIdsMap.get(dimension.getNumber());
            if (memberIds == null) {
                memberIds = new HashSet<Long>();
                memberIdsMap.put(dimension.getNumber(), memberIds);
            }
            memberIds.add(record.getMemberId(dimension.getNumber()));
            if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                memberId = record.getReqOrgUnitId();
                if (memberId != null && memberId != 0L) {
                    memberIds.add(memberId);
                }
            } else if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) && (memberId = record.getReqAccountId()) != null && memberId != 0L) {
                memberIds.add(memberId);
            }
            if ((record.getOccPeriodId() == null || record.getOccPeriodId() == 0L || !SysDimensionEnum.Period.getNumber().equals(dimension.getNumber())) && !SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) continue;
            memberIds.add(record.getOccPeriodId());
        }
    }

    public static void batchSaveOlap(Collection<BizModel> models, Collection<BgControlRecord> records, String billNumber) {
        if (models == null || records == null || records.isEmpty()) {
            return;
        }
        Long modelId = null;
        HashMap<Long, ArrayList<BgControlRecord>> batchMap = new HashMap<Long, ArrayList<BgControlRecord>>();
        Collection<BgControlRecord> batchs = null;
        for (BgControlRecord bgControlRecord : records) {
            if (bgControlRecord.isOnlyCheck()) continue;
            modelId = bgControlRecord.getBizModel().getKey();
            batchs = (ArrayList<BgControlRecord>)batchMap.get(modelId);
            if (batchs == null) {
                batchs = new ArrayList<BgControlRecord>();
                batchMap.put(modelId, (ArrayList<BgControlRecord>)batchs);
            }
            batchs.add(bgControlRecord);
        }
        OlapTraceServiceHelper.setTraceOpInfo((String)billNumber);
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.BudgetControl));
        HashMap<Long, Collection<BgControlRecord>> savedMap = new HashMap<Long, Collection<BgControlRecord>>(10);
        try {
            for (BizModel model : models) {
                batchs = (Collection)batchMap.get(model.getKey());
                if (batchs == null || batchs.isEmpty()) continue;
                if (model.isEBByModel()) {
                    BgControlRecordUtils.saveMolap(model, batchs);
                } else {
                    BgControlRecordUtils.saveRolap(model, batchs);
                }
                savedMap.put(model.getKey(), batchs);
            }
        }
        catch (Throwable throwable) {
            for (BizModel model : models) {
                batchs = (Collection)savedMap.get(model.getKey());
                if (batchs == null || batchs.isEmpty()) continue;
                for (BgControlRecord record : batchs) {
                    if (record.getAmount() == null) continue;
                    record.setAmount(record.getAmount().negate());
                }
                if (model.isEBByModel()) {
                    BgControlRecordUtils.saveMolap(model, batchs);
                    continue;
                }
                BgControlRecordUtils.saveRolap(model, batchs);
            }
            log.info("save-olap-error: {}", (Object)throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveMolap(BizModel model, Collection<BgControlRecord> records) {
        if (model == null || records == null || records.isEmpty()) {
            return;
        }
        String[] dimensionNums = null;
        String[] memberNums = null;
        dimensionNums = model.getModelCache().getDimensionNums();
        Map dimensionMap = model.getDimensionMap();
        String dataKey = null;
        HashMap olapDataMap = Maps.newHashMapWithExpectedSize((int)records.size());
        OlapData olapData = null;
        for (BgControlRecord record : records) {
            if (record.isOnlyCheck()) continue;
            dataKey = record.getMemberKey();
            memberNums = new String[dimensionNums.length];
            for (int i = 0; i < dimensionNums.length; ++i) {
                memberNums[i] = record.getMember((kd.epm.eb.common.model.Dimension)dimensionMap.get(dimensionNums[i])).getNumber();
                if (memberNums[i] != null) continue;
                ControlException.erorrOther((String)("member number is null. dimension number is " + dimensionNums[i]));
            }
            olapData = (OlapData)olapDataMap.get(dataKey);
            if (olapData == null) {
                olapData = new OlapData(dataKey, memberNums, BigDecimal.ZERO);
            }
            olapData.setValue(olapData.getValue().add(record.getAmount()));
            olapDataMap.put(dataKey, olapData);
        }
        if (!olapDataMap.isEmpty()) {
            LogStats stats = new LogStats("budget-shrek-log : ");
            stats.addInfo("begin-save-controlRecord.");
            HashSet metaKeys = Sets.newHashSetWithExpectedSize((int)olapDataMap.size());
            try (IShrekSave save = ShrekOlapServiceHelper.saveDataByIncrement((Model)model.getModelCache().getModelobj(), (String[])dimensionNums, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));){
                for (OlapData _olapData : olapDataMap.values()) {
                    if (metaKeys.add(_olapData.calcMetaKey())) {
                        save.add(_olapData.getMemberNums(), (Object)_olapData.getValue());
                        continue;
                    }
                    log.error("olap-data is save repetition." + _olapData.calcMetaKey());
                }
            }
            finally {
                stats.addInfo("end-save-controlRecord.");
                log.info(stats.toString());
            }
        }
    }

    private static void saveRolap(BizModel model, Collection<BgControlRecord> records) {
        if (model == null || records == null || records.isEmpty()) {
            return;
        }
        String dataKey = null;
        String[] memberNums = null;
        LinkedList cells = new LinkedList();
        HashMap<String, IKDCell> olapDataMap = new HashMap<String, IKDCell>();
        IKDCell cell = null;
        List dimensions = model.getDimensions();
        kd.epm.eb.common.model.Dimension dimension = null;
        for (BgControlRecord record : records) {
            if (record.isOnlyCheck()) continue;
            dataKey = record.getMemberKey();
            memberNums = new String[dimensions.size()];
            int in = dimensions.size();
            for (int i = 0; i < in; ++i) {
                dimension = (kd.epm.eb.common.model.Dimension)dimensions.get(i);
                memberNums[i] = record.getMember(dimension).getNumber();
                if (memberNums[i] != null) continue;
                ControlException.erorrOther((String)("member number is null. dimension number is " + dimension.getNumber()));
            }
            if (olapDataMap.containsKey(dataKey)) {
                cell = (IKDCell)olapDataMap.get(dataKey);
                cell.getValue().setDecimal(cell.getValue().getDecimal().add(record.getAmount()));
                continue;
            }
            olapDataMap.put(dataKey, KDCell.of((String[])memberNums, (BigDecimal)record.getAmount()));
        }
        cells.addAll(olapDataMap.values());
        if (!cells.isEmpty()) {
            IKDOlapRequest request = KDOlapRequestUtils.of((Long)model.getId(), (Long)model.getControlBusModelId(), null, cells);
            request.getOlapData().setUseDimension(model.getDimensionArrays());
            request.getOlapData().setDimensionMap(model.getDimensionMap(model.getModelCache()));
            request.getProperties().setPropertyValue("IGNORE_SAVE_TEXT", KDValue.valueOf((String)BgConstant.TRUE_STR));
            request.getProperties().setPropertyValue("IGNORE_PERM_SAVE", KDValue.valueOf((String)BgConstant.TRUE_STR));
            request.getProperties().setPropertyValue("IGNORE_DATA_LOCK", KDValue.valueOf((String)BgConstant.TRUE_STR));
            request.getProperties().setPropertyValue("IGNORE_SAVE_TRANSACTION", KDValue.valueOf((String)BgConstant.TRUE_STR));
            OlapServiceCaller caller = new OlapServiceCaller();
            caller.saveByAdd(request);
        }
    }

    public static void backOlap(Collection<BizModel> models, Collection<BgControlRecord> records) {
        if (models == null || records == null || records.isEmpty()) {
            return;
        }
    }

    public static void save(Collection<BgControlRecord> bgControlRecords, String appliernumber) {
        UserInfo info;
        if (bgControlRecords == null || bgControlRecords.isEmpty()) {
            return;
        }
        Long applierId = 0L;
        if (StringUtils.isNotEmpty((String)appliernumber) && (info = UserUtils.getUserInfo((String)appliernumber)) != null) {
            applierId = info.getId();
            for (BgControlRecord r : bgControlRecords) {
                r.setApplierId(applierId);
            }
        }
        ArrayList ebs = Lists.newArrayListWithCapacity((int)bgControlRecords.size());
        HashMap bgMdsMap = Maps.newHashMapWithExpectedSize((int)bgControlRecords.size());
        HashSet<String> onlyChecks = new HashSet<String>(16);
        for (BgControlRecord record : bgControlRecords) {
            if (record.isOnlyCheck()) {
                String key = record.getMemberKey() + "!" + record.getBgMemberJson();
                if (onlyChecks.contains(key)) continue;
                onlyChecks.add(key);
            }
            if (record.getBizModel().isEBByModel()) {
                ebs.add(record.getObject());
                continue;
            }
            List _records = bgMdsMap.computeIfAbsent(record.getBizModel().getKey(), f -> new ArrayList());
            _records.add(record);
        }
        if (!ebs.isEmpty()) {
            BgControlRecord record;
            BgControlRecordUtils.checkExistEntryByRecord("t_eb_bgcontrolrecord");
            BgControlRecordUtils.checkExistOccPeriodByRecord("t_eb_bgcontrolrecord");
            BgControlRecordUtils.checkExistOccTypeByRecord("t_eb_bgcontrolrecord");
            DynamicObject rec = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgcontrolrecord");
            SaveServiceHelper.save((IDataEntityType)rec.getDataEntityType(), (Object[])ebs.toArray(new DynamicObject[ebs.size()]));
            record = (DynamicObject)ebs.get(0);
            BgControlUtils.createCRRecord(record.getString("entitynumber"), record.getString("bizid"), "t_eb_bgcontrolrecord");
        }
        if (!bgMdsMap.isEmpty()) {
            for (List bgMds : bgMdsMap.values()) {
                if (bgMds.isEmpty()) continue;
                BgControlRecordUtils.saveBgMd(((BgControlRecord)bgMds.get(0)).getBizModel(), bgMds, applierId);
            }
        }
    }

    private static void saveBgMd(BizModel model, List<BgControlRecord> bgControlRecords, Long applierId) {
        if (model == null || bgControlRecords == null || bgControlRecords.isEmpty()) {
            return;
        }
        String controlTable = BgControlUtils.getBgControlRecordTable(model.getId(), model.getControlBusModelId());
        BgControlRecordUtils.checkExistOccTypeByRecord(controlTable);
        List dimensions = model.getModelCache().getDimensionListByBusModel(model.getControlBusModelId());
        int fieldSize = 31;
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(controlTable).append(" (fid, fmodelid, fentitynumber, fbizid, fbiznumber, foperation, freqorgunitid, forgunitid, freqaccountid, faccountid, ");
        sql.append("fbgperiodid, fcurrencyid, fversionid, fatid, fctid, fdtid, fmetricid, famount, fcreatetime, fcreatorid, fruleid, frefbizid, fentryid, foccperiodid, focctype,fbgmemberjson,frequestId,fstatus,fwriteofftype,frefentryid,fserialtextjson");
        if (model.getControlDims() != null) {
            for (Dimension dimension : dimensions) {
                if (!model.getControlDims().contains(dimension.getId())) continue;
                if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                    sql.append(", ").append(BgControlUtils.getUserDefinedIdField(dimension));
                    ++fieldSize;
                    continue;
                }
                if (!SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) continue;
                sql.append(", ").append(BgControlRecordUtils.getBgMdRecordFields().get(dimension.getNumber()));
                ++fieldSize;
            }
        }
        sql.append(") values (").append(SqlBatchUtils.getBatchParamsSql((int)fieldSize)).append(")");
        Timestamp time = new Timestamp(System.currentTimeMillis());
        Long userId = UserUtils.getUserId();
        if (IDUtils.isNotNull((Long)applierId)) {
            userId = applierId;
        }
        ArrayList sqlParams = Lists.newArrayListWithCapacity((int)bgControlRecords.size());
        ArrayList sqlParam = null;
        for (BgControlRecord record : bgControlRecords) {
            sqlParam = Lists.newArrayListWithExpectedSize((int)fieldSize);
            sqlParam.add(DBServiceHelper.genGlobalLongId());
            sqlParam.add(model.getId());
            sqlParam.add(record.getEntityNumber());
            sqlParam.add(record.getBizId());
            sqlParam.add(record.getBizNumber());
            sqlParam.add(record.getOperation());
            sqlParam.add(record.getReqOrgUnitId());
            sqlParam.add(record.getMember(SysDimensionEnum.Entity.getNumber()).getId());
            sqlParam.add(record.getReqAccountId());
            sqlParam.add(record.getMember(SysDimensionEnum.Account.getNumber()).getId());
            sqlParam.add(record.getMember(SysDimensionEnum.BudgetPeriod.getNumber()).getId());
            sqlParam.add(record.getMember(SysDimensionEnum.Currency.getNumber()).getId());
            sqlParam.add(record.getMember(SysDimensionEnum.Version.getNumber()).getId());
            sqlParam.add(record.getMember(SysDimensionEnum.AuditTrail.getNumber()).getId());
            sqlParam.add(record.getMember(SysDimensionEnum.ChangeType.getNumber()).getId());
            sqlParam.add(record.getMember(SysDimensionEnum.DataType.getNumber()).getId());
            sqlParam.add(record.getMember(SysDimensionEnum.Metric.getNumber()).getId());
            sqlParam.add(record.getAmount());
            sqlParam.add(time);
            sqlParam.add(userId);
            sqlParam.add(record.getSetting() != null ? record.getSetting() : 0L);
            sqlParam.add(StringUtils.isNotEmpty((String)record.getRefBizId()) ? record.getRefBizId() : " ");
            sqlParam.add(record.getEntryId());
            sqlParam.add(record.getOccPeriod() != null ? record.getOccPeriodId() : 0L);
            sqlParam.add(record.getOccType());
            sqlParam.add(record.getBgMemberJson());
            sqlParam.add(record.getRequestId());
            sqlParam.add(record.getStatus());
            sqlParam.add(record.getWriteOffType());
            sqlParam.add(record.getRefEntryId());
            sqlParam.add(record.getSerialJson());
            for (Dimension dimension : dimensions) {
                if (!model.getControlDims().contains(dimension.getId()) || !BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) && !SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) continue;
                sqlParam.add(record.getMember(dimension.getNumber()).getId());
            }
            sqlParams.add(sqlParam.toArray(new Object[sqlParam.size()]));
        }
        if (!sqlParams.isEmpty()) {
            DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql.toString(), (List)sqlParams);
            BgControlRecord record = bgControlRecords.get(0);
            BgControlUtils.createCRRecord(record.getEntityNumber(), record.getBizId(), controlTable);
        }
    }

    public static void checkExistEntryByRecord(String controlTable) {
        if (controlTable == null) {
            return;
        }
        if (!SqlBatchUtils.hasColumn((String)controlTable, (String)"fentryid")) {
            String sql = "alter table " + controlTable + " add (fentryid nvarchar(80) default ' ' not null)";
            try (TXHandle tx = TX.requiresNew((String)"checkExistEntry");){
                try {
                    DB.execute((DBRoute)BgBaseConstant.epm, (String)sql);
                }
                catch (Exception e) {
                    tx.markRollback();
                }
            }
        }
    }

    public static void checkExistOccPeriodByRecord(String controlTable) {
        if (controlTable == null) {
            return;
        }
        if (!SqlBatchUtils.hasColumn((String)controlTable, (String)"foccperiodid")) {
            String sql = "alter table " + controlTable + " add (foccperiodid bigint default 0 not null)";
            try (TXHandle tx = TX.requiresNew((String)"checkExistOccPeriod");){
                try {
                    DB.execute((DBRoute)BgBaseConstant.epm, (String)sql);
                }
                catch (Exception e) {
                    tx.markRollback();
                }
            }
        }
    }

    public static void checkExistOccTypeByRecord(String controlTable) {
        if (controlTable == null) {
            return;
        }
        String sufix = controlTable.replace("t_eb_cr", "");
        String crSign = "sign_cr_" + sufix;
        if (!UpdateRecordHelper.isUpdated((String)crSign, (String)"v6.0.1", (boolean)Boolean.TRUE)) {
            for (Tuple colInfo : BgControlConstant.addCRCols) {
                Set cols = SqlBatchUtils.getColumns((String)controlTable);
                if (cols.contains(colInfo.p1)) continue;
                String sql = String.format("alter table %s add (%s %s default %s not null)", controlTable, colInfo.p1, colInfo.p2, colInfo.p3);
                TXHandle tx = TX.requiresNew((String)"checkExistOccType");
                Throwable throwable = null;
                try {
                    try {
                        BgControlRecordUtils.excuteSql(sql);
                    }
                    catch (Exception e) {
                        tx.markRollback();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
            try (TXHandle tx = TX.requiresNew((String)"addRecord");){
                try {
                    UpdateRecordHelper.addRecord((String)crSign, (String)"", (String)"v6.0.1", (boolean)Boolean.TRUE);
                }
                catch (Exception e) {
                    tx.markRollback();
                }
            }
        }
    }

    private static void excuteSql(String sql) {
        DB.execute((DBRoute)BgBaseConstant.epm, (String)sql);
    }

    public static boolean checkIdempotent(IControlParameter parameter, LogStats stats) {
        if (parameter == null || !parameter.isCheckIdempotent()) {
            return false;
        }
        boolean re = false;
        RecordInfo record = BgControlRecordUtils.hasRecord(parameter.getEntityNumber(), parameter.getBizId(), parameter.getOperation());
        if (record.isHasRecord()) {
            if (stats != null) {
                stats.addInfo("has Identical record.");
            }
            BgControlLogUtils.info(stats, true, "checkIdempotent = " + parameter.getEntityNumber() + ":" + parameter.getBizId() + ":" + parameter.getOperation() + " has Identical record.");
            if (record.isHasOccupation()) {
                if (!parameter.getControlManager().isStandard()) {
                    if (!(parameter.getControlManager().isOccupation() && parameter.getControlManager().isDelentry().booleanValue() && record.hasRecord && record.hasWriteOff)) {
                        // empty if block
                    }
                    return false;
                }
                if (parameter.getControlManager().isOccupation()) {
                    if (stats != null) {
                        stats.addInfo("has repetition occupation operation - " + parameter.getOperation());
                    }
                    if (parameter.getControlManager().canOccAgain().booleanValue()) {
                        return false;
                    }
                    if (record.getOperations().contains(parameter.getOperation())) {
                        parameter.getResult().setCode("success-check-idempotent");
                        parameter.getResult().setResult(ControlResultEnum.PASS);
                        return true;
                    }
                    parameter.getControlManager().setReturnBudget(true);
                    return false;
                }
            } else {
                if (stats != null) {
                    stats.addInfo("has execute operation - " + parameter.getOperation());
                }
                parameter.getResult().setCode("success-check-idempotent");
                parameter.getResult().setResult(ControlResultEnum.PASS);
                re = true;
            }
        }
        return re;
    }

    private static RecordInfo hasRecord(String entityNumber, String bizId, String operation) {
        if (entityNumber == null) {
            ControlException.errorBizEntityNumber();
            return new RecordInfo(false, false, null, false);
        }
        if (bizId == null) {
            ControlException.errorBizId();
            return new RecordInfo(false, false, null, false);
        }
        if (operation == null) {
            ControlException.errorOperation();
            return new RecordInfo(false, false, null, false);
        }
        Set<String> crTables = BgControlUtils.getCRTable(entityNumber, bizId);
        if (crTables.isEmpty()) {
            crTables.add("t_eb_bgcontrolrecord");
        }
        String sql = null;
        LinkedHashSet operations = Sets.newLinkedHashSet();
        LinkedHashSet<Long> changeTypes = new LinkedHashSet<Long>();
        HashSet<String> bizids = new HashSet<String>(16);
        for (String crTable : crTables) {
            sql = "select fid,fbizid, foperation, fctid, frefbizid,focctype from " + crTable + " where fbizid = ? or frefbizid = ?";
            if (!SqlBatchUtils.hasColumn((String)crTable, (String)"focctype")) {
                sql = sql.replaceFirst(",focctype", "");
            }
            BgControlRecordUtils.qryBgRd(sql, bizId, changeTypes, operations, bizids);
        }
        Boolean hasWriteOff = !bizids.isEmpty();
        if (!changeTypes.isEmpty()) {
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("id", "in", changeTypes));
            Map cts = BusinessDataServiceHelper.loadFromCache((String)SysDimensionEnum.ChangeType.getMemberTreemodel(), (String)"id, number", (QFilter[])builder.toArrays());
            if (cts != null) {
                for (DynamicObject ct : cts.values()) {
                    if (!"Execute".equals(ct.getString("number"))) continue;
                    return new RecordInfo(true, false, operations, hasWriteOff);
                }
                return new RecordInfo(true, true, operations, hasWriteOff);
            }
        }
        return new RecordInfo(false, false, operations, hasWriteOff);
    }

    private static void qryBgRd(String sql, String bizId, Set<Long> changeTypes, Set<String> operations, Set<String> bizIds) {
        try (DataSet ds = DB.queryDataSet((String)"exist BgControlRecord", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{bizId, bizId});){
            for (Row row : ds) {
                String refbizid = row.getString("frefbizid");
                if (StringUtils.isNotEmpty((String)refbizid) && !bizId.equals(refbizid)) continue;
                try {
                    if (StringUtils.isNotEmpty((String)refbizid) || StringUtils.isNotEmpty((String)row.getString("focctype")) && "clsocc".equals(row.getString("focctype"))) {
                        bizIds.add(row.getString("fbizid"));
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                changeTypes.add(row.getLong("fctid"));
                operations.add(row.getString("foperation"));
            }
        }
    }

    public static Map<Long, DynamicObject> queryApplierName(List<BgControlRecord> records) {
        if (records == null || records.isEmpty()) {
            return new HashMap<Long, DynamicObject>(1);
        }
        HashSet<Long> userIds = new HashSet<Long>(16);
        for (BgControlRecord r : records) {
            Long applierId = r.getApplierId();
            if (!IDUtils.isNotNull((Long)applierId)) continue;
            userIds.add(applierId);
        }
        return BgControlRecordUtils.queryApplierName(userIds);
    }

    public static Map<Long, DynamicObject> queryApplierName(Set<Long> userIds) {
        HashMap<Long, DynamicObject> userMap = new HashMap<Long, DynamicObject>(16);
        if (userIds != null && !userIds.isEmpty()) {
            QFilter filter = new QFilter("id", "in", userIds);
            Map users = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,number,name", (QFilter[])filter.toArray());
            users.values().forEach(f -> userMap.put(f.getLong("id"), (DynamicObject)f));
        }
        return userMap;
    }

    static {
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.Entity.getNumber(), "forgunitid");
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.Account.getNumber(), "faccountid");
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.BudgetPeriod.getNumber(), "fbgperiodid");
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.Year.getNumber(), "fyearid");
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.Period.getNumber(), "fperiodid");
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.Currency.getNumber(), "fcurrencyid");
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.Scenario.getNumber(), "fscenarioid");
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.Version.getNumber(), "fversionid");
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.AuditTrail.getNumber(), "faudittrailid");
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.InternalCompany.getNumber(), "ficid");
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.ChangeType.getNumber(), "fctid");
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.DataType.getNumber(), "fdatatypeid");
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.Process.getNumber(), "fprocessid");
        BgControlRecordUtils.getRecordFields().put(SysDimensionEnum.Metric.getNumber(), "fmetricid");
        BgControlRecordUtils.getBgMdRecordFields().put(SysDimensionEnum.Entity.getNumber(), "forgunitid");
        BgControlRecordUtils.getBgMdRecordFields().put(SysDimensionEnum.Account.getNumber(), "faccountid");
        BgControlRecordUtils.getBgMdRecordFields().put(SysDimensionEnum.BudgetPeriod.getNumber(), "fbgperiodid");
        BgControlRecordUtils.getBgMdRecordFields().put(SysDimensionEnum.Currency.getNumber(), "fcurrencyid");
        BgControlRecordUtils.getBgMdRecordFields().put(SysDimensionEnum.Version.getNumber(), "fversionid");
        BgControlRecordUtils.getBgMdRecordFields().put(SysDimensionEnum.AuditTrail.getNumber(), "fatid");
        BgControlRecordUtils.getBgMdRecordFields().put(SysDimensionEnum.ChangeType.getNumber(), "fctid");
        BgControlRecordUtils.getBgMdRecordFields().put(SysDimensionEnum.DataType.getNumber(), "fdtid");
        BgControlRecordUtils.getBgMdRecordFields().put(SysDimensionEnum.InternalCompany.getNumber(), "ficid");
        BgControlRecordUtils.getBgMdRecordFields().put(SysDimensionEnum.Metric.getNumber(), "fmetricid");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.Entity.getNumber(), "orgunit");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.Account.getNumber(), "account");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.BudgetPeriod.getNumber(), "bgperiod");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.Year.getNumber(), "year");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.Period.getNumber(), "period");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.Scenario.getNumber(), "scenario");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.Version.getNumber(), "version");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.Currency.getNumber(), "currency");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.AuditTrail.getNumber(), "audittrail");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.InternalCompany.getNumber(), "ic");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.ChangeType.getNumber(), "changetype");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.DataType.getNumber(), "datatype");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.Process.getNumber(), "process");
        BgControlRecordUtils.getRecordProps().put(SysDimensionEnum.Metric.getNumber(), "metric");
    }

    public static class RecordInfo {
        private boolean hasRecord;
        private boolean hasOccupation;
        private boolean hasWriteOff;
        private Set<String> operations = null;

        public boolean isHasRecord() {
            return this.hasRecord;
        }

        public boolean isHasOccupation() {
            return this.hasOccupation;
        }

        public boolean isHasWriteOff() {
            return this.hasWriteOff;
        }

        public Set<String> getOperations() {
            if (this.operations == null) {
                this.operations = new HashSet<String>();
            }
            return this.operations;
        }

        RecordInfo(boolean hasRecord, boolean hasOccupation, Set<String> operations, boolean hasWriteOff) {
            this.hasRecord = hasRecord;
            this.hasOccupation = hasOccupation;
            this.operations = operations;
            this.hasWriteOff = hasWriteOff;
        }
    }
}

