/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BgControlRelationUtils {
    private static final Log log = LogFactory.getLog(BgControlRelationUtils.class);
    private static final String RELATION_KEY = "_lk";
    private static final String RELATION_KEY_VALUE = "_sbillid";
    private static final String RELATION_KEY_TABLE = "_stableid";

    public static BgControlRelationUtils get() {
        return new BgControlRelationUtils();
    }

    public Map<String, HashSet<Long>> getSource(DynamicObject object) {
        if (object == null) {
            return Collections.emptyMap();
        }
        ExtendedDataEntitySet dataset = new ExtendedDataEntitySet();
        dataset.Parse(new DynamicObject[]{object}, (MainEntityType)object.getDataEntityType());
        LinkedHashMap sources = Maps.newLinkedHashMap();
        LinkedHashMap tableMap = Maps.newLinkedHashMap();
        StringBuilder str = new StringBuilder();
        str.append("budget-control-log : ").append("ExtendedDataEntity-");
        ExtendedDataEntity[] dataEntities = dataset.FindByEntityKey("billhead_lk");
        this.getSourceByProp("billhead", dataEntities, tableMap, sources, str);
        for (IDataEntityProperty property : object.getDataEntityType().getProperties()) {
            String propertyKey = property.getName() + RELATION_KEY;
            dataEntities = dataset.FindByEntityKey(propertyKey);
            this.getSourceByProp(propertyKey, dataEntities, tableMap, sources, str);
        }
        log.info(str.toString());
        return sources;
    }

    private void getSourceByProp(String propertyKey, ExtendedDataEntity[] dataEntities, Map<Long, String> tableMap, Map<String, HashSet<Long>> sources, StringBuilder str) {
        if (propertyKey == null || dataEntities == null || str == null) {
            return;
        }
        if (dataEntities != null && dataEntities.length > 0) {
            str.append("property=").append(propertyKey).append(';');
            for (ExtendedDataEntity dataEntity : dataEntities) {
                Object _sourceId = dataEntity.getValue(propertyKey + RELATION_KEY_VALUE);
                Object _tableId = dataEntity.getValue(propertyKey + RELATION_KEY_TABLE);
                str.append("sourceId=").append(_sourceId).append("; tableId=").append(_tableId).append(';');
                if (!(_sourceId instanceof Long) || !(_tableId instanceof Long)) continue;
                Long sourceId = (Long)_sourceId;
                Long tableId = (Long)_tableId;
                String entityNumber = tableMap.computeIfAbsent(tableId, f -> {
                    TableDefine tableDefine = null;
                    try {
                        tableDefine = EntityMetadataCache.loadTableDefine((Long)tableId);
                    }
                    catch (Exception e) {
                        log.error("loadTableDefine error", (Throwable)e);
                    }
                    if (tableDefine != null) {
                        return tableDefine.getEntityNumber();
                    }
                    return null;
                });
                if (entityNumber == null) continue;
                Set billIds = sources.computeIfAbsent(entityNumber, f -> Sets.newLinkedHashSet());
                billIds.add(sourceId);
            }
            str.append("\r\n");
        }
    }
}

