/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.RuleControlTypeEnum;
import kd.epm.eb.common.enums.RulePeriodClassifyEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.resource.ResourceUtils;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.impl.model.BgControlSetting;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class BgControlRuleUtils {
    private static final Log log = LogFactory.getLog(BgControlRuleUtils.class);
    public static final String RULE_FIELDS = "id,model,periodclassify,controltype,coefficient,isbeyond,effectivedate,invaliddate,createdate,illustrate,group.id,group.groupname,group.groupseq,accounts.account.id,accounts.account.name,accounts.account.number,dimentions.id,dimentions.groupaccount.id,dimentions.groupaccount.number,dimentions.groupaccount.name,dimentions.userdefined1.number,dimentions.userdefined1.name,dimentions.userdefined2.number,dimentions.userdefined2.name,dimentions.userdefined3.number,dimentions.userdefined3.name,dimentions.userdefined4.number,dimentions.userdefined4.name,dimentions.userdefined5.number,dimentions.userdefined5.name,dimentions.userdefined6.number,dimentions.userdefined6.name,dimentions.userdefined7.number,dimentions.userdefined7.name,dimentions.userdefineddimid1,dimentions.userdefineddimid2,dimentions.userdefineddimid3,dimentions.userdefineddimid4,dimentions.userdefineddimid5,dimentions.userdefineddimid6,dimentions.userdefineddimid7";
    public static final String RULE_FIELDS_ACCOUNT_MAIN = "id,model,periodclassify,controltype,coefficient,isbeyond,isfreetype,effectivedate,invaliddate,createdate,illustrate,group.id,group.groupname,group.groupseq,accounts.account.id,accounts.account.name,accounts.account.number";
    public static final String MAIN_RULE_FIELD = "mainRuleField";
    public static final String USER_DEFINED_RULE_FIELD = "userDefinedRuleField";
    public static final String RULE_FIELDS_USER_DEFINED = "id,dimentions.id,dimentions.groupaccount.id,dimentions.groupaccount.number,dimentions.groupaccount.name,dimentions.userdefined1.number,dimentions.userdefined1.name,dimentions.userdefined2.number,dimentions.userdefined2.name,dimentions.userdefined3.number,dimentions.userdefined3.name,dimentions.userdefined4.number,dimentions.userdefined4.name,dimentions.userdefined5.number,dimentions.userdefined5.name,dimentions.userdefined6.number,dimentions.userdefined6.name,dimentions.userdefined7.number,dimentions.userdefined7.name,dimentions.userdefineddimid1,dimentions.userdefineddimid2,dimentions.userdefineddimid3,dimentions.userdefineddimid4,dimentions.userdefineddimid5,dimentions.userdefineddimid6,dimentions.userdefineddimid7";
    public static final String RULE_FIELDS_MAIN = "id,model,periodclassify,controltype,coefficient,isbeyond,effectivedate,invaliddate,createdate,illustrate,group.id,group.groupname,group.groupseq";
    private static final Set<String> LONG_RULE_FIELDS_SET = Sets.newHashSet((Object[])new String[]{"id", "model", "group.id", "accounts.account.id", "dimentions.id", "dimentions.groupaccount.id", "dimentions.userdefineddimid1", "dimentions.userdefineddimid2", "dimentions.userdefineddimid3", "dimentions.userdefineddimid4", "dimentions.userdefineddimid5", "dimentions.userdefineddimid6", "dimentions.userdefineddimid7"});
    private static final Set<String> STRING_RULE_FIELDS_SET = Sets.newHashSet((Object[])new String[]{"periodclassify", "controltype", "illustrate", "group.groupname", "accounts.account.name", "accounts.account.number", "dimentions.groupaccount.number", "dimentions.groupaccount.name", "dimentions.userdefined1.number", "dimentions.userdefined1.name", "dimentions.userdefined2.number", "dimentions.userdefined2.name", "dimentions.userdefined3.number", "dimentions.userdefined3.name", "dimentions.userdefined4.number", "dimentions.userdefined4.name", "dimentions.userdefined5.number", "dimentions.userdefined5.name", "dimentions.userdefined6.number", "dimentions.userdefined6.name", "dimentions.userdefined7.number", "dimentions.userdefined7.name"});
    private static final Set<String> BIGDECIMAL_RULE_FIELDS_SET = Sets.newHashSet((Object[])new String[]{"coefficient"});
    private static final Set<String> TIMESTAMP_RULE_FIELDS_SET = Sets.newHashSet((Object[])new String[]{"effectivedate", "invaliddate", "createdate"});
    private static final Set<String> INTEGER_RULE_FIELDS_SET = Sets.newHashSet((Object[])new String[]{"group.groupseq"});
    private static final Set<String> BOOLEAN_RULE_FIELDS_SET = Sets.newHashSet((Object[])new String[]{"isbeyond"});
    public static final String RULE_FIELDS_NEW = "id,model, periodclassify, controltype, coefficient, isbeyond, effectivedate, invaliddate, createdate, illustrate, group.id, group.groupname, group.groupseq, accounts.account.id, accounts.account.name, accounts.account.number, dimentions.id,dimentions.groupaccount.id,dimentions.groupaccount.number,dimentions.groupaccount.name,dimentions.userdefined1.number, dimentions.userdefined1.name, dimentions.userdefined2.number, dimentions.userdefined2.name, dimentions.userdefined3.number, dimentions.userdefined3.name, dimentions.userdefined4.number, dimentions.userdefined4.name, dimentions.userdefined5.number, dimentions.userdefined5.name, dimentions.userdefined6.number, dimentions.userdefined6.name, dimentions.userdefined7.number, dimentions.userdefined7.name, dimentions.userdefineddimid1, dimentions.userdefineddimid2, dimentions.userdefineddimid3, dimentions.userdefineddimid4, dimentions.userdefineddimid5, dimentions.userdefineddimid6, dimentions.userdefineddimid7,groupdims.groupdim.id,groupdims.groupdim.name,groupdims.groupdim.number,groupdims.isobodim,obomemranges.obomember.id,obomemranges.obomember.name,obomemranges.obomember.number,obomemranges.memrange";

    public static BgControlRuleUtils getInterface() {
        return new BgControlRuleUtils();
    }

    private static String getPeriodClassifyCn() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u671f\u95f4\u5206\u7c7b*", (String)"BgControlRuleUtils_7", (String)"epm-eb-business", (Object[])new Object[0]);
    }

    private static String getControlTypeCn() {
        return ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f*", (String)"BgControlRuleUtils_8", (String)"epm-eb-business", (Object[])new Object[0]);
    }

    private static String getGroupDimCn() {
        return ResManager.loadKDString((String)"\u5206\u7ec4\u7ef4\u5ea6", (String)"RuleControlListPlugin_69", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getOboDimCn() {
        return ResManager.loadKDString((String)"\u5206\u7ec4\u7ef4\u5ea6\uff08\u9010\u4e00\u5206\u7ec4\u7ef4\u5ea6\uff09", (String)"RuleControlListPlugin_70", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getGroupDimGroupByNameCn() {
        return ResManager.loadKDString((String)"\u5206\u7ec4\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0\uff08\u53ef\u591a\u9009\u7528\u9017\u53f7\u5206\u9694\uff09", (String)"RuleControlListPlugin_71", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    private static String getGroupDimGroupByNumberCn() {
        return ResManager.loadKDString((String)"\u5206\u7ec4\u7ef4\u5ea6\u7ec4\u5408\u7f16\u7801\uff08\u53ef\u591a\u9009\u7528\u9017\u53f7\u5206\u9694\uff09", (String)"RuleControlListPlugin_72", (String)"epm-eb-formplugin", (Object[])new Object[0]);
    }

    public DynamicObject createDefaultRuleObj() {
        DynamicObjectType dt = new DynamicObjectType("ruleObject");
        this.handleRuleObjectDynamicObjectType(dt);
        DynamicObject defaultRuleObj = new DynamicObject(dt);
        this.handleRuleObjMainFieldDynamicObject(defaultRuleObj);
        this.handleRuleObjUserDefinedFieldDynamicObject(defaultRuleObj);
        return defaultRuleObj;
    }

    public void queryControlRule(BgControlData controlData, Collection<IControlParam> controlParams) {
        if (controlData == null || controlParams == null || controlParams.isEmpty()) {
            return;
        }
        HashMap<Long, Collection> paramMap = new HashMap<Long, Collection>(10);
        for (IControlParam iControlParam : controlParams) {
            if (iControlParam.getBizModel() == null) continue;
            paramMap.computeIfAbsent(iControlParam.getBizModel().getKey(), f -> new ArrayList(10)).add(iControlParam);
        }
        for (Map.Entry entry : paramMap.entrySet()) {
            this.queryControlRule(controlData.getBizModels().get(entry.getKey()), controlData, (Collection)entry.getValue());
        }
    }

    public void queryControlRule(BizModel bizModel, BgControlData controlData, Collection<IControlParam> controlParams) {
        BgControlSetting setting;
        if (controlData == null || controlParams == null || controlParams.isEmpty()) {
            return;
        }
        HashMap<String, DynamicObject> cacheRuleMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, List> cacheGroupRuleMap = new HashMap<String, List>(16);
        HashMap<String, String> cacheRuleOrgMap = new HashMap<String, String>(16);
        String accountNum = null;
        String[] tmpNums = null;
        HashSet<String> bgAccountNums = new HashSet<String>();
        HashSet<String> orgUnitNums = new HashSet<String>();
        for (IControlParam controlParam : controlParams) {
            String[] stringArray;
            Member entityMember = controlParam.getOrgUnit(true);
            if (entityMember.getLongNumber() != null) {
                stringArray = entityMember.getLongNumber().split("!");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = entityMember.getNumber();
            }
            tmpNums = stringArray;
            if (tmpNums != null) {
                for (String number : tmpNums) {
                    orgUnitNums.add(number);
                }
            }
            if ((tmpNums = controlParam.getAccount(true).getLongNumber().split("!")) != null) {
                for (String number : tmpNums) {
                    bgAccountNums.add(number);
                }
            }
            if ((tmpNums = controlParam.getAccount(false).getLongNumber().split("!")) == null) continue;
            for (String number : tmpNums) {
                bgAccountNums.add(number);
            }
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)bizModel.getId()));
        if (!bizModel.isEBByModel()) {
            builder.add(new QFilter("bussmodel", "=", (Object)bizModel.getControlBusModelId()));
        }
        builder.add(new QFilter("accounts.account.number", "in", bgAccountNums));
        HashMap<String, Map<String, List<DynamicObject>>> ruleMap = new HashMap<String, Map<String, List<DynamicObject>>>(16);
        Map orgRuleMap = null;
        List rules = null;
        DynamicObject defaultRule = null;
        HashMap<Long, Set<Long>> proMaps = new HashMap<Long, Set<Long>>(16);
        long time01 = System.currentTimeMillis();
        DynamicObjectCollection mainRuleObjs = QueryServiceHelper.query((String)"eb_bgcontrolrulemain", (String)RULE_FIELDS_ACCOUNT_MAIN, (QFilter[])builder.toArrays());
        time01 = System.currentTimeMillis() - time01;
        builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)bizModel.getId()));
        if (!bizModel.isEBByModel()) {
            builder.add(new QFilter("bussmodel", "=", (Object)bizModel.getControlBusModelId()));
        }
        builder.add(new QFilter("dimentions.groupaccount.number", "in", bgAccountNums));
        builder.or(new QFilter("dimentions.groupaccount", "=", (Object)0L).or(new QFilter("dimentions.groupaccount", "=", null)));
        long time01_1 = System.currentTimeMillis();
        DynamicObjectCollection userDefinedRuleObjs = QueryServiceHelper.query((String)"eb_bgcontrolrulemain", (String)RULE_FIELDS_USER_DEFINED, (QFilter[])builder.toArrays());
        time01_1 = System.currentTimeMillis() - time01_1;
        BgControlLogUtils.info(controlData.getStats(), controlParams.iterator().next().isNeedLog(), "budget-control-log : use_time_mainRuleObjs_size:" + mainRuleObjs.size() + "_query_time01:" + time01 + "_userDefinedRuleObjs_size:" + userDefinedRuleObjs.size() + "_query_time01_1:" + time01_1);
        long time1 = System.currentTimeMillis();
        DynamicObjectType dt = new DynamicObjectType("ruleObject");
        this.handleRuleObjectDynamicObjectType(dt);
        DynamicObjectCollection ruleObjs = this.handleRuleObjs(mainRuleObjs, userDefinedRuleObjs, dt, true);
        time1 = System.currentTimeMillis() - time1;
        BgControlLogUtils.info(controlData.getStats(), controlParams.iterator().next().isNeedLog(), "budget-control-log : use_time_handleRuleObjs_time1:" + time1);
        ArrayList timestamplist = new ArrayList(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)bizModel.getId());
        if (ruleObjs != null && !ruleObjs.isEmpty()) {
            Long entityView;
            HashSet<Long> ruleIds = new HashSet<Long>();
            HashMap<Long, Set> ruleOrgNums = new HashMap<Long, Set>();
            Set orgNums = null;
            HashSet<Long> timestamps = new HashSet<Long>();
            for (DynamicObject rule : ruleObjs) {
                if (rule.getDynamicObject(MAIN_RULE_FIELD).getDate("effectivedate") != null) {
                    timestamps.add(rule.getDynamicObject(MAIN_RULE_FIELD).getDate("effectivedate").getTime());
                }
                if (rule.getDynamicObject(MAIN_RULE_FIELD).getDate("invaliddate") != null) {
                    timestamps.add(rule.getDynamicObject(MAIN_RULE_FIELD).getDate("invaliddate").getTime());
                }
                ruleIds.add(rule.getDynamicObject(MAIN_RULE_FIELD).getLong("id"));
            }
            timestamplist.addAll(timestamps);
            Collections.sort(timestamplist);
            List<Map<String, Object>> proValueMap = this.getPropValueId(bizModel.getId(), orgUnitNums);
            builder = new QFBuilder();
            builder.add(new QFilter("allotedorg.number", "in", orgUnitNums).or(new QFilter("property.id", "in", proValueMap.stream().map(k -> (Long)k.get("fpropertyvalueid")).collect(Collectors.toSet()))));
            builder.add(new QFilter("controlrulemainid", "in", ruleIds));
            if (!bizModel.isEBByModel() && (entityView = modelCacheHelper.getViewByBusModelAndDimNumber(bizModel.getControlBusModelId(), "Entity")) != null) {
                builder.add(new QFilter("entityview", "=", (Object)entityView).or("entityview", "is null", null).or("entityview", "=", (Object)0L));
            }
            try (DataSet rst = QueryServiceHelper.queryDataSet((String)"queryRuleDistOrgs", (String)"eb_ocntrolrule_allotorg", (String)"controlrulemainid, allotedorg.number,property.id", (QFilter[])builder.toArrays(), (String)"allotedorg.id");){
                while (rst.hasNext()) {
                    Row row = rst.next();
                    orgNums = ruleOrgNums.computeIfAbsent(row.getLong("controlrulemainid"), f -> new HashSet());
                    if (row.getString("allotedorg.number") != null) {
                        orgNums.add(row.getString("allotedorg.number"));
                        continue;
                    }
                    if (row.getLong("property.id") == 0L || !proValueMap.stream().anyMatch(k -> row.getString("property.id").equals(String.valueOf(k.get("fpropertyvalueid"))))) continue;
                    Set numbers = proValueMap.stream().filter(k -> row.getString("property.id").equals(String.valueOf(k.get("fpropertyvalueid")))).map(k -> (String)k.get("fnumber")).collect(Collectors.toSet());
                    orgNums.addAll(numbers);
                    Set mainIds = proMaps.computeIfAbsent(row.getLong("property.id"), f -> new HashSet());
                    mainIds.add(row.getLong("controlrulemainid"));
                }
            }
            for (DynamicObject rule : ruleObjs) {
                accountNum = StringUtils.isNotEmpty((String)rule.getDynamicObject(USER_DEFINED_RULE_FIELD).getString("dimentions.groupaccount.number")) ? rule.getDynamicObject(USER_DEFINED_RULE_FIELD).getString("dimentions.groupaccount.number") : rule.getDynamicObject(MAIN_RULE_FIELD).getString("accounts.account.number");
                orgNums = (Set)ruleOrgNums.get(rule.getDynamicObject(MAIN_RULE_FIELD).get("id"));
                if (orgNums == null) continue;
                for (String orgNum : orgNums) {
                    orgRuleMap = ruleMap.computeIfAbsent(orgNum, f -> new HashMap());
                    rules = orgRuleMap.computeIfAbsent(accountNum, f -> new ArrayList());
                    if (proMaps.isEmpty() || proMaps.values().stream().noneMatch(k -> k.contains(rule.getDynamicObject(MAIN_RULE_FIELD).getLong("id")))) {
                        rules.add(0, rule);
                        continue;
                    }
                    rules.add(rule);
                }
            }
        }
        HashSet<Integer> groupNos = new HashSet<Integer>();
        int groupNo = 0;
        HashSet<Long> ruleIdSet = new HashSet<Long>(16);
        for (Map.Entry entry : ruleMap.entrySet()) {
            Map accountRuleMap = (Map)entry.getValue();
            for (Map.Entry accountRule : accountRuleMap.entrySet()) {
                List accountRules = (List)accountRule.getValue();
                ruleIdSet.addAll(accountRules.stream().map(e -> e.getDynamicObject(MAIN_RULE_FIELD).getLong("id")).collect(Collectors.toSet()));
            }
        }
        Map<Long, Map<Long, Set<String>>> oboMemberNumberMapByRuleIds = BgControlRuleUtils.getGroupRuleOboMemberNumberMapByRuleIds(ruleIdSet);
        Map<Long, List<Long>> oboDimIdMap = BgControlRuleUtils.getGroupRuleOboDimIdMap(ruleIdSet);
        for (IControlParam controlParam : controlParams) {
            Long bizTime;
            int bizTimeIndex = -1;
            if (timestamplist.isEmpty()) {
                bizTimeIndex = 0;
            }
            if (!timestamplist.isEmpty() && controlParam.getBizTime() != null && (bizTime = Long.valueOf(controlParam.getBizTime().getTime())).compareTo((Long)timestamplist.get(0)) >= 0) {
                if (bizTime.compareTo((Long)timestamplist.get(timestamplist.size() - 1)) >= 0) {
                    bizTimeIndex = timestamplist.size();
                } else {
                    for (int i = 1; i < timestamplist.size(); ++i) {
                        if (bizTime.compareTo((Long)timestamplist.get(i)) > 0) continue;
                        bizTimeIndex = i;
                        break;
                    }
                }
            }
            String ruleKey = bizTimeIndex + "!" + BgControlUtils.getMemberKey(controlParam, true, true, true, bizModel.getDimensions());
            DynamicObject rule = null;
            if (cacheRuleMap.containsKey(ruleKey)) {
                rule = (DynamicObject)cacheRuleMap.get(ruleKey);
                if (rule != null) {
                    controlParam.setSettingOrg((String)cacheRuleOrgMap.get(ruleKey));
                }
            } else {
                rule = this.getRule(controlData, bizModel.getDimensions(), controlParam, ruleMap, true, proMaps, oboMemberNumberMapByRuleIds, oboDimIdMap, null);
                cacheRuleMap.put(ruleKey, rule);
                if (rule != null) {
                    cacheRuleOrgMap.put(ruleKey, controlParam.getSettingOrg());
                }
            }
            if (rule != null) {
                setting = BgControlSetting.loadFromDynamicobject(rule);
                this.handleRuleOboDimsAndOboMemMap(setting, oboMemberNumberMapByRuleIds, oboDimIdMap);
                controlParam.setSetting(setting);
                groupNo = controlParam.getSetting().getGroupNo();
                if (groupNo > 0) {
                    groupNos.add(groupNo);
                }
            } else if (defaultRule == null) {
                defaultRule = this.queryDefaultRule(bizModel.getId());
                if (defaultRule == null) {
                    if (controlParam.getAdjustCheckFlag()) {
                        controlParam.setAdjustCheckNoDefaultSetting(true);
                    } else {
                        ControlException.notDefaultRule((BizModel)bizModel);
                    }
                } else {
                    this.setControlParamSettingByDefaultRule(defaultRule, dt, controlParam);
                }
            } else {
                this.setControlParamSettingByDefaultRule(defaultRule, dt, controlParam);
            }
            if (!cacheGroupRuleMap.containsKey(ruleKey = BgControlUtils.getMemberKey(controlParam, false, true, true, bizModel.getDimensions())) && bizTimeIndex >= 0) {
                rule = this.getRule(controlData, bizModel.getDimensions(), controlParam, ruleMap, false, proMaps, oboMemberNumberMapByRuleIds, oboDimIdMap, cacheGroupRuleMap.computeIfAbsent(ruleKey, f -> new ArrayList(10)));
                cacheRuleMap.put(ruleKey, rule);
            }
            if (cacheGroupRuleMap.get(ruleKey) == null) continue;
            for (DynamicObject r : (List)cacheGroupRuleMap.get(ruleKey)) {
                rule = r;
                if (rule == null || (groupNo = (setting = BgControlSetting.loadFromDynamicobject(rule)).getGroupNo()) <= 0) continue;
                groupNos.add(groupNo);
                this.handleRuleOboDimsAndOboMemMap(setting, oboMemberNumberMapByRuleIds, oboDimIdMap);
                controlParam.getActParentGroupSetting().add(setting);
            }
        }
        if (!groupNos.isEmpty()) {
            HashMap<Integer, List<BgControlSetting>> groupRuleMap = new HashMap<Integer, List<BgControlSetting>>();
            ArrayList<BgControlSetting> _rules = null;
            builder = new QFBuilder();
            builder.add(new QFilter("model", "=", (Object)bizModel.getId()));
            if (!bizModel.isEBByModel()) {
                builder.add(new QFilter("bussmodel", "=", (Object)bizModel.getControlBusModelId()));
            }
            builder.add(new QFilter("group.groupseq", "in", groupNos));
            long time02 = System.currentTimeMillis();
            mainRuleObjs = QueryServiceHelper.query((String)"eb_bgcontrolrulemain", (String)RULE_FIELDS_MAIN, (QFilter[])builder.toArrays());
            time02 = System.currentTimeMillis() - time02;
            long time02_1 = System.currentTimeMillis();
            userDefinedRuleObjs = QueryServiceHelper.query((String)"eb_bgcontrolrulemain", (String)RULE_FIELDS_USER_DEFINED, (QFilter[])builder.toArrays());
            time02_1 = System.currentTimeMillis() - time02_1;
            BgControlLogUtils.info(controlData.getStats(), controlParams.iterator().next().isNeedLog(), "budget-control-log : use_time_mainRuleObjs_size:" + mainRuleObjs.size() + "_query_time02:" + time02 + "_userDefinedRuleObjs_size:" + userDefinedRuleObjs.size() + "_query_time02_1:" + time02_1);
            long time2 = System.currentTimeMillis();
            ruleObjs = this.handleRuleObjs(mainRuleObjs, userDefinedRuleObjs, dt, false);
            time2 = System.currentTimeMillis() - time2;
            BgControlLogUtils.info(controlData.getStats(), controlParams.iterator().next().isNeedLog(), "budget-control-log : use_time_handleRuleObjs_time2:" + time2);
            if (ruleObjs != null && !ruleObjs.isEmpty()) {
                for (DynamicObject ruleObj : ruleObjs) {
                    groupNo = ruleObj.getDynamicObject(MAIN_RULE_FIELD).getInt("group.groupseq");
                    _rules = (ArrayList<BgControlSetting>)groupRuleMap.get(groupNo);
                    if (_rules == null) {
                        _rules = new ArrayList<BgControlSetting>();
                        groupRuleMap.put(groupNo, _rules);
                    }
                    setting = BgControlSetting.loadFromDynamicobject(ruleObj);
                    setting.initMemberMap();
                    this.handleRuleOboDimsAndOboMemMap(setting, oboMemberNumberMapByRuleIds, oboDimIdMap);
                    _rules.add(setting);
                }
                for (IControlParam controlParam : controlParams) {
                    groupNo = controlParam.getSetting().getGroupNo();
                    if (groupNo <= 0) continue;
                    controlParam.setGroupRuleMap(groupRuleMap);
                }
            }
        }
    }

    private void setControlParamSettingByDefaultRule(DynamicObject defaultRule, DynamicObjectType dt, IControlParam controlParam) {
        DynamicObject dynamicObject = new DynamicObject(dt);
        dynamicObject.beginInit();
        dynamicObject.set(MAIN_RULE_FIELD, (Object)defaultRule);
        this.handleRuleObjUserDefinedFieldDynamicObject(dynamicObject);
        dynamicObject.endInit();
        controlParam.setSetting(BgControlSetting.loadFromDynamicobject(dynamicObject));
        controlParam.getSetting().setDefault(true);
    }

    private void handleRuleOboDimsAndOboMemMap(BgControlSetting setting, Map<Long, Map<Long, Set<String>>> oboMemberMapByRuleIds, Map<Long, List<Long>> oboDimIdMap) {
        if (setting == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)oboDimIdMap.get(setting.getId()))) {
            setting.setOboDimIds(oboDimIdMap.get(setting.getId()));
        }
        if (oboMemberMapByRuleIds.get(setting.getId()) != null && !oboMemberMapByRuleIds.get(setting.getId()).isEmpty()) {
            setting.setOboMemberNumberMap(oboMemberMapByRuleIds.get(setting.getId()));
        }
    }

    private void handleRuleObjUserDefinedFieldDynamicObject(DynamicObject dynamicObject) {
        DynamicObjectType userDefinedFieldDt = new DynamicObjectType("userDefinedFieldDt");
        this.handleRuleObjDetailFieldDynamicObjectType(userDefinedFieldDt, RULE_FIELDS_USER_DEFINED);
        dynamicObject.set(USER_DEFINED_RULE_FIELD, (Object)new DynamicObject(userDefinedFieldDt));
    }

    private void handleRuleObjMainFieldDynamicObject(DynamicObject dynamicObject) {
        DynamicObjectType mainDt = new DynamicObjectType("mainFieldDt");
        this.handleRuleObjDetailFieldDynamicObjectType(mainDt, RULE_FIELDS_ACCOUNT_MAIN);
        dynamicObject.set(MAIN_RULE_FIELD, (Object)new DynamicObject(mainDt));
    }

    private void handleRuleObjectDynamicObjectType(DynamicObjectType dt) {
        dt.registerSimpleProperty(new DynamicSimpleProperty(MAIN_RULE_FIELD, DynamicObject.class, null));
        dt.registerSimpleProperty(new DynamicSimpleProperty(USER_DEFINED_RULE_FIELD, DynamicObject.class, null));
    }

    private void handleRuleObjDetailFieldDynamicObjectType(DynamicObjectType dt, String ruleDetailField) {
        String[] ruleDetailFieldArr;
        for (String field : ruleDetailFieldArr = ruleDetailField.split(",")) {
            if (LONG_RULE_FIELDS_SET.contains(field)) {
                dt.registerSimpleProperty(new DynamicSimpleProperty(field, Long.class, null));
                continue;
            }
            if (STRING_RULE_FIELDS_SET.contains(field)) {
                dt.registerSimpleProperty(new DynamicSimpleProperty(field, String.class, null));
                continue;
            }
            if (BIGDECIMAL_RULE_FIELDS_SET.contains(field)) {
                dt.registerSimpleProperty(new DynamicSimpleProperty(field, BigDecimal.class, null));
                continue;
            }
            if (BOOLEAN_RULE_FIELDS_SET.contains(field)) {
                dt.registerSimpleProperty(new DynamicSimpleProperty(field, Boolean.class, null));
                continue;
            }
            if (TIMESTAMP_RULE_FIELDS_SET.contains(field)) {
                dt.registerSimpleProperty(new DynamicSimpleProperty(field, Timestamp.class, null));
                continue;
            }
            if (!INTEGER_RULE_FIELDS_SET.contains(field)) continue;
            dt.registerSimpleProperty(new DynamicSimpleProperty(field, Integer.class, null));
        }
    }

    @NotNull
    private DynamicObjectCollection handleRuleObjs(DynamicObjectCollection acccountRuleObjs, DynamicObjectCollection userDefinedRuleObjs, DynamicObjectType dt, boolean needRemoveDup) {
        DynamicObjectCollection ruleObjs;
        block7: {
            ruleObjs = new DynamicObjectCollection();
            if (acccountRuleObjs == null || acccountRuleObjs.isEmpty()) break block7;
            Map<Long, List<DynamicObject>> grpAcccountRuleMap = acccountRuleObjs.stream().collect(Collectors.groupingBy(k -> k.getLong("id")));
            if (userDefinedRuleObjs != null && !userDefinedRuleObjs.isEmpty()) {
                Map<Long, List<DynamicObject>> grpUserDefinedRuleMap = userDefinedRuleObjs.stream().collect(Collectors.groupingBy(k -> k.getLong("id")));
                for (Map.Entry<Long, List<DynamicObject>> entry : grpAcccountRuleMap.entrySet()) {
                    Long ruleId = entry.getKey();
                    List<DynamicObject> accountRules = entry.getValue();
                    List<DynamicObject> userDefinedRules = grpUserDefinedRuleMap.get(ruleId);
                    for (DynamicObject accountRule : accountRules) {
                        if (CollectionUtils.isNotEmpty(userDefinedRules)) {
                            for (DynamicObject userDefinedRule : userDefinedRules) {
                                if (needRemoveDup && StringUtils.isNotEmpty((String)accountRule.getString("accounts.account.number")) && StringUtils.isNotEmpty((String)userDefinedRule.getString("dimentions.groupaccount.number")) && !StringUtils.equals((String)accountRule.getString("accounts.account.number"), (String)userDefinedRule.getString("dimentions.groupaccount.number"))) continue;
                                DynamicObject newRuleObj = new DynamicObject(dt);
                                newRuleObj.set(MAIN_RULE_FIELD, (Object)accountRule);
                                newRuleObj.set(USER_DEFINED_RULE_FIELD, (Object)userDefinedRule);
                                ruleObjs.add((Object)newRuleObj);
                            }
                            continue;
                        }
                        this.handleOnlyMainFieldRuleObj(dt, ruleObjs, accountRule);
                    }
                }
            } else {
                for (DynamicObject accountRule : acccountRuleObjs) {
                    this.handleOnlyMainFieldRuleObj(dt, ruleObjs, accountRule);
                }
            }
        }
        return ruleObjs;
    }

    private void handleOnlyMainFieldRuleObj(DynamicObjectType dt, DynamicObjectCollection ruleObjs, DynamicObject accountRule) {
        DynamicObject newRuleObj = new DynamicObject(dt);
        newRuleObj.set(MAIN_RULE_FIELD, (Object)accountRule);
        this.handleRuleObjUserDefinedFieldDynamicObject(newRuleObj);
        ruleObjs.add((Object)newRuleObj);
    }

    private DynamicObject getRule(BgControlData controlData, Collection<kd.epm.eb.common.model.Dimension> dimensions, IControlParam controlParam, Map<String, Map<String, List<DynamicObject>>> ruleMap, boolean isBudget, Map<Long, Set<Long>> proMaps, Map<Long, Map<Long, Set<String>>> oboMemberNumberMapByRuleIds, Map<Long, List<Long>> oboDimIdMap, List<DynamicObject> groupRules) {
        String[] stringArray;
        if (dimensions == null || controlParam == null || ruleMap == null) {
            return null;
        }
        DynamicObject rule = null;
        Member orgUnit = controlParam.getOrgUnit(true);
        Member account = controlParam.getAccount(isBudget);
        BgControlLogUtils.info(controlData.getStats(), controlParam.isNeedLog(), "budget-control-log : -rule-orgUnit-" + orgUnit.getLongNumber());
        BgControlLogUtils.info(controlData.getStats(), controlParam.isNeedLog(), "budget-control-log : -rule-account-" + account.getLongNumber());
        if (orgUnit.getLongNumber() != null) {
            stringArray = orgUnit.getLongNumber().split("!");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = orgUnit.getNumber();
        }
        String[] orgNumbers = stringArray;
        for (int i = orgNumbers.length - 1; i >= 0 && rule == null; --i) {
            Map<String, List<DynamicObject>> orgRuleMap = ruleMap.get(orgNumbers[i]);
            if (orgRuleMap == null || (rule = this.getRule(controlData, dimensions, controlParam, orgUnit, account, orgRuleMap, proMaps, oboMemberNumberMapByRuleIds, oboDimIdMap, groupRules)) == null) continue;
            controlParam.setSettingOrg(orgNumbers[i]);
        }
        return rule;
    }

    private DynamicObject getRule(BgControlData controlData, Collection<kd.epm.eb.common.model.Dimension> dimensions, IControlParam controlParam, Member entity, Member account, Map<String, List<DynamicObject>> orgRuleMap, Map<Long, Set<Long>> proMaps, Map<Long, Map<Long, Set<String>>> oboMemberNumberMapByRuleIds, Map<Long, List<Long>> oboDimIdMap, List<DynamicObject> groupRules) {
        if (dimensions == null || controlParam == null || account == null || orgRuleMap == null) {
            return null;
        }
        DynamicObject rule = null;
        List<DynamicObject> rules = null;
        DynamicObject acctRule = null;
        DynamicObject userdefRule = null;
        String userDefNumber = null;
        String memberNum = null;
        boolean hasExtDim = false;
        boolean hasRule = false;
        boolean ruleHasExt = false;
        boolean isonlygroup = false;
        int extDimSize = 0;
        int oldDimSize = 0;
        String[] tmpNums = account.getLongNumber().split("!");
        for (int i = tmpNums.length - 1; i >= 0; --i) {
            rules = orgRuleMap.get(tmpNums[i]);
            if (rules == null) continue;
            for (DynamicObject _rule : rules) {
                hasExtDim = false;
                ruleHasExt = false;
                hasRule = true;
                extDimSize = 0;
                if (!this.inclusiveTime(_rule, controlParam.getBizTime())) continue;
                for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                    if (!BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension)) continue;
                    Map<Long, Set<String>> oboMemberNumberMapByDimId = oboMemberNumberMapByRuleIds.get(_rule.getDynamicObject(MAIN_RULE_FIELD).getLong("id"));
                    userDefNumber = BgControlRuleUtils.getRuleMember(_rule, dimension, controlParam, oboMemberNumberMapByDimId);
                    if (StringUtils.isEmpty((String)userDefNumber)) {
                        userDefNumber = BgControlRuleUtils.getRuleMember(controlParam.getBizModel(), controlParam.getControlScheme(), _rule, dimension);
                    }
                    if (!StringUtils.isNotEmpty((String)userDefNumber) || dimension == null) continue;
                    hasExtDim = true;
                    Member member = controlParam.getMember(true, dimension.getNumber());
                    if (member == null) continue;
                    memberNum = member.getNumber();
                    BgControlLogUtils.info(controlData.getStats(), controlParam.isNeedLog(), "budget-control-log : " + dimension.getNumber() + "-" + userDefNumber + "/" + memberNum);
                    if (!memberNum.equals(userDefNumber)) {
                        hasRule = false;
                        break;
                    }
                    ++extDimSize;
                }
                try {
                    if (hasRule && groupRules != null && _rule.getDynamicObject(MAIN_RULE_FIELD).getInt("group.groupseq") > 0) {
                        groupRules.add(_rule);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (isonlygroup) continue;
                if (!hasExtDim && _rule != null) {
                    for (int d = 1; d <= 7; ++d) {
                        if (!StringUtils.isNotEmpty((String)_rule.getDynamicObject(USER_DEFINED_RULE_FIELD).getString("dimentions.userdefined" + d + ".number"))) continue;
                        ruleHasExt = true;
                        break;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)oboDimIdMap.get(_rule.getDynamicObject(MAIN_RULE_FIELD).getLong("id")))) {
                        ruleHasExt = true;
                    }
                }
                if (!hasExtDim && !ruleHasExt) {
                    if (acctRule == null) {
                        BgControlLogUtils.info(controlData.getStats(), controlParam.isNeedLog(), "budget-control-log : acctRule = " + JSONUtils.toString((Object)_rule));
                        acctRule = _rule;
                    } else if (acctRule.get(MAIN_RULE_FIELD) != null && acctRule.getDynamicObject(MAIN_RULE_FIELD).getString("accounts.account.number").equals(tmpNums[i])) {
                        this.hasMorePropertyRule(controlParam, acctRule, _rule, proMaps, entity, account);
                    }
                }
                if (!hasExtDim || !hasRule) continue;
                BgControlLogUtils.info(controlData.getStats(), controlParam.isNeedLog(), "budget-control-log : oldDimSize = " + oldDimSize + " extDimSize = " + extDimSize + " Rule = " + JSONUtils.toString((Object)_rule));
                if (oldDimSize == extDimSize && (acctRule == null || acctRule != null && acctRule.get(MAIN_RULE_FIELD) != null && acctRule.getDynamicObject(MAIN_RULE_FIELD) != null && StringUtils.equals((String)acctRule.getDynamicObject(MAIN_RULE_FIELD).getString("accounts.account.number"), (String)tmpNums[i]))) {
                    this.hasMorePropertyRule(controlParam, userdefRule, _rule, proMaps, entity, account);
                }
                if (userdefRule == null) {
                    userdefRule = _rule;
                } else if (extDimSize > oldDimSize) {
                    userdefRule = _rule;
                } else if (groupRules == null) {
                    isonlygroup = true;
                    continue;
                }
                rule = userdefRule;
                oldDimSize = extDimSize;
            }
            if (rule != null || acctRule == null) continue;
            BgControlLogUtils.info(controlData.getStats(), controlParam.isNeedLog(), "budget-control-log :  use acctRule = " + JSONUtils.toString(acctRule));
            rule = acctRule;
        }
        return rule;
    }

    private void hasMorePropertyRule(IControlParam controlParam, DynamicObject existRule, DynamicObject newRule, Map<Long, Set<Long>> proMaps, Member entity, Member account) {
        Long provalId1 = null;
        Long provalId2 = null;
        if (proMaps.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, Set<Long>> entry : proMaps.entrySet()) {
            Set<Long> mainIds = entry.getValue();
            if (mainIds.contains(existRule.getDynamicObject(MAIN_RULE_FIELD).getLong("id"))) {
                provalId1 = entry.getKey();
            }
            if (!mainIds.contains(newRule.getDynamicObject(MAIN_RULE_FIELD).getLong("id"))) continue;
            provalId2 = entry.getKey();
        }
        if (provalId1 != null && provalId2 != null && !provalId1.equals(provalId2)) {
            DynamicObject bussObj;
            MemberPropCache propCache = MemberPropCacheService.getOrCreate((Long)existRule.getDynamicObject(MAIN_RULE_FIELD).getLong("model"));
            String pn1 = propCache.getPropertyValue(provalId1).getName();
            String pn2 = propCache.getPropertyValue(provalId2).getName();
            String businessmodelName = null;
            if (CommonUtils.isBgmdModel((Long)controlParam.getBizModel().getId()) && (bussObj = BusinessDataServiceHelper.loadSingle((Object)controlParam.getBizModel().getControlBusModelId(), (String)"eb_businessmodel")) != null) {
                businessmodelName = bussObj.getString("name");
            }
            throw new KDBizException(new ErrorCode("EB090002", ResourceUtils.repeatProp((String)controlParam.getBizModel().getName(), (String)businessmodelName, (String)entity.getName(), (String)(pn1 + "\u3001" + pn2), (String)account.getName())), new Object[0]);
        }
    }

    private boolean inclusiveTime(DynamicObject rule, Date bizTime) {
        if (rule == null || bizTime == null) {
            return false;
        }
        boolean inclusive = true;
        Date effectiveDate = rule.getDynamicObject(MAIN_RULE_FIELD).getDate("effectivedate");
        Date invalidDate = rule.getDynamicObject(MAIN_RULE_FIELD).getDate("invaliddate");
        if (effectiveDate == null && invalidDate == null) {
            return true;
        }
        if (effectiveDate != null && bizTime.before(effectiveDate)) {
            inclusive = false;
        }
        if (invalidDate != null && new CalendarHelper().getBeoverDate(invalidDate).before(bizTime)) {
            inclusive = false;
        }
        return inclusive;
    }

    protected DynamicObject queryDefaultRule(long modelId) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model.id", "=", (Object)modelId));
        builder.add(new QFilter("isdefault", "=", (Object)Character.valueOf('1')));
        return QueryServiceHelper.queryOne((String)"eb_bgcontrolrulemain", (String)RULE_FIELDS_ACCOUNT_MAIN, (QFilter[])builder.toArrays());
    }

    public static String getRuleMember(DynamicObject rule, kd.epm.eb.common.model.Dimension dimension, IControlParam controlParam, Map<Long, Set<String>> oboMemNumMapByDimId) {
        if (rule == null) {
            return null;
        }
        Set<Object> oboMemberNumbers = new HashSet(16);
        if (oboMemNumMapByDimId != null) {
            oboMemberNumbers = oboMemNumMapByDimId.get(dimension.getId());
        }
        if (CollectionUtils.isNotEmpty(oboMemberNumbers)) {
            Member member = controlParam.getMember(true, dimension.getNumber());
            if (CollectionUtils.isNotEmpty(oboMemberNumbers) && member != null) {
                String memberNumber = member.getNumber();
                if (oboMemberNumbers.contains(memberNumber)) {
                    return memberNumber;
                }
                return (String)oboMemberNumbers.iterator().next();
            }
        } else {
            Long dimId = null;
            for (int i = 1; i <= 7; ++i) {
                dimId = rule.getDynamicObject(USER_DEFINED_RULE_FIELD).getLong("dimentions.userdefineddimid" + i);
                if (dimId == null || dimId.compareTo(dimension.getId()) != 0) continue;
                return rule.getDynamicObject(USER_DEFINED_RULE_FIELD).getString("dimentions.userdefined" + i + ".number");
            }
        }
        return null;
    }

    public static Map<Long, List<Long>> getGroupRuleOboDimIdMap(Set<Long> ruleIds) {
        Map<Long, List<Long>> oboDimIdMapByRuleId = new HashMap<Long, List<Long>>(ruleIds.size());
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "in", ruleIds));
        builder.add(new QFilter("groupdims.isobodim", "=", (Object)true));
        String selectFiles = "id,groupdims.groupdim";
        DynamicObjectCollection oboDims = QueryServiceHelper.query((String)"eb_bgcontrolrulemain", (String)selectFiles, (QFilter[])builder.toArrays(), (String)"");
        if (oboDims != null && !oboDims.isEmpty()) {
            oboDimIdMapByRuleId = oboDims.stream().collect(Collectors.groupingBy(k -> k.getLong("id"), Collectors.mapping(k -> k.getLong("groupdims.groupdim"), Collectors.toList())));
        }
        return oboDimIdMapByRuleId;
    }

    public static String getRuleMember(BizModel bizModel, BgControlScheme controlScheme, DynamicObject rule, kd.epm.eb.common.model.Dimension dimension) {
        if (bizModel == null || controlScheme == null || rule == null) {
            return null;
        }
        if (rule.getDataEntityType().getProperties().get((Object)USER_DEFINED_RULE_FIELD) != null) {
            for (int i = 1; i <= 7; ++i) {
                DynamicObject dynamicObject = rule.getDynamicObject(USER_DEFINED_RULE_FIELD);
                if (dynamicObject.get("dimentions.userdefineddimid" + i) == null || dynamicObject.getLong("dimentions.userdefineddimid" + i) != dimension.getId().longValue()) continue;
                return dynamicObject.getString("dimentions.userdefined" + i + ".number");
            }
        }
        return null;
    }

    @NotNull
    public static XSSFWorkbook createWorkBook(Long modelId, Long bussModelId) {
        boolean bgmdModelFlag = CommonUtils.isBgmdModel((Long)modelId);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        boolean ebModelFlag = modelCacheHelper.getModelobj().isModelByEB();
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFCellStyle style = workBook.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFCellStyle headerStyle = workBook.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFSheet xssfSheet = workBook.createSheet();
        xssfSheet.setColumnWidth(0, 10000);
        ArrayList<Dimension> businessModelList = new ArrayList(16);
        ArrayList<DynamicObject> userDefineDimensionList = new ArrayList(16);
        if (bgmdModelFlag || ModelUtil.isBGModel(modelId)) {
            businessModelList = BgControlRuleUtils.getBusinessModelList(modelId, bussModelId);
        } else {
            userDefineDimensionList = DimensionServiceHelper.getUserDefineDimensionList(modelId, true);
        }
        List<String> headerList = BgControlRuleUtils.getHeaderList(modelId, bgmdModelFlag, businessModelList, userDefineDimensionList);
        for (int i = 0; i < 3; ++i) {
            XSSFRow headerRow1 = xssfSheet.createRow(i);
            XSSFCell cell0 = headerRow1.createCell(0, CellType.STRING);
            XSSFCell cell1 = headerRow1.createCell(1, CellType.STRING);
            if (i == 0) {
                cell0.setCellValue(ResManager.loadKDString((String)"\u63a7\u5236\u65b9\u5f0f\u8bbe\u7f6e", (String)"BgControlRuleUtils_15", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            if (i == 1) {
                cell0.setCellValue(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801*", (String)"BgControlRuleUtils_16", (String)"epm-eb-business", (Object[])new Object[0]));
                cell1.setCellValue(modelCacheHelper.getModelobj().getNumber());
            }
            if (i != 2) continue;
            if (ebModelFlag) {
                cell0.setCellValue(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u7f16\u7801*", (String)"BgControlRuleUtils_17", (String)"epm-eb-business", (Object[])new Object[0]));
                headerRow1.setZeroHeight(true);
            }
            if (bgmdModelFlag || ModelUtil.isBGModel(modelId)) {
                cell0.setCellValue(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u7f16\u7801*", (String)"BgControlRuleUtils_17", (String)"epm-eb-business", (Object[])new Object[0]));
                DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)bussModelId, (String)"eb_businessmodel");
                if (object != null) {
                    cell1.setCellValue(object.getString("number"));
                } else {
                    cell1.setCellValue("");
                }
                cell1.setCellStyle((CellStyle)style);
                headerRow1.setZeroHeight(true);
            }
            cell0.setCellStyle((CellStyle)style);
        }
        XSSFRow headerRow1 = xssfSheet.createRow(3);
        for (int i = 0; i < headerList.size(); ++i) {
            String columnName = headerList.get(i);
            xssfSheet.setColumnWidth(i, 5000);
            XSSFCell cell = headerRow1.createCell(i, CellType.STRING);
            cell.setCellValue(columnName);
            cell.setCellStyle((CellStyle)style);
            FileImportUtils fileImportUtils = FileImportUtils.getInstance();
            if (BgControlRuleUtils.getGroupDimCn().equals(columnName)) {
                fileImportUtils.setCellTips((Cell)cell, ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u5206\u7ec4\u63a7\u5236\u65b9\u5f0f\u65f6\u53ef\u586b\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6\u4e2d\u7684\u81ea\u5b9a\u4e49\u7ef4\u5ea6\uff0c\u53ef\u591a\u9009\u7528\u9017\u53f7\u5206\u9694\uff0c\u586b\u5199\u683c\u5f0f\u7ef4\u5ea6\u540d\u79f0#\u7ef4\u5ea6\u7f16\u7801", (String)"BgControlRuleUtils_0", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            if (BgControlRuleUtils.getOboDimCn().equals(columnName)) {
                fileImportUtils.setCellTips((Cell)cell, ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u586b\u5199\u8981\u6c42\u4e0e\u5206\u7ec4\u7ef4\u5ea6\u4e00\u81f4\uff0c\u4e0d\u80fd\u4e0e\u5206\u7ec4\u7ef4\u5ea6\u7684\u5df2\u9009\u7ef4\u5ea6\u76f8\u540c\u3002\u9010\u4e00\u5206\u7ec4\u7ef4\u5ea6\u7684\u6210\u5458\u53ca\u8303\u56f4\u586b\u5728\u5bf9\u5e94\u7684\u7ef4\u5ea6\u5217\uff0c\u53ef\u591a\u9009\u7528\u9017\u53f7\u5206\u9694\uff0c\u7ef4\u5ea6\u6210\u5458\u540d\u79f0\u586b\u5199\u683c\u5f0f\u7ef4\u5ea6\u6210\u5458\u540d\u79f0#\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u540d\u79f0\uff0c\u8303\u56f4\u540d\u79f0\u4ec5\u53ef\u9009\u6240\u6709\u4e0b\u7ea7_\u542b\u81ea\u5df1\uff0850\uff09\u6216\u6240\u6709\u4e0b\u7ea7_\u4ec5\u660e\u7ec6\u6210\u5458\uff0890\uff09\u3002\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u586b\u5199\u683c\u5f0f\u7ef4\u5ea6\u6210\u5458\u7f16\u7801#\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u7f16\u7801\uff0c\u8303\u56f4\u7f16\u7801\u4ec5\u53ef\u900950\u621690", (String)"BgControlRuleUtils_1", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            if (BgControlRuleUtils.getGroupDimGroupByNameCn().equals(columnName)) {
                fileImportUtils.setCellTips((Cell)cell, ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u53ef\u591a\u9009\u7528\u9017\u53f7\u5206\u9694\uff0c\u586b\u5199\u683c\u5f0f\u7ef4\u5ea6\u6210\u5458\u540d\u79f0#\u7ef4\u5ea6\u6210\u5458\u540d\u79f0\uff0c\u5982\u679c\u5206\u7ec4\u7ef4\u5ea6\u662f\u5927\u6392\u5217\u7ec4\u5408\uff0c\u65e0\u9700\u586b\u5199\u5206\u7ec4\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0\uff1b\u5982\u679c\u5206\u7ec4\u7ef4\u5ea6\u4e0d\u662f\u5927\u6392\u5217\u7ec4\u5408\uff0c\u5219\u9700\u8981\u586b\u5199\u5206\u7ec4\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0\uff0c\u6309\u7167\u6240\u586b\u7684\u7ef4\u5ea6\u7ec4\u5408\u751f\u6210\u5206\u7ec4\u6210\u5458\u8bb0\u5f55\u3002", (String)"BgControlRuleUtils_2", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            if (BgControlRuleUtils.getGroupDimGroupByNumberCn().equals(columnName)) {
                fileImportUtils.setCellTips((Cell)cell, ResManager.loadKDString((String)"\u975e\u5fc5\u586b\u9879\uff0c\u53ef\u591a\u9009\u7528\u9017\u53f7\u5206\u9694\uff0c\u586b\u5199\u683c\u5f0f\uff1a\u7ef4\u5ea6\u6210\u5458\u7f16\u7801#\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\uff0c\u5982\u679c\u5206\u7ec4\u6210\u5458\u662f\u5206\u7ec4\u7ef4\u5ea6\u7684\u5927\u6392\u5217\u7ec4\u5408\uff0c\u65e0\u9700\u586b\u5199\u5206\u7ec4\u7ef4\u5ea6\u7ec4\u5408\u7f16\u7801\uff1b\u5982\u679c\u5206\u7ec4\u6210\u5458\u4e0d\u662f\u5927\u6392\u5217\u7ec4\u5408\uff0c\u5219\u9700\u8981\u586b\u5199\u5206\u7ec4\u7ef4\u5ea6\u7ec4\u5408\u7f16\u7801\uff0c\u6309\u7167\u6240\u586b\u7684\u7ef4\u5ea6\u7ec4\u5408\u751f\u6210\u5206\u7ec4\u6210\u5458\u8bb0\u5f55\u3002", (String)"BgControlRuleUtils_3", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            if (ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u5c5e\u6027\u7f16\u7801", (String)"RuleControlImportPlugin_78", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(columnName)) {
                fileImportUtils.setCellTips((Cell)cell, ResManager.loadKDString((String)"\u5982\u679c\u591a\u5c5e\u6027\u5206\u7c7b\u7684\u6210\u5458\u7f16\u7801\u91cd\u590d\uff0c\u5219\u9700\u8981\u6807\u6ce8\u5c5e\u6027\u5206\u7c7b\uff0c\u683c\u5f0f\uff1a\u5206\u7c7b\u7f16\u7801!\u6210\u5458\u7f16\u7801\uff1b\u5982\u679c\u672a\u6807\u6ce8\u5c5e\u6027\u5206\u7c7b\u7f16\u7801\uff0c\u5219\u540c\u65f6\u5339\u914d\u591a\u5c5e\u6027\u5206\u7c7b\u7684\u76f8\u540c\u7f16\u7801\u6210\u5458\u3002", (String)"BgControlRuleUtils_18", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            if (BgControlRuleUtils.getPeriodClassifyCn().equals(columnName)) {
                String[] periodClassifyArray = (String[])Arrays.stream(RulePeriodClassifyEnum.values()).map(RulePeriodClassifyEnum::getName).toArray(String[]::new);
                fileImportUtils.setColumnFormatAsCombo((Sheet)xssfSheet, i, periodClassifyArray);
            }
            if (!BgControlRuleUtils.getControlTypeCn().equals(columnName)) continue;
            String[] controlTypeArray = (String[])Arrays.stream(RuleControlTypeEnum.values()).map(RuleControlTypeEnum::getName).toArray(String[]::new);
            fileImportUtils.setColumnFormatAsCombo((Sheet)xssfSheet, i, controlTypeArray);
        }
        return workBook;
    }

    @NotNull
    public static List<String> getHeaderList(Long modelId, boolean bgmdModelFlag, List<Dimension> businessModelList, List<DynamicObject> userDefineDimensionList) {
        ArrayList<String> headerList = new ArrayList<String>(16);
        headerList.add(ResManager.loadKDString((String)"\u5206\u7ec4\u63a7\u5236\u540d\u79f0", (String)"BgControlRuleUtils_4", (String)"epm-eb-business", (Object[])new Object[0]));
        headerList.add(BgControlRuleUtils.getGroupDimCn());
        headerList.add(BgControlRuleUtils.getOboDimCn());
        headerList.add(ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0\uff08\u53ef\u591a\u9009\u7528\u9017\u53f7\u5206\u9694\uff09", (String)"BgControlRuleUtils_5", (String)"epm-eb-business", (Object[])new Object[0]));
        headerList.add(ResManager.loadKDString((String)"\u79d1\u76ee\u5185\u7801*\uff08\u53ef\u591a\u9009\u7528\u9017\u53f7\u5206\u9694\uff09", (String)"BgControlRuleUtils_6", (String)"epm-eb-business", (Object[])new Object[0]));
        if (bgmdModelFlag || ModelUtil.isBGModel(modelId)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < businessModelList.size(); ++i) {
                StringBuilder temp = new StringBuilder();
                Dimension dimension = businessModelList.get(i);
                temp.append(dimension.getName()).append('#').append(dimension.getNumber()).append('.');
                headerList.add(sb.append((CharSequence)temp).append("name").toString());
                sb.delete(0, sb.length());
                headerList.add(sb.append((CharSequence)temp).append("number").toString());
                sb.delete(0, sb.length());
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < userDefineDimensionList.size(); ++i) {
                StringBuilder temp = new StringBuilder();
                DynamicObject object = userDefineDimensionList.get(i);
                temp.append(object.getString("name")).append('#').append(object.getString("number")).append('.');
                headerList.add(sb.append((CharSequence)temp).append("name").toString());
                sb.delete(0, sb.length());
                headerList.add(sb.append((CharSequence)temp).append("number").toString());
                sb.delete(0, sb.length());
            }
        }
        headerList.add(BgControlRuleUtils.getPeriodClassifyCn());
        headerList.add(BgControlRuleUtils.getControlTypeCn());
        headerList.add(ResManager.loadKDString((String)"\u67d4\u6027\u7cfb\u6570*", (String)"BgControlRuleUtils_9", (String)"epm-eb-business", (Object[])new Object[0]));
        headerList.add(ResManager.loadKDString((String)"\u662f\u5426\u5141\u8bb8\u8d85\u9884\u7b97*", (String)"BgControlRuleUtils_10", (String)"epm-eb-business", (Object[])new Object[0]));
        headerList.add(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u5185\u7801", (String)"BgControlRuleUtils_11", (String)"epm-eb-business", (Object[])new Object[0]));
        headerList.add(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7", (String)"BgControlRuleUtils_12", (String)"epm-eb-business", (Object[])new Object[0]));
        headerList.add(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u5c5e\u6027\u7f16\u7801", (String)"RuleControlImportPlugin_78", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        headerList.add(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u5c5e\u6027", (String)"RuleControlImportPlugin_79", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        headerList.add(BgControlRuleUtils.getGroupDimGroupByNameCn());
        headerList.add(BgControlRuleUtils.getGroupDimGroupByNumberCn());
        headerList.add(ResManager.loadKDString((String)"\u8bf4\u660e", (String)"RuleControlListPlugin_63", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        headerList.add(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"BgControlRuleUtils_13", (String)"epm-eb-business", (Object[])new Object[0]));
        headerList.add(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f", (String)"BgControlRuleUtils_14", (String)"epm-eb-business", (Object[])new Object[0]));
        return headerList;
    }

    public static List<Dimension> getBusinessModelList(Long modelId, Long bussModelId) {
        ArrayList<Object> dimensions = new ArrayList<Dimension>(10);
        if (modelId == null || modelId == 0L) {
            return dimensions;
        }
        if (CommonUtils.isBgmdModel((Long)modelId) || ModelUtil.isBGModel(modelId)) {
            dimensions = new ArrayList(10);
            DynamicObject model = ModelUtils.getModel((Long)modelId);
            QFilter qFilter = new QFilter("model", "=", (Object)model.getLong("id"));
            if (IDUtils.isNotEmptyLong((Long)bussModelId).booleanValue()) {
                qFilter.and(new QFilter("businessmodel", "=", (Object)bussModelId));
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgmcontroldimension", (String)"entryentity.dimensionid", (QFilter[])new QFilter[]{qFilter});
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            for (DynamicObject dynamicObject : query) {
                long dimId = dynamicObject.getLong("entryentity.dimensionid");
                Dimension dimension = modelCache.getDimension(Long.valueOf(dimId));
                if (!"epm_userdefinedmembertree".equals(dimension.getMemberModel())) continue;
                dimensions.add(dimension);
            }
            dimensions.sort(Comparator.comparingInt(BaseCache::getSeq));
        }
        return dimensions;
    }

    private List<Map<String, Object>> getPropValueId(Long modelId, Set<String> orgNums) {
        ArrayList<Map<String, Object>> proList = new ArrayList<Map<String, Object>>(16);
        StringBuilder sql = new StringBuilder("select b.fpropertyvalueid,a.fnumber,c.fname,c.fpropertyid from t_eb_structofent a,t_eb_memberpropertyvalue b,t_eb_custompropertyvalue c ");
        sql.append("where a.fid = b.fid and b.fpropertyvalueid = c.fid and a.fmodelid = ");
        sql.append(modelId);
        sql.append(" and a.fnumber in ('");
        sql.append(StringUtils.join(orgNums, (String)"','"));
        sql.append("')");
        try (DataSet ds = DB.queryDataSet((String)"dimensionproperty", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            if (ds != null) {
                List list = CommonServiceHelper.transDataSet((DataSet)ds);
                return list;
            }
        }
        return proList;
    }

    public static Map<Long, Map<Long, Set<String>>> getGroupRuleOboMemberNumberMapByRuleIds(Set<Long> ids) {
        HashMap<Long, Map<Long, Set<String>>> oboMemberNumberMapByRuleId = new HashMap<Long, Map<Long, Set<String>>>(ids.size());
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "in", ids));
        builder.add(new QFilter("groupdims.isobodim", "=", (Object)true));
        String selectFiles = "id,model,bussmodel,groupdims.groupdim.id,groupdims.groupdim.number,obomemranges.obomember.id,obomemranges.obomember.number,obomemranges.obodim.id,obomemranges.obodim.number,obomemranges.memrange";
        DynamicObjectCollection oboMemberRanges = QueryServiceHelper.query((String)"eb_bgcontrolrulemain", (String)selectFiles, (QFilter[])builder.toArrays(), (String)"");
        if (oboMemberRanges != null && !oboMemberRanges.isEmpty()) {
            Map<Long, List<DynamicObject>> grpOboMemberRangeMapByRuleId = oboMemberRanges.stream().collect(Collectors.groupingBy(k -> k.getLong("id")));
            Long viewId = 0L;
            for (Map.Entry<Long, List<DynamicObject>> entry : grpOboMemberRangeMapByRuleId.entrySet()) {
                Long ruleId = entry.getKey();
                List<DynamicObject> oboMemsByRule = entry.getValue();
                long modelId = oboMemsByRule.get(0).getLong("model");
                long bussModel = oboMemsByRule.get(0).getLong("bussmodel");
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                Map<Long, List<DynamicObject>> grpOboMemberRangeMap = oboMemsByRule.stream().collect(Collectors.groupingBy(k -> k.getLong("groupdims.groupdim.id")));
                HashMap oboMemberNumberMap = new HashMap(16);
                for (Map.Entry<Long, List<DynamicObject>> oboMemEntry : grpOboMemberRangeMap.entrySet()) {
                    Long oboDimId = oboMemEntry.getKey();
                    List<DynamicObject> oboMems = oboMemEntry.getValue();
                    Dimension dimension = modelCacheHelper.getDimension(oboDimId);
                    if (IDUtils.isNotEmptyLong((Long)bussModel).booleanValue()) {
                        viewId = modelCacheHelper.getViewByBusModelAndDimNumber(Long.valueOf(bussModel), dimension.getNumber());
                    }
                    HashSet members = new HashSet(16);
                    Set<Object> memberNumbers = new HashSet(16);
                    for (DynamicObject oboMem : oboMems) {
                        if (IDUtils.equals((Object)oboMem.getLong("groupdims.groupdim.id"), (Object)oboMem.getLong("obomemranges.obodim.id")) && IDUtils.isNotEmptyLong((Long)oboMem.getLong("obomemranges.obomember.id")).booleanValue()) {
                            members.addAll(modelCacheHelper.getMember(oboMem.getString("obomemranges.obodim.number"), viewId, oboMem.getString("obomemranges.obomember.number"), RangeEnum.getRangeByVal((int)Integer.parseInt(oboMem.getString("obomemranges.memrange"))).getIndex()));
                            continue;
                        }
                        members.addAll(modelCacheHelper.getMember(oboMem.getString("groupdims.groupdim.number"), viewId, oboMem.getString("groupdims.groupdim.number"), RangeEnum.ALL.getIndex()));
                    }
                    memberNumbers = members.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    oboMemberNumberMap.put(oboDimId, memberNumbers);
                }
                oboMemberNumberMapByRuleId.put(ruleId, oboMemberNumberMap);
            }
        }
        return oboMemberNumberMapByRuleId;
    }
}

