/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.impl.model.BgControlSchemeValueField;
import kd.epm.eb.control.impl.model.WriteOff;
import kd.epm.eb.control.utils.BgControlLogUtils;

public class BgControlSchemeUtils {
    private static final Log log = LogFactory.getLog(BgControlSchemeUtils.class);

    public static Map<String, Collection<BgControlScheme>> query(BgControlData controlData, String entityNumber, Boolean checkEmpty) {
        return BgControlSchemeUtils.query(controlData, entityNumber, false, checkEmpty);
    }

    public static Map<String, Collection<BgControlScheme>> query(BgControlData controlData, String entityNumber, boolean isBatch, Boolean checkEmpty) {
        return BgControlSchemeUtils.query(controlData, entityNumber, isBatch, false, checkEmpty);
    }

    public static Map<String, Collection<BgControlScheme>> query(BgControlData controlData, String entityNumber, boolean isBatch, boolean isQueryAll, Boolean checkEmpty) {
        DynamicObject[] groups;
        HashMap<String, Collection<BgControlScheme>> controlSchemes = new HashMap<String, Collection<BgControlScheme>>(10);
        if (StringUtils.isEmpty((String)entityNumber) || controlData == null || controlData.getBizModels() == null || controlData.getBizModels().isEmpty()) {
            return controlSchemes;
        }
        SqlBuilder groupSql = new SqlBuilder();
        groupSql.append("select g.fid from t_eb_dimmaterulegroup g inner join t_eb_structofbill b on g.fbill = b.fid", new Object[0]);
        groupSql.append(" where", new Object[0]);
        groupSql.append(" b.fnumber = ?", new Object[]{entityNumber});
        if (!isQueryAll) {
            groupSql.append(" and g.fstatus = ?", new Object[]{Character.valueOf('1')});
        }
        groupSql.append(" order by g.fnumber", new Object[0]);
        LinkedHashSet groupIds = new LinkedHashSet(10);
        try (DataSet ds = DB.queryDataSet((String)"queryControlSchemaEntry", (DBRoute)BgBaseConstant.epm, (SqlBuilder)groupSql);){
            if (ds != null) {
                ds.forEach(f -> groupIds.add(f.getLong("fid")));
            }
        }
        if (groupIds.isEmpty()) {
            if (checkEmpty.booleanValue()) {
                ControlException.notDimensionMappings((String)entityNumber);
            }
            return controlSchemes;
        }
        if (!controlData.isMultiControl() && groupIds.size() > 1) {
            ControlException.errorMoreGroup((String)entityNumber);
            return controlSchemes;
        }
        HashSet<Long> modelIds = new HashSet<Long>(controlData.getBizModels().size());
        HashSet<Long> busModelIds = new HashSet<Long>(controlData.getBizModels().size());
        for (BizModel bizModel : controlData.getBizModels().values()) {
            modelIds.add(bizModel.getId());
            if (bizModel.getControlBusModelId() == null) {
                busModelIds.add(0L);
                continue;
            }
            busModelIds.add(bizModel.getControlBusModelId());
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select g.fisonlycheck, t.fisonlycontrolsuit, g.fnumber groupnumber, g.fbill,g.fisdynamicvalue, t.fid, t.fwriteoffschemeid, t.fmodelid, t.fdetailid, t.fbillid, t.fnumber, t.fbussmodelid,t.feffectivetime,t.finvalidtime,t.fentryfieldid, t.faccountfieldid, t.fyearfieldid, t.fcurrencyfieldid, t.fchangetypefield, t.fmetricfield, t.fuserdefined1fieldid, t.fuserdefined2fieldid, t.fuserdefined3fieldid, t.fuserdefined4fieldid, t.fuserdefined5fieldid, t.fuserdefined6fieldid, t.fentryfieldextid, t.faccountfieldextid, t.fcurrencyfieldextid, t.fchangetypefieldextid, t.fuserdefined1fieldextid, t.fuserdefined2fieldextid, t.fuserdefined3fieldextid, t.fuserdefined4fieldextid, t.fuserdefined5fieldextid, t.fuserdefined6fieldextid, t.fentrydimsionmapid, t.faccountdimsionmapid, t.fcurrencydimsionmapid, t.fchangetypedimsionmapid, t.fuserdefined1dimsionmapid, t.fuserdefined2dimsionmapid, t.fuserdefined3dimsionmapid, t.fuserdefined4dimsionmapid, t.fuserdefined5dimsionmapid, t.fuserdefined6dimsionmapid, t.fuserdefineddimid1, t.fuserdefineddimid2, t.fuserdefineddimid3, t.fuserdefineddimid4, t.fuserdefineddimid5, t.fuserdefineddimid6, t.fqfilter,t.fserqfilter, t.fpriority from t_eb_dimmaterulebill t inner join t_eb_dimmaterulegroup g on g.fid = t.fid inner join t_eb_structofbill b on g.fbill = b.fid ", new Object[0]);
        sqlBuilder.append(" where ", new Object[0]);
        sqlBuilder.append(" b.fnumber = ?", new Object[]{entityNumber});
        sqlBuilder.appendIn(" and g.fid", groupIds.toArray());
        sqlBuilder.appendIn(" and t.fbussmodelid", busModelIds.toArray());
        sqlBuilder.appendIn(" and t.fmodelid", modelIds.toArray());
        if (!isBatch) {
            sqlBuilder.append(" and t.feffectivetime <= ?", new Object[]{controlData.getBizTime()});
            sqlBuilder.append(" and (t.finvalidtime is null or t.finvalidtime >= ?)", new Object[]{controlData.getBizTime()});
        }
        List schemas = null;
        try (DataSet ds = DB.queryDataSet((String)"queryControlSchemaEntry", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            schemas = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        if (schemas.isEmpty() && checkEmpty.booleanValue() && groupIds.size() > 0 && (groups = BusinessDataServiceHelper.load((Object[])groupIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_adddimmaterule").getDynamicObjectType())) != null && groups.length > 0) {
            String s1 = Arrays.stream(groups).map(k -> k.getString("name")).collect(Collectors.joining("\u3001"));
            String s2 = controlData.getBizModels().values().stream().map(k -> k.getName()).collect(Collectors.joining("\u3001"));
            ControlException.notDimensionMappings1((String)s1, (String)s2);
        }
        Map<Object, Object> controlValueMap = new HashMap();
        HashMap<String, Set> processMap = new HashMap<String, Set>();
        HashMap<String, Set> sourceGroupMap = new HashMap<String, Set>();
        List detailids = schemas.stream().filter(f -> BgControlScheme.isDynamicvalue(f)).map(k -> IDUtils.toLong(k.get("fdetailid"))).collect(Collectors.toList());
        List groupids = schemas.stream().filter(f -> BgControlScheme.isDynamicvalue(f)).map(k -> IDUtils.toLong(k.get("fid"))).collect(Collectors.toList());
        if (!detailids.isEmpty()) {
            Object row2;
            Object controlValues2;
            SqlBuilder ruleValueSql = new SqlBuilder();
            ruleValueSql.append("select fdetailid,ftype,foperation,fvaluefield from t_eb_dimmaterulevalue where ", new Object[0]);
            ruleValueSql.appendIn("fdetailid", detailids.toArray());
            DataSet ds = DB.queryDataSet((String)"querydimmaterulevalue", (DBRoute)BgBaseConstant.epm, (SqlBuilder)ruleValueSql);
            Object object = null;
            try {
                if (ds != null) {
                    controlValues2 = CommonServiceHelper.transDataSet((DataSet)ds);
                    controlValueMap = controlValues2.stream().collect(Collectors.groupingBy(k -> String.valueOf(k.get("fdetailid"))));
                }
            }
            catch (Throwable controlValues2) {
                object = controlValues2;
                throw controlValues2;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable controlValues2) {
                            ((Throwable)object).addSuppressed(controlValues2);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            SqlBuilder processSql = new SqlBuilder();
            processSql.append("select fid,fbasedataid from t_eb_dimmateruleprc where ", new Object[0]);
            processSql.appendIn("fid", detailids.toArray());
            DataSet ds2 = DB.queryDataSet((String)"querydimmateruleprocess", (DBRoute)BgBaseConstant.epm, (SqlBuilder)processSql);
            controlValues2 = null;
            try {
                while (ds2 != null && ds2.hasNext()) {
                    row2 = ds2.next();
                    processMap.computeIfAbsent(row2.getString("fid"), f -> new HashSet(10)).add(row2.getLong("fbasedataid"));
                }
            }
            catch (Throwable row2) {
                controlValues2 = row2;
                throw row2;
            }
            finally {
                if (ds2 != null) {
                    if (controlValues2 != null) {
                        try {
                            ds2.close();
                        }
                        catch (Throwable row2) {
                            ((Throwable)controlValues2).addSuppressed(row2);
                        }
                    } else {
                        ds2.close();
                    }
                }
            }
            SqlBuilder sourcegroupSql = new SqlBuilder();
            sourcegroupSql.append("select fid,fbasedataid from t_eb_dimmaterulesrc where ", new Object[0]);
            sourcegroupSql.appendIn("fid", groupids.toArray());
            DataSet ds3 = DB.queryDataSet((String)"querydimmateruleprocess", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sourcegroupSql);
            row2 = null;
            try {
                while (ds3 != null && ds3.hasNext()) {
                    Row row3 = ds3.next();
                    sourceGroupMap.computeIfAbsent(row3.getString("fid"), f -> new HashSet(10)).add(row3.getLong("fbasedataid"));
                }
            }
            catch (Throwable row3) {
                row2 = row3;
                throw row3;
            }
            finally {
                if (ds3 != null) {
                    if (row2 != null) {
                        try {
                            ds3.close();
                        }
                        catch (Throwable row3) {
                            ((Throwable)row2).addSuppressed(row3);
                        }
                    } else {
                        ds3.close();
                    }
                }
            }
        }
        BgControlScheme controlScheme = null;
        if (schemas != null) {
            boolean isdynamicvalue;
            HashMap<Long, DynamicObject> writeoffObj = new HashMap<Long, DynamicObject>();
            for (Iterator schema : schemas) {
                String detailId = String.valueOf(schema.get("fdetailid"));
                BgControlLogUtils.infoThread(controlData.getStats(), true, () -> BgControlSchemeUtils.lambda$query$10((Map)((Object)schema)));
                Long key = BizModel.getKey((Long)IDUtils.toLong(schema.get("fmodelid")), (Long)IDUtils.toLong(schema.get("fbussmodelid")));
                BizModel bizModel = controlData.getBizModels().get(key);
                if (bizModel == null) {
                    BgControlLogUtils.info(controlData.getStats(), true, "schema-nofound-bizmodel=" + key);
                    continue;
                }
                controlScheme = new BgControlScheme(entityNumber, bizModel, (Map<String, Object>)((Object)schema), controlData.getStats());
                isdynamicvalue = controlScheme.isDynamicvalue();
                if (isdynamicvalue) {
                    Long writeid;
                    if (controlValueMap != null && controlValueMap.containsKey(detailId)) {
                        List controlValues = (List)controlValueMap.get(detailId);
                        BgControlSchemeValueField controlSchemeValueField = new BgControlSchemeValueField();
                        for (Map controlValue : controlValues) {
                            controlSchemeValueField.addFromControlProcess(BillFieldTypeEmum.getBillFieldTypeEmumByIndex((int)Integer.parseInt((String)controlValue.get("ftype"))), (String)controlValue.get("foperation"), (String)controlValue.get("fvaluefield"));
                        }
                        controlScheme.setControlSchemeValueField(controlSchemeValueField.getValueFields());
                    }
                    if (IDUtils.isNotNull((Long)(writeid = controlScheme.getWriteoffSchemeId()))) {
                        writeoffObj.put(writeid, null);
                    }
                    controlScheme.setProcessIds((Set)processMap.get(String.valueOf(controlScheme.getGroupId())));
                    controlScheme.setSourceGroups((Set)sourceGroupMap.get(String.valueOf(controlScheme.getGroupId())));
                }
                controlSchemes.computeIfAbsent(controlScheme.getSchemeKey(), f -> new ArrayList(10)).add(controlScheme);
            }
            if (!writeoffObj.isEmpty()) {
                Map maps = BusinessDataServiceHelper.loadFromCache((String)"eb_writeoffscheme_pro", (String)"id, number, name, writeoffinfo.id, writeoffinfo.writeoffbill, writeoffinfo.writeoffbill.number, writeoffinfo.writeofftype, writeoffinfo.writeoffsourcebill, writeoffinfo.writeoffsourcebill.number, writeoffinfo.writeoffentry, writeoffinfo.writeoffentry.number, writeoffinfo.writeoffvalue, writeoffinfo.writeoffvalue.number, writeoffinfo.writeoffsourcebillentry, writeoffinfo.writeoffsourcebillentry.number", (QFilter[])new QFilter("id", "in", new HashSet(writeoffObj.keySet())).toArray());
                if (maps != null) {
                    for (DynamicObject obj : maps.values()) {
                        writeoffObj.put(obj.getLong("id"), obj);
                    }
                }
                for (Collection schemeCol : controlSchemes.values()) {
                    if (schemeCol == null) continue;
                    for (BgControlScheme _controlScheme : schemeCol) {
                        isdynamicvalue = _controlScheme.isDynamicvalue();
                        Long writeoffid = _controlScheme.getWriteoffSchemeId();
                        if (!isdynamicvalue || !IDUtils.isNotNull((Long)writeoffid)) continue;
                        if (!writeoffObj.containsKey(writeoffid)) {
                            log.info("query-writeoff-no-found: " + writeoffid);
                            continue;
                        }
                        _controlScheme.setWriteOff(WriteOff.of((DynamicObject)writeoffObj.get(writeoffid)));
                    }
                }
            }
        } else {
            BgControlLogUtils.info(controlData.getStats(), true, "schemas is null.");
        }
        LinkedHashMap<String, Collection<BgControlScheme>> _controlSchemes = new LinkedHashMap<String, Collection<BgControlScheme>>(10);
        for (Long groupId : groupIds) {
            Collection schemes = (Collection)controlSchemes.get(String.valueOf(groupId));
            if (schemes != null) {
                ((List)schemes).sort(Comparator.comparingInt(BgControlScheme::getPriority));
                _controlSchemes.put(String.valueOf(groupId), schemes);
                continue;
            }
            _controlSchemes.put(String.valueOf(groupId), new ArrayList(1));
        }
        return _controlSchemes;
    }

    private static /* synthetic */ String lambda$query$10(Map schema) {
        return "schema = " + JSONUtils.toString((Object)schema);
    }
}

