/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.constant.BgControlConstant;
import kd.epm.eb.common.ebcommon.common.Tuple;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.face.IControlAmount;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IResultCause;
import kd.epm.eb.control.impl.model.BgControlRecord;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.impl.model.BgControlSetting;
import kd.epm.eb.control.impl.model.BudgetBalance;
import kd.epm.eb.control.impl.model.ControlOccValue;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgPeriodUtils;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class BgControlUtils {
    private static final Log log = LogFactory.getLog(BgControlUtils.class);

    public static String getEBUserDefined(kd.epm.eb.common.model.Dimension dimension) {
        if (dimension != null && StringUtils.isNotEmpty((String)dimension.getFieldMapped())) {
            return "userdefined" + dimension.getFieldMapped().replaceFirst("dim", "");
        }
        return null;
    }

    public static String getEBUserDefined(Dimension dimension) {
        if (dimension != null && StringUtils.isNotEmpty((String)dimension.getFieldMapped())) {
            return "userdefined" + dimension.getFieldMapped().replaceFirst("dim", "");
        }
        return null;
    }

    public static String getUserDefined(BizModel model, BgControlScheme controlScheme, kd.epm.eb.common.model.Dimension dimension) {
        if (model == null || controlScheme == null) {
            return null;
        }
        String userDefined = null;
        userDefined = model.isEBByModel() ? BgControlUtils.getEBUserDefined(dimension) : controlScheme.getUserDefendDimNumMap().get(dimension.getNumber());
        return userDefined;
    }

    public static String getMemberKey(IBudgetBalance param, boolean hasBudget, boolean ignChangeType, boolean ignPeriod, Collection<kd.epm.eb.common.model.Dimension> dimensions) {
        if (param == null || dimensions == null || dimensions.isEmpty()) {
            return null;
        }
        StringBuilder dataKey = new StringBuilder();
        dataKey.append(param.getBizModel().getId()).append("!");
        Member member = null;
        String memberNumber = null;
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            if (ignChangeType && SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber()) || ignPeriod && SysDimensionEnum.Period.getNumber().equals(dimension.getNumber())) continue;
            member = param.getMember(hasBudget, dimension.getNumber());
            if (member != null) {
                memberNumber = member.getNumber();
                if (ignPeriod && SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) {
                    memberNumber = BgPeriodUtils.getYear(memberNumber);
                }
            } else {
                memberNumber = "";
            }
            dataKey.append(dimension.getNumber()).append("_").append(memberNumber).append("!");
        }
        return dataKey.toString();
    }

    public static Set<String> getParentMemberKey(IControlAmount param, boolean hasBudget, boolean ignChangeType, boolean ignPeriod, Collection<kd.epm.eb.common.model.Dimension> dimensions, Map<Long, Set<String>> hasMembers) {
        HashSet<String> parentMemberKeys = new HashSet<String>();
        if (param == null || dimensions == null || dimensions.isEmpty()) {
            return parentMemberKeys;
        }
        ArrayList<kd.epm.eb.common.model.Dimension> _dimensions = null;
        _dimensions = dimensions instanceof List ? (ArrayList<kd.epm.eb.common.model.Dimension>)dimensions : new ArrayList<kd.epm.eb.common.model.Dimension>(dimensions);
        String[] members = new String[dimensions.size()];
        BgControlUtils.calcParentMemberKey(parentMemberKeys, members, param, hasBudget, ignChangeType, ignPeriod, _dimensions, 0, hasMembers);
        return parentMemberKeys;
    }

    private static void calcParentMemberKey(Set<String> parentMemberKeys, String[] members, IControlAmount param, boolean hasBudget, boolean ignChangeType, boolean ignPeriod, List<kd.epm.eb.common.model.Dimension> dimensions, int dimIndex, Map<Long, Set<String>> hasMembers) {
        if (dimIndex >= dimensions.size()) {
            StringBuilder dataKey = new StringBuilder();
            dataKey.append(param.getBizModel().getId()).append("!");
            for (String member : members) {
                if (member == null) continue;
                dataKey.append(member).append("!");
            }
            parentMemberKeys.add(dataKey.toString());
        } else {
            kd.epm.eb.common.model.Dimension dimension = dimensions.get(dimIndex);
            if (ignChangeType && SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber())) {
                BgControlUtils.calcParentMemberKey(parentMemberKeys, members, param, hasBudget, ignChangeType, ignPeriod, dimensions, dimIndex + 1, hasMembers);
            } else if (ignPeriod && SysDimensionEnum.Period.getNumber().equals(dimension.getNumber())) {
                BgControlUtils.calcParentMemberKey(parentMemberKeys, members, param, hasBudget, ignChangeType, ignPeriod, dimensions, dimIndex + 1, hasMembers);
            } else {
                Member member = param.getMember(hasBudget, dimension.getNumber());
                if (member == null) {
                    members[dimIndex] = dimension.getNumber() + "_" + "";
                    BgControlUtils.calcParentMemberKey(parentMemberKeys, members, param, hasBudget, ignChangeType, ignPeriod, dimensions, dimIndex + 1, hasMembers);
                } else if (ignPeriod && SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) {
                    members[dimIndex] = dimension.getNumber() + "_" + BgPeriodUtils.getYear(member.getNumber());
                    BgControlUtils.calcParentMemberKey(parentMemberKeys, members, param, hasBudget, ignChangeType, ignPeriod, dimensions, dimIndex + 1, hasMembers);
                } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) {
                    members[dimIndex] = dimension.getNumber() + "_" + member.getNumber();
                    BgControlUtils.calcParentMemberKey(parentMemberKeys, members, param, hasBudget, ignChangeType, ignPeriod, dimensions, dimIndex + 1, hasMembers);
                } else {
                    String[] lns = new String[]{dimension.getNumber(), member.getNumber()};
                    int start = 1;
                    if (!StringUtils.isEmpty((String)member.getLongNumber())) {
                        lns = member.getLongNumber().split("!");
                        if (BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension)) {
                            start = 0;
                        }
                    }
                    for (int l = start; l < lns.length; ++l) {
                        if (!SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber()) && hasMembers != null && (hasMembers.get(param.getBizModel().getId()) == null || !hasMembers.get(param.getBizModel().getId()).contains(dimension.getNumber() + "_" + lns[l]))) continue;
                        members[dimIndex] = dimension.getNumber() + "_" + lns[l];
                        BgControlUtils.calcParentMemberKey(parentMemberKeys, members, param, hasBudget, ignChangeType, ignPeriod, dimensions, dimIndex + 1, hasMembers);
                    }
                }
            }
        }
    }

    public static String getCtrlKey(IBudgetBalance param, boolean hasBudget, Collection<kd.epm.eb.common.model.Dimension> dimensions, boolean isOccupation) {
        if (param == null || dimensions == null || dimensions.isEmpty()) {
            return null;
        }
        StringBuilder dataKey = new StringBuilder();
        dataKey.append(param.getBizModel().getId()).append("!");
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            Member member = param.getMember(hasBudget, dimension.getNumber());
            if (member == null) {
                throw new KDBizException("control getMemberKey error, member is null.");
            }
            String memberNumber = member.getNumber();
            if (SysDimensionEnum.Period.getNumber().equals(dimension.getNumber())) {
                memberNumber = BgControlUtils.getCtrlSetPeriodNumber(param.getSetting(), param.getBizTime(), isOccupation);
            } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) {
                memberNumber = BgPeriodUtils.getYear(memberNumber) + "_" + BgControlUtils.getCtrlSetPeriodNumber(param.getSetting(), param.getBizTime(), isOccupation);
            }
            dataKey.append(dimension.getNumber()).append("_").append(memberNumber).append("!");
        }
        return dataKey.toString();
    }

    private static String getCtrlSetPeriodNumber(BgControlSetting setting, Date date, boolean isOccupation) {
        if (setting == null || date == null) {
            return null;
        }
        CalendarHelper helper = new CalendarHelper();
        helper.setTime(date);
        String ctrlPeriodNumber = "M" + helper.getCurrentlyMonth();
        if (BgControlSettingTypeEnum.MONTH != setting.getSettingType()) {
            if (BgControlSettingTypeEnum.MONTH_ADDUP == setting.getSettingType()) {
                ctrlPeriodNumber = isOccupation ? "M" + helper.getCurrentlyMonth() : "M" + helper.getCurrentlyYear();
            } else if (BgControlSettingTypeEnum.QUARTER == setting.getSettingType()) {
                ctrlPeriodNumber = "Q" + helper.getCurrentlyQuarter();
            } else if (BgControlSettingTypeEnum.QUARTER_ADDUP == setting.getSettingType()) {
                ctrlPeriodNumber = isOccupation ? "Q" + helper.getCurrentlyQuarter() : "Q" + helper.getCurrentlyYear();
            } else if (BgControlSettingTypeEnum.HALFYEAR == setting.getSettingType()) {
                ctrlPeriodNumber = "HF" + helper.getCurrentlyHalfYear();
            } else if (BgControlSettingTypeEnum.YEAR == setting.getSettingType()) {
                ctrlPeriodNumber = "FY" + helper.getCurrentlyYear();
            }
        }
        return ctrlPeriodNumber;
    }

    public static String getMemberString(IBudgetBalance param, boolean hasBudget, Collection<kd.epm.eb.common.model.Dimension> dimensions) {
        if (param == null || dimensions == null || dimensions.isEmpty()) {
            return null;
        }
        StringBuilder dataKey = new StringBuilder();
        Member member = null;
        String memberName = null;
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            member = param.getMember(hasBudget, dimension.getNumber());
            memberName = member != null ? member.getName() : "";
            dataKey.append(dimension.getName()).append("_").append(memberName).append("!");
        }
        if (dataKey.length() > 0) {
            dataKey.setLength(dataKey.length() - "!".length());
        }
        return dataKey.toString();
    }

    public static Map<String, Member> getMemberMap(IBudgetBalance param, boolean hasBudget, Collection<kd.epm.eb.common.model.Dimension> dimensions) {
        if (param == null || dimensions == null || dimensions.isEmpty()) {
            return null;
        }
        HashMap<String, Member> map = new HashMap<String, Member>();
        Member member = null;
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            member = param.getMember(hasBudget, dimension.getNumber());
            if (member == null) continue;
            map.put(dimension.getNumber(), member);
        }
        return map;
    }

    public static String getMemberKey(IBudgetBalance param, boolean hasBudget, Collection<kd.epm.eb.common.model.Dimension> dimensions, Set<String> ignDimNumbers, BgControlSetting setting, IControlParam controlParam, Map<Long, Set<String>> oboMemberNumberMap, List<Long> oboDims, Map<Long, Boolean> hasUserDefinedDimensionMap) {
        if (param == null || dimensions == null || dimensions.isEmpty()) {
            return null;
        }
        StringBuilder dataKey = new StringBuilder();
        dataKey.append(param.getBizModel().getId()).append("!");
        String memberNumber = null;
        String tmpNumber = null;
        Member member = null;
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            memberNumber = null;
            if (ignDimNumbers != null && ignDimNumbers.contains(dimension.getNumber())) continue;
            if (hasUserDefinedDimensionMap.get(dimension.getId()).booleanValue()) {
                member = param.getMember(true, dimension.getNumber());
                if (member != null) {
                    memberNumber = member.getNumber();
                }
                if (setting != null) {
                    tmpNumber = setting.getMemberNumber(param.getBizModel(), param.getControlScheme(), dimension, controlParam, oboMemberNumberMap);
                    if (tmpNumber != null) {
                        memberNumber = tmpNumber;
                    } else if (IDUtils.isNotEmptyLong((Long)setting.getGroupId()).booleanValue()) {
                        if (CollectionUtils.isNotEmpty(oboDims) && oboDims.contains(dimension.getId())) continue;
                        IModelCacheHelper cacheHelper = controlParam.getBizModel().getModelCache();
                        if (cacheHelper != null) {
                            Long viewid = cacheHelper.getViewByBusModelAndDimNumber(controlParam.getBizModel().getControlBusModelId(), dimension.getNumber());
                            kd.epm.eb.common.cache.impl.Member m = cacheHelper.getRootMember(dimension.getNumber(), viewid);
                            memberNumber = m == null ? dimension.getNumber() : m.getNumber();
                        } else {
                            memberNumber = dimension.getNumber();
                        }
                    }
                }
            } else {
                memberNumber = SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) ? (setting != null ? setting.getAccountNumber() : param.getAccount(true).getNumber()) : (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) ? param.getMember(true, dimension.getNumber()).getNumber() : (SysDimensionEnum.DataType.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.Version.getNumber().equals(dimension.getNumber()) ? param.getMember(hasBudget, dimension.getNumber()).getNumber() : param.getMember(hasBudget, dimension.getNumber()).getNumber()));
            }
            dataKey.append(dimension.getNumber()).append("_").append(memberNumber).append("!");
        }
        return dataKey.toString();
    }

    public static String getMemberKey(BgControlRecord record, boolean ignChangeType, boolean ignPeriod, Collection<kd.epm.eb.common.model.Dimension> dimensions) {
        if (record == null || record.getModelId() == 0L || dimensions == null || dimensions.isEmpty()) {
            return null;
        }
        StringBuilder dataKey = new StringBuilder();
        dataKey.append(record.getModelId()).append("!");
        String memberNumber = null;
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            if (ignChangeType && SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber()) || ignPeriod && SysDimensionEnum.Period.getNumber().equals(dimension.getNumber())) continue;
            memberNumber = record.getMember(dimension).getNumber();
            if (ignPeriod && SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) {
                memberNumber = BgPeriodUtils.getYear(memberNumber);
            }
            dataKey.append(dimension.getNumber()).append("_").append(memberNumber).append("!");
        }
        return dataKey.toString();
    }

    public static String getWriteOffKey(BgControlRecord record) {
        if (record == null || record.getBizModel() == null) {
            return null;
        }
        StringBuilder dataKey = new StringBuilder();
        dataKey.append(record.getModelId()).append("!");
        List dimensions = record.getBizModel().getDimensions();
        String memberNumber = null;
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            memberNumber = record.getMember(dimension).getNumber();
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber()) && record.getOccPeriod() != null) {
                memberNumber = record.getOccPeriodNumber();
            }
            dataKey.append(dimension.getNumber()).append("_").append(memberNumber).append("!");
        }
        return dataKey.toString();
    }

    public static String getBgControlRecordTable(Long cubeId, Long businessModelId) {
        return "t_eb_cr" + businessModelId;
    }

    @Deprecated
    public static String getBgControlRecordIndex(Long cubeId, Long businessModelId) {
        return "ix_eb_cr" + businessModelId;
    }

    public static String getBgControlRecordRefIndex(Long cubeId, Long businessModelId) {
        return "ix_eb_crr" + businessModelId;
    }

    @Deprecated
    public static String getBgControlRecordEntityIndex(Long cubeId, Long businessModelId) {
        return "ix_eb_cre" + businessModelId;
    }

    @Deprecated
    public static String getBgControlRecordOrgAccIndex(Long cubeId, Long businessModelId) {
        return "ix_eb_croa" + businessModelId;
    }

    public static String getBgControlRecordIndexNew(Long businessModelId) {
        return "ix_eb_cn" + businessModelId;
    }

    public static String getBgControlRecordEntityIndexNew(Long businessModelId) {
        return "ix_eb_cne" + businessModelId;
    }

    public static String getBgControlRecordOrgAccIndexNew(Long businessModelId) {
        return "ix_eb_cnoa" + businessModelId;
    }

    public static boolean hasBgControlRecord(Long cubeId, Long bussnessModelId) {
        if (cubeId == null || cubeId == 0L) {
            return true;
        }
        String controlTable = BgControlUtils.getBgControlRecordTable(cubeId, bussnessModelId);
        return SqlBatchUtils.hasData((String)controlTable);
    }

    public static boolean hasEbBgControlRecord(Long modelId) {
        if (modelId == null) {
            return false;
        }
        return SqlBatchUtils.hasEbData((String)"t_eb_bgcontrolrecord", (Long)modelId);
    }

    public static void checkBgControlRecordIndex(Long cubeId, Long bussnessModleId, DynamicObject bgConDimSet) {
        String index;
        if (cubeId == null || cubeId == 0L || bussnessModleId == null || bussnessModleId == 0L || bgConDimSet == null) {
            return;
        }
        String controlTable = BgControlUtils.getBgControlRecordTable(cubeId, bussnessModleId);
        if (!DB.exitsIndex((DBRoute)BgBaseConstant.epm, (String)controlTable, (String)(index = BgControlUtils.getBgControlRecordRefIndex(cubeId, bussnessModleId)))) {
            StringBuilder sql = new StringBuilder();
            sql.append("create index ").append(index).append(" ON ").append(controlTable).append(" (frefbizid)");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
        }
    }

    public static void checkBgControlRecord(Long cubeId, Long bussnessModleId, DynamicObject bgConDimSet, List<Dimension> userDefinedDimensions) {
        if (cubeId == null || cubeId == 0L || bussnessModleId == null || bussnessModleId == 0L || bgConDimSet == null) {
            return;
        }
        String controlTable = BgControlUtils.getBgControlRecordTable(cubeId, bussnessModleId);
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)cubeId);
        if (SqlBatchUtils.hasTable((String)controlTable)) {
            if (SqlBatchUtils.hasData((String)controlTable)) {
                String string;
                if (userDefinedDimensions.size() > 0) {
                    StringBuilder alterSql = new StringBuilder();
                    for (Dimension dimension : userDefinedDimensions) {
                        alterSql.append("alter table ").append(controlTable).append(" add (").append(BgControlUtils.getUserDefinedIdField(dimension)).append(" bigint not null default 0);");
                    }
                    DB.execute((DBRoute)BgBaseConstant.epm, (String)alterSql.toString());
                    StringBuilder updateSql = new StringBuilder();
                    updateSql.append("update ").append(controlTable).append(" set ");
                    for (Dimension dimension : userDefinedDimensions) {
                        String noneNumber = dimension.getNoneNumber();
                        kd.epm.eb.common.cache.impl.Member member = cacheHelper.getMemberByAnyView(dimension.getNumber(), noneNumber);
                        updateSql.append(BgControlUtils.getUserDefinedIdField(dimension)).append(" = ").append(member.getId()).append(",");
                    }
                    updateSql.setLength(updateSql.length() - 1);
                    updateSql.append(";");
                    DB.execute((DBRoute)BgBaseConstant.epm, (String)updateSql.toString());
                }
                boolean hasIcId = false;
                DynamicObjectCollection entries = bgConDimSet.getDynamicObjectCollection("entryentity");
                if (entries != null && !entries.isEmpty()) {
                    Object var8_13 = null;
                    for (DynamicObject entry : entries) {
                        String string2 = entry.getString("dimensionnumber");
                        if (!SysDimensionEnum.InternalCompany.getNumber().equals(string2)) continue;
                        hasIcId = true;
                        break;
                    }
                }
                if (hasIcId && !SqlBatchUtils.hasColumn((String)controlTable, (String)(string = BgControlRecordUtils.getBgMdRecordFields().get(SysDimensionEnum.InternalCompany.getNumber())))) {
                    Long l = cacheHelper.getMember(SysDimensionEnum.InternalCompany.getNumber(), bussnessModleId, cacheHelper.getDimension(SysDimensionEnum.InternalCompany.getNumber()).getNoneNumber()).getId();
                    DB.execute((DBRoute)BgBaseConstant.epm, (String)("alter table " + controlTable + " add " + string + " bigint not null default " + l));
                }
                for (Tuple tuple : BgControlConstant.addCRCols) {
                    if (SqlBatchUtils.hasColumn((String)controlTable, (String)((String)tuple.p1))) continue;
                    String sql = "alter table " + controlTable + " add (" + (String)tuple.p1 + " " + (String)tuple.p2 + " default " + (String)tuple.p3 + " not null)";
                    TXHandle tx = TX.requiresNew((String)("checkExist" + controlTable + (String)tuple.p1));
                    Throwable throwable = null;
                    try {
                        try {
                            BgControlUtils.excuteSql(sql);
                        }
                        catch (Exception e) {
                            tx.markRollback();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                return;
            }
            DB.execute((DBRoute)BgBaseConstant.epm, (String)("drop table " + controlTable));
        }
        StringBuilder sql = new StringBuilder();
        if (!SqlBatchUtils.hasTable((String)"t_eb_bgcontrolindex")) {
            sql.append("create table ").append("t_eb_bgcontrolindex").append(" (fid bigint default 0 not null,fentityNumber nvarchar(80) not null default ' ', fbizid nvarchar(80) not null default ' ', ftable nvarchar(80) not null default ' ',constraint pk_t_eb_bgcontrolindex primary key (fid))");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
            sql.setLength(0);
            sql.append("create index ").append("ix_eb_bgcontrolindex").append(" ON ").append("t_eb_bgcontrolindex").append(" (fentitynumber, fbizid, ftable)");
            DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
        }
        sql.setLength(0);
        sql.append("create table ").append(controlTable).append(" (").append("fid bigint not null default 0, fmodelid bigint not null default 0, ").append("fentitynumber nvarchar(80) not null default ' ', fbizid nvarchar(80) not null default ' ',").append("fbiznumber nvarchar(80) not null default ' ', foperation  nvarchar(80) not null default ' ',").append("freqorgunitid bigint not null default 0, forgunitid bigint not null default 0,").append("freqaccountid bigint not null default 0, faccountid bigint not null default 0,").append("fbgperiodid bigint not null default 0, fcurrencyid bigint not null default 0, fversionid bigint not null default 0,").append("fatid bigint not null default 0, fctid bigint not null default 0, ").append("fdtid bigint not null default 0, fmetricid bigint default 0 not null, ");
        DynamicObjectCollection entries = bgConDimSet.getDynamicObjectCollection("entryentity");
        if (entries != null && !entries.isEmpty()) {
            Object var8_20 = null;
            Object var9_32 = null;
            for (DynamicObject entry : entries) {
                String string = entry.getString("dimensionnumber");
                Dimension dimension = cacheHelper.getDimension(string);
                if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                    sql.append(BgControlUtils.getUserDefinedIdField(dimension)).append(" bigint not null default 0, ");
                    continue;
                }
                if (!SysDimensionEnum.InternalCompany.getNumber().equals(string)) continue;
                sql.append(BgControlRecordUtils.getBgMdRecordFields().get(string)).append(" bigint not null default 0, ");
            }
        }
        for (Tuple tuple : BgControlConstant.addCRCols) {
            sql.append(String.format("%s %s not null default %s,", tuple.p1, tuple.p2, tuple.p3));
        }
        sql.append("famount decimal(19,6) not null default 0, fcreatetime datetime, fcreatorid bigint not null default 0, ").append("fruleid bigint not null default 0, frefbizid nvarchar(80) not null default ' ')");
        DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
        String string = BgControlUtils.getBgControlRecordIndex(cubeId, bussnessModleId);
        sql.setLength(0);
        sql.append("create index ").append(string).append(" ON ").append(controlTable).append(" (fbizid)");
        DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
        String string3 = BgControlUtils.getBgControlRecordEntityIndex(cubeId, bussnessModleId);
        sql.setLength(0);
        sql.append("create index ").append(string3).append(" ON ").append(controlTable).append(" (fentitynumber, fbiznumber)");
        DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
        String oaIndex = BgControlUtils.getBgControlRecordOrgAccIndex(cubeId, bussnessModleId);
        sql.setLength(0);
        sql.append("create index ").append(oaIndex).append(" ON ").append(controlTable).append(" (fcreatetime, forgunitid, faccountid, fbgperiodid)");
        DB.execute((DBRoute)BgBaseConstant.epm, (String)sql.toString());
    }

    public static String getUserDefinedIdField(Dimension dimension) {
        String userDefined = null;
        if (StringUtils.isNotEmpty((String)dimension.getFieldMapped())) {
            userDefined = 'f' + dimension.getFieldMapped().replaceFirst("dim", "userdefinedid");
        }
        return userDefined;
    }

    public static String getUserDefinedIdField(kd.epm.eb.common.model.Dimension dimension) {
        String userDefined = null;
        if (StringUtils.isNotEmpty((String)dimension.getFieldMapped())) {
            userDefined = 'f' + dimension.getFieldMapped().replaceFirst("dim", "userdefinedid");
        }
        return userDefined;
    }

    public static void queryControlDimension(BizModel model) {
        ArrayList<BizModel> models = new ArrayList<BizModel>();
        models.add(model);
        BgControlUtils.queryControlDimension(models);
    }

    public static void queryControlDimension(Collection<BizModel> models) {
        if (models == null || models.isEmpty()) {
            return;
        }
        HashSet<Long> modelSet = new HashSet<Long>(16);
        HashMap modelMap = Maps.newHashMapWithExpectedSize((int)models.size());
        for (BizModel model : models) {
            if (model == null) continue;
            if (model.isEBByModel()) {
                modelMap.put(model.getId().toString(), model);
            } else if (model.getStartVersion() == null && (model.getControlBusModelId() == null || model.getControlBusModelId() == 0L)) {
                modelMap.put(model.getId().toString(), model);
            } else if (model.getStartVersion() != null) {
                modelMap.put(model.getId() + "!" + model.getStartVersion().getLong("bussmodel.id"), model);
            } else {
                modelMap.put(model.getId() + "!" + model.getControlBusModelId(), model);
            }
            modelSet.add(model.getId());
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "in", modelSet));
        String fields = "id,model.id,businessmodel.id,entryentity.id,entryentity.dimensionid";
        Map ctrlDims = BusinessDataServiceHelper.loadFromCache((String)"eb_bgmcontroldimension", (String)fields, (QFilter[])builder.toArrays());
        for (DynamicObject ctrlDim : ctrlDims.values()) {
            DynamicObjectCollection entries;
            DynamicObject busModel = ctrlDim.getDynamicObject("businessmodel");
            if (ctrlDim.getDynamicObject("model") == null) continue;
            Long modelId = ctrlDim.getDynamicObject("model").getLong("id");
            String key = busModel != null ? modelId + "!" + busModel.getLong("id") : modelId.toString();
            BizModel model = (BizModel)modelMap.get(key);
            if (model == null) continue;
            model.setControlManagerId(Long.valueOf(ctrlDim.getLong("id")));
            if (busModel != null) {
                model.setControlBusModelId(Long.valueOf(busModel.getLong("id")));
                model.setView(BusinessModelServiceHelper.getViewIds((Long)model.getControlBusModelId(), (boolean)false));
            }
            if ((entries = ctrlDim.getDynamicObjectCollection("entryentity")) == null) continue;
            HashSet dims = Sets.newHashSetWithExpectedSize((int)entries.size());
            for (DynamicObject entry : entries) {
                dims.add(entry.getLong("dimensionid"));
            }
            model.setControlDims((Set)dims);
        }
    }

    public static String getSVKey(BizModel model) {
        String key;
        if (model.isEBByModel()) {
            key = String.valueOf(model.getId());
        } else {
            StringBuilder str = new StringBuilder();
            str.append(model.getId()).append("@").append(model.getControlBusModelId());
            key = str.toString();
        }
        return key;
    }

    public static DynamicObject queryControlDimension(Long modelId, Long bussmodelId) {
        if (modelId == null || modelId == 0L) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("businessmodel", "=", (Object)bussmodelId));
        String fields = "id,model.id,businessmodel.id,entryentity.id,entryentity.dimensionid";
        return BusinessDataServiceHelper.loadSingleFromCache((String)"eb_bgmcontroldimension", (String)fields, (QFilter[])builder.toArrays());
    }

    public static Set<Long> getControlDimension(DynamicObject ctrlDim) {
        if (ctrlDim == null) {
            return null;
        }
        HashSet<Long> dims = new HashSet<Long>();
        DynamicObjectCollection entries = ctrlDim.getDynamicObjectCollection("entryentity");
        if (entries != null) {
            for (DynamicObject entry : entries) {
                dims.add(entry.getLong("dimensionid"));
            }
        }
        return dims;
    }

    public static Long getControlDimensionBusModelId(DynamicObject ctrlDim) {
        if (ctrlDim == null) {
            return null;
        }
        return ctrlDim.getDynamicObject("businessmodel").getLong("id");
    }

    public static Set<String> getCRTable(String entityNumber, String bizId) {
        HashSet<String> crTables = new HashSet<String>();
        if (entityNumber == null || bizId == null) {
            return crTables;
        }
        String sql = "select ftable from t_eb_bgcontrolindex where fentityNumber = ? and fbizid = ?";
        try (DataSet rst = DB.queryDataSet((String)"queryBizIndex", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{entityNumber, bizId});){
            for (Row row : rst) {
                crTables.add(row.getString("ftable"));
            }
        }
        return crTables;
    }

    public static Set<String> getBizIds(String table, String bizId) {
        if (table == null || bizId == null) {
            return Collections.emptySet();
        }
        String sql = "select fbizid from " + table + " where frefbizid = ?";
        LinkedHashSet bizIds = Sets.newLinkedHashSet();
        try (DataSet ds = DB.queryDataSet((String)"queryBizIds", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{bizId});){
            if (ds != null) {
                for (Row row : ds) {
                    bizIds.add(row.getString("fbizid"));
                }
            }
        }
        return bizIds;
    }

    public static void createCRRecord(String entityNumber, String bizId, String crTables) {
        if (entityNumber == null || bizId == null || crTables == null) {
            return;
        }
        String sql = "insert into t_eb_bgcontrolindex(fid,fentityNumber, fbizid, ftable) values (?,?,?,?)";
        DB.execute((DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{DBServiceHelper.genGlobalLongId(), entityNumber, bizId, crTables});
    }

    public static Map<String, Map<String, Map<String, ControlOccValue>>> getRecordPeriod(Collection<BgControlRecord> records, Map<String, BgControlRecord> addNewOccupationRecordMap, boolean hasCurrOccupation, Collection<String> bizIds, String currBizId, Map<String, Map<String, Map<String, ControlOccValue>>> periodMap, Boolean isReviewOcc, Boolean isReviewExec, Boolean isWriteOffByEntry) {
        ArrayList _records = Lists.newArrayList();
        if (records != null) {
            _records.addAll(records);
        }
        if (addNewOccupationRecordMap != null) {
            _records.addAll(addNewOccupationRecordMap.values());
        }
        if (periodMap == null) {
            periodMap = Maps.newHashMapWithExpectedSize((int)10);
        }
        if (_records.isEmpty()) {
            return periodMap;
        }
        for (BgControlRecord record : _records) {
            String ignorekey;
            Map billValues;
            Map periodNumbers;
            ControlOccValue occRecord;
            String bizId;
            if ("Execute".equals(record.getMemberNumber(SysDimensionEnum.ChangeType.getNumber())) || (!hasCurrOccupation || isReviewOcc != false ? (!bizIds.contains(record.getBizId()) || !StringUtils.isEmpty((String)record.getRefBizId())) && !bizIds.contains(record.getRefBizId()) || isReviewOcc != false && currBizId.equals(record.getBizId()) && record.isOcc() != false || isReviewExec != false && currBizId.equals(record.getBizId()) && (StringUtils.isEmpty((String)record.getRefBizId()) && record.isExe() != false || StringUtils.isNotEmpty((String)record.getRefBizId()) && record.getWriteOffType().contains("Execute")) : !currBizId.equals(record.getBizId()) || currBizId.equals(record.getBizId()) && StringUtils.isNotEmpty((String)record.getRefBizId()))) continue;
            String periodNumber = record.getBizModel().isEBByModel() ? record.getMemberNumber(SysDimensionEnum.Period.getNumber()) : record.getMemberNumber(SysDimensionEnum.BudgetPeriod.getNumber());
            if (record.getOccPeriod() != null) {
                periodNumber = record.getOccPeriodNumber();
            }
            String string = bizId = isWriteOffByEntry != false ? record.getBizId() + "#" + record.getEntryId() : record.getBizId();
            if (StringUtils.isNotEmpty((String)record.getRefBizId())) {
                String string2 = bizId = isWriteOffByEntry != false ? record.getRefBizId() + "#" + record.getRefEntryId() : record.getRefBizId();
            }
            if ((occRecord = (ControlOccValue)(periodNumbers = (billValues = periodMap.computeIfAbsent(bizId, f -> Maps.newHashMapWithExpectedSize((int)records.size()))).computeIfAbsent(ignorekey = record.getMemberKey(true), f -> Maps.newHashMapWithExpectedSize((int)records.size()))).get(periodNumber)) == null) {
                occRecord = new ControlOccValue();
                periodNumbers.put(periodNumber, occRecord);
            }
            occRecord.addRecord(record);
        }
        return periodMap;
    }

    public static boolean isIncludePeriod(IControlParam controlParam, String dataKeyIgnPeriod, Map<String, Map<String, Map<String, BigDecimal>>> periodValueMap) {
        if (controlParam == null || dataKeyIgnPeriod == null || periodValueMap == null) {
            return false;
        }
        Map<String, Map<String, BigDecimal>> periodNumbers = periodValueMap.get(dataKeyIgnPeriod);
        if (periodNumbers != null && !periodNumbers.isEmpty()) {
            List<List<String>> periods = controlParam.getBgPeriod();
            for (List<String> period : periods) {
                String periodNum = period.get(1);
                if (!periodNumbers.containsKey(periodNum)) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, BigDecimal> getIncludePeriodValue(IControlParam controlParam, String dataKeyIgnPeriod, Map<String, Map<String, Map<String, BigDecimal>>> periodValueMap, Map<String, Set<String>> memberKeyMap) {
        if (controlParam == null || dataKeyIgnPeriod == null || periodValueMap == null) {
            return null;
        }
        Set refPeriodNum = null;
        LinkedHashMap billValues = Maps.newLinkedHashMap();
        Map<String, Map<String, BigDecimal>> periodNumbers = periodValueMap.get(dataKeyIgnPeriod);
        if (periodNumbers != null && !periodNumbers.isEmpty()) {
            refPeriodNum = memberKeyMap != null ? memberKeyMap.computeIfAbsent(dataKeyIgnPeriod, f -> Sets.newLinkedHashSet()) : null;
            List<List<String>> periods = controlParam.getBgPeriod();
            for (List<String> period : periods) {
                String periodNum = period.get(1);
                Map<String, BigDecimal> _tmpValues = periodNumbers.get(periodNum);
                if (_tmpValues == null || _tmpValues.isEmpty()) continue;
                for (Map.Entry<String, BigDecimal> entry : _tmpValues.entrySet()) {
                    BigDecimal occupation = billValues.computeIfAbsent(entry.getKey(), f -> BigDecimal.ZERO);
                    occupation = occupation.add(entry.getValue());
                    billValues.put(entry.getKey(), occupation);
                }
                if (refPeriodNum == null) continue;
                refPeriodNum.add(periodNum);
            }
        }
        return billValues;
    }

    public static void checkBusinessModel(Collection<BizModel> models) {
        if (models == null || models.isEmpty()) {
            return;
        }
        HashMap modelMap = Maps.newHashMapWithExpectedSize((int)models.size());
        for (BizModel bizModel : models) {
            modelMap.put(bizModel.getId(), bizModel);
        }
        for (Map.Entry entry : modelMap.entrySet()) {
            BizModel value = (BizModel)entry.getValue();
            if (value.getControlBusModelId() == null || value.getStartVersion().getString("bussmodel.id").equals(value.getControlBusModelId().toString())) continue;
            models.remove(entry.getValue());
        }
    }

    public static String handleMessageList(String spacer, List<String> messageList) {
        StringBuilder message = new StringBuilder();
        if (CollectionUtils.isNotEmpty(messageList)) {
            int i = 1;
            for (String causeMessage : messageList) {
                message.append(i++).append(spacer);
                message.append(causeMessage);
            }
            message.setLength(message.length() - 1);
        }
        return message.toString();
    }

    public static String getControlMessage(List<IResultCause> causeList, String entityNumber, Boolean showBeyondMessage, String typeNumber) {
        if (causeList == null) {
            return "";
        }
        StringBuilder message = new StringBuilder();
        QFilter qFilter = new QFilter("bill.number", "=", (Object)entityNumber);
        qFilter.and(new QFilter("messagetype", "=", (Object)typeNumber));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bgc_controlmessage", (String)"messagetitle,messagecontent", (QFilter[])qFilter.toArray());
        LocaleString string = BgControlUtils.getDefaultMessageTitle();
        String messageTitle = string == null ? "" : string.getLocaleValue();
        String messageContent = "{entity.number} - {entity.name}\uff0c{account.number} - {account.name}\uff0c{userdefineddim.all}\uff0c{period.number} - {period.name}\uff1b";
        boolean defaultMessageFlag = true;
        if (dynamicObject != null) {
            messageTitle = dynamicObject.getString("messagetitle");
            messageContent = dynamicObject.getString("messagecontent");
            if (messageContent != null && !messageContent.equals("{entity.number} - {entity.name}\uff0c{account.number} - {account.name}\uff0c{userdefineddim.all}\uff0c{period.number} - {period.name}\uff1b")) {
                defaultMessageFlag = false;
            }
        }
        if (messageTitle == null) {
            messageTitle = "";
        }
        if (messageContent == null) {
            messageContent = "";
        }
        LinkedHashMap<Long, List> causeMap = new LinkedHashMap<Long, List>();
        for (IResultCause cause : causeList) {
            if (cause.getControlParam() == null && cause.getControlParam().getBizModel() == null) continue;
            causeMap.computeIfAbsent(cause.getControlParam().getBizModel().getId(), f -> new ArrayList(16)).add(cause);
        }
        HashMap<String, String> namesMap = new HashMap<String, String>(16);
        for (List _causeList : causeMap.values()) {
            if (message.length() > 0) {
                message.append("\r\n");
            }
            List distinctCause = _causeList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<IResultCause>(Comparator.comparing(o -> o.getControlParam().getMemberKeyByBudget()))), ArrayList::new));
            IControlParam controlParam = ((IResultCause)distinctCause.get(0)).getControlParam();
            Map<String, String> userDefendDimNumMap = BgControlUtils.getControlUserDefinedDimNumMapByControlParam(controlParam);
            String[] messageTitleArray = org.apache.commons.lang3.StringUtils.substringsBetween((String)messageTitle, (String)"{", (String)"}");
            String _messageTitle = messageTitle;
            if (messageTitleArray != null) {
                for (String keyword : messageTitleArray) {
                    _messageTitle = BgControlUtils.replaceControlMessageByControlParam(_messageTitle, keyword, controlParam, defaultMessageFlag, userDefendDimNumMap, namesMap);
                }
            }
            message.append(_messageTitle).append("\r\n");
            Object[] messageContentArray = org.apache.commons.lang3.StringUtils.substringsBetween((String)messageContent, (String)"{", (String)"}");
            boolean hasBeyondMessage = false;
            ArrayList<String> causeMessageList = new ArrayList<String>(distinctCause.size());
            if (messageContentArray != null) {
                hasBeyondMessage = ArrayUtils.contains((Object[])messageContentArray, (Object)"beyondmessage");
            }
            for (IResultCause resultCause : distinctCause) {
                controlParam = resultCause.getControlParam();
                userDefendDimNumMap = BgControlUtils.getControlUserDefinedDimNumMapByControlParam(controlParam);
                String replace = messageContent;
                if (messageContentArray != null) {
                    for (Object keyword : messageContentArray) {
                        replace = BgControlUtils.replaceControlMessageByControlParam(replace, (String)keyword, controlParam, defaultMessageFlag, userDefendDimNumMap, namesMap);
                    }
                }
                if (!hasBeyondMessage && showBeyondMessage.booleanValue() && controlParam.getBeyondBalanceValue().compareTo(BigDecimal.ZERO) > 0) {
                    String value = new DecimalFormat("#,##0.00").format(controlParam.getBeyondBalanceValue());
                    replace = replace + ControlException.beyondBalanceValueMessage((String)value);
                }
                causeMessageList.add(replace + "\r\n");
            }
            message.append(BgControlUtils.handleMessageList(".", causeMessageList));
        }
        return message.toString();
    }

    public static Format setDecimalFormatPrecision(Format format, int precision) {
        if (!(format instanceof DecimalFormat)) {
            return format;
        }
        DecimalFormat dformat = (DecimalFormat)format.clone();
        dformat.setMaximumFractionDigits(precision);
        dformat.setMinimumFractionDigits(precision);
        return dformat;
    }

    public static Format getDecimalFormatByInternetSet() {
        FormatObject userFormat = InteServiceHelper.getUserFormat((Long)UserUtils.getUserId());
        if (userFormat == null) {
            return new DecimalFormat("#,##0.00");
        }
        if (FormatFactory.get((FormatTypes)FormatTypes.Number) == null || FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(userFormat) == null) {
            return new DecimalFormat("#,##0.00");
        }
        return FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(userFormat);
    }

    public static Map<String, String> getControlUserDefinedDimNumMapByControlParam(IControlParam controlParam) {
        Map<String, String> userDefendDimNumMap = new LinkedHashMap<String, String>(16);
        if (controlParam == null || controlParam.getBizModel() == null) {
            return userDefendDimNumMap;
        }
        BgControlScheme controlScheme = controlParam.getControlScheme();
        if (controlScheme != null) {
            userDefendDimNumMap = controlScheme.getUserDefendDimNumMap();
        } else {
            BizModel bizModel = controlParam.getBizModel();
            List<DynamicObject> controlDims = BgControlUtils.queryControlUserDefinedDimensionSortFieldMapped(bizModel.getId(), bizModel.getControlBusModelId());
            for (int i = 0; i < controlDims.size(); ++i) {
                int index = i + 1;
                userDefendDimNumMap.put(controlDims.get(i).getString("number"), "userdefined" + index);
            }
        }
        return userDefendDimNumMap;
    }

    public static String replaceControlMessageByControlParam(String message, String keyword, IControlParam controlParam, boolean defaultMessageFlag, Map<String, String> userDefendDimNumMap, @NotNull Map<String, String> namesMap) {
        String regex = "\\{" + keyword + "\\}";
        String userDefinedDim = "";
        BizModel bizModel = controlParam.getBizModel();
        if (bizModel == null) {
            throw new KDBizException("model is null.");
        }
        boolean ebByModel = bizModel.isEBByModel();
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
        Map budgetMemberMap = (Map)((BudgetBalance)((Object)controlParam)).get("BUDGET_MEMBER");
        StringBuilder sb = new StringBuilder();
        switch (keyword) {
            case "model.number": {
                String replacement = bizModel.getNumber();
                message = message.replaceAll(regex, replacement);
                break;
            }
            case "model.name": {
                String replacement = bizModel.getName();
                if (!namesMap.containsKey(String.valueOf(bizModel.getId()))) {
                    DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)bizModel.getId(), (String)"epm_model", (String)"id,name");
                    if (model != null) {
                        namesMap.put(String.valueOf(bizModel.getId()), model.getString("name"));
                    } else {
                        namesMap.put(String.valueOf(bizModel.getId()), bizModel.getName());
                    }
                }
                if (namesMap.containsKey(String.valueOf(bizModel.getId()))) {
                    replacement = namesMap.get(String.valueOf(bizModel.getId()));
                }
                message = message.replaceAll(regex, replacement);
                break;
            }
            case "entity.number": {
                message = BgControlUtils.replaceControlMessageByKeywordNumber(message, regex, budgetMemberMap, SysDimensionEnum.Entity.getNumber());
                break;
            }
            case "entity.name": {
                message = BgControlUtils.replaceControlMessageByKeywordName(message, regex, budgetMemberMap, SysDimensionEnum.Entity.getNumber(), namesMap);
                break;
            }
            case "account.number": {
                message = BgControlUtils.replaceControlMessageByKeywordNumber(message, regex, budgetMemberMap, SysDimensionEnum.Account.getNumber());
                break;
            }
            case "account.name": {
                message = BgControlUtils.replaceControlMessageByKeywordName(message, regex, budgetMemberMap, SysDimensionEnum.Account.getNumber(), namesMap);
                break;
            }
            case "version.number": {
                message = BgControlUtils.replaceControlMessageByKeywordNumber(message, regex, budgetMemberMap, SysDimensionEnum.Version.getNumber());
                break;
            }
            case "version.name": {
                message = BgControlUtils.replaceControlMessageByKeywordName(message, regex, budgetMemberMap, SysDimensionEnum.Version.getNumber(), namesMap);
                break;
            }
            case "currency.number": {
                message = BgControlUtils.replaceControlMessageByKeywordNumber(message, regex, budgetMemberMap, SysDimensionEnum.Currency.getNumber());
                break;
            }
            case "currency.name": {
                message = BgControlUtils.replaceControlMessageByKeywordName(message, regex, budgetMemberMap, SysDimensionEnum.Currency.getNumber(), namesMap);
                break;
            }
            case "period.number": {
                if (ebByModel) {
                    String replacement = controlParam.getYear(true).getNumber() + "." + controlParam.getPeriod(true).getNumber();
                    message = message.replaceAll(regex, replacement);
                    break;
                }
                message = BgControlUtils.replaceControlMessageByKeywordNumber(message, regex, budgetMemberMap, SysDimensionEnum.BudgetPeriod.getNumber());
                break;
            }
            case "period.name": {
                if (ebByModel) {
                    String replacement = controlParam.getYear(true).getName() + controlParam.getPeriod(true).getName();
                    message = message.replaceAll(regex, replacement);
                    break;
                }
                message = BgControlUtils.replaceControlMessageByKeywordName(message, regex, budgetMemberMap, SysDimensionEnum.BudgetPeriod.getNumber(), namesMap);
                break;
            }
            case "changetype.number": {
                message = BgControlUtils.replaceControlMessageByKeywordNumber(message, regex, budgetMemberMap, SysDimensionEnum.ChangeType.getNumber());
                break;
            }
            case "changetype.name": {
                message = BgControlUtils.replaceControlMessageByKeywordName(message, regex, budgetMemberMap, SysDimensionEnum.ChangeType.getNumber(), namesMap);
                break;
            }
            case "audittrail.number": {
                message = BgControlUtils.replaceControlMessageByKeywordNumber(message, regex, budgetMemberMap, SysDimensionEnum.AuditTrail.getNumber());
                break;
            }
            case "audittrail.name": {
                message = BgControlUtils.replaceControlMessageByKeywordName(message, regex, budgetMemberMap, SysDimensionEnum.AuditTrail.getNumber(), namesMap);
                break;
            }
            case "userdefineddim.all": {
                sb.setLength(0);
                for (Map.Entry<String, String> entry : userDefendDimNumMap.entrySet()) {
                    if (budgetMemberMap.get(entry.getKey()) == null) continue;
                    if (StringUtils.isNotEmpty((String)((Member)budgetMemberMap.get(entry.getKey())).getNumber())) {
                        sb.append(((Member)budgetMemberMap.get(entry.getKey())).getNumber()).append(" - ");
                    } else {
                        sb.append(regex).append(" - ");
                    }
                    if (StringUtils.isNotEmpty((String)((Member)budgetMemberMap.get(entry.getKey())).getName())) {
                        sb.append(((Member)budgetMemberMap.get(entry.getKey())).getName()).append("\uff0c");
                        continue;
                    }
                    sb.append(regex).append("\uff0c");
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                } else if (defaultMessageFlag) {
                    regex = regex + "\uff0c";
                }
                String replacement = sb.toString();
                message = message.replaceAll(regex, replacement);
                break;
            }
            case "userdefineddim.all.number": {
                sb.setLength(0);
                for (Map.Entry<String, String> entry : userDefendDimNumMap.entrySet()) {
                    if (budgetMemberMap.get(entry.getKey()) == null) continue;
                    if (StringUtils.isNotEmpty((String)((Member)budgetMemberMap.get(entry.getKey())).getNumber())) {
                        sb.append(((Member)budgetMemberMap.get(entry.getKey())).getNumber()).append("\uff0c");
                        continue;
                    }
                    sb.append(regex).append("\uff0c");
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                }
                String replacement = sb.toString();
                message = message.replaceAll(regex, replacement);
                break;
            }
            case "userdefineddim.all.name": {
                sb.setLength(0);
                for (Map.Entry<String, String> entry : userDefendDimNumMap.entrySet()) {
                    if (budgetMemberMap.get(entry.getKey()) == null) continue;
                    if (StringUtils.isNotEmpty((String)((Member)budgetMemberMap.get(entry.getKey())).getName())) {
                        sb.append(((Member)budgetMemberMap.get(entry.getKey())).getName()).append("\uff0c");
                        continue;
                    }
                    sb.append(regex).append("\uff0c");
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                }
                String replacement = sb.toString();
                message = message.replaceAll(regex, replacement);
                break;
            }
            case "budget": {
                String replacement = decimalFormat.format(((BudgetBalance)((Object)controlParam)).getBudget() != null ? ((BudgetBalance)((Object)controlParam)).getBudget() : new BigDecimal(0));
                message = message.replaceAll(regex, replacement);
                break;
            }
            case "realbudget": {
                String replacement = decimalFormat.format(((BudgetBalance)((Object)controlParam)).getRealBudget() != null ? ((BudgetBalance)((Object)controlParam)).getRealBudget() : new BigDecimal(0));
                message = message.replaceAll(regex, replacement);
                break;
            }
            case "actual.occupation": {
                String replacement = decimalFormat.format(((BudgetBalance)((Object)controlParam)).getOccupation() != null ? ((BudgetBalance)((Object)controlParam)).getOccupation() : new BigDecimal(0));
                message = message.replaceAll(regex, replacement);
                break;
            }
            case "actual.execute": {
                String replacement = decimalFormat.format(((BudgetBalance)((Object)controlParam)).getExecute() != null ? ((BudgetBalance)((Object)controlParam)).getExecute() : new BigDecimal(0));
                message = message.replaceAll(regex, replacement);
                break;
            }
            case "actual.actualchanges": {
                String replacement = decimalFormat.format(((BudgetBalance)((Object)controlParam)).getActualChanges() != null ? ((BudgetBalance)((Object)controlParam)).getActualChanges() : new BigDecimal(0));
                message = message.replaceAll(regex, replacement);
                break;
            }
            case "actual.budgetoccupation": {
                String replacement = decimalFormat.format(((BudgetBalance)((Object)controlParam)).getBudgetOccupation() != null ? ((BudgetBalance)((Object)controlParam)).getBudgetOccupation() : new BigDecimal(0));
                message = message.replaceAll(regex, replacement);
                break;
            }
            case "balance": {
                String replacement = decimalFormat.format(controlParam.getBalance() != null ? controlParam.getBalance() : new BigDecimal(0));
                message = message.replaceAll(regex, replacement);
                break;
            }
            case "beyondmessage": {
                String replacement = decimalFormat.format(controlParam.getBeyondBalanceValue() != null ? controlParam.getBeyondBalanceValue() : new BigDecimal(0));
                message = message.replaceAll(regex, replacement);
                break;
            }
        }
        return message;
    }

    private static String replaceControlMessageByKeywordNumber(String message, String regex, Map<String, Member> budgetMemberMap, String dimNumber) {
        if (budgetMemberMap.get(dimNumber) != null) {
            String replacement = budgetMemberMap.get(dimNumber).getNumber();
            if (StringUtils.isEmpty((String)replacement)) {
                return message;
            }
            message = message.replaceAll(regex, replacement);
        }
        return message;
    }

    private static String replaceControlMessageByKeywordName(String message, String regex, Map<String, Member> budgetMemberMap, String dimNumber, @NotNull Map<String, String> namesMap) {
        if (budgetMemberMap.get(dimNumber) != null) {
            String replacement = budgetMemberMap.get(dimNumber).getName();
            if (StringUtils.isEmpty((String)replacement)) {
                return message;
            }
            message = message.replaceAll(regex, replacement);
        }
        return message;
    }

    public static LocaleString getDefaultMessageTitle() {
        return ResManager.getLocaleString((String)"\u9884\u7b97\u4f53\u7cfb\uff08{model.number} - {model.name}\uff09\u4ee5\u4e0b\u53ef\u7528\u9884\u7b97\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ControlMessageSetPlugin_0", (String)"epm-eb-formplugin");
    }

    public static List<DynamicObject> queryControlUserDefinedDimensionSortFieldMapped(Long modelId, Long businessModelId) {
        List<Object> userDefDims = new ArrayList<DynamicObject>(16);
        HashSet<Long> dimensionIdSet = new HashSet<Long>(16);
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        if (CommonUtils.hasBusinessModel((Long)modelId).booleanValue()) {
            if (IDUtils.isEmptyLong((Long)businessModelId).booleanValue()) {
                return userDefDims;
            }
            builder.add(new QFilter("businessmodel.id", "=", (Object)businessModelId));
            String fields = "id,model.id,businessmodel.id,entryentity.id,entryentity.dimensionid";
            DynamicObjectCollection ctrlDims = QueryServiceHelper.query((String)"eb_bgmcontroldimension", (String)fields, (QFilter[])builder.toArrays());
            if (ctrlDims == null || ctrlDims.isEmpty()) {
                return userDefDims;
            }
            for (DynamicObject ctrlDim : ctrlDims) {
                if (!IDUtils.isNotEmptyLong((Long)ctrlDim.getLong("entryentity.dimensionid")).booleanValue()) continue;
                dimensionIdSet.add(ctrlDim.getLong("entryentity.dimensionid"));
            }
            builder.clear();
            builder.add("issysdimension", "=", (Object)Boolean.FALSE);
            if (!dimensionIdSet.isEmpty()) {
                builder.add(new QFilter("id", "in", dimensionIdSet));
            }
        } else {
            builder.add("issysdimension", "=", (Object)Boolean.FALSE);
        }
        String selectField = "id,number,name,dseq,issysdimension,fieldmapped";
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"epm_dimension", (String)selectField, (QFilter[])builder.toArray(), (String)"dseq");
        userDefDims = doc.stream().filter(k -> !k.getBoolean("issysdimension")).sorted(Comparator.comparing(o -> Integer.parseInt(o.getString("fieldmapped").substring(3)))).collect(Collectors.toList());
        return userDefDims;
    }

    public static Map<Long, BizModel> buildBizModelMap(Collection<IControlParam> controlParams) {
        HashMap<Long, BizModel> bizModelMap = new HashMap<Long, BizModel>(10);
        if (controlParams != null) {
            for (IControlParam controlParam : controlParams) {
                if (controlParam == null || controlParam.getBizModel() == null) continue;
                bizModelMap.put(controlParam.getBizModel().getKey(), controlParam.getBizModel());
            }
        }
        return bizModelMap;
    }

    public static Map<Long, List<IControlParam>> buildParamMap(List<IControlParam> controlParams) {
        HashMap<Long, List<IControlParam>> bizParamMap = new HashMap<Long, List<IControlParam>>(10);
        if (controlParams != null) {
            for (IControlParam controlParam : controlParams) {
                if (controlParam == null || controlParam.getBizModel() == null) continue;
                bizParamMap.computeIfAbsent(controlParam.getBizModel().getKey(), f -> new ArrayList(10)).add(controlParam);
            }
        }
        return bizParamMap;
    }

    public static Long getAddNewPermissionIncludeUserSelectModelId(String entityType, IFormView view) {
        Long modelId = UserSelectUtils.getUserSelectModelId(view);
        Set<Long> modelIds = ModelUtil.getModelIdsWithPermItem(entityType, ModelUtil.queryApp(view), "47156aff000000ac");
        if (IDUtils.isNotEmptyLong((Long)modelId).booleanValue() && modelIds.contains(modelId)) {
            return modelId;
        }
        if (modelIds.size() > 0) {
            modelId = modelIds.iterator().next();
        }
        return modelId;
    }

    public static String subCellString(String excelCellStr, int maxTextLength) {
        if (StringUtils.isNotEmpty((String)excelCellStr) && excelCellStr.length() > maxTextLength) {
            excelCellStr = excelCellStr.substring(0, maxTextLength);
        }
        return excelCellStr;
    }

    private static void excuteSql(String sql) {
        DB.execute((DBRoute)BgBaseConstant.epm, (String)sql);
    }

    public static String getNegativeOccKey(String bizId, Long modelKey) {
        return modelKey + "!" + bizId;
    }

    public static void buildHasNegativeOcc(Collection<BgControlRecord> records, Set<String> hasNegativeOcc) {
        if (records != null) {
            HashMap<String, Map> recordValues = new HashMap<String, Map>(16);
            for (BgControlRecord bgControlRecord : records) {
                if (bgControlRecord.getAmount() == null || StringUtils.isNotEmpty((String)bgControlRecord.getRefBizId()) || "Execute".equals(bgControlRecord.getMember(SysDimensionEnum.ChangeType.getNumber()).getNumber())) continue;
                String memberKey = bgControlRecord.getMemberKey(false);
                String bizId = StringUtils.isNotEmpty((String)bgControlRecord.getRefBizId()) ? bgControlRecord.getRefBizId() : bgControlRecord.getBizId();
                Map subMap = recordValues.computeIfAbsent(bizId, f -> new HashMap(16));
                Map subvalueMap = subMap.computeIfAbsent(bgControlRecord.getBizModel().getKey(), f -> new HashMap(16));
                if (subvalueMap.containsKey(memberKey)) {
                    subvalueMap.put(memberKey, bgControlRecord.getAmount().add((BigDecimal)subvalueMap.get(memberKey)));
                    continue;
                }
                subvalueMap.put(memberKey, bgControlRecord.getAmount());
            }
            for (Map.Entry entry : recordValues.entrySet()) {
                for (Map.Entry me : ((Map)entry.getValue()).entrySet()) {
                    if (!((Map)me.getValue()).values().stream().anyMatch(f -> f.compareTo(BigDecimal.ZERO) < 0)) continue;
                    hasNegativeOcc.add(BgControlUtils.getNegativeOccKey((String)entry.getKey(), (Long)me.getKey()));
                }
            }
        }
    }
}

