/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.LogUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.impl.model.BgWhiteList;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.OQLBuilder;

public class BgControlWhiteUtils {
    private static final Log log = LogFactory.getLog(BgControlWhiteUtils.class);
    private static final String RULE_FIELDS = "id, number, bill, namelisttype, useextbiz, entryentity.id, entryentity.biztype, entryentity.biznumber, entryentity.extbiztype, entryentity.extbiznumber, entryentity.entrystatus, orgentryentity.orgbizid, orgentryentity.orgbiznumber";
    private static final String DEFAULTSET = "isfreetype,isdefault";
    private static volatile Map<String, String> mappingTimestampMap = Collections.synchronizedMap(new HashMap());
    private static volatile LoadingCache<String, List<BgWhiteList>> whiteListMap = CacheBuilder.newBuilder().maximumSize(8L).expireAfterAccess(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, List<BgWhiteList>>(){

        public List<BgWhiteList> load(String entityNumber) {
            return null;
        }
    });

    public static DynamicObjectCollection queryWhite(String billNumber) {
        if (billNumber == null) {
            return null;
        }
        DynamicObjectCollection result = new DynamicObjectCollection();
        Object obj = null;
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("status", "=", (Object)true));
        builder.add(new QFilter("entryentity.entrystatus", "=", (Object)true));
        builder.add(new QFilter("bill.fbasedataid.number", "=", (Object)billNumber));
        Map whiteLists = BusinessDataServiceHelper.loadFromCache((String)"eb_whitelist", (String)RULE_FIELDS, (QFilter[])builder.toArrays());
        for (DynamicObject whiteList : whiteLists.values()) {
            DynamicObjectCollection bills = (DynamicObjectCollection)whiteList.get("bill");
            if (bills == null) continue;
            for (DynamicObject bill : bills) {
                String number;
                obj = bill.get("fbasedataid");
                if (!(obj instanceof DynamicObject) || !billNumber.equals(number = ((DynamicObject)obj).getString("number"))) continue;
                result.add((Object)whiteList);
            }
        }
        return result;
    }

    public static List<BgWhiteList> queryCacheByWhiteList(String entityNumber) {
        ArrayList<BgWhiteList> whiteList = new ArrayList<BgWhiteList>();
        if (kd.bos.util.StringUtils.isEmpty((String)entityNumber)) {
            return whiteList;
        }
        long beginTotal = System.nanoTime();
        Object cacheMap = null;
        HashMap<String, String> cacheTimeMap = (HashMap<String, String>)CacheServiceHelper.get((String)"CONTROL_WHITE_LIST_TIMESTAMP_CACHE1", Map.class);
        if (cacheTimeMap == null) {
            cacheTimeMap = new HashMap<String, String>();
        }
        log.info("query-cache-white-list.get time cache, use=" + LogUtils.use((long)beginTotal));
        String cacheTimeKey = BgControlWhiteUtils.getCacheTimeKey(entityNumber);
        String cacheKey = BgControlWhiteUtils.getCacheKey(entityNumber);
        Object cacheTimestamp = cacheTimeMap.get(cacheTimeKey);
        if (cacheTimestamp == null) {
            cacheTimestamp = String.valueOf(System.nanoTime());
            cacheTimeMap.put(cacheTimeKey, (String)cacheTimestamp);
            CacheServiceHelper.put((String)"CONTROL_WHITE_LIST_TIMESTAMP_CACHE1", cacheTimeMap);
        }
        List<BgWhiteList> _whiteList = null;
        if (cacheTimestamp != null && cacheTimestamp.equals(mappingTimestampMap.get(cacheTimeKey))) {
            _whiteList = (List)whiteListMap.getIfPresent((Object)cacheKey);
        }
        if (_whiteList == null || _whiteList.isEmpty()) {
            long begin;
            block12: {
                begin = System.nanoTime();
                String cache = (String)CacheServiceHelper.get((String)cacheKey, String.class);
                String cacheData = cache;
                if (kd.bos.util.StringUtils.isNotEmpty((String)cacheData)) {
                    try {
                        BgWhiteList[] tmp = (BgWhiteList[])JSONUtils.parse((String)cacheData, new BgWhiteList[0].getClass());
                        if (tmp != null) {
                            _whiteList = Arrays.asList(tmp);
                            break block12;
                        }
                        _whiteList = new ArrayList<BgWhiteList>();
                    }
                    catch (Exception exception) {}
                } else {
                    _whiteList = BgControlWhiteUtils.loadWhiteList(entityNumber);
                    CacheServiceHelper.put((String)cacheKey, (Object)JSONUtils.toString(_whiteList));
                    CacheServiceHelper.put((String)cacheTimeKey, (Object)String.valueOf(System.nanoTime()));
                }
            }
            log.info("load-cache-white-list. entity number=" + entityNumber + ", use=" + LogUtils.use((long)begin));
            whiteListMap.put((Object)cacheKey, _whiteList);
            mappingTimestampMap.put(cacheTimeKey, (String)cacheTimestamp);
            if (_whiteList != null) {
                whiteList.addAll(_whiteList);
            }
        } else {
            whiteList.addAll((Collection<BgWhiteList>)_whiteList);
        }
        return whiteList;
    }

    public static List<BgWhiteList> loadWhiteList(String entityNumber) {
        DynamicObjectCollection dymColl = BgControlWhiteUtils.queryWhite(entityNumber);
        ArrayList<BgWhiteList> whiteList = new ArrayList<BgWhiteList>();
        if (dymColl != null) {
            for (DynamicObject dymObj : dymColl) {
                whiteList.add(BgControlWhiteUtils.buildWhiteList(dymObj));
            }
        }
        return whiteList;
    }

    private static BgWhiteList buildWhiteList(DynamicObject dymObj) {
        DynamicObjectCollection entries;
        BgWhiteList whiteList = new BgWhiteList();
        whiteList.setCacheVer(1);
        whiteList.setBlack("1".equals(dymObj.get("namelisttype")));
        DynamicObjectCollection bizOrgCol = dymObj.getDynamicObjectCollection("orgentryentity");
        if (bizOrgCol != null) {
            HashSet<String> orgIds = new HashSet<String>();
            for (DynamicObject dymOrg : bizOrgCol) {
                orgIds.add(dymOrg.getString("orgbiznumber"));
            }
            whiteList.setBizOrgIds(orgIds);
        }
        if ((entries = dymObj.getDynamicObjectCollection("entryentity")) != null) {
            HashSet<String> bizAndExt = new HashSet<String>();
            for (DynamicObject entryentity : entries) {
                if (!Boolean.TRUE.equals(entryentity.get("entrystatus"))) continue;
                String number = null;
                number = entryentity.getString("extbiznumber") != null ? entryentity.getString("biznumber") + "@" + entryentity.getString("extbiznumber") : entryentity.getString("biznumber");
                if (whiteList.getExtBizType() == null && StringUtils.isNotEmpty((String)entryentity.getString("extbiztype"))) {
                    whiteList.setExtBizType(entryentity.getString("extbiztype"));
                }
                bizAndExt.add(number);
            }
            whiteList.getWhitelist().addAll(bizAndExt);
        }
        return whiteList;
    }

    public static void isExitAccount(LogStats stats, String entityNumber, List<IControlParam> controlParams, BgControlScheme scheme) {
        List params;
        String key;
        if (kd.bos.util.StringUtils.isEmpty((String)entityNumber) || controlParams == null || controlParams.isEmpty() || scheme == null) {
            return;
        }
        List<BgWhiteList> whiteList = BgControlWhiteUtils.queryCacheByWhiteList(entityNumber);
        if (whiteList == null || whiteList.isEmpty()) {
            return;
        }
        HashMap<String, Map> bizAndExt = new HashMap<String, Map>(controlParams.size());
        Map subBizAndExt = null;
        StringBuilder stringBuilder = new StringBuilder();
        for (IControlParam controlParam : controlParams) {
            BgControlLogUtils.info(stats, true, "white-list-controlParam-reqorgUnitObj:" + controlParam.getReqOrgUnitObj().getNumber());
            String orgId = String.valueOf(controlParam.getReqOrgUnitObj().getNumber());
            subBizAndExt = bizAndExt.computeIfAbsent(orgId, f -> new HashMap());
            stringBuilder.setLength(0);
            stringBuilder.append(controlParam.getAccount(true).getNumber()).append("@");
            if (scheme.getAccountExtFields() != null) {
                Object object = controlParam.getPropValueMap().get(scheme.getAccountExtFields());
                if (object instanceof DynamicObject) {
                    stringBuilder.append(((DynamicObject)object).getString("number"));
                } else if (object != null) {
                    if (object instanceof Long) {
                        Object number = controlParam.getPropValueMap().get(OQLBuilder.getNumberProp(scheme.getAccountExtFields()));
                        if (number != null) {
                            stringBuilder.append(String.valueOf(number));
                        } else {
                            stringBuilder.append(String.valueOf(object));
                        }
                    } else {
                        stringBuilder.append(String.valueOf(object));
                    }
                }
            }
            key = stringBuilder.toString();
            params = subBizAndExt.computeIfAbsent(key, f -> Lists.newArrayList());
            params.add(controlParam);
        }
        BgControlLogUtils.info(stats, true, "white-list-bizAndExt:" + JSONUtils.toString(bizAndExt.keySet()));
        BgControlLogUtils.info(stats, true, "white-list-whiteList:" + JSONUtils.toString(whiteList));
        HashSet<String> blackSet = new HashSet<String>();
        HashSet whiteSet = new HashSet();
        HashSet<String> tmpSet = null;
        for (Map.Entry entry : bizAndExt.entrySet()) {
            String orgId = (String)entry.getKey();
            blackSet.clear();
            whiteSet.clear();
            for (BgWhiteList bgWhiteList : whiteList) {
                if (bgWhiteList.getWhitelist() == null || bgWhiteList.getWhitelist().isEmpty()) continue;
                HashSet<String> hashSet = tmpSet = bgWhiteList.isBlack() ? blackSet : whiteSet;
                if (bgWhiteList.getBizOrgIds() != null && !bgWhiteList.getBizOrgIds().isEmpty() && !bgWhiteList.getBizOrgIds().contains(orgId)) continue;
                tmpSet.addAll(bgWhiteList.getWhitelist());
            }
            if (blackSet.isEmpty() && whiteSet.isEmpty()) continue;
            for (Map.Entry entry2 : ((Map)bizAndExt.get(orgId)).entrySet()) {
                key = (String)entry2.getKey();
                params = (List)entry2.getValue();
                if (!blackSet.isEmpty()) {
                    if (blackSet.contains(key)) continue;
                    BgControlLogUtils.info(stats, true, "black list skip = " + key);
                    controlParams.removeAll(params);
                    continue;
                }
                if (!whiteSet.contains(key)) continue;
                BgControlLogUtils.info(stats, true, "white-list-skip = " + key);
                controlParams.removeAll(params);
            }
        }
    }

    private static String getCacheKey(String entityNumber) {
        return RequestContext.get().getAccountId() + "_" + "CONTROL_WHITE_LIST_CACHE1" + "_" + entityNumber.toLowerCase();
    }

    private static String getCacheTimeKey(String entityNumber) {
        return RequestContext.get().getAccountId() + "_" + "CONTROL_WHITE_LIST_TIMESTAMP_CACHE1" + "_" + entityNumber;
    }

    public static synchronized void clearCacheByWhiteList(String entityNumber) {
        if (kd.bos.util.StringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        HashSet<String> entityNumbers = new HashSet<String>();
        entityNumbers.add(entityNumber);
        BgControlWhiteUtils.clearCacheByWhiteList(entityNumbers);
    }

    public static synchronized void clearCacheByWhiteList(Set<String> entityNumbers) {
        if (entityNumbers == null || entityNumbers.isEmpty()) {
            return;
        }
        HashMap mapTimeCache = (HashMap)CacheServiceHelper.get((String)"CONTROL_WHITE_LIST_TIMESTAMP_CACHE1", Map.class);
        if (mapTimeCache == null) {
            mapTimeCache = new HashMap();
        }
        for (String entityNumber : entityNumbers) {
            CacheServiceHelper.remove((String)BgControlWhiteUtils.getCacheKey(entityNumber));
            mapTimeCache.remove(BgControlWhiteUtils.getCacheTimeKey(entityNumber));
        }
        CacheServiceHelper.put((String)"CONTROL_WHITE_LIST_TIMESTAMP_CACHE1", mapTimeCache);
    }

    private static LoadingCache<String, List<BgWhiteList>> getWhiteListMap() {
        return whiteListMap;
    }

    public static boolean isFreeType(BizModel bizModel, BgControlData controlData) {
        if (bizModel == null) {
            BgControlLogUtils.info(controlData.getStats(), true, "isFreeType-nofound-bizmodel");
            return false;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("isdefault", "=", (Object)true));
        builder.add(new QFilter("model", "=", (Object)bizModel.getId()));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"eb_bgcontrolrulemain", (String)DEFAULTSET, (QFilter[])builder.toArrays());
        if (dynamicObject == null) {
            return false;
        }
        return dynamicObject.getBoolean("isfreetype");
    }
}

