/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.impl.model.BgItemMapping;

public class BgMemMappingServiceHelper {
    private static final Log log = LogFactory.getLog(BgMemMappingServiceHelper.class);
    public static final String FIELDS = "fid, number, name, useassistdata, isexitnoleaf, businessbasedataext, entryentity.id, entryentity.bizmember, entryentity.biznumber, entryentity.showbizmemberext, entryentity.biznumberext, entryentity.bizmemberext, entryentity.range,entryentity.dimmemnumber, entryentity.showdimmember,entryentity.budimmemnumber, entryentity.bushowdimmember";
    private static volatile Map<String, String> mappingTimestampMap = Collections.synchronizedMap(new HashMap());
    private static volatile LoadingCache<String, BgItemMapping> mappingMap = CacheBuilder.newBuilder().maximumSize(8L).expireAfterAccess(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, BgItemMapping>(){

        public BgItemMapping load(String mappingId) {
            return BgMemMappingServiceHelper.$loadMapping(mappingId);
        }
    });

    public static Map<Long, BgItemMapping> loadMapping(Set<Long> mappingIds) {
        HashMap<Long, BgItemMapping> mappings = new HashMap<Long, BgItemMapping>();
        if (mappingIds == null || mappingIds.isEmpty()) {
            return mappings;
        }
        BgItemMapping mapping = null;
        ArrayList<Long> _mappingIds = new ArrayList<Long>(mappingIds);
        long begin = System.nanoTime();
        StringBuilder logStr = new StringBuilder();
        logStr.append("begin-load-mapping.").append("\r\n");
        logStr.append("mappingIds=").append(JSONUtils.toString(mappingIds)).append("\r\n");
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fnumber, fdim, fbusinessbasedata, fuseassistdata, fisexitnoleaf, fbusinessbasedataext from t_eb_dimmembermapping where ", new Object[0]);
        sql.appendIn("fid", _mappingIds);
        try (DataSet ds = DB.queryDataSet((String)"loadMapping", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            for (Row row : ds) {
                mapping = new BgItemMapping();
                mapping.setId(row.getLong("fid"));
                mapping.setNumber(row.getString("fnumber"));
                mapping.setBizData(row.getString("fbusinessbasedata"));
                mapping.setUseAssistData(row.getBoolean("fuseassistdata"));
                mapping.setExitNoLeaf(row.getBoolean("fisexitnoleaf"));
                mapping.setBizDataExt(row.getString("fbusinessbasedataext"));
                mapping.setDim(row.getString("fdim"));
                mappings.put(mapping.getId(), mapping);
            }
        }
        long end = System.nanoTime();
        logStr.append("end-load-ref. use=").append(LogUtils.use((long)begin, (long)end)).append("\r\n");
        begin = end;
        sql = new SqlBuilder();
        sql.append("select fid, fentryid, fbizmemberid, fbiznumber, fbizname, frange, ", new Object[0]).append("fbizmemberiextid, fbiznumberext, fbiznameext, ", new Object[0]).append("fdimmemberid, fdimmemnumber, fdimmemname, ", new Object[0]).append("fbudimmemberid, fbudimmemnumber, fbudimmemname, fmorebussdata, fwildcardstatus from t_eb_membermapping where ", new Object[0]);
        sql.appendIn("fid", _mappingIds);
        sql.append(" and fentrystatus = '1'", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"loadMappingEntry", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            for (Row row : ds) {
                mapping = (BgItemMapping)mappings.get(row.getLong("fid"));
                if (mapping == null) continue;
                mapping.addEntry(mapping.getId(), row.getLong("fentryid"), row.getString("fmorebussdata"), row.getString("fbizmemberid"), row.getString("fbiznumber"), row.getString("fbizname"), row.getString("frange"), row.getString("fbizmemberiextid"), row.getString("fbiznumberext"), row.getString("fbiznameext"), row.getString("fdimmemberid"), row.getString("fdimmemnumber"), row.getString("fdimmemname"), row.getString("fbudimmemberid"), row.getString("fbudimmemnumber"), row.getString("fbudimmemname"), row.getString("fwildcardstatus"));
            }
        }
        mappings.values().forEach(m -> m.sortWildcards());
        logStr.append("end-load-mapping. use=").append(LogUtils.use((long)begin));
        log.info(logStr.toString());
        return mappings;
    }

    private static Map<String, String> getCacheMap(Map<String, String> cacheMap) {
        if (cacheMap != null) {
            return cacheMap;
        }
        long beginTotal = System.nanoTime();
        StringBuilder logStr = new StringBuilder();
        cacheMap = (HashMap<String, String>)CacheServiceHelper.get((String)"CONTROL_MAPPING_CACHE1", Map.class);
        if (cacheMap == null) {
            cacheMap = new HashMap<String, String>();
        }
        logStr.append("query-cache-mapping.get mapping cache, use=").append(LogUtils.use((long)beginTotal));
        log.info(logStr.toString());
        return cacheMap;
    }

    public static Map<Long, BgItemMapping> queryCacheByMapping(BizModel model, Set<Long> mappingIds) {
        HashMap<Long, BgItemMapping> mappings = new HashMap<Long, BgItemMapping>();
        if (model == null || mappingIds == null || mappingIds.isEmpty()) {
            return mappings;
        }
        long beginTotal = System.nanoTime();
        StringBuilder logStr = new StringBuilder();
        Map<String, String> cacheMap = null;
        HashMap<String, String> cacheTimeMap = (HashMap<String, String>)CacheServiceHelper.get((String)"CONTROL_MAPPING_TIMESTAMP_CACHE1", Map.class);
        if (cacheTimeMap == null) {
            cacheTimeMap = new HashMap<String, String>();
        }
        logStr.append("query-cache-mapping.get time cache, use=").append(LogUtils.use((long)beginTotal));
        log.info(logStr.toString());
        HashSet queryIds = Sets.newHashSetWithExpectedSize((int)mappingIds.size());
        for (Long mappingId : mappingIds) {
            String _mappingId = String.valueOf(mappingId);
            BgItemMapping itemMapping = null;
            Object cacheTimestamp = cacheTimeMap.get(_mappingId);
            if (cacheTimestamp == null) {
                cacheTimestamp = String.valueOf(System.nanoTime());
                cacheTimeMap.put(_mappingId, (String)cacheTimestamp);
                CacheServiceHelper.put((String)"CONTROL_MAPPING_TIMESTAMP_CACHE1", cacheTimeMap);
            }
            if (cacheTimestamp != null && cacheTimestamp.equals(mappingTimestampMap.get(_mappingId))) {
                itemMapping = (BgItemMapping)mappingMap.getIfPresent((Object)_mappingId);
            }
            if (itemMapping == null) {
                String cacheData;
                String cache = (cacheMap = BgMemMappingServiceHelper.getCacheMap(cacheMap)).get(_mappingId);
                if (cache instanceof String && StringUtils.isNotEmpty((String)(cacheData = cache))) {
                    logStr = new StringBuilder();
                    long begin = System.nanoTime();
                    try {
                        itemMapping = (BgItemMapping)JSONUtils.parse((String)cacheData, BgItemMapping.class);
                        if (itemMapping != null) {
                            mappings.put(mappingId, itemMapping);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    mappingMap.put((Object)_mappingId, (Object)itemMapping);
                    mappingTimestampMap.put(_mappingId, (String)cacheTimestamp);
                    logStr.append("load-cache-mapping. id=").append(_mappingId).append(", use=").append(LogUtils.use((long)begin));
                    log.info(logStr.toString());
                }
            } else {
                mappings.put(mappingId, itemMapping);
                log.info("load-static-cache-mapping.id=" + _mappingId);
            }
            if (itemMapping != null) continue;
            queryIds.add(mappingId);
        }
        if (!queryIds.isEmpty()) {
            logStr = new StringBuilder();
            long begin = System.nanoTime();
            Map<Long, BgItemMapping> _mappings = BgMemMappingServiceHelper.loadMapping(queryIds);
            for (BgItemMapping _mapping : _mappings.values()) {
                cacheMap = BgMemMappingServiceHelper.getCacheMap(cacheMap);
                cacheMap.put(String.valueOf(_mapping.getId()), JSONUtils.toString((Object)_mapping));
                cacheTimeMap.put(String.valueOf(_mapping.getId()), String.valueOf(System.nanoTime()));
            }
            mappings.putAll(_mappings);
            CacheServiceHelper.put((String)"CONTROL_MAPPING_CACHE1", cacheMap);
            CacheServiceHelper.put((String)"CONTROL_MAPPING_TIMESTAMP_CACHE1", cacheTimeMap);
            logStr.append("load-db-mapping. id=").append(queryIds).append(", use=").append(LogUtils.use((long)begin));
            log.info(logStr.toString());
        }
        logStr = new StringBuilder();
        logStr.append("query-cache-mapping. id=").append(mappingIds).append(", use=").append(LogUtils.use((long)beginTotal));
        log.info(logStr.toString());
        return mappings;
    }

    public static synchronized void clearCacheByModel(Long modelId, Long dimensionId) {
        if (IDUtils.isNull((Long)modelId) || IDUtils.isNull((Long)dimensionId)) {
            return;
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("dimnumber", "=", (Object)"Entity");
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"eb_dimmembermapping", (QFilter[])builder.toArrays(), null, (int)1000);
        if (pks != null) {
            BgMemMappingServiceHelper.clearCacheByMapping(new HashSet<Long>(IDUtils.toLongs((List)pks)));
        }
    }

    public static synchronized void clearCacheByMapping(Long mappingId) {
        if (mappingId == null || mappingId == 0L) {
            return;
        }
        HashSet<Long> mappingIds = new HashSet<Long>();
        mappingIds.add(mappingId);
        BgMemMappingServiceHelper.clearCacheByMapping(mappingIds);
    }

    public static synchronized void clearCacheByMapping(Set<Long> mappingIds) {
        HashMap mapTimeCache;
        if (mappingIds == null || mappingIds.isEmpty()) {
            return;
        }
        HashMap mapCache = (HashMap)CacheServiceHelper.get((String)"CONTROL_MAPPING_CACHE1", Map.class);
        if (mapCache == null) {
            mapCache = new HashMap();
        }
        if ((mapTimeCache = (HashMap)CacheServiceHelper.get((String)"CONTROL_MAPPING_TIMESTAMP_CACHE1", Map.class)) == null) {
            mapTimeCache = new HashMap();
        }
        for (Long mappingId : mappingIds) {
            mapCache.remove(String.valueOf(mappingId));
            mapTimeCache.remove(String.valueOf(mappingId));
        }
        CacheServiceHelper.put((String)"CONTROL_MAPPING_CACHE1", mapCache);
        CacheServiceHelper.put((String)"CONTROL_MAPPING_TIMESTAMP_CACHE1", mapTimeCache);
    }

    private static LoadingCache<String, BgItemMapping> getCentralizedMap() {
        return mappingMap;
    }

    protected static BgItemMapping $loadMapping(String mappingId) {
        return null;
    }
}

