/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;

public class BgMemberMapHisUtils {
    private static Log log = LogFactory.getLog(BgMemberMapHisUtils.class);

    public static void write(Long modelId, String entityNumber, String propValue, Member bizMember) {
        if (modelId == null || StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)propValue) || BgMemberMapHisUtils.verify(bizMember)) {
            return;
        }
        String businessdata = BgMemberMapHisUtils.getPropBusinessData(entityNumber, propValue);
        if (businessdata == null) {
            return;
        }
        String sql = "select fid from t_eb_dimmemberhistory where fmodelid = ? and fbusinessdata = ? and fdimension = ? and fbiznumber = ?";
        Object[] params = new Object[]{modelId, businessdata, bizMember.getDimension().getNumber(), bizMember.getNumber()};
        DBRoute epm = DBRoute.of((String)"epm");
        try (DataSet ds = DB.queryDataSet((String)"queryMemberMapHistory", (DBRoute)epm, (String)sql, (Object[])params);){
            if (ds != null) {
                Object[] excuteParams;
                String excuteSql;
                Date date = new Date();
                if (ds.hasNext()) {
                    Row row = ds.next();
                    excuteSql = "update t_eb_dimmemberhistory set fmodifydate = ? where fid = ?";
                    excuteParams = new Object[]{date, row.getLong("fid")};
                } else {
                    excuteSql = "insert into t_eb_dimmemberhistory (fid, fmodelid, fbusinessdata, fdimension, fbiznumber, fbizname, fcreatedate, fmodifydate) values (?,?,?,?,?,?,?,?)";
                    excuteParams = new Object[]{DBServiceHelper.genGlobalLongId(), modelId, businessdata, bizMember.getDimension().getNumber(), bizMember.getNumber(), bizMember.getName(), date, date};
                }
                BgMemberMapHisUtils.writeData(excuteSql, excuteParams);
            }
        }
    }

    private static void writeData(String sql, Object[] params) {
        try (TXHandle tx = TX.requiresNew((String)"eb_dimmemberhistory");){
            try {
                DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])params);
            }
            catch (Throwable ex) {
                tx.markRollback();
                log.error("save member mapping history error:", ex);
            }
        }
    }

    private static boolean verify(Member member) {
        return member == null || StringUtils.isEmpty((String)member.getNumber()) || StringUtils.isEmpty((String)member.getName());
    }

    private static String getPropBusinessData(String entityNumber, String propValue) {
        String businessdata = null;
        if (StringUtils.isEmpty((String)entityNumber) || StringUtils.isEmpty((String)propValue)) {
            return businessdata;
        }
        MainEntityType met = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        if (met != null) {
            businessdata = BgMemberMapHisUtils.getPropBusinessData((DynamicObjectType)met, propValue);
        }
        return businessdata;
    }

    private static String getPropBusinessData(DynamicObjectType dt, String propValue) {
        String _prop;
        String businessdata = null;
        if (dt == null || StringUtils.isEmpty((String)propValue)) {
            return businessdata;
        }
        int index = propValue.indexOf(".");
        String string = _prop = index >= 0 ? propValue.substring(0, index) : propValue;
        if (_prop != null) {
            DynamicProperty prop = dt.getProperty(_prop);
            if (prop instanceof EntryProp) {
                String lastProp = index >= 0 ? propValue.substring(index + 1) : propValue;
                businessdata = BgMemberMapHisUtils.getPropBusinessData((EntryProp)prop, lastProp);
            } else if (prop instanceof BasedataProp) {
                businessdata = BgMemberMapHisUtils.getPropBusinessData((BasedataProp)prop);
            }
        }
        return businessdata;
    }

    private static String getPropBusinessData(EntryProp prop, String propValue) {
        String businessdata = null;
        if (prop == null || StringUtils.isEmpty((String)propValue)) {
            return businessdata;
        }
        DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
        if (dt instanceof DynamicObjectType) {
            businessdata = BgMemberMapHisUtils.getPropBusinessData(dt, propValue);
        }
        return businessdata;
    }

    private static String getPropBusinessData(BasedataProp prop) {
        return prop != null ? prop.getBaseEntityId() : null;
    }

    public static boolean importHistory(Long mappingId, String businessData, DynamicObjectCollection historys, int[] rows) {
        boolean re = false;
        if (mappingId == null || mappingId == 0L || StringUtils.isEmpty((String)businessData) || historys == null || historys.isEmpty()) {
            return re;
        }
        HashSet<String> bizNumbers = new HashSet<String>();
        DynamicObject history = null;
        Object mapping = null;
        DynamicObject member = null;
        int in = rows.length;
        for (int i = 0; i < in; ++i) {
            history = (DynamicObject)historys.get(rows[i]);
            if (history.get("members") == null) continue;
            bizNumbers.add(history.getString("biznumber"));
        }
        if (!bizNumbers.isEmpty()) {
            HashMap<String, Long> bizObjMap = new HashMap<String, Long>();
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("number", "in", bizNumbers));
            List bizObjs = null;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBaseData", (String)businessData, (String)"id, number", (QFilter[])builder.toArray(), null);){
                bizObjs = CommonServiceHelper.transDataSet((DataSet)ds);
                if (bizObjs != null && !bizObjs.isEmpty()) {
                    for (Map bizObj : bizObjs) {
                        bizObjMap.put((String)bizObj.get("number"), (Long)bizObj.get("id"));
                    }
                }
            }
            bizNumbers.clear();
            DBRoute epm = DBRoute.of((String)"epm");
            DataSet ds = DB.queryDataSet((String)"queryMapping", (DBRoute)epm, (String)"select fbiznumber from t_eb_membermapping where fid = ?", (Object[])new Object[]{mappingId});
            Object object = null;
            try {
                if (ds != null) {
                    Row row = null;
                    while (ds.hasNext()) {
                        row = ds.next();
                        bizNumbers.add(row.getString("fbiznumber"));
                    }
                }
            }
            catch (Throwable row) {
                object = row;
                throw row;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)object).addSuppressed(row);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            Object[] params = null;
            String bizNumber = null;
            String sql = "insert into t_eb_membermapping(fid, fentryid, fseq, fentrystatus, fbizmemberid, fbiznumber, fbizname, fdimmemberid, fdimmemnumber, fdimmemname) values (?,?,?,?,?,?,?,?,?,?)";
            SqlBatchUtils utils = SqlBatchUtils.getInstance((String)sql);
            try (TXHandle tx = TX.required((String)("eb/mapping/import-" + mappingId));){
                HashSet<Long> historyIds = new HashSet<Long>();
                try {
                    int in2 = rows.length;
                    for (int i = 0; i < in2; ++i) {
                        history = (DynamicObject)historys.get(rows[i]);
                        member = history.getDynamicObject("members");
                        if (member == null || !bizObjMap.containsKey(bizNumber = history.getString("biznumber")) || bizNumbers.contains(bizNumber)) continue;
                        historyIds.add(history.getLong("id"));
                        params = new Object[]{mappingId, DBServiceHelper.genGlobalLongId(), 0, 1, bizObjMap.get(history.getString("biznumber")), history.getString("biznumber"), history.getString("bizname"), member.getLong("id"), member.getString("number"), member.getString("name")};
                        utils.addBatch(params);
                    }
                    utils.executeBatch();
                    builder.clear();
                    builder.add(new QFilter("id", "in", historyIds));
                    DeleteServiceHelper.delete((String)"eb_mappinghistory", (QFilter[])builder.toArray());
                    re = true;
                }
                catch (Throwable ex) {
                    tx.markRollback();
                    throw ex;
                }
            }
        }
        return re;
    }
}

