/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import kd.epm.eb.common.enums.BgControlPeriodTypeEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.impl.model.BgControlSetting;

public class BgPeriodUtils
extends kd.epm.eb.common.utils.period.BgPeriodUtils {
    public static final int MONTH_OF_YEAR = 12;
    public static final int MONTH_OF_HALFYEAR = 6;
    public static final int MONTH_OF_QUARTER = 3;
    public static final int QUARTER_OF_YEAR = 4;
    public static final int QUARTER_OF_HALFYEAR = 2;
    public static final int HALFYEAR_OF_YEAR = 2;

    public static List<List<String>> getBgPeriod(boolean isEb, IBudgetBalance param) {
        return BgPeriodUtils.getPeriod(isEb, param, false);
    }

    public static List<List<String>> getAcPeriod(boolean isEb, IBudgetBalance param) {
        return BgPeriodUtils.getPeriod(isEb, param, true);
    }

    private static List<List<String>> getPeriod(boolean isEb, IBudgetBalance param, boolean hasActual) {
        LinkedList<List<String>> periods = new LinkedList<List<String>>();
        if (param == null || param.getSetting() == null) {
            return periods;
        }
        return BgPeriodUtils.getPeriod(isEb, param.getSetting(), param.getBizModel().getPeriodUtils().isPeriodUserDefine() ? BgPeriodHelper.periodNumberToDate((String)param.getFullPeriodNumber(true), (boolean)isEb) : param.getBizTime(), hasActual);
    }

    public static List<List<String>> getPeriod(boolean isEb, BgControlSetting setting, Date bizTime, boolean hasActual) {
        ArrayList<List<String>> periods = new ArrayList<List<String>>();
        if (setting == null || bizTime == null) {
            return periods;
        }
        return BgPeriodUtils.getPeriod(isEb, setting.getPeriodType().getIndex(), setting.getSettingType().getIndex(), bizTime, hasActual);
    }

    private static List<List<String>> getPeriod(boolean isEb, int periodType, int type, Date bizTime, boolean hasActual) {
        List<List<String>> periods = new LinkedList<List<String>>();
        if (bizTime == null) {
            return periods;
        }
        if (type == BgControlSettingTypeEnum.MONTH.getIndex()) {
            periods = BgPeriodUtils.getCurrPeriod(isEb, bizTime, periodType, BgControlPeriodTypeEnum.MONTH.getIndex());
        } else if (type == BgControlSettingTypeEnum.QUARTER.getIndex()) {
            periods = BgPeriodUtils.getCurrPeriod(isEb, bizTime, periodType, BgControlPeriodTypeEnum.QUARTER.getIndex());
        } else if (type == BgControlSettingTypeEnum.HALFYEAR.getIndex()) {
            periods = BgPeriodUtils.getCurrPeriod(isEb, bizTime, periodType, BgControlPeriodTypeEnum.HALFYEAR.getIndex());
        } else if (type == BgControlSettingTypeEnum.YEAR.getIndex()) {
            periods = BgPeriodUtils.getCurrPeriod(isEb, bizTime, periodType, BgControlPeriodTypeEnum.YEAR.getIndex());
        } else if (type == BgControlSettingTypeEnum.MONTH_ADDUP.getIndex()) {
            periods = BgPeriodUtils.getAddup(isEb, bizTime, periodType, BgControlPeriodTypeEnum.MONTH.getIndex(), BgControlPeriodTypeEnum.YEAR.getIndex(), hasActual);
        } else if (type == BgControlSettingTypeEnum.QUARTER_ADDUP.getIndex()) {
            periods = BgPeriodUtils.getAddup(isEb, bizTime, periodType, BgControlPeriodTypeEnum.QUARTER.getIndex(), BgControlPeriodTypeEnum.YEAR.getIndex(), hasActual);
        } else if (type == BgControlSettingTypeEnum.HALFYEAR_ADDUP.getIndex()) {
            periods = BgPeriodUtils.getAddup(isEb, bizTime, periodType, BgControlPeriodTypeEnum.HALFYEAR.getIndex(), BgControlPeriodTypeEnum.YEAR.getIndex(), hasActual);
        } else if (type == BgControlSettingTypeEnum.MONTH_HALFYEAR_ADDUP.getIndex()) {
            periods = BgPeriodUtils.getAddup(isEb, bizTime, periodType, BgControlPeriodTypeEnum.MONTH.getIndex(), BgControlPeriodTypeEnum.HALFYEAR.getIndex(), hasActual);
        } else if (type == BgControlSettingTypeEnum.QUARTER_HALFYEAR_ADDUP.getIndex()) {
            periods = BgPeriodUtils.getAddup(isEb, bizTime, periodType, BgControlPeriodTypeEnum.QUARTER.getIndex(), BgControlPeriodTypeEnum.HALFYEAR.getIndex(), hasActual);
        } else if (type == BgControlSettingTypeEnum.MONTH_QUARTER_ADDUP.getIndex()) {
            periods = BgPeriodUtils.getAddup(isEb, bizTime, periodType, BgControlPeriodTypeEnum.MONTH.getIndex(), BgControlPeriodTypeEnum.QUARTER.getIndex(), hasActual);
        } else if (type != BgControlSettingTypeEnum.YEAR_MODEL_ADDIP.getIndex() && type != BgControlSettingTypeEnum.QUARTER_MODEL_ADDUP.getIndex() && type != BgControlSettingTypeEnum.MONTH_MODEL_ADDUP.getIndex() && type == BgControlSettingTypeEnum.MONTH_BY_YEAR_CURR_GROSS.getIndex()) {
            periods = BgPeriodUtils.getGrossByYear(isEb, bizTime, periodType, BgControlPeriodTypeEnum.MONTH.getIndex(), 0);
        }
        return periods;
    }

    private static List<List<String>> getCurrPeriod(boolean isEb, Date bizTime, int periodType, int calcPeriodCycle) {
        LinkedList<List<String>> periods = new LinkedList<List<String>>();
        if (bizTime == null) {
            return periods;
        }
        CalendarHelper helper = new CalendarHelper(bizTime);
        int year = helper.getCurrentlyYear();
        String yearStr = BgPeriodUtils.getPeriodYear((int)year);
        String trueStr = Boolean.TRUE.toString();
        ArrayList period = null;
        if (periodType == BgControlPeriodTypeEnum.MONTH.getIndex()) {
            int mBegin = 0;
            int mend = 0;
            if (calcPeriodCycle == BgControlPeriodTypeEnum.YEAR.getIndex()) {
                mBegin = 1;
                mend = 12;
            } else if (calcPeriodCycle == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
                int halfYear = helper.getCurrentlyHalfYear();
                mBegin = (halfYear - 1) * 6 + 1;
                mend = halfYear * 6;
            } else if (calcPeriodCycle == BgControlPeriodTypeEnum.QUARTER.getIndex()) {
                int quarter = helper.getCurrentlyQuarter();
                mBegin = (quarter - 1) * 3 + 1;
                mend = quarter * 3;
            } else if (calcPeriodCycle == BgControlPeriodTypeEnum.MONTH.getIndex()) {
                mend = mBegin = helper.getCurrentlyMonth();
            }
            if (isEb) {
                while (mBegin <= mend) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(yearStr);
                    period.add(BgPeriodUtils.getPeriodMonth((int)mBegin));
                    period.add(trueStr);
                    periods.add(period);
                    ++mBegin;
                }
            } else {
                while (mBegin <= mend) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(yearStr);
                    period.add(BgPeriodUtils.getBgPeriodMonth((int)year, (int)mBegin));
                    period.add(trueStr);
                    periods.add(period);
                    ++mBegin;
                }
            }
        } else if (periodType == BgControlPeriodTypeEnum.QUARTER.getIndex()) {
            int qBegin = 0;
            int qEnd = 0;
            if (calcPeriodCycle == BgControlPeriodTypeEnum.YEAR.getIndex()) {
                qBegin = 1;
                qEnd = 4;
            } else if (calcPeriodCycle == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
                int halfYear = helper.getCurrentlyHalfYear(bizTime);
                qBegin = (halfYear - 1) * 2 + 1;
                qEnd = halfYear * 2;
            } else if (calcPeriodCycle == BgControlPeriodTypeEnum.QUARTER.getIndex()) {
                qEnd = qBegin = helper.getCurrentlyQuarter(bizTime);
            }
            if (isEb) {
                while (qBegin <= qEnd) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(yearStr);
                    period.add(BgPeriodUtils.getPeriodQuarter((int)qBegin));
                    period.add(trueStr);
                    periods.add(period);
                    ++qBegin;
                }
            } else {
                while (qBegin <= qEnd) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(yearStr);
                    period.add(BgPeriodUtils.getBgPeriodQuarter((int)year, (int)qBegin));
                    period.add(trueStr);
                    periods.add(period);
                    ++qBegin;
                }
            }
        } else if (periodType == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
            int hyBegin = 0;
            int hyEnd = 0;
            if (calcPeriodCycle == BgControlPeriodTypeEnum.YEAR.getIndex()) {
                hyBegin = 1;
                hyEnd = 2;
            } else if (calcPeriodCycle == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
                hyEnd = hyBegin = helper.getCurrentlyHalfYear(bizTime);
            }
            if (isEb) {
                while (hyBegin <= hyEnd) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(yearStr);
                    period.add(BgPeriodUtils.getPeriodHalfYear((int)hyBegin));
                    period.add(trueStr);
                    periods.add(period);
                    ++hyBegin;
                }
            } else {
                while (hyBegin <= hyEnd) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(yearStr);
                    period.add(BgPeriodUtils.getBgPeriodHalfYear((int)year, (int)hyBegin));
                    period.add(trueStr);
                    periods.add(period);
                    ++hyBegin;
                }
            }
        } else if (periodType == BgControlPeriodTypeEnum.YEAR.getIndex()) {
            // empty if block
        }
        return periods;
    }

    private static List<List<String>> getAddup(boolean isEb, Date bizTime, int periodType, int calcPeriodType, int calcPeriodCycle, boolean hasActual) {
        LinkedList<List<String>> periodNums = new LinkedList<List<String>>();
        if (bizTime == null) {
            return periodNums;
        }
        CalendarHelper helper = new CalendarHelper(bizTime);
        int begin = 0;
        int end = 0;
        int cYear = helper.getCurrentlyYear();
        int cHalfYear = helper.getCurrentlyHalfYear();
        int cQuarter = helper.getCurrentlyQuarter();
        int cMonth = helper.getCurrentlyMonth();
        String cYearStr = BgPeriodUtils.getPeriodYear((int)cYear);
        String trueStr = Boolean.TRUE.toString();
        ArrayList period = null;
        if (periodType == BgControlPeriodTypeEnum.MONTH.getIndex()) {
            if (calcPeriodType == BgControlPeriodTypeEnum.MONTH.getIndex()) {
                if (calcPeriodCycle == BgControlPeriodTypeEnum.MONTH.getIndex()) {
                    begin = cMonth;
                    end = cMonth;
                } else if (calcPeriodCycle == BgControlPeriodTypeEnum.QUARTER.getIndex()) {
                    begin = (cQuarter - 1) * 3 + 1;
                    end = hasActual ? cQuarter * 3 : cMonth;
                } else if (calcPeriodCycle == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
                    begin = (cHalfYear - 1) * 6 + 1;
                    end = hasActual ? cHalfYear * 6 : cMonth;
                } else if (calcPeriodCycle == BgControlPeriodTypeEnum.YEAR.getIndex()) {
                    begin = 1;
                    end = hasActual ? 12 : cMonth;
                }
            } else if (calcPeriodType == BgControlPeriodTypeEnum.QUARTER.getIndex()) {
                if (calcPeriodCycle == BgControlPeriodTypeEnum.QUARTER.getIndex()) {
                    begin = (cQuarter - 1) * 3 + 1;
                    end = cQuarter * 3;
                } else if (calcPeriodCycle == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
                    begin = (cHalfYear - 1) * 6 + 1;
                    end = hasActual ? cHalfYear * 6 : cQuarter * 3;
                } else if (calcPeriodCycle == BgControlPeriodTypeEnum.YEAR.getIndex()) {
                    begin = 1;
                    end = hasActual ? 12 : cQuarter * 3;
                }
            } else if (calcPeriodType == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
                if (calcPeriodCycle == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
                    begin = (cHalfYear - 1) * 6 + 1;
                    end = cHalfYear * 6;
                } else if (calcPeriodCycle == BgControlPeriodTypeEnum.YEAR.getIndex()) {
                    begin = 1;
                    end = hasActual ? 12 : cHalfYear * 6;
                }
            } else if (calcPeriodType == BgControlPeriodTypeEnum.YEAR.getIndex() && calcPeriodCycle == BgControlPeriodTypeEnum.YEAR.getIndex()) {
                begin = 1;
                end = 12;
            }
            if (isEb) {
                while (begin <= end) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(cYearStr);
                    period.add(BgPeriodUtils.getPeriodMonth((int)begin));
                    period.add(trueStr);
                    periodNums.add(period);
                    ++begin;
                }
            } else {
                while (begin <= end) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(cYearStr);
                    period.add(BgPeriodUtils.getBgPeriodMonth((int)cYear, (int)begin));
                    period.add(trueStr);
                    periodNums.add(period);
                    ++begin;
                }
            }
        } else if (periodType == BgControlPeriodTypeEnum.QUARTER.getIndex()) {
            if (calcPeriodType == BgControlPeriodTypeEnum.QUARTER.getIndex()) {
                if (calcPeriodCycle == BgControlPeriodTypeEnum.QUARTER.getIndex()) {
                    end = begin = cQuarter;
                } else if (calcPeriodCycle == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
                    begin = (cHalfYear - 1) * 2 + 1;
                    end = hasActual ? cHalfYear * 2 : cQuarter;
                } else if (calcPeriodCycle == BgControlPeriodTypeEnum.YEAR.getIndex()) {
                    begin = 1;
                    end = hasActual ? 4 : cQuarter;
                }
            } else if (calcPeriodType == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
                if (calcPeriodCycle == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
                    begin = (cHalfYear - 1) * 2 + 1;
                    end = cHalfYear * 2;
                } else if (calcPeriodCycle == BgControlPeriodTypeEnum.YEAR.getIndex()) {
                    begin = 1;
                    end = hasActual ? cHalfYear * 2 : 4;
                }
            } else if (calcPeriodType == BgControlPeriodTypeEnum.YEAR.getIndex() && calcPeriodCycle == BgControlPeriodTypeEnum.YEAR.getIndex()) {
                begin = 1;
                end = 4;
            }
            if (isEb) {
                while (begin <= end) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(cYearStr);
                    period.add(BgPeriodUtils.getPeriodQuarter((int)begin));
                    period.add(trueStr);
                    periodNums.add(period);
                    ++begin;
                }
            } else {
                while (begin <= end) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(cYearStr);
                    period.add(BgPeriodUtils.getBgPeriodQuarter((int)cYear, (int)begin));
                    period.add(trueStr);
                    periodNums.add(period);
                    ++begin;
                }
            }
        } else if (periodType == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
            if (calcPeriodType == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
                if (calcPeriodCycle == BgControlPeriodTypeEnum.HALFYEAR.getIndex()) {
                    begin = cHalfYear;
                    end = cHalfYear;
                } else if (calcPeriodCycle == BgControlPeriodTypeEnum.YEAR.getIndex()) {
                    begin = 1;
                    end = hasActual ? cHalfYear : 2;
                }
            } else if (calcPeriodType == BgControlPeriodTypeEnum.YEAR.getIndex() && calcPeriodCycle == BgControlPeriodTypeEnum.YEAR.getIndex()) {
                begin = 1;
                end = 2;
            }
            if (isEb) {
                while (begin <= end) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(cYearStr);
                    period.add(BgPeriodUtils.getPeriodHalfYear((int)begin));
                    period.add(trueStr);
                    periodNums.add(period);
                    ++begin;
                }
            } else {
                while (begin <= end) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(cYearStr);
                    period.add(BgPeriodUtils.getBgPeriodHalfYear((int)cYear, (int)begin));
                    period.add(trueStr);
                    periodNums.add(period);
                    ++begin;
                }
            }
        } else if (periodType == BgControlPeriodTypeEnum.YEAR.getIndex()) {
            period = Lists.newArrayListWithCapacity((int)3);
            period.add(cYearStr);
            period.add(cYearStr);
            period.add(trueStr);
            periodNums.add(period);
        }
        return periodNums;
    }

    private static List<List<String>> getGrossByYear(boolean isEb, Date bizTime, int periodType, int calcPeriodType, int calcPeriodCycle) {
        LinkedList<List<String>> periodNums;
        block6: {
            periodNums = new LinkedList<List<String>>();
            if (bizTime == null) {
                return periodNums;
            }
            CalendarHelper helper = new CalendarHelper(bizTime);
            int begin = 0;
            int end = 0;
            int cYear = helper.getCurrentlyYear();
            int cMonth = helper.getCurrentlyMonth();
            String yearStr = BgPeriodUtils.getPeriodYear((int)cYear);
            ArrayList period = null;
            if (periodType != BgControlPeriodTypeEnum.MONTH.getIndex() || calcPeriodType != BgControlPeriodTypeEnum.MONTH.getIndex()) break block6;
            if (calcPeriodCycle == 0) {
                begin = 1;
                end = cMonth;
            }
            if (isEb) {
                while (begin <= end) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(yearStr);
                    period.add(BgPeriodUtils.getPeriodMonth((int)begin));
                    period.add(Boolean.TRUE.toString());
                    periodNums.add(period);
                    ++begin;
                }
            } else {
                while (begin <= end) {
                    period = Lists.newArrayListWithCapacity((int)3);
                    period.add(yearStr);
                    period.add(BgPeriodUtils.getBgPeriodMonth((int)cYear, (int)begin));
                    period.add(Boolean.TRUE.toString());
                    periodNums.add(period);
                    ++begin;
                }
            }
        }
        return periodNums;
    }

    public static String getYear(String periodNumber) {
        if (periodNumber == null) {
            return null;
        }
        String[] tmpStr = periodNumber.split("\\.");
        if (tmpStr != null && tmpStr.length > 0) {
            return tmpStr[0];
        }
        return null;
    }

    public static Date[] getPeriodOnMonth() {
        Date firstDate;
        Date lastDate;
        Date[] date = new Date[2];
        LocalDateTime now = LocalDateTime.now();
        LocalDate lastMonthData = now.with(TemporalAdjusters.lastDayOfMonth()).toLocalDate();
        LocalDateTime of = LocalDateTime.of(lastMonthData, LocalTime.MAX);
        LocalDateTime localDateTime2 = of.minusNanos(of.getNano());
        date[1] = lastDate = Date.from(localDateTime2.atZone(ZoneId.systemDefault()).toInstant());
        LocalDate firstMonthData = now.with(TemporalAdjusters.firstDayOfMonth()).toLocalDate();
        LocalDateTime of1 = LocalDateTime.of(firstMonthData, LocalTime.MIN);
        date[0] = firstDate = Date.from(of1.atZone(ZoneId.systemDefault()).toInstant());
        return date;
    }

    public static Date parseBizTime(IControlParam controlParam) {
        int i;
        String yearNum = null;
        String periodNum = null;
        if (controlParam.getBizModel().isEBByModel()) {
            yearNum = controlParam.getMember(false, SysDimensionEnum.Year.getNumber()).getNumber();
            periodNum = controlParam.getMember(false, SysDimensionEnum.Period.getNumber()).getNumber();
        } else {
            String budgetPeriod = controlParam.getMember(false, SysDimensionEnum.BudgetPeriod.getNumber()).getNumber();
            String[] arr = budgetPeriod.split("\\.");
            yearNum = arr[0];
            periodNum = "";
            if (arr.length > 1) {
                periodNum = arr[1];
            }
        }
        if (StringUtils.isEmpty((String)yearNum) || StringUtils.isEmpty((String)periodNum)) {
            return new Date();
        }
        if (controlParam.getBizModel().getPeriodUtils().isPeriodUserDefine()) {
            String pnumber = controlParam.getFullPeriodNumber(true);
            if (pnumber == null) {
                pnumber = controlParam.getFullPeriodNumber(false);
            }
            return controlParam.getBizModel().getPeriodUtils().parseBizTime(pnumber);
        }
        String _year = "";
        String _month = "";
        StringBuilder str = new StringBuilder();
        int in = yearNum.length();
        for (i = 0; i < in; ++i) {
            char _char = yearNum.charAt(i);
            if (!Character.isDigit(_char)) continue;
            str.append(_char);
        }
        _year = str.toString();
        str.setLength(0);
        in = periodNum.length();
        for (i = 0; i < in; ++i) {
            char _char = periodNum.charAt(i);
            if (!Character.isDigit(_char)) continue;
            str.append(_char);
        }
        _month = str.toString();
        if (periodNum.startsWith("M_Q") || periodNum.startsWith("Q_Q")) {
            if ("1".equals(_month)) {
                _month = "3";
            } else if ("2".equals(_month)) {
                _month = "6";
            } else if ("3".equals(_month)) {
                _month = "9";
            } else if ("4".equals(_month)) {
                _month = "12";
            }
        } else if (periodNum.startsWith("M_HF") || periodNum.startsWith("Q_HF") || periodNum.startsWith("HF_")) {
            if ("1".equals(_month)) {
                _month = "6";
            } else if ("2".equals(_month)) {
                _month = "12";
            }
        } else if (periodNum.endsWith("_YearTotal")) {
            _month = "12";
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, Integer.parseInt(_year));
        calendar.set(2, Integer.parseInt(_month) - 1);
        calendar.set(5, 1);
        return calendar.getTime();
    }
}

