/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.epm.eb.common.model.BizOrgUnit;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.OrgUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.eums.ControlLogTypeEnum;
import kd.epm.eb.control.face.IBatchControlParameter;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlOrgUtils;

public class BgRegisterUtils {
    private static final Log log = LogFactory.getLog(BgRegisterUtils.class);
    public static final int PROP_BIZORGUNIT_FIELD = 0;
    public static final int PROP_BIZTIME_FILE = 1;
    public static final int ISMAPPING = 2;
    public static final int MULTICONTROL = 3;
    public static final int PROP_BIZORGUNIT_NAME = 4;
    public static final int PROP_BIZTIME_NAME = 5;
    public static final int PROP_IS_RETURN_CHECK = 6;
    public static final int PROP_CAN_OCCUPATION_AGAIN = 7;
    public static final int PROP_OCC_BY_ENTRY = 8;
    public static final String FIELDS = "id, fieldalias, type, typename";

    public static String[] queryRegisterBizUnit(String entityNumber) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("fieldtable", "=", (Object)entityNumber));
        String[] defaults = new String[9];
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryRegisterBizUnit", (String)"eb_bgcontroldefault", (String)"orgfield.fieldalias, periodfield.fieldalias,ismapping, ismulticontrol,isreturncheck,occupationagain,occbyentry", (QFilter[])builder.toArrays(), null, (int)1);){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                defaults[0] = row.getString("orgfield.fieldalias");
                defaults[1] = row.getString("periodfield.fieldalias");
                defaults[2] = row.getString("ismapping");
                defaults[3] = String.valueOf(row.getBoolean("ismulticontrol"));
                try {
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    defaults[4] = BgRegisterUtils.getFieldName(entityType, defaults[0]);
                    defaults[5] = BgRegisterUtils.getFieldName(entityType, defaults[1]);
                    defaults[6] = row.getString("isreturncheck");
                    defaults[7] = row.getString("occupationagain");
                    defaults[8] = row.getString("occbyentry");
                }
                catch (Throwable e) {
                    log.info("budget-control-log : no find entityNumber - " + entityNumber);
                }
            } else {
                log.info("budget-control-log : no find default Register - " + entityNumber);
            }
        }
        return defaults;
    }

    public static String getFieldName(MainEntityType entityType, String field) {
        StringBuilder names = new StringBuilder();
        BgRegisterUtils.getField(entityType, field, names);
        return names.toString();
    }

    public static IDataEntityProperty getField(MainEntityType entityType, String field, StringBuilder names) {
        return BgRegisterUtils.getField(entityType, field, names, null);
    }

    public static IDataEntityProperty getField(MainEntityType entityType, String field, StringBuilder names, String locale) {
        if (entityType == null || StringUtils.isEmpty((String)field)) {
            return null;
        }
        if (names == null) {
            names = new StringBuilder();
        }
        IDataEntityProperty dp = null;
        String[] props = field.split("\\.");
        MainEntityType de = entityType;
        for (String prop : props) {
            if (de == null) {
                names.setLength(0);
                return null;
            }
            dp = (IDataEntityProperty)de.getProperties().get((Object)prop);
            if (dp != null) {
                if (names.length() > 0) {
                    names.append(".");
                }
                if (locale == null) {
                    names.append(dp.getDisplayName() == null || dp.getDisplayName().getLocaleValue() == null ? dp.getName() : dp.getDisplayName().getLocaleValue());
                } else {
                    names.append(dp.getDisplayName() == null || dp.getDisplayName().getItem(locale) == null ? dp.getName() : (String)dp.getDisplayName().getItem(locale));
                }
            } else {
                names.setLength(0);
                return null;
            }
            if (dp instanceof ICollectionProperty) {
                de = ((ICollectionProperty)dp).getItemType();
                continue;
            }
            if (!(dp instanceof IComplexProperty)) continue;
            de = ((IComplexProperty)dp).getComplexType();
        }
        return dp;
    }

    public static boolean isMultiControl(String[] props) {
        if (props == null || props.length <= 3) {
            return false;
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(props[3]);
    }

    public static boolean isOccAgain(String[] props) {
        return props != null && props.length > 7 && "true".equals(props[7]);
    }

    public static boolean isDeductByEntry(String[] props) {
        return props != null && props.length > 8 && "true".equals(props[8]);
    }

    public static void loadDefaultSetting(Map<String, String[]> params, String entityNumber) {
        if (entityNumber == null) {
            ControlException.bostTypeMustInput((String)entityNumber);
        }
        if (entityNumber != null && !params.containsKey(entityNumber)) {
            String[] props = BgRegisterUtils.queryRegisterBizUnit(entityNumber);
            if (props == null || props[0] == null) {
                ControlException.bostTypeMustInput((String)entityNumber);
            }
            params.put(entityNumber, props);
        }
    }

    public static Map<String, Object[]> getBizUnitBatch(IBatchControlParameter parameter, String[] props) {
        if (parameter == null || parameter.getBizIds() == null || parameter.getBizIds().isEmpty()) {
            return new HashMap<String, Object[]>(1);
        }
        HashMap<String, Object[]> result = new HashMap<String, Object[]>(parameter.getBizIds().size());
        String fields = props[0] + ", " + props[1];
        HashSet<Long> billIds = new HashSet<Long>(parameter.getBizIds().size());
        try {
            for (String id : parameter.getBizIds()) {
                billIds.add(Long.parseLong(id));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (billIds.isEmpty()) {
            return result;
        }
        QFilter filter = new QFilter("id", "in", billIds);
        Map bills = BusinessDataServiceHelper.loadFromCache((String)parameter.getEntityNumber(), (String)fields, (QFilter[])filter.toArray());
        if (bills == null || bills.isEmpty()) {
            return result;
        }
        HashSet<Object> bizOrgIds = new HashSet<Object>(bills.size());
        for (DynamicObject _bizObj : bills.values()) {
            if (_bizObj == null) continue;
            Object[] objProps = new Object[2];
            result.put(String.valueOf(_bizObj.getPkValue()), objProps);
            Object obj = _bizObj.get(props[0]);
            if (!(obj instanceof DynamicObject)) {
                log.info("org-field-no-instanceof-DynamicObject");
                continue;
            }
            DynamicObject _bizOrg = (DynamicObject)obj;
            bizOrgIds.add(_bizOrg.getPkValue());
            objProps[0] = _bizOrg.getPkValue();
            objProps[1] = _bizObj.get(props[1]);
            if (objProps[1] instanceof Timestamp) {
                objProps[1] = new Date(((Timestamp)objProps[1]).getTime());
                continue;
            }
            if (!(objProps[1] instanceof Long)) continue;
            objProps[1] = new Date((Long)objProps[1]);
        }
        HashMap<Object, BizOrgUnit> bizUnitMap = new HashMap<Object, BizOrgUnit>(bills.size());
        if (!bizOrgIds.isEmpty()) {
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("org", "in", bizOrgIds));
            builder.add(new QFilter("view", "=", (Object)BgControlOrgUtils.getOrgUnitType()));
            Map orgInfos = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"id, org.id, org.number, org.name, longnumber, isleaf, parent", (QFilter[])builder.toArray());
            if (orgInfos != null) {
                for (DynamicObject struct : orgInfos.values()) {
                    bizUnitMap.put(struct.getDynamicObject("org").getPkValue(), new BizOrgUnit("bos_org_structure", struct));
                }
            }
        }
        for (Object[] objProps : result.values()) {
            if (objProps == null || objProps[0] == null) continue;
            objProps[0] = bizUnitMap.get(objProps[0]);
        }
        return result;
    }

    public static Object[] getBizUnit(LogStats stats, IControlParameter parameter, String[] props) {
        return BgRegisterUtils.innerGetBizUnit(parameter, props);
    }

    public static Object[] innerGetBizUnit(IControlParameter parameter, String[] props) {
        if (parameter == null) {
            ControlException.errorControlParameter();
            return null;
        }
        BgRegisterUtils.checkHasDefaultSet(parameter, props, null);
        DynamicObject _bizObj = null;
        Map<String, Object> _bizObjMap = null;
        Object[] objProps = new Object[3];
        if (parameter.getBizObj() != null) {
            _bizObj = parameter.getBizObj();
        } else if (parameter.getBizObjMaps() != null && !parameter.getBizObjMaps().isEmpty()) {
            _bizObjMap = parameter.getBizObjMaps().get(0);
        } else if (StringUtils.isNotEmpty((String)parameter.getBizId())) {
            String fields = props[0] + ", " + props[1];
            QFilter[] filters = new QFilter[]{parameter.getControlManager().isStandard() ? new QFilter("id", "=", (Object)Long.parseLong(parameter.getBizId())) : new QFilter("id", "=", (Object)parameter.getBizId())};
            _bizObj = BusinessDataServiceHelper.loadSingleFromCache((String)parameter.getEntityNumber(), (String)fields, (QFilter[])filters);
        } else {
            ControlException.errorControlParameter();
            return null;
        }
        if (_bizObj != null) {
            Object obj = _bizObj.get(props[0]);
            if (!(obj instanceof DynamicObject)) {
                if (obj instanceof DynamicObjectCollection) {
                    ControlException.errorDefaultBizOrgUnitProp();
                } else if (obj != null) {
                    ControlException.errorOrg((String)null);
                }
            }
            if (obj instanceof DynamicObject) {
                DynamicObject _bizOrg = (DynamicObject)obj;
                QFBuilder builder = new QFBuilder();
                builder.add(new QFilter("org", "=", _bizOrg.getPkValue()));
                builder.add(new QFilter("view", "=", (Object)BgControlOrgUtils.getOrgUnitType()));
                DynamicObject struct = OrgUtils.getOrgUnit((String)"bos_org_structure", (QFBuilder)builder);
                if (struct == null) {
                    ControlException.errorOrg((DynamicObject)_bizOrg);
                }
                objProps[0] = new BizOrgUnit("bos_org_structure", struct);
            }
            objProps[1] = _bizObj.get(props[1]);
            if (objProps[1] instanceof Timestamp) {
                objProps[1] = new Date(((Timestamp)objProps[1]).getTime());
            } else if (objProps[1] instanceof Long) {
                objProps[1] = new Date((Long)objProps[1]);
            }
        } else if (_bizObjMap != null) {
            String orgNumber = (String)_bizObjMap.get(props[0] + ".number");
            if (StringUtils.isEmpty((String)orgNumber)) {
                ControlException.notDefaultBizOrgUnitProp();
            }
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("org.number", "=", (Object)orgNumber));
            builder.add(new QFilter("view", "=", (Object)BgControlOrgUtils.getOrgUnitType()));
            DynamicObject struct = null;
            if (props[2] != null && props[2].equals("true")) {
                QFilter[] filters;
                DynamicObject _bizOrg;
                String id = BgRegisterUtils.OrgMappingEas(orgNumber);
                if (id == null) {
                    ControlException.errorMappingId();
                }
                if ((_bizOrg = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,number,name", (QFilter[])(filters = new QFilter[]{new QFilter("id", "=", (Object)id)}))) != null) {
                    QFBuilder builder1 = new QFBuilder();
                    builder1.add(new QFilter("org", "=", _bizOrg.get("id")));
                    builder1.add(new QFilter("view", "=", (Object)15));
                    struct = OrgUtils.getOrgUnit((String)"bos_org_structure", (QFBuilder)builder1);
                    if (struct == null) {
                        Map costCompanyAccountOrg = OrgUnitServiceHelper.getCompanyByAdminOrg((Long)_bizOrg.getLong("id"), (Boolean)false);
                        QFBuilder builder2 = new QFBuilder();
                        builder2.add(new QFilter("org", "=", costCompanyAccountOrg.get("id")));
                        builder2.add(new QFilter("view", "=", (Object)15));
                        struct = OrgUtils.getOrgUnit((String)"bos_org_structure", (QFBuilder)builder2);
                        if (struct == null) {
                            ControlException.errorOrgNumberAndName((String)((String)costCompanyAccountOrg.get("name")), (String)((String)costCompanyAccountOrg.get("number")));
                        }
                    }
                    objProps[0] = new BizOrgUnit("bos_org_structure", struct);
                } else {
                    ControlException.errorMappingId();
                }
            } else {
                struct = OrgUtils.getOrgUnit((String)"bos_org_structure", (QFBuilder)builder);
                if (struct == null) {
                    ControlException.errorOrg((String)orgNumber);
                }
                objProps[0] = new BizOrgUnit("bos_org_structure", struct);
            }
            objProps[1] = _bizObjMap.get(props[1]);
            if (objProps[1] instanceof Timestamp) {
                objProps[1] = new Date(((Timestamp)objProps[1]).getTime());
            } else if (objProps[1] instanceof String) {
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    objProps[1] = format.parse((String)objProps[1]);
                }
                catch (Exception ex) {
                    ControlException.errorBizTimeProp();
                }
            } else if (objProps[1] instanceof Long) {
                objProps[1] = new Date((Long)objProps[1]);
            }
        } else {
            ControlException.errorDynamicObject();
        }
        if (objProps[1] instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)objProps[1]);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            objProps[1] = calendar.getTime();
        } else if (objProps[1] != null) {
            ControlException.errorBizTimeProp();
        } else {
            ControlException.notDefaultBizTimeProp();
        }
        return objProps;
    }

    public static void checkHasDefaultSet(IControlParameter parameter, String[] props, LogStats stats) {
        if (props == null || StringUtils.isEmpty((String)props[0]) || StringUtils.isEmpty((String)props[1])) {
            if (LogStats.isNeedDetailLog((LogStats)stats)) {
                if (props == null || StringUtils.isEmpty((String)props[0])) {
                    BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.REGISTBILLDEFAULTORG, 2, null, null, null, false);
                }
                if (props == null || StringUtils.isEmpty((String)props[1])) {
                    BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.REGISTBILLDEFAULTPERIOD, 2, null, null, null, false);
                }
            }
            ControlException.notDefaultBizProp((String)parameter.getEntityNumber());
        }
    }

    public static void checkDefaultProps(LogStats stats, Object[] objProps, String[] props) {
        if (objProps == null || objProps.length <= 0 || objProps[0] == null) {
            if (LogStats.isNeedDetailLog((LogStats)stats)) {
                String fieldNumber = props[0];
                String fieldName = props.length > 4 ? props[4] : "";
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.REGISTBILLDEFAULTORG, 2, null, ResManager.loadResFormat((String)"\u7ec4\u7ec7\u5339\u914d\u5b57\u6bb5\u4e3a\u7a7a\uff1a%1 %2", (String)"ControlLog_DefaultOrgNull", (String)"epm-eb-business", (Object[])new Object[]{fieldNumber, fieldName}), null, false);
            }
            ControlException.notDefaultBizOrgUnitProp();
            return;
        }
        if (objProps == null || objProps.length <= 1 || objProps[1] == null) {
            if (LogStats.isNeedDetailLog((LogStats)stats)) {
                String fieldNumber = props[1];
                String fieldName = props.length > 4 ? props[5] : "";
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.REGISTBILLDEFAULTPERIOD, 2, null, ResManager.loadResFormat((String)"\u8d22\u5e74\u671f\u95f4\u5339\u914d\u5b57\u6bb5\u4e3a\u7a7a\uff1a%1 %2", (String)"ControlLog_DefaultPeriodNull", (String)"epm-eb-business", (Object[])new Object[]{fieldNumber, fieldName}), null, false);
            }
            ControlException.notDefaultBizTimeProp();
            return;
        }
        if (!(objProps[1] instanceof Date)) {
            if (LogStats.isNeedDetailLog((LogStats)stats)) {
                String fieldNumber = props[1];
                String fieldName = props.length > 4 ? props[5] : "";
                BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.REGISTBILLDEFAULTPERIOD, 2, null, ResManager.loadResFormat((String)"\u8d22\u5e74\u671f\u95f4\u5339\u914d\u5b57\u6bb5\u503c\u975e\u65e5\u671f\u7c7b\u578b\uff1a%1 %2", (String)"ControlLog_DefaultPeriodError", (String)"epm-eb-business", (Object[])new Object[]{fieldNumber, fieldName}), null, false);
            }
            ControlException.errorBizTimeProp();
            return;
        }
        if (LogStats.isNeedDetailLog((LogStats)stats)) {
            String fieldNumber = props[0];
            String fieldName = props.length > 4 ? props[4] : "";
            String orgName = "";
            String orgNumber = "";
            if (objProps[0] instanceof BizOrgUnit) {
                BizOrgUnit org = (BizOrgUnit)objProps[0];
                orgNumber = org.getNumber();
                orgName = org.getName();
            } else if (objProps[0] instanceof DynamicObject) {
                DynamicObject org = (DynamicObject)objProps[0];
                orgNumber = org.getString("number");
                orgName = org.getString("name");
            }
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.REGISTBILLDEFAULTORG, 0, null, ResManager.loadResFormat((String)"\u7ec4\u7ec7\u5339\u914d\u5b57\u6bb5\uff1a%1 %2 - %3 %4\u3002", (String)"ControlLog_DefaultOrg", (String)"epm-eb-business", (Object[])new Object[]{fieldNumber, fieldName, orgNumber, orgName}), null, false);
            fieldNumber = props[1];
            fieldName = props.length > 4 ? props[5] : "";
            BgControlLogUtils.addDetail(stats, ControlLogTypeEnum.REGISTBILLDEFAULTPERIOD, 0, null, ResManager.loadResFormat((String)"\u8d22\u5e74\u671f\u95f4\u5339\u914d\u5b57\u6bb5\uff1a%1 %2 - %3", (String)"ControlLog_DefaultPeriod", (String)"epm-eb-business", (Object[])new Object[]{fieldNumber, fieldName, new SimpleDateFormat("yyyy-MM-dd").format(objProps[1])}), null, false);
        }
    }

    public static String OrgMappingEas(String orgNumber) {
        String dataid = null;
        Object dataTypeid = null;
        QFBuilder dtBuilder = new QFBuilder();
        dtBuilder.add(new QFilter("number", "=", (Object)"bos_org"));
        try (DataSet ds2 = QueryServiceHelper.queryDataSet((String)"queryRegisterBizUnit", (String)"bas_datatype", (String)"id", (QFilter[])dtBuilder.toArrays(), null, (int)1);){
            if (ds2 != null && ds2.hasNext()) {
                Row row = ds2.next();
                dataTypeid = row.getString("id");
            }
        }
        try {
            dataTypeid = Long.parseLong((String)dataTypeid);
        }
        catch (Throwable ds2) {
            // empty catch block
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("extnumber", "=", (Object)orgNumber));
        builder.add(new QFilter("datatype", "=", dataTypeid));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryRegisterBizUnit", (String)"bas_datamapping", (String)"dataid", (QFilter[])builder.toArrays(), null, (int)1);){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                dataid = row.getString("dataid");
            }
        }
        return dataid;
    }
}

