/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.utils.BgControlUtils;

public class BizUnitUtils {
    private static final Log log = LogFactory.getLog(BizUnitUtils.class);
    private IControlParameter parameter;

    public BizUnitUtils(IControlParameter parameter) {
        this.parameter = parameter;
    }

    protected IControlParameter getParameter() {
        return this.parameter;
    }

    protected void setParameter(IControlParameter parameter) {
        this.parameter = parameter;
    }

    public Collection<BizModel> queryModel(Date bizTime) {
        return this.queryModel(bizTime, false);
    }

    public Collection<BizModel> queryModel(Date bizTime, boolean isCheckControlVersion) {
        if (this.getParameter() == null || bizTime == null) {
            return null;
        }
        Collection models = CacheServiceHelper.queryCacheByScenVer((Date)bizTime);
        if (models == null || models.isEmpty()) {
            ControlException.notControlVersion();
            return null;
        }
        BgControlUtils.queryControlDimension(models);
        BgControlUtils.checkBusinessModel(models);
        for (BizModel bizModel : models) {
            if (bizModel == null || bizModel.getId() == null) {
                ControlException.erorrOther((String)ResManager.loadKDString((String)"\u9884\u7b97\u4f53\u7cfbID\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizUnitUtils_0", (String)"epm-eb-business", (Object[])new Object[0]));
                return null;
            }
            this.getParameter().getDataManager().getScenVersion().put(BgControlUtils.getSVKey(bizModel), bizModel.getStartVersion());
        }
        return models;
    }

    public Collection<BizModel> filterModel(Collection<BizModel> bizModels, BgControlData controlData) {
        if (bizModels == null || bizModels.isEmpty() || controlData == null || controlData.getBizOrgUnit() == null) {
            return bizModels;
        }
        BizModel bizModel = (BizModel)bizModels.toArray()[0];
        if (bizModels.size() == 1 && bizModel.isEBByModel() && bizModel.getControlManagerId() == 0L) {
            return bizModels;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct fcontrolversionid from t_eb_controlversionorg where ", new Object[0]);
        sql.appendIn("fcontrolversionid", bizModels.stream().map(BizModel::getControlManagerId).collect(Collectors.toList()));
        sql.append(" and ", new Object[0]);
        Set<Long> parentIds = controlData.getParentIds();
        if (parentIds != null && !parentIds.isEmpty()) {
            sql.appendIn("forgrange", new ArrayList<Long>(parentIds));
        } else {
            sql.append("forgrange = ?", new Object[]{controlData.getBizOrgUnit().getOrgId()});
        }
        HashSet ctrlManagerIds = Sets.newHashSetWithExpectedSize((int)bizModels.size());
        DataSet ds = DB.queryDataSet((String)"queryControlOrgRange", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        Object object = null;
        try {
            if (ds != null) {
                for (Row row : ds) {
                    ctrlManagerIds.add(row.getLong("fcontrolversionid"));
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ArrayList filters = Lists.newArrayListWithCapacity((int)bizModels.size());
        for (BizModel model : bizModels) {
            if (ctrlManagerIds.contains(model.getControlManagerId())) {
                filters.add(model);
                continue;
            }
            log.info("budget-control-log : filter-model:" + model.getNumber());
        }
        return filters;
    }

    public String getBizItemType(String entityNumber) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            return null;
        }
        String bizItemType = null;
        if (entityNumber.startsWith("er_")) {
            bizItemType = "er_expenseitemedit";
        }
        return bizItemType;
    }

    public String getBillNumberField(String entityNumber) {
        String field = "billno";
        if (entityNumber == null) {
            return field;
        }
        if (entityNumber.startsWith("er_")) {
            field = "billno";
        }
        return field;
    }

    public Map<Object, DynamicObject> queryBizItem(String entityNumber, Set<Long> ids) {
        HashMap<Object, DynamicObject> objectMap = new HashMap<Object, DynamicObject>();
        if (StringUtils.isEmpty((String)entityNumber) || ids == null || ids.isEmpty()) {
            return objectMap;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "in", ids));
        return BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)"id, name, number, longnumber", (QFilter[])builder.toArrays());
    }
}

