/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.adjust.AdjustCheckBalancePojo;
import kd.epm.eb.common.dao.adjust.CompareDataPojo;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.BgDataUtils;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.impl.model.BgControlSetting;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class BudgetAdjustCheckUtils {
    private static final Log log = LogFactory.getLog(BudgetAdjustCheckUtils.class);
    public static final String ADJUST_VALUE = "adjustValue";
    public static final String SUBMIT_VALUE = "submitValue";
    public static final String ADJUST_CHECK_BALANCE_KEY = "adjustcheckbalance";
    public static final String ADJUST_CHECK_BAR = "adjustcheck";
    public static final String SUBMIT_BAR = "submit";

    public static Map<String, BigDecimal> getAdjustValueMap(List<CompareDataPojo> finalDataByPeriodAndOrg, String valueType, String formType) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(finalDataByPeriodAndOrg.size());
        if (CollectionUtils.isEmpty(finalDataByPeriodAndOrg)) {
            return map;
        }
        BudgetAdjustCheckUtils.getAdjustCheckValueMapByCustomDim(finalDataByPeriodAndOrg, valueType, map, false, formType);
        Long model = finalDataByPeriodAndOrg.get(0).getModel();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)model);
        if (!modelCacheHelper.getModelobj().isModelByEB()) {
            List dimensionByModel = BgDimensionServiceHelper.getDimensionByModel((Long)model);
            BizModel bizModel = ModelUtils.getBizModel((Long)model);
            Long businessModelId = finalDataByPeriodAndOrg.get(0).getBizmodel();
            bizModel.setControlBusModelId(businessModelId);
            BgControlUtils.queryControlDimension(bizModel);
            Set controlDims = bizModel.getControlDims();
            if (CollectionUtils.isNotEmpty((Collection)controlDims)) {
                dimensionByModel = bizModel.filterControlDims(dimensionByModel);
                List<String> controlDimensionNumbers = dimensionByModel.stream().map(kd.epm.eb.common.model.Dimension::getNumber).collect(Collectors.toList());
                List controlDimNumbersByCache = modelCacheHelper.getDimensionList(controlDimensionNumbers.toArray(new String[0])).stream().filter(e -> {
                    boolean isPreset = !e.isPreset();
                    return isPreset;
                }).map(BaseCache::getNumber).collect(Collectors.toList());
                for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
                    String accountNumber = compareDataPojo.getAccountNumber();
                    kd.epm.eb.common.cache.impl.Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, accountNumber);
                    Long datasetId = accountMember.getDatasetId();
                    List dimensionList = modelCacheHelper.getDimensionList(datasetId);
                    List dimensionNumbers = dimensionList.stream().filter(e -> {
                        boolean isPreset = !e.isPreset();
                        return isPreset;
                    }).map(BaseCache::getNumber).collect(Collectors.toList());
                    boolean hasControlDim = false;
                    for (String dimensionNumber : dimensionNumbers) {
                        if (!controlDimNumbersByCache.contains(dimensionNumber)) continue;
                        hasControlDim = true;
                        break;
                    }
                    if (hasControlDim) continue;
                    dimensionNumbers.removeAll(controlDimNumbersByCache);
                    if (dimensionNumbers.size() <= 0) continue;
                    compareDataPojo.setAdjustTotalFlag(Boolean.valueOf(false));
                }
            }
        }
        BudgetAdjustCheckUtils.handleUserDefinedMemberParentsAggoprt(finalDataByPeriodAndOrg, modelCacheHelper);
        List<CompareDataPojo> finalDataByPeriodAndOrgAndCustomDim = BudgetAdjustCheckUtils.depCopy(finalDataByPeriodAndOrg);
        if (CollectionUtils.isNotEmpty(finalDataByPeriodAndOrgAndCustomDim)) {
            for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrgAndCustomDim) {
                Map customDimMemberMap = compareDataPojo.getCustomdimMemberMap();
                if (customDimMemberMap == null || customDimMemberMap.size() <= 0) continue;
                HashMap<String, String> customDimRootMemberMap = new HashMap<String, String>(customDimMemberMap.size());
                if (customDimMemberMap != null && customDimMemberMap.size() > 0) {
                    for (Map.Entry entry : customDimMemberMap.entrySet()) {
                        String key = (String)entry.getKey();
                        customDimRootMemberMap.put(key, key);
                    }
                }
                compareDataPojo.setCustomdimMemberMap(customDimRootMemberMap);
            }
            Map<String, List<CompareDataPojo>> compareDataListCustomDimRootMap = BudgetAdjustCheckUtils.getSameKeyCompareDataPojoListMap(finalDataByPeriodAndOrgAndCustomDim, valueType, formType, true, true);
            if (compareDataListCustomDimRootMap != null && compareDataListCustomDimRootMap.size() > 0) {
                for (Map.Entry<String, List<CompareDataPojo>> entry : compareDataListCustomDimRootMap.entrySet()) {
                    String key = entry.getKey();
                    List<CompareDataPojo> value = entry.getValue();
                    BigDecimal totalValue = BigDecimal.ZERO;
                    for (CompareDataPojo compareDataPojo : value) {
                        BigDecimal currentValue;
                        if (!compareDataPojo.getAdjustTotalFlag().booleanValue()) continue;
                        if (ADJUST_VALUE.equals(valueType)) {
                            currentValue = compareDataPojo.getAdjustdata() != null ? compareDataPojo.getAdjustdata() : BigDecimal.ZERO;
                            totalValue = totalValue.add(currentValue);
                            continue;
                        }
                        if (!SUBMIT_VALUE.equals(valueType)) continue;
                        currentValue = compareDataPojo.getSubmitValue() != null ? compareDataPojo.getSubmitValue() : BigDecimal.ZERO;
                        totalValue = totalValue.add(currentValue);
                    }
                    map.put(key, totalValue);
                }
            }
        }
        return map;
    }

    private static void handleUserDefinedMemberParentsAggoprt(List<CompareDataPojo> finalDataByPeriodAndOrg, IModelCacheHelper modelCacheHelper) {
        if (CollectionUtils.isEmpty(finalDataByPeriodAndOrg)) {
            return;
        }
        Long businessModelId = finalDataByPeriodAndOrg.get(0).getBizmodel();
        Map views = new HashMap(16);
        if (IDUtils.isNotEmptyLong((Long)businessModelId).booleanValue()) {
            views = modelCacheHelper.getViewsByBusModel(businessModelId);
        }
        block0: for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
            Map customDimMemberMap = compareDataPojo.getCustomdimMemberMap();
            if (customDimMemberMap == null || customDimMemberMap.size() <= 0) continue;
            for (Map.Entry entry : customDimMemberMap.entrySet()) {
                kd.epm.eb.common.cache.impl.Member member;
                String dimNumber = (String)entry.getKey();
                String memberNumber = (String)entry.getValue();
                Long viewId = views.get(dimNumber) == null ? Long.valueOf(0L) : (Long)views.get(dimNumber);
                List parents = modelCacheHelper.getParents(viewId, member = modelCacheHelper.getMember(dimNumber, viewId, memberNumber), true);
                boolean hasSkip = parents.stream().anyMatch(e -> AggOprtEnum.SKIP.getSign().equals(e.getAggType()));
                if (!hasSkip) continue;
                compareDataPojo.setAdjustTotalFlag(Boolean.valueOf(false));
                continue block0;
            }
        }
    }

    public static <T> List<T> depCopy(List<T> srcList) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);
            outputStream.writeObject(srcList);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            List desList = (List)objectInputStream.readObject();
            return desList;
        }
        catch (Exception e) {
            log.info("adjust check balance list deep copy error: " + e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u5217\u8868\u6df1\u62f7\u8d1d\u5931\u8d25", (String)"BudgetAdjustCheckUtils_6", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    private static Map<String, List<CompareDataPojo>> getSameKeyCompareDataPojoListMap(List<CompareDataPojo> finalDataByPeriodAndOrg, String valueType, String formType, boolean customTotalFlag, boolean billNumberFlag) {
        HashMap<String, List<CompareDataPojo>> compareDataListCustomDimRootMap = new HashMap<String, List<CompareDataPojo>>(finalDataByPeriodAndOrg.size());
        Long modelId = finalDataByPeriodAndOrg.get(0).getModel();
        if (modelId == null || modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u51cf\u6821\u9a8c\u83b7\u53d6\u4e0d\u5230\u4f53\u7cfbid", (String)"BudgetAdjustCheckUtils_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Long busModeId = 0L;
        ArrayList<Dimension> dimensionList = new ArrayList(16);
        boolean modelByEB = modelCacheHelper.getModelobj().isModelByEB();
        if (modelByEB) {
            dimensionList = modelCacheHelper.getDimensionList();
        } else {
            busModeId = finalDataByPeriodAndOrg.get(0).getBizmodel();
            dimensionList = modelCacheHelper.getDimensionListByBusModel(busModeId);
        }
        String dataTypeNumber = finalDataByPeriodAndOrg.get(0).getDatatypeNumber();
        for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
            StringBuilder dataKey = BudgetAdjustCheckUtils.getCompareDataKey(valueType, formType, modelId, dimensionList, modelByEB, dataTypeNumber, compareDataPojo, customTotalFlag, billNumberFlag);
            String customKey = dataKey.toString();
            List customRootCompareDataPojoList = compareDataListCustomDimRootMap.computeIfAbsent(customKey, v -> new ArrayList(finalDataByPeriodAndOrg.size()));
            customRootCompareDataPojoList.add(compareDataPojo);
        }
        return compareDataListCustomDimRootMap;
    }

    @NotNull
    private static StringBuilder getCompareDataKey(String valueType, String formType, Long modelId, List<Dimension> dimensionList, boolean modelByEB, String dataTypeNumber, CompareDataPojo compareDataPojo, boolean customTotalFlag, boolean billNumberFlag) {
        StringBuilder dataKey = new StringBuilder();
        dataKey.append(modelId).append("!");
        Set ignDimNumbers = BgDataUtils.getIgnDimNumbers();
        for (Dimension dimension : dimensionList) {
            String memberNumber;
            if (ignDimNumbers != null && ignDimNumbers.contains(dimension.getNumber()) || !StringUtils.isNotEmpty((String)(memberNumber = BudgetAdjustCheckUtils.getMemberNumberByCompareData(dimension, compareDataPojo, modelId, dataTypeNumber, customTotalFlag, valueType, formType)))) continue;
            dataKey.append(dimension.getNumber()).append("_").append(memberNumber).append("!");
        }
        if (modelByEB) {
            dataKey.append(SysDimensionEnum.Period.getNumber()).append("_").append(compareDataPojo.getYearNumber()).append("_").append(compareDataPojo.getPreiod()).append("!");
        } else {
            dataKey.append(SysDimensionEnum.BudgetPeriod.getNumber()).append("_").append(compareDataPojo.getPreiod()).append("!");
        }
        if (billNumberFlag) {
            dataKey.append("billnumber").append("_").append(compareDataPojo.getBillNumber());
        }
        return dataKey;
    }

    private static void getAdjustCheckValueMapByCustomDim(List<CompareDataPojo> finalDataByPeriodAndOrg, String valueType, Map<String, BigDecimal> map, boolean customTotalFlag, String formType) {
        Long modelId = finalDataByPeriodAndOrg.get(0).getModel();
        if (modelId == null || modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u51cf\u6821\u9a8c\u83b7\u53d6\u4e0d\u5230\u4f53\u7cfbid", (String)"BudgetAdjustCheckUtils_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Long busModeId = 0L;
        ArrayList<Dimension> dimensionList = new ArrayList(16);
        boolean modelByEB = modelCacheHelper.getModelobj().isModelByEB();
        if (modelByEB) {
            dimensionList = modelCacheHelper.getDimensionList();
        } else {
            busModeId = finalDataByPeriodAndOrg.get(0).getBizmodel();
            dimensionList = modelCacheHelper.getDimensionListByBusModel(busModeId);
        }
        String dataTypeNumber = finalDataByPeriodAndOrg.get(0).getDatatypeNumber();
        for (CompareDataPojo compareDataPojo : finalDataByPeriodAndOrg) {
            StringBuilder dataKey = BudgetAdjustCheckUtils.getCompareDataKey(valueType, formType, modelId, dimensionList, modelByEB, dataTypeNumber, compareDataPojo, customTotalFlag, true);
            BigDecimal value = BigDecimal.ZERO;
            if (ADJUST_VALUE.equals(valueType)) {
                value = compareDataPojo.getAdjustdata() != null ? compareDataPojo.getAdjustdata() : BigDecimal.ZERO;
            } else if (SUBMIT_VALUE.equals(valueType)) {
                value = compareDataPojo.getSubmitValue() != null ? compareDataPojo.getSubmitValue() : BigDecimal.ZERO;
            }
            map.put(dataKey.toString(), value);
        }
    }

    private static String getMemberNumberByCompareData(Dimension dimension, CompareDataPojo compareDataPojo, Long modelId, String dataTypeNumber, boolean customTotalFlag, String valueType, String formType) {
        String memberNumber;
        block32: {
            block31: {
                IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
                boolean modelByEB = cacheHelper.getModelobj().isModelByEB();
                Dimension cacheHelperDimension = cacheHelper.getDimension(dimension.getNumber());
                memberNumber = "";
                if (!cacheHelperDimension.isPreset()) break block31;
                switch (dimension.getNumber()) {
                    case "Entity": {
                        memberNumber = compareDataPojo.getOrgnumber();
                        break;
                    }
                    case "Account": {
                        memberNumber = compareDataPojo.getAccountNumber();
                        break;
                    }
                    case "Currency": {
                        memberNumber = compareDataPojo.getCurrencyNumber();
                        break;
                    }
                    case "AuditTrail": {
                        if (ADJUST_VALUE.equals(valueType)) {
                            String auditTrail;
                            if (formType == null) {
                                formType = EbAdjBillTypeEnum.adjust.getNumber();
                            }
                            memberNumber = auditTrail = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel(modelId));
                            break;
                        }
                        if (SUBMIT_VALUE.equals(valueType)) {
                            memberNumber = "BudgetOccupation";
                            break;
                        }
                        break block32;
                    }
                    case "DataType": {
                        memberNumber = dataTypeNumber;
                        break;
                    }
                    case "Metric": {
                        memberNumber = compareDataPojo.getMetricNumber();
                        break;
                    }
                    case "Scenario": {
                        if (modelByEB) {
                            memberNumber = "NoScenario";
                            break;
                        }
                        break block32;
                    }
                    case "Process": {
                        if (modelByEB) {
                            memberNumber = "IRpt";
                            break;
                        }
                        break block32;
                    }
                    case "InternalCompany": {
                        memberNumber = "ICNone";
                        break;
                    }
                    default: {
                        memberNumber = "";
                        break;
                    }
                }
                break block32;
            }
            Map customDimMemberMap = compareDataPojo.getCustomdimMemberMap();
            if (customDimMemberMap == null || customDimMemberMap.size() <= 0) break block32;
            if (customTotalFlag) {
                for (Map.Entry entry : customDimMemberMap.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!dimension.getNumber().equals(key)) continue;
                    memberNumber = key;
                }
            } else {
                for (Map.Entry entry : customDimMemberMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (!dimension.getNumber().equals(key)) continue;
                    memberNumber = value;
                }
            }
        }
        return memberNumber;
    }

    public static void openAdjustCheckPage(IFormView view, Collection<IBudgetBalance> balances, Map<String, Integer> orgNumberSortMap) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        List<AdjustCheckBalancePojo> pojos = BudgetAdjustCheckUtils.getAdjustCheckPojoList(balances, orgNumberSortMap);
        params.put(ADJUST_CHECK_BALANCE_KEY, JSON.toJSONString(pojos));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bgc_adjustcheck");
        parameter.setCustomParams(params);
        parameter.setCaption(ResManager.loadKDString((String)"\u8c03\u6574\u68c0\u67e5\u7ed3\u679c", (String)"BudgetAdjustCheckUtils_1", (String)"epm-eb-business", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(parameter);
    }

    private static List<AdjustCheckBalancePojo> getAdjustCheckPojoList(Collection<IBudgetBalance> balances, Map<String, Integer> orgNumberSortMap) {
        ArrayList<AdjustCheckBalancePojo> pojos = new ArrayList<AdjustCheckBalancePojo>(16);
        Collection userDefineDims = null;
        for (IBudgetBalance balance : balances) {
            if (balance.getAdjustCheckAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            boolean ebByModel = balance.getBizModel().isEBByModel();
            IModelCacheHelper modelCache = balance.getBizModel().getModelCache();
            userDefineDims = balance.getBizModel().getUserDefinedDimensions();
            String memberString = BgControlUtils.getMemberString(balance, true, userDefineDims);
            String memberLongNumberString = BudgetAdjustCheckUtils.getMemberLongNumberString(balance, true, userDefineDims, modelCache);
            AdjustCheckBalancePojo pojo = new AdjustCheckBalancePojo();
            pojo.setBizNumber(balance.getBizNumber());
            pojo.setEntityName(BudgetAdjustCheckUtils.showMemberName(balance.getOrgUnit(true)));
            String entityNumber = BudgetAdjustCheckUtils.showMemberNumber(balance.getOrgUnit(true));
            pojo.setEntityNumber(entityNumber);
            if (orgNumberSortMap.containsKey(entityNumber)) {
                pojo.setEntitySeq(orgNumberSortMap.get(entityNumber));
            }
            pojo.setAccountName(BudgetAdjustCheckUtils.showMemberName(balance.getAccount(true)));
            pojo.setAccountNumber(BudgetAdjustCheckUtils.showMemberNumber(balance.getAccount(true)));
            pojo.setCustomDimsName(memberString);
            pojo.setCustomDimsLongNumber(memberLongNumberString);
            pojo.setMetricName(BudgetAdjustCheckUtils.getMetricNameByBalance(balance.getMetric(true), modelCache));
            pojo.setMetricNumber(BudgetAdjustCheckUtils.getMetricNumberByBalance(balance.getMetric(true), modelCache));
            pojo.setControlType(BudgetAdjustCheckUtils.showCtrlSet(balance.getSetting()));
            if (ebByModel) {
                pojo.setPeriod(BudgetAdjustCheckUtils.showMemberName(balance.getYear(true)) + BudgetAdjustCheckUtils.showMemberName(balance.getPeriod(true)));
                pojo.setPeriodNumber(BudgetAdjustCheckUtils.showMemberNumber(balance.getYear(true)) + BudgetAdjustCheckUtils.showMemberNumber(balance.getPeriod(true)));
            } else {
                pojo.setPeriod(BudgetAdjustCheckUtils.showMemberName(balance.getPeriod(true)));
                pojo.setPeriodNumber(BudgetAdjustCheckUtils.showMemberNumber(balance.getPeriod(true)));
            }
            pojo.setGroupName(BudgetAdjustCheckUtils.showGroupName(balance.getSetting()));
            pojo.setBeyondFlag(BudgetAdjustCheckUtils.showBeyondFlag(balance.getSetting()));
            pojo.setAdjustCheckBudget(balance.getAdjustCheckBudget());
            pojo.setAdjustCheckOccupation(balance.getAdjustCheckOccupation());
            pojo.setExecute(balance.getExecute());
            pojo.setAdjustCheckBalance(balance.getAdjustCheckBalance());
            pojo.setEbByModel(Boolean.valueOf(ebByModel));
            pojos.add(pojo);
        }
        return pojos;
    }

    private static String getMetricNameByBalance(Member metric, IModelCacheHelper modelCache) {
        if (metric == null) {
            return "";
        }
        kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metric.getNumber());
        return member.getName();
    }

    private static String getMetricNumberByBalance(Member metric, IModelCacheHelper modelCache) {
        if (metric == null || modelCache == null) {
            return "";
        }
        kd.epm.eb.common.cache.impl.Member member = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metric.getNumber());
        if (member == null) {
            return "";
        }
        return member.getNumber();
    }

    public static boolean checkCustomDimExist(long modelId, long bizModelId) {
        boolean customDimExist = false;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        if (bizModelId == 0L) {
            List dimensionList = modelCacheHelper.getDimensionList();
            for (Dimension dimension : dimensionList) {
                if (dimension.isPreset()) continue;
                customDimExist = true;
                break;
            }
        } else {
            List dimensionListByBusModel = modelCacheHelper.getDimensionListByBusModel(Long.valueOf(bizModelId));
            for (Dimension dimension : dimensionListByBusModel) {
                if (dimension.isPreset()) continue;
                customDimExist = true;
                break;
            }
        }
        return customDimExist;
    }

    public static String showCtrlSet(BgControlSetting setting) {
        if (setting == null) {
            return "";
        }
        return setting.getSettingType().getName();
    }

    public static String showMemberName(Member member) {
        if (member == null) {
            return "";
        }
        return member.getName();
    }

    public static String showMemberNumber(Member member) {
        if (member == null) {
            return "";
        }
        return member.getNumber();
    }

    public static String getMemberName(IModelCacheHelper modelCacheHelper, String dimNum, Long viewId, String memberNum) {
        String number = "";
        kd.epm.eb.common.cache.impl.Member member = modelCacheHelper.getMember(dimNum, viewId, memberNum);
        if (member != null) {
            number = member.getName();
        }
        return number;
    }

    public static String showGroupName(BgControlSetting setting) {
        String message = "";
        if (setting == null) {
            return message;
        }
        if (setting.getGroupName() != null) {
            StringBuilder messageSb = new StringBuilder();
            messageSb.append(setting.getGroupName()).append("(").append(setting.getGroupNo()).append(")");
            message = messageSb.toString();
        }
        return message;
    }

    public static String showBeyondFlag(BgControlSetting setting) {
        String message = "";
        if (setting == null) {
            return message;
        }
        message = setting.isBeyond() ? ResManager.loadKDString((String)"\u662f", (String)"BudgetAdjustCheckUtils_2", (String)"epm-eb-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"BudgetAdjustCheckUtils_3", (String)"epm-eb-business", (Object[])new Object[0]);
        return message;
    }

    public static String getItemClickType(String itemClickBar) {
        String itemClickType = "";
        itemClickType = ADJUST_CHECK_BAR.equals(itemClickBar) ? ResManager.loadKDString((String)"\u8c03\u6574\u68c0\u67e5", (String)"BudgetAdjustCheckUtils_4", (String)"epm-eb-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"BudgetAdjustCheckUtils_5", (String)"epm-eb-business", (Object[])new Object[0]);
        return itemClickType;
    }

    public static String getMemberLongNumberString(IBudgetBalance param, boolean hasBudget, Collection<kd.epm.eb.common.model.Dimension> dimensions, IModelCacheHelper modelCache) {
        String memberLongNumberString = "";
        if (param == null || dimensions == null || dimensions.isEmpty()) {
            return memberLongNumberString;
        }
        StringBuilder dataKey = new StringBuilder();
        Member member = null;
        String memberLongNumber = null;
        Map viewIds = modelCache.getViewsByBusModel(param.getBizModel().getControlBusModelId());
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            kd.epm.eb.common.cache.impl.Member cacheMember;
            member = param.getMember(hasBudget, dimension.getNumber());
            memberLongNumber = member != null ? ((cacheMember = modelCache.getMember(dimension.getNumber(), (Long)viewIds.get(dimension.getNumber()), member.getNumber())) != null ? cacheMember.getLongNumber() : "") : "";
            dataKey.append(dimension.getNumber()).append("_").append(memberLongNumber).append("!");
        }
        if (dataKey.length() > 0) {
            dataKey.setLength(dataKey.length() - "!".length());
            memberLongNumberString = dataKey.toString();
        }
        return memberLongNumberString;
    }

    public static Boolean checkAuditTrailParamRelation(Long modelId, String formType) {
        List auditTrailShowMemberNumLeaf;
        if (modelId == null || modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u51cf\u6821\u9a8c\u83b7\u53d6\u4e0d\u5230\u4f53\u7cfbid", (String)"BudgetAdjustCheckUtils_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (formType == null) {
            formType = EbAdjBillTypeEnum.adjust.getNumber();
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        String auditTrail = ControlParamsSettingUtil.getAuditTrail((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        String auditTrailShow = ControlParamsSettingUtil.getAuditTrailShow((Long)modelId, (String)formType, (boolean)ModelUtil.isEbOrBgModel(modelId));
        kd.epm.eb.common.cache.impl.Member auditTrailShowMember = modelCacheHelper.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, auditTrailShow);
        if (auditTrailShowMember != null && (auditTrailShowMemberNumLeaf = auditTrailShowMember.getLeaf().stream().map(BaseCache::getNumber).collect(Collectors.toList())).contains(auditTrail)) {
            return true;
        }
        return false;
    }

    public static void getBatchBillSameCheckDataMap(Map<String, List<CompareDataPojo>> billNumberCheckDataMap) {
        ArrayList<CompareDataPojo> sameCheckDataList = new ArrayList<CompareDataPojo>(16);
        for (Map.Entry<String, List<CompareDataPojo>> entry : billNumberCheckDataMap.entrySet()) {
            sameCheckDataList.addAll((Collection<CompareDataPojo>)entry.getValue());
        }
        Map<String, List<CompareDataPojo>> sameKeyCheckDataMap = BudgetAdjustCheckUtils.getSameKeyCompareDataPojoListMap(sameCheckDataList, ADJUST_VALUE, null, false, false);
        HashMap<String, BigDecimal> sameAdjustValueMap = new HashMap<String, BigDecimal>(sameKeyCheckDataMap.size());
        if (sameKeyCheckDataMap != null && sameKeyCheckDataMap.size() > 0) {
            List<CompareDataPojo> value;
            String key;
            for (Map.Entry<String, List<CompareDataPojo>> entry : sameKeyCheckDataMap.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                BigDecimal totalValue = BigDecimal.ZERO;
                for (CompareDataPojo compareDataPojo : value) {
                    BigDecimal currentValue = compareDataPojo.getAdjustdata() != null ? compareDataPojo.getAdjustdata() : BigDecimal.ZERO;
                    totalValue = totalValue.add(currentValue);
                }
                sameAdjustValueMap.put(key, totalValue);
            }
            for (Map.Entry<String, List<CompareDataPojo>> entry : sameKeyCheckDataMap.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (!sameAdjustValueMap.containsKey(key)) continue;
                BigDecimal bigDecimal = (BigDecimal)sameAdjustValueMap.get(key);
                for (CompareDataPojo dataPojo : value) {
                    dataPojo.setAdjustdata(bigDecimal);
                }
            }
        }
    }
}

