/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.epm.eb.common.utils.StringUtils;

public class ModelPropUtils {
    public static Object getProp(DynamicObject model, String prop) {
        Object value = null;
        if (model == null || StringUtils.isEmpty((String)prop)) {
            return value;
        }
        Collection<Object> propValue = model.get(prop);
        if (propValue != null) {
            value = propValue;
        } else {
            String[] props = prop.split("\\.");
            if (props != null && props.length > 0) {
                Object _value = model.get(props[0]);
                if (props.length == 1) {
                    value = _value;
                } else {
                    String _prop;
                    int index = prop.indexOf(".");
                    if (index >= 0 && prop.length() > index && (_prop = prop.substring(index + 1)) != null) {
                        value = _value instanceof DynamicObject ? ModelPropUtils.getProp((DynamicObject)_value, _prop) : (_value instanceof DynamicObjectCollection ? ModelPropUtils.getProp((DynamicObjectCollection)_value, _prop) : (_value instanceof Collection ? ModelPropUtils.getPropByCollection((Collection)_value, _prop) : null));
                    }
                }
            }
        }
        return value;
    }

    public static Collection<Object> getProp(DynamicObjectCollection models, String prop) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (models == null || models.isEmpty() || StringUtils.isEmpty((String)prop)) {
            return values;
        }
        Object value = null;
        for (DynamicObject model : models) {
            value = ModelPropUtils.getProp(model, prop);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public static Collection<Object> getPropByCollection(Collection<Object> colls, String prop) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (colls == null || colls.isEmpty() || StringUtils.isEmpty((String)prop)) {
            return values;
        }
        Object value = null;
        for (Object obj : colls) {
            value = null;
            if (obj instanceof DynamicObject) {
                value = ModelPropUtils.getProp((DynamicObject)obj, prop);
            }
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }
}

