/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.BgControlScheme;

public class OQLBuilder {
    public static final String orgUnit = "orgUnit";
    public static final String orgUnitNum = "orgUnitNum";
    public static final String orgUnitAlias = "orgUnitAlias";
    public static final String bizItem = "bizItem";
    public static final String bizItemNum = "bizItemNum";
    public static final String bizItemAlias = "bizItemAlias";
    public static final String bizTime = "bizTime";
    public static final String currency = "currency";
    public static final String currencyNum = "currencyNum";
    public static final String currencyAlias = "currencyAlias";
    public static final String changeType = "changeType";
    public static final String changeTypeNum = "changeTypeNum";
    public static final String changeTypeAlias = "changeTypeAlias";
    public static final String entry_account_dc = "entry_account_dc";
    public static final String entry_dc = "entrydc";
    public static final String entryId_prop = "entryProp";
    public static final String entrySeq_prop = "entrySeqProp";
    public static final String Num = "Num";
    public static final String Alias = "Alias";
    public static final String Ext = "Ext";
    private String fields = null;
    private QFBuilder builder = new QFBuilder();
    private Map<String, String> props = new LinkedHashMap<String, String>();
    private Set<String> extProps = new HashSet<String>(32);
    private String entryProp = null;
    private String entrySeq = null;

    public String getFields() {
        return this.fields;
    }

    public QFBuilder getBuilder() {
        return this.builder;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public Set<String> getExtProps() {
        return this.extProps;
    }

    public String getEntryProp() {
        return this.entryProp;
    }

    public String getEntryPropSeq() {
        return this.entrySeq;
    }

    public void clear() {
        this.fields = null;
        this.getBuilder().clear();
        this.getProps().clear();
        this.getExtProps().clear();
    }

    public void builder(IControlParameter parameter, String entityNumber, BgControlData controlData, BgControlScheme schema, boolean hasApplyField) {
        String controlValField;
        String prop_ct;
        if (parameter == null || StringUtils.isEmpty((String)entityNumber) || controlData == null || controlData.getBizModels() == null || schema == null) {
            return;
        }
        this.clear();
        BizModel bizModel = controlData.getBizModels().get(schema.getBizModelKey());
        if (bizModel == null) {
            ControlException.errorBizModel();
            return;
        }
        StringBuilder checkStr = new StringBuilder();
        if (StringUtils.isEmpty((String)schema.getOrgUnitFields())) {
            checkStr.append(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"OQLBuilder_0", (String)"epm-eb-business", (Object[])new Object[0])).append(',');
        }
        if (StringUtils.isEmpty((String)schema.getAccountFields())) {
            checkStr.append(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"OQLBuilder_1", (String)"epm-eb-business", (Object[])new Object[0])).append(',');
        }
        if (StringUtils.isEmpty((String)schema.getCurrencyFields())) {
            checkStr.append(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"OQLBuilder_2", (String)"epm-eb-business", (Object[])new Object[0])).append(',');
        }
        if (checkStr.length() > 0) {
            ControlException.propValueIsNull((String)checkStr.toString());
        }
        LinkedHashSet<String> select = new LinkedHashSet<String>(128);
        select.add("id");
        select.add(parameter.getBizUtils().getBillNumberField(entityNumber));
        String prop_org = this.getProp(schema.getOrgUnitFields());
        String prop_orgNumber = this.getNumberProp(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"OQLBuilder_0", (String)"epm-eb-business", (Object[])new Object[0]), prop_org);
        String prop_orgAlias = this.getAliasProp(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"OQLBuilder_0", (String)"epm-eb-business", (Object[])new Object[0]), prop_org);
        select.add(prop_org);
        select.add(prop_orgNumber);
        select.add(prop_orgAlias);
        this.getProps().put(orgUnit, prop_org);
        this.getProps().put(orgUnitNum, prop_orgNumber);
        this.getProps().put(orgUnitAlias, prop_orgAlias);
        String prop_org_ext = schema.getOrgUnitExtFields();
        if (StringUtils.isNotEmpty((String)prop_org_ext)) {
            String prop_org_extNumber = this.getNumberProp(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"OQLBuilder_0", (String)"epm-eb-business", (Object[])new Object[0]), prop_org_ext);
            String prop_org_extAlias = this.getAliasProp(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"OQLBuilder_0", (String)"epm-eb-business", (Object[])new Object[0]), prop_org_ext);
            select.add(prop_org_ext);
            select.add(prop_org_extNumber);
            select.add(prop_org_extAlias);
            this.getProps().put("orgUnitExt", prop_org_ext);
            this.getProps().put("orgUnitNumExt", prop_org_extNumber);
            this.getProps().put("orgUnitAliasExt", prop_org_extAlias);
            this.getExtProps().add(prop_org_ext);
            this.getExtProps().add(prop_org_extNumber);
            this.getExtProps().add(prop_org_extAlias);
        }
        String prop_bizItem = this.getProp(schema.getAccountFields());
        String prop_bizItemNumber = this.getNumberProp(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"OQLBuilder_1", (String)"epm-eb-business", (Object[])new Object[0]), prop_bizItem);
        String prop_bizItemAlias = this.getAliasProp(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"OQLBuilder_1", (String)"epm-eb-business", (Object[])new Object[0]), prop_bizItem);
        select.add(prop_bizItem);
        select.add(prop_bizItemNumber);
        select.add(prop_bizItemAlias);
        this.getProps().put(bizItem, prop_bizItem);
        this.getProps().put(bizItemNum, prop_bizItemNumber);
        this.getProps().put(bizItemAlias, prop_bizItemAlias);
        String prop_bizItem_ext = schema.getAccountExtFields();
        if (StringUtils.isNotEmpty((String)prop_bizItem_ext)) {
            String prop_bizItemNumber_ext = this.getNumberProp(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"OQLBuilder_1", (String)"epm-eb-business", (Object[])new Object[0]), prop_bizItem_ext);
            String prop_bizItemAlias_ext = this.getAliasProp(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"OQLBuilder_1", (String)"epm-eb-business", (Object[])new Object[0]), prop_bizItem_ext);
            select.add(prop_bizItem_ext);
            select.add(prop_bizItemNumber_ext);
            select.add(prop_bizItemAlias_ext);
            this.getProps().put("bizItemExt", prop_bizItem_ext);
            this.getProps().put("bizItemNumExt", prop_bizItemNumber_ext);
            this.getProps().put("bizItemAliasExt", prop_bizItemAlias_ext);
            this.getExtProps().add(prop_bizItem_ext);
            this.getExtProps().add(prop_bizItemNumber_ext);
            this.getExtProps().add(prop_bizItemAlias_ext);
        }
        String prop_currency = this.getProp(schema.getCurrencyFields());
        String prop_currencyNumber = this.getNumberProp(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"OQLBuilder_2", (String)"epm-eb-business", (Object[])new Object[0]), prop_currency);
        String prop_currencyAlias = this.getAliasProp(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"OQLBuilder_2", (String)"epm-eb-business", (Object[])new Object[0]), prop_currency);
        select.add(prop_currency);
        select.add(prop_currencyNumber);
        select.add(prop_currencyAlias);
        this.getProps().put(currency, prop_currency);
        this.getProps().put(currencyNum, prop_currencyNumber);
        this.getProps().put(currencyAlias, prop_currencyAlias);
        String prop_currency_ext = schema.getCurrencyExtFields();
        if (StringUtils.isNotEmpty((String)prop_currency_ext)) {
            String prop_currencyNumber_ext = this.getNumberProp(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"OQLBuilder_2", (String)"epm-eb-business", (Object[])new Object[0]), prop_currency_ext);
            String prop_currencyAlias_ext = this.getAliasProp(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"OQLBuilder_2", (String)"epm-eb-business", (Object[])new Object[0]), prop_currency_ext);
            select.add(prop_currency_ext);
            select.add(prop_currencyNumber_ext);
            select.add(prop_currencyAlias_ext);
            this.getProps().put("currencyExt", prop_currency_ext);
            this.getProps().put("currencyNumExt", prop_currencyNumber_ext);
            this.getProps().put("currencyAliasExt", prop_currencyAlias_ext);
            this.getExtProps().add(prop_currency_ext);
            this.getExtProps().add(prop_currencyNumber_ext);
            this.getExtProps().add(prop_currencyAlias_ext);
        }
        String prop_period = schema.getPeriodFields().toLowerCase(Locale.getDefault());
        select.add(prop_period);
        this.getProps().put(bizTime, prop_period);
        if (!bizModel.isEBByModel() && StringUtils.isNotEmpty((String)(prop_ct = schema.getChangeTypeField()))) {
            prop_ct = prop_ct.toLowerCase(Locale.getDefault());
            String prop_ctNumber = this.getNumberProp(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"OQLBuilder_3", (String)"epm-eb-business", (Object[])new Object[0]), prop_ct);
            String prop_ctAlias = this.getAliasProp(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"OQLBuilder_3", (String)"epm-eb-business", (Object[])new Object[0]), prop_ct);
            select.add(prop_ct);
            select.add(prop_ctNumber);
            select.add(prop_ctAlias);
            this.getProps().put(changeType, prop_ct);
            this.getProps().put(changeTypeNum, prop_ctNumber);
            this.getProps().put(changeTypeAlias, prop_ctAlias);
            String prop_ct_ext = schema.getChangeTypeExtField();
            if (StringUtils.isNotEmpty((String)prop_ct_ext)) {
                String prop_ctNumber_ext = this.getNumberProp(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"OQLBuilder_3", (String)"epm-eb-business", (Object[])new Object[0]), prop_ct_ext);
                String prop_ctAlias_ext = this.getAliasProp(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"OQLBuilder_3", (String)"epm-eb-business", (Object[])new Object[0]), prop_ct_ext);
                select.add(prop_ct_ext);
                select.add(prop_ctNumber_ext);
                select.add(prop_ctAlias_ext);
                this.getExtProps().add(prop_ct_ext);
                this.getExtProps().add(prop_ctNumber_ext);
                this.getExtProps().add(prop_ctAlias_ext);
            }
        }
        for (Map.Entry<String, String> entry : schema.getUserDefendPropMap().entrySet()) {
            String prop_userDefend = entry.getValue();
            if (!StringUtils.isNotEmpty((String)prop_userDefend)) continue;
            prop_userDefend = this.getProp(prop_userDefend);
            String prop_userDefendNumber = this.getNumberProp("useDefined Prop", prop_userDefend);
            String prop_userDefendAlias = this.getAliasProp("useDefined Prop", prop_userDefend);
            select.add(prop_userDefend);
            select.add(prop_userDefendNumber);
            select.add(prop_userDefendAlias);
            this.getProps().put(entry.getKey(), prop_userDefend);
            this.getProps().put(entry.getKey() + Num, prop_userDefendNumber);
            this.getProps().put(entry.getKey() + Alias, prop_userDefendAlias);
        }
        HashSet<String> controlValFields = new HashSet<String>(16);
        BillFieldTypeEmum operation = parameter.getControlManager().isOccupation() ? BillFieldTypeEmum.TAKEOPERATION : (parameter.getControlManager().isExecute() ? BillFieldTypeEmum.RUNOPERATION : null);
        String string = controlValField = operation != null ? schema.getControlValue(String.valueOf(operation.getIndex()), parameter.getOperation()) : null;
        if (controlValField != null) {
            controlValFields.add(controlValField);
        } else {
            controlValFields.addAll(parameter.getDataManager().getApplyFields());
        }
        if (hasApplyField && !controlValFields.isEmpty()) {
            for (String field : controlValFields) {
                if (!StringUtils.isNotEmpty((String)field)) continue;
                select.add(field);
                if (field.indexOf(46) <= 0) continue;
                this.entryProp = this.getEntryId(field);
                this.entrySeq = this.getEntrySeq(field);
            }
        }
        if ("gl_voucher".equals(parameter.getEntityNumber())) {
            this.getProps().put(entry_account_dc, "entries.account.dc");
            this.getProps().put(entry_dc, "entries.entrydc");
            select.add("entries.account.dc");
            select.add("entries.entrydc");
        }
        if (parameter.getControlManager().isStandard()) {
            this.builder.add(new QFilter("id", "=", (Object)Long.parseLong(parameter.getBizId())));
        } else {
            this.builder.add(new QFilter("id", "=", (Object)parameter.getBizId()));
        }
        if (schema.getFilter() != null) {
            this.builder.add(schema.getFilter());
            select.addAll(schema.getCondProperty());
        }
        if (this.entryProp != null) {
            select.add(this.entryProp);
            this.getProps().put(entryId_prop, this.entryProp);
        }
        if (this.entrySeq != null) {
            select.add(this.entrySeq);
            this.getProps().put(entrySeq_prop, this.entrySeq);
        }
        this.fields = String.join((CharSequence)",", select);
    }

    private String getEntryId(String applyProp) {
        if (applyProp == null) {
            return null;
        }
        int index = applyProp.lastIndexOf(46);
        return applyProp.substring(0, index) + ".id";
    }

    private String getEntrySeq(String applyProp) {
        if (applyProp == null) {
            return null;
        }
        int index = applyProp.lastIndexOf(46);
        return applyProp.substring(0, index) + ".seq";
    }

    private String getProp(String property) {
        if (property.startsWith("entries.assgrp")) {
            return property;
        }
        return property.toLowerCase(Locale.getDefault());
    }

    private String getNumberProp(String propType, String propValue) throws KDBizException {
        if (StringUtils.isEmpty((String)propValue)) {
            ControlException.propValueIsNull((String)propType);
        }
        return OQLBuilder.getNumberProp(propValue);
    }

    public static String getNumberProp(String propValue) {
        if (propValue == null) {
            return null;
        }
        String string = propValue = propValue.startsWith("entries.assgrp") ? propValue : propValue.toLowerCase(Locale.getDefault());
        String propNumber = propValue.endsWith(".number") ? propValue : (propValue.endsWith(".longnumber") ? propValue : (propValue.endsWith(".id") ? propValue.replaceAll(".id", ".number") : (propValue.endsWith("number") ? propValue : propValue + ".number")));
        return propNumber;
    }

    private String getAliasProp(String propType, String propValue) throws KDBizException {
        if (StringUtils.isEmpty((String)propValue)) {
            ControlException.propValueIsNull((String)propType);
        }
        return OQLBuilder.getAliasProp(propValue);
    }

    public static String getAliasProp(String propValue) {
        if (propValue == null) {
            return null;
        }
        String string = propValue = propValue.startsWith("entries.assgrp") ? propValue : propValue.toLowerCase(Locale.getDefault());
        String propAlias = propValue.endsWith(".number") ? propValue.replaceAll(".number", ".name") : (propValue.endsWith(".longnumber") ? propValue.replaceAll(".longnumber", ".name") : (propValue.endsWith(".id") ? propValue.replaceAll(".id", ".name") : (propValue.endsWith("number") ? propValue.replaceAll("number", "name") : propValue + ".name")));
        return propAlias;
    }

    public static void addParentField(Set<String> fieldList) {
        if (fieldList == null || fieldList.isEmpty()) {
            return;
        }
        HashSet<String> parentFields = new HashSet<String>(10);
        for (String field : fieldList) {
            OQLBuilder.addParentField(field, parentFields);
        }
        fieldList.addAll(parentFields);
    }

    private static void addParentField(String field, Set<String> parentFields) {
        int lastIndex;
        if (StringUtils.isNotEmpty((String)field) && parentFields != null && (lastIndex = field.lastIndexOf(46)) > 0) {
            field = field.substring(0, lastIndex);
            parentFields.add(field);
            OQLBuilder.addParentField(field, parentFields);
        }
    }
}

