/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.control.ConditionUtils;
import kd.epm.eb.control.face.IWriteOff;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.impl.model.WriteOff;
import kd.epm.eb.control.utils.BgControlProcessUtils;
import kd.epm.eb.control.utils.BgRegisterUtils;
import kd.epm.eb.control.utils.OQLBuilder;

public class QueryFieldByBill {
    private static final Log log = LogFactory.getLog(QueryFieldByBill.class);
    private static final String FIELDS = "cardentity.entityfield.number, cardentity.accountfield.number, cardentity.yearfield.number, cardentity.currencyfield.number, cardentity.entityfieldext.number, cardentity.accountfieldext.number, cardentity.currencyfieldext.number, cardentity.userdefined1field.number, cardentity.userdefined2field.number, cardentity.userdefined3field.number, cardentity.userdefined4field.number, cardentity.userdefined5field.number, cardentity.userdefined6field.number, cardentity.userdefined1fieldext.number, cardentity.userdefined2fieldext.number, cardentity.userdefined3fieldext.number, cardentity.userdefined4fieldext.number, cardentity.userdefined5fieldext.number, cardentity.serqfilter, cardentity.qfilter,cardentity.id,isdynamicvalue";
    private static final String PROCESSFIELD = "controlprocess.entryentity.runoperation, controlprocess.entryentity.runvalue, controlprocess.entryentity.takeoperation, controlprocess.entryentity.takevalue, controlprocess.entryentity.serqfilter, controlprocess.entryentity.writeoffscheme.id";

    public static Set<String> queryFieldByDefault(String billtype, boolean isCheckParam, boolean isopenapi) {
        try {
            return QueryFieldByBill.innerQueryFieldByDefault(billtype, isCheckParam, isopenapi);
        }
        catch (Throwable ex) {
            log.info("queryFieldByDefault-error{}", (Object)ex);
            MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billtype);
            if (billEntityType != null) {
                return billEntityType.getAllFields().keySet();
            }
            log.info("no-bill-entity = " + billtype);
            return new HashSet<String>(1);
        }
    }

    private static Set<String> innerQueryFieldByDefault(String billtype, boolean isCheckParam, boolean isopenapi) {
        QFilter wffilter;
        Map wfMap;
        Serializable schema;
        if (StringUtils.isEmpty((String)billtype)) {
            return new HashSet<String>(1);
        }
        QFilter qFilterBill = new QFilter("fieldtable", "=", (Object)billtype);
        DynamicObject defalut = QueryServiceHelper.queryOne((String)"eb_bgcontroldefault", (String)"id,simplefield", (QFilter[])qFilterBill.toArray());
        if (defalut == null) {
            log.info("no-default-set = " + billtype);
            return new HashSet<String>(1);
        }
        MainEntityType billEntityType = null;
        if (isCheckParam && !defalut.getBoolean("simplefield")) {
            billEntityType = EntityMetadataCache.getDataEntityType((String)billtype);
            if (billEntityType != null) {
                return billEntityType.getAllFields().keySet();
            }
            log.info("no-bill-entity = " + billtype);
            return new HashSet<String>(1);
        }
        HashSet<String> fieldList = null;
        if (fieldList != null) {
            log.info("queryFieldByDefault-from-cache:" + JSONUtils.toString(fieldList));
            return fieldList;
        }
        fieldList = new HashSet<String>(16);
        if (StringUtils.isEmpty((String)billtype)) {
            return fieldList;
        }
        String field = null;
        String propValue = null;
        Row row = null;
        QFilter qFilter = new QFilter("fieldtable", "in", (Object)billtype);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryFieldByDefault", (String)"eb_bgcontroldefault", (String)"orgfield.fieldalias, periodfield.fieldalias", (QFilter[])new QFilter[]{qFilter}, null);){
            if (ds != null && ds.hasNext()) {
                row = ds.next();
                propValue = row.getString("orgfield.fieldalias");
                QueryFieldByBill.addField(isopenapi, fieldList, propValue);
                fieldList.add(row.getString("periodfield.fieldalias"));
            } else if (isopenapi) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u9ed8\u8ba4\u5c5e\u6027\u503c\u201d\u3002", (String)"QueryFieldByBill_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        HashSet<Long> detailids = new HashSet<Long>();
        QFilter qFilterrule = new QFilter("bill.fieldtable", "=", (Object)billtype);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryFieldByDefault", (String)"eb_adddimmaterule", (String)FIELDS, (QFilter[])new QFilter[]{qFilterrule}, null);){
            if (ds != null) {
                schema = new HashMap(2);
                int periodIndex = ds.getRowMeta().getFieldIndex("cardentity.yearfield.number");
                int serqfilterindex = ds.getRowMeta().getFieldIndex("cardentity.serqfilter");
                int cardentityindex = ds.getRowMeta().getFieldIndex("cardentity.id");
                int qfilterindex = ds.getRowMeta().getFieldIndex("cardentity.qfilter");
                int size = ds.getRowMeta().getFieldCount();
                while (ds.hasNext()) {
                    row = ds.next();
                    for (int index = 0; index < size; ++index) {
                        if (index == serqfilterindex || index == qfilterindex || index == cardentityindex) continue;
                        propValue = row.getString(index);
                        if ("0".equals(propValue) && row.get(index) instanceof Long) {
                            propValue = "";
                        }
                        if (!StringUtils.isNotEmpty((String)propValue)) continue;
                        if (index == periodIndex) {
                            fieldList.add(propValue);
                            continue;
                        }
                        if (propValue.toLowerCase(Locale.getDefault()).endsWith("id")) {
                            fieldList.add(propValue);
                            continue;
                        }
                        if (!isopenapi) {
                            fieldList.add(propValue);
                        }
                        QueryFieldByBill.addField(isopenapi, fieldList, propValue);
                    }
                    schema.clear();
                    schema.put("fserqfilter", row.getString("cardentity.serqfilter"));
                    schema.put("fqfilter", row.getString("cardentity.qfilter"));
                    detailids.add(row.getLong("cardentity.id"));
                    try {
                        fieldList.addAll(BgControlScheme.getConditionFields(billtype, (Map<String, Object>)((Object)schema)));
                    }
                    catch (Throwable ex) {
                        log.info("parseCondition-error{}", (Object)ex);
                    }
                }
            } else if (isopenapi) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u7ef4\u5ea6\u5339\u914d\u89c4\u5219\u201d\u3002", (String)"QueryFieldByBill_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        SqlBuilder ruleValueSql = new SqlBuilder();
        ruleValueSql.append("select fdetailid,ftype,foperation,fvaluefield from t_eb_dimmaterulevalue where ", new Object[0]);
        ruleValueSql.appendIn("fdetailid", detailids.toArray());
        DataSet ds = DB.queryDataSet((String)"querydimmaterulevalue", (DBRoute)BgBaseConstant.epm, (SqlBuilder)ruleValueSql);
        schema = null;
        try {
            Row next;
            if (ds != null && ds.hasNext() && StringUtils.isNotEmpty((String)(next = ds.next()).getString("fvaluefield"))) {
                fieldList.add(next.getString("fvaluefield"));
            }
        }
        catch (Throwable next) {
            schema = next;
            throw next;
        }
        finally {
            if (ds != null) {
                if (schema != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable next) {
                        ((Throwable)schema).addSuppressed(next);
                    }
                } else {
                    ds.close();
                }
            }
        }
        QFilter qFilterprocess = new QFilter("controlprocess.entryentity.bill.fieldtable", "=", (Object)billtype);
        HashSet<Long> writeIds = new HashSet<Long>(16);
        try (DataSet ds2 = QueryServiceHelper.queryDataSet((String)"queryFieldByDefault", (String)"eb_bgcontrolprocessorg", (String)PROCESSFIELD, (QFilter[])new QFilter[]{qFilterprocess}, null);){
            if (ds2 != null) {
                while (ds2.hasNext()) {
                    Set<String> fields;
                    row = ds2.next();
                    if (IDUtils.isNotNull((Long)row.getLong("controlprocess.entryentity.writeoffscheme.id"))) {
                        writeIds.add(row.getLong("controlprocess.entryentity.writeoffscheme.id"));
                    }
                    if (StringUtils.isNotEmpty((String)(field = row.getString("controlprocess.entryentity.runvalue")))) {
                        fieldList.add(field);
                    }
                    if (StringUtils.isNotEmpty((String)(field = row.getString("controlprocess.entryentity.takevalue")))) {
                        fieldList.add(field);
                    }
                    String serqfilter = row.getString("controlprocess.entryentity.serqfilter");
                    if (isopenapi || !StringUtils.isNotEmpty((String)serqfilter)) continue;
                    FlexBDValueCondition flexBDValueCondition = (FlexBDValueCondition)SerializationUtils.fromJsonString((String)serqfilter, FlexBDValueCondition.class);
                    FilterBuilder filterBuilder = ConditionUtils.get().getFilterBuilder(billtype, flexBDValueCondition.getFilterCondition());
                    QFilter filter = filterBuilder.getFilterObject().getFilterResult().getQFilter();
                    if (qFilter == null || (fields = BgControlProcessUtils.getCondProperty(filter)) == null) continue;
                    fieldList.addAll(fields);
                }
            } else if (isopenapi) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c\u6267\u884c\u503c\u201d\u6216\u201c\u5360\u7528\u503c\u201d\u3002", (String)"QueryFieldByBill_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        if (!writeIds.isEmpty() && (wfMap = BusinessDataServiceHelper.loadFromCache((String)"eb_writeoffscheme_pro", (String)"id, number, name, writeoffinfo.id, writeoffinfo.writeoffbill, writeoffinfo.writeoffbill.number, writeoffinfo.writeofftype, writeoffinfo.writeoffsourcebill, writeoffinfo.writeoffsourcebill.number, writeoffinfo.writeoffentry, writeoffinfo.writeoffentry.number, writeoffinfo.writeoffvalue, writeoffinfo.writeoffvalue.number, writeoffinfo.writeoffsourcebillentry, writeoffinfo.writeoffsourcebillentry.number", (QFilter[])(wffilter = new QFilter("id", "in", writeIds)).toArray())) != null) {
            for (DynamicObject wfobj : wfMap.values()) {
                IWriteOff writeoff = WriteOff.of(wfobj);
                for (String[] writebill : writeoff.getBills().values()) {
                    String sourceIdProp = writebill[1];
                    String entryIdProp = writebill[2];
                    String valueProp = writebill[4];
                    if (StringUtils.isNotEmpty((String)sourceIdProp)) {
                        fieldList.add(sourceIdProp);
                    }
                    if (StringUtils.isNotEmpty((String)entryIdProp)) {
                        fieldList.add(entryIdProp);
                    }
                    if (!StringUtils.isNotEmpty((String)valueProp)) continue;
                    fieldList.add(valueProp);
                }
            }
        }
        if (isopenapi) {
            fieldList.add("bostype");
            fieldList.add("id");
            fieldList.add("number");
        } else {
            if (billEntityType == null) {
                billEntityType = EntityMetadataCache.getDataEntityType((String)billtype);
            }
            fieldList.add("id");
            if (billEntityType.getProperties().containsKey((Object)"billno")) {
                fieldList.add("billno");
            } else {
                fieldList.add("number");
            }
        }
        if (!isopenapi) {
            if (billEntityType == null) {
                billEntityType = EntityMetadataCache.getDataEntityType((String)billtype);
            }
            StringBuilder names = new StringBuilder();
            if ("gl_voucher".equals(billtype)) {
                fieldList.add("entries.debitlocal");
                fieldList.add("entries.creditlocal");
                fieldList.add("entries.debitori");
                fieldList.add("entries.creditori");
                fieldList.add("entries.account.dc");
                fieldList.add("entries.entrydc");
            }
            Iterator itF = fieldList.iterator();
            while (itF.hasNext()) {
                names.setLength(0);
                field = (String)itF.next();
                if ("gl_voucher".equals(billtype) && (field.startsWith("entries.assgrp") || field.startsWith("assgrp")) || BgRegisterUtils.getField(billEntityType, field, names) != null) continue;
                log.info("queryFieldByDefault-no-property:" + field);
                itF.remove();
            }
            OQLBuilder.addParentField(fieldList);
        }
        CacheServiceHelper.setFieldsCache((String)billtype, (boolean)isopenapi, fieldList);
        log.info("queryFieldByDefault-from-db:" + JSONUtils.toString(fieldList));
        return fieldList;
    }

    private static void addField(boolean isopenapi, Set<String> fieldList, String propValue) {
        fieldList.add(OQLBuilder.getAliasProp(propValue));
        fieldList.add(OQLBuilder.getNumberProp(propValue));
        if (!isopenapi) {
            fieldList.add(propValue + ".id");
        }
    }

    public static boolean isSimpleField(String entityNumber) {
        QFilter qFilterBill = new QFilter("fieldtable", "=", (Object)entityNumber);
        DynamicObject defalut = QueryServiceHelper.queryOne((String)"eb_bgcontroldefault", (String)"id,simplefield", (QFilter[])qFilterBill.toArray());
        boolean value = defalut != null && defalut.getBoolean("simplefield");
        log.info("queryFieldByDefault-isSimpleField:" + value);
        return value;
    }
}

