/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.BizOrgUnit;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.control.ConditionUtils;
import kd.epm.eb.control.eums.ControlTypeEnum;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.face.IWriteOff;
import kd.epm.eb.control.impl.model.BgControlData;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.impl.model.WriteOff;
import kd.epm.eb.control.impl.model.WriteOffLog;
import kd.epm.eb.control.utils.BgControlLogAddUtils;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgControlParamUtils;
import kd.epm.eb.control.utils.BgControlRecordUtils;
import kd.epm.eb.control.utils.BgControlSchemeUtils;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.BgRegisterUtils;
import kd.epm.eb.control.utils.OQLBuilder;
import kd.epm.eb.control.utils.WriteOffsObj;

public class WriteOffsUtils {
    public static final String WRITEOFF_FIELDS = "id, number, name, writeoffinfo.id, writeoffinfo.writeoffbill, writeoffinfo.writeoffbill.number, writeoffinfo.writeofftype, writeoffinfo.writeoffsourcebill, writeoffinfo.writeoffsourcebill.number, writeoffinfo.writeoffentry, writeoffinfo.writeoffentry.number, writeoffinfo.writeoffvalue, writeoffinfo.writeoffvalue.number, writeoffinfo.writeoffsourcebillentry, writeoffinfo.writeoffsourcebillentry.number";
    private static final Log log = LogFactory.getLog(WriteOffsUtils.class);
    private static final String noEntryID = "";

    public static WriteOffsUtils get() {
        return new WriteOffsUtils();
    }

    public static boolean verifyWriteOffs(IControlParameter parameter) {
        boolean isWriteOff;
        boolean bl = isWriteOff = parameter != null && (parameter.getControlManager().isExecute() || parameter.getControlManager().isOccupation());
        if (isWriteOff && !parameter.getControlManager().isStandard() && (parameter.getWriteoffMaps() == null || parameter.getWriteoffMaps().isEmpty())) {
            isWriteOff = false;
        }
        return isWriteOff;
    }

    public Collection<IControlParam> builderParams(IControlParameter parameter, BgControlData controlData, Collection<IControlParam> executes) {
        Collection<IControlParam> _controlParams;
        LinkedList<IControlParam> writeoffparams = new LinkedList<IControlParam>();
        if (parameter == null || parameter.getControlManager().isStandard() && parameter.getBizObj() == null || controlData == null || executes == null || executes.isEmpty()) {
            return writeoffparams;
        }
        LinkedHashMap<String, BgControlScheme> dynamicSchemas = new LinkedHashMap<String, BgControlScheme>();
        HashSet<Long> uniteModelKey = new HashSet<Long>();
        HashMap<String, BigDecimal> writeoffAmount = new HashMap<String, BigDecimal>(16);
        HashMap<String, Map<String, BigDecimal>> entrywriteoffAmount = new HashMap<String, Map<String, BigDecimal>>(16);
        LinkedList<IControlParam> dynamicExecutes = new LinkedList<IControlParam>();
        LinkedList<IControlParam> uniteExecutes = new LinkedList<IControlParam>();
        for (IControlParam controlParam : executes) {
            if (controlParam == null || controlParam.getControlScheme() == null || controlParam.isOnlyCheck()) continue;
            if (!parameter.getControlManager().isStandard()) {
                uniteModelKey.add(controlParam.getControlScheme().getBizModelKey());
                uniteExecutes.add(controlParam);
                continue;
            }
            if (controlParam.getControlScheme().isDynamicvalue() && controlParam.getControlScheme().getSourceGroups() != null && !controlParam.getControlScheme().getSourceGroups().isEmpty()) {
                if (controlParam.getControlScheme().getWriteOff() == null && parameter.getDataManager() != null && parameter.getDataManager().getWriteOff() != null && parameter.getDataManager().getWriteOff().getBills() != null) {
                    controlParam.getControlScheme().setWriteOff(parameter.getDataManager().getWriteOff());
                }
                if (controlParam.getControlScheme().getWriteOff() != null && controlParam.getControlScheme().getWriteOff().getBills() != null) {
                    dynamicSchemas.put(String.valueOf(controlParam.getControlScheme().getDetailId()), controlParam.getControlScheme());
                    dynamicExecutes.add(controlParam);
                    continue;
                }
                uniteModelKey.add(controlParam.getControlScheme().getBizModelKey());
                uniteExecutes.add(controlParam);
                continue;
            }
            uniteModelKey.add(controlParam.getControlScheme().getBizModelKey());
            uniteExecutes.add(controlParam);
        }
        for (BgControlScheme controlScheme : dynamicSchemas.values()) {
            Collection<IControlParam> _controlParams2 = this.builderParams(parameter, controlData, dynamicExecutes, writeoffAmount, entrywriteoffAmount, controlScheme, null);
            if (_controlParams2 == null) continue;
            writeoffparams.addAll(_controlParams2);
        }
        if (!uniteModelKey.isEmpty() && (_controlParams = this.builderParams(parameter, controlData, uniteExecutes, writeoffAmount, entrywriteoffAmount, null, uniteModelKey)) != null) {
            writeoffparams.addAll(_controlParams);
        }
        return writeoffparams;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<IControlParam> builderParams(IControlParameter parameter, BgControlData controlData, Collection<IControlParam> executes, Map<String, BigDecimal> writeoffAmount, Map<String, Map<String, BigDecimal>> entrywriteoffAmount, BgControlScheme controlScheme, Set<Long> uniteModelKey) {
        LogStats writeLog = new LogStats("control-write-log : ");
        LinkedList<IControlParam> controlParams = new LinkedList<IControlParam>();
        if (parameter == null || parameter.getDataManager() == null || parameter.getControlManager().isStandard() && parameter.getBizObj() == null || controlData == null || executes == null || executes.isEmpty()) {
            return controlParams;
        }
        DynamicObject bizObj = parameter.getBizObj();
        LinkedList<IControlParam> _controlParams = new LinkedList<IControlParam>();
        LinkedList<Map<String, Object>> propsMap = new LinkedList<Map<String, Object>>();
        OQLBuilder oqlBuilder = new OQLBuilder();
        StringBuilder memberKey = new StringBuilder();
        HashSet<Long> hasSchemeKeys = new HashSet<Long>(10);
        BizModel bizModel = null;
        HashMap<String, Collection> bizModelMap = new HashMap<String, Collection>(10);
        Map<Long, Map<Long, Set<String>>> exeNumbers = this.getUseControlShemeNumbers(executes);
        ArrayList<WriteOffLog> logs = new ArrayList<WriteOffLog>(10);
        boolean isMulti = controlData.isMultiControl();
        IWriteOff writeoff = parameter.getDataManager().getWriteOff();
        HashSet<Long> bizModelKey = new HashSet<Long>(1);
        HashMap<String, Boolean> isWriteoffEntryMap = new HashMap<String, Boolean>(2);
        boolean isDeductByEntry = false;
        HashMap<String, String[]> defaultSetMap = new HashMap<String, String[]>(2);
        if (!parameter.getControlManager().isStandard()) {
            writeoff = WriteOff.of(parameter.getWriteoffMaps());
            if (parameter.getWriteoffMaps() != null && !parameter.getWriteoffMaps().isEmpty()) {
                long entryId = 0L;
                HashSet<String> entryids = new HashSet<String>(10);
                for (Map.Entry<String, List<Map<String, Object>>> entries : parameter.getWriteoffMaps().entrySet()) {
                    boolean isWriteoffEntry = true;
                    BgRegisterUtils.loadDefaultSetting(defaultSetMap, entries.getKey());
                    isDeductByEntry = BgRegisterUtils.isDeductByEntry((String[])defaultSetMap.get(entries.getKey()));
                    for (Map<String, Object> entry : entries.getValue()) {
                        String writeentryid = StringUtils.toNoEmptyString((Object)entry.get("writeoffentry.id"));
                        if (StringUtils.isEmpty((String)writeentryid)) {
                            isWriteoffEntry = false;
                            if (isDeductByEntry) {
                                ControlException.entryIdMustInput();
                            }
                            entry.put("writeoffentry.id", String.valueOf(entryId++));
                            continue;
                        }
                        if (entryids.contains(writeentryid)) {
                            ControlException.entryIdWriteOff();
                            continue;
                        }
                        entryids.add(writeentryid);
                    }
                    isWriteoffEntryMap.put(entries.getKey(), isWriteoffEntry);
                }
            }
            bizModelKey.addAll(uniteModelKey);
        } else if (controlScheme != null) {
            writeoff = controlScheme.getWriteOff();
            bizModelKey.add(controlScheme.getBizModelKey());
        } else if (uniteModelKey != null) {
            bizModelKey.addAll(uniteModelKey);
        }
        writeLog.add("isWriteoffEntry = " + JSONUtils.toString(isWriteoffEntryMap));
        if (writeoff != null && writeoff.getBills() != null) {
            Set<String> refBizIds = this.queryRefBizIds(parameter, controlData);
            for (String[] writeInfo : writeoff.getBills().values()) {
                Map<String, String> _fields;
                Object _schemas2;
                List<Map<String, Object>> _entries;
                int index;
                String _targetApplyProp;
                bizModelMap.clear();
                String sourceEntityNumber = writeInfo[0];
                String sourceIdProp = writeInfo[1];
                String entryIdProp = writeInfo[2];
                String valueProp = writeInfo[4];
                boolean hasOccupation = "occupationwriteoff".equals(writeInfo[3]);
                boolean isWriteoffEntry = true;
                if (isWriteoffEntryMap.containsKey(sourceEntityNumber)) {
                    isWriteoffEntry = (Boolean)isWriteoffEntryMap.get(sourceEntityNumber);
                }
                if (!(_targetApplyProp = writeInfo[5]).endsWith(".id")) {
                    _targetApplyProp = _targetApplyProp + ".id";
                }
                try {
                    String[] props = BgRegisterUtils.queryRegisterBizUnit(sourceEntityNumber);
                    isDeductByEntry = BgRegisterUtils.isDeductByEntry(props);
                    controlData.setMultiControl(BgRegisterUtils.isMultiControl(props));
                }
                catch (Throwable props) {
                    // empty catch block
                }
                if (!isDeductByEntry) {
                    isWriteoffEntry = false;
                }
                if ((index = valueProp.lastIndexOf(46)) == -1) {
                    writeLog.add("error-prop:" + valueProp);
                    continue;
                }
                String entryProp = valueProp.substring(0, index);
                if (StringUtils.isEmpty((String)sourceIdProp)) {
                    writeLog.addInfo("error-entry-prop:" + sourceIdProp);
                    continue;
                }
                HashSet<String> sourceBillIds = new HashSet<String>(16);
                String _sourceIdProp = sourceIdProp;
                if (!parameter.getControlManager().isStandard()) {
                    if (parameter.getWriteoffMaps() != null && parameter.getWriteoffMaps().get(sourceEntityNumber) != null) {
                        for (Map<String, Object> map : parameter.getWriteoffMaps().get(sourceEntityNumber)) {
                            sourceBillIds.add(StringUtils.toNoEmptyString((Object)map.get("id")));
                        }
                    }
                } else if (sourceIdProp.indexOf(46) < 0) {
                    if (bizObj.get(_sourceIdProp) != null && StringUtils.isNotEmpty((String)bizObj.getString(_sourceIdProp))) {
                        sourceBillIds.add(bizObj.getString(_sourceIdProp));
                    }
                } else if (sourceIdProp.startsWith(entryProp)) {
                    DynamicObjectCollection writeOffEntry;
                    _sourceIdProp = this.transEntryProp(entryProp, sourceIdProp);
                    if (_sourceIdProp == null) {
                        writeLog.addInfo("empty-_sourceIdProp:" + _sourceIdProp);
                        continue;
                    }
                    if (bizObj.get(entryProp) != null && bizObj.get(entryProp) instanceof DynamicObjectCollection && (writeOffEntry = bizObj.getDynamicObjectCollection(entryProp)) != null && !writeOffEntry.isEmpty()) {
                        for (DynamicObject entry2 : writeOffEntry) {
                            if (!StringUtils.isNotEmpty((String)entry2.getString(_sourceIdProp))) continue;
                            sourceBillIds.add(entry2.getString(_sourceIdProp));
                        }
                    }
                }
                if (sourceBillIds.isEmpty()) {
                    writeLog.addInfo("empty-sourceid:" + sourceIdProp);
                    continue;
                }
                String _entryIdProp = this.transEntryProp(entryProp, entryIdProp);
                String string = this.transEntryProp(entryProp, valueProp);
                if (StringUtils.isEmpty((String)_entryIdProp) && parameter.getControlManager().isStandard() && !"er_tripreimbursebill".equals(parameter.getEntityNumber())) {
                    writeLog.addInfo("error-entry-prop:" + entryIdProp);
                    continue;
                }
                if (StringUtils.isEmpty((String)string)) {
                    writeLog.addInfo("error-entry-prop:" + valueProp);
                    continue;
                }
                List<Map<String, Object>> entryObj = null;
                entryObj = !parameter.getControlManager().isStandard() ? parameter.getWriteoffMaps().get(sourceEntityNumber) : bizObj.get(entryProp);
                if (!(entryObj instanceof List) || (_entries = entryObj).isEmpty()) continue;
                if (!parameter.getControlManager().isStandard() && isWriteoffEntry) {
                    Object obj;
                    List<Map<String, Object>> backup = _entries;
                    _entries = new ArrayList<Map<String, Object>>(backup);
                    HashMap<String, Map<String, Object>> entryMap = new HashMap<String, Map<String, Object>>(_entries.size());
                    for (Map<String, Object> entry : _entries) {
                        obj = new WriteOffsObj(entry);
                        String string2 = ((WriteOffsObj)obj).getString("writeoffentry.id");
                        entryMap.put(string2, entry);
                    }
                    Iterator<Map<String, Object>> it = _entries.iterator();
                    while (it.hasNext()) {
                        Map<String, Object> entry;
                        entry = it.next();
                        obj = new WriteOffsObj(entry);
                        String string3 = ((WriteOffsObj)obj).getString("writeoffentry.id");
                        if (entryMap.get(string3) == null || entryMap.get(string3) == entry) continue;
                        it.remove();
                        log.info("writeoff-remove-entryid: " + string3);
                    }
                }
                boolean isAllCt = !parameter.getControlManager().isStandard();
                HashSet<String> hasExecuteBizIds = new HashSet<String>(10);
                Map<Long, Map<String, Map<String, Map<String, BigDecimal>>>> sourceKeys = this.getControlBizIds(sourceBillIds, controlData, hasOccupation, isAllCt, sourceEntityNumber, parameter.getBizId(), hasExecuteBizIds, isWriteoffEntry);
                HashSet<String> hasNegativeOcc = new HashSet<String>();
                if (sourceKeys != null) {
                    for (Map.Entry entry : sourceKeys.entrySet()) {
                        block19: for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                            if (hasExecuteBizIds.contains(entry2.getKey())) continue;
                            for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                                BigDecimal value = BigDecimal.ZERO;
                                for (BigDecimal bigDecimal : ((Map)entry3.getValue()).values()) {
                                    if (bigDecimal == null) continue;
                                    value = value.add(bigDecimal);
                                }
                                if (value.compareTo(BigDecimal.ZERO) >= 0) continue;
                                hasNegativeOcc.add(BgControlUtils.getNegativeOccKey((String)entry2.getKey(), (Long)entry.getKey()));
                                continue block19;
                            }
                        }
                    }
                }
                if (sourceKeys == null || sourceKeys.isEmpty()) {
                    writeLog.addInfo("writeOff-sourceKeys: is empty");
                    continue;
                }
                writeLog.addInfo("writeOff-sourceKeys:" + JSONUtils.toString(sourceKeys));
                Map<String, Collection<BgControlScheme>> schemas = BgControlSchemeUtils.query(controlData, sourceEntityNumber, false);
                if (schemas == null || schemas.isEmpty()) {
                    ControlException.notDimensionMappingByLoanBills((String)sourceEntityNumber, controlData.getBizModels().values(), (BizOrgUnit)controlData.getBizOrgUnit());
                    return controlParams;
                }
                _controlParams.clear();
                for (Object _schemas2 : schemas.entrySet()) {
                    hasSchemeKeys.clear();
                    for (BgControlScheme schema : _schemas2.getValue()) {
                        Collection<IControlParam> _params;
                        void var55_86;
                        if (!bizModelKey.contains(schema.getBizModelKey()) || hasSchemeKeys.contains(schema.getBizModelKey()) || schema.isOnlyCheck()) continue;
                        bizModel = controlData.getBizModels().get(schema.getBizModelKey());
                        if (bizModel == null) {
                            BgControlLogUtils.info(controlData.getStats(), true, "budget-control-log : nofound-scheme=" + schema.getBizModelKey());
                            continue;
                        }
                        if (parameter.getDataManager() != null && parameter.getDataManager().getNegativeOcc() != null && parameter.getDataManager().getNegativeOcc().contains(BgControlUtils.getNegativeOccKey(parameter.getBizId(), schema.getBizModelKey())) || controlScheme != null && controlScheme.getSourceGroups() != null && !controlScheme.getSourceGroups().contains(schema.getGroupId()) || sourceKeys == null || sourceKeys.get(bizModel.getKey()) == null || sourceKeys.get(bizModel.getKey()).isEmpty() || !parameter.getControlManager().isOccupation() && !parameter.getControlManager().isExecute()) continue;
                        writeLog.addInfo("writeOff-bizIds:" + JSONUtils.toString(sourceKeys));
                        Object var55_84 = null;
                        if (parameter.getControlManager().isStandard()) {
                            Set<Long> set = this.getControlBizEntryIds(_sourceIdProp, _entryIdProp, (DynamicObjectCollection)_entries, sourceKeys.get(bizModel.getKey()).keySet());
                        }
                        _fields = BgControlRecordUtils.getCommFields(bizModel);
                        propsMap.clear();
                        oqlBuilder.builder(parameter, sourceEntityNumber, controlData, schema, false);
                        oqlBuilder.getBuilder().clear();
                        oqlBuilder.getBuilder().add(new QFilter("id", "in", (Object)IDUtils.toLongs(sourceKeys.get(bizModel.getKey()).keySet())));
                        if (var55_86 != null && _targetApplyProp != null) {
                            oqlBuilder.getBuilder().add(new QFilter(_targetApplyProp, "in", (Object)var55_86));
                        }
                        if (parameter.getControlManager().isStandard()) {
                            DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBizBill", (String)sourceEntityNumber, (String)(oqlBuilder.getFields() + "," + _targetApplyProp), (QFilter[])oqlBuilder.getBuilder().toArrays(), null);
                            Object object = null;
                            try {
                                propsMap.addAll(CommonServiceHelper.transDataSet((DataSet)ds));
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (ds != null) {
                                    if (object != null) {
                                        try {
                                            ds.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                    } else {
                                        ds.close();
                                    }
                                }
                            }
                        } else {
                            propsMap.addAll(_entries);
                        }
                        BgControlLogUtils.infoThread(controlData.getStats(), true, () -> JSONUtils.toString((Object)propsMap));
                        if (StringUtils.isNotEmpty((String)schema.getCondition())) {
                            writeLog.addInfo(schema.getCondition());
                            ArrayList _filterProps = Lists.newArrayListWithCapacity((int)propsMap.size());
                            ConditionUtils utils = ConditionUtils.get();
                            ConditionUtils.QFilterEvaluator qFilterEvaluator = new ConditionUtils.QFilterEvaluator();
                            for (Map map : propsMap) {
                                qFilterEvaluator.setValues(map);
                                if (!utils.run(schema.getFilter(), qFilterEvaluator)) continue;
                                _filterProps.add(map);
                            }
                            if (schema.isOnlycontrolsuit()) {
                                propsMap.clear();
                                propsMap.addAll(_filterProps);
                            } else if (_filterProps.isEmpty()) {
                                propsMap.clear();
                            }
                        }
                        if (propsMap.isEmpty()) continue;
                        hasSchemeKeys.add(schema.getBizModelKey());
                        if (schema.hasMapping(bizModel)) {
                            schema.loadMapping(bizModel);
                        }
                        if ((_params = this.builderParams(parameter, schema, controlData, oqlBuilder.getProps(), propsMap)) == null) continue;
                        _controlParams.addAll(_params);
                    }
                    for (BizModel _bizModel : controlData.getBizModels().values()) {
                        if (hasSchemeKeys.contains(_bizModel.getKey())) continue;
                        bizModelMap.computeIfAbsent((String)_schemas2.getKey(), f -> new ArrayList(10)).add(_bizModel);
                    }
                }
                HashMap hashMap = Maps.newHashMapWithExpectedSize((int)_controlParams.size());
                _schemas2 = _controlParams.iterator();
                while (_schemas2.hasNext()) {
                    IControlParam iControlParam = (IControlParam)_schemas2.next();
                    if (iControlParam == null || iControlParam.getBizModel() == null || iControlParam.getControlScheme() == null) continue;
                    StringBuilder entryId = new StringBuilder(String.valueOf(iControlParam.getPropValueMap().get("id"))).append("#");
                    if (parameter.getControlManager().isStandard()) {
                        if (StringUtils.isNotEmpty((String)_entryIdProp)) {
                            entryId.append(iControlParam.getPropValueMap().get(_targetApplyProp));
                        }
                    } else {
                        entryId.append(iControlParam.getPropValueMap().get("writeoffentry.id"));
                    }
                    hashMap.computeIfAbsent(entryId.toString(), f -> new HashMap(10)).computeIfAbsent(iControlParam.getControlScheme().getBizModelKey(), f -> new ArrayList(10)).add(iControlParam);
                }
                String writeentryId = noEntryID;
                for (Map<String, Object> obj : _entries) {
                    Map subMap;
                    void var58_98;
                    WriteOffsObj writeOffsObj = new WriteOffsObj(obj);
                    String sourceId = writeOffsObj.getString(_sourceIdProp);
                    StringBuilder entryId = new StringBuilder(sourceId).append("#");
                    if (parameter.getControlManager().isStandard()) {
                        if (StringUtils.isNotEmpty((String)_entryIdProp)) {
                            entryId.append(writeOffsObj.getLong(_entryIdProp));
                        }
                    } else if (!parameter.getControlManager().isStandard()) {
                        entryId.append(writeOffsObj.getString("writeoffentry.id"));
                    }
                    BigDecimal bigDecimal = writeOffsObj.getBigDecimal(string);
                    if (!parameter.getControlManager().isStandard()) {
                        BigDecimal bigDecimal2 = writeOffsObj.getBigDecimal("writeoffentry.amount");
                    }
                    if (var58_98 == null || var58_98.compareTo(BigDecimal.ZERO) < 0) {
                        BigDecimal bigDecimal3 = BigDecimal.ZERO;
                    }
                    if ((subMap = (Map)hashMap.get(entryId.toString())) == null || subMap.isEmpty()) continue;
                    for (Map.Entry subEntry : subMap.entrySet()) {
                        void var58_100;
                        if (hasNegativeOcc.contains(BgControlUtils.getNegativeOccKey(sourceId, (Long)subEntry.getKey()))) {
                            writeLog.addInfo("writeOff-has-negative: " + BgControlUtils.getNegativeOccKey(sourceId, (Long)subEntry.getKey()));
                            continue;
                        }
                        BigDecimal leftOcc = var58_100;
                        if (sourceKeys.get(subEntry.getKey()) == null || !sourceKeys.get(subEntry.getKey()).containsKey(sourceId)) continue;
                        for (IControlParam controlParam : (List)subEntry.getValue()) {
                            if (controlParam == null || controlParam.getBizModel() == null) continue;
                            Map memberKeys = (Map)sourceKeys.computeIfAbsent((Long)subEntry.getKey(), (Function<Long, Map<String, Map<String, Map<String, BigDecimal>>>>)((Function<Long, Map>)f -> new HashMap(10))).get(sourceId);
                            memberKey.setLength(0);
                            _fields = BgControlRecordUtils.getCommFields(controlParam.getBizModel());
                            this.getMemberkey(controlData, memberKey, _fields, controlParam);
                            controlParam.setRefBizId(controlParam.getBizId());
                            controlParam.setBizId(parameter.getBizId());
                            controlParam.setBizNumber(parameter.getBizNo());
                            if (isAllCt) {
                                controlParam.setControlType(!hasExecuteBizIds.contains(controlParam.getRefBizId()) ? ControlTypeEnum.OCCUPATION : ControlTypeEnum.EXECUTE);
                            } else {
                                controlParam.setControlType(hasOccupation ? ControlTypeEnum.OCCUPATION : ControlTypeEnum.EXECUTE);
                            }
                            controlParam.setAmend(controlParam.getAmount());
                            controlParam.setWriteOffs(true);
                            controlParam.setAmount(var58_100 == null ? BigDecimal.ZERO : var58_100.negate());
                            writeLog.addInfo("writeOff-memberKey: " + memberKey);
                            if (StringUtils.isNotEmpty((String)_entryIdProp) && writeOffsObj.getLong(_entryIdProp) != null) {
                                controlParam.setEntryId(String.valueOf(writeOffsObj.getLong(_entryIdProp)));
                            }
                            if (isWriteoffEntry) {
                                if (parameter.getControlManager().isStandard()) {
                                    writeentryId = writeOffsObj.getString(_entryIdProp);
                                } else if (!parameter.getControlManager().isStandard()) {
                                    writeentryId = writeOffsObj.getString("writeoffentry.id");
                                }
                            }
                            String sourceIdKey = sourceId + "!" + memberKey;
                            BigDecimal writeoffedamount = writeoffAmount.computeIfAbsent(sourceIdKey, f -> BigDecimal.ZERO);
                            BigDecimal entrywriteoffedamount = entrywriteoffAmount.computeIfAbsent(sourceIdKey, f -> Maps.newHashMap()).computeIfAbsent(writeentryId, f -> BigDecimal.ZERO);
                            BigDecimal canWriteoffValue = memberKeys.get(memberKey.toString()) == null ? null : (BigDecimal)((Map)memberKeys.get(memberKey.toString())).get(writeentryId);
                            BigDecimal allcanWriteoffValue = BigDecimal.ZERO;
                            if (memberKeys.get(memberKey.toString()) != null) {
                                for (BigDecimal v : ((Map)memberKeys.get(memberKey.toString())).values()) {
                                    if (v == null) continue;
                                    allcanWriteoffValue = allcanWriteoffValue.add(v);
                                }
                            }
                            if (canWriteoffValue != null) {
                                BigDecimal cwov;
                                canWriteoffValue = canWriteoffValue.add(entrywriteoffedamount);
                                if ((allcanWriteoffValue = allcanWriteoffValue.add(writeoffedamount)).compareTo(BigDecimal.ZERO) < 0) {
                                    allcanWriteoffValue = BigDecimal.ZERO;
                                }
                                BigDecimal bigDecimal4 = cwov = canWriteoffValue.compareTo(allcanWriteoffValue) > 0 ? allcanWriteoffValue : canWriteoffValue;
                                if (cwov.compareTo(BigDecimal.ZERO) < 0) {
                                    cwov = BigDecimal.ZERO;
                                }
                                if (StringUtils.isEmpty((String)_entryIdProp) && (!parameter.getControlManager().isStandard() || "er_tripreimbursebill".equals(parameter.getEntityNumber()))) {
                                    if (leftOcc.compareTo(BigDecimal.ZERO) > 0) {
                                        if (cwov.compareTo(leftOcc) < 0) {
                                            controlParam.setAmount(cwov.negate());
                                            leftOcc = leftOcc.subtract(cwov);
                                        } else {
                                            controlParam.setAmount(leftOcc.negate());
                                            leftOcc = BigDecimal.ZERO;
                                        }
                                    } else {
                                        controlParam.setAmount(BigDecimal.ZERO);
                                        _controlParams.remove(controlParam);
                                    }
                                } else if (cwov.compareTo(controlParam.getAmount().negate()) < 0) {
                                    controlParam.setAmount(cwov.negate());
                                }
                            } else {
                                controlParam.setAmount(BigDecimal.ZERO);
                                _controlParams.remove(controlParam);
                            }
                            controlParam.setAmend(controlParam.getAmount());
                            if (isWriteoffEntry) {
                                controlParam.setEntryId(writeentryId);
                            }
                            writeoffAmount.put(sourceIdKey, writeoffedamount.add(controlParam.getAmount()));
                            entrywriteoffAmount.get(sourceIdKey).put(writeentryId, writeoffedamount.add(controlParam.getAmount()));
                        }
                    }
                }
                if (!_controlParams.isEmpty()) {
                    controlParams.addAll(_controlParams);
                    WriteOffLog writeOffLog = new WriteOffLog();
                    writeOffLog.setEntryIdProp(entryIdProp);
                    writeOffLog.setTargetApplyProp(_targetApplyProp);
                    writeOffLog.setSourceEntityNumber(sourceEntityNumber);
                    writeOffLog.setOccupation(hasOccupation);
                    writeOffLog.setSourceIdProp(sourceIdProp);
                    writeOffLog.setValueProp(valueProp);
                    writeOffLog.getControlParams().addAll(_controlParams);
                    logs.add(writeOffLog);
                }
                Map<Long, Map<Long, Set<String>>> map = this.getUseControlShemeNumbers(controlParams);
                log.info("budget-control-log : exeNumbers = " + JSONUtils.toString(exeNumbers));
                log.info("budget-control-log : writeNumbers = " + JSONUtils.toString(map));
                block31: for (Map.Entry<Object, Object> entry : exeNumbers.entrySet()) {
                    if (entry.getValue() == null || ((Map)entry.getValue()).isEmpty() || map.get(entry.getKey()) == null) continue;
                    Set exes = (Set)((Map)entry.getValue()).values().iterator().next();
                    for (Set set : map.get(entry.getKey()).values()) {
                        if (exes.size() >= set.size()) continue;
                        ControlException.errorWriteOffMulti((BizModel)controlData.getBizModels().get(entry.getKey()));
                        continue block31;
                    }
                }
            }
        }
        controlData.setMultiControl(isMulti);
        ArrayList removes = Lists.newArrayListWithExpectedSize((int)controlParams.size());
        for (IControlParam _controlParam : controlParams) {
            if (_controlParam.isWriteOffs()) continue;
            removes.add(_controlParam);
        }
        if (!removes.isEmpty()) {
            controlParams.removeAll(removes);
        }
        if (controlScheme != null) {
            for (IControlParam _controlParam : controlParams) {
                if (!_controlParam.isWriteOffs()) continue;
                _controlParam.setTargetSchemeId(controlScheme.getDetailId());
            }
        }
        BgControlLogUtils.infoThread(controlData.getStats(), true, () -> writeLog.toString());
        BgControlLogAddUtils.addWriteOffLogs(controlData.getStats(), writeoff == null ? Long.valueOf(0L) : writeoff.getId(), logs);
        return controlParams;
    }

    private Map<Long, Map<Long, Set<String>>> getUseControlShemeNumbers(Collection<IControlParam> controlParams) {
        HashMap<Long, Map<Long, Set<String>>> numbers = new HashMap<Long, Map<Long, Set<String>>>(10);
        if (controlParams == null) {
            return numbers;
        }
        for (IControlParam controlparam : controlParams) {
            if (controlparam == null || controlparam.getBizModel() == null || controlparam.getControlScheme() == null || controlparam.isOnlyCheck()) continue;
            numbers.computeIfAbsent(controlparam.getBizModel().getKey(), f -> new HashMap(10)).computeIfAbsent(controlparam.getControlScheme().getBillId(), f -> new HashSet(10)).add(controlparam.getControlScheme().getSchemeKey());
        }
        return numbers;
    }

    protected Set<String> queryRefBizIds(IControlParameter parameter, BgControlData controlData) {
        if (parameter == null) {
            return Collections.emptySet();
        }
        LinkedHashSet refBizIds = Sets.newLinkedHashSet();
        HashSet<String> ctrlTables = new HashSet<String>(controlData.getBizModels().size());
        for (BizModel bizModel : controlData.getBizModels().values()) {
            ctrlTables.add(bizModel.getBgControlRecordTable());
        }
        for (String ctrlTable : ctrlTables) {
            this.queryRefBizIds(parameter, refBizIds, ctrlTable);
        }
        return refBizIds;
    }

    private void queryRefBizIds(IControlParameter parameter, Set<String> refBizIds, String ctrlTable) {
        String sql = "select frefbizid from " + ctrlTable + " where fbizid = ? and frefbizid is not null";
        try (DataSet ds = DB.queryDataSet((String)"queryRefBizIds", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{parameter.getBizId()});){
            if (ds != null) {
                for (Row row : ds) {
                    if (!StringUtils.isNotEmpty((String)row.getString("frefbizid"))) continue;
                    refBizIds.add(row.getString("frefbizid"));
                }
            }
        }
    }

    protected String transEntryProp(String entryProp, String entryDirectProp) {
        if (entryProp == null || entryDirectProp == null) {
            return null;
        }
        int index = entryDirectProp.indexOf(entryProp);
        if (index == -1) {
            return null;
        }
        return entryDirectProp.replaceFirst(entryProp + '.', noEntryID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<IControlParam> builderParams(IControlParameter parameter, BgControlScheme scheme, BgControlData controlData, Map<String, String> props, List<Map<String, Object>> propsMap) {
        LogStats schemeStats = new LogStats("budget-control-log : ");
        schemeStats.addInfo("begin-writeoff-builderParams");
        if (scheme != null) {
            scheme.setStats(schemeStats);
        }
        try {
            Collection<IControlParam> collection = BgControlParamUtils.get().setParameter(parameter).setScheme(scheme).builderParams(controlData, props, propsMap);
            return collection;
        }
        finally {
            if (scheme != null) {
                scheme.setStats(controlData.getStats());
                BgControlLogUtils.infoThread(controlData.getStats(), true, () -> schemeStats.toString());
            }
        }
    }

    protected Map<Long, Map<String, Map<String, Map<String, BigDecimal>>>> getControlBizIds(Set<String> bizIds, BgControlData controlData, boolean hasOccupation, boolean isAllCt, String sourceEntityNumber, String currBillId, Set<String> hasExecuteBizIds, boolean isWriteoffEntry) {
        if (bizIds.isEmpty() || controlData == null || controlData.getBizModels() == null || controlData.getBizModels().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<String, Map<String, Map<String, BigDecimal>>>> result = new HashMap<Long, Map<String, Map<String, Map<String, BigDecimal>>>>(controlData.getBizModels().size());
        for (BizModel bizModel : controlData.getBizModels().values()) {
            Map<String, Map<String, Map<String, BigDecimal>>> subMap = this.getControlBizIds(bizIds, controlData, bizModel, hasOccupation, isAllCt, sourceEntityNumber, currBillId, hasExecuteBizIds, isWriteoffEntry);
            if (subMap == null || subMap.isEmpty()) continue;
            result.put(bizModel.getKey(), subMap);
        }
        return result;
    }

    protected Map<String, Map<String, Map<String, BigDecimal>>> getControlBizIds(Set<String> bizIds, BgControlData controlData, BizModel bizModel, boolean hasOccupation, boolean isAllCt, String sourceEntityNumber, String currBillId, Set<String> hasExecuteBizIds, boolean isWriteoffEntry) {
        HashSet<String> isEntityBizIds;
        LinkedHashMap sourceIdKeys;
        block38: {
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("model", "=", (Object)bizModel.getId()));
            builder.add(new QFilter("number", "=", (Object)"Execute"));
            DynamicObject execute = BusinessDataServiceHelper.loadSingleFromCache((String)SysDimensionEnum.ChangeType.getMemberTreemodel(), (String)"id, number", (QFilter[])builder.toArrays());
            if (execute == null) {
                log.warn("budget-control-log : write-offs error. execute is null.");
                return Collections.emptyMap();
            }
            Long executeId = execute.getLong("id");
            if (hasExecuteBizIds == null) {
                hasExecuteBizIds = new HashSet<String>(10);
                log.info("budget-control-log : write-offs error. hasExecuteBizIds is null.");
            }
            SqlBuilder sql = new SqlBuilder();
            sql.append(BgControlRecordUtils.getSql(bizModel).toString(), new Object[0]);
            sql.append(" where (", new Object[0]);
            sql.appendIn("fbizid", bizIds.toArray());
            sql.appendIn(" or frefbizid ", bizIds.toArray());
            sql.append(")", (Object[])null);
            if (!hasOccupation && !isAllCt) {
                sql.append(" and fctid = ?", new Object[]{executeId});
            }
            sourceIdKeys = Maps.newLinkedHashMap();
            isEntityBizIds = new HashSet<String>(10);
            try (DataSet ds = DB.queryDataSet((String)"queryControlRecord", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                String _bizId;
                if (ds == null) break block38;
                StringBuilder key = new StringBuilder();
                Map<String, String> _fields = BgControlRecordUtils.getCommFields(bizModel);
                Map memberKeys = null;
                Map valueMap = null;
                BigDecimal value = null;
                String entryId = noEntryID;
                HashSet<String> removeIds = new HashSet<String>();
                IModelCacheHelper modelCacheHelper = bizModel.getModelCache();
                List records = CommonServiceHelper.transDataSet((DataSet)ds.copy());
                Boolean isReviewOcc = false;
                for (String string : bizIds) {
                    if (!records.stream().anyMatch(k -> currBillId.equals(k.get("fbizid")) && k.get("frefbizid") != null && !noEntryID.equals(k.get("frefbizid")) && string.equals(k.get("frefbizid").toString()))) continue;
                    isReviewOcc = true;
                }
                controlData.setIsReviewOcc(isReviewOcc);
                Throwable throwable = null;
                try (DataSet copy = ds.copy();){
                    for (Row row : copy) {
                        _bizId = row.getString("fbizid");
                        if (executeId.compareTo(row.getLong("fctid")) != 0) continue;
                        hasExecuteBizIds.add(_bizId);
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                for (Row row : ds) {
                    _bizId = row.getString("fbizid");
                    String _refBizId = row.getString("frefbizid");
                    if (!bizModel.getId().equals(row.getLong("fmodelid"))) continue;
                    String _entityNumber = row.getString("fentitynumber");
                    if (sourceEntityNumber != null && sourceEntityNumber.equals(_entityNumber)) {
                        isEntityBizIds.add(_bizId);
                    }
                    if (StringUtils.isNotEmpty((String)_refBizId)) {
                        _bizId = _refBizId;
                    }
                    if (isAllCt && hasExecuteBizIds.contains(_bizId) && executeId.compareTo(row.getLong("fctid")) != 0) continue;
                    memberKeys = sourceIdKeys.computeIfAbsent(_bizId, f -> Maps.newLinkedHashMap());
                    this.getMemberkey(controlData, bizModel, key, _fields, modelCacheHelper, row);
                    valueMap = memberKeys.computeIfAbsent(key.toString(), f -> Maps.newLinkedHashMap());
                    if (isWriteoffEntry) {
                        entryId = StringUtils.isNotEmpty((String)row.getString("frefbizid")) ? row.getString("frefentryid") : row.getString("fentryid");
                    }
                    value = valueMap.computeIfAbsent(entryId, f -> BigDecimal.ZERO);
                    if (row.getBigDecimal("famount") != null && (StringUtils.isEmpty((String)row.getString("frefbizid")) || !currBillId.equals(row.getString("fbizid")))) {
                        value = value.add(row.getBigDecimal("famount"));
                        valueMap.put(entryId, value);
                    }
                    if (isAllCt || !hasOccupation || executeId.compareTo(row.getLong("fctid")) != 0) continue;
                    removeIds.add(_bizId);
                }
                if (!removeIds.isEmpty()) {
                    for (String string : removeIds) {
                        sourceIdKeys.remove(string);
                    }
                }
            }
        }
        if (sourceEntityNumber != null) {
            Iterator it = sourceIdKeys.entrySet().iterator();
            while (it.hasNext()) {
                if (isEntityBizIds.contains(it.next().getKey())) continue;
                it.remove();
            }
        }
        return sourceIdKeys;
    }

    private void getMemberkey(BgControlData controlData, StringBuilder key, Map<String, String> _fields, IControlParam controlParam) {
        key.setLength(0);
        BizModel bizModel = controlData.getBizModels().get(controlParam.getBizModel().getKey());
        if (bizModel == null) {
            BgControlLogUtils.info(controlData.getStats(), true, "nofound-scheme=" + controlParam.getBizModel().getKey());
            ControlException.errorBizModel();
            return;
        }
        for (kd.epm.eb.common.model.Dimension dimension : bizModel.getDimensions()) {
            if (dimension.getNumber().equals(SysDimensionEnum.ChangeType.getNumber())) continue;
            Member _member = controlParam.getMember(false, dimension.getNumber());
            if (_member == null) {
                ControlException.notExistByMember1((kd.epm.eb.common.model.Dimension)dimension, (BizModel)bizModel, (Long)dimension.getId());
                return;
            }
            key.append(dimension.getShortNumber()).append('@').append(_member.getNumber()).append('!');
        }
    }

    private void getMemberkey(BgControlData controlData, BizModel bizModel, StringBuilder key, Map<String, String> _fields, IModelCacheHelper modelCacheHelper, Row row) {
        key.setLength(0);
        for (kd.epm.eb.common.model.Dimension dimension : bizModel.getDimensions()) {
            Dimension dimension1;
            Long occperiodid;
            if (dimension.getNumber().equals(SysDimensionEnum.ChangeType.getNumber())) continue;
            String _field = BgDimensionServiceHelper.hasUserDefinedDimension((kd.epm.eb.common.model.Dimension)dimension) ? BgControlUtils.getUserDefinedIdField(dimension) : _fields.get(dimension.getNumber());
            Long _memberId = row.getLong(_field);
            if ((SysDimensionEnum.Period.getNumber().equals(dimension.getNumber()) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) && (occperiodid = row.getLong("foccperiodid")) != null && occperiodid != 0L) {
                _memberId = occperiodid;
            }
            if ((dimension1 = modelCacheHelper.getDimension(dimension.getId())) == null) continue;
            kd.epm.eb.common.cache.impl.Member _member = dimension1.getStructOfMember(_memberId);
            if (_member == null) {
                ControlException.notExistMember((String)ControlException.notExistByMember1((kd.epm.eb.common.model.Dimension)dimension, (BizModel)bizModel, (Long)_memberId));
                return;
            }
            key.append(dimension.getShortNumber()).append('@').append(_member.getNumber()).append('!');
        }
    }

    protected Set<Long> getControlBizEntryIds(String sourceIdProp, String sourceEntryIdProp, DynamicObjectCollection entries, Set<String> sourceIds) {
        if (sourceIdProp == null || entries == null || sourceIds == null) {
            return null;
        }
        if (sourceEntryIdProp == null) {
            return null;
        }
        HashSet<Long> entryIds = new HashSet<Long>();
        int in = entries.size();
        for (int i = 0; i < in; ++i) {
            Long entryId;
            DynamicObject entry = (DynamicObject)entries.get(i);
            String sourceId = entry.getString(sourceIdProp);
            if (!StringUtils.isNotEmpty((String)sourceId) || !sourceIds.contains(sourceId) || (entryId = Long.valueOf(entry.getLong(sourceEntryIdProp))) == null || entryId == 0L) continue;
            entryIds.add(entryId);
        }
        return entryIds;
    }
}

