/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.warning;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.ebupgrades.utils.PermUpgradesUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.BgControlPeriodTypeEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.gridfilter.CommonFilter;
import kd.epm.eb.common.message.MessageUtils;
import kd.epm.eb.common.model.BgPeriodUserDefinedUtils;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgPeriodUtils;
import kd.epm.eb.control.warning.ControlWarningException;
import kd.epm.eb.control.warning.ControlWarningHelper;
import kd.epm.eb.control.warning.ControlWarningMemberCheckHelper;
import kd.epm.eb.control.warning.ControlWarningMemberNode;
import kd.epm.eb.control.warning.ControlWarningMessageCompilerHelper;
import kd.epm.eb.control.warning.ControlWarningRule;
import kd.epm.eb.control.warning.ControlWarningScheme;
import kd.epm.eb.control.warning.ControlWarningSchemeEntry;
import org.jetbrains.annotations.NotNull;

public class ControlWarningDataSourceHelper
implements CommonFilter {
    private static final Log log = LogFactory.getLog(ControlWarningDataSourceHelper.class);
    public static final int MAX_BATCH = 50000;
    private Double usePercent = ControlWarningMemberCheckHelper.getCheckMemberPercent();
    private Integer dataSize = BgControlLogUtils.getWarningDataSize();

    public DynamicObjectCollection getData(Long warningId, String warningName, List<QFilter> qFilterList, Set<Long> formulaIds) {
        if (formulaIds != null && formulaIds.isEmpty()) {
            return new DynamicObjectCollection();
        }
        ControlWarningMemberCheckHelper.checkMember(this.usePercent);
        DynamicObjectCollection result = new DynamicObjectCollection();
        DynamicObjectCollection saveResult = new DynamicObjectCollection();
        long st = System.currentTimeMillis();
        log.info("budget-control-warning-log : time-begin");
        Set<Object> ids = null;
        if (qFilterList != null && !qFilterList.isEmpty()) {
            ids = Sets.newHashSet();
            try {
                log.info("budget-control-warning-log : QFilter:" + JSONUtils.toString(qFilterList));
                List keys = QueryServiceHelper.queryPrimaryKeys((String)"bgc_controlwarnningscheme", (QFilter[])qFilterList.toArray(new QFilter[0]), null, (int)Integer.MAX_VALUE);
                if (keys != null) {
                    for (Object obj : keys) {
                        ids.add(IDUtils.toLong(obj));
                    }
                }
            }
            catch (Throwable e) {
                log.info("budget-control-warning-log : QFilter-error:" + e);
            }
        }
        if (formulaIds != null) {
            if (ids == null) {
                ids = formulaIds;
            } else {
                ids.retainAll(formulaIds);
            }
        }
        if (ids != null && ids.isEmpty()) {
            return result;
        }
        Map<Long, ControlWarningScheme> schems = ControlWarningHelper.queryWarningScheme((Set<Long>)ids);
        if (schems == null || schems.isEmpty()) {
            return result;
        }
        HashMap<Long, List<ControlWarningScheme>> schemeMap = new HashMap<Long, List<ControlWarningScheme>>(10);
        schems.values().forEach(f -> schemeMap.computeIfAbsent(f.getModelKey(), g -> new ArrayList(10)).add(f));
        log.info("budget-control-warning-log : time-endQueryWarningScheme " + (System.currentTimeMillis() - st));
        ArrayList<Map<String, String>> members = new ArrayList<Map<String, String>>(schems.size());
        HashMap oneMembers = Maps.newHashMap();
        Long modelId = null;
        Long bussModelId = null;
        HashMap memberList = Maps.newHashMap();
        HashMap oneMemberList = Maps.newHashMap();
        HashSet modelIds = Sets.newHashSet();
        HashSet dimNumbers = Sets.newHashSet();
        for (Map.Entry entry : schemeMap.entrySet()) {
            if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
            for (ControlWarningScheme scheme : (List)entry.getValue()) {
                modelIds.add(scheme.getModelId());
            }
        }
        HashMap<Long, Map<String, Set<Long>>> defaultMemberList = new HashMap<Long, Map<String, Set<Long>>>(10);
        this.queryControlVersion(defaultMemberList, modelIds);
        Map<Long, ControlWarningMemberNode> warnHasMembers = this.queryHasMembers(schemeMap);
        ControlWarningMemberNode memberNode = null;
        log.info("budget-control-warning-log : time-queryControlVersion " + (System.currentTimeMillis() - st));
        HashMap<Long, BgPeriodUserDefinedUtils> pUtilsMap = new HashMap<Long, BgPeriodUserDefinedUtils>(10);
        HashMap<Long, Set<Long>> bailOrgMap = new HashMap<Long, Set<Long>>(10);
        HashMap<Long, Set<Long>> orgPesonMap = new HashMap<Long, Set<Long>>(10);
        try {
            block18: for (Map.Entry entry : schemeMap.entrySet()) {
                if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
                boolean isFirst = true;
                for (ControlWarningScheme controlWarningScheme : (List)entry.getValue()) {
                    log.info("budget-control-warning-log : time-scheme " + (System.currentTimeMillis() - st));
                    log.info("budget-control-warning-log : modelid = " + controlWarningScheme.getModelId());
                    modelId = controlWarningScheme.getModelId();
                    BgPeriodUserDefinedUtils utils = (BgPeriodUserDefinedUtils)pUtilsMap.get(modelId);
                    if (utils == null) {
                        utils = new BgPeriodUserDefinedUtils(modelId);
                        pUtilsMap.put(modelId, utils);
                    }
                    CalendarHelper calendar = new CalendarHelper();
                    calendar.setTime(this.getCurrentDate());
                    String time = BgPeriodUtils.getPeriodYear((int)calendar.getCurrentlyYear());
                    if (utils.isPeriodUserDefine()) {
                        time = utils.getPeriodNumber(BgControlPeriodTypeEnum.YEAR.getIndex(), this.getCurrentDate());
                    }
                    bussModelId = controlWarningScheme.getBussModelId();
                    Map defaultMap = defaultMemberList.computeIfAbsent((Long)entry.getKey(), (Function<Long, Map<String, Set<Long>>>)((Function<Long, Map>)f -> Maps.newHashMap()));
                    if (isFirst) {
                        boolean b = this.queryByControlRecord(modelId, bussModelId, defaultMap, "fcurrencyid", SysDimensionEnum.Currency.getNumber());
                        log.info("budget-control-warning-log : time-queryByControlRecord-fcurrencyid" + (System.currentTimeMillis() - st));
                        if (!b) continue block18;
                        b = this.queryByControlRecord(modelId, bussModelId, defaultMap, "fmetricid", SysDimensionEnum.Metric.getNumber());
                        log.info("budget-control-warning-log : time-queryByControlRecord-fmetricid" + (System.currentTimeMillis() - st));
                        if (!b) continue block18;
                    }
                    isFirst = false;
                    members.clear();
                    memberList.clear();
                    memberNode = warnHasMembers.get(controlWarningScheme.getId());
                    try {
                        this.calcMemberList(controlWarningScheme, defaultMemberList, members, memberList, oneMemberList, oneMembers, dimNumbers, memberNode, bailOrgMap, orgPesonMap);
                    }
                    catch (ControlWarningException ex) {
                        String schemeName = controlWarningScheme.getNumber();
                        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)controlWarningScheme.getId(), (String)"bgc_controlwarnningscheme", (String)"name");
                        if (obj != null) {
                            schemeName = obj.getString("name");
                        }
                        String message = ResManager.loadResFormat((String)"\u9884\u8b66\u65b9\u6848%1\u4e2d\u7ef4\u5ea6\u6210\u5458\u7ec4\u5408\u6570\u8d85\u8fc7\u7cfb\u7edf\u9650\u5236%2\u4e07\uff0c\u8bf7\u51cf\u5c11\u540e\u91cd\u8bd5\u3002", (String)"ControlWarningDataSourceHelper_1", (String)"epm-eb-business", (Object[])new Object[]{schemeName, this.dataSize});
                        throw new ControlWarningException(message);
                    }
                    log.info("budget-control-warning-log : time-calcMemberList " + (System.currentTimeMillis() - st));
                    DynamicObject report = ControlWarningHelper.buildReportHead(controlWarningScheme, time, warningId, 0L);
                    if (members.isEmpty()) {
                        saveResult.add((Object)report);
                        continue;
                    }
                    log.info("members=" + JSONUtils.toString(members));
                    int batchCount = (members.size() - 1) / 50000 + 1;
                    for (int i = 0; i < batchCount; ++i) {
                        int startIndex = i * 50000;
                        int endIndex = startIndex + 50000;
                        if (endIndex > members.size()) {
                            endIndex = members.size();
                        }
                        log.info("budget-control-warning-log : getData = " + (i + 1) + "/" + batchCount);
                        ControlWarningMemberCheckHelper.checkMember(this.usePercent);
                        this.getData(result, controlWarningScheme, report, members.subList(startIndex, endIndex), bussModelId);
                        log.info("budget-control-warning-log : time-getData " + (System.currentTimeMillis() - st));
                    }
                    if (!report.getDynamicObjectCollection("entryentity").isEmpty()) {
                        result.addAll(ControlWarningHelper.splitByReceiver(controlWarningScheme, time, report, bailOrgMap, orgPesonMap));
                        int count = 0;
                        for (DynamicObject obj : result) {
                            count += obj.getDynamicObjectCollection("entryentity").size();
                        }
                        if (count <= this.dataSize * 10000) continue;
                        String message = ResManager.loadResFormat((String)"\u9884\u8b66\u76d1\u63a7\u65b9\u6848%1\u4e2d\u9884\u8b66\u6d88\u606f\u6570\u8d85\u8fc7\u7cfb\u7edf\u9650\u5236%2\u4e07\u6761\uff0c\u8bf7\u8c03\u6574\u9884\u8b66\u76d1\u63a7\u65b9\u6848\u3002", (String)"ControlWarningDataSourceHelper_2", (String)"epm-eb-business", (Object[])new Object[]{warningName, this.dataSize});
                        throw new ControlWarningException(message);
                    }
                    saveResult.add((Object)report);
                }
            }
        }
        catch (ControlWarningException ex) {
            HashSet receivers = Sets.newHashSetWithExpectedSize((int)16);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"querySchemeCreator", (String)"epm_model", (String)"id, creator", (QFilter[])new QFilter("id", "in", (Object)modelIds).toArray(), null);
            Object object = null;
            try {
                while (ds != null && ds.hasNext()) {
                    receivers.add(ds.next().getLong("creator"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            Map<Long, List<Long>> manageUserIds = PermUpgradesUtil.getInstance().getModelManagers(new ArrayList<Long>(modelIds));
            for (List list : manageUserIds.values()) {
                if (list == null || list.isEmpty()) continue;
                receivers.addAll(list);
            }
            String title = ResManager.loadKDString((String)"\u9884\u8b66\u63a7\u5236\u9884\u8b66\u6267\u884c\u5931\u8d25", (String)"ControlWarningDataSourceHelper_3", (String)"epm-eb-business", (Object[])new Object[0]);
            MessageUtils.get().sendMessage("bgc_controlwarnningscheme", title, ex.getMessage(), new ArrayList(receivers), MessageUtils.MessageType.YUNZHIJIA);
            throw new KDBizException(ex.getMessage());
        }
        saveResult.addAll((Collection)result);
        if (!saveResult.isEmpty()) {
            ControlWarningMemberCheckHelper.checkMember(this.usePercent);
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])saveResult.toArray((Object[])new DynamicObject[0])));
            log.info("budget-control-warning-log : time-saveWarn " + (System.currentTimeMillis() - st));
        }
        return result;
    }

    private Map<Long, ControlWarningMemberNode> queryHasMembers(Map<Long, List<ControlWarningScheme>> schemeMap) {
        if (schemeMap == null || schemeMap.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap warnSends = Maps.newHashMap();
        for (List<ControlWarningScheme> schemes : schemeMap.values()) {
            for (ControlWarningScheme scheme : schemes) {
                if (!StringUtils.isNotEmpty((String)scheme.getRule().getSendTime())) continue;
                warnSends.put(scheme.getId(), scheme.getRule().getSendTime());
            }
        }
        return this.innerQueryHasMembers(warnSends);
    }

    protected Map<Long, ControlWarningMemberNode> innerQueryHasMembers(Map<Long, String> warnSends) {
        HashMap result = Maps.newHashMap();
        ControlWarningMessageCompilerHelper helper = new ControlWarningMessageCompilerHelper();
        if (warnSends.isEmpty()) {
            return result;
        }
        DynamicObjectCollection warnCols = ControlWarningHelper.queryHistWarn(warnSends);
        ControlWarningMemberCheckHelper.checkMember(this.usePercent);
        if (warnCols == null || warnCols.isEmpty()) {
            return result;
        }
        Map<String, Map<Long, DynamicObjectCollection>> warnMap = helper.splitWarnMap(warnCols);
        ControlWarningMemberCheckHelper.checkMember(this.usePercent);
        Map<String, Map<Long, List<Map<String, kd.epm.eb.common.cache.impl.Member>>>> memberMap = helper.queryMemberMap(warnMap);
        ControlWarningMemberCheckHelper.checkMember(this.usePercent);
        if (memberMap == null || memberMap.isEmpty()) {
            return result;
        }
        Long modelid = null;
        Long bussmodelid = null;
        IModelCacheHelper cachehelper = null;
        ControlWarningMemberNode node = null;
        ArrayList<Dimension> dimensions = null;
        String[] dimNumbers = null;
        for (Map.Entry<String, Map<Long, List<Map<String, kd.epm.eb.common.cache.impl.Member>>>> memberEntry : memberMap.entrySet()) {
            modelid = helper.getModelId(memberEntry.getKey());
            bussmodelid = helper.getBussModelId(memberEntry.getKey());
            cachehelper = ModelCacheContext.getOrCreate((Long)modelid);
            List<Object> list = dimensions = IDUtils.isNull((Long)bussmodelid) ? cachehelper.getDimensionList() : cachehelper.getDimensionListByBusModel(bussmodelid);
            if (dimensions == null || dimensions.isEmpty()) {
                log.info("budget-control-warning-log : dimensions-is-empty:" + modelid);
                continue;
            }
            dimensions = new ArrayList<Dimension>(dimensions);
            dimensions.removeIf(f -> SysDimensionEnum.InternalCompany.getNumber().equals(f.getNumber()));
            dimNumbers = new String[dimensions.size()];
            int index = 0;
            for (int i = 0; i < dimensions.size(); ++i) {
                if (SysDimensionEnum.Period.getNumber().equals(((Dimension)dimensions.get(i)).getNumber()) || SysDimensionEnum.BudgetPeriod.getNumber().equals(((Dimension)dimensions.get(i)).getNumber())) continue;
                dimNumbers[index++] = ((Dimension)dimensions.get(i)).getNumber();
            }
            for (Map.Entry<Long, List<Map<String, kd.epm.eb.common.cache.impl.Member>>> entry : memberEntry.getValue().entrySet()) {
                node = ControlWarningMemberNode.createRoot(dimNumbers);
                result.put(entry.getKey(), node);
                for (Map<String, kd.epm.eb.common.cache.impl.Member> _memberMap : entry.getValue()) {
                    node.addMember(_memberMap);
                }
            }
        }
        ControlWarningMemberCheckHelper.checkMember(this.usePercent);
        try {
            log.info("budget-control-warning-log : hasMembers = " + JSONUtils.toString((Object)result));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private boolean queryByControlRecord(Long modelId, Long bussModelId, Map<String, Set<Long>> defaultMap, String field, String dimNumber) {
        String controlTable;
        String string = controlTable = IDUtils.isNull((Long)bussModelId) ? "t_eb_bgcontrolrecord" : BizModel.getBgControlRecordTable((Long)bussModelId);
        if (SqlBatchUtils.hasTable((String)controlTable)) {
            SqlBuilder sql = new SqlBuilder();
            sql.append("select distinct " + field + " from " + controlTable, new Object[0]);
            if (IDUtils.isNull((Long)bussModelId)) {
                sql.append(" where fmodelid = ?", new Object[]{modelId});
            }
            HashSet ids = Sets.newHashSet();
            try (DataSet ds = DB.queryDataSet((String)"queryControlRecord", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                ds.forEach(f -> ids.add(f.getLong(field)));
            }
            if (ids.isEmpty()) {
                log.info("budget-control-warning-log : no-" + field + " = " + controlTable);
                return false;
            }
            defaultMap.put(dimNumber, ids);
            return true;
        }
        log.info("budget-control-warning-log : no-table = " + controlTable);
        return false;
    }

    private void queryControlVersion(Map<Long, Map<String, Set<Long>>> defaultMemberList, Set<Long> modelIds) {
        Collection<BizModel> bizModels = this.queryCacheByScenVerNoTime();
        if (bizModels == null) {
            return;
        }
        for (BizModel bizModel : bizModels) {
            if (bizModel.getStartVersion() == null || !modelIds.contains(bizModel.getId())) continue;
            if (IDUtils.isNotNull((long)bizModel.getStartVersion().getLong("bussmodel.id"))) {
                bizModel.setControlBusModelId(Long.valueOf(bizModel.getStartVersion().getLong("bussmodel.id")));
            } else {
                bizModel.setControlBusModelId(Long.valueOf(0L));
            }
            Map membermap = defaultMemberList.computeIfAbsent(bizModel.getKey(), f -> new HashMap(10));
            membermap.computeIfAbsent(SysDimensionEnum.Version.getNumber(), g -> new HashSet(10)).add(bizModel.getStartVersion().getLong("version.id"));
            if (IDUtils.isNotNull((long)bizModel.getStartVersion().getLong("datatype.id"))) {
                membermap.computeIfAbsent(SysDimensionEnum.DataType.getNumber(), f -> new HashSet(10)).add(bizModel.getStartVersion().getLong("datatype.id"));
            } else {
                membermap.computeIfAbsent(SysDimensionEnum.DataType.getNumber(), f -> new HashSet(10)).add(0L);
            }
            if (IDUtils.isNotNull((long)bizModel.getStartVersion().getLong("audittrail.id"))) {
                membermap.computeIfAbsent(SysDimensionEnum.AuditTrail.getNumber(), f -> new HashSet(10)).add(bizModel.getStartVersion().getLong("audittrail.id"));
                continue;
            }
            membermap.computeIfAbsent(SysDimensionEnum.AuditTrail.getNumber(), f -> new HashSet(10)).add(0L);
        }
    }

    protected Collection<BizModel> queryCacheByScenVerNoTime() {
        return CacheServiceHelper.queryCacheByScenVer((Date)new Date());
    }

    private void calcMembers(IModelCacheHelper cachehelper, List<Map<String, String>> members, Map<String, Set<String>> memberList, ControlWarningScheme scheme, Map<String, String> oneMembers, Set<String> dimNumbers, ControlWarningMemberNode node) {
        if (members == null || memberList == null || memberList.isEmpty() || oneMembers == null) {
            return;
        }
        Map.Entry[] entrys = memberList.entrySet().toArray(new Map.Entry[0]);
        Map.Entry accEntry = null;
        int accIndex = -1;
        for (int i = 0; i < entrys.length; ++i) {
            if (!SysDimensionEnum.Account.getNumber().equals(entrys[i].getKey())) continue;
            accEntry = entrys[i];
            accIndex = i;
        }
        if (accIndex > 0) {
            entrys[accIndex] = entrys[0];
            entrys[0] = accEntry;
        }
        this.calcMembers(cachehelper, members, entrys, oneMembers, dimNumbers, node, 0);
    }

    private void calcMembers(IModelCacheHelper cachehelper, List<Map<String, String>> members, Map.Entry<String, Set<String>>[] entrys, Map<String, String> oneMembers, Set<String> dimNumbers, ControlWarningMemberNode node, int index) {
        Map.Entry<String, Set<String>> entry = entrys[index];
        if (!SysDimensionEnum.Account.getNumber().equals(entry.getKey()) && !dimNumbers.contains(entry.getKey())) {
            oneMembers.remove(entry.getKey());
            if (entrys.length - 1 == index) {
                if (node == null || !node.hasMember(oneMembers)) {
                    members.add(new HashMap<String, String>(oneMembers));
                }
            } else {
                this.calcMembers(cachehelper, members, entrys, oneMembers, dimNumbers, node, index + 1);
            }
        } else {
            for (String number : entry.getValue()) {
                if (SysDimensionEnum.Account.getNumber().equals(entry.getKey())) {
                    dimNumbers.clear();
                    kd.epm.eb.common.cache.impl.Member acc = cachehelper.getDimension(SysDimensionEnum.Account.getNumber()).getMember(Long.valueOf(0L), number);
                    if (acc == null) {
                        log.info("budget-control-warning-log :  acc-is-empty: " + number);
                        continue;
                    }
                    Long dataseteid = cachehelper.getDimension(SysDimensionEnum.Account.getNumber()).getMember(Long.valueOf(0L), number).getDatasetId();
                    List dimensions = cachehelper.getDimensionList(dataseteid);
                    if (dimensions == null || dimensions.isEmpty()) {
                        log.info("budget-control-warning-log :  dimensions-is-empty: " + number);
                        continue;
                    }
                    dimensions.forEach(f -> dimNumbers.add(f.getNumber()));
                }
                oneMembers.put(entry.getKey(), number);
                if (entrys.length - 1 == index) {
                    boolean hasMembers;
                    boolean hasIc = oneMembers.containsKey(SysDimensionEnum.InternalCompany.getNumber());
                    boolean bl = hasMembers = node != null && node.hasMember(oneMembers);
                    if (!hasMembers && !hasIc) {
                        oneMembers.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
                        hasMembers = node != null && node.hasMember(oneMembers);
                        oneMembers.remove(SysDimensionEnum.InternalCompany.getNumber());
                    }
                    if (node != null && hasMembers) continue;
                    if (!hasIc) {
                        oneMembers.remove(SysDimensionEnum.InternalCompany.getNumber());
                    }
                    members.add(new HashMap<String, String>(oneMembers));
                    if (members.size() % 50000 == 0) {
                        ControlWarningMemberCheckHelper.checkMember(this.usePercent);
                    }
                    if (members.size() <= this.dataSize * 10000) continue;
                    throw new ControlWarningException("member is too large");
                }
                this.calcMembers(cachehelper, members, entrys, oneMembers, dimNumbers, node, index + 1);
            }
        }
    }

    private void calcMemberList(ControlWarningScheme scheme, @NotNull Map<Long, Map<String, Set<Long>>> defaultMemberList, List<Map<String, String>> members, Map<String, Set<String>> memberList, Map<String, Set<String>> oneMemberList, Map<String, String> oneMembers, Set<String> dimNumbers, ControlWarningMemberNode node, Map<Long, Set<Long>> bailOrgMap, Map<Long, Set<Long>> orgPesonMap) {
        if (scheme == null || memberList == null) {
            return;
        }
        IModelCacheHelper cachehelper = ModelCacheContext.getOrCreate((Long)scheme.getModelId());
        Map<String, Set<Long>> defaultMap = defaultMemberList.get(scheme.getModelKey());
        if (defaultMap == null || defaultMap.isEmpty()) {
            log.info("budget-control-warning-log :  defaultMap-is-empty: " + JSONUtils.toString(defaultMap));
            return;
        }
        log.info("budget-control-warning-log :  defaultMap: " + JSONUtils.toString(defaultMap));
        Dimension dimension = cachehelper.getDimension(SysDimensionEnum.Version.getNumber());
        this.addDefaultMember(memberList, dimension, defaultMap, cachehelper, scheme.getBussModelId());
        dimension = cachehelper.getDimension(SysDimensionEnum.Currency.getNumber());
        HashSet<Long> ids = new HashSet<Long>();
        this.addDefaultMember(memberList, dimension, defaultMap, cachehelper, scheme.getBussModelId());
        dimension = cachehelper.getDimension(SysDimensionEnum.ChangeType.getNumber());
        ids.clear();
        ids.add(cachehelper.getMemberByAnyView(scheme.getBussModelId(), SysDimensionEnum.ChangeType.getNumber(), "CurrentPeriod").getId());
        this.addMember(memberList, dimension, ids, cachehelper, scheme.getBussModelId());
        Set<Long> defIds = null;
        if (!cachehelper.getModelobj().isModelByEB()) {
            dimension = cachehelper.getDimension(SysDimensionEnum.Metric.getNumber());
            this.addDefaultMember(memberList, dimension, defaultMap, cachehelper, scheme.getBussModelId());
            dimension = cachehelper.getDimension(SysDimensionEnum.DataType.getNumber());
            defIds = defaultMap.get(dimension.getNumber());
            if (defIds == null) {
                return;
            }
            if (defIds.contains(0L)) {
                defIds.add(cachehelper.getMemberByAnyView(scheme.getBussModelId(), SysDimensionEnum.DataType.getNumber(), "Budget").getId());
            }
            defIds.remove(0L);
            this.addDefaultMember(memberList, dimension, defaultMap, cachehelper, scheme.getBussModelId());
        }
        if ((defIds = defaultMap.get((dimension = cachehelper.getDimension(SysDimensionEnum.AuditTrail.getNumber())).getNumber())) == null) {
            return;
        }
        if (defIds.contains(0L)) {
            defIds.add(dimension.getMember(Long.valueOf(0L), "ATTotal").getId());
        }
        defIds.remove(0L);
        this.addDefaultMember(memberList, dimension, defaultMap, cachehelper, scheme.getBussModelId());
        dimension = cachehelper.getDimension(SysDimensionEnum.Entity.getNumber());
        List<Long> orgIds = ControlWarningHelper.queryHasReceiverOrg(scheme, scheme.getOrgIds(), bailOrgMap, orgPesonMap);
        if (orgIds == null || orgIds.isEmpty()) {
            log.info("budget-control-warning-log :  orgIds-empty: " + JSONUtils.toString(orgIds));
            return;
        }
        log.info("budget-control-warning-log :  orgIds: " + JSONUtils.toString(orgIds));
        this.addMember(memberList, dimension, scheme.getOrgIds(), cachehelper, scheme.getBussModelId());
        if (!this.fillPeriodMember(memberList, cachehelper)) {
            return;
        }
        int lastCount = 0;
        log.info("budget-control-warning-log :  scheme-size: " + scheme.getEntrys().size());
        boolean isNeedLog = BgControlLogUtils.isNeedLog();
        for (ControlWarningSchemeEntry entry : scheme.getEntrys().values()) {
            oneMemberList.clear();
            oneMemberList.putAll(memberList);
            if (isNeedLog) {
                log.info("budget-control-warning-log : entry.getMemberMap(): " + JSONUtils.toString(entry.getMemberMap()));
            }
            for (Map.Entry<Long, List<Long>> mEntry : entry.getMemberMap().entrySet()) {
                dimension = cachehelper.getDimension(mEntry.getKey());
                this.addMember(oneMemberList, dimension, (Collection<Long>)mEntry.getValue(), cachehelper, scheme.getBussModelId());
            }
            oneMembers.clear();
            if (isNeedLog) {
                log.info("budget-control-warning-log : oneMemberList: " + JSONUtils.toString(oneMemberList));
            }
            this.calcMembers(cachehelper, members, oneMemberList, scheme, oneMembers, dimNumbers, node);
            if (isNeedLog) {
                log.info("budget-control-warning-log : members.size: " + members.size());
            }
            if (members.size() - lastCount <= 50000) continue;
            ControlWarningMemberCheckHelper.checkMember(this.usePercent);
            lastCount = members.size();
        }
    }

    private void addDefaultMember(Map<String, Set<String>> memberList, Dimension dimension, Map<String, Set<Long>> defaultMap, IModelCacheHelper modelcache, Long bussModelId) {
        if (dimension == null) {
            return;
        }
        if (defaultMap.get(dimension.getNumber()) == null || defaultMap.get(dimension.getNumber()).isEmpty()) {
            log.info("budget-control-warning-log :  defaultMap-" + dimension.getNumber() + "-is-empty: " + JSONUtils.toString(defaultMap));
            return;
        }
        this.addMember(memberList, dimension, (Collection<Long>)defaultMap.get(dimension.getNumber()), modelcache, bussModelId);
    }

    private boolean fillPeriodMember(Map<String, Set<String>> memberList, IModelCacheHelper cachehelper) {
        CalendarHelper helper = new CalendarHelper();
        helper.setTime(this.getCurrentDate());
        BgPeriodUserDefinedUtils utils = new BgPeriodUserDefinedUtils(cachehelper.getModelobj().getId());
        if (cachehelper.getModelobj().isModelByEB()) {
            Dimension dimension = cachehelper.getDimension(SysDimensionEnum.Year.getNumber());
            String year = BgPeriodUtils.getPeriodYear((int)helper.getCurrentlyYear());
            kd.epm.eb.common.cache.impl.Member m = dimension.getMember(Long.valueOf(0L), year);
            if (m == null) {
                log.info("budget-control-warning-log :  year-not-found: " + year);
                return false;
            }
            this.addMember(memberList, dimension, Lists.newArrayList((Object[])new Long[]{m.getId()}), cachehelper, 0L);
            dimension = cachehelper.getDimension(SysDimensionEnum.Period.getNumber());
            String periodNumber = BgPeriodUtils.getPeriodMonth((int)helper.getCurrentlyMonth());
            m = dimension.getMember(Long.valueOf(0L), periodNumber);
            if (m == null) {
                log.info("budget-control-warning-log :  period-not-fofoundunt: " + year);
                return false;
            }
            this.addMember(memberList, dimension, Lists.newArrayList((Object[])new Long[]{m.getId()}), cachehelper, 0L);
            periodNumber = "M_YearTotal";
            m = dimension.getMember(Long.valueOf(0L), periodNumber);
            if (m == null) {
                log.info("budget-control-warning-log :  period-not-found: " + year);
                return false;
            }
            this.addMember(memberList, dimension, Lists.newArrayList((Object[])new Long[]{m.getId()}), cachehelper, 0L);
        } else {
            kd.epm.eb.common.cache.impl.Member m;
            Dimension dimension = cachehelper.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
            String periodNumber = BgPeriodUtils.getBgPeriodMonth((int)helper.getCurrentlyYear(), (int)helper.getCurrentlyMonth());
            if (utils.isPeriodUserDefine()) {
                periodNumber = utils.getPeriodNumber(BgControlPeriodTypeEnum.MONTH.getIndex(), helper.getTime());
            }
            if ((m = dimension.getMember(Long.valueOf(0L), periodNumber)) == null) {
                log.info("budget-control-warning-log :  budgetperiod-not-found: " + periodNumber);
                return false;
            }
            this.addMember(memberList, dimension, Lists.newArrayList((Object[])new Long[]{m.getId()}), cachehelper, 0L);
            periodNumber = BgPeriodUtils.getPeriodYear((int)helper.getCurrentlyYear());
            if (utils.isPeriodUserDefine()) {
                periodNumber = utils.getPeriodNumber(BgControlPeriodTypeEnum.YEAR.getIndex(), helper.getTime());
            }
            if ((m = dimension.getMember(Long.valueOf(0L), periodNumber)) == null) {
                log.info("budget-control-warning-log :  budgetperiod-not-found: " + periodNumber);
                return false;
            }
            this.addMember(memberList, dimension, Lists.newArrayList((Object[])new Long[]{m.getId()}), cachehelper, 0L);
        }
        return true;
    }

    protected Date getCurrentDate() {
        return new Date();
    }

    private void addMember(Map<String, Set<String>> memberList, Dimension dimension, Collection<Long> orgIds, IModelCacheHelper modelcache, Long bussModelId) {
        if (orgIds == null || orgIds.isEmpty() || dimension == null || memberList == null) {
            return;
        }
        Set numbers = memberList.computeIfAbsent(dimension.getNumber(), f -> new HashSet(16));
        orgIds.forEach(f -> {
            kd.epm.eb.common.cache.impl.Member member = modelcache.getMemberByAnyView(bussModelId, dimension.getNumber(), f);
            if (member == null) {
                try {
                    member = modelcache.getMember(dimension.getNumber(), modelcache.getViewByBusModelAndDimNumber(bussModelId, dimension.getNumber()), f);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (member != null) {
                numbers.add(member.getNumber());
            } else {
                log.info("budget-control-warning-log : bussmodelid: " + bussModelId);
                log.info("budget-control-warning-log : " + dimension.getNumber() + "-not-found: " + f);
            }
        });
    }

    private void getData(@NotNull DynamicObjectCollection result, @NotNull ControlWarningScheme scheme, @NotNull DynamicObject report, @NotNull List<Map<String, String>> members, Long bussModelId) {
        if (members == null || members.isEmpty()) {
            return;
        }
        ArrayList<Map<String, String>> detail = new ArrayList<Map<String, String>>(members.size() / 2);
        ArrayList<Map<String, String>> year = new ArrayList<Map<String, String>>(members.size() / 2);
        String pNumber = null;
        String yearNumber = null;
        IModelCacheHelper cache = ModelCacheContext.getOrCreate((Long)scheme.getModelId());
        BgPeriodUserDefinedUtils utils = new BgPeriodUserDefinedUtils(scheme.getModelId());
        String yearEnd = null;
        if (cache.getModelobj().isModelByEB()) {
            yearEnd = BgPeriodUtils.getPeriodMonth((int)12);
        } else if (!utils.isPeriodUserDefine()) {
            yearEnd = BgPeriodUtils.getBgPeriodMonth((int)new CalendarHelper(this.getCurrentDate()).getCurrentlyYear(), (int)12);
        }
        for (Map<String, String> member : members) {
            pNumber = member.get(SysDimensionEnum.BudgetPeriod.getNumber());
            if (pNumber == null) {
                pNumber = member.get(SysDimensionEnum.Period.getNumber());
            }
            if (ControlWarningRule.checkIsYear(pNumber)) {
                yearNumber = pNumber;
                if (cache.getModelobj().isModelByEB()) {
                    member.put(SysDimensionEnum.Period.getNumber(), yearEnd);
                } else if (utils.isPeriodUserDefine()) {
                    member.put(SysDimensionEnum.BudgetPeriod.getNumber(), utils.getPeriodNumber(BgControlPeriodTypeEnum.MONTH.getIndex(), utils.parseEndBizTime(pNumber)));
                } else {
                    member.put(SysDimensionEnum.BudgetPeriod.getNumber(), yearEnd);
                }
                year.add(member);
                continue;
            }
            detail.add(member);
        }
        HashSet<String> types = new HashSet<String>(1);
        types.add(BgControlSettingTypeEnum.MONTH.getNumber());
        Collection<IBudgetBalance> balances = new BgControlCallerImpl().queryBalance(scheme.getModelId(), detail, types, scheme.getRule().isQueryControlSet(), scheme.getRule().isQueryControlSet(), true, bussModelId, false);
        if (balances == null || balances.isEmpty() || scheme.getRule() == null) {
            return;
        }
        types.clear();
        types.add(BgControlSettingTypeEnum.MONTH.getNumber());
        log.info("queryBalance:" + JSONUtils.toString(year));
        Collection<IBudgetBalance> _balances = new BgControlCallerImpl().queryBalance(scheme.getModelId(), year, types, scheme.getRule().isQueryControlSet(), scheme.getRule().isQueryControlSet(), true, bussModelId, false);
        if (_balances != null && !_balances.isEmpty() && yearNumber != null) {
            Member yearMember = null;
            if (cache.getModelobj().isModelByEB()) {
                yearMember = Member.loadFormCache((kd.epm.eb.common.cache.impl.Member)cache.getMember(SysDimensionEnum.Period.getNumber(), null, yearNumber));
                yearMember.setDimension(kd.epm.eb.common.model.Dimension.loadFormCache((Dimension)cache.getDimension(SysDimensionEnum.Period.getNumber())));
            } else {
                yearMember = Member.loadFormCache((kd.epm.eb.common.cache.impl.Member)cache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, yearNumber));
                yearMember.setDimension(kd.epm.eb.common.model.Dimension.loadFormCache((Dimension)cache.getDimension(SysDimensionEnum.BudgetPeriod.getNumber())));
            }
            for (IBudgetBalance balance : _balances) {
                balance.setMember(true, yearMember);
                balance.setMember(false, yearMember);
            }
        }
        if (_balances != null) {
            balances.addAll(_balances);
        }
        scheme.getRule().checkWarning(result, report, balances);
    }

    public List<Map<String, Object>> getCommonFilterColumns() {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bgc_controlwarnningscheme");
        return this.getFilterFields(entityType);
    }

    public Set<String> getRegistField(String entityNumber) {
        HashSet registField = Sets.newHashSet((Object[])new String[]{"number", "name", "remark", "warnningrule", "warnningmsg", "modifier", "modifydate"});
        return registField;
    }
}

