/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.warning;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.warning.ControlWarnDataCompartor;
import kd.epm.eb.control.warning.ControlWarningConstant;
import kd.epm.eb.control.warning.ControlWarningMessageCompilerHelper;
import kd.epm.eb.control.warning.ControlWarningReceiver;
import kd.epm.eb.control.warning.ControlWarningRule;
import kd.epm.eb.control.warning.ControlWarningScheme;
import org.jetbrains.annotations.NotNull;

public class ControlWarningHelper {
    private static final Log log = LogFactory.getLog(ControlWarningHelper.class);
    private static Map<String, Set<String>> fields = Maps.newHashMap();

    public static Map<Long, ControlWarningScheme> queryWarningScheme(Set<Long> ids) {
        ControlWarningReceiver receiver;
        Object _scheme2;
        Object ms3;
        Object ms22;
        HashMap schemes = Maps.newHashMap();
        Lang lang = RequestContext.get().getLang();
        List rstList = null;
        Long id = null;
        SqlBuilder sql = new SqlBuilder();
        sql.append("select a.fid,a.fnumber,a.fwarnningrule,a.fwarnningmsg,l.fwarnningmsg as fwarnningmsglang,a.fmodel,a.fbusinessmodel,a.funit,a.fprecision from t_eb_warnningscheme a left join t_eb_warnningscheme_l l on (a.fid=l.fid) where a.fstatus = '1' and l.flocaleid= '" + lang.toString() + "'", new Object[0]);
        DataSet ds = DB.queryDataSet((String)"queryWarnScheme", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        Object object = null;
        try {
            rstList = CommonServiceHelper.transDataSet((DataSet)ds);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (rstList == null || rstList.isEmpty()) {
            return schemes;
        }
        ControlWarningScheme scheme = null;
        for (Object ms22 : rstList) {
            if (ms22 == null) continue;
            scheme = new ControlWarningScheme((Map<String, Object>)ms22);
            if (ids != null && !ids.contains(scheme.getId())) continue;
            schemes.put(scheme.getId(), scheme);
        }
        sql = new SqlBuilder();
        sql.append("select fid,fentity,frange,fisexclude from t_eb_warnningentity where fid in(select fid from t_eb_warnningscheme where fstatus = '1')", new Object[0]);
        DataSet ds2 = DB.queryDataSet((String)"queryWarnEntity", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        ms22 = null;
        try {
            rstList = CommonServiceHelper.transDataSet((DataSet)ds2);
        }
        catch (Throwable throwable) {
            ms22 = throwable;
            throw throwable;
        }
        finally {
            if (ds2 != null) {
                if (ms22 != null) {
                    try {
                        ds2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)ms22).addSuppressed(throwable);
                    }
                } else {
                    ds2.close();
                }
            }
        }
        HashSet<Long> noScheme = new HashSet<Long>(10);
        if (rstList != null && !rstList.isEmpty()) {
            for (Object ms3 : rstList) {
                if (ms3 == null) continue;
                id = IDUtils.toLong(ms3.get("fid"));
                if (schemes.get(id) == null) {
                    if (!noScheme.contains(id)) {
                        log.info("budget-control-warning-log : not-scheme- = " + id);
                    }
                    noScheme.add(id);
                    continue;
                }
                ((ControlWarningScheme)schemes.get(id)).addOrgRange(IDUtils.toLong(ms3.get("fentity")), Convert.toInt(ms3.get("frange")), Convert.toBool(ms3.get("fisexclude")));
            }
        }
        for (Object _scheme2 : schemes.values()) {
            ((ControlWarningScheme)_scheme2).buildOrgIds();
        }
        sql = new SqlBuilder();
        sql.append("select t0.fid,t1.fentryid,t1.fmember,t1.fdimensiontreemodel,t1.fdimension,t1.fscope from t_eb_warnningtarget t0 inner join t_eb_warnningtargetentity t1 on t0.fentryid = t1.fentryid where t0.fid in (select fid from t_eb_warnningscheme where fstatus = '1')", new Object[0]);
        Object ds3 = DB.queryDataSet((String)"queryWarnMember", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        _scheme2 = null;
        try {
            rstList = CommonServiceHelper.transDataSet((DataSet)ds3);
        }
        catch (Throwable throwable) {
            _scheme2 = throwable;
            throw throwable;
        }
        finally {
            if (ds3 != null) {
                if (_scheme2 != null) {
                    try {
                        ds3.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)_scheme2).addSuppressed(throwable);
                    }
                } else {
                    ds3.close();
                }
            }
        }
        noScheme.clear();
        if (rstList != null && !rstList.isEmpty()) {
            for (Object ms3 : rstList) {
                if (ms3 == null) continue;
                id = IDUtils.toLong(ms3.get("fid"));
                if (schemes.get(id) == null) {
                    if (!noScheme.contains(id)) {
                        log.info("budget-control-warning-log : not-scheme- = " + id);
                    }
                    noScheme.add(id);
                    continue;
                }
                ((ControlWarningScheme)schemes.get(id)).addMember(IDUtils.toLong(ms3.get("fentryid")), IDUtils.toLong(ms3.get("fdimension")), IDUtils.toLong(ms3.get("fmember")), Convert.toInt(ms3.get("fscope")));
            }
        }
        sql = new SqlBuilder();
        sql.append("select t0.fid,t1.fwarningsendtype,t1.fcondition from t_eb_warnningscheme t0 inner join t_eb_controlwarningrule t1 on t0.fwarnningrule = t1.fid where t0.fstatus = '1'", new Object[0]);
        ds3 = DB.queryDataSet((String)"queryWarnRule", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        ms3 = null;
        try {
            rstList = CommonServiceHelper.transDataSet((DataSet)ds3);
        }
        catch (Throwable throwable) {
            ms3 = throwable;
            throw throwable;
        }
        finally {
            if (ds3 != null) {
                if (ms3 != null) {
                    try {
                        ds3.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)ms3).addSuppressed(throwable);
                    }
                } else {
                    ds3.close();
                }
            }
        }
        noScheme.clear();
        if (rstList != null && !rstList.isEmpty()) {
            for (Object ms3 : rstList) {
                if (ms3 == null) continue;
                id = IDUtils.toLong(ms3.get("fid"));
                if (schemes.get(id) == null) {
                    if (!noScheme.contains(id)) {
                        log.info("budget-control-warning-log : not-scheme- = " + id);
                    }
                    noScheme.add(id);
                    continue;
                }
                ((ControlWarningScheme)schemes.get(id)).getRule().setSendType((String)ms3.get("fwarningsendtype"));
                ((ControlWarningScheme)schemes.get(id)).getRule().setCondition((String)ms3.get("fcondition"));
            }
        }
        HashMap recMap = Maps.newHashMap();
        sql = new SqlBuilder();
        sql.append("select t0.fid,t0.forgtype,t0.fisdefault,t1.fbgorgview,t1.forgtypeitem,t1.fbgorgview,t1.fstatus,t1.forg,t2.fbasedataid ", new Object[0]);
        sql.append("from t_eb_recipientmapping t0 left join t_eb_recipientmapentry t1 on t0.fid = t1.fid left join t_eb_recipientmapperson t2 on t1.fentryid = t2.fentryid ", new Object[0]);
        sql.append("where t0.fid in (select fbasedataid from t_eb_warnningreceiver where fid in (select fid from t_eb_warnningscheme where fstatus = '1'))", new Object[0]);
        DataSet ds4 = DB.queryDataSet((String)"queryWarnReceiver", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        Iterator iterator = null;
        try {
            rstList = CommonServiceHelper.transDataSet((DataSet)ds4);
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (ds4 != null) {
                if (iterator != null) {
                    try {
                        ds4.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    ds4.close();
                }
            }
        }
        if (rstList != null) {
            receiver = null;
            for (Map rec : rstList) {
                id = IDUtils.toLong(rec.get("fid"));
                receiver = recMap.computeIfAbsent(id, f -> new ControlWarningReceiver(rec));
                receiver.buildReciever(rec);
            }
        }
        sql = new SqlBuilder();
        sql.append("select fid,fbasedataid from t_eb_warnningreceiver where fid in (select fid from t_eb_warnningscheme where fstatus = '1')", new Object[0]);
        ds4 = DB.queryDataSet((String)"queryWarnSchemeReceiver", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        iterator = null;
        try {
            rstList = CommonServiceHelper.transDataSet((DataSet)ds4);
        }
        catch (Throwable rec) {
            iterator = rec;
            throw rec;
        }
        finally {
            if (ds4 != null) {
                if (iterator != null) {
                    try {
                        ds4.close();
                    }
                    catch (Throwable rec) {
                        ((Throwable)((Object)iterator)).addSuppressed(rec);
                    }
                } else {
                    ds4.close();
                }
            }
        }
        noScheme.clear();
        if (rstList != null) {
            receiver = null;
            for (Map rec : rstList) {
                id = IDUtils.toLong(rec.get("fbasedataid"));
                receiver = (ControlWarningReceiver)recMap.get(id);
                if (receiver == null) {
                    log.info("budget-control-warning-log : not-receiver- = " + id);
                    continue;
                }
                id = IDUtils.toLong(rec.get("fid"));
                if (schemes.get(id) == null) {
                    if (!noScheme.contains(id)) {
                        log.info("budget-control-warning-log : not-scheme- = " + id);
                    }
                    noScheme.add(id);
                    continue;
                }
                scheme = (ControlWarningScheme)schemes.get(id);
                for (String type : receiver.getTypes()) {
                    scheme.getReceivers().computeIfAbsent(type, f -> Lists.newArrayList()).add(receiver);
                }
            }
        }
        return schemes;
    }

    public static Map<String, BigDecimal> getValues(DynamicObject dynamicObject) {
        HashMap values = Maps.newHashMap();
        if (dynamicObject == null) {
            return values;
        }
        for (DynamicObject value : dynamicObject.getDynamicObjectCollection("subentryentity")) {
            values.put(value.getString("type"), value.getBigDecimal("value"));
        }
        return values;
    }

    public static DynamicObject buildReportHead(ControlWarningScheme scheme, String time, Long warningId, Long receiver) {
        DynamicObject report = BusinessDataServiceHelper.newDynamicObject((String)"bgc_warningreport");
        report.set("model", (Object)scheme.getModelId());
        report.set("bussmodel", (Object)scheme.getBussModelId());
        report.set("time", (Object)time);
        report.set("warnscheme", (Object)scheme.getId());
        report.set("earlywarn", (Object)warningId);
        report.set("receiver", (Object)receiver);
        report.set("unit", (Object)String.valueOf(scheme.getUnit().getIndex()));
        report.set("precision", (Object)scheme.getPrecision());
        return report;
    }

    private static Set<String> getFields(DynamicObject entry) {
        if (entry == null) {
            return Sets.newHashSet();
        }
        if (fields.get(entry.getDataEntityType().getName()) == null) {
            Set _fields = fields.computeIfAbsent(entry.getDataEntityType().getName(), f -> Sets.newHashSet());
            for (IDataEntityProperty prop : entry.getDataEntityType().getProperties()) {
                if ("id".equals(prop.getName()) || "seq".equals(prop.getName())) continue;
                _fields.add(prop.getName());
            }
        }
        return fields.get(entry.getDataEntityType().getName());
    }

    public static Collection<? extends DynamicObject> splitByReceiver(ControlWarningScheme scheme, String time, DynamicObject report, @NotNull Map<Long, Set<Long>> bailOrgMap, @NotNull Map<Long, Set<Long>> orgPesonMap) {
        HashMap result = Maps.newHashMap();
        List<Long> receivers = null;
        DynamicObject oneReport = null;
        HashSet<Long> entityids = new HashSet<Long>(16);
        for (DynamicObject entry : report.getDynamicObjectCollection("entryentity")) {
            entityids.add(entry.getLong("orgunit"));
        }
        for (DynamicObject entry : report.getDynamicObjectCollection("entryentity")) {
            Long bgorgunitid = entry.getLong("orgunit");
            receivers = ControlWarningHelper.getReceivers(bgorgunitid, scheme, entityids, bailOrgMap, orgPesonMap);
            if (receivers == null || receivers.isEmpty()) continue;
            for (Long userid : receivers) {
                oneReport = result.computeIfAbsent(userid, f -> ControlWarningHelper.buildReportHead(scheme, time, report.getLong("earlywarn"), userid));
                DynamicObject entryClone = oneReport.getDynamicObjectCollection("entryentity").addNew();
                ControlWarningHelper.copy(entryClone, entry);
            }
        }
        return result.values();
    }

    private static List<Long> getReceivers(Long bgorgunitid, ControlWarningScheme scheme, Collection<Long> entityids, @NotNull Map<Long, Set<Long>> bailOrgMap, @NotNull Map<Long, Set<Long>> orgPesonMap) {
        if (IDUtils.isNull((Long)bgorgunitid) || scheme == null || entityids == null || entityids.isEmpty() || bailOrgMap == null || orgPesonMap == null) {
            return null;
        }
        HashMap receivers = Maps.newHashMap();
        for (String type : ControlWarningReceiver.RECEIVERS) {
            List<ControlWarningReceiver> receiverList = scheme.getReceivers().get(type);
            if (receiverList == null || receiverList.isEmpty()) continue;
            if ("admin".equals(type) || "default".equals(type)) {
                ControlWarningHelper.queryBailOrg(new HashSet<Long>(entityids), bailOrgMap);
            }
            if ("default".equals(type)) {
                ControlWarningHelper.queryOrgPerson(bailOrgMap, orgPesonMap);
            }
            for (ControlWarningReceiver receiver : receiverList) {
                if (receiver == null) continue;
                receiver.receiver(bgorgunitid, receivers, type, bailOrgMap, orgPesonMap);
            }
            if (receivers.get(type) == null || ((List)receivers.get(type)).isEmpty()) continue;
            return (List)receivers.get(type);
        }
        return null;
    }

    public static List<Long> queryHasReceiverOrg(ControlWarningScheme scheme, List<Long> orgIds, @NotNull Map<Long, Set<Long>> bailOrgMap, @NotNull Map<Long, Set<Long>> orgPesonMap) {
        if (scheme == null || orgIds == null || bailOrgMap == null || orgPesonMap == null) {
            return null;
        }
        if (orgIds.isEmpty()) {
            return orgIds;
        }
        ArrayList<Long> result = new ArrayList<Long>(orgIds.size());
        List<Long> receivers = null;
        for (Long orgId : orgIds) {
            receivers = ControlWarningHelper.getReceivers(orgId, scheme, orgIds, bailOrgMap, orgPesonMap);
            if (receivers == null || receivers.isEmpty()) continue;
            result.add(orgId);
        }
        return result;
    }

    private static void queryOrgPerson(@NotNull Map<Long, Set<Long>> bailOrgMap, @NotNull Map<Long, Set<Long>> orgPesonMap) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (Set<Long> oids : bailOrgMap.values()) {
            if (oids == null) continue;
            orgIds.addAll(oids);
        }
        orgIds.removeAll(orgPesonMap.keySet());
        if (!orgIds.isEmpty()) {
            Set<Long> oids;
            DataSet ds = QueryServiceHelper.queryDataSet((String)"queryPersonWarning", (String)"bos_user", (String)"entryentity,entryentity.dpt.id,id", (QFilter[])QFBuilder.newQFilter().add("entryentity.dpt.id", "in", orgIds).add("entryentity.isincharge", "=", (Object)Boolean.TRUE).toArray(), null);
            oids = null;
            try {
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    Long depid = row.getLong("entryentity.dpt.id");
                    orgPesonMap.computeIfAbsent(depid, f -> new HashSet(10)).add(row.getLong("id"));
                }
            }
            catch (Throwable throwable) {
                oids = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (oids != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)oids)).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        Iterator<Set<Long>> iterator = orgIds.iterator();
        while (iterator.hasNext()) {
            long orgId = (Long)((Object)iterator.next());
            if (orgPesonMap.containsKey(orgId)) continue;
            orgPesonMap.put(orgId, new HashSet(1));
        }
    }

    private static void queryBailOrg(Collection<Long> entityids, Map<Long, Set<Long>> bailOrgMap) {
        if (entityids.isEmpty()) {
            return;
        }
        entityids.removeAll(bailOrgMap.keySet());
        if (entityids.isEmpty()) {
            return;
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryBailOrgWarning", (String)"eb_bailorg_entity", (String)"entity.id,entryentity,entryentity.bailorg,entryentity.bailorg.id", (QFilter[])QFBuilder.newQFilter().add("entity.id", "in", entityids).toArray(), null);){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long entityId = row.getLong("entity.id");
                Long bailOrgId = row.getLong("entryentity.bailorg.id");
                if (!IDUtils.isNotNull((Long)bailOrgId)) continue;
                bailOrgMap.computeIfAbsent(entityId, f -> new HashSet(16)).add(bailOrgId);
            }
        }
        for (Long entityId : entityids) {
            if (bailOrgMap.containsKey(entityId)) continue;
            bailOrgMap.put(entityId, new HashSet(1));
        }
    }

    private static void copy(DynamicObject entryClone, DynamicObject entry) {
        Set<String> fields = ControlWarningHelper.getFields(entry);
        Object obj = null;
        for (String field : fields) {
            obj = entry.get(field);
            if (obj == null) continue;
            if (obj instanceof DynamicObjectCollection) {
                DynamicObjectCollection doc = (DynamicObjectCollection)obj;
                for (DynamicObject _entry : doc) {
                    ControlWarningHelper.copy(entryClone.getDynamicObjectCollection(field).addNew(), _entry);
                }
                continue;
            }
            entryClone.set(field, obj);
        }
    }

    public static DynamicObjectCollection queryHistWarn(Map<Long, String> warnSchemes) {
        Set<String> fields = ControlWarningHelper.getFields(BusinessDataServiceHelper.newDynamicObject((String)"bgc_warningreport").getDynamicObjectCollection("entryentity").addNew());
        if (fields == null || fields.isEmpty() || warnSchemes.isEmpty()) {
            return new DynamicObjectCollection();
        }
        fields = new HashSet<String>(fields);
        for (String f2 : ControlWarningConstant.ENTRY_COLL_FIELDS) {
            fields.remove(f2);
        }
        HashSet _fields = Sets.newHashSet();
        fields.forEach(f -> _fields.add("entryentity." + f));
        QFilter qf = new QFilter("warnscheme", "in", new HashSet<Long>(warnSchemes.keySet()));
        qf.and(new QFilter("time", "in", new HashSet<String>(warnSchemes.values())));
        DynamicObjectCollection warnCol = QueryServiceHelper.query((String)"bgc_warningreport", (String)("id,warnscheme,model,bussmodel,time,entryentity.id," + StringUtils.join((Collection)_fields, (String)",")), (QFilter[])qf.toArray());
        if (warnCol == null || warnCol.isEmpty()) {
            log.info("budget-control-warning-log : empty-report");
            return new DynamicObjectCollection();
        }
        log.info("budget-control-warning-log : report-size=" + warnCol.size());
        HashMap warnMap = Maps.newHashMap();
        HashMap warnEntryMap = Maps.newHashMap();
        Long warnschemeid = null;
        Long id = null;
        Long entryid = null;
        DynamicObject newWarn = null;
        DynamicObject newWarnEntry = null;
        DynamicObject userObj = null;
        for (DynamicObject warn : warnCol) {
            warnschemeid = warn.getLong("warnscheme");
            id = warn.getLong("id");
            if (!warn.getString("time").equals(warnSchemes.get(warnschemeid))) continue;
            newWarn = (DynamicObject)warnMap.get(id);
            if (newWarn == null) {
                newWarn = BusinessDataServiceHelper.newDynamicObject((String)"bgc_warningreport");
                newWarn.set("id", (Object)id);
                newWarn.set("warnscheme", warn.get("warnscheme"));
                newWarn.set("model", warn.get("model"));
                newWarn.set("bussmodel", warn.get("bussmodel"));
                newWarn.set("time", warn.get("time"));
                warnMap.put(id, newWarn);
            }
            newWarnEntry = newWarn.getDynamicObjectCollection("entryentity").addNew();
            entryid = warn.getLong("entryentity.id");
            newWarn.set("id", (Object)entryid);
            warnEntryMap.put(entryid, newWarnEntry);
            for (String field : fields) {
                newWarnEntry.set(field, warn.get("entryentity." + field));
            }
        }
        String userDef = "entryentity.userdefineds";
        qf.and(new QFilter("entryentity.userdefineds.dimension", "is not null", null));
        DynamicObjectCollection warnUserDefCol = QueryServiceHelper.query((String)"bgc_warningreport", (String)("entryentity.id," + userDef + ".dimension," + userDef + ".member"), (QFilter[])qf.toArray());
        if (warnUserDefCol != null && !warnUserDefCol.isEmpty()) {
            log.info("budget-control-warning-log : report-userdef-size=" + warnCol.size());
            for (DynamicObject obj : warnUserDefCol) {
                entryid = obj.getLong("entryentity.id");
                newWarnEntry = (DynamicObject)warnEntryMap.get(entryid);
                userObj = newWarnEntry.getDynamicObjectCollection("userdefineds").addNew();
                userObj.set("dimension", obj.get(userDef + ".dimension"));
                userObj.set("member", obj.get(userDef + ".member"));
            }
        } else {
            log.info("budget-control-warning-log : report-userdef-empty");
        }
        DynamicObjectCollection result = new DynamicObjectCollection(BusinessDataServiceHelper.newDynamicObject((String)"bgc_warningreport").getDynamicObjectType(), null);
        result.addAll(warnMap.values());
        return result;
    }

    public static List<Map<String, Object>> queryWarnDatas(Set<Long> warnIds, boolean isNeedName, boolean isMob) {
        ArrayList warnDatas = Lists.newArrayList();
        if (warnIds == null || warnIds.isEmpty()) {
            return warnDatas;
        }
        Map _warnMap = BusinessDataServiceHelper.loadFromCache((Object[])warnIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bgc_warningreport").getDynamicObjectType());
        if (_warnMap == null || _warnMap.isEmpty()) {
            return warnDatas;
        }
        DynamicObjectCollection warnCol = new DynamicObjectCollection();
        warnCol.addAll(_warnMap.values());
        ControlWarningMessageCompilerHelper helper = new ControlWarningMessageCompilerHelper();
        Map<String, Map<Long, DynamicObjectCollection>> warnMap = helper.splitWarnMap(warnCol);
        ArrayList subDatas = Lists.newArrayList();
        HashMap subDataMap = Maps.newHashMap();
        Long modelid = null;
        Long bussmodelid = null;
        Long metricid = null;
        IModelCacheHelper cachehelper = null;
        List dimensions = null;
        ArrayList<String> itemDimNumber = new ArrayList<String>(16);
        ArrayList<String> itemDimName = new ArrayList<String>(16);
        Map<String, Map<Long, List<Map<String, Member>>>> memberMap = helper.queryMemberMap(warnMap);
        Map<Long, List<Map<String, Member>>> subMemberMap = null;
        List<Map<String, Member>> subMemberList = null;
        Map<String, Member> oneMemberMap = null;
        Member member = null;
        Map<String, BigDecimal> oneData = null;
        Object[] itemNumbers = null;
        String[] itemNames = null;
        StringBuilder item = new StringBuilder();
        StringBuilder memberKey = new StringBuilder();
        HashSet<Long> needUnitIds = new HashSet<Long>(16);
        for (Map.Entry<String, Map<Long, DynamicObjectCollection>> modelEntry : warnMap.entrySet()) {
            modelid = helper.getModelId(modelEntry.getKey());
            needUnitIds.add(modelid);
        }
        if (!needUnitIds.isEmpty()) {
            QFilter qf = new QFilter("model", "in", needUnitIds);
            qf.and("datatype", "in", (Object)Sets.newHashSet((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex()}));
            DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMetric", (String)"epm_metricmembertree", (String)"id", (QFilter[])qf.toArray(), null);
            Iterator<Map.Entry<Long, DynamicObjectCollection>> iterator = null;
            try {
                needUnitIds.clear();
                ds.forEach(f -> needUnitIds.add(f.getLong("id")));
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (iterator != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        for (Map.Entry<String, Map<Long, DynamicObjectCollection>> modelEntry : warnMap.entrySet()) {
            modelid = helper.getModelId(modelEntry.getKey());
            bussmodelid = helper.getBussModelId(modelEntry.getKey());
            cachehelper = ModelCacheContext.getOrCreate((Long)modelid);
            itemDimNumber.clear();
            itemDimNumber.add(SysDimensionEnum.Entity.getNumber());
            if (StringUtils.isEmpty((String)SysDimensionEnum.Entity.getChineseName())) {
                itemDimName.add(SysDimensionEnum.Entity.getNumber());
            } else {
                itemDimName.add(SysDimensionEnum.Entity.getChineseName());
            }
            itemDimNumber.add(SysDimensionEnum.Account.getNumber());
            if (StringUtils.isEmpty((String)SysDimensionEnum.Account.getChineseName())) {
                itemDimName.add(SysDimensionEnum.Account.getNumber());
            } else {
                itemDimName.add(SysDimensionEnum.Account.getChineseName());
            }
            if ((dimensions = IDUtils.isNull((Long)bussmodelid) ? cachehelper.getDimensionList() : cachehelper.getDimensionListByBusModel(bussmodelid)) == null || dimensions.isEmpty()) continue;
            for (Dimension dim : dimensions) {
                if (!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dim)) continue;
                itemDimNumber.add(dim.getNumber());
                if (StringUtils.isEmpty((String)dim.getName())) {
                    itemDimName.add(dim.getNumber());
                    continue;
                }
                itemDimName.add(dim.getName());
            }
            subDatas.clear();
            subDataMap.clear();
            subMemberMap = memberMap.get(modelEntry.getKey());
            if (subMemberMap == null || subMemberMap.isEmpty()) {
                log.info("budget-control-warning-log : not-found-subMemberMap = " + modelEntry.getKey());
                continue;
            }
            for (Map.Entry<Long, DynamicObjectCollection> docEntry : modelEntry.getValue().entrySet()) {
                subMemberList = subMemberMap.get(docEntry.getKey());
                if (subMemberList == null || subMemberList.isEmpty()) {
                    log.info("budget-control-warning-log : not-found-subMemberList = " + docEntry.getKey());
                    continue;
                }
                int index = 0;
                block13: for (DynamicObject warnObj : docEntry.getValue()) {
                    for (DynamicObject warnEntry : warnObj.getDynamicObjectCollection("entryentity")) {
                        if (index > subMemberList.size() - 1) {
                            log.info("budget-control-warning-log : subMemberList-index-out = " + index);
                            continue block13;
                        }
                        oneMemberMap = subMemberList.get(index++);
                        memberKey.setLength(0);
                        itemNumbers = oneMemberMap.keySet().toArray(new String[0]);
                        Arrays.sort(itemNumbers);
                        for (Object dimNumber : itemNumbers) {
                            if (SysDimensionEnum.Year.getNumber().equals(dimNumber) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) || SysDimensionEnum.Period.getNumber().equals(dimNumber)) continue;
                            if (memberKey.length() > 0) {
                                memberKey.append(",");
                            }
                            memberKey.append(oneMemberMap.get(dimNumber));
                        }
                        if (subDataMap.containsKey(memberKey.toString())) {
                            oneData = (Map)subDataMap.get(memberKey.toString());
                        } else {
                            oneData = Maps.newHashMap();
                            subDataMap.put(memberKey.toString(), oneData);
                            subDatas.add(oneData);
                            itemNumbers = new String[itemDimNumber.size()];
                            itemNames = new String[itemDimNumber.size()];
                            item.setLength(0);
                            String accName = null;
                            for (int i = 0; i < itemDimNumber.size(); ++i) {
                                member = oneMemberMap.get(itemDimNumber.get(i));
                                itemNumbers[i] = member == null ? "" : member.getNumber();
                                String string = itemNames[i] = member == null ? "" : member.getName();
                                if (member == null) continue;
                                if (SysDimensionEnum.Account.getNumber().equals(itemDimNumber.get(i))) {
                                    accName = member.getName();
                                    continue;
                                }
                                if (item.length() > 0) {
                                    item.append("_");
                                }
                                item.append(member.getName());
                            }
                            if (accName != null) {
                                if (item.length() > 0) {
                                    item.append("_");
                                }
                                item.append(accName);
                            }
                            if (oneMemberMap.get(SysDimensionEnum.Metric.getNumber()) != null) {
                                metricid = oneMemberMap.get(SysDimensionEnum.Metric.getNumber()).getId();
                            }
                            oneData.put("item", (BigDecimal)((Object)item.toString()));
                            oneData.put("itemnumber", (BigDecimal)itemNumbers);
                            if (isNeedName) {
                                oneData.put("itemname", (BigDecimal)itemNames);
                            }
                            if (!isMob) {
                                oneData.put("dimname", (BigDecimal)((Object)itemDimName));
                            }
                            oneData.put("need_unit", (BigDecimal)((Object)Boolean.valueOf(needUnitIds.contains(metricid))));
                        }
                        boolean isleaf = true;
                        if (oneMemberMap.get(SysDimensionEnum.Period.getNumber()) != null) {
                            isleaf = !ControlWarningRule.checkIsYear(oneMemberMap.get(SysDimensionEnum.Period.getNumber()).getNumber());
                        } else if (oneMemberMap.get(SysDimensionEnum.BudgetPeriod.getNumber()) != null) {
                            isleaf = !ControlWarningRule.checkIsYear(oneMemberMap.get(SysDimensionEnum.BudgetPeriod.getNumber()).getNumber());
                        }
                        for (DynamicObject warnValue : warnEntry.getDynamicObjectCollection("subentryentity")) {
                            String type = warnValue.getString("type") + (isleaf ? "" : "total");
                            oneData.put(type.toLowerCase(), warnValue.getBigDecimal("value"));
                        }
                    }
                }
            }
            Collections.sort(subDatas, new ControlWarnDataCompartor());
            warnDatas.addAll(subDatas);
        }
        return warnDatas;
    }
}

