/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.warning;

import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogSignHelper;

public class ControlWarningMemberCheckHelper {
    private static final Log log = LogFactory.getLog(ControlWarningMemberCheckHelper.class);

    public static void checkMember(Double usePercent) {
        ControlWarningMemberCheckHelper.checkMember(usePercent, true);
    }

    public static void checkMember(Double usePercent, boolean isCheckusePercent) {
        block7: {
            try {
                if (usePercent == null || isCheckusePercent && usePercent < 0.6) {
                    return;
                }
                long free = Runtime.getRuntime().freeMemory();
                long total = Runtime.getRuntime().totalMemory();
                long max = Runtime.getRuntime().maxMemory();
                double useP = (double)(total - free) / (double)max;
                log.info("budget-control-warning-log : free=" + free + ";total=" + total + ";max=" + max + ";usePercent=" + useP);
                if (!(useP > usePercent)) break block7;
                log.info("budget-control-warning-log : start gc");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    log.info("budget-control-warning-log : Thread-sleep" + e);
                }
                free = Runtime.getRuntime().freeMemory();
                total = Runtime.getRuntime().totalMemory();
                max = Runtime.getRuntime().maxMemory();
                useP = (double)(total - free) / (double)max;
                log.info("budget-control-warning-log :  after gc free=" + free + ";total=" + total + ";max=" + max + ";usePercent=" + useP);
                if (useP > usePercent) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5185\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u652f\u6301\u6307\u5b9a\u7684\u64cd\u4f5c\u3002", (String)"ControlWarningMemberCheckHelper_1", (String)"epm-eb-business", (Object[])new Object[0]));
                }
            }
            catch (KDBizException e) {
                throw e;
            }
            catch (Throwable e) {
                log.info("budget-control-warning-log : ControlWarningMemberCheckHelper-exception" + e);
            }
        }
    }

    public static Double getCheckMemberPercent() {
        try {
            Set percent = LogSignHelper.getLogSignByGropNum((String)"ControlWaringCheckMember");
            log.info("budget-control-warning-log : ControlWarningMemberCheckHelper-getCheckMemberPercent" + JSONUtils.toString((Object)percent));
            if (percent != null && !percent.isEmpty()) {
                return Double.valueOf((String)percent.iterator().next());
            }
        }
        catch (Throwable ex) {
            log.info("budget-control-warning-log : ControlWarningMemberCheckHelper-getCheckMemberPercent" + ex);
        }
        return null;
    }
}

