/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.warning;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.utils.JSONUtils;

public class ControlWarningMemberNode
implements Serializable {
    private static final long serialVersionUID = -6937127871414469251L;
    private static final Log log = LogFactory.getLog(ControlWarningMemberNode.class);
    private String[] dimNumbers = null;
    private Map<String, ControlWarningMemberNode> childNode = Maps.newHashMap();

    private ControlWarningMemberNode() {
    }

    public static ControlWarningMemberNode createRoot(String[] dimNumbers) {
        ControlWarningMemberNode root = new ControlWarningMemberNode();
        root.dimNumbers = dimNumbers;
        return root;
    }

    public String[] getDimNumbers() {
        return this.dimNumbers;
    }

    public Map<String, ControlWarningMemberNode> getChildNode() {
        HashMap<String, ControlWarningMemberNode> clone = new HashMap<String, ControlWarningMemberNode>(this.childNode.size());
        for (Map.Entry<String, ControlWarningMemberNode> entry : this.childNode.entrySet()) {
            String key = entry.getKey();
            if (key == null) {
                key = "nullkey";
            }
            clone.put(key, entry.getValue());
        }
        return clone;
    }

    public void addMember(Map<String, Member> memberMap) {
        if (memberMap == null || memberMap.isEmpty()) {
            return;
        }
        ControlWarningMemberNode node = this;
        ControlWarningMemberNode thisNode = null;
        String number = null;
        for (String dimNumber : this.dimNumbers) {
            number = memberMap.get(dimNumber) == null ? null : memberMap.get(dimNumber).getNumber();
            thisNode = node.childNode.get(number);
            if (thisNode == null) {
                thisNode = new ControlWarningMemberNode();
                node.childNode.put(number, thisNode);
            }
            node = thisNode;
        }
    }

    public boolean hasMember(Map<String, String> memberMap) {
        ControlWarningMemberNode node = this;
        String number = null;
        for (String dimNumber : this.dimNumbers) {
            number = memberMap.get(dimNumber);
            node = node.childNode.get(number);
            if (node != null) continue;
            return false;
        }
        log.info("ControlWarningMemberNode.memberMap:" + JSONUtils.toString(memberMap));
        return true;
    }
}

