/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.warning;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.DataUnitEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.calc.eums.CalculatorTypeEnum;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.control.utils.BgPeriodUtils;
import kd.epm.eb.control.warning.ControlWarningHelper;
import kd.epm.eb.control.warning.ControlWarningScheme;

public class ControlWarningMessageCompilerHelper {
    private static final Log log = LogFactory.getLog(ControlWarningMessageCompilerHelper.class);

    public String getSingleMessage(DynamicObject warnObj) {
        DynamicObjectCollection warnCol = new DynamicObjectCollection();
        warnCol.add((Object)warnObj);
        return this.getMergeMessage(warnCol);
    }

    public String getMergeMessage(DynamicObjectCollection warnCol) {
        Map<String, Map<Long, DynamicObjectCollection>> warnMap = this.splitWarnMap(warnCol);
        Map<String, Map<Long, List<Map<String, Member>>>> warnMemberMap = this.queryMemberMap(warnMap);
        HashSet ids = Sets.newHashSet();
        warnMemberMap.values().forEach(f -> ids.addAll(f.keySet()));
        Map<Long, ControlWarningScheme> schemeMap = ControlWarningHelper.queryWarningScheme(ids);
        return this.buildMessage(warnMap, warnMemberMap, schemeMap);
    }

    private String buildMessage(Map<String, Map<Long, DynamicObjectCollection>> warnMap, Map<String, Map<Long, List<Map<String, Member>>>> warnMemberMap, Map<Long, ControlWarningScheme> schemeMap) {
        LinkedHashSet<String> message = new LinkedHashSet<String>(16);
        if (warnMap == null || warnMap.isEmpty() || warnMemberMap == null || warnMemberMap.isEmpty() || schemeMap == null || schemeMap.isEmpty()) {
            return message.toString();
        }
        Long modelid = null;
        Long bussmodelid = null;
        IModelCacheHelper cachehelper = null;
        Map<Long, List<Map<String, Member>>> subWarnMemberMap = null;
        List<Map<String, Member>> subWarnMemberList = null;
        ControlWarningScheme warnScheme = null;
        Map<String, Member> members = null;
        HashMap backMembers = Maps.newHashMap();
        Map<String, BigDecimal> values = null;
        StringBuilder memberLog = new StringBuilder();
        HashMap userDefRoot = Maps.newHashMap();
        HashSet<Long> needUnitIds = new HashSet<Long>(16);
        for (Map.Entry<String, Map<Long, DynamicObjectCollection>> entry : warnMap.entrySet()) {
            modelid = this.getModelId(entry.getKey());
            needUnitIds.add(modelid);
        }
        QFilter qf = new QFilter("model", "in", needUnitIds);
        qf.and("datatype", "in", (Object)Sets.newHashSet((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex()}));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMetric", (String)"epm_metricmembertree", (String)"id", (QFilter[])qf.toArray(), null);){
            needUnitIds.clear();
            ds.forEach(f -> needUnitIds.add(f.getLong("id")));
        }
        for (Map.Entry<String, Map<Long, DynamicObjectCollection>> entry : warnMap.entrySet()) {
            List dimensions;
            modelid = this.getModelId(entry.getKey());
            bussmodelid = this.getBussModelId(entry.getKey());
            subWarnMemberMap = warnMemberMap.get(entry.getKey());
            if (subWarnMemberMap == null || subWarnMemberMap.isEmpty()) {
                log.info("budget-control-warning-log : subWarnMemberMap-empty " + entry.getKey());
                continue;
            }
            userDefRoot.clear();
            cachehelper = ModelCacheContext.getOrCreate((Long)modelid);
            List list = dimensions = IDUtils.isNull((Long)bussmodelid) ? cachehelper.getDimensionList() : cachehelper.getDimensionListByBusModel(bussmodelid);
            if (dimensions != null) {
                for (Dimension dimension : dimensions) {
                    if (!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) continue;
                    userDefRoot.put(dimension.getNumber(), cachehelper.getMemberByAnyView(bussmodelid, dimension.getNumber(), dimension.getNumber()));
                }
            }
            for (Map.Entry entry2 : entry.getValue().entrySet()) {
                warnScheme = schemeMap.get(entry2.getKey());
                if (warnScheme == null) {
                    log.info("budget-control-warning-log : warnScheme-empty " + entry2.getKey());
                    continue;
                }
                subWarnMemberList = subWarnMemberMap.get(entry2.getKey());
                if (subWarnMemberList == null || subWarnMemberList.isEmpty()) {
                    log.info("budget-control-warning-log : subWarnMemberMap1-empty " + entry2.getKey());
                    continue;
                }
                Format format = BgControlUtils.setDecimalFormatPrecision(BgControlUtils.getDecimalFormatByInternetSet(), warnScheme.getPrecision());
                Format formatRate = BgControlUtils.setDecimalFormatPrecision(new DecimalFormat("#,##0.00%"), warnScheme.getPrecision());
                DataUnitEnum unit = warnScheme.getUnit();
                BigDecimal unitValue = new BigDecimal(unit.getValue());
                int index = 0;
                block13: for (DynamicObject warnObj : (DynamicObjectCollection)entry2.getValue()) {
                    DynamicObjectCollection warnEntry = warnObj.getDynamicObjectCollection("entryentity");
                    for (int i = 0; i < warnEntry.size(); ++i) {
                        if (index > subWarnMemberList.size() - 1) {
                            log.info("budget-control-warning-log : subWarnMemberList-empty " + i);
                            continue block13;
                        }
                        members = subWarnMemberList.get(index);
                        Member period = members.get(SysDimensionEnum.BudgetPeriod.getNumber());
                        if (period == null) {
                            period = members.get(SysDimensionEnum.Period.getNumber());
                        }
                        if (period == null || !period.isLeaf()) continue;
                        ++index;
                        values = ControlWarningHelper.getValues((DynamicObject)warnEntry.get(i));
                        String _message = warnScheme.getMessageRule();
                        if (!StringUtils.isNotEmpty((String)_message)) continue;
                        memberLog.setLength(0);
                        backMembers.clear();
                        backMembers.putAll(userDefRoot);
                        backMembers.putAll(members);
                        for (Map.Entry entryMember : backMembers.entrySet()) {
                            if (members.containsKey(entryMember.getKey())) {
                                if (memberLog.length() > 0) {
                                    memberLog.append(",");
                                }
                                memberLog.append((String)entryMember.getKey()).append("=").append(((Member)entryMember.getValue()).getNumber());
                            }
                            _message = this.replaceMessage(_message, (String)entryMember.getKey() + ".number", ((Member)entryMember.getValue()).getNumber());
                            _message = this.replaceMessage(_message, (String)entryMember.getKey() + ".name", ((Member)entryMember.getValue()).getName());
                        }
                        log.info("budget-control-warning-log : entryMember " + memberLog);
                        for (String type : warnScheme.getRule().getCalcTypes()) {
                            BigDecimal value = values.get(type);
                            if (value == null) {
                                value = BigDecimal.ZERO;
                            }
                            String stringValue = null;
                            if (CalculatorTypeEnum.RATE.getNumber().equals(type) || CalculatorTypeEnum.RATE_OLD.getNumber().equals(type)) {
                                stringValue = formatRate.format(value);
                            } else {
                                if (value != null && needUnitIds.contains(((DynamicObject)warnEntry.get(i)).getLong("metric"))) {
                                    value = value.divide(unitValue, 4);
                                }
                                stringValue = format.format(value);
                            }
                            _message = this.replaceMessage(_message, type, stringValue);
                        }
                        message.add(_message);
                    }
                }
            }
        }
        return StringUtils.join(message, (String)"\r\n");
    }

    private String replaceMessage(String _message, String keyword, String value) {
        if (value == null) {
            value = "";
        }
        keyword = "\\{" + keyword + "\\}";
        return _message.replaceAll(keyword, value);
    }

    public Map<String, Map<Long, List<Map<String, Member>>>> queryMemberMap(Map<String, Map<Long, DynamicObjectCollection>> warnMap) {
        HashMap<String, Map<Long, List<Map<String, Member>>>> memberMap = new HashMap<String, Map<Long, List<Map<String, Member>>>>(16);
        HashMap wMemberMap = null;
        ArrayList<Map<String, Member>> wMemberList = null;
        if (warnMap == null || warnMap.isEmpty()) {
            return memberMap;
        }
        IModelCacheHelper cachehelper = null;
        Long modelId = null;
        Long bussmodelid = null;
        Set<String> fields = this.queryWarnFields();
        for (Map.Entry<String, Map<Long, DynamicObjectCollection>> entry : warnMap.entrySet()) {
            modelId = this.getModelId(entry.getKey());
            bussmodelid = this.getBussModelId(entry.getKey());
            cachehelper = ModelCacheContext.getOrCreate((Long)modelId);
            wMemberMap = new HashMap(16);
            memberMap.put(entry.getKey(), wMemberMap);
            for (Map.Entry<Long, DynamicObjectCollection> warnEntry : entry.getValue().entrySet()) {
                wMemberList = new ArrayList<Map<String, Member>>(warnEntry.getValue().size());
                wMemberMap.put(warnEntry.getKey(), wMemberList);
                for (DynamicObject warnR : warnEntry.getValue()) {
                    for (DynamicObject warnObj : warnR.getDynamicObjectCollection("entryentity")) {
                        wMemberList.add(this.queryMember(warnObj, cachehelper, bussmodelid, fields));
                    }
                }
            }
        }
        return memberMap;
    }

    private Set<String> queryWarnFields() {
        HashSet fields = Sets.newHashSet();
        DynamicObject report = BusinessDataServiceHelper.newDynamicObject((String)"bgc_warningreport");
        DynamicObject newLine = report.getDynamicObjectCollection("entryentity").addNew();
        for (IDataEntityProperty prop : newLine.getDataEntityType().getProperties()) {
            fields.add(prop.getName());
        }
        return fields;
    }

    private Map<String, Member> queryMember(DynamicObject warnObj, IModelCacheHelper cachehelper, Long bussmodelid, Set<String> fields) {
        boolean isEb = cachehelper.getModelobj().isModelByEB();
        HashMap memberMap = Maps.newHashMap();
        if (fields == null || fields.isEmpty()) {
            return memberMap;
        }
        List dimensions = IDUtils.isNull((Long)bussmodelid) ? cachehelper.getDimensionList() : cachehelper.getDimensionListByBusModel(bussmodelid);
        String field = null;
        Long id = null;
        for (Object dimension : dimensions) {
            field = dimension.getNumber().toLowerCase();
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber())) {
                field = SysDimensionEnum.Period.getNumber().toLowerCase();
            }
            if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                field = "orgunit";
            }
            if (!fields.contains(field) || IDUtils.isNull((Long)(id = Long.valueOf(warnObj.getLong(field))))) continue;
            if (SysDimensionEnum.Year.getNumber().equals(dimension.getNumber())) {
                memberMap.put(dimension.getNumber(), dimension.getMember(Long.valueOf(0L), BgPeriodUtils.getPeriodYear((int)id.intValue())));
                continue;
            }
            memberMap.put(dimension.getNumber(), cachehelper.getMemberByAnyView(bussmodelid, dimension.getNumber(), id));
        }
        DynamicObjectCollection userDefs = warnObj.getDynamicObjectCollection("userdefineds");
        if (userDefs != null) {
            for (DynamicObject ud : userDefs) {
                id = ud.getLong("dimension");
                if (cachehelper.getDimension(id) == null) {
                    log.info("budget-control-warning-log : userDef-dimension-empty " + id);
                    continue;
                }
                memberMap.put(cachehelper.getDimension(id).getNumber(), cachehelper.getMemberByAnyView(bussmodelid, cachehelper.getDimension(id).getNumber(), Long.valueOf(ud.getLong("member"))));
            }
        }
        Iterator it = memberMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() != null) continue;
            log.info("budget-control-warning-log : dimension-empty " + (String)entry.getKey());
            it.remove();
        }
        return memberMap;
    }

    public Map<String, Map<Long, DynamicObjectCollection>> splitWarnMap(DynamicObjectCollection warnCol) {
        HashMap warnMap = Maps.newHashMap();
        Long modelId = null;
        Long bussModelId = null;
        Long warnschemeid = null;
        for (DynamicObject warn : warnCol) {
            modelId = warn.getLong("model");
            bussModelId = warn.getLong("bussmodel");
            warnschemeid = warn.getLong("warnscheme");
            warnMap.computeIfAbsent(this.getModelKey(modelId, bussModelId), f -> Maps.newHashMap()).computeIfAbsent(warnschemeid, f -> new DynamicObjectCollection()).add((Object)warn);
        }
        return warnMap;
    }

    private String getModelKey(Long modelId, Long bussModelId) {
        return modelId + "!" + bussModelId;
    }

    public Long getModelId(String key) {
        return Long.parseLong(key.split("!")[0]);
    }

    public Long getBussModelId(String key) {
        return Long.parseLong(key.split("!")[1]);
    }
}

