/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.warning;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.convert.Convert;
import org.jetbrains.annotations.NotNull;

public class ControlWarningReceiver {
    private static final Log log = LogFactory.getLog(ControlWarningReceiver.class);
    public static final String RECEIVER_DEFAULT = "default";
    public static final String RECEIVER_ADMIN = "admin";
    public static final String RECEIVER_BUDGET = "budget";
    public static final String[] RECEIVERS = new String[]{"budget", "admin", "default"};
    private Map<String, Map<Long, Set<Long>>> receiverMap = Maps.newHashMap();

    public ControlWarningReceiver(Map<String, Object> recObject) {
        if (recObject == null || Boolean.TRUE.equals(Convert.toBool((Object)recObject.get("fisdefault")))) {
            this.receiverMap.put(RECEIVER_DEFAULT, Maps.newHashMap());
        }
    }

    protected void buildReciever(Map<String, Object> entry) {
        if (entry == null || entry.get("fstatus") == null || !Convert.toBool((Object)entry.get("fstatus")).booleanValue()) {
            return;
        }
        String type = this.getType(entry);
        Set userIds = this.receiverMap.computeIfAbsent(type, f -> Maps.newHashMap()).computeIfAbsent(IDUtils.toLong((Object)entry.get("forg")), f -> Sets.newHashSet());
        userIds.add(IDUtils.toLong((Object)entry.get("fbasedataid")));
    }

    public void receiver(Long bgorgunitid, Map<String, List<Long>> receivers, String type, @NotNull Map<Long, Set<Long>> bailOrgMap, @NotNull Map<Long, Set<Long>> orgPesonMap) {
        if (IDUtils.isNull((Long)bgorgunitid)) {
            log.info("budget-control-warning-log : orgunit-id-is-null = " + bgorgunitid);
        } else if (this.receiverMap.get(type) == null) {
            log.info("budget-control-warning-log : receiverMap.get(type)-is-null = " + type);
        } else if (RECEIVER_BUDGET.equals(type)) {
            if (this.receiverMap.get(type).get(bgorgunitid) == null) {
                log.info("budget-control-warning-log : receiverMap.get(type).get(bgorgunitid)-is-null = " + bgorgunitid);
            } else {
                receivers.computeIfAbsent(type, f -> Lists.newArrayList()).addAll((Collection)this.receiverMap.get(type).get(bgorgunitid));
            }
        } else {
            Set<Long> orgIds = bailOrgMap.get(bgorgunitid);
            if (orgIds != null && !orgIds.isEmpty()) {
                for (Long orgId : orgIds) {
                    if (RECEIVER_ADMIN.equals(type)) {
                        if (this.receiverMap.get(type).get(orgId) == null) continue;
                        receivers.computeIfAbsent(type, f -> Lists.newArrayList()).addAll((Collection)this.receiverMap.get(type).get(orgId));
                        continue;
                    }
                    if (!RECEIVER_DEFAULT.equals(type) || orgPesonMap.get(orgId) == null || orgPesonMap.get(orgId).isEmpty()) continue;
                    receivers.computeIfAbsent(type, f -> Lists.newArrayList()).addAll((Collection)orgPesonMap.get(orgId));
                }
            } else {
                log.info("budget-control-warning-log : bailOrgMap-is-null = " + bgorgunitid);
            }
        }
    }

    public Set<String> getTypes() {
        return this.receiverMap.keySet();
    }

    private String getType(Map<String, Object> recEntry) {
        if (recEntry != null && "bos_adminorg".equals(recEntry.get("forgtypeitem"))) {
            return RECEIVER_ADMIN;
        }
        return RECEIVER_BUDGET;
    }
}

