/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.warning;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.control.ConditionUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.calc.eums.CalculatorTypeEnum;
import kd.epm.eb.control.calc.face.Calculator;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.utils.BgControlLogUtils;
import kd.epm.eb.control.utils.BgPeriodUtils;
import kd.epm.eb.control.warning.ControlWarningConstant;

public class ControlWarningRule {
    private static final Log log = LogFactory.getLog(ControlWarningRule.class);
    public static final String SEND_DEFAULT = "default";
    public static final String SEND_YEAR = "year";
    private boolean hasTimePlan = false;
    private QFilter filter = null;
    private String sendType = "default";
    private Set<String> calcTypes = new HashSet<String>();

    public boolean isQueryBalance() {
        return true;
    }

    public boolean isQueryControlSet() {
        return true;
    }

    public void setCondition(String condition) {
        log.info("budget-control-warning-log : condition = " + condition);
        try {
            FilterCondition filterConditiond = (FilterCondition)SerializationUtils.fromJsonString((String)condition, FilterCondition.class);
            if (filterConditiond != null && filterConditiond.getFilterRow() != null) {
                for (SimpleFilterRow filterRow : filterConditiond.getFilterRow()) {
                    if (!"rate.time_plan".equals(filterRow.getFieldName()) || filterRow.getBaseDataIds() == null) continue;
                    for (int i = 0; i < filterRow.getBaseDataIds().size(); ++i) {
                        if (i > filterRow.getValue().size() - 1 || !String.valueOf(ControlWarningConstant.TIME_PLAN_ID).equals(String.valueOf(((FilterValue)filterRow.getBaseDataIds().get(i)).getValue()))) continue;
                        ((FilterValue)filterRow.getValue().get(i)).setValue((Object)CalculatorTypeEnum.TIME_PLAN.getNumber());
                    }
                }
            }
            FilterBuilder filterBuilder = ConditionUtils.get().getFilterBuilder("bgc_warningrulecondition", filterConditiond);
            QFilter qFilter = filterBuilder.getFilterObject().getFilterResult().getQFilter();
            try {
                this.hasTimePlan = ControlWarningRule.convertToNumber(qFilter, null);
            }
            catch (Throwable ex) {
                log.warn("condition parse error:" + condition);
                log.warn("condition parse error:" + ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u9884\u8b66\u89c4\u5219\u6761\u4ef6\u9519\u8bef\u3002", (String)"ControlWarningRule_1", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            this.filter = qFilter;
        }
        catch (Throwable ex) {
            log.warn("condition parse error:" + condition);
            log.warn("condition parse error:" + ex);
        }
    }

    public static boolean convertToNumber(QFilter filter, BigDecimal timeplan) {
        if (filter == null) {
            return false;
        }
        boolean hasTimePlan = false;
        if (filter.getValue() != null && !(filter.getValue() instanceof BigDecimal)) {
            if ("rate.time_plan".equals(filter.getProperty()) && CalculatorTypeEnum.TIME_PLAN.getNumber().equals(filter.getValue())) {
                if (timeplan != null) {
                    filter.__setValue((Object)timeplan);
                }
                hasTimePlan = true;
            } else if (filter.getValue() != null && !(filter.getValue() instanceof QEmptyValue)) {
                if ("".equals(filter.getValue()) || " ".equals(filter.getValue())) {
                    filter.__setValue(null);
                    filter.__setCP("is not null");
                } else {
                    filter.__setValue((Object)Convert.toBigDecimal((Object)filter.getValue()));
                }
            }
        }
        if (filter.getNests(true) != null) {
            for (QFilter.QFilterNest nest : filter.getNests(true)) {
                hasTimePlan = ControlWarningRule.convertToNumber(nest.getFilter(), timeplan) || hasTimePlan;
            }
        }
        return hasTimePlan;
    }

    public QFilter getFilter() {
        return this.filter;
    }

    public void setSendType(String sendType) {
        if ("0".equals(sendType)) {
            this.sendType = SEND_YEAR;
        }
    }

    public String getSendTime() {
        if (SEND_YEAR.equals(this.sendType)) {
            return BgPeriodUtils.getPeriodYear((int)new CalendarHelper().getCurrentlyYear());
        }
        return null;
    }

    public Set<String> getCalcTypes() {
        if (this.calcTypes.isEmpty()) {
            for (CalculatorTypeEnum type : CalculatorTypeEnum.getWaringTypes()) {
                this.calcTypes.add(type.getNumber());
            }
        }
        return this.calcTypes;
    }

    public void checkWarning(DynamicObjectCollection result, DynamicObject report, Collection<IBudgetBalance> balances) {
        boolean isLog = BgControlLogUtils.isNeedLog();
        if (result == null || balances == null || balances.isEmpty()) {
            return;
        }
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)report.getLong("model"));
        HashSet hasReports = Sets.newHashSetWithExpectedSize((int)balances.size());
        ArrayList totalBalances = Lists.newArrayListWithCapacity((int)balances.size());
        for (IBudgetBalance balance : balances) {
            if (balance == null || balance.getPeriod(true) == null) continue;
            String periodNumber = balance.getPeriod(true).getNumber();
            if (ControlWarningRule.checkIsYear(periodNumber)) {
                totalBalances.add(balance);
                continue;
            }
            if (!this.check(balance, isLog)) continue;
            this.buildWaringReport(report, balance, cacheHelper);
            hasReports.add(balance.getMemberKey(true, true, balance.getBizModel().getDimensions()));
        }
        for (IBudgetBalance balance : totalBalances) {
            if (balance == null || balance.getPeriod(true) == null || !hasReports.contains(balance.getMemberKey(true, true, balance.getBizModel().getDimensions()))) continue;
            this.buildWaringReport(report, balance, cacheHelper);
        }
    }

    public static boolean checkIsYear(String periodNumber) {
        return periodNumber == null || periodNumber.matches("FY[\\d]{4}") || periodNumber.equals("M_YearTotal");
    }

    private void buildWaringReport(DynamicObject report, IBudgetBalance balance, IModelCacheHelper cacheHelper) {
        DynamicObject newLine = report.getDynamicObjectCollection("entryentity").addNew();
        newLine.set("orgunit", (Object)this.getId(balance.getOrgUnit(true), SysDimensionEnum.Entity.getNumber(), cacheHelper, balance));
        newLine.set(SysDimensionEnum.Account.getNumber().toLowerCase(), (Object)this.getId(balance.getAccount(true), SysDimensionEnum.Account.getNumber(), cacheHelper, balance));
        newLine.set(SEND_YEAR, (Object)new CalendarHelper().getCurrentlyYear());
        newLine.set("period", (Object)this.getId(balance.getPeriod(true), balance.getBizModel().isEBByModel() ? SysDimensionEnum.Period.getNumber() : SysDimensionEnum.BudgetPeriod.getNumber(), cacheHelper, balance));
        newLine.set(SysDimensionEnum.Version.getNumber().toLowerCase(), (Object)this.getId(balance.getVersion(true), SysDimensionEnum.Version.getNumber(), cacheHelper, balance));
        newLine.set(SysDimensionEnum.Currency.getNumber().toLowerCase(), (Object)this.getId(balance.getCurrency(true), SysDimensionEnum.Currency.getNumber(), cacheHelper, balance));
        newLine.set(SysDimensionEnum.InternalCompany.getNumber().toLowerCase(), (Object)this.getId(balance.getMember(true, SysDimensionEnum.InternalCompany.getNumber()), SysDimensionEnum.InternalCompany.getNumber(), cacheHelper, balance));
        newLine.set(SysDimensionEnum.ChangeType.getNumber().toLowerCase(), (Object)this.getId(balance.getChangeType(true), SysDimensionEnum.ChangeType.getNumber(), cacheHelper, balance));
        newLine.set(SysDimensionEnum.DataType.getNumber().toLowerCase(), (Object)this.getId(balance.getMember(true, SysDimensionEnum.DataType.getNumber()), SysDimensionEnum.DataType.getNumber(), cacheHelper, balance));
        newLine.set(SysDimensionEnum.Metric.getNumber().toLowerCase(), (Object)this.getId(balance.getMetric(true), SysDimensionEnum.Metric.getNumber(), cacheHelper, balance));
        newLine.set(SysDimensionEnum.AuditTrail.getNumber().toLowerCase(), (Object)this.getId(balance.getAuditTrail(true), SysDimensionEnum.AuditTrail.getNumber(), cacheHelper, balance));
        Member m = null;
        if (balance.getQueryUserDefDims() != null) {
            for (String dim : balance.getQueryUserDefDims()) {
                m = balance.getMember(true, dim);
                if (m == null) continue;
                DynamicObject uo = newLine.getDynamicObjectCollection("userdefineds").addNew();
                uo.set("dimension", (Object)cacheHelper.getDimension(dim).getId());
                uo.set("member", (Object)this.getId(m, dim, cacheHelper, balance));
            }
        }
        DynamicObject value = null;
        for (String type : this.getCalcTypes()) {
            Object calcvalue = Calculator.calc(balance, type);
            if (calcvalue == null) continue;
            value = newLine.getDynamicObjectCollection("subentryentity").addNew();
            value.set("type", (Object)type);
            value.set("value", calcvalue);
        }
    }

    private Long getId(Member member, String dimNumber, IModelCacheHelper cacheHelper, IBudgetBalance balance) {
        if (member == null) {
            return 0L;
        }
        if (IDUtils.isNotNull((Long)member.getId())) {
            return member.getId();
        }
        Long busModelId = balance.getBizModel().getControlBusModelId();
        Long viewId = cacheHelper.getViewByBusModelAndDimNumber(busModelId, dimNumber);
        kd.epm.eb.common.cache.impl.Member m = cacheHelper.getMember(dimNumber, viewId, member.getNumber());
        if (m == null) {
            log.info("budget-control-warning-log : not-found-member dimension number = " + dimNumber + " number = " + member.getNumber() + "viewId=" + viewId);
            return 0L;
        }
        return m.getId();
    }

    private boolean check(IBudgetBalance balance, boolean isLog) {
        if (balance == null || balance.getBizModel() == null) {
            return false;
        }
        if (this.getFilter() == null) {
            return true;
        }
        QFilter thisFilter = this.getFilter();
        HashMap<String, Object> values = new HashMap<String, Object>(10);
        Object value = null;
        for (String type : this.getCalcTypes()) {
            value = Calculator.calc(balance, type);
            if (CalculatorTypeEnum.RATE.getNumber().equalsIgnoreCase(type)) {
                type = "rate.time_plan";
            }
            values.put(type.toLowerCase(), value);
        }
        if (this.hasTimePlan) {
            thisFilter = thisFilter.copy();
            BigDecimal timeplan = (BigDecimal)Calculator.calc(balance, CalculatorTypeEnum.TIME_PLAN.getNumber());
            if (timeplan == null) {
                BgControlLogUtils.info(log, isLog, "budget-control-warning-log :  timeplan-is-empty");
                timeplan = BigDecimal.ZERO;
            }
            ControlWarningRule.convertToNumber(thisFilter, timeplan);
        }
        BgControlLogUtils.info(log, isLog, "budget-control-warning-log :  ControlWarningRule-balance = " + JSONUtils.toString(balance.toMap()));
        BgControlLogUtils.info(log, isLog, "budget-control-warning-log :  ControlWarningRule-values = " + JSONUtils.toString(values));
        ConditionUtils utils = ConditionUtils.get();
        ConditionUtils.QFilterEvaluator evaluator = new ConditionUtils.QFilterEvaluator();
        evaluator.setValues(values);
        return utils.run(thisFilter, evaluator);
    }
}

