/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.control.warning;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.DataUnitEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.control.warning.ControlWarningReceiver;
import kd.epm.eb.control.warning.ControlWarningRule;
import kd.epm.eb.control.warning.ControlWarningSchemeEntry;

public class ControlWarningScheme {
    private Map<String, Object> schemeData = null;
    private Long id = null;
    private DataUnitEnum unit = null;
    private Long modelId = null;
    private Long bussModelId = null;
    private Long warnningRuleId = null;
    private Set<Long> dimensionIds = Sets.newHashSet();
    private Map<Long, Integer> orgMap = Maps.newHashMap();
    private Map<Long, Integer> excludeOrgMap = Maps.newHashMap();
    private Map<Long, ControlWarningSchemeEntry> entrys = Maps.newHashMap();
    private String messageRule = null;
    private ControlWarningRule rule = new ControlWarningRule();
    private Map<String, List<ControlWarningReceiver>> receivers = Maps.newHashMap();

    public ControlWarningScheme(Map<String, Object> ms) {
        this.schemeData = ms;
    }

    public Long getId() {
        if (this.id == null) {
            this.id = IDUtils.toLong((Object)this.schemeData.get("fid"));
        }
        return this.id;
    }

    public String getNumber() {
        return String.valueOf(this.schemeData.get("fnumber"));
    }

    public DataUnitEnum getUnit() {
        if (this.unit == null) {
            int unitindex = Convert.toInt((Object)this.schemeData.get("funit"), (Integer)0);
            this.unit = DataUnitEnum.getEnumByIndex((int)unitindex);
            if (this.unit == null) {
                this.unit = DataUnitEnum.YUAN;
            }
        }
        return this.unit;
    }

    public int getPrecision() {
        return Convert.toInt((Object)this.schemeData.get("fprecision"), (Integer)2);
    }

    public Long getModelId() {
        if (this.modelId == null) {
            this.modelId = IDUtils.toLong((Object)this.schemeData.get("fmodel"));
        }
        return this.modelId;
    }

    public Long getBussModelId() {
        if (this.bussModelId == null) {
            this.bussModelId = IDUtils.toLong((Object)this.schemeData.get("fbusinessmodel"));
        }
        return this.bussModelId;
    }

    public Long getWarnningRuleId() {
        if (this.warnningRuleId == null) {
            this.warnningRuleId = IDUtils.toLong((Object)this.schemeData.get("fwarnningrule"));
        }
        return this.warnningRuleId;
    }

    public Long getModelKey() {
        return BizModel.getKey((Long)this.getModelId(), (Long)this.getBussModelId());
    }

    public Set<Long> getDimensionIds() {
        return this.dimensionIds;
    }

    public List<Long> getOrgIds() {
        if (this.orgMap.isEmpty()) {
            return Lists.newArrayList();
        }
        return new ArrayList<Long>(this.orgMap.keySet());
    }

    public void addOrgRange(Long org, Integer range, boolean isexclude) {
        if (isexclude) {
            this.excludeOrgMap.put(org, range);
        } else {
            this.orgMap.put(org, range);
        }
    }

    public void buildOrgIds() {
        IModelCacheHelper cachehelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (cachehelper == null) {
            return;
        }
        Dimension orgDim = cachehelper.getDimension(SysDimensionEnum.Entity.getNumber());
        LinkedHashSet<Long> orgIds = new LinkedHashSet<Long>(16);
        this.queryOrgIds(cachehelper, orgDim, this.orgMap, orgIds, this.getBussModelId());
        HashSet<Long> excludeOrgIds = new HashSet<Long>(16);
        this.queryOrgIds(cachehelper, orgDim, this.excludeOrgMap, excludeOrgIds, this.getBussModelId());
        this.orgMap.clear();
        this.excludeOrgMap.clear();
        for (Long orgId : orgIds) {
            if (excludeOrgIds.contains(orgId)) continue;
            this.addOrgRange(orgId, RangeEnum.ONLY.getIndex(), false);
        }
    }

    public void queryOrgIds(IModelCacheHelper cachehelper, Dimension orgDim, Map<Long, Integer> orgMap, Set<Long> orgIds, Long bussModelId) {
        Member m = null;
        List members = null;
        for (Map.Entry<Long, Integer> entry : orgMap.entrySet()) {
            m = cachehelper.getMemberByAnyView(bussModelId, SysDimensionEnum.Entity.getNumber(), entry.getKey());
            if (m == null || (members = cachehelper.getMemberByAnyView(SysDimensionEnum.Entity.getNumber(), bussModelId, m.getNumber(), entry.getValue().intValue())) == null) continue;
            members.forEach(f -> orgIds.add(f.getId()));
        }
    }

    public Map<Long, ControlWarningSchemeEntry> getEntrys() {
        return this.entrys;
    }

    public void addMember(Long entityId, Long dimensionid, Long memberid, Integer range) {
        ControlWarningSchemeEntry entry = this.getEntrys().computeIfAbsent(entityId, f -> new ControlWarningSchemeEntry());
        entry.getMemberMap().computeIfAbsent(dimensionid, f -> Lists.newArrayList()).add(memberid);
    }

    public String getMessageRule() {
        if (this.messageRule == null) {
            String langMsg = (String)this.schemeData.get("fwarnningmsglang");
            this.messageRule = StringUtils.isNotEmpty((String)langMsg) ? langMsg : (String)this.schemeData.get("fwarnningmsg");
        }
        return this.messageRule;
    }

    public ControlWarningRule getRule() {
        return this.rule;
    }

    public Map<String, List<ControlWarningReceiver>> getReceivers() {
        return this.receivers;
    }
}

