/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.model.serviceHelper;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.dataset.BizModelPreset;
import kd.epm.eb.common.enums.DataSetPresetDimEnum;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;

public class DataSetServiceHelper {
    public static void createDefault(DynamicObject model) {
        Long modelId = model.getLong("id");
        String rootId = String.valueOf(GlobalIdUtil.genGlobalLongId());
        LocaleString name = LanguageUtils.getLocaleValue((String)ResManager.loadKDString((String)"\u6570\u636e\u96c6", (String)"DataSetServiceHelper_0", (String)"epm-eb-business", (Object[])new Object[0]), (String)"DataSetServiceHelper_0", (String)"epm-eb-business");
        DataSetServiceHelper.createDefaultNode(modelId, rootId, "datasetroot", name, 0L);
        String defaultCatalog = String.valueOf(GlobalIdUtil.genGlobalLongId());
        name = LanguageUtils.getLocaleValue((String)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5206\u7c7b", (String)"DataSetServiceHelper_1", (String)"epm-eb-business", (Object[])new Object[0]), (String)"DataSetServiceHelper_1", (String)"epm-eb-business");
        DataSetServiceHelper.createDefaultNode(modelId, defaultCatalog, "default", name, Long.valueOf(rootId));
        String defaultDataSet = String.valueOf(GlobalIdUtil.genGlobalLongId());
        Long datasetId = Long.valueOf(defaultCatalog);
        name = LanguageUtils.getLocaleValue((String)ResManager.loadKDString((String)"\u9ed8\u8ba4\u6570\u636e\u96c6", (String)"DataSetServiceHelper_2", (String)"epm-eb-business", (Object[])new Object[0]), (String)"DataSetServiceHelper_2", (String)"epm-eb-business");
        DataSetServiceHelper.createDefaultDataSet(modelId, defaultDataSet, "default", name, datasetId);
    }

    public static DynamicObject loadDefault(Long modelId) {
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("number", "=", (Object)"default"));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"eb_dataset", (String)"id, name, number, businessmodel.id, entryentity.datasetdim", (QFilter[])builder.toArray());
    }

    public static Map<Object, DynamicObject> loadDatasets(Long modelId) {
        return DataSetServiceHelper.loadDatasets(modelId, "id, name, number");
    }

    public static Map<Object, DynamicObject> loadDatasets(Long modelId, String selectors) {
        if (modelId == null || modelId == 0L) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        return BusinessDataServiceHelper.loadFromCache((String)"eb_dataset", (String)selectors, (QFilter[])builder.toArray());
    }

    public static DynamicObject createDefaultNode(Long modelId, String nodeId, String number, LocaleString name, Long parent) {
        DynamicObject newGroup = BusinessDataServiceHelper.newDynamicObject((String)"eb_datasetcatalog");
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        newGroup.set("model", (Object)modelId);
        newGroup.set("id", (Object)nodeId);
        newGroup.set("number", (Object)number);
        newGroup.set("name", (Object)name);
        newGroup.set("creator", (Object)userId);
        newGroup.set("createtime", (Object)now);
        newGroup.set("modifier", (Object)userId);
        newGroup.set("modifytime", (Object)now);
        newGroup.set("parent", (Object)parent);
        if ("datasetroot".equals(number)) {
            newGroup.set("longname", (Object)"");
        } else {
            newGroup.set("longname", (Object)("." + parent.toString()));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newGroup});
        return newGroup;
    }

    public static DynamicObject createDefaultDataSet(Long modelId, String nodeId, String number, LocaleString name, Long catalog) {
        DynamicObject biz = BizModelPreset.queryByNumber(modelId.toString());
        DynamicObject newGroup = BusinessDataServiceHelper.newDynamicObject((String)"eb_dataset");
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        newGroup.set("model", (Object)modelId);
        newGroup.set("id", (Object)nodeId);
        newGroup.set("number", (Object)number);
        newGroup.set("name", (Object)name);
        newGroup.set("creator", (Object)userId);
        newGroup.set("createdate", (Object)now);
        newGroup.set("modifier", (Object)userId);
        newGroup.set("modifydate", (Object)now);
        newGroup.set("catalog", (Object)catalog);
        List dimArr = DataSetPresetDimEnum.getNumberExcludeAccount();
        if (NewEbAppUtil.isNewEbModel((Long)modelId)) {
            dimArr.add("InternalCompany");
        }
        String entity = "epm_dimension";
        String selects = "id,number,name";
        QFilter modelQf = new QFilter("model", "=", (Object)modelId);
        QFilter dimQf = new QFilter("number", "in", (Object)dimArr);
        DynamicObjectCollection dims = QueryServiceHelper.query((String)entity, (String)selects, (QFilter[])new QFilter[]{modelQf, dimQf});
        DynamicObjectCollection defaultDim = newGroup.getDynamicObjectCollection("entryentity");
        for (DynamicObject dim : dims) {
            DynamicObject d = new DynamicObject(defaultDim.getDynamicObjectType());
            d.set("datasetdim", (Object)dim.getLong("id"));
            defaultDim.add((Object)d);
        }
        newGroup.set("entryentity", (Object)defaultDim);
        if (biz != null) {
            newGroup.set("businessmodel", (Object)biz.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newGroup});
        return newGroup;
    }
}

