/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.model.serviceHelper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.DetailTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.log.BcmLogFactory;
import kd.epm.eb.common.log.WatchLogger;

public class DistributionDetailsSpreadLogic {
    protected static WatchLogger log;

    public DistributionDetailsSpreadLogic() {
        log = BcmLogFactory.getWatchLogInstance(this.getClass());
    }

    private List<QFilter> buildQueryAllChildFilter(String entity, Object entityid, Long modelid, Integer iDetail, boolean needQueryLongNumber, boolean needAddDelExchangeRatePlanFilter, boolean includeSelf) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (modelid != null) {
            filterList.add(new QFilter("model", "=", (Object)modelid));
        }
        if (needQueryLongNumber) {
            Object longNumber = this.getOrgMemLongNumber(entity, entityid);
            filterList.add(new QFilter("longnumber", "like", (Object)(longNumber + "!" + "%")));
        }
        if (needAddDelExchangeRatePlanFilter) {
            if ("epm_entitymembertree".equals(entity)) {
                filterList.add(new QFilter("isexchangerate", "=", (Object)false));
            } else if ("bcm_eb_versionmember".equals(entity)) {
                filterList.add(new QFilter("isactual", "!=", (Object)"1"));
            }
        }
        if (iDetail != null) {
            filterList.add(new QFilter("isleaf", "=", (Object)iDetail));
        }
        return filterList;
    }

    private Object getOrgMemLongNumber(String entity, Object entityid) {
        DynamicObject orgmen = BusinessDataServiceHelper.loadSingleFromCache((Object)entityid, (String)entity, (String)"longnumber");
        return orgmen != null ? orgmen.get("longnumber") : null;
    }

    private List<DynamicObject> queryAllChild(String entity, Long entityid, Long modelid, Integer iDetail) {
        List<QFilter> filters = this.buildQueryAllChildFilter(entity, entityid, modelid, iDetail, true, true, true);
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id,number,name, copyfrom", (QFilter[])filters.toArray(new QFilter[0])).values());
    }

    private List<DynamicObject> queryAllChild(String entity, Long entityid, Long modelid) {
        List<QFilter> filters = this.buildQueryAllChildFilter(entity, entityid, modelid, null, true, true, true);
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id,number,name,isleaf,copyfrom,parent,level,dseq", (QFilter[])filters.toArray(new QFilter[0]), (String)"dseq").values());
    }

    private List<QFilter> buildQueryDirectChild(String entity, Collection<?> entityIds, String parent, boolean needAddDelExchangeRatePlanFilter) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(16);
        if (parent != null) {
            filterList.add(new QFilter(parent, "in", entityIds));
        }
        if (needAddDelExchangeRatePlanFilter) {
            if ("epm_entitymembertree".equals(entity)) {
                filterList.add(new QFilter("isexchangerate", "=", (Object)false));
            } else if ("bcm_eb_versionmember".equals(entity)) {
                filterList.add(new QFilter("isactual", "!=", (Object)"1"));
            }
        }
        return filterList;
    }

    private List<DynamicObject> queryDirectChild(String entity, Long entityid, String parent) {
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id, number, name, isleaf, copyfrom", (QFilter[])this.buildQueryDirectChild(entity, Collections.singletonList(entityid), parent, true).toArray(new QFilter[0]), (String)"dseq").values());
    }

    private List<QFilter> buildQueryAllBrothersFilters(String entity, Collection<?> entityIds, Long modelid, String parent) {
        QFilter filter = new QFilter("id", "in", entityIds);
        HashSet<Object> parentIds = new HashSet<Object>();
        for (DynamicObject dyn : QueryServiceHelper.query((String)entity, (String)parent, (QFilter[])filter.toArray())) {
            parentIds.add(dyn.get(parent));
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filter = new QFilter("model", "=", (Object)modelid);
        filterList.add(filter);
        filterList.add(new QFilter(parent, "in", parentIds));
        filterList.add(new QFilter("number", "!=", (Object)SysDimensionEnum.Entity.getNumber()));
        return filterList;
    }

    private List<DynamicObject> queryAllBrothers(String entity, Long entityId, Long modelid, String parent) {
        return new ArrayList<DynamicObject>(BusinessDataServiceHelper.loadFromCache((String)entity, (String)"id, number, name, isleaf, copyfrom", (QFilter[])this.buildQueryAllBrothersFilters(entity, Collections.singletonList(entityId), modelid, parent).toArray(new QFilter[0]), (String)"dseq").values());
    }

    Set<Long> chooseMethodByRange(String entity, int value, Long entityid, Long modelid, String parent, DetailTypeEnum type) {
        HashSet<Long> templateSet = new HashSet<Long>();
        switch (value) {
            case 10: {
                if (this.isOrgRootMember(entityid, type)) break;
                templateSet.add(entityid);
                break;
            }
            case 20: {
                for (DynamicObject mem : this.queryDirectChild(entity, entityid, parent)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 30: {
                if (!this.isOrgRootMember(entityid, type)) {
                    templateSet.add(entityid);
                }
                for (DynamicObject mem : this.queryDirectChild(entity, entityid, parent)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 40: {
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 50: {
                if (!this.isOrgRootMember(entityid, type)) {
                    templateSet.add(entityid);
                }
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 60: {
                for (DynamicObject mem : this.queryAllBrothers(entity, entityid, modelid, parent)) {
                    templateSet.add(mem.getLong("id"));
                }
                templateSet.remove(entityid);
                break;
            }
            case 70: {
                for (DynamicObject mem : this.queryAllBrothers(entity, entityid, modelid, parent)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 90: {
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid, 1)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
            case 110: {
                if (!this.isOrgRootMember(entityid, type)) {
                    templateSet.add(entityid);
                }
                for (DynamicObject mem : this.queryAllChild(entity, entityid, modelid, 0)) {
                    templateSet.add(mem.getLong("id"));
                }
                break;
            }
        }
        return templateSet;
    }

    private boolean isOrgRootMember(Long entityid, DetailTypeEnum type) {
        if (DetailTypeEnum.TEMPLATEDIS == type) {
            QFilter filter = new QFilter("id", "=", (Object)entityid);
            QFilter filter2 = new QFilter("number", "=", (Object)SysDimensionEnum.Entity.getNumber());
            return QueryServiceHelper.exists((String)"epm_entitymembertree", (QFilter[])new QFilter[]{filter, filter2});
        }
        return false;
    }

    static class TreeNode {
        private String id;
        private TreeNode parent;
        private List<TreeNode> children = new ArrayList<TreeNode>();
        private DynamicObject data;

        public TreeNode(String id, DynamicObject dot) {
            this.id = id;
            this.data = dot;
        }

        public String getId() {
            return this.id;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public void setParent(TreeNode parent) {
            this.parent = parent;
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        public void addChild(TreeNode child) {
            this.children.add(child);
            child.setParent(this);
        }

        public DynamicObject getData() {
            return this.data;
        }
    }
}

